;******************************************************************
;***                              ***
;***  Lader fuer PEPS (EPROM-Emulator) Version: 1.0     ***
;***                              ***
;***                              ***
;***  letzte Aenderung am: 09.01.1985 ( Joachim Hanst )   ***
;***                              ***
;***                  (c) 1985 Conitec    ***
;***                              ***
;***                              ***
;***    20.01.2007 rekonstruiert vom PEPS-Handbuch              ***
;***    21.01.2007 Kommentare ergaenzt                          ***
;***               Wolfram Kurtz (DL8ZAQ)                       ***
;***                              ***
;******************************************************************
;
;
;
wboot  equ   0        ; warmstart
bdos  equ   5        ; bdos einsprung
fcb   equ   5ch       ; default file control block
defbuf equ   80h       ; ccp eingabe buffer
tpa   equ   100h      ; tpa anfang
bufl  equ   4000h      ; default buffer laenge
                ; (muss durch 256 teilbar sein)
    org   tpa       ;
                ;
begin  jmp   pastcon     ; Sprung zum Anfang
debug1 jmp   dbug1      ; Einsprung vom Debugger mit Eingabemoeglichkeit
debug2 jmp   dbug2      ; Einsprung vom Debugger default Werte
stop  jmp   wboot      ; Warmstart
    db   0,0,0,0     ; bringe (c) auf gerade Adresse
                ;
                ;
pprmt  db   10,13,'PEPS EPROM emulator version 1.0 '
    db   ' (c) copyright 1985 ,Conitec ',10,13,36
                ;
                ;
    db   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                ;
start  dw   4000h
laenge dw   bufl
                ;
    db   0,0,0,0,0,0,0,0,0,0,0
    db   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                ;
                ;
;-------------------------------------------------------------------------------
                ;
pout:              ; ausgabe routine an peps
                ; eingang: akku bit 0 = M0
                ;     akku bit 1 = M1
                ;     akku bit 2 = Data
                ;     akku bit 3 = Clock
                ;
                ; es darf kein register veraendert werden
                ;
                ; Standardmaessig gibt pout seine Daten
                ; ueber das VCP/M List Device. Es wird
                ; angenommen, dass es sich um eine Centronics
                ; Schnittstelle handelt. Busy ist am Stecker
                ; auf Low-pegel zu legen.
    push  psw       ;
    push  b        ;
    push  d        ;
    push  h        ;
    mvi   c,5       ; ausgabe an list device
    mov   e,a       ;
    call  bdos      ;
    pop   h        ;
    pop   d        ;
    pop   b        ;
    pop   psw       ;
    ret           ;
                ; platz fuer patch
    db   0
    db   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;
;
pinit:             ; diese routine dient dazu, den
                ; PEPS ausgabe port zu initialisieren
                ; falls keine initialisierung notwendig,
                ; dann einfach RET (C9 Hex) eintragen
                ;
                ; die register muessen nicht gerettet
                ; werden
                ;
    ret           ;
                ; platz fuer patch
    db   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;
;
;************************************************************************
;                                    *
;                                    *
; Der mit Sternen umrahmte Code stellt die eigentliche Ausgabe-     *
; Routine an den EPROM-Emulator dar.                  *
;                                    *
; LPEPS uebertraegt den RAM-Bereich, der bei der in START stehenden   *
; Adresse beginnt, zum PEPS. In Laenge muss die Anzahl der zu      *
; uebertragenden Bytes stehen.                     *
;                                    *
; LPEPS benoetigt einen 4 Bit breiten parallelen Ausgabe Port, deshalb *
; muessen die folgenden zwei Unterprogramme an die jeweilige      *
; Hardware angepasst werden:                      *
;                                    *
;    PINIT  Initialsierung des Ausgabeports (falls notwendig, sonst *
;        besteht dieses Unterprogramm lediglich aus einer    *
;        Return-Anweisung)                    *
;                                    *
;    POUT  Diese Routine gibt das im Akku stehende Byte an den   *
;        PEPS Ausgabe Port. Es darf kein Register veraendert   *
;        werden. Die Leitungen des Ausgabe Ports muessen     *
;        folgendermassen mit dem PEPS verbunden werden:     *
;        Bit 0 mit M0                      *
;        Bit 1 mit M1                      *
;        Bit 2 mit Data                     *
;        Bit 3 mit Clock                     *
;                                    *
;        Anmerkung: die Routine POUT wird sehr oft aufgerufen.  *
;        Die Zeit, die beoetigt wird um PEPS zu laden, haengt  *
;        deshalb entscheidend von der POUT Routine ab.      *
;        In den meisten Faellen wird POUT so aussehen:      *
;                                    *
;                OUT PEPSPORT              *
;                RET                   *
;                                    *
;        Bei einer 6 Mhz ZBO CPU dauert die Uebertragung von   *
;        16K Bytes dann etwa 4 Sekunden. Diese Zeit kann noch  *
;        auf etwa 2 Sekunden verkuerzt werden, wenn man alle   *
;        CALL POUT Aufrufe durch OUT PEPSPORT ersetzt.      *
;                                    *
;                                    *
LPEPS:             ;                    *
    CALL  PINIT      ; INITIALISIERE AUSGABE PORT      *
    MVI   A,00001011B   ; SETZE ADRESSZAEHLER AUF NULL     *
    CALL  POUT      ; LADE LAENGE NACH DE          *
    LHLD  LAENGE     ;                    *
    XCHG          ;                    *
    LHLD  START      ; LADE START-ADRESSE NACH HL      *
    MOV   A,D       ; WENN LAENGE NULL,           *
    ORA   E        ; DANN SOFORT ENDE           *
    RZ           ;                    *
LOOP  CALL  WRITEBYTE    ; SCHREIBE EIN BYTE EIN         *
    MVI   A,00001000B   ; PEPS ADRESSE EINS WEITER       *
    CALL  POUT      ;                    *
    INX   H        ; ZEIGER EINS WEITER          *
    DCX   D        ; ENDE ERREICHT ?            *
    MOV   A,D       ;                    *
    ORA   E        ;                    *
    JNZ   LOOP      ; DANN RETURN              *
                ;                    *
ENDE  MVI   A,00001011B   ; SETZE ADRESSZAEHLER AUF NULL     *
    CALL  POUT      ; UND GEHE IN SIMULIER-MODUS      *
    RET           ;                    *
                ;                    *
                ;                    *
WRITEBYTE:           ;                    *
                ; SCHREIBE (HL) IN PEPS EIN, HL UND DE *
                ; WERDEN NICHT VERAENDERT        *
                ;                    *
    MVI   B,8       ; 8 BIT                 *
    MOV   A,M       ; LADE BYTE               *
    CMA           ; KOMPLEMENT FUER 74LS540        *
    RLC           ; SCHIEBE BYTE RICHTIG         *
    RLC           ;                    *
    MOV   C,A       ;                    *
WRITEL MOV   A,C       ;                    *
    RLC           ;                    *
    MOV   C,A       ; RETTE IN C              *
    ANI   00000100B    ;                    *
    ORI   00001001B    ;                    *
    CALL  POUT      ;                    *
    ANI   00000111B    ;                    *
    CALL  POUT      ;                    *
    DCR   B        ;                    *
    JNZ   WRITEL     ;                    *
    MVI   A,00001010B   ;                    *
    CALL  POUT      ;                    *
    XRA   A        ;                    *
    CALL  POUT      ;                    *
    RET           ;                    *
;                                    *
;                                    *
;************************************************************************
;
;
;
dbug1:             ; ueber diesen einsprung kann man peps von ddt
                ; sid oder aehnlichen debuggern starten,
                ; default werte koennen neu gesetzt werden
    lxi   sp,stack    ;
    lxi   d,pprmt     ;
    call  pstring     ;
    call  getval     ;
    call  pepsout     ;
    rst   7        ;
;
;
dbug2:             ; wie dbugl, default werte werden jedoch
                ; ohne aenderungsmoeglichkeit uebernommen
    lxi   sp,stack    ;
    lxi   d,pprmt     ;
    call  pstring     ;
    call  pepsout     ;
    rst   7        ;
;
;
;
pastcon:            ; einsprung, wenn PEPS von ccp gestartet
                ; wurde
                ;
    lxi   sp,stack    ; setze stackpointer
    lxi   d,pprmt     ; PEPS-Meldung
    call  pstring     ;
                ;
    lda   defbuf     ; wurde Datei angegeben?
    ora   a        ;
    jnz   fileon     ; Sprung wenn Datei angegeben
                ;
    call  getval     ; Es wurde kein Dateiname angegeben
    call  pepsout     ;
    jmp   stop      ;
                ;
fileon:
    lxi   h,fcb+9     ; teste ob HEX-file
    lxi   d,blank     ;
    mvi   b,3       ;
    call  comp      ;
    jz   hexfile     ; extension = blank dann HEX-file
    lxi   h,fcb+9     ;
    lxi   d,hex      ;
    mvi   b,3       ;
    call  comp      ;
    jz   hexfile     ; extension = HEX dann ebenfalls HEX-file
                ;
    lxi   d,fcb      ; oeffne file
    call  open      ;
    inr   a        ; gefunden?
    jz   notfnd     ; Sprung, wenn nicht gefunden
    lxi   d,yesno     ;
    call  pstring     ;
    call  pfname     ;
    lxi   d,nohex     ;
    call  pstring     ;
    call  comread     ; lese non-hex-datei in buffer
    call  pepsout     ;
    jmp   stop      ;

hexfile:
    lxi   d,fcb+9     ; trage Extension HEX
    lxi   h,hex      ; in file control block ein
    lxi   b,3       ;
    call  ldir      ;
    lxi   d,fcb      ; oeffne file
    call  open      ;
    inr   a        ; gefunden?
    jz   notfnd     ; Sprung, wenn nicht gefunden
    lxi   d,yesno     ; Gebe Dateiname aus
    call  pstring     ;
    call  pfname     ;
    lxi   d,yeshex    ;
    call  pstring     ;
    call  hexread     ; lese hex-datei in buffer
    call  pepsout     ; gebe daten an PEPS
    jmp   stop      ;
;
;
;
hexread:
                ; lese hexdatei in buffer
                ; setze peps start adresse und laenge
                ;
    lxi   d,defbuf    ; defaultbuffer ist dma fuer hex datei
    call  setdma     ;
    lxi   h,defbuf+128  ; initialisiere HEXIN-Routine
    shld  hexzeig     ;
    xra   a        ;
    sta   fcb+32     ;
    sta   flag      ;
    sta   hflag      ;
    lxi   h,buffer    ;
    shld  hexend     ;
hexcon2 call  waitdop     ; warte auf doppelpunkt
    xra   a        ; loesche pruefsumme
    sta   psum      ;
    call  hbyte      ; lese laenge des records
    push  psw       ; rette laenge
    ora   a        ; null, dann ende
    jz   hrend      ;
    call  hadr      ; lese adresse
    lda   flag      ; berechne offset beim ersten record
    ora   a        ;
    cz   goff      ;
    xchg          ; addiere offset
    lhld  offset     ;
    dad   d        ;
    lxi   d,buffer    ; teste ob adresse unterhalb den buffers liegt
    xchg          ;
    call  hilo      ;
    xchg          ;
    jc   hexcon3     ; ok, aufzeichnung hoeher als buffer
    pop   psw       ; richte stack
    mvi   a,0ffh     ; setze flag
    sta   lflag      ;
    jmp   hexcon2     ; ueberspringe diese aufzeichnung
hexcon3 lxi   d,buffer+bufl-1 ; teste ob adresse oberhalb des buffers liegt
    call  hilo      ;
    jc   hexcon4     ; ok, aufzeichnungsanfang im buffer
    pop   psw       ; richte stack
    mvi   a,0ffh     ; setze flag
    sta   hflag      ;
    jmp   hexcon2     ; ueberspringe diese aufzeichnung
hexcon4 pop   psw       ; laenge zurueck
    mov   b,a       ; laenge in b
    call  hbyte      ; Type-Byte wird nicht ausgewertet
hloop  call  hbyte      ; lese byte
    mov   m,a       ; in tpa
    inx   h        ; eins weiter
    dcr   b        ;
    jnz   hloop      ;
    call  hbyte      ; lese pruefsumme
    lda   psum      ;
    ora   a        ; pruefsumme muss null sein
    jz   hexcon1     ; kein fehler, weiter
    lxi   d,cserr     ;
    call  pstring     ;
    jmp   stop      ;
hexcon1 xchg          ; trage groesste endadresse ein
    lhld  hexend     ;
    xchg          ;
    call  hilo      ;
    jc   hexcon2     ; alte adresse war groesser
    shld  hexend     ;
    jmp   hexcon2     ;
hrend:
    lxi   h,buffer    ; setze start adresse und laenge
    shld  start      ; fuer peps
    lhld  hexend     ;
    lxi   d,-buffer    ;
    dad   d        ;
    shld  laenge     ;
    lxi   d,bufl     ; teste ob zu lang
    call  hilo      ;
    jc   hrend4     ;
    mvi   a,0ffh     ;
    sta   hflag      ;
hrend4 lda   lflag      ; code in low buffer?
    ora   a        ;
    jz   hrend1     ;
    lxi   d,warn2     ; gebe warnung aus
    call  pstring     ;
hrend1 lda   hflag      ; code in high buffer?
    ora   a        ;
    jz   hrend2     ;
    lxi   d,warn2     ;
    call  pstring     ;
    lxi   h,bufl     ; buffer laenge dann maximal
    shld  laenge     ;
hrend2 pop   psw       ; richte stack
    ret           ;
                ;
                ;
goff:              ; addiere offset
    push  h        ;
    mov   a,h       ;
    cma           ;
    mov   h,a       ;
    mov   a,l       ;
    cma           ;
    mov   l,a       ;
    lxi   d,buffer    ;
    inx   h        ;
    dad   d        ;
    shld  offset     ;
    mvi   a,0ffh     ;
    sta   flag      ;
    pop   h        ;
    ret           ;
                ;
                ;
waitdop call  hexin      ; warte auf doppelpunkt
    cpi   ':'       ;
    jnz   waitdop     ;
    ret           ;
                ;
                ;
hbyte:             ; lese naechste zwei zeichen aus hexstrom
                ; und wandle in byte
                ; CP/M wenn kein hexzeichen
    push  b        ;
    call  hexin      ; lese erstes zeichen
    call  valdg      ; hexzeichen ?
    jnc   hexer      ; nein, fehler
    call  cnvbn      ;
    rlc           ;
    rlc           ;
    rlc           ;
    rlc           ;
    mov   b,a       ;
    call  hexin      ; lese zweites zeichen
    call  valdg      ; hexzeichen ?
    jnc   hexer      ; nein, fehler
    call  cnvbn      ;
    ora   b        ;
    mov   b,a       ; rette in b
    lda   psum      ; berechne pruefsumme
    add   d        ;
    sta   psum      ;
    mov   a,b       ;
    pop   b        ;
    ret           ;
                ;
                ;
hexer:             ;
    lxi   d,hexert    ;
    call  pstring     ;
    jmp   stop      ;
                ;
                ;
hadr:              ;
    call  hbyte      ;
    mov   h,a       ;
    call  hbyte      ;
    mov   l,a       ;
    ret           ;
                ;
                ;
comread:            ;
                ; lese non-hex-datei in buffer
                ; setze peps start-adresse und laenge
                ;
    lxi   h,buffer    ; setze dma adresse auf buffer anfang
    shld  dmaadr     ;
    shld  start      ; peps startadresse ist mit buffer identisch
    xchg          ;
    call  setdma     ;
    lxi   h,0       ; setze laenge auf null
    xra   a        ;
    sta   fcb+32     ; setze cr feld auf null
readcom:            ;
    lxi   d,fcb      ; lese 128 byte
    call  readseq     ;
    ora   a        ; lese
    jnz   rcom1      ; bis eof kommt
    lxi   d,128      ; oder bis buffer voll
    lhld  laenge     ;
    mvi   a,bufl/256   ;
    cmp   h        ;
    jz   rcom2      ; buffer voll, ende file lesen
    dad   d        ;
    shld  laenge     ;
    lhld  dmaadr     ; erhoehe dma adresse um 128 byte
    dad   d        ;
    shld  dmaadr     ;
    xchg          ;
    call  setdma     ;
    jmp   readcom     ;
rcom2:             ;
    lxi   d,warn1     ;
    call  pstring     ; gebe warnung aus
rcom1: ret           ;
                ;
                ;
getval:             ; lese startadresse und laenge ein
    lxi   d,etxt1     ;
    call  pstring     ;
    lhld  start      ;
    call  hlhex      ;
    lxi   d,etxt4     ;
    call  pstring     ;
    lhld  start      ;
    call  gethex     ;
    ora   a        ;
    jz   getval1     ; sprung wenn kein fehler
    lxi   d,etxt3     ;
    call  pstring     ;
    jmp   getval     ;
getval1 shld  start      ;
getval2 lxi   d,etxt2     ;
    call  pstring     ;
    lhld  laenge     ;
    call  hlhex      ;
    lxi   d,etxt4     ;
    call  pstring     ;
    lhld  laenge     ;
    call  gethex     ;
    ora   a        ;
    jz   getval3     ;
    lxi   d,etxt3     ;
    call  pstring     ;
    jmp   getval2     ;
getval3 shld  laenge     ;
    ret           ;
;                ;
;                ;
notfnd lxi   d,nftxt1    ; gebe Fehlermeldung
    call  pstring     ; fuer File nicht gefunden aus
    call  pfname     ; dann zurueck zum CP/M
    lxi   d,nftxt2    ;
    call  pstring     ;
    jmp   stop      ;
                ;
ldir:              ; simuliere z80 ldir befehl
    push  psw       ;
ldir1  mov   a, m      ;
    stax  d        ;
    inx   h        ;
    inx   d        ;
    dcx   b        ;
    mov   a, b      ;
    ora   c        ;
    jnz   ldir1      ;
    pop   psw       ;
    ret           ;
                ;
comp  ldax  d        ; vergleiche String (DE)
    cmp   m        ; mit Sting (HL)
    rnz           ; ungleich, return
    inx   h        ;
    inx   d        ;
    dcr   b        ; Laenge in B
    jnz   comp      ;
    ret           ;
                ;
hlhex:             ; gebe hl als vierstellige HEX-Zahl aus
    mov   a,h       ;
    call  nmout      ;
    mvi   a,1       ;
    jmp   nmout      ;
                ;
nmout:             ; gebe akku als hexzahl aus
    push  h        ;
    push  d        ;
    push  b        ;
    push  psw       ;
    rrc           ;
    rrc           ;
    rrc           ;
    rrc           ;
    call  prval      ;
    pop   psw       ;
    call  prval      ;
    pop   b        ;
    pop   d        ;
    pop   h        ;
    ret           ;
                ;
prval:             ;
    ori   0f0h      ; gebe untere 4 bits des akkus
    daa           ; als HEX-Zeichen auf konsolen-kanal
    adi   0a0h      ;
    aci   40h       ;
    mov   e,a       ;
    mvi   c,2       ;
    jmp   bdos      ;
                ;
                ;
pfname:             ; gebe filename in fcb auf Konsolenkanal aus
    mvi   a,':'      ; setze Doppelpunkt
    sta   pfeld+1     ;
    lda   fcb       ; setze Laufwerk
    adi   40h       ; wandle in Buchstaben
    sta   pfeld      ;
    lxi   d,fcb+1     ;
    lxi   h,pfeld+2    ; trage filename ein
    mvi   b,9       ;
pfn1  ldax  d        ;
    cpi   ' '       ;
    jz   pfn2      ;
    dcr   b        ;
    jz   pfn2      ;
    mov   m,a       ;
    inx   h        ;
    inx   d        ;
    jmp   pfn1      ;
pfn2  mvi   m,'.'      ; setze punkt
    inx   h        ;
    lxi   d,fcb+9     ; trage extension ein
    mvi   b,4       ;
pfn3  ldax  d        ;
    cpi   ' '       ;
    jz   pfn4      ;
    dcr   b        ;
    jz   pfn4      ;
    mov   m,a       ;
    inx   h        ;
    inx   d        ;
    jmp   pfn3      ;
pfn4  mvi   m,'$'      ;
    lxi   d,pfeld     ;
    lda   fcb       ; lw-Buchstabe ausgeben?
    ora   a        ;
    jnz   pfn5      ;
    inx   d        ;
    inx   d        ;
pfn5  jmp   pstring     ;
;                ;
;                ;
gethex:
                ; lese hexzahl von console
                ; eingang: hl mit default-wert
                ; ausgang: hl mit eingabe-wert
                ;      a=00 zahl gueltig
                ;      a=FF zahl ungueltig
                ;
    push h         ; rette default-wert
    mvi   a,13      ; initialisiere eingabe buffer
    sta   pfeld      ;
    mvi   c,10      ; read console buffer
    lxi   d,pfeld     ;
    call  bdos      ;
    pop   h        ; default-wert zurueck
    lda   pfeld+1     ; wurde nur cr eingegeben?
    ora   a        ;
    rz           ; dann return mit default-wert
    cpi   5        ; mehr als vier zeichen im buffer?
    mvi   a,0ffh     ; dann zurueck mit fehlermeldung
    rnc           ;
    lxi   h,pfeld+1    ; zeichen anzahl in b
    mov   b,m       ;
    inx   h        ;
    xchg          ; de zeigt auf erstes zeichen
    lxi   h,0       ; loesche hl
gethex1:dad   h        ; schiebe eine ziffer weiter
    dad   h        ;
    dad   h        ;
    dad   h        ;
    ldax  d        ; lese zeichen
    call  valdg      ; teste ob hexzeichen
    mvi   a,0ffh     ;
    rnc           ; nein, zurueck mit fehlermeldung
    ldax  d        ; lese zeichen erneut
    call  cnvbn      ; wandle in binaer-wert
    add   l        ; addiere zu hl
    mov   l,a       ; zurueck in l (Uebertrag in h nicht moeglich)
    inx   d        ;
    dcr   b        ; ende?
    jnz   gethex1     ; sprung wenn nein
    xra   a        ; kein fehler
    ret           ; zurueck
                ;
                ;
fret  stc           ;
    cmc           ;
    ret           ;
                ;
                ;
sret  stc           ;
    ret           ;
                ;
                ;
hilo:              ; vergleicht hl mit de
                ; ist de kleiner hl dann ist carry geloescht
    mov   a,d       ;
    cmp   h        ;
    jc   fret      ;
    jnz   sret      ;
    mov   a,e       ;
    cmp   l        ;
    jc   fret      ;
    jmp   sret      ;
                ;
                ;
valdg:             ; pruefe ob in a gueltige hex ziffer
    call  upper      ;
    cpi   '0'       ;
    jm   fret      ;
    cpi   '9'       ;
    jm   sret      ;
    jz   sret      ;
    cpi   'A'       ;
    jm   fret      ;
    cpi   'G'       ;
    jp   fret      ;
    jmp   sret      ;
                ;
                ;
cnvbn:             ; wandle hexziffer in a in binaer ziffer
    call  upper      ;
    sui   '0'       ;
    cpi   0ah       ;
    rm           ;
    sui   7        ;
    ret           ;
                ;
                ;
upper  cpi   'a'       ; wandle in grossbuchstaben
    rc           ;
    sui   'a'-'A'     ;
    ret           ;
                ;
                ;
hexin:             ; lese naechstes Zeichen aus hex-datei
                ; wenn kein Zeichen mehr kommt, dann
                ; gebe eine Warnung aus und simuliere
                ; Endaufzeichnung.
    push  h        ;
    push  d        ;
    push  b        ;
    lhld  hexzeig     ; teste, ob neuer record gelesen werden muss
    mvi   a,(defbuf+128) and 0ffh
    cmp   l        ;
    jnz   hexin1     ; ungleich, weiter
    mvi   a,((defbuf+128)/256) and 0ffh
    cmp   h        ;
    jnz   hexin1     ;
    lxi   h,defbuf    ; Setze Zeiger neu
    shld  hexzeig     ;
    lxi   d,fcb      ;
    call  readseq     ; lese neuen record
    ora   a        ; eof?
    jz   hexin1     ;
    lxi   d,hetxt     ; gebe warnung aus
    call  pstring     ;
    lxi   h,defbuf    ; setze endaufzeichnung in default buffer
    mvi   m,':'      ;
    mvi   b,127      ;
hexin2 inx   h        ;
    mvi   m,'0'      ;
    dcr   b        ;
    jnz   hexin2     ;
hexin1 lhld  hexzeig     ;
    mov   a,m       ;
    inx   h        ;
    shld  hexzeig     ;
    pop   b        ;
    pop   d        ;
    pop   h        ;
    ret           ;
;                ;
;                ;
pepsout lxi   d,ptxt1     ; lade PEPS
    call  pstring     ; gebe vorher Start Adresse
    lhld  start      ; und Laenge aus
    call  hlhex      ;
    lxi   d,ptxt2     ;
    call  pstring     ;
    lhld  laenge     ;
    call  hlhex      ;
    lxi   d,ptxt3     ;
    call  pstring     ;
    call  lpeps      ;
    ret           ;
;
;
pstring mvi   c,9
    jmp   bdos
;
;
open  mvi   c,15
    jmp   bdos
;
;
readseq mvi   c,20
    jmp   bdos
;
;
setdma mvi   c,26
    jmp   bdos
;
;
yesno  db   10,13,'loading $'
;
nohex  db   ' objekt file in TPA buffer',10,13,36
;
yeshex db   ' Intel HEX-file in TPA buffer',10,13,36
;
ptxt1  db   10,13
    db   10,13,' loading PEPS from TPA, start location: $'
ptxt2  db   10,13,' length: $'
ptxt3  db   10,13,36
;
etxt1  db   10,13,' enter start location (default = $'
etxt2  db   10,13,' enter lenght (default = $'
etxt3  db   10,13,'error, no valid hex number$'
etxt4  db   '): $'
;
nftxt1 db   7,10,13,'error, file $'
;
nftxt2 db   ' not found',10,13,36
;
hetxt  db   7,10,13,'warning, no end record in Intel HEX-file',10,13,36
;
hexert db   7,10,13,'error, wrong character in Intel HEX-file',10,13,36
;
cserr  db   7,10,13,'checksum error in Intel HEX-file',10,13,36
;
warn1  db   7,10,13,'warning, buffer overflow',10,13,36
;
warn2  db   7,10,13,'warning, data in lower buffer',10,13,36
;
blank  db   '    '
hex   db   'HEX'
;
pfeld  ds   15

dmaadr ds   2
hexzeig ds   2
hexend ds   2
flag  ds   1
lflag  ds   1
hflag  ds   1
offset ds   2
psum  ds   1
;
    ds   64
stack  equ   $

buffer equ   $
buffere equ   buffer+4000h

    end
