{ ========================================================================== }
{                                                                            }
{          Generator fuer Prommbare Files, fuer CONITEC Darmstadt            }
{          von Manfred Oheimer.                                              }
{                                                                            }
{          Modul enthaelt Hilfsfunktionen und Proceduren allgemeiner         }
{          Art.                                                              }
{                                                                            }
{          Letzte Aenderung : 27.11.86                                       }
{                                                                            }
{ ========================================================================== }




{ ************* Definition der COUNTER - Zugriffsfunktionen **************** }



procedure resetctr ( var CTR : integer );
begin
   CTR := 0;
end;

procedure incrementctr ( var CTR : integer );
begin
   CTR := CTR + 1 ;
end;

function getextnr ( CTR : integer ) : byte;
begin
   getextnr := (CTR - 1) div 128 ;
end;

function getrecctr ( CTR : integer ) : byte;
begin
   getrecctr := 1 + ((CTR - 1) mod 128 );
end;



{ ************ Ende der COUNTER - Zugriffsfunktionen  ********  }



procedure setdirandblksize;
begin
   EPRKAPINKBYTE:=EPROMSIZEINKBYTE * NREPROMS;
   if BLKSIZEINKB = 0 then
      begin
         case EPRKAPINKBYTE of
         1..96       : begin NRDIRENTR:=32  ; BLKSIZEINKB:=1 end;
         97..256     : begin NRDIRENTR:=64  ; BLKSIZEINKB:=1 end;
         257..512    : begin NRDIRENTR:=128 ; BLKSIZEINKB:=2 end;
         513..1024   : begin NRDIRENTR:=256 ; BLKSIZEINKB:=2 end;
         1025..2048  : begin NRDIRENTR:=512 ; BLKSIZEINKB:=2 end;
         else
            NRDIRENTR:=512 ; BLKSIZEINKB:=4
         end; {end-of-case }
      end { end-of-BLKSIZEINKB=0 }
    else; { BLKSIZEINKB<>0 }
end; { end-of-setdirandblksize }




procedure clearBUFFBLOCK;
var i: integer;
begin
   for i:=0 to 4095 do BUFFBLOCK[i]:=$FF;
end;




procedure makename(AKTNAME: string14);
var hilf                  : string[3];
    nr,errorcode          : integer;
begin
   hilf:=AKTNAME[5]+AKTNAME[6]+AKTNAME[7];
   VAL(hilf,nr,errorcode);
   if nr>64 then nr:=-1; { weil die Files mit DISI000.HXC anfangen muessen }
   if errorcode=0 then begin
                         AKTFILENR:=nr+1;
                         STR((nr+1):3,hilf);
                         NEWNAME:='DISI'+hilf+'.HXC';
                         case nr+1 of
                         0..9   : begin
                                   NEWNAME[5]:='0';NEWNAME[6]:='0';
                                  end;
                         10..99 : NEWNAME[5]:='0';
                         end;
                       end
                else writeln('Fehler in der MAKENAME-Funktion');
end;




procedure init;      { Setzt einige Systemvariablen }
begin
   if NREPROMS>64 then begin
                          writeln('Anzahl der EPROMs ist zu gross');
                          FATALERROR:=TRUE;
                       END;
   if NRDIRENTR>512 then begin
                          writeln('Anzahl der Direktory-Eintraege ist zu gross');
                          FATALERROR:=TRUE;
                       END;
   DIRENTRFREE:=NRDIRENTR;  { Anzahl der aktuell freien Dir-eintr. }
   if NRDIRENTR<1024 then begin
          DIRSIZEINKB:=(NRDIRENTR * 32) div 1024;  { absolute Dir-groesse }
          if ((NRDIRENTR * 32) mod 1024)<>0 then DIRSIZEINKB:=DIRSIZEINKB+1;
       end
      else begin
          DIRSIZEINKB:=((((NRDIRENTR div 2) * 32) div 1024) * 2);
          if (((NRDIRENTR div 2) * 32) mod 1024)<>0 then
              DIRSIZEINKB:=DIRSIZEINKB+2;
        end;
          { Diese Berechnung der Directory-Groesse ist nicht ganz richtig!!!! }

   FIRSTDATAFILENAME:='DISI000.HXC';        { damit <makename> bei 0 anfaengt }
   DIRFULL:=FALSE;
   RECSPROBLK:=BLKSIZEINKB*8;
   BLKPOINTERSIZE:= ((EPRKAPINKBYTE div BLKSIZEINKB) > 256);            { T/F }
   if ((BLKPOINTERSIZE)and(BLKSIZEINKB<2)) then begin
      writeln('Blockgroesse und DISK-Kapazitaet sind unvertraeglich');
      FATALERROR:=TRUE;
    end;
   DIRSIZEINBLK:=DIRSIZEINKB div BLKSIZEINKB;
   if ((DIRSIZEINKB mod BLKSIZEINKB)<>0) then DIRSIZEINBLK:=DIRSIZEINBLK + 1;
   ABSBLKNR := DIRSIZEINBLK - 1; { laeuft als einziger Blockzaehler von 0 ab. }
   DRCTR := DIRSIZEINBLK * RECSPROBLK;
                         { damit der 1.File noch Platz fuer das Directory hat }
end;



procedure initdir;
var  i,j : integer;
begin
   for i:=0 to 512 do
      for j:=0 to 31 do DIRBUFF[i,j]:=$FF;
   for i:=0 to 512 do DIRBUFF[i,0]:=$E5;
   AKTDIRENTRNR:=-1; { weil <makedir> zuerst addiert }
end;




procedure makedir;
var j       : integer;
begin
   AKTDIRENTRNR:=AKTDIRENTRNR+1;
   DIRENTRFREE:=DIRENTRFREE-1;
   if DIRENTRFREE=0 then DIRFULL:=true;
   for j:=0 to 31 do DIRBUFF[AKTDIRENTRNR,j]:=$00;
   for j:=1 to 11 do DIRBUFF[AKTDIRENTRNR,j]:=ord(SFNAME[j]);
   if sfpt^.ro = TRUE   { R/O Flag soll im DIR gesetzt sein }
        then DIRBUFF[AKTDIRENTRNR,9]:=( DIRBUFF[AKTDIRENTRNR,9] or $80 );
   if sfpt^.sys = TRUE  { SYS Flag soll im DIR gesetzt sein }
        then DIRBUFF[AKTDIRENTRNR,10]:=( DIRBUFF[AKTDIRENTRNR,10] or $80 );
   if sfpt^.arch = TRUE { ARCH Flag soll im DIR gesetzt sein }
        then DIRBUFF[AKTDIRENTRNR,11]:=( DIRBUFF[AKTDIRENTRNR,11] or $80 );
end;




procedure normsfname( zeig : sourcefilepointer);
var l,sp,i,punktpos : integer;
    leerstr         : string[8];
begin
   SFNAME:=zeig^.filnam;
   l:=length(SFNAME);
   sp:=12-l;
   leerstr:=' ';
   for i:=1 to sp-1 do leerstr:=leerstr + ' ';
   if sp=0 then leerstr:='';
   punktpos:=POS('.',SFNAME);
   if punktpos <> 0 then begin DELETE(SFNAME,punktpos,1);
                               INSERT(leerstr,SFNAME,punktpos)
                         end
                    else SFNAME:=SFNAME + leerstr;
end;

function enoughspace (neededrecs :integer) : boolean;
var ok       : byte;
    lw       : byte;
    space    : integer absolute $0080; { enthaelt die niederwertigen Bytes }
                                       { des Bdos-call-Ergebnisses         }
begin
   bdos(26,$0080);                     { Reset des BDOS-DMA-Pointers       }
   enoughspace:=FALSE;
   lw:=ord(DESTDR)-65; { LAUFW-BEZ ---> BYTE }
   ok:=bdos(46,lw);    { BDOS-CALL liefert die Anzahl freier Records     }
   if ok=0 then { in Abhaengigkeit von EPROMSIZEINKBYTE wird ausgerechnet, }
                { ob der naechste Destfile noch auf die Diskette passt.    }
            begin
               if mem[$0082] <> $00 then begin
                                           enoughspace:=TRUE;
                                     end
                   else begin
                    space:=(mem[$0080]+(mem[$0081]*256));
                    if ((space<0) or (space>=neededrecs))
                      then begin
                              enoughspace:=TRUE;
                              writeln;
writeln('Freier Speicherplatz auf LW-',DESTDR,' : ',space div 8,' K-BYTE');
                              writeln;
                           end
                      else begin
                             enoughspace:=FALSE;
                          writeln;
                          write('Platz auf Ziel-LW : ',space div 8,' K-BYTE');
                          writeln;
                            end;
                      end;
            end
         else begin
                 enoughspace:=FALSE;
                 NOHEAVYERROR:=FALSE;ENDE:=TRUE;
                 writeln('Fehler beim Testen der DISK-Kapazitaet. FATAL !');
              end;
end;



procedure computedir;
var hp : byte;
begin
   if NOT( BLKPOINTERSIZE ) then    { BLKPOINTERSIZE ist nur 1 byte lang      }
      begin
         if (SRCTR mod RECSPROBLK) = 0 then { ein Block ist ganz uebertragen  }
             begin
                AKTBLKINFILE := AKTBLKINFILE + 1;
                ABSBLKNR:=ABSBLKNR + 1;
                DIRBUFF[AKTDIRENTRNR,16+((AKTBLKINFILE-1)mod 16)]:=ABSBLKNR;
                DIRBUFF[AKTDIRENTRNR,15]:=getrecctr( SRCTR );
                DIRBUFF[AKTDIRENTRNR,12]:=getextnr ( SRCTR );
                if ((AKTBLKINFILE mod 16 = 0) and (ABSANZRECS > SRCTR))
                  then
                   begin
                      if DIRFULL then
                         begin
                            writeln('Directory Ueberlauf in <COMPUTEDIR>');
                            ENDE := TRUE;
                            NOHEAVYERROR := FALSE;
                         end
                       else makedir;
                   end;                    { end-of Neues DIR-ENTRY noetig }
             end                        { end-of-ganzer Block ist uebertragen }
                else                      { Kein ganzer Block ist uebertragen }
                   begin
                      if ABSANZRECS = SRCTR then
                            begin
                               DIRBUFF[AKTDIRENTRNR,15]:=getrecctr( SRCTR );
                               DIRBUFF[AKTDIRENTRNR,12]:=getextnr ( SRCTR );
                               AKTBLKINFILE := AKTBLKINFILE + 1;
                               ABSBLKNR:=ABSBLKNR + 1;
                   DIRBUFF[AKTDIRENTRNR,16+((AKTBLKINFILE-1)mod 16)]:=ABSBLKNR;
                            end; { end-of-File fertig, schliesse DIR-ENTRY ab }
                   end;

      end  { ************** end-of-NOT(BLKPOINTERSIZE) ********************** }
   else
      begin                                         { begin-of-BLKPOINTERSIZE }
         if (SRCTR mod RECSPROBLK) = 0 then { ein Block ist ganz uebertragen  }
             begin
                AKTBLKINFILE := AKTBLKINFILE + 1;
                ABSBLKNR:=ABSBLKNR + 1;
                DIRBUFF[AKTDIRENTRNR,16+(2*((AKTBLKINFILE-1)mod 8))]:=ABSBLKNR;
                hp:=SWAP ( ABSBLKNR );
                DIRBUFF[AKTDIRENTRNR,17+(2*((AKTBLKINFILE-1)mod 8))]:=hp;
                DIRBUFF[AKTDIRENTRNR,15]:=getrecctr( SRCTR );
                DIRBUFF[AKTDIRENTRNR,12]:=getextnr ( SRCTR );
                if ((AKTBLKINFILE mod 8 = 0) and (ABSANZRECS > SRCTR))
                  then
                   begin
                      if DIRFULL then
                         begin
                            writeln('Directory Ueberlauf in <COMPUTEDIR>');
                            ENDE := TRUE;
                            NOHEAVYERROR := FALSE;
                         end
                       else makedir;
                   end;                    { end-of Neues DIR-ENTRY noetig }
             end                        { end-of-ganzer Block ist uebertragen }
                else                      { Kein ganzer Block ist uebertragen }
                   begin
                      if ABSANZRECS = SRCTR then
                            begin
                               DIRBUFF[AKTDIRENTRNR,15]:=getrecctr( SRCTR );
                               DIRBUFF[AKTDIRENTRNR,12]:=getextnr ( SRCTR );
                               AKTBLKINFILE := AKTBLKINFILE + 1;
                               ABSBLKNR:=ABSBLKNR + 1;
                DIRBUFF[AKTDIRENTRNR,16+(2*((AKTBLKINFILE-1)mod 8))]:=ABSBLKNR;
                hp:=SWAP ( ABSBLKNR );
                DIRBUFF[AKTDIRENTRNR,17+(2*((AKTBLKINFILE-1)mod 8))]:=hp;
                            end; { end-of-File fertig, schliesse DIR-ENTRY ab }
                   end;

      end  { ************** end-of-BLKPOINTERSIZE *************************** }
end;