{ ========================================================================== }
{                                                                            }
{          Generator fuer Prommbare Files, fuer CONITEC Darmstadt            }
{          von Manfred Oheimer.                                              }
{                                                                            }
{          Hauptprogramm.                                                    }
{                                                                            }
{                                                                            }
{          Letzte Aenderung : 21.04.87 / 22.04.87 (Joachim)                  }
{                                                                            }
{ ========================================================================== }


type string14                   = string[14];
     zeile                      = string[128];
     sourcefilepointer          = ^Filelist;
     Filelist                   = record
                                     filnam : string14;
                                     arch   : boolean;
                                     sys    : boolean;
                                     ro     : boolean;
                                     next   : sourcefilepointer;
                                  end;
     dirbuffer                  = array[0..512,0..31] of byte; { DIR max.16k }
     dataarea                   = array[0..4095]of byte;

var EPROMSIZEINKBYTE,          { Groesse der Ziel-Datei = EPROM-Groesse       }
    NREPROMS,                  { Anzahl der EPROMS auf der EPROM-DISK         }
    EPRKAPINKBYTE,             { Kapazitaet der EPROM-DISK                    }
    BLKSIZEINKB,               { log. Blockgroesse unter CP/M                 }
    NRDIRENTR,                 { Anzahl DIRECTORY-Eintraege auf der EPROM-Disk}
    AKTDIRENTRNR,              { NR. des gerade benutzten DIR-Eintrages       }
    DIRENTRFREE,               { Anzahl der noch unbenutzten DIR-Eintraege    }
    DIRSIZEINKB,               { Groesse des DIRECTORIES in Kbyte             }
    DIRSIZEINBLK,              { Groesse des DIRECTORIES in CP/M-Blocks       }
    ABSBLKNR,                  { NR. des gerade beschriebenen Blocks, auf der }
                               { EPROM-DISK. (Werden konsekutiv vergeben)     }
    AKTBLKINFILE,              { NR. der bereits uebertragenen Bloecke der    }
                               { aktuellen Quell-Datei.                       }
    AKTFILENR,                 { NR. der aktuellen Ziel-Datei                 }
    ABSANZRECS,                { Anzahl Records in aktueller Quell-Datei      }
    RECSPROBLK                 { (Blockgroesse in Kbyte) div 128              }
                                : integer;

    DIRFULL,                   { Flag : True ,wenn alle DIR-ENTRIES verbraucht}
    RABERROR,                  { Merkzelle fuer Ergebnis Diskettenzugriff (R) }
    WABERROR,                  { Merkzelle fuer Ergebnis Diskettenzugriff (W) }
    NOHEAVYERROR,              { Tor-Bedingung fuer Arbeitszyclus             }
    ENDE,                      { Tor-Bedingung fuer Arbeitszyclus, ENDE-Fall  }
    BLKPOINTERSIZE,            { Laenge Blockpointer ( 1-byte/ 2-byte )       }
    SEITENWECHSEL,             { True ,wenn die Ziel-Diskette gewechselt wurde}
    FATALERROR,                { True ,ganze Aktion muss abgebrochen werden   }
    hlp,
    DOK,                       { True ,wenn die Voraussetzungen fuer eine     }
                               { Uebertragung eines Records zur Ziel-Datei    }
                               { gegeben sind.                                }
    SOK,                       { True ,wenn die Voraussetzungen fuer eine     }
                               { Uebertragung eines Records von der           }
                               { Quell-Datei gegeben sind.                    }
    DESTFOPEN,                 { Ist noch nicht ganz voller DestFile offen  ? }
    SOURCEFOPEN                { Ist ein noch nicht ganz verarbeiteter        }
                               { SourceFile offen ?                           }
                                : boolean;
    SOURCEDR,                  { Log. Laufwerkskennung [a:,b:,....] Quelle    }
    DESTDR                     { Log. Laufwerkskennung [a:,b:,....] Ziel      }
                                : char;
    BUFF                        : zeile;
    SFNAME,                    { Name der Quell-Datei, der Form XXXXXXXXBBB   }
    FIRSTDATAFILENAME          { Initialisierung der Ziel-Datei-Namen         }
                                : string[12];
    BUFFBLOCK                  { Puffer fuer die Datenuebertragung            }
                                : dataarea;
    DIRBUFF                    { Puffer fuer das neu berechnete DIRECTORY     }
                                : dirbuffer;
    FileVar                    { Zugriffs Variable fuer die Kommando-Datei    }
                                : text;
    SFilevar,                  { Zugriffs Variable fuer die Quell-Datei       }
    DFileVar                   { Zugriffs Variable fuer die Ziel-Datei        }
                                : file;
    sfroot,                    { Wurzel der Quell-Datei-Namen Pointerkette    }
    sfpt,                      { Zwei Pointer !                               }
    sfpth                       : sourcefilepointer;
    hilfsname,
    NEWNAME,
    AKTN,
    SNAME                       : string14;
    i,
    needed,
    DRCTR,                     { Zaehler fuer die uebertragenen Records zur   }
                               { Ziel-Datei.                                  }
    SRCTR                      { Zaehler fuer die uebertragenen Records vom   }
                               { der Quell-Datei. Aus diesem Zaehler werden   }
                               { die Werte fuer <rec> und <extentnr> im DIR-  }
                               { eintrag abgeleitet !!                        }
                                : integer;

{$I GPFMODHR.PAS }
{$I GPFMODTF.PAS }
{$I GPFMODRF.PAS }
{$I GPFMODWF.PAS }
{$I GPFMODDC.PAS }


procedure fillblk;
var emptyrecs : integer;
    ok        : boolean;
begin
   if (DRCTR mod RECSPROBLK <> 0) then { Abfangen, das Block genau voll ist   }
      begin
         clearBUFFBLOCK;
         emptyrecs := RECSPROBLK - (DRCTR mod RECSPROBLK);
         for i:=1 to emptyrecs do incrementctr( DRCTR );
                           { Justieren des DRCTR auf naechsten ganzen Block   }
         if emptyrecs <> 0 then ok := writeablock ( emptyrecs );
                                                { Auffuellen auf ganzen Block }
      end;
end;


procedure filllastfile;
var ok                             : boolean;
    fullblks,emptyblocks,emptyrecs : integer;
begin
   if not(FATALERROR) then
      begin
         fillblk;           { Fuellt den Destfile auf den naechsten Block auf }
         fullblks:=(DRCTR div RECSPROBLK);
         emptyblocks:=(EPROMSIZEINKBYTE div BLKSIZEINKB)-fullblks;
         clearBUFFBLOCK;
         for i:=1 to emptyblocks do ok:=writeablock( RECSPROBLK );
                                            { Auffuellen auf ganze Ziel-Datei }
      end; { end-of-not(FATALERROR) }
end;




procedure montieredisi000;
var ok,ERROR,stop  : boolean;
    ein            : char;
begin
   writeln;
   writeln('Montage des DIRECTORIES');
   stop:=FALSE;
   repeat
      ASSIGN(DFileVar,DESTDR+':DISI000.HXC');
      {$I- } RESET(DFileVar) {$I+ };
      if IOresult=0 then begin stop:=TRUE; ERROR:=FALSE; end
         else begin
            writeln('Bitte die Diskette ins Ziel-Laufwerk einlegen,');
            writeln('die die Datei   DISI000.HXC    enthaelt !!');
            write('Eingelegt ?  (J\N) : ');
            read(KBD,ein);ein:=UPCASE(ein);writeln(ein);
            if ein<>'J' then begin stop:=TRUE; ERROR:=TRUE; end;
          end;
   until stop;
   if ERROR then writeln('Es wurde kein DIRECTORY erzeugt')
     else begin ok:=writeDIR; closedestfile; end;
end;



procedure transferrecord;
begin
   clearBUFFBLOCK;
   RABERROR := not( readablock ( 1 ) );
   WABERROR := not( writeablock( 1 ) );
   incrementctr( SRCTR );
   incrementctr( DRCTR );
end;




procedure getnewsourcef; { Bereitet die Verarbeitung des naechsten      }
                         { Sourcefiles vor.                             }
var ok:boolean;
begin
   sfpt:=sfpt^.next;     { Geht in der Kette ein Element weiter           }
   resetctr( SRCTR );    { Reset des SOURCE-record counters               }
   if not(sfpt=NIL) then
   begin
      normsfname(sfpt);  { Erzeugt den normierten Namen des Source Files  }
                         { fuer den Directory-Eintrag                     }

      SNAME:=SOURCEDR + ':' + sfpt^.filnam; { Sourcefilename fuer Fileops }

      ok:=openfile(SNAME);  { Oeffnet den File zum Lesen                  }

      if not(ok) then ok:=changedisk('S'); { Diskettenwechsel noetig      }

      if not(ok) then begin { immer noch nicht ok !!                      }
                      NOHEAVYERROR := FALSE;
                      ENDE := TRUE;  { Abbruch der gesammten Aktion       }
                      SOK := TRUE;
                      DOK := TRUE
                   end
              else begin
                      AKTBLKINFILE := 0;
                      if not(DIRFULL) then makedir
                                      else begin
                                        NOHEAVYERROR := FALSE;
                                        ENDE := TRUE;
                                        SOK := TRUE;
                                        DOK := TRUE;
                               writeln('DIRECTORY der EPROM-Disk ist voll');
                                       end; { Fehlermeldung zu viele Files }
                   end;
      end { end-of-not(sfpt=NIL) }
     else
        begin  { Alle Sourcefiles sind abgearbeitet }

           { Hier muessen alle Files geclosed werden, und in Abhaengigkeit }
           { von NOHEAVYERROR die BUFFERinhalte gerettet oder nicht.       }

           if NOHEAVYERROR then filllastfile;
              { Hier wird der letzte offene DestFile so weit    }
              { aufgefuellt, bis er EPROMSIZE gross ist.        }
           closedestfile;
           montieredisi000;
           write('Nach Ende der Operation bleibt noch');
           hlp := enoughspace(1);
           NOHEAVYERROR := FALSE;
           ENDE := TRUE;
           SOK := TRUE;
           DOK := TRUE; { Die ganze Operation ist erfolgreich abgeschlossen }
        end;
end;




procedure getnewdestfile;          { Muss einen neuen DESTfile anlegen, dabei }
                                   { notfalls einen Wechsel der DESTDISK ver- }
                                   { anlassen und BLKCOUNT, resetten.         }
var ok,isokay : boolean;
begin
   needed := EPROMSIZEINKBYTE * 8;
   ok := TRUE;
   while ok do if not(enoughspace(needed)) then begin
                                                  ok := changedisk('D');
                                                  isokay := ok; end
                                           else begin ok := FALSE;
                                                      isokay := TRUE; end;
   if isokay then begin
    makename(AKTN); { zuviel DFiles und noch nicht alle Files bearbeitet }
    if ((AKTFILENR > NREPROMS)and(sfpt<>NIL)) then begin
     writeln('Alle EPROMS sind belegt, nicht alle Dateien wurden verarbeitet');
     writeln('Letzte begonnene Datei : ',SNAME);
     ENDE := TRUE;
     NOHEAVYERROR := FALSE;
     SOK := TRUE;
     DOK := TRUE;
    end;                              { end-of Nicht alle Dateien verarbeitet }
    AKTN := NEWNAME;
    ok := createfile(DESTDR+':'+AKTN);
    if not(ok) then                                      { Alles im Eimer!!!! }
                 begin
                    NOHEAVYERROR := FALSE;
                    ENDE := TRUE;
                    SOK := TRUE;
                    DOK := TRUE;
                 end  { Abbruch der ganzen Aktion }
               else begin
                      if AKTFILENR<>0 then DRCTR :=0;
                   end;                { DISI000.HXC wird gesondert behandelt }
   end { end-of-enoughspace }
      else begin
             NOHEAVYERROR := FALSE;
             ENDE := TRUE;
             SOK := TRUE;
             DOK := TRUE;
           end;                                   { Ende der gesammten Aktion }
end;

procedure createdir;
var ok : boolean;
begin
   ok := FALSE;
   if spacetest(EPROMSIZEINKBYTE*8) then ok:=createfile(DESTDR+':DISI000.HXC');
   if not(ok) then begin FATALERROR := TRUE;
                      writeln('Abbruch beim Eroeffnen der Datei DISI000.HXC');
                   end
      else if not(writeDIR) then begin FATALERROR := TRUE;
                      writeln('Abbruch beim Schreiben der Datei DISI000.HXC');
                     end;
end;


begin
   { Anfangsmeldung mit Versionsnummer }
   writeln;writeln;writeln;writeln;writeln;
   writeln('Generator fuer ROM-Disk Dateien, Version 1.3');
   writeln;
   writeln('                            (c) Conitec 1986');
   writeln;

   SEITENWECHSEL := FALSE;
   FATALERROR := FALSE;
   if getcommandfile('gpf.ctr') then
       begin bdos(13);                                { Reset des Disksystems }
         setdirandblksize;
         init;
         initdir;
         createdir;                         { Aufruf fuer Dummy-Dir Erzeugung }
       end
     else FATALERROR := TRUE;
   if not(FATALERROR) then        { Die ganze Uebertragung beginnt nur, wenn  }
       begin                      { bei der Berechnung der Parameter etc. kein}
          AKTN := Firstdatafilename; { gravierender Fehler aufgetreten ist.   }
          makename(AKTN);
          sfpt := sfroot;


          { *********** Hier beginnt die Initialisierung  ******************  }


          NEW(sfpt); sfpt^.next := sfroot;   { Ein Leerelement am Anfang, zur }
                                             { Initialisierung                }
          getnewsourcef;
          if DIRSIZEINKB = EPROMSIZEINKBYTE then getnewdestfile;

          NOHEAVYERROR := TRUE;
          ENDE := FALSE;


          { ********** Hier beginnt der eigentliche Arbeitszyclus **********  }


          repeat                                                 { UNTIL ENDE }
             if NOHEAVYERROR then begin
                repeat                                { UNTIL ( SOK and DOK ) }
                   if ABSANZRECS > SRCTR then SOK := TRUE
                                   else begin
                                           fillblk;
                                           SOK := FALSE;
                                           SOURCEFOPEN := FALSE;
                                           write('Datei ');
                                           write(SNAME);
                                           writeln(' ist verarbeitet.');
                                           getnewsourcef;
                                        end;
                   if NOHEAVYERROR then begin
                      if (( DRCTR div 8 ) = EPROMSIZEINKBYTE )
                                           then begin
                                                 DOK := FALSE; closedestfile;
                                                 getnewdestfile;
                                                end
                                           else DOK := TRUE;
                                        end;           { end-of-NOHEAVYERROR  }

                until ( SOK and DOK );
                if NOHEAVYERROR then
                   begin
                   transferrecord; { Uebertragung eines Records  SF ---> DF   }
                                   { incl. SRCTR- und DRCTR-Korrektur .       }

                   computedir;     { traegt Blockpointer(8/16-bit) und        }
                                   { #Records ins Directory ein. Erzeugt ein  }
                                   { neues, wenn noetig.                      }

                   end;                                 { end-of-NOHEAVYERROR }
             end;{ Richtig, diese Abfrage kommt oft vor : end-of-NOHEAVYERROR }
          until ENDE;
   end; { end-of-not(FATALERROR) }
   closedestfile;
end.


