(************************************************************)
(*                                                          *)
(* Dieses Programm fuellt das Direktory einer RAM-Floppy    *)
(* mit "E5" und loescht damit die Floppy.                   *)
(*                                                          *)
(*                                     (c) Conitec JH 1986  *)
(*                                                          *)
(************************************************************)

const

start_lw = 'E';    (* Geben Sie hier den Buchstaben der ersten  *)
stop_lw  = 'P';    (* und letzten Laufwerks an, dass von ERASER *)
                   (* geloescht werden kann.                    *)
                   (* Achtung, nur Grossbuchstaben verwenden!   *)

type

dpbrec      = record

            spt     : integer;
            bsh     : byte;
            blm     : byte;
            exm     : byte;
            dsm     : integer;
            drm     : integer;
            all     : integer;
            cks     : integer;
            off     : integer;
            psh     : byte;
            phm     : byte;

            end;


var

dpb         : dpbrec;
dpbpointer  : integer;
i           : integer;
dirbytes    : integer;
secsize     : integer;
dirsecs     : integer;
sector      : integer;
track       : integer;
drive       : integer;
dmabuffer   : array[1..1024] of byte;




procedure dbc(no:integer;areg:integer;bc,de,hl:integer);

type

pbarec      = record

            no      : byte;
            areg    : byte;
            bc      : integer;
            de      : integer;
            hl      : integer;

            end;

var

pba         : pbarec;


begin
  pba.no:=no;
  pba.areg:=areg;
  pba.bc:=bc;
  pba.de:=de;
  pba.hl:=hl;
  bdos(50,addr(pba));
end;

procedure setsec(sec:integer);
begin
  dbc(11,0,sec,0,0);
end;

procedure settrk(trk:integer);
begin
  dbc(10,0,trk,0,0);
end;

procedure setdma(dma:integer);
begin
  dbc(12,0,dma,0,0);
end;

procedure writesec;
begin
  dbc(14,0,0,0,0);
end;

function loeschen:boolean;

var

ch      : char;
flag    : boolean;

begin
  write('enter RAM-Floppy to clear : ');
  read(kbd,ch);
  ch:=upcase(ch);
  writeln(ch);
  drive:=(ord(ch)-65);
  flag:=true;
  if (drive < (ord(start_lw)-65)) or (drive > (ord(stop_lw)-65) ) then
  begin
    flag:=false;
    writeln('error, wrong drive name');
    writeln;
  end;
  loeschen:=flag;
end;





begin (* Hauptprogramm *)
 for i:=1 to 16 do writeln;
 if loeschen then
  begin
  (* fuelle dmabuffer mit e5               *);
  fillchar(dmabuffer,1024,229);
  (* waehle laufwerk  aus                *);
  bdos(14,drive);
  (* kopiere dpb-Daten in die Variable dpb *);
  dpbpointer := bdoshl(31);
  for i:=0 to 16 do mem[addr(dpb)+i]:=mem[dpbpointer+i];

  dirbytes:=32*(dpb.drm+1);
  secsize:=128 shl dpb.psh;
  dirsecs:=dirbytes div secsize;

  for i:=1 to 3 do writeln;
  writeln('Directory Bytes   : ',dirbytes);
  writeln('Sectorsize        : ',secsize);
  writeln('No. Dir. Sectors  : ',dirsecs);
  writeln;
  writeln;

  track:=dpb.off;
  sector:=0;
  setdma(addr(dmabuffer));
  for I:=0 to dirsecs-1 do
  begin
    if (i mod 4) = 0 then writeln;
    write('sec',sector:3,' trk',track:3,'    ');
    setsec(sector);
    settrk(track);
    writesec;
    sector:=sector+1;
    if sector shl dpb.psh >= dpb.spt then
    begin
      sector:=0;
      track:=track+1;
    end;
  end;
  bdos(13);
  writeln;
  writeln;
  writeln('RAM-Disk erased, restart Computer to use RAM-Disk');
  writeln;
 end;
end.