(*********************************************************************

Harddisk Formatierprogramm                       (c) Conitec 1987, JH

letzte Aenderung am : 01.12.1987

*********************************************************************)


{$U+}
{$R+}

const

boot_file_name     = 'PBECPC.COM';
cpmldr_file_name   = 'CPMLDR.COM';

kopf1_txt = 'Harddisk Formatierprogramm Version 1.0        (c) 1987 Conitec, JH';

cop_txt   = 'CP/M-Lader auf Harddisk kopieren .......... : ';
lwf_txt   = '*** Fehler beim Schreiben des CP/M Laders ***';
fnf_txt   = 'Fehler, Datei nicht gefunden .............. : ';
lese_txt  = 'Datei lesen ............................... : ';
bwf_txt   = '*** Fehler beim Schreiben des Bootsektors ***';
zukurz_txt= '*** Fehler, Datei enthaelt keine Daten .... : ';
zulang_txt= '*** Fehler, Datei zu lang ................. : ';

for1_txt  = 'Harddisk neu formatieren ? (J/N) .......... : ';
for2_txt  = 'Harddisk wird formatiert, alle Daten werden';
for9_txt  = 'Formatierung Ueberpruefen ? (J/N) ......... : ';
for3_txt  = 'geloescht (J/N) ........................... : ';
for4_txt  = 'Begin des Formatierens .................... : ';
for5_txt  = 'Formatierung wird ueberprueft ............. : ';
for6_txt  = '***     Fehler im Harddisk Controller     ***';
for7_txt  = 'Fehler aufgetreten';
for8_txt  = 'ok';

txt_cyl   = 'Anzahl der Zylinder ....................... : ';
txt_heads = 'Anzahl der Koepfe ......................... : ';
txt_pre   = 'Ab welcher Spur write precompensation ..... : ';
txt_red   = 'Ab welcher Spur reduced write current ..... : ';
txt_ecc   = 'ECC Data Burst Laenge (max. 11)............ : ';
txt_skew  = 'Sektor Skewfaktor.......................... : ';
txt_spt   = 'Sektoren / Spur (17 bei MFM, 26 bei RLL) .. : ';
txt_cntl  = 'Kontrollbyte .............................. : ';

boot1_txt = 'Soll der Bootsektor beschrieben werden ? J/N: ';
boot2_txt = 'Soll der CP/M-Lader kopiert werden ? (J/N)  : ';

con_cyl   : integer = 440;
con_heads : integer = 6;
con_pre   : integer = 256;
con_red   : integer = 256;
con_ecc   : integer = 11;  {bei Omti Controller hier Null}
con_skew  : integer = 7;
con_spt   : integer = 17;
con_cntl  : integer = 1;

port_adr  : byte = $e0;    {Basisadresse des Controllers}


type message   = string [80];

var

cfield                 :  record
                            COMAND : byte;
                            ADRESS : byte;
                            SECTOR : byte;
                            TRACK  : byte;
                            BCOUNT : byte;
                            TERMIN : byte;
                          end;

CFARRAY                :  array [0..5] of byte absolute CFIELD;
RES                    :  array [1..5] of byte;
BUFFER                 :  array [0..511] of byte;
ERROR                  :  boolean;
file_var               :  file;
skew_factor            :  integer;
code,k                 :  integer;
answ                   :  char;
skew                   :  byte;

dpb                    :  record
                            spt : integer;
                            bsh : byte;
                            blm : byte;
                            exm : byte;
                            dsm : integer;
                            drm : integer;
                            all : integer;
                            cks : integer;
                            off : integer;
                            psh : byte;
                            phm : byte;
                          end;
drive_characteristics  :  array [0..7] of byte;
copyright              :  string[11];
copy_array1            :  array [0..16] of byte absolute dpb;
copy_array2            :  array [0..7] of byte absolute drive_characteristics;
copy_array3            :  array [0..11] of byte absolute copyright;




procedure wait_controller_ready;

var  STATUS:  byte;

begin
  repeat
    STATUS:= port[port_adr+1] and 1;
  until STATUS=1;
end;


procedure send_command;


var    I:    byte;

begin
  PORT[port_adr+2]:=0;
  delay(10);
  for I:=0 to 5 do begin
      wait_controller_ready;
      PORT[port_adr]:=CFARRAY[I];
  end;
end;


procedure  read_result;

var       I:        byte;

begin
    res[5]:=0;
    for I:=1 to 5 do begin
      wait_controller_ready;
      if I=4 then res[i]:=RES[I]+port[port_adr]
             else
             res[i]:=port[port_adr];
(*      if i=3 then
         if res[i] >= 64 then res[i+1]:= (res[i] div 64)*256
                         else res[i+1]:=0;;
  *)   end;
end;


function error_check: boolean;

var  err:           boolean;
     status:        byte;


begin
     wait_controller_ready;
     status:=port[port_adr];
     err:=false;
     if status and 2 <> 0 then begin
        cfield.comand:=3;
        cfield.adress:=0;
        cfield.sector:=0;
        cfield.track:=0;
        cfield.termin:=0;
        cfield.bcount:=1;
        send_command;
        read_result;
        err:=true;
      end;
      error_check:=err;
 end;


procedure set_characteristics       (var err: boolean);

var  i: byte;

begin
    port[port_adr+1]:=0;
    delay(10);
    port[port_adr+3]:=0;
    delay(10);
    cfield.comand:=12;
    cfield.adress:=0;
    cfield.sector:=0;
    cfield.track:=0;
    cfield.termin:=0;
    cfield.bcount:=0;
    send_command;
    for i:=0 to 7 do begin
        wait_controller_ready;
        port[port_adr]:=drive_characteristics[i];
    end;
    err:=error_check;
end;


procedure write_hd_sector  (cyl,head,sect: integer; var err: boolean);

var      status  :        byte;
                I:        INTEGER;

begin

        cfield.bcount:=1;
        cfield.comand:=10;
        cfield.adress:=head;
        cfield.termin:=con_cntl;
        cfield.track:=cyl mod 256;
        cfield.sector:=((cyl div 4) and $c0)+ sect;
        send_command;
        wait_controller_ready;
        status:=port[port_adr+1];
        if (status and 4) = 0 then begin
           for i:= 0 to 511 do begin
               wait_controller_ready;
               port[port_adr]:=buffer[i];
           end;
         end;
         err:=error_check;

end;


procedure  read_hd_sector   (cyl,head,sect: integer; var err: boolean);

var      status  :        byte;
              I  :        integer;
begin
  cfield.bcount:=1;
  cfield.comand:=8;
  cfield.adress:=head;
  cfield.termin:=con_cntl;
  cfield.track:=cyl mod 256;
  cfield.sector:=((cyl div 4) and $c0)+ sect;
  send_command;
  wait_controller_ready;
  status:=port[port_adr+1];
  if (status and 4) = 0 then begin
     for i:= 0 to 511 do begin
         wait_controller_ready;
         buffer[i]:=port[port_adr];
     end;
  end;
  err:=error_check;
end;


procedure fill_sector_buffer (pattern: byte;  var err: boolean);

var      status:        byte;
              I:        INTEGER;
begin

        cfield.bcount:=0;
        cfield.comand:=$f;
        cfield.adress:=0;
        cfield.termin:=$0;
        cfield.track:=0;
        cfield.sector:=0;
        send_command;
        wait_controller_ready;
        status:=port[port_adr+1];
        if (status and 4) = 0 then begin
           for i:= 0 to 511 do begin
               wait_controller_ready;
               port[port_adr]:=pattern;
           end;
         end;
         err:=error_check;

end;


procedure  format_the_drive  (skew:byte; var err: boolean);



begin

        cfield.bcount:=skew and $1f;
        cfield.comand:=4;
        cfield.adress:=0;
        cfield.termin:=con_cntl or $40;
        cfield.track:=0;
        cfield.sector:=0;
        send_command;
        err:=error_check;

end;


procedure test_drive (var err: boolean);

begin

        cfield.comand:=$e3;
        cfield.adress:=0;
        cfield.track:=0;
        cfield.sector:=0;
        cfield.bcount:=0;
        cfield.termin:=0;
        send_command;
        err:=error_check;

end;


(*-------------------------------------------------------------------
Die folgende Funktion liest eine Zeichen ein. Wenn das Zeichen gleich
'J' ist die Funktion true, sonst false
*)
function Ja:boolean;
var ch : char;
begin
  read(kbd,ch);
  if (ord(ch) >= $20) and (ord(ch) < $80) then write(ch);
  if (ch='J') or (ch='j') then Ja:=true else Ja:=false;
  writeln;
end;

(*-------------------------------------------------------------------
Die folgende procedure liest eine  vierstellige Dezimalzahl ein
*)
procedure DEZ_input(var i:integer);
var
  ch   : char;
  flag : boolean;
begin
  flag:=true;
  ch:=' ';
  write('    ');
  while ch <> #13 do
  begin
    write(#8,#8,#8,#8,i:4);
    read(kbd,ch);
    ch:=upcase(ch);
    case ch of
    '0'..'9' : begin
                 if flag = true then begin
                                       flag:=false;
                                       i:=0;
                                     end;
                 if i<1000 then
                   i:=i*10+ord(ch)-$30
                   else
                   begin
                     i:=(i-((i div 1000)*1000))*10+ord(ch)-$30
                   end;
               end;
    #8       : begin
                 i:=i div 10;
                 flag:=false;
               end;
    #127     : i:=0;
    #13      : ;
    else write(#7);
    end;
  end;
end;

(*-------------------------------------------------------------------
  Erzeuge die Laufwerksparameter
*)
procedure build_drive_characteristics;
begin
  drive_characteristics[0]:= hi(con_cyl);
  drive_characteristics[1]:= lo(con_cyl);
  drive_characteristics[2]:= lo(con_heads);
  drive_characteristics[3]:= hi(con_red);
  drive_characteristics[4]:= lo(con_red);
  drive_characteristics[5]:= hi(con_pre);
  drive_characteristics[6]:= lo(con_pre);
  drive_characteristics[7]:= lo(con_ecc);
end;

(*-------------------------------------------------------------------
  Generiere den Disk Parameter Block aus den eingelesenen Daten
*)
procedure build_dpb;
begin
  dpb.spt:=con_spt*4;
  dpb.bsh:=5;       (* Blockgroesse liegt fest auf 4K *)
  dpb.blm:=31;
  dpb.exm:=1;

  dpb.drm:=2047;    (* Direktory Eintraege liegen fest auf 2048 *)
  dpb.all:=$FFFF;
  dpb.cks:=$8000;   (* Medium kann nicht gewechselt werden      *)
  dpb.off:=1;       (* Offset ist fest auf einer Spur           *)
  dpb.psh:=2;       (* Sektorgroesse fest auf 512 Byte          *)
  dpb.phm:=3;

  dpb.dsm:=trunc(dpb.spt/32*(con_heads*con_cyl-dpb.off)-1);
end;


(*-------------------------------------------------------------------
  lese die Laufwerksparameter ein
*)
procedure read_parameter;

begin
  write(txt_cyl);
  dez_input(con_cyl);
  writeln;

  write(txt_heads);
  dez_input(con_heads);
  writeln;

  write(txt_pre);
  dez_input(con_pre);
  writeln;

  write(txt_red);
  dez_input(con_red);
  writeln;
{
  write(txt_ecc);
  dez_input(con_ecc);
  writeln;
}
  write(txt_skew);
  dez_input(con_skew);
  writeln;
{
  write(txt_spt);
  dez_input(con_spt);
  writeln;
}
  write(txt_cntl);
  dez_input(con_cntl);
  writeln;

end;

(*------------------------------------------------------------------
Stellt die Frage ob formatiert werden soll doppelt
*)
function formatieren : boolean;
begin
formatieren:=false;
writeln;
write(for1_txt);
if Ja then
  begin
    writeln(for2_txt);
    write(for3_txt);
    if Ja then formatieren:=true;
  end
end;

(*-------------------------------------------------------------------
   Lese die Datei mit boot_file_name Namen in den Buffer
   gebe Fehlermeldungen aus bei:
                                  Datei nicht gefunden
                                  Datei zu kurz
                                  Datei zu lang
*)
procedure read_boot_sektor;
var laenge : integer;
begin
  assign(file_var,boot_file_name);
  {$I-}
  reset(file_var);
  {$I+}
  if ioresult = 0 then
  begin
    laenge:=filesize(file_var);
    if not((laenge = 0) or (laenge > 4)) then
    begin
      fillchar(buffer,512,$FF);
      writeln(lese_txt,boot_file_name);
      blockread(file_var,buffer,laenge);
    end
    else
    begin
      if laenge = 0 then writeln(zukurz_txt,boot_file_name) else
                         writeln(zulang_txt,boot_file_name);
    end;
  end
  else
  begin
    writeln(fnf_txt,boot_file_name);
  end;
end;

(*--------------------------------------------------------------------
  Schreibe den Bootsektor auf die Harddisk.
*)
procedure write_boot_sektor;
var
i        : integer;
hdfehler : boolean;
begin
  writeln;
  write(boot1_txt);
  if ja then
  begin
    read_boot_sektor;
    build_drive_characteristics;
    copyright:='(c) Conitec';
    build_dpb;
    for i:=0 to 16 do buffer[475+i]:=copy_array1[i];
    for i:=0 to 7 do buffer[492+i]:=copy_array2[i];
    buffer[500]:=con_cntl;
    for i:=1 to 11 do buffer[500+i]:=copy_array3[i];
    write_hd_sector(0,0,0,hdfehler);
    if hdfehler then writeln(bwf_txt);
  end;
end;

(*-------------------------------------------------------------------
   Kopiere die Datei mit cpmldr_file_name Namen auf die Harddisk
   ab Sektor 1, Spur 0.
   gebe Fehlermeldungen aus bei:
                                  Datei nicht gefunden
                                  Datei zu kurz
                                  Datei zu lang
*)
procedure copy_cpmldr;
var
laenge   : integer;
sektor   : integer;
readcnt  : integer;
hdfehler : boolean;
begin
  writeln;
  write(boot2_txt);
  if ja then
  begin
    assign(file_var,cpmldr_file_name);
    {$I-}
    reset(file_var);
    {$I+}
    if ioresult = 0 then
    begin
      laenge:=filesize(file_var);
      if not((laenge = 0) or (laenge > 65)) then
      begin
        writeln(cop_txt,cpmldr_file_name);
        sektor:=1;
        hdfehler:=false;
        while (laenge > 0) and (not hdfehler) do
        begin
          if laenge < 4 then readcnt:=laenge else readcnt:=4;
          fillchar(buffer,512,$FF);
          blockread(file_var,buffer,readcnt);
          write_hd_sector(0,0,sektor,hdfehler);
          if hdfehler then writeln(lwf_txt);
          laenge:=laenge-readcnt;
          sektor:=sektor+1;
        end;
      end
      else
      begin
        if laenge = 0 then writeln(zukurz_txt,boot_file_name) else
                           writeln(zulang_txt,boot_file_name);
      end;
    end
    else
    begin
      writeln(fnf_txt,boot_file_name);
    end;
  end;
end;

procedure format;

begin
  if formatieren then
  begin
    set_characteristics (error);
    if not error then
    begin
      skew:=con_skew;
      fill_sector_buffer ($e5,error);
      if not error then
      begin
        write(for4_txt);
        format_the_drive (skew,error);
        if not error then
        begin
          writeln (for8_txt);
          writeln;
          write (for9_txt);
          if ja then
          begin
            write (for5_txt);
            test_drive (error);
            if not error then
            begin
              writeln (for8_txt);
            end
            else writeln (for7_txt);
          end;
        end
        else writeln (for7_txt);
      end
      else writeln (for6_txt);
    end
    else writeln (for6_txt);
  end;
end;

procedure kopf;
begin
  for k:= 1 to 5 do writeln;
  writeln(kopf1_txt);
  writeln;
end;

begin
  kopf;
  read_parameter;
  build_drive_characteristics;
  format;
  write_boot_sektor;
  copy_cpmldr;
end.


