; CP/M plus Treiber fuer ECPC mit Omti 5520 / WD 1002 Controller

; Dieser Treiber eignet sich fuer alle CP/M plus Systeme, bei denen
; das BIOS nach dem Vorschlag von Digital Research aufgebaut ist.
; D.h. : Die Extern definierten Routinen und Variablen m}ssen die
; gleiche Bedeutung haben wie im Beispiel BIOS des System Guide.
; Die Rechner PROF-180X und PROF-80 von Conitec entsprechen diesen
; Anforderungen.

; letzte Aenderung am: 01.01.1988 (Joachim)

	title	'CP/M plus Hard Disk Driver'

	maclib	z80

	maclib	cpm3

	public	hdsd0

	extrn	?pmsg,?bank,@dma,@dbnk,@sect,@trk,@ermde
	extrn	ciecho

; Portadressen fuer WD- oder Omti-Controller auf ECB-Bus (mit ECPC von Conitec)

odata	equ	0e0h
ostatus	equ	0e1h
oconfig	equ	0e2h
omask	equ	0e3h
oreset	equ	0e1h
oselect	equ	0e2h

	cseg

dphd:
	dw	68	; spt
	db	5	; bsh
	db	31	; blm
	db	1	; exm
	dw	5609	; dsm
	dw	2047	; drm
	db	255	; all0
	db	255	; all1
	dw	8000h	; cks
	dw	1	; off
	db	2	; psh
	db	3	; phm


	dseg

	dw	write
	dw	read
	dw	login
	dw	init
	db	0,0

hdsd0:
 	DW 0				; NO SECTOR TRANSLATION
 	DB 0,0,0,0,0,0,0,0,0		; BDOS SCRATCH AREA
 	DB 0				; MEDIA FLAG
 	DW DPHD				; DISK PARAMETER BLOCK
 	DW 0				; NO CHECKSUM VECTOR
 	DW ALLVE			; ALLOCATION VECTOR
 	DW 0FFFEH,0FFFEH,0FFFEH		; DIRBCB, DTABCB, HASH ALLOC'D
 	DB 0				; HASH BANK

allve:

; Die INIT-Routine befindet sich im Datenbereich des Allocation
; Vectors. Da INIT nur einmal vor dem Ersten Beschreiben
; des Vectors aufgerufen wird entstehen keine Probleme.
;
; Die INIT-Routine setzt die Laufwerksdaten und den Disk Parameter
; Block wie im Boot-Sektor der Harddisk definiert (Die Definition
; erfolgt im Formatierprogramm).
;
; Falls beim Lesen der Initialisierungsdaten Fehler auftreten,
; wird beim nachfolgenden LOGIN ein Invalide Drive erzeugt. Der
; Fehler wird im Klartext auf dem Bildschirm angezeigt.

init:					;
	sspd	ssave			; rette alten stackpointer
	lxi	sp,initstack		; lade stackpointer neu
					;
	call	read$boot$sektor	; sonst Bootsektor lesen
	jrnz	initerror		; es trat ein Fehler auf
	lxi	h,boot$sektor+475	; ok, Zeiger auf Datenanfang

initt:					; ok, Diskdaten sind im Arbeitsspeicher
					; und HL zeigt auf den Anfang (DPB-Daten).
	lxi	d,dphd			; Kopiere als erstes dpb
	lxi	b,17			;
	ldir				;

	lxi	d,drivepar		; Kopiere drive characterisitics
	lxi	b,8			;
	ldir				;

	mov	a,m			; lege controllbyte ab
	sta	cntlbyte		;

	lda	drivepar+2		;
	sta	divheads+1		;
	

	call	init$drive$pars		; initialisiere drive characteristics
	mvi	a,4			; Fehlercode 4
	jrnz	initerror		; Sprung wenn Fehler aufgetreten

					; alles paletti
	mvi	a,0c9h			; noch Patch fuer LOGIN ok
	sta	login			;
	lxi	h,insttxt		; gebe text fuer harddisk ok aus
	call	?pmsg			;
osret:	lspd	ssave			; lade alten stackpointer wert
	ret				; Return

initerror:
	push	psw			; Rette Fehlernummer
	lxi	h,hderrtxt1		;
	call	?pmsg			;
	pop	psw			; Gebe Fehler im Klartext aus
	mov	l,a			;
	mvi	h,0			;
	lxi	d,hderrtab		;
	dad	h			;
	dad	d			;
	mov	a,m			;
	inx	h			;
	mov	h,m			;
	mov	l,a			;
	call	?pmsg			;
	jr	osret			;

hderrtab:				;
	dw	hderr0			;
	dw	hderr1			;
	dw	hderr2			;
	dw	hderr3			;
	dw	hderr4			;

insttxt:
	db	0dh,0ah,'Hardisk installation ok, driver version 1.0',0dh,0ah,0dh,0ah,0

hderrtxt1:
	db	0dh,0ah,'Harddisk initialisation error : ',0
hderr0:	db	'controller failed',0dh,0ah,0dh,0ah,0
hderr1:	db	'not ready',0dh,0ah,0dh,0ah,0
hderr2: db	'boot sector read failure',0dh,0ah,0dh,0ah,0
hderr3:	db	'data in boot sector not ok',0dh,0ah,0ah,0ah,0
hderr4:	db	'set drive characteristics',0dh,0ah,0dh,0ah,0


read$boot$sektor:			; lese Bootsektor
	mvi	h,0ffh			; unterdruecke alle Harddisk Fehler
	sta	@ermde			;
					;
	call	hdreset			; pruefe ob controller ok
	mvi	a,0			; Fehlercode 0
	rnz				;
	call	wait$hd$ready		;
	mvi	a,1			; Fehlercode 1
	rnz				;
	xra	a			;
	lxi	h,boot$sektor		; DMA-Adresse ist boot$sektor
	shld	@dma			;
	sta	@dbnk			; boot$sektor liegt in Bank 0
	sta	@sect			; lade Sektor 0
	lxi	h,0			; Track Null
	shld	@trk			;
	call	read			; ok, lese den Sektor
	mvi	a,2			; Fehlercode 2
	rnz				; Ruecksprung, wenn Fehler
					; sonst, teste ob Bootsektor gueltig
	lxi	h,boot$sektor+501	;
	lxi	d,hdboottxt		;
	mvi	b,11			;
hdrb1:	ldax	d			;
	cmp	m			;
	mvi	a,3			; Fehlercode 3
	rnz				; Return, wenn Copyright falsch
	inx	h			;
	inx	d			;
	djnz	hdrb1			;
					;
	ret				; Return, Bootsektor ok
					;
hdboottxt:
	db	'(c) Conitec'

wait$hd$ready:			; warte bis Winchester READY oder Timeout
	call	check$hd$ready	;
	rz			; alles ok Winchester beim ersten Mal READY
	lxi	h,whrtxt	; gebe Wartemeldung aus
	call	?pmsg		;
	lxi	h,0ffffh	; lade Timeout Zaehler
whr1:	push	h		;
	call	check$hd$ready	;
	pop	h		;
	rz			;
	dcx	h		;
	mov	a,h		;
	ora	l		;
	jrnz	whr1		;
	mvi	a,0ffh		;
	ora	a		;
	ret			;
	
whrtxt:	db	0dh,0ah,'waiting for Harddisk ready',0dh,0ah,0dh,0ah,0

check$hd$ready:			; pruefe ob Winchesterlaufwerk READY
	call	select		;
	lxi	h,readycmdfield	;
	call	scmd2		;
	call	readstatus	;
	ret			;

readycmdfield:
	db	0,0,0,0,0,0



HDRESET:			;SOFTRESET DES HARDDISK KONTROLLERS
				;FALLS KEIN HARDDISKCONTROLLER VORHANDEN
				;WIRD ZEROFLAG RUECKGESETZT, SONST GESETZT
	CALL	HDR2		;TESTE RESET
	RNZ			;FEHLER, ENDE
	MVI	B,0FFH		;VERZOEGERUNG NACH RESET
HDR4:	DJNZ	HDR4		;
	LXI	H,0		;TIME-OUT FUER SELECT-TEST
	OUT	OSELECT		;
HDR3:	IN	OSTATUS		;
	ANI	00111111B	;
	CPI	00DH		;
	JRZ	HDR2		;
	INX	H		;
	MOV	A,H		;
	CPI	10H		;
	JRNZ	HDR3		;
	ORA	A		;
	RET			;
HDR2:				;RESET HARDDSIK CONTROLLER, WENN OK IST
				;ZERO BIT GESETZT
	LXI	H,0		;TIME-OUT FUER RESET-TEST
	OUT	ORESET		;RESET BEFEHL
HDR1:	IN	OSTATUS		;LESE STATUS
	ANI	00111111B	;
	RZ			;WENN NULL RESET OK
	INX	H		;LESE BIS TIMEOUT
	MOV	A,H		;
	CPI	10H		;
	JRNZ	HDR1		;
	ORA	A		;RESET WAR NICHT ERFOLGREICH LOESCHE ZEROFLAG
	RET			;
	

init$drive$pars:		; Initialisiere Laufwerksparameter
	call	select		;
	lxi	h,initcmdfield	;
	call	scmd2		;
init1:	in	ostatus		; wait for data write transfer
	ani	00111111b	;
	cpi	00001111b	; no transfer in error case
	jrz	init2		;
	cpi	00001001b	;
	jrnz	init1		;

	lxi	h,drivepar	;
	mvi	b,8		;
	mvi	c,odata		;
	outir			;

init2:	call	readstatus	;

	ret			;

initcmdfield:
	db	0ch,0,0,0,0,0

drivepar:
	ds	8
boot$sektor:
	ds	512
ssave:
	ds	2
	ds	256
initstack:

	ds	allve+2048-$


login:
				; Wenn von init kein Patch erfolgt
				; dann setze Stack so, dass hl =0
				; wenn seldsk zum bdos zurueckkehrt
	pop	d		; returnadresse
	pop	h		; dph adresse
	lxi	h,0		; setze dph adresse auf 0 (disk nicht erkennbar)
	push	h		; stack wieder herstellen
	push	d		;
	ret			;

select:				; select Omti controller
	out	oselect		;
select1	in	ostatus		; wait for controller selected
	ani	00111111b
	cpi	00001101b	; wait until commandtransfer is ready
	jrnz	select1		;
	ret			; end of procedure


sendcmd:			; send command (6 Byte) from cmdfield 
				; to Omti controller
	call	select		; first select controller
	lxi	h,cmdfield	; point to cmdfield
scmd2:	mvi	b,6		; byte counter
	mvi	c,odata		; pointer to Omti dataport
scmd1:	in	ostatus		; read statusbyte
	ani	00111111b
	cpi	00001101b	; ready for write command byte ?
	jrnz	scmd1		; no, wait until ready
	outi			; write commandbyte to omti
	jrnz	scmd1		; until all done
	ret			; end of procedure


readstatus:			; read statusbyte and set zeroflag and
				; errflag if any error
	in	ostatus		; read contoller statusbyte
	ani	00111111b
	cpi	00001111b	; ready for status read ?
	jrnz	readstatus	; no, wait until ready
	in	odata		; ok, read statusbyte
	sta	errflag		; save it in errflag
	ora	a		; and set zeroflag
	rz			; end of procedure if no errors
	mvi	a,0ffh		; else set errorflag
	ret			; in reg. A too.

	cseg

readbuffer:			; read Omti databuffer to (hl)
	lda	@dbnk		;
	call	?bank
rbuff2:	in	ostatus		; wait for data read transfer
	ani	00111111b
	cpi	00001111b	; 
	jrz	rbuff1		; no transfer in error case
	cpi	00001011b	;
	jrnz	rbuff2		;
	lxi	b,odata		; clear b and set c to dataport
	inir			; read 256 Byte
	inir			; read the next 256 Byte
rbuff1:	xra	a
	call	?bank
	ret			; end of procedure


writebuffer:			; write Omti databuffer from (hl)
	lda	@dbnk
	call	?bank
wbuff2:	in	ostatus		; wait for data write transfer
	ani	00111111b
	cpi	00001111b	; no transfer in error case
	jrz	wbuff1		;
	cpi	00001001b	;
	jrnz	wbuff2		;
	lxi	b,odata		; clear b and set c to dataport
	outir			; write 256 Byte
	outir			; write the next 256 Byte
wbuff1:	xra	a
	call	?bank
	ret			; end of procedure

	dseg

setaddr:			; set address
	lda	@sect		; lade sektor
	sta	sector		;
	lbcd	@trk		; lade spur
	lxi	h,0		;
divheads:			;
	lxi	d,0		; Divisor wird bei Init gesetzt
	call	divide		;
	mov	a,c		;
	sta	head		;
	shld	cylinder

	lhld	cylinder	; load cylinder in hl register
	mov	a,l		; copy lower byte
	sta	cmdfield+3	; in cmdfield
	lda	sector		; load sector
	ani	00111111b	; mask sector bits
	mov	b,a		; save sektor in b
	lda	head		; load head
	ani	00011111b	; mask head bits
	mov	c,a		; save head in b
	rrcr	h		; rotate h
	rrcr	h		;
	mov	a,h		;
	ani	11000000b	; mask upper 2 bits
	ora	b		; or sector
	sta	cmdfield+2	; save in cmdfield
	rrcr	h		; rotate h again
	mov	a,h		;
	ani	10000000b	; maske upper bit
	ora	c		; or head
	sta	cmdfield+1	; and save in cmdfield
	ret			; end of procedure

write:				; write one sector
	mvi	a,00ah		; set write command
	sta	cmdfield	; and save in cmdfield
	jr	rw		; jump to read/write procedure


read:				; read one sector
	mvi	a,008h		; set read command
	sta	cmdfield	; and save in cmdfield
	

rw:	call	setaddr		; compute address for cmdfield
	call	select		; select controller
	call	sendcmd		; send command
	lhld	@dma		; load dma address
	lda	cmdfield	; read or write
	cpi	8		;
	push	psw		; save flags
	cz	readbuffer	;
	pop	psw		;
	cnz	writebuffer	;
	call	readstatus	;
	rz			; end of procedure if no error
				;
	lda	@ermde		; Fehlermeldung vom BDOS zugelassen ?
	ora	a		;
	jrnz	rw1		;
	call	print$error	;
	lxi	h,retrytxt	;
	call	?pmsg		;
	call	ciecho		;
	cpi	'A'		;
	jrz	rw1		;
	cpi	'I'		;
	jrz	rw2		;
	jr	rw		;
rw2:	xra	a		;
	ret			;
rw1:	ori	0ffh		;
	ret			;
	


cmdfield:			; datafield for the six Omti commandbytes
		db	008h
		db	000h
		db	000h
		db	000h
		db	001h
cntlbyte	db	000h

errflag:	db	0ffh	; errorflag

cylinder	dw	0
head		db	0
sector		db	0



DIVIDE:
	;DIVIDIERT HLBC/DE
	;CARRY IST GESETZT, WENN QUOTIENT GROESSER ALS FFFF HEX
	;QUOTIENT STEHT IN HL, REST IN BC
	;BENUTZT STACK ALS ZWISCHENSPEICHER
	;
	PUSH	H
	LXI	H,1
	XTHL
	MOV	A,D	;FORM 2 COMPLEMENT OF DIVISOR	
	CMA
	MOV	D,A
	MOV	A,E
	CMA
	MOV	E,A
	INX	D
	PUSH	H
	DAD	D
	JRC	DIV1
DIV2:	POP	H
	JRC	DIV3
	RALR	C	;ROTATE HLBC 1 BIT LEFT
	RALR	B
	RALR	L
	RALR	H
	JRC	DIV4
	PUSH	H
	DAD	D
	INX	SP
	INX	SP
	JRC	DIV5
	POP	H
	DAD	H
DIV6	PUSH	H
	DCX	SP
	DCX	SP
	JR	DIV2
DIV4	DAD	D
DIV5	PUSH	H
	INX	SP
	INX	SP
	POP	H
	DAD	H
	INX	H
	JR	DIV6
DIV3	XTHL
	POP	B
	XRA	A
	RET
DIV1	POP	H
	INX	SP
	INX	SP
	RET

print$error:			; gebe Fehlermeldung der Harddisk aus
	lxi	h,etxt1		;
	call	?pmsg		;
	lxi	h,etxt2		;
	lda	cmdfield	;
	cpi	08h		;
	jrz	pe1		;
	lxi	h,etxt2		;
pe1:	call	?pmsg		;
	lxi	h,etxt4		;
	call	?pmsg		;
	lhld	cylinder	;
	call	decout		;
	lxi	h,etxt5		;
	call	?pmsg		;
	lhld	head		;
	mvi	h,0		;
	call	decout		;
	lxi	h,etxt6		;
	call	?pmsg		;
	lhld	sector		;
	mvi	h,0		;
	call	decout		;
	lxi	h,etxt7		;
	jmp	?pmsg		;

etxt1:	db	0dh,0ah,07h,'Harddisk error on ',0
etxt2:	db	'read',0
etxt3:	db	'write',0
etxt4:	db	', cylinder # ',0
etxt5:	db	' head # ',0
etxt6:	db	' sector # ',0
etxt7:	db	0dh,0ah,0
retrytxt:
	db	0dh,0ah
	db	'(R)etry / (A)bort / (I)gnore ? ',0

decout:				; gebe HL als Dezimalzahl ohne f}hrende
				; Nullen aus
	call	conv$dec	;
	jmp	?pmsg		;

CONV$DEC:			; WANDLE HL IN ASCII-DEZIMALSTRING
				; FUEHRENDE NULLEN WERDEN UNTERDRUECKT.
				; ERGEBNIS DER WANDLUNG STEHT IN DEC$STRING.
				; HL ZEIGT AUF STRINGANFANG.
				;
	PUSH	PSW		; RETTE REGISTER
	PUSH	B		;
	PUSH	D		;
	PUSH	H		;
				;
	MVI	A,' '		; VORBESETZEN DES STRINGS MIT BLANK
	MVI	B,5		;
	LXI	H,DEC$STRING	;
CONV1:	MOV	M,A		;
	INX	H		;
	DJNZ	CONV1		;
	MVI	M,0		;
				;
	POP	B		; HEXZAHL NACH BC (VORHER HL)
CONV2:	DCX	H		;
	PUSH	H		; RETTE ZEIGER
	LXI	H,0		;
	LXI	D,10		;
	CALL	DIVIDE		;
	MVI	A,'0'		; WANDLE C IN ASCII
	ADD	C		; ERGEBNIS NACH E
	MOV	E,A		; 
	PUSH	H		; QUOTIENT NACH B
	POP	B		;
	MOV	A,H		; TESTE OB ENDE DER WANDLUNG ?
	ORA	L		;
	POP	H		; ZEIGER ZURUECKLADEN
	MOV	M,E		; ASCII-ZEICHEN ABLEGEN
	JRNZ	CONV2		; SPRUNG WENN NOCH KEIN ENDE
				;
	POP	D		; LADE REGISTER BIS AUF H ZURUECK
	POP	B		;
	POP	PSW		;
	RET			; ENDE
				;
dec$string:	ds	6	;

	end


