
/*-
; * All UZI280 source code is  
; * Copyright (c) (1990-95) by Stefan Nitschke and Doug Braun
; *
; * Permission is hereby granted, free of charge, to any person obtaining a copy of this
; * software and associated documentation files (the "Software"), to deal in the Software
; * without restriction, including without limitation the rights to use, copy, modify, merge,
; * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
; * to whom the Software is furnished to do so, subject to the following conditions:
; * 
; * The above copyright notice and this permission notice shall be included in all copies or
; * substantial portions of the Software.
; * 
; * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
; * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
; * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
; * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
; * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
; * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
; * DEALINGS IN THE SOFTWARE.
; */


/************************************
chdir(dir)
char *dir;
************************************/

#define dir (char *)udata.u_argn

_chdir()
{
    register inoptr newcwd;
    inoptr n_open();
    unsigned getmode();

    ifnot (newcwd = n_open(dir,NULLINOPTR))
	return(-1);

    if (getmode(newcwd) != F_DIR)
    {
	udata.u_error = ENOTDIR;
	i_deref(newcwd);
	return(-1);
    }
	
    i_deref(udata.u_cwd);
    udata.u_cwd = newcwd;
    return(0);
}

#undef dir



/*************************************
mknod(name,mode,dev)
char *name;
int16 mode;
int16 dev;
***************************************/

#define name (char *)udata.u_argn2
#define mode (int16)udata.u_argn1
#define dev (int16)udata.u_argn

_mknod()
{
    register inoptr ino;
    inoptr parent;
    inoptr n_open();
    inoptr newfile();
    int    isdevice(),super();
    char fname[15];

    udata.u_error = 0;


/*    ifnot (super()) */

    if (ino = n_open(name,&parent))
    {
	udata.u_error = EEXIST;
	goto nogood;
    }

    ifnot (parent)
    {
	udata.u_error = ENOENT;
	return(-1);
    }

    filename(name, fname);
    ifnot (*fname && (ino = newfile(parent,fname)))
/* BUG SN 
	goto nogood2;
 !!!!*/
	goto nogood3;	/* parent inode is derefed in newfile. SN */ 

    /* Initialize mode and dev */
    ino->c_node.i_mode = mode & ~udata.u_mask;
    ino->c_node.i_addr[0] = isdevice(ino) ? dev : 0;
    setftime(ino, A_TIME|M_TIME|C_TIME);
    wr_inode(ino);

    i_deref(ino);
    return (0);

nogood:
    i_deref(ino);
nogood2:
    i_deref(parent);
nogood3:
    return (-1);
}

#undef name
#undef mode
#undef dev



/****************************************    
sync()
***************************************/

_sync()
{
    register j;
    register inoptr ino;
    register char *buf;
    char *bread();
    extern int in_casync;
	
    /* Write out modified inodes */

    for (ino=i_tab; ino < i_tab+ITABSIZE; ++ino)
	if ((ino->c_refs) > 0 && ino->c_dirty != 0)
	{
	    wr_inode(ino);
	    ino->c_dirty = 0;
	}

    /* Write out modified super blocks */
    /* This fills the rest of the super block with garbage. */

    for (j=0; j < NDEVS; ++j)
    {
	if (fs_tab[j].s_mounted == SMOUNTED && fs_tab[j].s_fmod)
	{
	    fs_tab[j].s_fmod = 0;
	    buf = bread(j, 1, 1);
	    bcopy((char *)&fs_tab[j], buf, 512);
	    bfree(buf, 2);
	}
    }

    bufsync();   /* Clear buffer pool */

    if (udata.u_insys && in_casync!=1) /* Clear cache only on system call sync */	
    	ca_sync();
}


/****************************************
access(path,mode)
char *path;
int16 mode;
****************************************/

#define path (char *)udata.u_argn1
#define mode (int16)udata.u_argn

_access()
{
    register inoptr ino;
    register int16 euid;
    register int16 egid;
    register int16 retval;
    inoptr n_open();
    char     ugetc();

    if ((mode & 07) && !ugetc(path))
    {
	udata.u_error = ENOENT;
	return (-1);
    }

    /* Temporarily make eff. id real id. */
    euid = udata.u_euid;
    egid = udata.u_egid;
    udata.u_euid = udata.u_ptab->p_uid;
    udata.u_egid = udata.u_gid;

    ifnot (ino = n_open(path,NULLINOPTR))
    {
	retval = -1;
	goto nogood;
    }
    
    retval = 0;
    if (~getperm(ino) & (mode&07))
    {
	udata.u_error = EPERM;
	retval = -1;
    }

    i_deref(ino);
nogood:
    udata.u_euid = euid;
    udata.u_egid = egid;

    return(retval);
}

#undef path
#undef mode



/*******************************************
chmod(path,mode)
char *path;
int16 mode;
*******************************************/

#define path (char *)udata.u_argn1
#define mode (int16)udata.u_argn

_chmod()
{

    inoptr ino;
    inoptr n_open();
    int    super();

    ifnot (ino = n_open(path,NULLINOPTR))
	return (-1);

    if (ino->c_node.i_uid != udata.u_euid && !super())
    {
	i_deref(ino);
	udata.u_error = EPERM;
	return(-1);
    }

    ino->c_node.i_mode = (mode & MODE_MASK) | (ino->c_node.i_mode & F_MASK);
    setftime(ino, C_TIME);
    i_deref(ino);
    return(0);
}

#undef path
#undef mode



/***********************************************
chown(path, owner, group)
char *path;
int owner;
int group;
**********************************************/

#define path (char *)udata.u_argn2
#define owner (int16)udata.u_argn1
#define group (int16)udata.u_argn

_chown()
{
    register inoptr ino;
    inoptr n_open();
    int    super();

    ifnot (ino = n_open(path,NULLINOPTR))
	return (-1);

    if (ino->c_node.i_uid != udata.u_euid && !super())
    {
	i_deref(ino);
	udata.u_error = EPERM;
	return(-1);
    }

    ino->c_node.i_uid = owner;
    ino->c_node.i_gid = group;
    setftime(ino, C_TIME);
    i_deref(ino);
    return(0);
}

#undef path
#undef owner
#undef group




/**************************************
utime(file,buf)
char *file;
char *buf;
****************************************/

#define file (char *)udata.u_argn1
#define buf (char *)udata.u_argn

_utime()
{

    register inoptr ino;
    inoptr n_open();
    int    valadr();
    	
    ifnot (valadr(buf,2*sizeof(time_t))) 
	return (-1);

    ifnot (ino = n_open(file,NULLINOPTR))
	return (-1);

    if (ino->c_node.i_uid != udata.u_euid && !super())
    {
	i_deref(ino);
	udata.u_error = EPERM;
	return(-1);
    }
    uget(buf,&(ino->c_node.i_atime),2*sizeof(time_t));
    setftime(ino, C_TIME);
    i_deref(ino);
    return(0);
}

#undef file
#undef buf





/**************************************
stat(path,buf)
char *path;
char *buf;
****************************************/

#define path (char *)udata.u_argn1
#define buf (char *)udata.u_argn

_stat()
{

    register inoptr ino;
    inoptr n_open();
    int    valadr();

    ifnot (valadr(buf,sizeof(struct stat)))
	return (-1);
    ifnot (ino = n_open(path,NULLINOPTR))
	return (-1);
    stcpy(ino,buf);
    i_deref(ino);
    return(0);
}

#undef path
#undef buf





/********************************************
fstat(fd, buf)
int16 fd;
char *buf;
********************************************/

#define fd (int16)udata.u_argn1
#define buf (char *)udata.u_argn

_fstat()
{
    register inoptr ino;
    inoptr getinode();
    int    valadr();

    ifnot (valadr(buf,sizeof(struct stat)))
	return(-1);

    if ((ino = getinode(fd)) == NULLINODE)
	return(-1);

    stcpy(ino,buf);
    return(0);
}

#undef fd
#undef buf


/* Utility for stat and fstat */
stcpy(ino, buf)
inoptr ino;
char *buf;
{
    /* violently system-dependent */
    uput((char *)&(ino->c_dev), buf, 12);
    uput((char *)&(ino->c_node.i_addr[0]), buf+12, 2);
    uput((char *)&(ino->c_node.i_size), buf+14, 16);
}



/************************************
dup(oldd)
int16 oldd;
************************************/

#define oldd (uint16)udata.u_argn

_dup()
{
    register int newd;
    inoptr getinode();
    int    uf_alloc();

    if (getinode(oldd) == NULLINODE)
	return(-1);

    if ((newd = uf_alloc()) == -1)
	return (-1);
    
    udata.u_files[newd] = udata.u_files[oldd];
    ++of_tab[udata.u_files[oldd]].o_refs;

    return(newd);
}

#undef oldd



/****************************************
dup2(oldd, newd)
int16 oldd;
int16 newd;
****************************************/

#define oldd (int16)udata.u_argn1
#define newd (int16)udata.u_argn

_dup2()
{
    inoptr getinode();

    if (getinode(oldd) == NULLINODE)
	return(-1);

    if (newd < 0 || newd >= UFTSIZE)
    {
	udata.u_error = EBADF;
	return (-1);
    }
    
    ifnot (udata.u_files[newd] & 0x80)
	doclose(newd);
    
    udata.u_files[newd] = udata.u_files[oldd];
    ++of_tab[udata.u_files[oldd]].o_refs;

    return(0);
}

#undef oldd
#undef newd



/**************************************
umask(mask)
int mask;
*************************************/

#define mask (int16)udata.u_argn

_umask()
{
    register int omask;

    omask = udata.u_mask;
    udata.u_mask = mask & 0777;
    return(omask);
}

#undef mask



/* Special system call returns super-block of given
filesystem for users to determine free space, etc.
Should be replaced with a sync() followed by a read
of block 1 of the device.  */

/***********************************************
getfsys(dev,buf)
int16 dev;
struct filesys *buf;
**************************************************/

#define dev (int16)udata.u_argn1
#define buf (struct filesys *)udata.u_argn

_getfsys()
{
   if (dev < 0 || dev >= NDEVS || fs_tab[dev].s_mounted != SMOUNTED)
   {
       udata.u_error = ENXIO;
       return(-1);
    }

    uput((char *)&fs_tab[dev],(char *)buf,sizeof(struct filesys));
    return(0);
}

#undef dev
#undef buf



/****************************************
ioctl(fd, request, data)
int fd;
int request;
char *data;
*******************************************/

#define fd (int)udata.u_argn2
#define request (int)udata.u_argn1
#define data (char *)udata.u_argn

_ioctl()
{

    register inoptr ino;
    register int dev;
    inoptr getinode();
    int   isdevice(),getperm(),d_ioctl();

    if ((ino = getinode(fd)) == NULLINODE)
	return(-1);

    ifnot (isdevice(ino))
    {
	udata.u_error = ENOTTY;
	return(-1);
    }

    ifnot (getperm(ino) & OTH_WR)
    {
	udata.u_error = EPERM;
	return(-1);
    }

    dev = ino->c_node.i_addr[0];

    if (d_ioctl(dev, request,data))
	return(-1);
    return(0);
}

#undef fd
#undef request
#undef data



/* This implementation of mount ignores the rwflag */

/*****************************************
mount(spec, dir, rwflag)
char *spec;
char *dir;
int rwflag;
*******************************************/

#define spec (char *)udata.u_argn2
#define dir (char *)udata.u_argn1
#define rwflag (int)udata.u_argn

_mount()
{
    register inoptr sino, dino;
    register int dev;
    inoptr n_open();
    int    d_open(),fmount(),super();
    unsigned  getmode();

    ifnot(super())
    {
	udata.u_error = EPERM;
	return (-1);
    }

    ifnot (sino = n_open(spec,NULLINOPTR))
	return (-1);

    ifnot (dino = n_open(dir,NULLINOPTR))
    {
	i_deref(sino);
	return (-1);
    }

    if (getmode(sino) != F_BDEV)
    {
	udata.u_error = ENOTBLK;
	goto nogood;
    }

    if (getmode(dino) != F_DIR)
    {
	udata.u_error = ENOTDIR;
	goto nogood;
    }

    dev = (int)sino->c_node.i_addr[0];

    if ( dev >= NDEVS || d_open(dev))
    {
	udata.u_error = ENXIO;
	goto nogood;
    }

    if (fs_tab[dev].s_mounted || dino->c_refs != 1 || dino->c_num == ROOTINODE)
    {
       udata.u_error = EBUSY;
       goto nogood;
    }

    _sync();

    if (fmount(dev,dino))
    {
       udata.u_error = EBUSY;
       goto nogood;
    }

    i_deref(dino);
    i_deref(sino);
    return(0);

nogood:
    i_deref(dino);
    i_deref(sino);
    return (-1);
}

#undef spec
#undef dir
#undef rwflag



/******************************************
umount(spec)
char *spec;
******************************************/

#define spec (char *)udata.u_argn

_umount()
{
    register inoptr sino;
    register int dev;
    register inoptr ptr;
    inoptr n_open();
    int    super(),validdev();
    unsigned getmode();
    extern	int in_casync;
	
    ifnot(super())
    {
	udata.u_error = EPERM;
	return (-1);
    }

    ifnot (sino = n_open(spec,NULLINOPTR))
	return (-1);

    if (getmode(sino) != F_BDEV)
    {
	udata.u_error = ENOTBLK;
	goto nogood;
    }

    dev = (int)sino->c_node.i_addr[0];
    ifnot (validdev(dev))
    {
	udata.u_error = ENXIO;
	goto nogood;
    }

    if (!fs_tab[dev].s_mounted)
    {
	udata.u_error = EINVAL;
	goto nogood;
    }

    for (ptr = i_tab; ptr < i_tab+ITABSIZE; ++ptr)
	if (ptr->c_refs > 0 && ptr->c_dev == dev)
	{
	    udata.u_error = EBUSY;
	    goto nogood;
	}

    _sync();

    fs_tab[dev].s_mounted = 0;
    i_deref(fs_tab[dev].s_mntpt);
    i_deref(sino);
    return(0);

nogood:
    i_deref(sino);
    return (-1);
}

#undef spec
