
#asm
; startup file for UZI280
	psect	text,global,pure
	psect	data,global
	psect	bss,global

	psect	text
	defs	100h		;Base of UZI280 program and data space

	global	start,_main,_exit,__brk,__Hbss,__Lbss,_environ

; on return from the uzi kernel the stack looks like the following:
;
;	stack+4 ->	start of environ
;	stack+2 ->	argc
;sp->	stack	->	pointer	to argv
;
start:  jp	1f		; jp to indicate uzi binary type 1

1:	ld	hl,__Hbss
	push	hl
	call	__brk		; do system call to precisely set break 
	pop	hl
; zero out bss segment 
	or	a
	ld	de,__Lbss
	sbc	hl,de	; calc length
	ld	b,h
	ld	c,l
	dec	bc
	ld	hl,__Lbss
	ld	(hl),0	; zero out __Lbss
	inc	de
	ldir		; do it
 
	ld	hl,4
	add	hl,sp		; pointer to first element of enviroment
	ld	(_environ),hl	; save the pointer
	pop	hl
	pop	de
	push	hl
	push	de		; shuffle argv pointer and argc 
	call	_main		; main(argc,argv)
	push	hl
02:	call	_exit		; give return val of main to exit
; should never be reached
	jr	02b

#endasm
