
/*-
; * All UZI280 source code is  
; * Copyright (c) (1990-95) by Stefan Nitschke and Doug Braun
; *
; * Permission is hereby granted, free of charge, to any person obtaining a copy of this
; * software and associated documentation files (the "Software"), to deal in the Software
; * without restriction, including without limitation the rights to use, copy, modify, merge,
; * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
; * to whom the Software is furnished to do so, subject to the following conditions:
; * 
; * The above copyright notice and this permission notice shall be included in all copies or
; * substantial portions of the Software.
; * 
; * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
; * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
; * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
; * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
; * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
; * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
; * DEALINGS IN THE SOFTWARE.
; */


/*
	UZI280 config.h  vers 1.02a
*/

/* choose your memory configuration */
#define MB2		/* more than 2 MB RAM not used in this verion */
/*#define MB1*/

/* Config for REH-CPU280 with 1 or 2Mbyte RAM 
2 MB :
   has   1.5M byte 	process space (64Kbyte used by kernel) 
   and   0.5M byte      read/write cache
1 MB :
   has   768 Kbyte 	process space (64Kbyte used by kernel) 
   and   232 Kbyte      read/write cache
*/	

/* 
  Terminal setting (ECB-bus terminals). Undef both for general serial
  terminal I/O only. 
  Note: 
  	With a bus terminal connected the UART serial line
	drives a second terminal.

  For adaption of other bus terminals take a look at
   _putc() in devtty.c and _pull_tty in devttyas.c.
*/ 
#define CLUB80_Terminal		/* this Terminal has virtuel console
				   and tektonix graphic capacity */
/*#define REH_HGT 		/* For RehDesign HGT terminal    */

/* 
  Define if terminal can't generate an interrupt on char input I/O.
  If undefined take a look into the file devttyas.c for interrupt
  handler routine.
*/  
#define no_tty_interrupt



#ifdef CLUB80_Terminal
#undef  no_bus_tty 
#undef no_tty_interrupt
#define BOOT_TTY 6		/* 4 text terminals and one graphic screen */
#define _WIN_SYS_		/* on the club80 terminal */	
#else
#undef _WIN_SYS_
#ifdef REH_HGT			
#undef  no_bus_tty
#define BOOT_TTY 6
#else /* no bus terminal */  
#define no_bus_tty
#define BOOT_TTY 13		/* only one serial TTY controlled by */
#endif /*REH_HGT*/				/* the cpu uart */
#endif /*CLUB80_Terminal*/


/* Remake devio.c when this is changed */
#ifdef STEFAN

extern dev_tab[];

#endif

#ifdef DEVIO

extern wd_open(), wd_read(),wd_write();
extern fd_open(), fd_read(),fd_write();
extern tty_open(), tty_close(), tty_read(),tty_write(), tty_ioctl();
extern lpr_open(), lpr_close(), lpr_write();
extern kmem_read(),kmem_write();
extern mt_read(), mt_write(), mt_open(), mt_close();
extern null_write();


static struct devsw dev_tab[] =  /* The device driver switch table */
{
    { 0, wd_open, ok,       wd_read, wd_write, nogood },	/* 0 */	
    { 0, fd_open, ok,       fd_read, fd_write, nogood },	/* 1 floppy */
    { 1, wd_open, ok,       wd_read, wd_write, nogood },
    { 2, wd_open, ok,       wd_read, wd_write, nogood },	/* 3 Swap */
    { 0, lpr_open, lpr_close, nogood, lpr_write, nogood},	/* 4 printer */
    { 0, tty_open, tty_close, tty_read, tty_write, tty_ioctl }, /* 5 tty */
    { 1, tty_open, tty_close, tty_read, tty_write, tty_ioctl }, /* 6 tty1 */
    { 2, tty_open, tty_close, tty_read, tty_write, tty_ioctl }, /* 7 tty2 */
    { 0, ok, ok, ok, null_write, nogood },			/* 8 null */
    { 0, ok, ok, kmem_read, kmem_write, nogood },		/* 9 kmem */
    { 0, mt_open, mt_close, mt_read, mt_write, nogood },
    { 3, tty_open, tty_close, tty_read, tty_write, tty_ioctl }, /* 11 tty3 */
    { 4, tty_open, tty_close, tty_read, tty_write, tty_ioctl }, /* 12 tty4 */
    { 5, tty_open, tty_close, tty_read, tty_write, tty_ioctl },	/* 13 tty5(UART)*/
    { 6, tty_open, tty_close, tty_read, tty_write, tty_ioctl }	/* 14 tty6 */
};

#endif

#ifndef CACHE

#define NDEVS   4    /* Devices 0..NDEVS-1 are capable of being mounted */
#define TTYDEV  BOOT_TTY    /* Device used by kernel for messages, panics */
		     /* Also initial process controlling tty */
#define SWAPDEV 3    /* Device for swapping. (not implemented) */
#define NBUFS  38    /* Number of block buffers ( 20KByte ). Must be
			at least 8 more than number of process tables (30) */

#endif

#ifdef MACHDEP2
/* some system variables for command ps. */
unsigned ptab_pointer=0;
unsigned number_of_pages=0;
unsigned proc_tab_size=PTABSIZE;
unsigned reserved_1=0;
unsigned reserved_2=0;
/* adress tables for virtuel user-ram management */ 
struct pg_descr pgtab[] = {
	0x8000, 0, 0,
	0x8020, 0, 0,
	0x8040, 0, 0,
	0x8060, 0, 0,
	0x8080, 0, 0,
	0x80a0, 0, 0,
	0x80c0, 0, 0,
	0x80e0, 0, 0,
        0x8200, 0, 0,   
	0x8220, 0, 0,
	0x8240, 0, 0,
	0x8260, 0, 0,
	0x8280, 0, 0,
	0x82a0, 0, 0,
	0x82c0, 0, 0,
	0x82e0, 0, 0,
	0x8300, 0, 0,
	0x8320, 0, 0,
	0x8340, 0, 0,
	0x8360, 0, 0,
	0x8380, 0, 0,
	0x83a0, 0, 0,
	0x83c0, 0, 0,
	0x83e0, 0, 0,
	0x8400, 0, 0,
	0x8420, 0, 0,
	0x8440, 0, 0,
	0x8460, 0, 0,
	0x8480, 0, 0,
	0x84a0, 0, 0,
	0x84c0, 0, 0,
	0x84e0, 0, 0,
	0x8500, 0, 0,
	0x8520, 0, 0,
	0x8540, 0, 0,
	0x8560, 0, 0,
	0x8580, 0, 0,
	0x85a0, 0, 0,
	0x85c0, 0, 0,
	0x85e0, 0, 0,
	0x8600, 0, 0,
	0x8620, 0, 0,
	0x8640, 0, 0,
	0x8660, 0, 0,
	0x8680, 0, 0,
	0x86a0, 0, 0,
	0x86c0, 0, 0,
	0x86e0, 0, 0,
	0x8700, 0, 0,
	0x8720, 0, 0,
	0x8740, 0, 0,
	0x8760, 0, 0,
	0x8780, 0, 0,
	0x87a0, 0, 0,
	0x87c0, 0, 0,
	0x87e0, 0, 0,
	0x8800, 0, 0,
	0x8820, 0, 0,
	0x8840, 0, 0,
	0x8860, 0, 0,
	0x8880, 0, 0,
	0x88a0, 0, 0,
	0x88c0, 0, 0,
	0x88e0, 0, 0,
	0x8900, 0, 0,
	0x8920, 0, 0,
	0x8940, 0, 0,
	0x8960, 0, 0,
	0x8980, 0, 0,
	0x89a0, 0, 0,
	0x89c0, 0, 0,
	0x89e0, 0, 0,
	0x8a00, 0, 0,
	0x8a20, 0, 0,
	0x8a40, 0, 0,
	0x8a60, 0, 0,
	0x8a80, 0, 0,
	0x8aa0, 0, 0,
	0x8ac0, 0, 0,
	0x8ae0, 0, 0,
	0x8b00, 0, 0,
	0x8b20, 0, 0,
	0x8b40, 0, 0,
	0x8b60, 0, 0,
	0x8b80, 0, 0,
	0x8ba0, 0, 0,
	0x8bc0, 0, 0,

#ifdef MB1
	0x8be0, 0, 0
};
#endif

#ifdef MB2
	0x8be0, 0, 0,
	0x8c00, 0, 0,
	0x8c20, 0, 0,
	0x8c40, 0, 0,
	0x8c60, 0, 0,
	0x8c80, 0, 0,
	0x8ca0, 0, 0,
	0x8cc0, 0, 0,
	0x8ce0, 0, 0,
	0x8d00, 0, 0,
	0x8d20, 0, 0,
	0x8d40, 0, 0,
	0x8d60, 0, 0,
	0x8d80, 0, 0,
	0x8da0, 0, 0,
	0x8dc0, 0, 0,
	0x8de0, 0, 0,
	0x8e00, 0, 0,
	0x8e20, 0, 0,
	0x8e40, 0, 0,
	0x8e60, 0, 0,
	0x8e80, 0, 0,
	0x8ea0, 0, 0,
	0x8ec0, 0, 0,
	0x8ee0, 0, 0,
	0x8f00, 0, 0,
	0x8f20, 0, 0,
	0x8f40, 0, 0,
	0x8f60, 0, 0,
	0x8f80, 0, 0,
	0x8fa0, 0, 0,
	0x8fc0, 0, 0,
	0x8fe0, 0, 0,
	0x9000, 0, 0,
	0x9020, 0, 0,
	0x9040, 0, 0,
	0x9060, 0, 0,
	0x9080, 0, 0,
	0x90a0, 0, 0,
	0x90c0, 0, 0,
	0x90e0, 0, 0,
	0x9100, 0, 0,
	0x9120, 0, 0,
	0x9140, 0, 0,
	0x9160, 0, 0,
	0x9180, 0, 0,
	0x91a0, 0, 0,
	0x91c0, 0, 0,
	0x91e0, 0, 0,
        0x9200, 0, 0,   
	0x9220, 0, 0,
	0x9240, 0, 0,
	0x9260, 0, 0,
	0x9280, 0, 0,
	0x92a0, 0, 0,
	0x92c0, 0, 0,
	0x92e0, 0, 0,
	0x9300, 0, 0,
	0x9320, 0, 0,
	0x9340, 0, 0,
	0x9360, 0, 0,
	0x9380, 0, 0,
	0x93a0, 0, 0,
	0x93c0, 0, 0,
	0x93e0, 0, 0,
	0x9400, 0, 0,
	0x9420, 0, 0,
	0x9440, 0, 0,
	0x9460, 0, 0,
	0x9480, 0, 0,
	0x94a0, 0, 0,
	0x94c0, 0, 0,
	0x94e0, 0, 0,
	0x9500, 0, 0,
	0x9520, 0, 0,
	0x9540, 0, 0,
	0x9560, 0, 0,
	0x9580, 0, 0,
	0x95a0, 0, 0,
	0x95c0, 0, 0,
	0x95e0, 0, 0,
	0x9600, 0, 0,
	0x9620, 0, 0,
	0x9640, 0, 0,
	0x9660, 0, 0,
	0x9680, 0, 0,
	0x96a0, 0, 0,
	0x96c0, 0, 0,
	0x96e0, 0, 0,
	0x9700, 0, 0,
	0x9720, 0, 0,
	0x9740, 0, 0,
	0x9760, 0, 0,
	0x9780, 0, 0,
	0x97a0, 0, 0,
	0x97c0, 0, 0,
	0x97e0, 0, 0
};
#endif /* 2MB */

int npages = sizeof(pgtab) / sizeof(struct pg_descr);


#endif


#ifdef CACHE

/* 
   read cache from mem. adr. 980000h to 9fffffh (model 2MB)
   or 			     8c0000h to 8fffffh (  "   1MB)
*/

#ifdef MB1
#define C_Start (0x8C00)
#define max_cache  ((0x8ff-0x8C0)*8) 
#endif

#ifdef MB2
#define C_Start (0x9800)
#define max_cache  ((0x9ff-0x980)*8) /* 1016 */
#endif

struct ca_buf cach_buf[max_cache];

#endif /* cache */
