program Out_Jump_Check;

(* 300391 Tilmann Reh *)

const signon = ^m^j'OUT/JMP-Tester V1.0  TR 300391'^m^j;

(* Dieses Programm sucht in CP/M-Programmen (.COM) nach Befehlssequenzen
aus einem Output-Befehl und einem 'Program Flow Change' Befehl (zB CALL/JMP).

Laut Errata Sheet zum Z280 koennen Fehler auftreten, wenn nach einem
'external write with wait states' ein Befehl ausgefuehrt wird, der die
Pipeline des Prozessors loescht. Bei der CPU280 ist Erstgenanntes nur bei
I/O-Write (d.h. OUT) moeglich. Ausser bei CALL und JMP wird die Pipeline
auch bei PCACHE und LDCTL geloescht, wobei LDCTL privilegiert ist und
daher hier nicht ueberprueft werden muss (kommt nur im BIOS vor). RETurn-
Befehle sind bei externem Stack (also bei der CPU280 generell) unkritisch.

Das Programm OUTJMP untersucht Dateien auf das Auftreten solcher 'verbotenen'
Sequenzen und zeigt diese sowie deren Adresslage an. Zu untersuchen sind
nur Programme mit direkter I/O-Ansteuerung, also i.A. Programmiersoftware
fuer EPROMs/PALs und dergleichen sowie Kommunikationsprogramme. Nicht alle
angezeigten Sequenzen muessen tatsaechlich die entsprechenden Befehle
darstellen (es koennen z.B. Datenfelder fehlinterpretiert worden sein).

Werden Sequenzen gefunden, so ist zunaechst zu pruefen, ob sie richtig
interpretiert wurden. Ist dies der Fall, sollte das Programm derart
gepatcht werden, dass zwischen den beiden Befehlen mindestens ein
'normaler' Befehl, am besten ein IN-Befehl, ausgefuehrt wird. In den
meisten Faellen wird dies nur durch Auslagern der Sequenz in ein Mini-
Unterprogramm moeglich sein. *)

(* Tabellen aller denkbaren OUT-Befehle (ausser D3xx) *)

type  bs       = set of byte;
const out_ed   : bs = [$41,$49,$51,$59,$61,$69,$79,$83,
                       $8B,$93,$9B,$A3,$AB,$B3,$BB,$BF];
      out_dd   : bs = [$49,$51,$59,$61,$69];
      out_dd_n : bs = [$41,$79];
      out_fd   : bs = [$61,$69];
      out_fd_n : bs = [$41,$49,$51,$59];

(* Tabellen aller denkbaren CALL/JUMP-Befehle (ausser E9) *)

      calljump : bs = [$CD,$C4,$CC,$D4,$DC,$E4,$EC,$F4,$FC,
                       $C3,$C2,$CA,$D2,$DA,$E2,$EA,$F2,$FA];
      cj_dd    : bs = [$CD,$C4,$CC,$D4,$DC,$E4,$EC,$F4,$FC,
                       $C2,$CA,$D2,$DA,$E2,$EA,$F2,$FA];
      jumprel  : bs = [$10,$18,$20,$28,$30,$38];
      jafjar   : bs = [$20,$28];

(* vorbelegte Variablen *)

      start    : integer = $100;  (* Startadresse *)
      ende     : integer = 1023;  (* letzes zu untersuchendes Byte *)

(* Variablen des Programms *)

var filnam     : string[20];
    f          : file;
    buf        : array[0..1151] of byte;  (* 9 records *)
    i,j,secs   : integer;

(* Ausgabe von Bytes und Worten hexadezimal *)

procedure hex_byte(b:byte);
const nyb : array[0..15] of char = '0123456789ABCDEF';
begin
  write(nyb[b shr 4],nyb[b and 15]);
  end;

procedure hex_word(w:integer);
begin hex_byte(hi(w)); hex_byte(lo(w)); end;

(* ALARM: Ausgabe von Adresse und Objektcode der gefundenen Sequenz *)

procedure alarm(laenge:integer);
var x : integer;
begin
  if eof(f) and (pred(j+laenge)>ende) then
    if j<=ende then write('begonnene ') else exit;
  write('Sequenz bei '); hex_word(i+start);
  write(' :');
  for x:=i to pred(j) do begin write(' '); hex_byte(buf[x]); end;
  write(' -');
  for x:=j to pred(j+laenge) do begin write(' '); hex_byte(buf[x]); end;
  writeln;
  end;

(*--------- MAIN ----------*)

begin
  writeln(signon);
  if paramcount=0 then begin
    writeln('Aufruf: OUTJMP filename (Default Extension .COM)');
    halt; end;
  filnam:=paramstr(1);
  i:=pos('.',filnam); if i=0 then filnam:=filnam+'.COM';
  assign(f,filnam);
  {$I-} reset(f); {$I+}
  if ioresult<>0 then begin
    writeln('Datei ',filnam,' kann nicht ge|ffnet werden!');
    halt; end;

  blockread(f,buf,9,secs);
  if secs<8 then ende:=pred(secs shl 7);
  repeat
    for i:=0 to ende do begin
      j:=-1;
      if buf[i]=$D3 then j:=i+2 else
      if (buf[i]=$ED) and (buf[succ(i)] in out_ed) then j:=i+2 else
      if (buf[i]=$DD) and (buf[succ(i)]=$ED) then begin
        if (buf[i+2] in out_dd) then j:=i+3 else
        if (buf[i+2] in out_dd_n) then j:=i+5 end else
      if (buf[i]=$FD) and (buf[succ(i)]=$ED) then begin
        if (buf[i+2] in out_fd) then j:=i+3 else
        if (buf[i+2] in out_fd_n) then j:=i+5 end;
      if j>=0 then begin
        if buf[j] in calljump then alarm(3) else
        if buf[j] in jumprel then alarm(2) else
        if buf[j]=$E9 then alarm(1) else
        if (buf[j] and $DF=$DD) and (buf[succ(j)]=$E9) then alarm(2) else
        if (buf[j]=$FD) and (buf[succ(j)] in calljump) then alarm(4) else
        if (buf[j]=$DD) then begin
          if buf[succ(j)] in cj_dd then alarm(2) else
          if buf[succ(j)] in jafjar then alarm(3) end else
        if (buf[j]=$ED) and (buf[succ(j)]=$65) then alarm(2);
        end;
      end;
    move(buf[1024],buf[0],128);
    blockread(f,buf[128],8,secs);
    if secs<7 then ende:=127+(secs shl 7) else ende:=1023;
    start:=start+1024;
  until ende<128;
  end.
