;	TITLE	'TVC-80 Firmware  V1.0'
;	NAME	TVC80
;* * * * * * * * * * * * * * * * * * * *
;*                          3 Sep 1983 *
;* TITLE:     TVC80                    *
;*                                     *
;* FIRMWARE FOR A Z-80 BASED VIDEO     *
;* DISPLAY BOARD. EITHER 16 X 64, OR   *
;* 24 X 80 DISPLAY MODES AVAILABLE     *
;* firmware:K7PF - comments:BIG HALO   *
;*         	                       *
;* * * * * * * * * * * * * * * * * * * *
;
;  The code in this program is designed to be burned into a 2732A
;  EPROM that resides in  U20  of the TVC-80 Video Board designed
;  by Phil K7PF to replace the TVC-64 Board in a Digital Group
;  Microcomputer (Z80 based). TheTVC-80 Board uses a TMS 9937 VTAC
;  chip to provide the video display together with a character
;  memory loaded by the Z80 and a user programable Character ROM.
;
;  The code runs in the on-board Z80 which accepts characters from
;  the Main CPU as 8 bit bytes and displays them in either a 64x16
;  or 80x24 format.  Characters with the Most Significant Bit (MSB)
;  reset (i.e. zero) are interpreted by this code as commands. If
;  the MSB is set (to one) the character is interpreted as as though
;  it were output to a terminal.  This code includes (user selectable)
;  simulations of the Digital Group TVC-64, the Televideo 950, the
;  Lear Siegler ADM3A, and the Zenith/Heath H19 Terminals with
;  their respective <esc> sequences.
;
;  The TVC-80 has hardware support for Half/Full Brightness, up to
;  four (user selectable -by software in the Main CPU) character
;  fonts, blinking/continuous cursor that is displayed by either
;  an underline or a solid block and that may be turned on or off.
;  The TVC-80 may also be set into a Slow mode where the on-board
;  Z80 is put into wait except during the Vertical Retrace so that
;  there is no memory conflict between the VTAC and the Z80. This
;  makes the display run slower but gives a very clean display.
;
; EQUATES:
;		    TVC-80 HARDWARE DEFINED ADDRESSES
POWRUP	EQU	0000H	;CONTROL VECTORED HERE ON POWER-ON OR RESET
INTRUP	EQU	0038H	;CONTROL HERE ON INTERRUPT (CHAR IN FROM
;				MAIN CPU)
RAMSTR	EQU	8000H	;FIRST LOCATION OF CHARACTER RAM
;		    INPUT/OUTPUT PORTS
CWAIT	EQU	10H	;CLEAR the WAIT latch to the MAIN CPU
WPARM	EQU	20H	;WRITE the PARAMETER latch
ICHAR	EQU	30H	;READ the input character
;
VTR0	EQU	80H		;VTAC REGISTERS
VTR1	EQU	VTR0+1
VTR2	EQU	VTR0+2
VTR3	EQU	VTR0+3
VTR4	EQU	VTR0+4
VTR5	EQU	VTR0+5
VTR6	EQU	VTR0+6
VTRS	EQU	VTR0+0AH	;VTAC RESET
CCOL	EQU	VTR0+0CH	;curs COL
CROW	EQU	VTR0+0DH	;curs ROW
VTCH	EQU	VTR0+0EH	;start TCHAIN
;
ST80	EQU	RAMSTR+0H	;start 24x80 DSPLY
ST64	EQU	RAMSTR+208H	;start 16x64 DSPLY
TADDR	EQU	RAMSTR+0F70H	;save term addr
CURPOS	EQU	RAMSTR+0F72H	;save (DE) cursor position
STACK	EQU	RAMSTR+1000H	;top of RAM
;
MPSP	EQU	0A0H	;ASCII SP (mark PARITY)
PARM64	EQU	60H	;init VAL for 64 PARM latch
PARM80	EQU	0EEH	;init VAL for 80 PARM latch
PARM81	EQU	0EEH	;H-19
SOP64	EQU	82H	;1st LINE (64)
EOP64	EQU	8AH	;last+1 (64)
SOL64	EQU	08H	;1st COL (64)
EOL64	EQU	48H	;last COL (64)
EOL80	EQU	50H	;last COL (80)
SOP80	EQU	80H	;1st LINE (80)
EOP80	EQU	8CH	;last+1 (80)
	.Z80
	ASEG
;
	ORG	POWRUP		;RESTART/RESET
;
	DI
	IM	1		;Z80 MODE 1
	LD	HL,STAB		;SETUP TABLE
	LD	B,(HL)		;..FOR VTAC
SETUP:	INC	HL
	LD	C,(HL)		;PORT#
	INC	HL
	LD	A,(HL)		;DATA
	OUT	(C),A		;  OUT
	DJNZ	SETUP
;
	LD	SP,STACK
	CALL	CLEAR		;clr screen
	LD	IX,MHLT		;MASTER HALT ADDR
	LD	IY,OPR64	;default to 64 mode
	LD	HL,ST64
	LD	BC,40H		;64 MODE OFFST
	LD	A,PARM64	;default 64..
	OUT	(WPARM),A	;..mode PARM
	EX	AF,AF'		;..SAVED
;
MHLT:	OUT	(CWAIT),A	;master HALT..
	EI			;..for all
	HALT			;..firmware
	DB	0FFH		;insure D7-D0 high at HALT
;
; INTERRUPT SERVICE FOR PORT 0 WRITE TO TVC-80 CARD
;
	ORG	INTRUP		;interupt mode 1 address
;
	LD	SP,STACK	;FIX STACK
	PUSH	IX		;SAVE MHLT ADDR
	IN	A,(ICHAR)	;get char
	BIT	7,A		;TVC-80 cmd?
	JR	Z,CNTRL		;yes
	JP	(IY)		;go to the selected emulation
;
; all "space" parity TVC-80 inputs are processed here
;
CNTRL:	OR	A		;null?
	RET	Z		;no operation
	CP	1H		;64 MODE FS?
	JP	Z,FS64		;one space advance
	CP	2H		;64 MODE BS?
	JP	Z,BS64		;one space back
	CP	7FH		;64 MODE HOME?
	JP	Z,HM64		;home the write position
	CP	3H		;SLOW MODE?
	JP	Z,SLOW		;Z-80 runs only during retrace
	CP	4H		;FAST MODE?
	JP	Z,FAST		;Z-80 runs anytime
	CP	5H		;FONT#2?
	JP	Z,FONT2
	CP	6H		;FONT#3?
	JP	Z,FONT3
	CP	16H		;HALF BR ON?
	JP	Z,HBRON
	CP	17H		;HALF BR OFF?
	JP	Z,HBROF
	CP	10H		;CURSOR ON?
	JP	Z,CURSON
	CP	11H		;CURSOR OFF?
	JP	Z,CURSOF
	CP	12H		;CURSOR BLINK?
	JP	Z,BLINK
	CP	13H		;CURSOR STEADY?
	JP	Z,STEDY
	CP	14H		;BLOCK CURS?
	JP	Z,BLOCK
	CP	15H		;UNDERLINE CURS?
	JP	Z,ULINE
	CP	30H		;enter TEST MODE?
	JP	Z,TVCTST
	CP	64D		;16X64 MODE?
	JP	Z,CTR64
	CP	80D		;ADM-3A or TV-950 TERM?
	JP	Z,CTR80
	CP	81D		;H-19 TERM?
	JP	Z,CTR81
	RET			;HALT: unused TVC-80 command
;
;
SLOW:	EX	AF,AF'		;get stored PARM data
	SET	7,A
	OUT	(WPARM),A
	EX	AF,AF'
	RET
;
FAST:	EX	AF,AF'
	RES	7,A
	OUT	(WPARM),A
	EX	AF,AF'
	RET
;
FONT2:	EX	AF,AF'
	RES	4,A
	OUT	(WPARM),A
	EX	AF,AF'
	RET
;
FONT3:	EX	AF,AF'
	SET	4,A
	OUT	(WPARM),A
	EX	AF,AF'
	RET
;
HBRON:	EX	AF,AF'		;turn on half brightness
	SET	3,A
	OUT	(WPARM),A
	EX	AF,AF'
	RET
;
HBROF:	EX	AF,AF'		;disable half brightness
	RES	3,A
	OUT	(WPARM),A
	EX	AF,AF'
	RET
;
CURSON:	EX	AF,AF'		;enable cursor display
	SET	2,A
	OUT	(WPARM),A
	EX	AF,AF'
	RET
;
CURSOF:	EX	AF,AF'		;blank out (turn off) cursor
	RES	2,A
	OUT	(WPARM),A
	EX	AF,AF'
	RET
;
BLINK:	EX	AF,AF'		;set cursor blinking
	SET	1,A
	OUT	(WPARM),A
	EX	AF,AF'
	RET
;
STEDY:	EX	AF,AF'		;set cursor continously on
	RES	1,A
	OUT	(WPARM),A
	EX	AF,AF'
	RET
;
BLOCK:	EX	AF,AF'		;set cursor to be solid block
	RES	0,A
	OUT	(WPARM),A
	EX	AF,AF'
	RET
;
ULINE:	EX 	AF,AF'		;set cursor as Underline
	SET	0,A
	OUT	(WPARM),A
	EX	AF,AF'
	RET
;
CTR64:	JP	POWRUP		;restart 16x64 mode
;
CTR80:	LD	A,PARM80	;PARM DATA..
	OUT	(WPARM),A	;..TO LATCH
	EX 	AF,AF'		;..& save in alt A reg
	LD	IY,OPR80	;ADM-3A/TV-950 TERM ADDR
	JP	CTR8X
;
CTR81:	LD	A,PARM81	;same as above..
	OUT	(WPARM),A	;..except for an
	EX	AF,AF'		;..H-19 terminal
	LD	IY,OPR81
;
CTR8X:	LD	(TADDR),IY	;save TERM emulation addr
CSHOM:	CALL	CLEAR
	XOR	A
	LD	D,A		;CURS ROW
	OUT	(CROW),A
	LD	E,A		;CURS COL
	INC	A		;MOVE RIGHT
	OUT	(CCOL),A
	LD	HL,ST80		;INIT WRT PTR
	LD	A,23D
	LD	B,A		;LAST LINE..
	OUT	(VTR6),A	;.. DISPLAYED
	RET			;HALT
;
; 16x64 native mode - emulates TVC-64 hardware card
;
OPR64:	OUT	(CWAIT),A	;clr WAIT
	LD	(HL),A
FS64:	INC	HL
	LD	A,L
	AND	7FH
	CP	EOL64
	RET	NZ		;HALT
	ADD	HL,BC		;nxt line
	LD	A,H
	CP	EOP64		;>16 LINES?
	RET	NZ		;if so, HALT
	LD	H,SOP64
	RET			;HALT
;
BS64:	DEC	HL
	LD	A,L
	AND	7FH
	CP	SOL64-1
	RET	NZ		;HALT?
	SBC	HL,BC		;LAST LINE
	LD	A,H
	CP	SOP64-1
	RET	NZ		;HALT?
	LD	H,EOP64-1	;WRAP
	RET			;HALT!
;
HM64:	LD	HL,ST64		;home write position
	RET
;
; 24x80 modes - '80 emulates ADM-3A and TV-950 terminals
;               '81 emulates a Heath/Zenith  H-19 terminal
;
OPR80:	CP	MPSP		;check input character
	JR	C,VCS80		;NON PRINTING
	LD	(HL),A		;DISPLAY
FS80:	INC	E		;CURS COL
	LD	A,E
	CP	EOL80		;EOL?
	JP	Z,LFCR
	INC	A
	OUT	(CCOL),A	;MOVE CURSOR
	INC	HL		;MOVE WRT PTR
	RET			;HALT
;
O80HI:	CP	MPSP		;HALF-INT ENTRY FOR ADM-3A & TV-950
	JR	C,VCS80		;if CTRL CHAR
	RES	7,A		;clear PARITY
	LD	(HL),A		;to DSPLY RAM
	JP	FS80
;
; control codes for ADM-3A and TV-950
;
VCS80:	CP	8AH		;LF?
	JP	Z,LFED
	CP	8DH		;CR?
	JP	Z,CRET
	CP	88H		;BS?
	JP	Z,BSPC		;backspace
	CP	89H		;CTL-I?
	JP	Z,TAB8		;nxt tab pos
	CP	8BH		;CTL-K?
	JP	Z,UCUR		;cursor up one line
	CP	8CH		;CTL-L?
	JP	Z,FS80		;cursor right one space
	CP	96H		;CTL-V?
	JP	Z,DCUR		;cursor down one line
	CP	97H		;CTL-W?
	JP	Z,CEOP		;clear to end of page
	CP	98H		;CTL-X?
	JP	Z,CEOL		;clear to end of line
	CP	9AH		;CTL-Z?
	JP	Z,CSHOM		;clear screen & home cursor
	CP	9EH		;CTL-^? (HOME)
	JP	Z,HCUR		;home the cursor
	CP	9BH		;ESC?
	RET	NZ		;unused CTL CODE
	LD	IY,EPR80	;process ESC sequence
	RET
;
; escape sequence processing for ADM-3A & TV-950
;
EPR80:	CP	'='+80H		;2nd char of ESC seq
	JR	NZ,EP801
	LD	IY,CAROW	;CURSOR ADDR SEQ
	RET
EP801:	CP	'.'+80H		;CURSOR CMD?
	JR	NZ,EP802
	LD	IY,CURSET	;CURSOR SEL SEQ
	RET
EP802:	LD	IY,(TADDR)	;RESTORE TERM ADDR
	CP	'j'+80H		;REV LINEFEED?
	JP	Z,RLFED
	CP	'E'+80H		;INSERT LINE?
	JP	Z,LNSRT
	CP	'R'+80H		;DELETE LINE?
	JP	Z,LDELT
	CP	';'+80H		;CLR SCR?
	JP	Z,CSHOM
	CP	'+'+80H		;CLR SCR?
	JP	Z,CSHOM
	CP	':'+80H		;CLR SCR?
	JP	Z,CSHOM
	CP	')'+80H		;HALF INT?
	JP	NZ,EP803
	LD	IY,O80HI	;half-intensity entry
	LD	(TADDR),IY
	RET
EP803:	CP	'('+80H		;FULL INT?
	JR	NZ,EP804
	LD	IY,OPR80	;full-intensity entry
	LD	(TADDR),IY
	RET
EP804:	AND	5FH		;UC & CLR PARITY
	CP	'Y'		;CLR TO EOP?
	JP	Z,CEOP
	CP	'T'		;CLR TO EOL?
	JP	Z,CEOL
	RET
;
; cursor characteristic selection
;
CURSET:	LD	IY,(TADDR)	;RESTORE TERM ADDR
	CP	'0'+80H		;NO CURS?
	JP	Z,CURSOF
	CP	'1'+80H		;BLINKING BLOCK?
	CALL	Z,CURSON
	CALL	Z,BLINK
	JP	Z,BLOCK
	CP	'2'+80H		;STEADY BLOCK?
	CALL	Z,CURSON
	CALL	Z,STEDY
	JP	Z,BLOCK
	CP	'3'+80H		;BLINKING UNDERLINE?
	CALL	Z,CURSON
	CALL	Z,BLINK
	JP	Z,ULINE
	CP	'4'+80H		;STEADY UNDERLINE?
	CALL	Z,CURSON
	CALL	Z,STEDY
	JP	Z,ULINE
	RET			;NOT RECOGNIZED
;
; emulation of a Heath/Zenith H-19 terminal
;
OPR81:	CP	MPSP		;CHECK INPUT CHARACTER
	JR	C,VCS81		;NON PRINTING
	LD	(HL),A		;DISPLAY
FS81:	INC	E		;CURS COL
	LD	A,E
	CP	EOL80		;EOL?
	JP	Z,LFCR
	INC	A
	OUT	(CCOL),A	;move CURSOR
	INC	HL		;move WRT PTR
	RET			;HALT
;
O81HI:	CP	MPSP		;half intensity entry for H-19
	JR	C,VCS81		;CTRL CHAR
	RES	7,A		;clear PARITY
	LD	(HL),A		;to DSPLY RAM
	JP	FS81
;
; CONTROL CODES FOR THE H-19
;
VCS81:	CP	8AH		;LF?
	JP	Z,LFED
	CP	8DH		;CR?
	JP	Z,CRET
	CP	88H		;BS?
	JP	Z,BSPC		;BACKSPACE
	CP	89H		;CTL-I?
	JP	Z,TAB8		;NXT TAB POS
	CP	9BH		;ESC?
	RET	NZ		;UNUSED CTL CODE
	LD	IY,EPR81	;PROCESS ESC SEQUENCE
	RET
;
; ESCAPE SEQUENCE PROCESSING FOR THE H-19
;
EPR81:	CP	'Y'+80H		;2ND CHAR OF ESC SEQ
	JR	NZ,EP811
	LD	IY,CAROW	;CURSOR ADDR SEQ
	RET
EP811:	CP	'x'+80H		;OFF CMD?
	JR	NZ,EP812
	LD	IY,EPROF	;all OFF commands
	RET
EP812:	CP	'y'+80H		;ON cmd?
	JR	NZ,EP813
	LD	IY,EPRON	;all ON commands
	RET
EP813:	LD	IY,(TADDR)	;RESTORE TERM ADDR
	CP	'I'+80H		;REV LINEFEED?
	JP	Z,RLFED
	CP	'L'+80H		;INSERT LINE?
	JP	Z,LNSRT
	CP	'M'+80H		;DELETE LINE?
	JP	Z,LDELT
	CP	'E'+80H		;clr screen?
	JP	Z,CSHOM
	CP	'H'+80H		;home curs?
	JP	Z,HCUR
	CP	'A'+80H		;up curs?
	JP	Z,UCUR
	CP	'B'+80H		;down curs?
	JP	Z,DCUR
	CP	'C'+80H		;curs right?
	JP	Z,FS81
	CP	'D'+80H		;curs left?
	JP	Z,BSPC
	CP	'J'+80H		;clear to EOP?
	JP	Z,CEOP
	CP	'K'+80H		;clear to EOL?
	JP	Z,CEOL
	CP	'p'+80H		;half int? (replaces rev video)
	JR	NZ,EP814
	LD	IY,O81HI
	LD	(TADDR),IY
	RET
EP814:	CP	'q'+80H		;full (normal) intensity?
	JR	NZ,EP815
	LD	IY,OPR81
	LD	(TADDR),IY
	RET
EP815:	CP	'j'+80H		;save curs pos?
	JR	NZ,EP816
	LD	(CURPOS),DE
	RET
EP816:	CP	'k'+80H		;restore curs pos?
	RET	NZ		;unrecognized H-19 ESC seq
	LD	DE,(CURPOS)
	JP	POSCUR		;set cursor pos
;
; ESC seq OFF commands
;
EPROF:	CP	'5'+80H		;curs OFF?
	JP	Z,CURSOF
	CP	'4'+80H		;blinking block curs?
	CALL	Z,BLINK
	JP	Z,BLOCK
	RET			;unrecognized OFF cmd
;
; ESC seq ON commands
;
EPRON:	CP	'5'+80H		;curs ON?
	JP	Z,CURSON
	CP	'4'+80H		;blinking underline curs?
	CALL	Z,BLINK
	JP	Z,ULINE
	RET			;unrecognized ON cmd
;
; The code which follows contain primitive..
; ..routines common to all 24x80 emulations
;
LFCR:	CALL	LFED		;first a linefeed, then..
;				;..fall thru to CR
CRET:	LD	E,0		;..get COL#
	LD	A,E		;..and save in reg E
	INC	A		;move actual pos RIGHT one sp
	OUT	(CCOL),A	;TO VTAC
	LD	A,80H
	AND	L		;SET WRT PTR
	LD	L,A
	RET
;
LFED:	LD	A,D		;Linefeed..get ROW#
	CP	B		;same as LAST LINE?
	CALL	Z,SCROLL	;better scroll up
	INC	A
	CP	24D
	JP	NZ,LFED1
	XOR	A
LFED1:	LD	D,A		;CURS ROW
	OUT	(CROW),A
	LD	H,D
	LD	L,E		;COMPUTE..
	RL	L		;..WRITE
	RR	H		;..POINTER
	RR	L
	SET	7,H		;MAKE RAM ADDR
	RET
;
SCROLL:	INC	B		;SCROLL - BUMP LAST..
	LD	A,B		;..LINE DSPLYD
	CP	24D		;..modulo-24
	JP	NZ,SCROL1
	LD	B,0
SCROL1:	LD	L,0
	LD	H,B
	RR	H		;ERASE..
	RR	L		;..THE
	SET	7,H
	LD	C,MPSP		;..LAST
SCROL2:	LD	(HL),C		;..LINE
	INC	HL
	LD	A,L
	RES	7,A
	CP	EOL80		;EOL?
	JP	NZ,SCROL2
	LD	A,B		;LAST LINE..
	OUT	(VTR6),A	;..TO VTAC
	LD	A,D
	RET
;
RLFED:	LD	A,D		;reverse LINEFEED - get curs row
	DEC	A
	JP	P,RLFED1
	LD	A,23D		;WRAP
RLFED1:	LD	D,A
	CP	B		;LAST LINE?
	CALL	Z,RSCROL	;Yes, SCROLL down
	OUT	(CROW),A
	LD	H,D
	LD	L,E
	RL	L
	RR	H
	RR	L
	SET	7,H
	RET
;
RSCROL:	DEC	B		;REVERSE SCROLL - decr last line
	LD	A,B
	OR	A		;less than zero?
	JP	P,RSCRL1	;no, else..
	LD	B,23D		;..WRAP B
RSCRL1:	LD	L,0
	LD	H,B		;clear..
	RR	H		;..the
	RR	L		;..top
	SET	7,H		;..line
	LD	C,MPSP		;..by
RSCRL2:	LD	(HL),C		;..writing
	INC	HL		;..it with 
	LD	A,L		;..SP
	RES	7,A
	CP	EOL80		;done?
	JP	NZ,RSCRL2
	LD	A,B		;get last line..
	OUT	(VTR6),A	;..and send to VTAC
	INC	A		;+1 = TOP LINE
	CP	24D		;over?
	JP	NZ,RSCRL3	;no
	XOR	A		;wrap (modulo-24)..
RSCRL3:	LD	D,A		;..also load cursor pos
	RET
;
BSPC:	DEC	E		;BACKSPACE
	JP	M,BSPC1		;too far left?
	LD	A,E		;no
	INC	A		;BUMP CURS
	OUT	(CCOL),A
	DEC	HL
	RET
BSPC1:	LD	E,EOL80-1	;select far right col
	LD	A,E
	INC	A
	OUT	(CCOL),A	;POSITION CURS..
;				;..and fall thru to
UCUR:	DEC	D		;CURSOR UP
	JP	P,CCLOC
	LD	D,23D		;WRAP ROW#
CCLOC:	LD	A,D
	OUT	(CROW),A
	LD	H,D
	LD	L,E		;COMPUTE..
	RL	L		;..WRITE
	RR	H		;..POINTER
	RR	L
	SET	7,H		;MAKE ADDR
	RET
;
DCUR:	INC	D		;cursor down
	LD	A,24D
	CP	D		;OVER?
	JP	NZ,CCLOC
	LD	D,0H		;WRAP
	JP	CCLOC
;
HCUR:	LD	A,B		;HOME CURSOR - get last line..
	INC	A		;..+1 = top line
	CP	24D		;OVER?
	JP	NZ,HCUR1
	XOR	A		;WRAP modulo 24
HCUR1:	LD	D,A		;cursor pos..
	OUT	(CROW),A	;..on top row
	XOR	A
	LD	E,A		;curs col = 0 (leftmost)
	INC	A
	OUT	(CCOL),A
	LD	H,D
	LD	L,E		;COMPUTE..
	RL	L		;..WRITE
	RR	H		;..POINTER
	RR	L
	SET	7,H		;MAKE ADDR
	RET
;
TAB8:	LD	A,E		;TAB OVER - GET COL #
	ADD	A,8H		;8 to the right
	AND	78H		;MASK TO NXT POS
	CP	EOL80		;if past EOL..
	RET	NC		;..abort command
	LD	E,A
	INC	A
	OUT	(CCOL),A
	LD	H,D
	LD	L,E		;COMPUTE..
	RL	L		;..WRITE
	RR	H		;..POINTER
	RR	L
	SET	7,H		;MAKE ADDR
	RET
;
LNSRT:	LD	E,0		;line insert
	PUSH	BC		;save last line
	PUSH	DE		;save curs pos
	LD	A,23D
	SUB	D		;#LINES TO SHIFT DOWN?
	JR	Z,LNSR2	;none
	LD	B,A		;save linecnt
	LD	D,EOP80-1	;address of last col..
	LD	E,EOL80-1	;..of next to last line
	LD	HL,80H
	ADD	HL,DE		;..same for last line
	EX	DE,HL		;swap for block move
LNSR1:	PUSH	BC		;save linecnt
	LD	BC,50H		;col cnt
	LDDR			;move line
	LD	BC,30H		;to next line
	EX	DE,HL	
	SBC	HL,BC		;destination
	EX	DE,HL
	SBC	HL,BC		;source
	POP	BC
	DJNZ	LNSR1		;next linemove
LNSR2:	POP	DE		;cursor pos
	CALL	POSCUR
	POP	BC		;restore last line
	JP	CEOL		;clear current line
;
LDELT:	LD	E,0		;delete current line
	PUSH 	DE		;save curs pos
	PUSH	BC		;save last line
	LD	H,D
	LD	L,E		;compute..
	RR	H		;..RAM write
	RR	L		;..pointer
	SET	7,H
	LD	A,23D
	SUB	D		;#LINES TO SHIFT UP?
	JR	Z,LDEL2		;none
	LD	B,A		;save linecnt
	PUSH	HL		;save RAM ptr
	LD	DE,80H
	ADD	HL,DE		;calculate source addr
	POP	DE		;restore destination
LDEL1:	PUSH	BC		;save linecnt
	LD	BC,50H		;col cnt
	LDIR			;linemove
	LD	BC,30H		;to next line
	EX	DE,HL
	ADD	HL,BC		;destination
	EX	DE,HL
	ADD	HL,BC		;source
	POP	BC		;restore linecnt
	DJNZ	LDEL1		;move em all
	LD	H,D
	LD	L,E		;last line RAM addr
LDEL2:	CALL	CEOL		;clear it
	POP	BC
	POP	DE
	JP	POSCUR		;position cursor
;
CEOP:	CALL	CEOL		;CLEAR BELOW CURSOR
	LD	A,B		;LAST ROW
	SUB	D		;-CURS ROW
	JP	P,CEOP1
	ADD	A,24D		;MODULO-24
CEOP1:	RET	Z		;NONE TO DO - HALT
	PUSH	BC
	PUSH	HL		;SAVE REG
	LD	B,A		;LINES TO ERASE
CEOP2:	PUSH	BC		;SAVE CNT
	LD	B,EOL80		;#COLS
	ADD	HL,HL		;WRT POS X 2
	INC	H		;NXT LINE
	LD	L,0
	RR	H
	RR	L		;MEM PTR
	LD	A,EOP80
	CP	H		;EOP?
	JP	NZ,CEOP3
	LD	H,SOP80
CEOP3:	LD	(HL),C		;C=SP FROM CEOL
	INC	HL
	DJNZ	CEOP3
	POP	BC		;GET CNT
	DJNZ	CEOP2
	POP	HL		;RESTORE REG
	POP	BC
	RET
;
CEOL:	PUSH	HL		;CLR TO EOL
	LD	C,MPSP		;SPACE
CEOL1:	LD	(HL),C		;to RAM
	INC	HL
	LD	A,L		;line..
	RES	7,A		;..done
	CP	EOL80		;..yet?
	JP	NZ,CEOL1
	POP	HL		;restore RAM wrt ptr
	RET
;
; common cursor addressing <row+sp> then <col+sp>
;
CAROW:	LD	IY,CACOL	;ROW THEN COL
	SUB	MPSP		;subtract sp
	ADD	A,B		;LAST ROW
	INC	A		;+1
	CP	24D		;OVERFLOW?
	JP	C,CARW1
	SUB	24D		;MOD 24
CARW1:	LD	D,A		;CURS ROW
	RET			;HALT
;
CACOL:	LD	IY,(TADDR)	;RESET PTR
	SUB	MPSP
	LD	E,A		;CURS COL
;				;fall thru to..
POSCUR:	LD	A,D		;..position cursor & RAM wrt ptr
	OUT	(CROW),A		;TO VTAC
	LD	A,E
	INC	A
	OUT	(CCOL),A		;TO VTAC
	LD	H,D
	LD	L,E		;COMPUTE..
	RL	L		;..WRITE
	RR	H		;..POINTER
	RR	L
	SET	7,H		;MAKE ADDR
	RET
;
; setup table for VTAC chip - used on TVC-80 reset
;
STAB:	DB	12D		;COUNT
	DB	WPARM,PARM64	;INIT PARM LATCH
	DB	VTRS,0		;RESET VTAC
	DB	VTR0,100D	;H CHARCNT=101
	DB	VTR1,4BH
	DB	VTR2,4DH
	DB	VTR3,97H
	DB	VTR4,03H
	DB	VTR5,0EH
	DB	VTR6,23D
	DB	CCOL,0
	DB	CROW,0
	DB	VTCH,0		;ST TCHAIN
;
; Initialize Screen - writes SP (blank) to all 1920 locations
;
CLEAR:	LD	HL,ST80		;screen RAM pointer
	LD	DE,48D		;skip between lines
	LD	B,24D		;#LINES
CLRS1:	PUSH	BC
	LD	B,80D		;#COLS
CLRS2:	LD	(HL),MPSP	;write mark parity SP
	INC	HL
	DJNZ	CLRS2		;all col
	ADD	HL,DE		;RAM pointer to next line
	POP	BC
	DJNZ	CLRS1		;all lines
	RET
;
; TVC-80 TEST PATTERN GENERATOR
;
TVCTST:	CALL	CLEAR
	LD	A,0E0H		;SLOW MODE
	OUT	(WPARM),A
	OUT	(CWAIT),A	;CLR WAIT
	LD	A,'*'+80H	;CORNER CHAR
	LD	HL,ST80		;UL CORNER 24X80
	LD	(HL),A
	LD	HL,ST80+4FH	;UR
	LD	(HL),A
	LD	HL,ST80+0B80H	;LL
	LD	(HL),A
	LD	HL,ST80+0BCFH	;LR
	LD	(HL),A
	LD	HL,ST80+208H	;UL CORNER 16X64
	LD	(HL),A
	LD	HL,ST80+247H	;UR
	LD	(HL),A
	LD	HL,ST80+988H	;LL
	LD	(HL),A
	LD	HL,ST80+9C7H	;LR
	LD	(HL),A
;
	LD	A,'-'+80H	;HORIZ BORDER CHAR
	LD	HL,ST80+1	;TOP 24X80
	LD	B,4EH		;COUNT
	CALL	HBORDR
	LD	HL,ST80+209H	;TOP 16X64
	LD	B,3EH
	CALL	HBORDR
	LD	HL,ST80+989H	;BOTTOM 16X64
	LD	B,3EH
	CALL	HBORDR
	LD	HL,ST80+0B81H	;BOTTOM 24X80
	LD	B,4EH
	CALL	HBORDR
	LD	A,'|'+80H	;VERT BORDER CHAR
	LD	HL,ST80+80H	;LEFT 24X80
	LD	B,16H		;COUNT
	CALL	VBORDR
	LD	HL,ST80+288H	;LEFT 16X64
	LD	B,0EH
	CALL	VBORDR
	LD	HL,ST80+2C7H	;RIGHT 16X64
	LD	B,0EH
	CALL	VBORDR
	LD	HL,ST80+0CFH	;RIGHT 24X80
	LD	B,16H
	CALL	VBORDR
;
	LD	HL,ST80+0A0H
	LD	IX,BMSG24	;24X80 MSG
	CALL	TEXT
	LD	HL,ST80+1A0H
	LD	IX,BMSG16	;16X64 MSG
	CALL	TEXT
	LD	HL,ST80+0A90H
	LD	IX,EXMSG	;EXIT MSG
	CALL	TEXT
	LD	HL,ST80+925H
	LD	IX,FTMSG	;Font # msg
	CALL	TEXT
;
	LD	HL,ST80+310H	;T
	LD	IX,TEE
	CALL	BIGCHR
	LD	HL,ST80+318H	;V
	LD	IX,VEE
	CALL	BIGCHR
	LD	HL,ST80+320H	;C
	LD	IX,CEE
	CALL	BIGCHR
	LD	HL,ST80+328H	;-
	LD	IX,DASH
	CALL	BIGCHR
	LD	HL,ST80+330H	;8
	LD	IX,EIGHT
	CALL	BIGCHR
	LD	HL,ST80+338H	;0
	LD	IX,ZERO
	CALL	BIGCHR
;
	LD	A,80H		;MSB=1 character set dsply
	LD	HL,ST80+718H	;LINE 1
	CALL	CHSET
	LD	HL,ST80+798H	;LINE 2
	CALL	CHSET
	LD	HL,ST80+818H	;LINE 3
	CALL	CHSET
	LD	HL,ST80+898H	;LINE 4
	CALL	CHSET
	LD	HL,ST80+0AB0H	;NAME
	LD	IX,OWNAME
	CALL	TEXT
;
	LD	HL,ST80+92AH	;point to font #
TPDSP:	CALL	WAIT
	LD	A,0F0H		;font 2
	OUT	(WPARM),A
	LD	(HL),'2'	;change font #
	CALL	WAIT
	LD	A,0F8H		;HALF BR
	OUT	(WPARM),A
	CALL	WAIT
	LD	A,0E8H		;font 1
	OUT	(WPARM),A
	LD	(HL),'1'	;change font #
	CALL	WAIT
	LD	A,0E0H		;FULL BR
	OUT	(WPARM),A
	JR	TPDSP
;
; SUBROUTINES
;
WAIT:	LD	BC,0H
WAIT1:	DEC	C
	JR	NZ,WAIT1
	DJNZ	WAIT1
	RET
;
HBORDR:	LD	(HL),A
	INC	HL
	DJNZ	HBORDR
	RET
;
VBORDR:	LD	DE,80H
VBORD1:	LD	(HL),A
	ADD	HL,DE		;NXT LINE
	DJNZ	VBORD1
	RET
;
TEXT:	LD	A,(IX+0)
	INC	A
	RET	Z		;FOR FF
	DEC	A
	LD	(HL),A
	INC	IX
	INC	HL
	JR	TEXT
;
BIGCHR:	LD	DE,80H
	LD	A,(IX+0)
	INC	IX
	LD	B,7H
BIGCH1:	PUSH	HL
	PUSH	BC
	LD	C,(IX+0)
	LD	B,8H
BIGCH2:	LD	(HL),20H	;SP
	RL	C
	JR	NC,BIGCH3
	LD	(HL),A
BIGCH3:	INC	HL
	DJNZ	BIGCH2
	POP	BC
	POP	HL
	ADD	HL,DE		;NXT LINE
	INC	IX
	DJNZ	BIGCH1
	RET
;
CHSET:	LD	B,20H
CHST1:	LD	(HL),A
	INC	A
	INC	HL
	DJNZ	CHST1
	RET
;
; MESSAGES & DATA
;
TEE:	DB	'T',7FH,8H,8H,8H,8H,8H,8H
VEE:	DB	'V',41H,41H,41H,41H,22H,14H,8H
CEE:	DB	'C',1EH,21H,40H,40H,40H,21H,1EH
DASH:	DB	'=',0,0,0,3EH,0,0,0
EIGHT:	DB	'8',1CH,22H,1CH,22H,41H,22H,1CH
ZERO:	DB	'0',1CH,22H,45H,49H,51H,22H,1CH
BMSG24:	DB	'24 X 80 boundary',0FFH
BMSG16:	DB	'16 X 64 boundary',0FFH
EXMSG:	DB	'RESET to EXIT',0FFH
FTMSG:	DB	'Font 1',0FFH
OWNAME:	DB	0FFH
;
	END
