	PSECT ABS
;=============================================================
;
;		Keyboard Handler for EDIT-11
;
;	   Standard Digital Group Implimentation
;
;           Revised May 31, 1981            cac
;           Revised Sept 1, 1981            cac
;	    Revised Oct 1, 1981   for v2.02 cac
;
;=============================================================
;
;
KEY	EQU	0		;Keyboard port number
TVC	EQU	0		;TV port number
;
;**********      Internal Terminal Codes        **************
;
SOH	EQU	01		;Cursor home
FF	EQU	12		;Clear screen
CAN	EQU	24		;End of screen clear
ETB	EQU	23		;End of line clear
CR	EQU	13		;Cursor to start of line
BS	EQU	08		;Cursor left
ACK	EQU	06		;Cursor right
SUB	EQU	26		;Cursor up
LF	EQU	10		;Cursor down
DLE	EQU	16		;Cursor address
EM	EQU	25		;Keyboard on (*)
NAK	EQU	21		;Keyboard off (*)
EOT	EQU	04		;Protect on (*)
ENQ	EQU	05		;Protect off (*)
STX	EQU	02		;Format on (*)
ETX	EQU	03		;Format off (*)
GS	EQU	29		;Blink on (*)
RS	EQU	30		;Blink off (*)
FS	EQU	28		;Erase unprotected (*)
DC1	EQU	17		;Insert line (*)
DC3	EQU	19		;Insert character (*)
DC2	EQU	18		;Delete line (*)
DC4	EQU	20		;Delete character (*)
;
; (*)=Not implimented in this driver.
;
;---------         Other Function Codes       -------------
;
TAB	EQU	9		;Tab character
;
;==============================================================
;
;   EDIT-11 handler jump table. Number of entries and order
; must be preserved.
;
	ORG	02300H		;Address set by EDIT-11 v2.05.
;
BEGADR:	JP	STATUS		;Status of keyboard.
	JP	INPUT		;Input a byte.
	JP	OUTPUT		;Output a byte (ignored).
	JP	INITIZE		;Initialization routine.
	JP	REMOVE		;De-initialize handler.
;
;**********
;
; = = = =   Keyboard Status Routine   = = = =
;
;   Preserve all registers.
;   Exit with the zero flag set if no character is ready.
;   Slightly speeded up - Oct 1, 1981 cac.
;
STATUS:
	LD	(SAVEA),A	;Put (A) here.
	IN	A,(KEY)		;Read keyboard
	AND	127		;Strip bit 7 (we don't care).
	JR	Z,NOTRDY	;Nothing ready.
	PUSH	BC		;Must save all registers
	LD	C,A
	LD	A,1		;Wait 2 milliseconds
	CALL	TIMER
	IN	A,(KEY)		;Check keyboard again.
	AND	127		;Strip bit 7 (we don't care).
	CP	C		;Same pattern ready?
	POP	BC		;Restore regs.
	JR	NZ,NOTRDY
	LD	(CHAR),A	;Save character for later use.
	AND	A		;Clear zero flag.
	LD	A,(SAVEA)	;Restore registers
	RET
NOTRDY:
	LD	A,255		;Not ready, clear buffer.
	LD	(CHAR),A
	XOR	A		;Set zero flag and return
	LD	A,(SAVEA)	;Restore registers
	RET
;
CHAR:	DEFB	255		;Save spot for key entry. Note,
;				;255= no character ready.
SAVEA:	DEFB	0		;Save space for register (A).
;
;
;   = = = =   Keyboard Input Routine   = = = =
;
;   Exit with the next character in the (A) register.
;
INPUT:
	PUSH	HL		;Save all registers except (A).
XXA1:	LD	A,(CHAR)	;Is a character ready?
	CP	255
	JR	NZ,XXA2		;Yes, we are almost done.
	CALL	STATUS		;Just keep checking.
	JR	XXA1
XXA2:	LD	HL,CHAR		;Clear character buffer
	LD	(HL),255
	BIT	6,A		;Check for non-numeric.
	JR	Z,XXA3		;Can't switch case.
	LD	H,A		;Save character here and check
	PUSH	HL
	LD	HL,(CONSTS)
	LD	A,(HL)		;Get console status byte.
	POP	HL		;Check for a upper/lower case switch.
	BIT	6,A		;Translate to upper case?
	JR	NZ,UPPER
	BIT	5,A		;Reverse case?
	LD	A,H		;Prepare for normal character.
	JR	Z,XXA3
	XOR	00100000B	;Flip bit 5.
XXA3:	POP	HL		;Restore registers
	RET
UPPER:	LD	A,H		;Get character.
	CP	'{'		;Is it a lower case letter?
	JR	NC,XXB1
	RES	5,A		;Clear bit 5.
XXB1:	POP	HL
	RET
;
;
;   = = = =   Keyboard Output Routine   = = = =
;
;
;
OUTPUT:
	PUSH	AF
	PUSH	HL
	PUSH	BC
	LD	A,(ARMING)	;In the middle of cursor addressing?
	AND	A
	JR	Z,NORMAL
	DEC	A		;Adjust count value.
	LD	(ARMING),A
	JR	Z,XXC1		;Ready for row?
	LD	A,C		;Just save column number.
	LD	(COLUMN),A
	JR	RTRN1
XXC1:	LD	L,C		;Convert row and column into
	LD	H,0		;absolute position.
	LD	B,H
	ADD	HL,HL		;Adjust for line length.
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL		;(HL)=(HL)*64.
	LD	A,(COLUMN)	;Adjust for column desired.
	LD	C,A
	ADD	HL,BC
RETURN:	CALL	CHECK		;Make sure cursor is within
	LD	(CURSOR),HL	;bounds.
	LD	A,1		;Set to non-zero
	LD	(MOVED),A	;Say we moved it.
RTRN1:	POP	BC		;Restore regs and return.
	POP	HL
	POP	AF
	RET
NORMAL:	LD	A,C		;Check option.
	CP	' '		;Is it printable?
	JP	NC,SEND
	CP	TAB		;Is it a tab?
	JP	Z,DOTABS
	LD	HL,(CURSOR)	;Get cursors location.
	CP	ACK		;Move right?
	JR	NZ,XXC2
	INC	HL		;Just bump cursors location.
	JR	RETURN
XXC2:	CP	BS		;Move left?
	JR	NZ,XXC3
	DEC	HL		;Just decrement address.
	JR	RETURN
XXC3:	CP	SOH		;Home the cursor?
	JR	NZ,XXC4
	LD	HL,0		;Start at the beginning.
	LD	A,127		;Also reset the screen.
	OUT	(TVC),A
	XOR	A
	OUT	(TVC),A
	JP	BACK2
XXC4:	CP	SUB		;Move cursor up?
	JR	NZ,XXC5
	LD	BC,-64
	ADD	HL,BC
	JR	RETURN
XXC5:	CP	LF		;Move cursor down?
	JR	NZ,XXC6
	LD	BC,64
	ADD	HL,BC
	JR	RETURN
XXC6:	CP	DLE		;Move to absolute address?
	JR	NZ,XXC7
	LD	A,2		;Say we are expecting 2 more
	LD	(ARMING),A	;characters.
	JR	RTRN1
XXC7:	CP	ETB		;Clear to end of line?
	JR	NZ,XXC9
	LD	A,(MOVED)	;Has cursor been moved?
	AND	A
	CALL	NZ,MOVE		;Position cursor first.
	LD	HL,(POSITION)	;Determine how many spaces to print.
	LD	(CURSOR),HL	;And move back to here.
XXC8:	LD	A,' '+128	;Print a space.
	OUT	(TVC),A
	XOR	A
	OUT	(TVC),A
	INC	HL		;Adjust position.
	LD	A,L		;At the end?
	AND	63
	JR	NZ,XXC8
	JR	BACK
XXC9:	CP	CAN		;Clear to end of screen?
	JR	NZ,XXC12
	LD	A,(MOVED)	;Has cursor been moved?
	AND	A
	CALL	NZ,MOVE		;Position cursor first.
	LD	HL,(POSITION)	;Determine how many spaces to print.
XXC10:	LD	(CURSOR),HL	;Move back to here.
XXC11:	LD	A,' '+128	;Print a space.
	OUT	(TVC),A
	XOR	A
	OUT	(TVC),A
	INC	HL		;Adjust position.
	LD	A,H		;At the end?
	CP	4
	JR	NZ,XXC11
	JR	BACK
XXC12:	CP	FF		;Clear screen?
	JR	NZ,XXC13
	LD	A,127		;Reset cursor.
	OUT	(TVC),A
	XOR	A
	OUT	(TVC),A
	LD	HL,0		;Screen starts here.
	JR	XXC10
XXC13:	CP	CR		;Return the carriage?
	JR	NZ,WHAT
	LD	A,L
	AND	0C0H		;Reset cursor to start of line.
	LD	L,A
	JP	RETURN
BACK:	LD	A,1		;Set moved flag.
	LD	(MOVED),A
	CALL	CHECK
	JR	BACK3
BACK1:	CALL	CHECK		;Keep within bounds.
BACK2:	LD	(CURSOR),HL	;Update desired location.
BACK3:	LD	(POSITION),HL	;Update tv's position.
WHAT:	POP	BC		;Restore regs and return.
	POP	HL
	POP	AF
	RET
;
;   Handle a tab ourselves. Use modulo 8 as tab stops.
;
DOTABS:	LD	A,(MOVED)	;Has cursor been moved?
	AND	A
	CALL	NZ,MOVE		;Move the cursor (if required).
	LD	HL,(POSITION)	;Get the current position.
XXD1:	LD	A,' '+128	;Print spaces until a tab stop.
	OUT	(TVC),A
	XOR	A
	OUT	(TVC),A
	INC	HL
	LD	A,L
	AND	7
	JR	NZ,XXD1
	JR	BACK1
;
;   Output (C) to the screen now.
;
SEND:	LD	A,(MOVED)	;Has cursor been moved?
	AND	A
	CALL	NZ,MOVE		;Move cursor (if required).
	LD	A,C
	OR	128		;Set bit 7 for the DB tvc board
	LD	HL,(POSITION)	;Update position of cusor.
	INC	HL
	OUT	(TVC),A
	XOR	A
	OUT	(TVC),A
	JR	BACK1
;
;   - - - -   Check (HL) to be sure it is with the bounds
;   if the tv screen buffer.
;
CHECK:	LD	A,H		;Check for off of the top.
	AND	A
	JP	P,XXE1
	ADD	A,4		;We went off of the top.
	LD	H,A		;Reset to lower corner.
	RET
XXE1:	CP	4		;Off the bottom?
	RET	C
	SUB	4		;Yes, reset to upper left.
	LD	H,A
	RET
;
;   Move the cursor to the desired location. It presently is
; located at address (POSITION) and it is desired to move it
; to (CURSOR). This routine should examine the move to find
; out what is the fastest way for the move.
;
MOVE:	PUSH	BC		;Yes, save registers.
	LD	BC,(CURSOR)	;We should move it to here.
	LD	HL,(POSITION)	;This is where we are now.
	LD	(POSITION),BC	;Set to new position.
	LD	A,B		;Check for a reset request.
	OR	C
	JR	Z,XXF4
	SBC	HL,BC
	JR	C,XXF2		;Forward or backward?
;
;   Move cursor backward (HL) places.
;
XXF1:	LD	A,H
	OR	L
	JR	Z,XXF3
	LD	A,2		;Backup a space.
	OUT	(TVC),A
	XOR	A
	OUT	(TVC),A
	DEC	HL		;Continue until (HL)=0.
	JR	XXF1
;
;   Move the cursor forward (-HL) places.
;
XXF2:	LD	A,1		;Else move one space.
	OUT	(TVC),A
	XOR	A
	OUT	(TVC),A
	INC	HL
	LD	A,H		;Test for zero now.
	OR	L
	JR	NZ,XXF2
XXF3:	LD	(MOVED),A	;Clear moved flag.
	POP	BC		;Restore used registers.
	RET
;
;   Reset the cursor to the upper left corner.
;
XXF4:	LD	HL,0		;Reset position value.
	LD	(POSITION),HL
	LD	(CURSOR),HL
	LD	A,127
	OUT	(TVC),A
	XOR	A
	OUT	(TVC),A
	JR	XXF3
;
POSITION:DEFW	0		;Current cursor position
CURSOR:	DEFW	0		;Desired position of cursor
MOVED:	DEFB	0		;Cursor moved if non-zero.
COLUMN:	DEFB	0		;Desired column storage.
ARMING:	DEFB	0		;Set to non-zero if processing absolute cursor move.
CONSTS:	DEFW	0		;ADDRESS OF STATUS BYTE.
;
;   = = = =   Keyboard Initialize Routine   = = = =
;
INITIZE:
	LD	(CONSTS),HL	;Save passed addresses.
	LD	(TIMER+1),DE	;Delay routine.
	LD	DE,ENDADDR	;Return last used address.
	LD	HL,64*256+16	;Setup screen size.
	RET
;
TIMER:	JP	0		;Address from EDIT-11.
;
;
;   = = = =   Keyboard De-initialize Routine   = = = =
;
REMOVE:
	RET
;
;
;
;***********************   PATCH   **************************
;
VIRTUAL	EQU	1812H		;Virtual file i/o by bytes.
EOM	EQU	1EC2H		;End of source address.
SOURCE	EQU	1EC8H		;Start of source text.
OUTFCB	EQU	1FFDH		;Output file control area.
;
PATCH1:	PUSH	DE
	DEC	DE		;If last byte written was a cr.
	LD	A,(DE)		;then add line feed.
	CP	CR
	JR	NZ,CONT1
	LD	DE,OUTFCB	;Use this file.
	LD	A,LF
	CALL	VIRTUAL
CONT1:	POP	DE
	LD	HL,(EOM)
	RET
;
ENDADDR	EQU	$		;Set end of handler address.
;
;*******************   INSTALL PATCH   **********************
;
	ORG	15CEH
	CALL	PATCH1
	ORG	106H
	DEFB	'6'		;Version 2.06.
;
	END
