;=============================================================
;
;		Keyboard Handler for EDIT-11
;
;	    SOROC IQ 120 / VIO-Xn  (CP/M or MP/M version)
;                   June 9, 1982   by Clark Calkins
;
;=============================================================
;
;**********      This version interfaces the video     ********
;**********      and keyboard through cp/m bios calls  ********
;
;**********      Internal Terminal Codes        **************
;
;             EDIT-11  Soroc IQ  Description.
;             -------  --------  -----------------------------
SOH:	EQU	01	;30	Cursor home
FF:	EQU	12	;26	Clear screen
CAN:	EQU	24	;$'Y'	End of screen clear(*)
ETB:	EQU	23	;$'T'	End of line clear
CR:	EQU	13	;13	Cursor to start of line
BS:	EQU	08	;08	Cursor left
ACK:	EQU	06	;12	Cursor right(*)
SUB:	EQU	26	;11	Cursor up(*)
LF:	EQU	10	;10	Cursor down
DLE:	EQU	16	;$=(r+32)(c+32)	Cursor address
EM:	EQU	25	;$"	Keyboard on (*)
NAK:	EQU	21	;$#	Keyboard off (*)
EOT:	EQU	04	;$&	Protect on (*)
ENQ:	EQU	05	;$'	Protect off (*)
STX:	EQU	02	;(none)	Format on (*)
ETX:	EQU	03	;(none)	Format off (*)
GS:	EQU	29	;$Z"	Blink on (*)
RS:	EQU	30	;$Z' '	Blink off (*)
FS:	EQU	28	;$	;Erase unprotected (*)
DC1:	EQU	17	;$E	Insert line (*)
DC3:	EQU	19	;$Q	Insert character (*)
DC2:	EQU	18	;$R	Delete line (*)
DC4:	EQU	20	;$W	Delete character (*)
;
;   ($)= Escape lead in character.
;   (*)=Not implemented in this driver.
;
;   Soroc IQ 120 immediate command codes (that are different
;   than the EDIT-11 codes).
;
HOME:	EQU	30
CLEAR:	EQU	26
;
;---------         Other Function Codes       -------------
;
TAB:	EQU	9		;Tab character.
ESC:	EQU	27		;Escape.
;
;==============================================================
;
;   EDIT-11 handler jump table. Number of entries and order
; must be preserved.
;
	ORG	02300H		;Address set by EDIT-11 v2.05.
;
BEGADR:	JP	STATUS		;Status of keyboard.
	JP	INPUT		;Input a byte.
	JP	OUTPUT		;Output a byte (ignored).
	JP	INITIZE		;Initialization routine.
	JP	REMOVE		;De-initialize handler.
;
;**********
;
; = = = =   Keyboard Status Routine   = = = =
;
;   Preserve all registers.
;   Exit with the zero flag set if no character is ready.
;
STATUS:
	PUSH	DE
	PUSH	BC
	PUSH	HL
	CALL	CONST
	AND	A	;(0)=not ready, (ff)=ready.
	POP	HL
	POP	BC
	POP	DE
	RET
;
;   = = = =   Keyboard Input Routine   = = = =
;
;   Exit with the next character in the (A) register.
;
INPUT:
	PUSH	HL		;Save all registers except (A).
	PUSH	DE
	PUSH	BC
	CALL	CONIN		;Get character.
	BIT	6,A		;Check for non-numeric.
	JR	Z,XXB1		;Can't switch case.
	LD	H,A		;Save character here and check
	PUSH	HL
	LD	HL,(CONSTS)
	LD	A,(HL)		;Get console status byte.
	POP	HL		;Check for a upper/lower case switch.
	BIT	6,A		;Translate to upper case?
	JR	NZ,UPPER
	BIT	5,A		;Reverse case?
	LD	A,H		;Prepare for normal character.
	JR	Z,XXB1
	XOR	00100000B	;Flip bit 5.
	JR	XXB1
UPPER:	LD	A,H		;Get character.
	CP	'{'		;Is it a lower case letter?
	JR	NC,XXB1
	RES	5,A		;Clear bit 5.
XXB1:	POP	BC
	POP	DE
	POP	HL
	RET
;
;
;   = = = =   Keyboard Output Routine   = = = =
;
;
;
OUTPUT:
	PUSH	AF
	PUSH	HL
	PUSH	DE
	PUSH	BC
	LD	A,(ARMING)	;In the middle of cursor addressing?
	AND	A
	JR	Z,NORMAL
	DEC	A		;Adjust count value.
	LD	(ARMING),A
	JR	Z,ROW		;Ready for row?
	LD	A,C		;Just save column number.
	LD	(XPOS),A
	JR	RTRN1
ROW:	LD	A,C		;Save row.
	LD	(YPOS),A	;Save position - row.
	LD	C,ESC		;Send (escape), (=), then (row),
	CALL	CONOUT		;and (column).
	LD	C,'='
	CALL	CONOUT
	LD	A,(YPOS)
	ADD	32		;Required by Soroc IQ 120.
	LD	C,A
	CALL	CONOUT
	LD	A,(XPOS)
	ADD	32		;Required by Soroc IQ 120.
	LD	C,A
	JR	RTRN0
NORMAL:	LD	A,C		;Check option.
	CP	' '		;Is it printable?
	JR	C,MORE
	LD	HL,XPOS		;Update position.
	INC	(HL)
RTRN0:	CALL	CONOUT
RTRN1:	POP	BC		;Restore regs and return.
	POP	DE
	POP	HL
	POP	AF
	RET
;
MORE:	CP	TAB		;Is it a tab?
	JR	NZ,MORE10	;Jump if not tab.
	LD	A,(XPOS)	;Get current column number.
	LD	B,A
	LD	C,' '		;Send spaces til mod 8.
DOAGN:	PUSH	BC
	CALL	CONOUT
	POP	BC
	INC	B		;Update column number.
	LD	A,B		;At a multiple of 8?
	AND	7
	JR	NZ,DOAGN
	LD	A,B		;Yes, we are done. Check to see
	CP	80		;if we went past the right edge.
	JR	C,STR
	SUB	80		;Yes, adjust for next row.
STR:	LD	(XPOS),A	;Save new column number.
	JR	RTRN1
;
MORE10:
	CP	BS		;Move left?
	JR	NZ,MORE9
	LD	HL,XPOS		;Correct xpos.
	DEC	(HL)
	JR	RTRN0
;
MORE9:	CP	SOH		;Home the cursor?
	JR	NZ,MORE6
	LD	C,HOME		;Send home command.
DOIT:	XOR	A		;Reset our column counter.
	LD	(XPOS),A
	JR	RTRN0
;
MORE6:	CP	LF		;Move cursor down?
	JR	Z,RTRN0		;Yes, just send it.
;
	CP	DLE		;Move to absolute address?
	JR	NZ,MORE1
	LD	A,2		;Say we are expecting 2 more
	LD	(ARMING),A	;characters.
	JR	RTRN1
;
MORE1:	CP	ETB		;Clear to end of line?
	JR	NZ,MORE2
	LD	C,ESC		;Send (escape), (T).
	CALL	CONOUT
	LD	C,'T'
	JR	RTRN0
;
MORE2:	CP	FF		;Clear screen?
	JR	NZ,MORE4
	LD	C,CLEAR		;Clear screen on Soroc IQ 120.
	JR	DOIT
;
MORE4:	CP	CR		;Return the carriage?
	JR	Z,DOIT
	JR	RTRN1		;Ignore anything else.
;
;   Cursors present position.
;
XPOS:	DB	0
YPOS:	DB	0		;Note above order is required.
;
ARMING:	DB	0		;Set to non-zero if processing absolute cursor move.
CONSTS:	DW	0		;ADDRESS OF STATUS BYTE.
;
;   Interface to the cp/m or mp/m bios jump table. The addresses
; are filled in by the initialize routine.
;
CONST:	JP	0
CONIN:	JP	0
CONOUT:	JP	0
;
;   = = = =   Keyboard Initialize Routine   = = = =
;
INITIZE:
	LD	(CONSTS),HL	;Save passed addresses.
	LD	C,12		;Cp/m or mp/m?
	CALL	5
	DEC	H		;(H)=0 for cp/m, =1 for mp/m.
	LD	HL,(1)		;Get address of warm boot vector.
	JR	NZ,STUFFIT	;Special process for mp/m.
	INC	HL		;Skip jump instruction.
	LD	E,(HL)		;Note one level of indirection.
	INC	HL
	LD	H,(HL)
	LD	L,E
STUFFIT:
	INC	HL		;Skip to console status vector.
	INC	HL
	INC	HL
	LD	DE,CONST	;Move three vectors down here
	LD	BC,9		;to execute faster.
	LDIR
	LD	HL,SETUP	;Setup the display for our use.
	CALL	SEND
	LD	DE,ENDADDR	;Return last used address.
	LD	HL,80*256+24	;Setup screen size.
	RET
;
;
;   = = = =   Keyboard De-initialize Routine   = = = =
;
REMOVE:
	PUSH	AF
	LD	HL,REVERT	;Reset the screen to normal use.
	CALL	SEND
	POP	AF
	RET
;
;   Send the string pointed to by (hl) to the video board. It
; end with a null byte.
;
SEND:	LD	A,(HL)		;Done?
	AND	A
	RET	Z
	PUSH	HL
	LD	C,A
	CALL	CONOUT
	POP	HL
	INC	HL
	JR	SEND
;
;   Byte strings to setup the Soroc IQ 120 display.
;
SETUP:	DB	ESC,'Z',' '	;Set normal attributes.
	DB	ESC,'H'		;Cursor off.
	DB	SUB		;Clear the screen.
	DB	0		;End flag byte.
REVERT:	DB	ESC,'Z',' '	;Set normal attributes.
	DB	ESC,'K'		;Cursor on.
	DB	SUB		;Clear the screen.
	DB	0		;End flag byte.
;
ENDADDR:EQU	$		;Set end of handler address.
;
;
	END
