;=============================================================
;
;		Keyboard Handler for EDIT-11
;
;	    ADDS Regent 100 Implementation.
;	    Revised Sep 22, 1981   by John Rheinstein
;
;=============================================================
;
;   Setup port usage.
;
CPORT:	EQU	17		;Keyboard status.
DPORT:	EQU	16		;Keyboard data.
;
;**********      Internal Terminal Codes        **************
;
SOH:	EQU	01		;Cursor home
FF:	EQU	12		;Clear screen
CAN:	EQU	24		;End of screen clear
ETB:	EQU	23		;End of line clear
CR:	EQU	13		;Cursor to start of line
BS:	EQU	08		;Cursor left
ACK:	EQU	06		;Cursor right
SUB:	EQU	26		;Cursor up
LF:	EQU	10		;Cursor down
DLE:	EQU	16		;Cursor address
EM:	EQU	25		;Keyboard on (*)
NAK:	EQU	21		;Keyboard off (*)
EOT:	EQU	04		;Protect on (*)
ENQ:	EQU	05		;Protect off (*)
STX:	EQU	02		;Format on (*)
ETX:	EQU	03		;Format off (*)
GS:	EQU	29		;Blink on (*)
RS:	EQU	30		;Blink off (*)
FS:	EQU	28		;Erase unprotected (*)
DC1:	EQU	17		;Insert line (*)
DC3:	EQU	19		;Insert character (*)
DC2:	EQU	18		;Delete line (*)
DC4:	EQU	20		;Delete character (*)
;
; (*)=Not implimented in this driver.
;
;---------         Other Function Codes       -------------
;
TAB:	EQU	9		;Tab character.
ESC:	EQU	27		;Escape.
VT:	EQU	11		;Vertical tab.
;
;==============================================================
;
;   EDIT-11 handler jump table. Number of entries and order
; must be preserved.
;
	ORG	02300H		;Address set by EDIT-11 v2.05.
;
BEGADR:	JP	STATUS		;Status of keyboard.
	JP	INPUT		;Input a byte.
	JP	OUTPUT		;Output a byte (ignored).
	JP	INITIZE		;Initialization routine.
	JP	REMOVE		;De-initialize handler.
;
;**********
;
; = = = =   Keyboard Status Routine   = = = =
;
;   Preserve all registers.
;   Exit with the zero flag set if no character is ready.
;
STATUS:
	LD	(SAVEA),A	;Put (A) here.
	IN	A,CPORT		;Read keyboard
	BIT	1,A		;Character ready?
	LD	A,(SAVEA)	;Restore registers
	RET
;
SAVEA:	DB	0		;Save space for register (A).
;
;
;   = = = =   Keyboard Input Routine   = = = =
;
;   Exit with the next character in the (A) register.
;
INPUT:
	PUSH	HL		;Save all registers except (A).
INPUT1:	IN	A,CPORT		;Get keyboard USART status.
	BIT	1,A		;Character ready?
	JR	Z,INPUT1
	IN	A,DPORT		;Get character.
	BIT	6,A		;Check for non-numeric.
	JR	Z,XXA3		;Can't switch case.
	LD	H,A		;Save character here and check
	PUSH	HL
	LD	HL,(CONSTS)
	LD	A,(HL)		;Get console status byte.
	POP	HL		;Check for a upper/lower case switch.
	BIT	6,A		;Translate to upper case?
	JR	NZ,UPPER
	BIT	5,A		;Reverse case?
	LD	A,H		;Prepare for normal character.
	JR	Z,XXA3
	XOR	00100000B	;Flip bit 5.
XXA3:	POP	HL		;Restore registers
	RET
UPPER:	LD	A,H		;Get character.
	CP	'{'		;Is it a lower case letter?
	JR	NC,XXB1
	RES	5,A		;Clear bit 5.
XXB1:	POP	HL
	RET
;
;
;   = = = =   Keyboard Output Routine   = = = =
;
;
;
OUTPUT:
	PUSH	AF
	PUSH	HL
	PUSH	DE
	PUSH	BC
	LD	A,(ARMING)	;In the middle of cursor addressing?
	AND	A
	JR	Z,NORMAL
	DEC	A		;Adjust count value.
	LD	(ARMING),A
	JR	Z,ROW		;Ready for row?
	LD	A,C		;Just save column number.
	LD	(XPOS),A
	LD	E,10		;This is required because
	LD	B,255		;of a bug inherent in ADDS
AGN:	INC	B		;Regent 100 terminal firmware.
	SUB	E		;The simpler ESC
	JR	NC,AGN		;sequence will cause trouble.
	ADD	E
	LD	HL,COLUMN
	RRD
	LD	A,B
	RRD
	JR	RTRN1
ROW:	LD	A,C		;Save row.
	LD	(YPOS),A	;Save position - row.
	LD	(ROW1),A
GOTO:	LD	HL,GOTOXY	;Address of goto xy buffer.
BUFOUT:	LD	B,(HL)
MOROUT:	INC	HL
	LD	A,(HL)
	CALL	SEND
	DJNZ	MOROUT
RTRN1:	POP	BC		;Restore regs and return.
	POP	DE
	POP	HL
	POP	AF
	RET
NORMAL:	LD	A,C		;Check option.
	CP	' '		;Is it printable?
	JR	C,MORE
SEND1:	LD	HL,XPOS		;Update position.
	INC	(HL)
SEND2:	CALL	SEND
	JR	RTRN1
SEND:	PUSH	AF
RDY:	IN	A,CPORT
	BIT	0,A
	JR	Z,RDY
	POP	AF
	OUT	DPORT,A
	RET
;
MORE:	CP	TAB		;Is it a tab?
	JR	NZ,MORE10	;Jump if not tab.
	LD	HL,XPOS		;Current position.
DOAGN:	INC	(HL)
	LD	A,' '		;Print space.
	CALL	SEND
	LD	A,(HL)		;New position.
	AND	7		;Done with tab?
	JR	NZ,DOAGN
	SUB	80		;Tab into next row?
	JR	C,RTRN1
	LD	(HL),A		;New xpos
	INC	HL		;Get ypos.
	INC	(HL)		;Increment ypos.
	JR	RTRN1
;
MORE10:	CP	ACK		;Send if move right.
	JR	Z,SEND1
;
	CP	BS		;Move left?
	JR	NZ,MORE9
	LD	HL,XPOS		;Correct xpos.
	DEC	(HL)
	JR	SEND2
;
MORE9:	CP	SOH		;Home the cursor?
	JR	NZ,MORE6
	LD	HL,XPOS		;Home is top left - not
	LD	(HL),0		;bottom left.
	INC	HL
	LD	(HL),0
	LD	HL,GOTO00	;Goto 0,0.
	JR	BUFOUT
;
MORE6:	CP	SUB		;Move cursor up?
	JR	NZ,MORE8
	LD	HL,YPOS		;Correct ypos.
	DEC	(HL)
	JR	SEND2
;
MORE8:	CP	LF		;Move cursor down?
	JR	NZ,MORE7
	LD	HL,YPOS		;Correct ypos.
	INC	(HL)
	JR	SEND2
;
MORE7:	CP	DLE		;Move to absolute address?
	JR	NZ,MORE1
	LD	A,2		;Say we are expecting 2 more
	LD	(ARMING),A	;characters.
	JR	RTRN1
MORE1:	CP	ETB		;Clear to end of line?
	JR	NZ,MORE2
	LD	HL,EREOL
	JP	BUFOUT
;
MORE2:	CP	CAN		;Clear to end of screen?
	JR	NZ,MORE3
	LD	HL,EREOS
	JP	BUFOUT
;
MORE3:	CP	FF		;Clear screen?
	JR	NZ,MORE4
	LD	HL,XPOS		;Correct xpos.
	LD	(HL),0
	INC	HL		;Correct ypos.
	LD	(HL),0
	JP	SEND2
;
MORE4:	CP	CR		;Return the carriage?
	JR	NZ,MORE5
	LD	HL,XPOS		;Correct xpos.
	LD	(HL),0
	JP	SEND2		;Left end of line.
MORE5:	JP	RTRN1		;Dump anything else.
;
GOTOXY:	DB	4		;String length.
	DB	VT
ROW1:	DB	0		;Row.
	DB	DLE
COLUMN:	DB	0		;Column.
;
EREOL:	DB	2
	DB	ESC		;Erase to end of line.
	DB	'K'
;
EREOS:	DB	2
	DB	ESC		;Erase to end of source.
	DB	'k'
;
GOTO00:	DB	4
	DB	DLE
	DB	0
	DB	VT
	DB	0
;
XPOS:	DB	0
YPOS:	DB	0		;Note above order is required.
;
ARMING:	DB	0		;Set to non-zero if processing absolute cursor move.
CONSTS:	DW	0		;ADDRESS OF STATUS BYTE.
;
;   = = = =   Keyboard Initialize Routine   = = = =
;
INITIZE:
	LD	(CONSTS),HL	;Save passed addresses.
	LD	DE,ENDADDR	;Return last used address.
	LD	HL,80*256+24	;Setup screen size.
	RET
;
;
;   = = = =   Keyboard De-initialize Routine   = = = =
;
REMOVE:
	PUSH	AF
	LD	A,SOH		;Home the cursor.
	CALL	SEND
	POP	AF
	RET
;
ENDADDR:EQU	$		;Set end of handler address.
;
;
	END
