;MODIFIED PROGR ROUTINE
;68766 SUPPORTED
;16X MODE FOR UART
;TO BE SHIPED AS VER 3.1
;MODIFIED ORDER OF SEARCH FOR BR :19.2->>50 BAUD
;STAR BEFORE EVERY ERROR MESSAGE
;PROGRAM ROUTINE MODIFIED TO TALK TO IBM PC WITH OLY'S DRIVER
;PROGR LED FLASH AFTER RESET

;PROGRAMMING L.E.D. IN
;ERROR ON 27128 CORRECTED.
;SHORT FORM OF MONITOR: LOAD, BREAK COMMANDS DELETED.
;MODIF FOR 2.2: ERROR ON 2532 CORRECTED
;	       WAIT 100 mS FOR 40 PIN BEFORE CHECKING DATA

;INTEL AND MOTOROLA FORMAT IN
;SEND XOFF AT END OF LINE OR AFTER 132 CHARACTERS
;CONVERT UPPER CASE TO LOWER
;WAIT 100 MS AFTER XOFF BEFORE HARD STOP
;140 CHAR MAX IN DATBUF
;WAIT 50 MS FOR 40 PIN'S BEFOR READING DATA
;DO NOT DROP DTR FOR THIS VERSION
;RING BELL AFTER PROGRAMMING
;VERSION 3.1:
;-NEW HELP COMMAND
;AUG 1: INTEL DUMP OK.
;AUG 3: 5513 EEPROM OK.
;AUG 11:FAST PROGRAMMING ATEMPT
;AUG 13:CHANGE INTEL DUMP TO 32 BYTES/LINE
;AUG 14:FAST O.K.
;       FIXED BUG IN PUT28 (BUS CONFLICT)
;       FIXED BUG IN PUT40
;AUG 23:VP COMMAND IN
;AUG 25: LOW/HIGH BYTE PROGRAMMING O.K.
;OCT 21: VER 3.2
;      2764A,27128A IN
;      COPY FUNCTION
;OCT 25: VER 3.3 : 2816A IMPLEMENTED
;
;MAR 17 1985: VER 3.3a  ADD COMMANDS SO INTEL 8748's and 8749's
;			program properly - add calls to DLY4tCY -
;			fix VERIFY command for 87XX parts -
;			fix MSG1,2,13,14 and 17
;			and add "o" command		 F.J.Loden
LEVEL	EQU	3		;Number  3.3a
REV	EQU	3		;Number
SUBREV	EQU	1		;Lower case letter
;
;------------------------;
;        EXECUTIVE       ;
;------------------------;

;INTERRUPT ADDRESSES

RES1	EQU	008H		;SOFT RESET FOR BREAK COMMAND
TRAP	EQU	024H		;TRAP INTERRUPT
RES55	EQU	02CH		;XMIT INTERRUPT
RES65	EQU	034H		;RCVE INTERRUPT
RES75	EQU	03CH		;TIMER INTERRUPT

;HARDWARE ASSIGNED ADDRESSES


RAM	EQU	0A000H		;START OF RAM
IOCTRL	EQU	0A100H		;I/O CONTROL
TIMCTRL	EQU	0A100H		;TIMER CONTROL
PORTA	EQU	0A101H		;I/O PORT A
PORTB	EQU	0A102H		;I/O PORT B
PORTC	EQU	0A103H		;I/O PORT C
PORTX	EQU	0C000H		;I/O PORT X
PORTY	EQU	08000H		;I/O PORT Y

TIMREG	EQU	0A104H		;TIMER CNT REGISTERS
TIMLO	EQU	0A104H		;TIMER LOW BYTE
TIMHI	EQU	0A105H		;TIMER HIGH BYTE

UART	EQU	0E000H		;R/W UART DATA
UCOMD	EQU	0E001H		;WRITE UART COMMAND
UCTRL	EQU	0E001H		;WRITE UART CONTROL
USTAT	EQU	0E001H		;READ UART STATUS

;CONSTANTS

INIT	EQU	040H		;START OF MONITOR
OVRRUN	EQU	010H		;READ OVERRUN FLAG
SET40	EQU	021H		;PATTERN FOR PORTC-SETUP FOR 40 PINERS
MAXSTR	EQU	014		;MAX STRING FOR COMMAND
MAXDAT	EQU	0132		;MAX STRING FOR RECEIVED DATA:132 CHARACTERS
TXRDY	EQU	001H		;MASK FOR TXRDY BIT
RXRDY	EQU	002H		;MASK FOR RXRDY BIT
XON	EQU	011H
XOFF	EQU	013H
NUMDIF	EQU	030H		;DIFFERENCE FROM ASCII NUMBERS TO HEX
UPLETD	EQU	037H		;DIFFERENCE FROM ASCII 'A-F' TO HEX
LOLETD	EQU	057H		;DIFFERENCE FROM ASCII 'a-f' TO HEX
ALLOUT	EQU	00FH		;ALL I/O OUTPUTS
PRTAIN	EQU	00EH		;PORT A INPUT, PORT B,C OUTPUT
PRTBIN	EQU	00DH		;PORT B INPUT, PORT A,C OUTPUT

RDSTAT	EQU	001H		;FILTER TO READ MASK DESCRIPTOR FOR READ STATUS
PGMSTAT	EQU	002H		;FILTER TO READ MASK DESCRIPTOR FOR PROGRAM STATUS
ERSTAT	EQU	020H		;FILTER TO READ MASK DESCRIPTOR FOR ERASE STATUS
LOPLSE	EQU	004H		;FILTER TO READ MASK DESCRIPTOR FOR LOW PULSE
HIPLSE	EQU	008H		;FILTER TO READ MASK DESCRIPTOR FOR HIGH PULSE
WIDTH	EQU	010H		;FILTER TO READ MASK DESCRIPTOR FOR PULSE WIDTH
VERSTAT	EQU	040H		;FILTER TO READ MASK DESCRIPTOR FOR VERIFY STATUS

BREK	EQU	0CFH		;OPCODE FOR RST1 INSTRUCTION
ECOFF	EQU	001H		;PATTERN FOR ECHO FLAG OFF
ECON	EQU	000H		;PATTERN FOR ECHO FLAG ON

BR300	EQU	003H		;PATTERN FOR 300 BAUD
BR600	EQU	006H		;PATTERN FOR 600 BAUD
BR1200	EQU	012H		;PATTERN FOR 1200 BAUD
BR1800	EQU	018H		;PATTERN FOR 1800 BAUD
BR2400	EQU	024H		;PATTERN FOR 2400 BAUD
BR4800	EQU	048H		;PATTERN FOR 4800 BAUD
BR9600	EQU	096H		;PATTERN FOR 9600 BAUD

;TIMER CONSTANTS

STRTIM	EQU	0CEH		;START TIMER
STPTIM	EQU	04EH		;STOP TIMER
;STRTIM & STPTIM WILL MAKE PORT A INPUT, PORT B,C OUTPUT

;BAUD RATE VALUES FOR QUARTZ = 4 MHZ

;B9600	EQU	0208		;COUNT TO 208 (BAUD RATE 9600)
;B4800	EQU	0416		;COUNT TO 416 (BAUD RATE 4800)
;B3600	EQU	0556		;COUNT TO 556 (BAUD RATE 3600)
;B2400	EQU	0833		;COUNT TO 833 (BAUD RATE 2400)
;B2000	EQU	01000		;COUNT TO 1000 (BAUD RATE 2000)
;B1800	EQU	01111		;COUNT TO 1111 (BAUD RATE 1800)
;B1200	EQU	01667		;COUNT TO 1667 (BAUD RATE 1200)
;B600	EQU	03333		;COUNT TO 3333 (BAUD RATE 600)
;B300	EQU	06667		;COUNT TO 6667 (BAUD RATE 300)
;B200	EQU	010000		;COUNT TO 10000 (BAUD RATE 200)
;B150	EQU	013333		;COUNT TO 13333 (BAUD RATE 150)

;BAUD RATE VALUES FOR 16X MODE

B192	EQU	06		;COUNT TO 6 (BAUD RATE 19200)
B9600	EQU	013		;COUNT TO 13 (BAUD RATE 9600)
B4800	EQU	026		;COUNT TO 26 (BAUD RATE 4800)
B3600	EQU	035		;COUNT TO 35 (BAUD RATE 3600)
B2400	EQU	052		;COUNT TO 52 (BAUD RATE 2400)
B2000	EQU	062		;COUNT TO 62 (BAUD RATE 2000)
B1800	EQU	069		;COUNT TO 69 (BAUD RATE 1800)
B1200	EQU	0104		;COUNT TO 104 (BAUD RATE 1200)
B600	EQU	0208		;COUNT TO 208 (BAUD RATE 600)
B300	EQU	0417		;COUNT TO 417 (BAUD RATE 300)
B200	EQU	0625		;COUNT TO 625 (BAUD RATE 200)
B150	EQU	0833		;COUNT TO 833 (BAUD RATE 150)
B50	EQU	02500		;COUNT TO 2500 (BAUD RATE 50)

;UART CONSTANTS

MODE	EQU	0CEH		;UART MODE WORD  1100 1110
STRTMOD	EQU	037H		;UART COMMAND WORD  0011 0111 (WILL RESET ERROR FLAGS)
STOPMOD	EQU	007H		;UART COMMAND TO STOP HOST 0000 0101
UREST	EQU	001110111B	;UART RESET WORD (RETURN TO MODE FORMAT)

;ASCII CONSTANTS

ASCNUL	EQU	000H		;3-3a
ASCCR	EQU	00DH		;3-3a
ASCLF	EQU	00AH		;3-3a
ASCSP	EQU	020H		;3-3a
ASC$	EQU	024H		;3-3a
CTLX	EQU	018H		;3-3a
;
;SIM MASKS

RONXON	EQU	00CH		;RCVE ON,  XMIT ON.
RONXOF	EQU	00DH		;RCVE ON,  XMIT OFF.
ROFXON	EQU	00EH		;RCVE OFF, XMIT ON.
ROFXOF	EQU	00FH		;RCVE OFF, XMIT OFF.

;RAM ASSIGNEMENT

STACK	EQU	0A100H		;TOP OF STACK

	PAGE
	ORG	RAM
;
; 3.3a	**** changed all db's to ds 1 and all dw's to ds 2 so Digital ****
;	**** Research's "MAC" would not put in hex output file        ****
;
UDATA:	DS	1		;1 BYTE FOR UART DATA
HEXNIB:	DS	1		;1 BYTE FOR HEX VALUE OF UART DATA
ACUM:	DS	1		;1 BYTE FOR ACUMULATOR DATA
DONEFL:	DS	1		;FLAG FOR END OF COMMAND ($)
VPFLAG:	DS	1		;FLAG FOR VERIFY PROGRAM MODE
FCOUNT:	DS	1		;FLAG TO COUNT THE # OF 1 MS PULSES APPLIED IN FAST PGM. MODE
CKSUM:	DS	1		;CHECK SUM FOR INTEL AND MOTOROLA DUMP
ECOFL:	DS	1		;ECHO FLAG
BAVFL:	DS	1		;BYTE AVAILABLE FLAG
OVRFLG:	DS	1		;OVERRUN FLAG
EOLFLG:	DS	1		;FLAG FOR END OF LINE
WIDEFL:	DS	1		;FLAG FOR 16 BIT DATA PATH PROGRAMMING
FLAG16:	DS	1		;0 FOR 8 BIT DATA PATH, 1 FOR LOW BYTE, 2 FOR HIGH BYTE
ASCII:	DS	2		;2 BYTES FOR ASCII VALUE OF THE ACUMULATOR
ADDR:	DS	2		;2 BYTES FOR ADDRESS FROM KEYBOARD
BUFCNT:	DS	1		;NUMBER OF CHARACTERS RECEIVED (IN BUFFER)
BUFPNT:	DS	2		;POINTER TO DATA BUFFER
TMPADR:	DS	2		;TEMP LOCATION TO STORE CRTADR

NIB11:	DS	1
NIB12:	DS	1
NIB13:	DS	1
NIB14:	DS	1

NIB21:	DS	1
NIB22:	DS	1
NIB23:	DS	1
NIB24:	DS	1

ADDR1:	DS	2
ADDR2:	DS	2

NIB1:	DS	1
NIB2:	DS	1
HEXDAT:	DS	1
CRTADR:	DS	2
ABSADR:	DS	2		;SUM OF CRTADR AND ADROFF

CMDBUF: DS 12			;12 BYTES FOR INPUT COMMAND
DATBUF: DS 140			;140 BYTES FOR DATA STRING

;CURRENT MASKS
;BYTE 1: SHOWS TO WHICH PIN OF PORTX OR Y IS CONNECTED THE CURRENT LINE

;|  X  |  X  |  X  |   X   |  X   |  X   |  X  | X  |
;|-----|-----|-----|-------|------|------|-----|----|
;|-X*/Y|VERIF|  -  | WIDTH |PLS HI|PLS LO|PROGR|READ|
;|-----|-----|-----|-------|------|------|-----|----|
;   |     |    |       |       |      |     |     |
; BIT7   BIT6 BIT5    BIT4    BIT3   BIT2  BIT1  BIT0

;BIT0: STATE OF THE PIN DURING READ
;BIT1: STATE OF THE PIN DURING PROGRAMMING
;BIT2: PIN PULSED LOW FOR PROGRAMMING
;BIT3: PIN PULSED HIGH FOR PROGRAMMING
;BIT4: 0-> PGM PULSE 2MS, 1-> PGM PULSE 50MS
;BIT5: NOT DEFINED
;BIT6: STATE OF THE PIN DURING VERIFY
;BIT7: 0->PORTX, 1->PORTY.

MASKTAB:
MSKVCC:	DS	2
MVPP5V:	DS	2
MVP21V:	DS	2
MVP25V:	DS	2
MFUNC1:	DS	2
MFUNC2:	DS	2
MFUNC3:	DS	2
MSKA08:	DS	2
MSKA09:	DS	2
MSKA10:	DS	2
MSKA11:	DS	2
MSKA12:	DS	2
MSKA13:	DS	2
MSKA14:	DS	2
MSKA15:	DS	2
MAXADR:	DS	2		;MAX ADDRESS
MSGPRT:	DS	2		;ADDRESS OF PROMPT MESSAGE

ADROFF:	DS	2		;3-3a - address offset for hex input/output
				;       absolute start address

SOCKET	EQU	MSKA09+1	;BIT SHOWS ACTIVE SOCKET(TURN ON LED)
MAXPLS	EQU	MSKA10+1	;MAX # OF 1 MS PULSES (FAST MODE)
PLSMUL	EQU	MSKA11+1	;PULSE MULTIPLIER
TIMDEL	EQU	MSKA14+1	;DELAY FOR EEPROMS WITH INTERNAL TIMER
CRTSTAT	EQU	MSKA15+1	;ERASE PROTECT, BYTE/CHIP* ERASE, FAST PROTECT

BRATE:	DS	1		;1 BYTE FOR BAUD RATE
FFLAG:	DS	1		;FLAG FOR FAST PROGRAMMING
IPRTC:	DS	1		;IMMAGE OF PORT C
IPRTX:	DS	1		;IMMAGE OF PORT X
IPRTY:	DS	1		;IMMAGE OF PORT Y
ENDRAM:	DS	1		;LAST LOCATION USED IN RAM

USDRAM	EQU	ENDRAM-RAM	;USED SPACE IN RAM
MAXNEST	EQU	STACK-ENDRAM	;MAX NUMBER OF CALLS POSSIBLE (STACK LIMITATION)
RAMCLR	EQU	MASKTAB-RAM-3	;RAM TO BE CLEARED WHEN LOOP
MAXMSK	EQU	MSGPRT-MASKTAB+2 ;BYTES TO BE MOVED WHEN MENU IS SET
;
; LOCAL MACROS TO DEFINE "RIM" AND "SIM"
; (because I don't have an 8085 cross-assembler)
;
RIM	MACRO			;3-3a
	DB	020H		;3-3a + RIM (8085 INST)
	ENDM			;3-3a
SIM	MACRO			;3-3a
	DB	030H		;3-3a + SIM (8085 INST)
	ENDM			;3-3a

	PAGE
;'INTERRUPT LOCATIONS'
	ORG	0

	DI
	JMP	START		;COLD START

	EI
	RET

	ORG	RES55		;XMIT INTERRUPT

RST55:  EI
	RET

	ORG	RES65		;RCVE INTERRUPT

RST65:  JMP	RCVE

	ORG	RES75		;TIMER INTERRUPT

RST75:  EI
	RET

	PAGE
; 'START OF MAIN PROGRAM'
	ORG	INIT

START:  LXI	SP,STACK	;INITIALIZE THE STACK POINTER

;FLASH PROGR LED

	MVI	E,3		;FLASH 3 TIMES

FLASH:  CALL	LITON		;LED ON
	CALL	WT05S		;WAIT 0.5 SEC
	CALL	LITOFF		;LED OFF
	CALL	WT05S
	DCR	E
	JNZ	FLASH

;INITIALIZE THE UART

UINIT:  MVI	A,MODE
	STA	UCOMD		;SET UART MODE
	MVI	A,STRTMOD
	STA	UCTRL		;SET UART COMMAND

	LXI	H,RAM		;POINT TO RAM
	MVI	B,ENDRAM-RAM	;TOTAL RAM USED
	CALL	CLEAR

;FIND THE BAUD RATE

TR9600: MVI	A,BR9600	;GET PATTERN

	LXI	H,B9600		;TRY 9600 BAUD
	CALL	SETBR
	JZ	FOUND

TR4800: MVI	A,BR4800

	LXI	H,B4800		;TRY 4800 BAUD
	CALL	SETBR
	JZ	FOUND

TR2400: MVI	A,BR2400

	LXI	H,B2400		;TRY 2400 BAUD
	CALL	SETBR
	JZ	FOUND

TR1800: MVI	A,BR1800

	LXI	H,B1800		;TRY 1800 BAUD
	CALL	SETBR
	JZ	FOUND

TR1200: MVI	A,BR1200

	LXI	H,B1200
	CALL	SETBR
	JZ	FOUND

TRY600: MVI	A,BR600

	LXI	H,B600		;TRY 600 BAUD
	CALL	SETBR
	JZ	FOUND

TRY300: MVI	A,BR300

	LXI	H,B300		;TRY 300 BAUD
	CALL	SETBR
	JZ	FOUND

	MVI	A,UREST		;RESET UART
	STA	UCTRL
	JMP	UINIT		;REINITIALIZE THE UART

FOUND:  CALL	RRDY
	CPI	ASCSP
	JNZ	TR9600		;TRY IT AGAIN

	LXI	D,MASKTAB	;POINT TO MASK TABLE
	LXI	H,CMSKTAB	;2732 TABLE
	CALL	MOVE		;SET DEFAULT MASKS (2732)

	LXI	H,MSGID
	CALL	PRINT
	JMP	STATUS		;PRINT STATUS, JUMP BACK

LOOP:   LXI	H,RAM		;POINT TO STORAGE SPACE
	MVI	B,RAMCLR	;CLEAR USED RAM
	CALL	CLEAR

	CALL	LITOFF		;PROGRAMMING LED OFF

	MVI	A,PRTAIN	;SET PORT A AS INPUT
	STA	IOCTRL		;

	XRA	A		;CLEAR ACUMULATOR
	STA	PORTB
	STA	PORTX
	STA	IPRTX
	STA	PORTY		;ALL I/O'S LOW
	STA	IPRTY		;ALL I/O IMMAGES LOW

	MVI	A,SET40
	STA	IPRTC
	STA	PORTC		;SET PORT C

PRPT:   LHLD	MSGPRT		;
	CALL	PRINT		;PRINT PROMPT

	MVI	B,MAXSTR	;COUNTER
	LXI	H,CMDBUF

	CALL	TKDAT		;WAIT FOR COMMAND DATA
	JC	LOOP		;'$' TYPED, OR TOO MANY CHARACTERS IN
	JZ	PRPT		;FIRST WAS 'cr', GET ANOTHER.
	LXI	D,CMDBUF

	LXI	H,MSG15		;"1p"
	CALL	COMP
	JZ	LPROG		;LOW BYTE PROGRAMMING

	LXI	H,MSG16		;"2p"
	CALL	COMP
	JZ	HPROG		;HIGH BYTE PROGRAMMING

	LXI	H,MSG1		;"l"
	CALL	COMP		;CHECK IF MSG1 WAS ENTERED
	JZ	LIST		;LIST

	LXI	H,MSG2		;"r"
	CALL	COMP		;CHECK IF MSG2 WAS ENTERED
	JZ	READ		;READ

	LXI	H,MSG3		;"p"
	CALL	COMP		;CHECK IF MSG3 WAS ENTERED
	JZ	PROGR		;AUTOMATED PROGRAMMING

	LXI	H,MSG4		;"vb"
	CALL	COMP		;CHECK IF MSG4 WAS ENTERED
	JZ	VERIF		;VERIFY

	LXI	H,MSG5		;"mp"
	CALL	COMP		;CHECK IF MSG5 WAS ENTERED
	JZ	MPROGR		;MANUAL PROGRAM

	LXI	H,MSG6		;"h"
	CALL	COMP		;
	JZ	PRCOM		;HELP - PRINT HELP MENU

	LXI	H,MSG7		;"m"
	CALL	COMP		;
	JZ	MENU		;DEVICE SELECTION MENU

	LXI	H,MSG8		;"x"
	CALL	COMP		;
	JZ	IDENT		;PRINT SIGN MESSAGE AND REV LEVEL

	LXI	H,MSG9		;" "
	CALL	COMP		;
	JZ	LOOP		;MESSAGE STARTS WITH 'space' - IGNORE

	LXI	H,MSG11
	CALL	COMP
	JZ	MLOOP		;GO INTO MONITOR

	LXI	H,MSG12		;"fp"
	CALL	COMP
	JZ	FMODE		;FAST MODE

	LXI	H,MSG13		;"il"
	CALL	COMP
	JZ	ILIST		;INTEL LIST

	LXI	H,MSG14		;"mol"
	CALL	COMP
	JZ	MLIST		;MOTOROLA LIST

	LXI	H,MSG17		;"e"
	CALL	COMP
	JZ	EERAS		;ERASE EEPROM

	LXI	H,MSG18		;"sp"
	CALL	COMP
	JZ	SMODE		;SLOW MODE

	LXI	H,MSG19		;"?"
	CALL	COMP
	JZ	STATUS		;DISPLAY STATUS

	LXI	H,MSG20		;"vp"
	CALL	COMP
	JZ	VPROG		;VERIFY PROGRAMMING

	LXI	H,MSG21		;"copy"
	CALL	COMP
	JZ	COPY		;COPY ALL PROGRAM

	LXI	H,MSG22		;3-3a - "o"
	CALL	COMP		;3-3a
	JZ	SETOFF		;3-3a - set address offset for in/output
				;3-3a - of files
;
;APPEND MORE MESSAGES IF NECESSARY

INVAL:  LXI	H,MSGN
	CALL	PRINT		;PRINT 'invalid command'
	JMP	LOOP		;WAIT FOR ANOTHER STRING

PRCOM:  LXI	H,MSGH
	CALL	PRINT
	JMP	LOOP

IDENT:  LXI	H,MSGID
	CALL	PRINT
	JMP	LOOP

	PAGE
;-----------------------;
;     MENU FUNCTION     ;
;-----------------------;

MENU:   LDA	CMDBUF+1	;NEXT CHARACTER AFTER M
	CPI	0
	JNZ	OVERM		;SOMETHING IS THERE, CHECK WHAT

	LXI	H,MSGMEN
	CALL	PRINT

STMENU: CALL	RRDY		;WAIT FOR DATA
	CALL	ECHO

OVERM:  LXI	D,MASKTAB
	CPI	'a'		;2758
	JZ	AMENU

	CPI	'b'		;27(C)16
	JZ	BMENU

	CPI	'c'		;27(C)32
	JZ	CMENU

	CPI	'd'		;2732A
	JZ	DMENU

	CPI	'e'		;2764
	JZ	EMENU

	CPI	'f'		;2764A
	JZ	FMENU

	CPI	'g'		;27128
	JZ	GMENU

	CPI	'h'		;27128A
	JZ	HMENU

	CPI	'i'		;27256
	JZ	IMENU

	CPI	'j'		;spare (will be 27512)
	JZ	JMENU

	CPI	'k'		;2508
	JZ	KMENU

	CPI	'l'		;2516
	JZ	LMENU

	CPI	'm'		;2532
	JZ	MMENU

	CPI	'n'		;2564
	JZ	NMENU

	CPI	'o'		;68732
	JZ	OMENU

	CPI	'p'		;68764
	JZ	PMENU

	CPI	'q'		;68766
	JZ	QMENU

	CPI	'r'		;2816A
	JZ	RMENU

	CPI	's'		;2832A
	JZ	SMENU

	CPI	't'		;2864A
	JZ	TMENU

	CPI	'u'		;52B13
	JZ	UMENU

	CPI	'v'		;52B23
	JZ	VMENU

	CPI	'w'		;52B33
	JZ	WMENU

	CPI	'x'		;52B43
	JZ	XMENU

	CPI	'y'		;spare
	JZ	YMENU

	CPI	'1'		;spare (will be 8751)
	JZ	X1MENU

	CPI	'2'		;spare (will be 8755)
	JZ	X2MENU

	CPI	'3'		;8748H
	JZ	X3MENU

	CPI	'4'		;8749H
	JZ	X4MENU

	JMP	LOOP

	PAGE
AMENU:  LXI	H,AMSKTAB	;2758
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

BMENU:  LXI	H,BMSKTAB	;27(C)16
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

CMENU:  LXI	H,CMSKTAB	;27(C)32
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

DMENU:  LXI	H,DMSKTAB	;2732A
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

EMENU:  LXI	H,EMSKTAB	;2764
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

FMENU:  LXI	H,MSGSW		;2764A
	CALL	PRINT		;PRINT "SET SW2 @ 01XX"
	LXI	H,EMSKTAB
	CALL	MOVE		;USE TABLE FOR 2764
	LXI	H,PRMPTF
	SHLD	MSGPRT		;SET PROMPT
	JMP	LOOP

GMENU:  LXI	H,GMSKTAB	;27128
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

HMENU:  LXI	H,MSGSW		;27128A
	CALL	PRINT		;PRINT "SET SW2 @ 01XX"
	LXI	H,GMSKTAB
	CALL	MOVE		;USE TABLE FOR 27128
	LXI	H,PRMPTH
	SHLD	MSGPRT		;SET PROMPT
	JMP	LOOP

IMENU:  LXI	H,MSGSW		;27256
	CALL	PRINT		;PRINT "SET SW2 @ 01XX"
	LXI	H,IMSKTAB
	CALL	MOVE
	JMP	LOOP

JMENU:  JMP	LOOP		;NOT SUPPORTED (will be 27512)

KMENU:  LXI	H,KMSKTAB	;2508
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

LMENU:  LXI	H,LMSKTAB	;2516
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

MMENU:  LXI	H,MMSKTAB	;2532
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

NMENU:  LXI	H,NMSKTAB	;2564
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

OMENU:  LXI	H,OMSKTAB	;68732
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

PMENU:  LXI	H,PMSKTAB	;68764
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

QMENU:  LXI	H,QMSKTAB	;68766
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

RMENU:  LXI	H,RMSKTAB	;2816A
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

SMENU:  JMP	LOOP		;NOT SUPPORTED (will be 2832A)

TMENU:  JMP	LOOP		;NOT SUPPORTED (will be 2864A)

UMENU:  LXI	H,UMSKTAB	;52B13
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

VMENU:  LXI	H,VMSKTAB	;52B23
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

WMENU:  LXI	H,WMSKTAB	;52B33
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

XMENU:  JMP	LOOP		;NOT SUPPORTED (will be 52B43)

YMENU:  JMP	LOOP		;NOT SUPPORTED (spare)
X1MENU: JMP	LOOP		;NOT SUPPORTED (will be 8751)
X2MENU: JMP	LOOP		;NOT SUPPORTED (will be 8755)

X3MENU: LXI	H,X3MSGPRT-MAXMSK+2	;8748H
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

X4MENU: LXI	H,X4MSGPRT-MAXMSK+2	;8749H
	CALL	MOVE		;SET CURRENT MASK
	JMP	LOOP

	PAGE
;-----------------------;
; DISPLAY STATUS CMD    ;
;-----------------------;

;MNEMONIC: '?'
;WILL DISPLAY:	PROG MODE
;		BAUD RATE
;		ABSOLUT START ADDR (OFFSET)
;		MAX. RELATIVE ADDR

STATUS: LXI	H,MSGPMOD
	CALL	PRINT		;PRINT 'programming mode:'
	LDA	FFLAG
	CPI	0
	JZ	SLMODE		;SLOW MODE

;FAST MODE

	LXI	H,MSGFST
	CALL	PRINT
	JMP	NXTSTAT		;PRINT NEXT STATUS (BAUD RATE)

SLMODE: LXI	H,MSGSLW
	CALL	PRINT

NXTSTAT:LXI	H,MSGBR
	CALL	PRINT		;PRINT 'current baud rate:'

	LDA	BRATE		;GET PATTERN FOR HIGH BYTE
	MOV	H,A		;PUT INTO H
	MVI	L,0		;CLEAR L
	CALL	PRHL		;PRINT BAUD RATE

	LXI	H,MSGOFF	;3-3a
	CALL	PRINT		;3-3a - PRINT 'absolute start address:'

	LHLD	ADROFF		;3-3a - GET OFFSET
	CALL	PRHL		;3-3a - PRINT ADDRESS OFFSET
	LXI	H,MSGMAX
	CALL	PRINT		;PRINT 'relative high addr:'

	LHLD	MAXADR		;GET MAX ADDRESS
	CALL	PRHL

	JMP	LOOP
	PAGE
;-----------------------------;
; SET ABSOLUTE ADDRESS OFFSET ;
;-----------------------------;

;SET MEMORY LOCATION ADROFF TO THE SPECIFIED VALUE
;COMMAND IS AS FOLLOWS: 'o [adroff]'
;IF ADROFF IS BLANK A VALUE OF 0 IS USED
;
SETOFF:	CALL	MKADR		;3-3a - CONVERT INPUT TO ADDRESS
	LHLD	ADDR2		;3-3a - ** GET COMPUTED OFFSET
	SHLD	ADROFF		;3-3a - AND SAVE IT
	JMP	LOOP		;3-3a - GO LOOK FOR MORE INPUT
	PAGE

;-----------------------;
;   LIST FUNCTION       ;
;-----------------------;

;LIST CONTENT OF THE SELECTED EPROM, IN THE FOLLOWING FORMAT:
;[ADDR] [DATA] [DATA] [DATA] [DATA]...[DATA] (16 BYTES)
;START AT [ADR1] AND END AT [ADR2] (TYPED)
;BY DEFAULT, ADDRESS2 EQU MAXADR

LIST:   CALL	MKADR
	LHLD	ADDR1
	SHLD	CRTADR
	CALL	STADR2		;SET ADDR2 (IF ZERO)

LINE:   LXI	H,MSGCRLF
	CALL	PRINT

	CALL	CKBRK		;CHECK FOR '$' AND XOFF
	JZ	LOOP		;'$' RECEIVED

	CALL	GETABS		;3-3a - GET ABSOLUTE ADDRESS IN HL
	CALL	PRHL		;AND PUT ON CRT

SPACE:  MVI	A,ASCSP
	STA	UDATA
	CALL	ECHO

NEXT:   CALL	GETDAT		;
	CALL	PRASCI

	CALL	CKEND
	JZ	LOOP		;TERMINATE

	LHLD	CRTADR		;UPDATE LOCAL INDEX
	INX	H
	SHLD	CRTADR

	MOV	A,L		;CHECK IF 16 BYTES PRINTED
	ANI	0FH
	CPI	0
	JZ	LINE

	ANI	01H		;PRINT SPACE BETWEEN EACH PAIR OF BYTES
	CPI	0
	JZ	SPACE

	JMP	NEXT

CKSM:		;WILL MAKE THE SUM BETWEEN CKSUM LOCATION AND A REGISTER
	MOV	B,A		;SAVE INTO B
	LDA	CKSUM
	ADD	B
	STA	CKSUM
	RET

STADR2:		;IF ADDR2 = 0 (NOT GIVEN FROM THE TERMINAL), SET IT TO FFFF
	LDA	ADDR2
	CPI	0
	RNZ			;ADDR2 NOT ZERO, RETURN
	LDA	ADDR2+1
	CPI	0
	RNZ
	LXI	H,0FFFFH
	SHLD	ADDR2
	RET
	PAGE
;-----------------------;
;   ILIST FUNCTION      ;
;-----------------------;

;LIST CONTENT OF THE SELECTED EPROM, IN INTEL FORMAT:
;START AT [ADR1] AND END AT [ADR2] (TYPED)
;BY DEFAULT, ADDRESS2 EQU MAXADR

ILIST:  CALL	MKADR
	LHLD	ADDR1
	SHLD	CRTADR
	CALL	STADR2

ILINE:  CALL	CKBRK		;CHECK FOR '$' AND XOFF
	JZ	IEND		;'$' RECEIVED

	LXI	H,MSGINT
	CALL	PRINT		;PRINT ':'

	CALL	BCOUNT		;GET BYTE COUNT FOR CURRENT LINE

	LDA	ACUM		;GET BYTE COUNT
	STA	CKSUM		;SET CHECK SUM = BYTE COUNT
	CALL	PRASCI		;PRINT BYTE COUNT

	CALL	GETABS		;3-3a - COMPUTE CURRENT ABSOLUTE ADDRESS
	LDA	ABSADR		;3-3a - LOW BYTE OF ADDRESS
	CALL	CKSM
	LDA	ABSADR+1	;3-3a - HIGH BYTE OF ADDRESS
	CALL	CKSM

	LHLD	ABSADR		;3-3a - GET ABSOLUTE ADDRESS BACK TO OUTPUT
	CALL	PRHL

	XRA	A
	STA	ACUM
	CALL	PRASCI		;PRINT '00'

INEXT:  CALL	GETDAT		;
	CALL	PRASCI

	LDA	ACUM		;GET DATA
	CALL	CKSM

	CALL	CKEND
	JZ	ILOOP		;TERMINATE

	LHLD	CRTADR
	INX	H
	SHLD	CRTADR

	MOV	A,L
	ANI	1FH
	CPI	0
	JNZ	INEXT

	LDA	CKSUM
	CMA
	ADI	1
	STA	ACUM
	CALL	PRASCI

	JMP	ILINE

ILOOP:  LDA	CKSUM
	CMA
	ADI	1
	STA	ACUM
	CALL	PRASCI

IEND:   LXI	H,MSIEND
	CALL	PRINT
	JMP	LOOP

BCOUNT:		;CALCULATE BYTE COUNT USING THE ACUM LOCATION

	LHLD	CRTADR		;GET CURRENT ADDRESS
	SHLD	TMPADR		;SAVE IT TEMPORARY

	XRA	A
	STA	ACUM		;CLEAR BYTE COUNT

CNT:    LDA	ACUM		;GET BYTE COUNT
	INR	A		;INCREMENT
	STA	ACUM

	CALL	CKEND		;CHECK FOR END
	JZ	ENDCNT		;STOP COUNTING

	LHLD	CRTADR
	INX	H
	SHLD	CRTADR		;INCREMENT CURRENT ADDRESS

	MOV	A,L		;LOW BYTE OF ADDRESS
	ANI	1FH		;ONLY RIGHT NIBBLE
	CPI	0		;MULTIPLE OF 10 ?H
	JNZ	CNT		;NO, COUNT NEXT BYTE

ENDCNT: LHLD	TMPADR		;GET OLD CURRENT ADDRESS
	SHLD	CRTADR		;RESTORE IT
	RET

	PAGE
;-----------------------;
;   MLIST FUNCTION      ;
;-----------------------;

;LIST CONTENT OF THE SELECTED EPROM, IN MOTOROLA FORMAT:
;START AT [ADR1] AND END AT [ADR2] (TYPED)
;BY DEFAULT, ADDRESS2 EQU MAXADR

MLIST:  CALL	MKADR
	LHLD	ADDR1
	SHLD	CRTADR
	CALL	STADR2

MLINE:  CALL	CKBRK		;CHECK FOR '$' AND XOFF
	JZ	MEND		;'$' RECEIVED

	LXI	H,MSGMOT
	CALL	PRINT

	CALL	BCOUNT		;GET BYTE COUNT FOR CURRENT LINE

	LDA	ACUM		;GET BYTE COUNT
	ADI	3		;+3 FOR MOTOROLA FORMAT
	STA	ACUM		;SAVE FOR PRASCI

	STA	CKSUM		;SET CHECK SUM = BYTE COUNT
	CALL	PRASCI		;PRINT BYTE COUNT

	CALL	GETABS		;3-3a - COMPUTE ABSOLUTE ADDRESS
	LDA	ABSADR		;3-3a - LOW BYTE OF ADDRESS
	CALL	CKSM
	LDA	ABSADR+1	;3-3a - HIGH BYTE OF ADDRESS
	CALL	CKSM

	LHLD	ABSADR		;3-3a
	CALL	PRHL

MNEXT:  CALL	GETDAT		;
	CALL	PRASCI

	LDA	ACUM		;GET DATA
	CALL	CKSM

	CALL	CKEND
	JZ	MOTLP		;TERMINATE

	LHLD	CRTADR
	INX	H
	SHLD	CRTADR

	MOV	A,L
	ANI	1FH
	CPI	0
	JNZ	MNEXT

	LDA	CKSUM
	CMA
	STA	ACUM
	CALL	PRASCI

	JMP	MLINE

MOTLP:  LDA	CKSUM
	CMA
	STA	ACUM
	CALL	PRASCI

MEND:   LXI	H,MSMEND
	CALL	PRINT
	JMP	LOOP

	PAGE
;-----------------------;
;   READ FUNCTION       ;
;-----------------------;
;READ THE CONTENT OF THE EPROM, FROM [ADR1] TO [ADR2]

READ:   CALL	MKADR
	LHLD	ADDR1
	SHLD	CRTADR
	CALL	STADR2

DAT:    CALL	CKBRK		;CHECK FOR '$' AND XOFF
	JZ	LOOP		;'$' RECEIVED

	CALL	GETDAT		;
	CALL	PRASCI

	CALL	CKEND		;CHECK IF END LIMIT REACHED
	JZ	LOOP		;TERMINATE

	LHLD	CRTADR
	INX	H
	SHLD	CRTADR		;INCREMENT ADDRESS

	JMP	DAT		;ONE MORE LOCATION

;-----------------------;
;   ERASE FUNCTION      ;
;-----------------------;

;CHIP ERASE FOR EEPROM'S
;BYTE ERASE PERFORMED BY WRITING X'FF TO ONE LOCATION
;IF CHIP ERASE WILL NOT BE POSSIBLE TO IMPLEMENT(EX 2816) DUE
; TO LACK OF PROPER VOLTAGE, WILL MAKE A BYTE ERASE TO ALL
; LOCATIONS

EERAS:  LDA	CRTSTAT
	ANI	01H		;CHECK ERASE PROTECT BIT
	CPI	0		;O.K. TO ERASE?
	JZ	ERS		;YES, GO AHEAD

	LXI	H,MSGUV	;
	CALL	PRINT		;PRINT 'use u.v. to erase'
	JMP	LOOP

ERS:    CALL	MKADR
	LHLD	ADDR1
	SHLD	CRTADR
	CALL	STADR2		;SET ADDR2 (IF ZERO)

	LDA	CMDBUF+1	;NEXT CHAR AFTER 'e'
	CPI	0		;ANYTHING THERE?
	JNZ	BYTERS		;YES, ERASE BY BYTE

	LDA	CRTSTAT
	ANI	02H		;CHECK BYTE/CHIP ERASE BIT
	CPI	0		;OK TO ERASE WHOLE CHIP ?
	JNZ	BYTERS		;NO, ERASE BY BYTE

;ONLY 'e' ENTERED, ERASE THE WHOLE CHIP

	MVI	D,ERSTAT
	CALL	SETSTAT		;SET ERASE STATE
	CALL	PULSE
	JMP	LOOP

BYTERS: MVI	A,0FFH
	STA	HEXDAT

ERSIT:  CALL	PUTDAT		;PROGRAM FF'S
	JNZ	ERRERS		;CAN NOT ERASE THIS ADDRESS

	CALL	CKEND
	JZ	LOOP

	LHLD	CRTADR
	INX	H
	SHLD	CRTADR

	JMP	ERSIT		;ERASE ONE MORE BYTE

ERRERS: LXI	H,MSGERS	;CAN'T ERASE MESSAGE
	CALL	PRINT
	LHLD	CRTADR
	CALL	PRHL
	JMP	LOOP

	PAGE
;-----------------------;
;   VERIFY FUNCTION     ;
;-----------------------;

;VERIFY ERASURE FROM 0 TO END
;CHECK IF EVERY LOCATION HAS ALL 1's (0'S IF 40 PINS)
;IF NOT, PRINT [DATA]@ [ADDRESS]

VERIF:  LXI	H,0
	SHLD	CRTADR		;START ADDRESS
	LXI	H,0FFFFH
	SHLD	ADDR2

	LXI	H,MSGCRLF
	CALL	PRINT		;RETURN CARRIAGE

VER:    CALL	CKBRK		;CHECK FOR '$' OR XOFF
	JZ	LOOP

	CALL	GETDAT		;GET DATA AT CRTADR
	CALL	CK40		;40 PINS?
	JZ	VER40		;YES, CHECK IF ALL 0'S

	LDA	ACUM		;DATA
	CPI	0FFH		;CHECK IF ALL 1'S
	JZ	OVERV		;THIS LOCATION O.K., CHECK NEXT ONE
	JMP	NERAS		;DEVICE NOT ERASED, PRINT DATA

VER40:  LDA	ACUM
	CPI	0		;DEV HAS 40 PINS, CHECK IF DATA = 0
	JZ	OVERV		;THIS LOCATION O.K., CHECK NEXT ONE

NERAS:  CALL	PRASCI		;PRINT DATA

	MVI	A,ASCSP
	STA	UDATA
	CALL	ECHO		;PRINT A SPACE

	MVI	A,'@'
	STA	UDATA
	CALL	ECHO		;PRINT '@'

	LHLD	CRTADR		;GET CURRENT ADDRESS
	CALL	PRHL		;PRINT IT

	LXI	H,MSGCRLF
	CALL	PRINT		;RETURN CARRIAGE

OVERV:  CALL	CKEND		;CHECK IF DONE
	JZ	LOOP		;TERMINATE

	LHLD	CRTADR
	INX	H
	SHLD	CRTADR		;SET NEXT ADDRESS
	JMP	VER		;VERIFY ONE MORE LOCATION

	PAGE
		;-----------------------;
		;  LOW/HI BYTE PROGRAM  ;
		;-----------------------;

;FORMAT: 1P: PROGRAM LOW BYTE
;        2P: PROGRAM HIGH BYTE

LPROG:  MVI	A,1
	STA	FLAG16
	JMP	PROGR		;PROGRAM

HPROG:  MVI	A,3
	STA	FLAG16
	JMP	PROGR

		;-----------------------;
		;  FAST/SLOW PROGRAM	;
		;-----------------------;

;FAST MODE
;FORMAT: FAST

FMODE:  MVI	A,1
	STA	FFLAG		;SET FAST FLAG
	JMP	LOOP

		;-----------------------;
		;  SMODE FUNCTION       ;
		;-----------------------;

;SLOW MODE
;FORMAT: SLOW

SMODE:  XRA	A
	STA	FFLAG		;CLEAR FAST FLAG
	JMP	LOOP

		;-------------------------;
		;  VERIFY PROGRAM FUNCTION;
		;-------------------------;

VPROG:  MVI	A,1
	STA	VPFLAG		;SET FLAG

		;-----------------------;
		;  PROGRAM FUNCTION     ;
		;-----------------------;

;AUTOMATED PROGRAM- USING A COMPUTER LINK
;NO ECHO PROVIDED
;CHECKS FOR : OVERRUN, BAD DATA, GOOD PROGRAMMING

PROGR:  CALL	LITON		;LED ON

	CALL	MKADR		;GET START ADDRESS
	LHLD	ADDR2		;START ADDRESS IS AT ADDR2
	SHLD	CRTADR		;SET CURRENT ADDRESS
	LXI	H,0FFFFH		;
	SHLD	ADDR2		;BYPASS CKEND

SETUP:  MVI	B,MAXDAT	;# OF BYTES TO BE CLEARED
	LXI	H,DATBUF	;START ADDRESS
	CALL	CLEAR		;CLEAR BUFFER

	LDA	OVRFLG		;GET OVERRUN FLAG
	CPI	0		;SET FLAGS
	JZ	CONT		;CONTINUE, NO OVERRUN SENSED

	LXI	H,MSGOVR	;POINT TO OVERRUN MESSAGE
	CALL	PRINT
	JMP	EXIT		;TERMINATE

CONT:   XRA	A		;CLEAR ACUMULATOR
	STA	BUFCNT		;ZERO CHARACTERS RECEIVED
	STA	DONEFL		;NOT DONE
	STA	EOLFLG		;CLEAR EOL FLAG

	LXI	H,DATBUF	;ADDRESS OF BUFFER
	SHLD	BUFPNT		;SET POINTER TO START

	MVI	A,RONXOF	;RCVE ON, XMIT OF
	SIM			;ENABLE RCVE INTERRUPT
	CALL	STRTIT		;RESET OVR FLAG

WTDATA: EI

	LDA	DONEFL		;CHECK IF DONE
	CPI	1
	JZ	DOIT		;USE DATA IN THE BUFFER

	LDA	BUFCNT		;# OF CHAR. RECEIVED
	CPI	MAXDAT
	JNC	LAST		;BUFFER FULL

	LDA	EOLFLG		;GET EOL FLAG
	CPI	0		;FLAG CLEAR?
	JZ	WTDATA		;WAIT UNTIL LINE ENDS

LAST:   CALL	SXOFF		;SEND XOFF
	CALL	WT100MS
	CALL	STOPIT

DOIT:   DI
	LXI	H,DATBUF
	SHLD	BUFPNT		;RESTORE POINTER TO START OF BUFFER

	CALL	CKFORM		;CHECK IF INTEL OR MOTOROLA FORMAT, SET POINTERS IF YES
	JZ	DONEP		;END OF RECORD

CYCLE:  LHLD	BUFPNT		;GET POINTER
	MOV	A,M		;GET CHARACTER
	CPI	0		;END OF BUFFER?
	JZ	AGAIN		;YES, FILL BUFFER AGAIN

	CPI	ASC$		;END OF STRING?
	JZ	DONEP		;TERMINATE PROGRAMMING

	CALL	CKHEX		;SEE IF DATA IS CORRECT, CONVERT TO HEX
	JC	BADDAT		;PRINT MESSAGE, EXIT.

	STA	NIB1		;SET FIRST NIBBLE
	INX	H		;SECOND NIBBLE
	MOV	A,M		;GET IT

	CPI	0		;END OF BUFFER?
	JZ	AGAIN		;FILL BUFFER AGAIN

	CPI	ASC$		;END OF STRING?
	JZ	DONEP		;TERMINATE

	CALL	CKHEX		;CORRECT DATA?
	JC	BADDAT		;PRINT MESSAGE, EXIT IF BAD DATA

	STA	NIB2		;SET SECOND NIBBLE
	INX	H		;POINT TO NEXT CHARACTER
	SHLD	BUFPNT		;SET POINTER

	LXI	H,NIB2
	LXI	D,HEXDAT	;SET-UP FOR MKBYT ROUTINE
	CALL	MKBYT		;GET HEX BYTE

	CALL	PUTDAT		;PROGRAM CRTADR WITH HEXDAT
	JNZ	ERRPGM		;EXIT WITH MESSAGE IF CAN'T PROGRAM

	CALL	CKEND		;CHECK IF CRTADR < MAXADR
	JZ	DONEP		;TERMINATE, NO MORE ROOM IN EPROM

	LHLD	CRTADR		;GET CURRENT ADDRESS
	INX	H		;NEXT ADDRESS TO BE PROGRAMMED
	SHLD	CRTADR		;SET IT

	LDA	BUFCNT
	DCR	A
	STA	BUFCNT
	JNZ	CYCLE		;PROGRAM ONE MORE LOCATION

AGAIN:  LDA	USTAT		;GET STATUS
	ANI	OVRRUN		;CHECK FOR OVERRUN
	STA	OVRFLG		;SET FLAG

	CALL	STRTIT		;START UATR
	CALL	SXON		;SEND XON
	JMP	SETUP		;FILL BUFFER AGAIN

	PAGE
		;---------------------;
		;  CKFORM SUBROUTINE  ;
		;---------------------;

;AT ENTRY H,L POINTS TO DATA BUFFER
;CHECK IF INTEL OR MOTOROLA FORMAT PRESENT
;SET CRTADR, BUFCNT IF YES
;RETURN WITH ZERO SET IF END RECORD

CKFORM: MOV	A,M		;FIRST CHAR IN BUFF
	CPI	':'		;INTEL?
	JZ	INTFORM		;SET INTEL CONDITIONS

	CPI	's'		;
	RNZ			;NO SPECIAL FORMAT

	INX	H		;FIRST BYTE WAS 's', CHECK SECOND
	MOV	A,M
	CPI	'9'		;MOTOROLA END RECORD?
	RZ			;RETURN WITH ZERO SET IF YES

	CPI	'1'		;MOTOROLA FORMAT?
	RNZ			;NO, RETURN WITH ZERO CLEAR

MOTFORM:INX	H		;POINT TO # OF BYTES
	CALL	SETFORM

	LHLD	BUFCNT		;GET # OF BYTES
	DCX	H
	DCX	H
	DCX	H		;THREE LESS FOR MOTOROLA FORMAT
	SHLD	BUFCNT

	RET			;RETURN WITH CARRY SET (SETFORM) IF BAD DATA

INTFORM:INX	H		;POINT TO FIRST NIBBLE OF # OF BYTES
	MOV	A,M
	CPI	'0'		;FIRST NIBBLE ZERO?

	JNZ	SETINT		;NOT END RECORD, SET PARAMETERS FOR INTEL
	INX	H		;SECOND NIBBLE
	MOV	A,M
	DCX	H		;RESTORE H,L TO FIRST NIBBLE
	CPI	'0'		;SECOND NIBBLE ALSO ZERO?

	RZ			;INTEL END RECORD, RETURN WITH ZERO SET

SETINT: CALL	SETFORM
	LHLD	BUFPNT		;GET POINTER TO BUFFER
	INX	H
	INX	H		;INTEL HAS TWO EXTRA BYTES BEFORE DATA
	SHLD	BUFPNT		;SET POINTER
	RET			;RETURN WITH CARRY SET (SETFORM) IF BAD DATA

	PAGE
		;----------------------;
		;  SETFORM SUBROUTINE  ;
		;----------------------;

;PUT CURRENT # OF BYTES AT BUFCNT, ADDRESS AT CRTADR
;AT ENTRY H,L POINTS TO FIRST NIBBLE IN # OF BYTES
;RETURN WITH ZERO CLEAR, CARRY SET IF BAD DATA RECEIVED

SETFORM:MOV	A,M		;GET FIRST NIBBLE
	CALL	CKHEX		;CHECK IF VALID ASCII, CONV TO HEX
	RC			;BAD DATA
	STA	NIB1

	INX	H
	MOV	A,M
	CALL	CKHEX		;CHECK IF VALID ASCII, CONV TO HEX
	RC			;BAD DATA
	STA	NIB2

	SHLD	BUFPNT		;SAVE H,L

	LXI	H,NIB2
	LXI	D,BUFCNT
	CALL	MKBYT		;SET # OF BYTES AT BUFCNT

	LHLD	BUFPNT		;GET POINTER TO BUFFER
	INX	H		;POINT TO ADDRESS
	LXI	D,CMDBUF+1	;WHERE TO MOVE THE ADDRESS
	MVI	B,4

PUTADR: MOV	A,M		;GET NIBBLE
	XCHG			;EXCHANGE POINTERS
	MOV	M,A		;PUT NIBBLE
	INX	H
	INX	D
	XCHG
	DCR	B
	JNZ	PUTADR		;MOVE FOUR NIBBLES

	SHLD	BUFPNT		;SET BUFPNT (MOTOROLA ONLY)

	CALL	MKADR
	LHLD	ADDR2		;GET START ADDRESS
;
;COMPUTE RELATIVE ADDRESS FROM PASSED ABSOLUTE ADDRESS
;
	XCHG			;3-3a - GET ABSOLUTE ADDRESS TO DE
	LHLD	ADROFF		;3-3a - GET ABSOLUTE START ADDRESS
	MOV	A,E		;3-3a - GET LOW BYTE OF ABSOLUTE ADDRESS
	SUB	L		;3-3a - PULL OFF ABSOLUTE START LOW BYTE
	MOV	L,A		;3-3a - SAVE RELATIVE ADDRESS LOW BYTE
	MOV	A,D		;3-3a - GET HIGH BYTE OF ABSOLUTE ADDRESS
	SBB	H		;3-3a - PULL OFF ABSOLUTE START HIGH BYTE
	MOV	H,A		;3-3a - HL = RELATIVE CURRENT ADDRESS
	JNC	PUTAD1		;3-3a - NOT TOO LOW - CONTINUE
;
;ABSOLUTE ADDRESS SMALLER THAN ABSOLUT START ADDRESS
; PRINT ERROR MESSAGE AND LOOP
;
	PUSH	D		;3-3a - SAVE PASSED ADDRESS
	CALL	STRTIT		;3-3a - START UART
	LXI	H,MSGCRLF	;3-3a
	CALL	PRINT		;3-3a - PRINT 'CR' AND 'LF' FIRST
	POP	H		;3-3a - GET BACK PASSED ADDRESS
	CALL	PRHL		;3-3a - PRINT PASSED ADDRESS
	LXI	H,MSGBAS	;3-3a
	CALL	PRINT		;3-3a - PRINT ' below absolute start address of '
	LHLD	ADROFF		;3-3a
	CALL	PRHL		;3-3a - PRINT ABSOLUTE ADDRESS
	JMP	EXIT		;3-3a - AND GET OUT

PUTAD1:	SHLD	CRTADR		;SET CRTADR
	LXI	H,0FFFFH
	SHLD	ADDR2		;BYPASS CKEND FOR ADDR2 (CHECK ONLY FOR MAXADR)

	XRA	A
	CPI	1		;CLEAR ZERO FLAG, SET CARRY
	CMC			;CLEAR CARRY
	RET			;ZERO, CARRY CLEAR

	PAGE
		;-------------------------;
		;  EXIT & ERROR MESSAGES  ;
		;-------------------------;

ERRPGM: CALL	STRTIT		;START UART
	CALL	PRCANT		;PRINT 'can'T PROG.' MSG
	JMP	EXIT		;TERMINATE

BADDAT: CALL	STRTIT		;START UART
	LXI	H,MSGERR	;POINT TO MESSAGE
	CALL	PRINT		;PRINT IT

	LHLD	CRTADR		;GET CURRENT ADDRESS
	CALL	PRHL		;PRINT IT
	JMP	EXIT		;TERMINATE

DONEP:  CALL	STRTIT		;START UART

	MVI	A,7		;BELL
	STA	UDATA
	CALL	ECHO		;RING BELL

EXIT:   MVI	A,ROFXOF	;RCVE OFF, XMIT OFF
	SIM			;INTERRUPTS OFF
	JMP	LOOP		;COMMAND MODE

		;----------------------;
		;  UART CRTL ROUTINES  ;
		;----------------------;

STRTIT: MVI	A,STRTMOD
	STA	UCTRL		;RESET OVRRUN, RTS & DTR LOW
	RET

SXON:   MVI	A,XON		;GET X-ON
	STA	UDATA
	CALL	ECHO		;SEND IT
	RET

SXOFF:  MVI	A,XOFF		;GET XOFF
	STA	UDATA
	CALL	ECHO		;SEND IT
	RET

STOPIT: MVI	A,STOPMOD
	STA	UCTRL		;RTS & DTR HIGH
	RET
	PAGE
		;-----------------------;
		;   MPROGRAM FUNCTION   ;
		;-----------------------;

;MANUAL PROGRAM- DESIGNED TO PROGRAM USING MANUAL DATA ENTRY
;WILL ECHO CHARACTERS UNTIL '$' IS TYPED

MPROGR: CALL	LITON		;LED ON

	CALL	MKADR		;GET START ADDRESS
	LHLD	ADDR2
	SHLD	CRTADR
	LXI	H,0FFFFH
	SHLD	ADDR2

PRADR:  LXI	H,MSGCRLF
	CALL	PRINT
	LHLD	CRTADR
	CALL	PRHL

	MVI	A,ASCSP
	STA	UDATA
	CALL	ECHO

	LXI	H,DATBUF
	MVI	B,MAXDAT
	CALL	CLEAR		;CLEAR BUFFER FOR DATA

	LXI	H,DATBUF
	MVI	B,MAXDAT
	CALL	TKDAT
	JC	LOOP		;'$' TYPED- ABORT
	JZ	PRADR		;'cr' TYPED FIRST

	LXI	H,DATBUF	;POINT TO BUFFER
	SHLD	BUFPNT		;SET POINTER

MKNIBS: LHLD	BUFPNT		;GET CURRENT POINTER

MKNIB1: MOV	A,M		;GET NIBBLE
	INX	H		;ADVANCE
	CPI	0		;END?
	JZ	PRADR		;NEXT LINE
	CPI	ASCSP		;SPACE?
	JZ	MKNIB1		;IGNORE

	CALL	CKHEX
	JC	BADDTA		;PRINT 'error @ [addr]'
	STA	NIB1		;SET FIRST NIBBLE

MKNIB2: MOV	A,M		;SECOND NIBBLE
	INX	H		;ADVANCE
	CPI	0		;END ?
	JZ	PRADR		;NEXT LINE
	CPI	ASCSP		;SPACE?
	JZ	MKNIB2		;IGNORE

	CALL	CKHEX
	JC	BADDTA
	STA	NIB2		;SET SECOND NIBBLE

	SHLD	BUFPNT		;UPDATE POINTER

	LXI	H,NIB2
	LXI	D,HEXDAT
	CALL	MKBYT

	CALL	PUTDAT
	JNZ	ERR7		;'can't program @ [addr]'

	CALL	CKEND
	JZ	LOOP		;NO MORE ROOM

	LHLD	CRTADR
	INX	H
	SHLD	CRTADR		;UPDATE ADDRESS

	JMP	MKNIBS		;NEXT CHAR IN BUFFER

ERR7:   CALL	PRCANT
	JMP	LOOP

BADDTA: LXI	H,MSGERR
	CALL	PRINT
	LHLD	CRTADR
	CALL	PRHL		;PRINT 'error @ [addr]'

	JMP	LOOP

PRCANT: LDA	VPFLAG
	CPI	0
	JZ	NOVMSG

	LXI	H,MSGVER	;PRINT 'verify failed '
	CALL	PRINT
	JMP	ADRPR		;PRINT ADDRESS

NOVMSG: LXI	H,MSGCANT
	CALL	PRINT		;PRINT 'can'T PROGRAM '

	LDA	FFLAG
	CPI	0		;FAST MODE?
	JZ	ADRPR		;NO, PRINT ADDRESS

	LXI	H,MSGFST
	CALL	PRINT		;PRINT 'fast '

ADRPR:  LXI	H,MSGAT
	CALL	PRINT		;PRINT '@ '

	LHLD	CRTADR
	CALL	PRHL
	RET
	PAGE
;-----------------------;
;  PROGRAMMER MONITOR	;
;-----------------------;


MLOOP:  LXI	H,RAM		;POINT TO RAM
	MVI	B,14		;COUNT 14 LOCATIONS

	CALL	CLEAR		;CLEAR RAM

	LXI	H,PROMP		;POINT TO PROMPT MESSAGE
	CALL	PRINT		;
	CALL	RRDY		;WAIT FOR A CHARACTER
	CALL	ECO		;ECHO IT

	CPI	'x'		;'x' COMMAND ?
	JNZ	CKWCOM		;NO

	LXI	H,MSGID
	CALL	PRINT
	JMP	MLOOP		;WAIT FOR ANOTHER COMMAND

CKWCOM: CPI	'w'		;WRITE COMMAND ?
	JZ	WRITE		;YES

	CPI	'g'		;GO COMMAND ?
	JZ	GO		;YES

	CPI	'p'		;PROGRAMMER ?
	JZ	LOOP		;GO BACK

	CPI	'r'		;READ COMMAND ?
	JNZ	MLOOP		;NO, WAIT FOR ANOTHER COMMAND
	PAGE
; 'READ COMMAND'
;USAGE R[ADDRESS] 'sp''sp''sp'...'sp'$
;AFTER TYPING THE FOUR DIGITS ADDRESS, EVERY 'sp' WILL OUTPUT
; ON THE SCREEN THE DATA AT THE CONSECUTIVE LOCATION

RDMON:  CALL	GETADR		;GET ADDRESS TO READ FROM
	LDA	DONEFL		;CHECK FLAG FOR '$'
	CPI	0		;CHECK IF ZERO
	JNZ	MLOOP		;DO IT AGAIN
	LHLD	ADDR		;POINT TO ADDRESS

RD:     CALL	RRDY		;WAIT FOR COMMAND
	CPI	ASC$		;CHECK IF END
	JZ	MLOOP		;YES, TERMINATE.

	MOV	A,M		;READ AT ADDRESS
	STA	ACUM		;SAVE VALUE FOR CONVERSION
	CALL	PRASCI		;PRINT IT

	MVI	A,ASCSP		;ASCII 'space'
	STA	UDATA		;STORE FOR ECO
	CALL	ECO		;PRINT 'space'

	INX	H		;NEXT LOCATION FOR READ
	JMP	RD

	PAGE
; 'WRITE COMMAND'
;USAGE W[ADDRESS] 'byte' 'byte' ...'byte' $

WRITE:  CALL	GETADR		;GET ADDRESS TO WRITE TO
	LHLD	ADDR		;POINT TO ADDRESS
	LDA	DONEFL		;CHECK FOR '$'
	CPI	0
	JNZ	MLOOP		;DO IT AGAIN

WR:     CALL	GETBYT		;GET HEX BYTE (TWO KEYBOARD CHARACTERS)
	LDA	DONEFL		;CHECK FOR END OF STRING
	CPI	0
	JNZ	MLOOP

	MVI	A,ASCSP		;ASCII 'space'
	STA	UDATA		;STORE FOR ECO
	CALL	ECO		;PRINT 'space'

	LDA	HEXDAT		;GET HEX VALUE OF LAST BYTE TYPED
	MOV	M,A		;WRITE DATA TO MEMORY
	INX	H		;POINT TO NEXT ADDRESS
	JMP	WR		;ONE MORE TIME

; 'GO COMMAND'
;USAGE G[ADDRESS]

GO:     CALL	GETADR		;GET ADDRESS WHERE TO GO
	LDA	DONEFL		;CHECK FOR '$'
	CPI	0
	JNZ	MLOOP		;DO IT AGAIN

	LHLD	ADDR		;GET ADDRESS
	PCHL			;JUMP THERE

	PAGE
;------------------------;
;    GETADR SUBORUTINE   ;
;------------------------;

;ACCEPTS A FOUR DIGGIT ADDRESS FROM THE KEYBOARD
;IF THE DATA IS A VALID HEX ADDRESS, ECOS IT
;CONVERTS DATA INTO HEX VALUE, AT 'addr' LOCATION

GETADR: LXI	H,ADDR+1	;POINT TO HIGH BYTE OF FUTURE ADDRESS
	CALL	GETBYT		;GET FIRST BYTE FROM THE KEYBOARD
	LDA	DONEFL		;CHECK FOR '$'
	CPI	0
	RNZ			;IF '$', RETURN
	LDA	HEXDAT		;GET HIGH BYTE
	MOV	M,A		;WRITE HIGH BYTE TO MEMORY

	DCX	H		;POINT TO LOW BYTE OF ADDRESS
	CALL	GETBYT		;GET SECOND BYTE FROM THE KEYBOARD
	LDA	DONEFL		;CHECK FOR '$'
	CPI	0
	RNZ			;IF '$', RETURN
	LDA	HEXDAT		;GET LOW BYTE
	MOV	M,A		;WRITE LOW BYTE TO MEMORY

	MVI	A,ASCSP		;ASCII 'space'
	STA	UDATA		;STORE FOR ECO
	CALL	ECO		;PRINT 'space'

	RET

;------------------------;
;    GETBYT SUBROUTINE   ;
;------------------------;

;MAKE A HEX BYTE FROM TWO KEYBOARD CHARACTERS
;RET WITH VALUE SAVED AT HEXDAT
;SET DONEFL WHEN '$' RECEIVED

GETBYT:CALL	MKHEX		;WAIT FOR FIRST DIGIT, GET HEX VALUE
	LDA	DONEFL		;CHECK FOR '$'
	CPI	0
	RNZ			;IF '$', RETURN

	LDA	HEXNIB
	RLC
	RLC
	RLC
	RLC			;SHIFT LEFT

	ANI	0F0H		;MASK RIGHT NIBBLE
	MOV	B,A		;SAVE INTO B-REG

	CALL	MKHEX		;WAIT FOR SECOND DIGGIT, GET HEX VALUE
	LDA	DONEFL		;CHECK FOR '$'
	CPI	0
	RNZ			;IF '$', RETURN

	LDA	HEXNIB
	ANI	0FH		;MASK LEFT NIBBLE
	ORA	B		;A = A OR B
	STA	HEXDAT		;SAVE VALUE
	RET

	PAGE
;------------------------;
;    MKHEX SUBROUTINE    ;
;------------------------;

;WAIT FOR UART DATA
;SET DONEFL IF '$' RECEIVED
;CHECK IF IT'S VALID HEX CHARACTER
;ECO IF O.K.
;STORE HEX VALUE AT HEXNIB

MKHEX:  CALL	RRDY		;WAIT FOR UART
	CPI	'$'		;CHECK FOR '$'
	JZ	END7

CKASCI: CPI	'0'		;CHECK IF VALID ASCII CHARACTER
	JC	MKHEX		;DATA < '0'

	CPI	'9'+1		;
	JC	NUMB		;'0' =<DATA=< '9'

	CPI	'A'		;
	JC	MKHEX		;'9' =<DATA=< 'A'

	CPI	'F'+1		;
	JC	UPRLT		;'A' =<DATA=< 'F'

	CPI	'a'		;
	JC	MKHEX		;'F' =<DATA=< 'a'

	CPI	'f'+1		;
	JC	LOWLT		;'a' =<DATA=< 'f'

	JMP	MKHEX		;DATA > 'f'

NUMB:   SUI	NUMDIF		;DATA IS NUMBER, GET HEX VALUE
	JMP	OVER12

UPRLT:  SUI	UPLETD		;DATA IS UPPER LETTER (A-F)
	JMP	OVER12

LOWLT:  SUI	LOLETD		;DATA IS LETTER, GET HEX VALUE

OVER12: STA	HEXNIB		;SAVE
	LDA	UDATA
	CALL	ECO		;DATA O.K., ECHO IT
	RET

END7:   MVI	A,01H		;
	STA	DONEFL		;SET FLAG FOR '$'
	RET

	PAGE
;
; 3-3a - **** changed all "ASCII" assembler directive call to "DB"
; 3-3a - **** because "MAC" doesn't handle it
;
;-----------------------;
;   MONITOR MESSAGES    ;
;-----------------------;

PROMP:	DB	ASCCR
	DB	ASCLF
	DB	'#'
	DB	ASCNUL

;-----------------------;
;  PRINTABLE MESSAGES   ;
;-----------------------;

MSGCRLF:DB	ASCCR
	DB	ASCLF
	DB	ASCNUL
MSGN:	DB	ASCCR
	DB	ASCLF
	DB	'*invalid command'
	DB	ASCNUL

MSGSW:	DB	ASCCR
	DB	ASCLF
	DB	'set SW2 to 01XX !!!'
	DB	ASCNUL

MSGINT:	DB	ASCCR
	DB	ASCLF
	DB	':'
	DB	ASCNUL
MSGMOT:	DB	ASCCR
	DB	ASCLF
	DB	'S1'
	DB	ASCNUL
MSIEND:	DB	ASCCR
	DB	ASCLF
	DB	':0000000000'
	DB	ASCNUL		;MESSAGE FOR INTEL END OF RECORD
MSMEND:	DB	ASCCR
	DB	ASCLF
	DB	'S9'
	DB	ASCNUL		;MESSAGE FOR MOTOROLA END OF RECORD
MSGERR:	DB	ASCCR
	DB	ASCLF
	DB	'*error @ '
	DB	ASCNUL
MSGUV:	DB	ASCCR
	DB	ASCLF
	DB	'*use u.v. to erase!'
	DB	ASCNUL
MSGH:	DB	ASCCR
	DB	ASCLF
	DB	ASCSP
	DB	ASCSP
	DB	ASCSP
	DB	ASCSP
	DB	ASCSP
	DB	ASCSP
	DB	'1409 COMMAND SYSTEM:'
	DB	ASCCR
	DB	ASCLF
	DB	ASCCR
	DB	ASCLF
	DB	'GENERAL COMMANDS    PROGRAM COMMANDS        LIST COMMANDS'
	DB	ASCCR
	DB	ASCLF
	DB	ASCCR
	DB	ASCLF
	DB	'h = help            p  = program            l  = list'
	DB	ASCCR
	DB	ASCLF
	DB	'm = menu            mp = manual program'
	DB	'     il = INTEL format list'
	DB	ASCCR
	DB	ASCLF
	DB	'? = status          fp = fast program'
	DB	'       mol= MOTOROLA format list'
	DB	ASCCR
	DB	ASCLF
	DB	'e = erase           sp = slow program'
	DB	'       r  = read (unformated)'
	DB	ASCCR
	DB	ASCLF
	DB	'x = identify        1p = low byte program'
	DB	ASCCR
	DB	ASCLF
	DB	'! = monitor         2p = high byte program'
	DB	ASCCR
	DB	ASCLF
	DB	'vb= verify blank    vp = verify programming'
	DB	ASCCR						;3-3a
	DB	ASCLF						;3-3a
	DB	'o = address offset'				;3-3a
	DB	ASCCR
	DB	ASCLF
	DB	'$ = break'
	DB	ASCCR
	DB	ASCLF
	DB	ASCNUL
MSGMEN:	DB	ASCCR
	DB	ASCLF
	DB	'SELECTION MENU:'
	DB	ASCCR
	DB	ASCLF
	DB	ASCCR
	DB	ASCLF
	DB	'a=2758    k=2508    o=68732   r=2816A   1=SPARE'
	DB	ASCCR
	DB	ASCLF
	DB	'b=27(C)16 l=2516    p=68764   s=2832A*  2=SPARE'
	DB	ASCCR
	DB	ASCLF
	DB	'c=27(C)32 m=2532    q=68766   t=2864A*  3=8748H'
	DB	ASCCR
	DB	ASCLF
	DB	'd=2732A   n=2564              u=52B13   4=8749H'
	DB	ASCCR
	DB	ASCLF
	DB	'e=2764                        v=52B23'
	DB	ASCCR
	DB	ASCLF
	DB	'f=2764A                       w=52B33'
	DB	ASCCR
	DB	ASCLF
	DB	'g=27128                       x=52B43*'
	DB	ASCCR
	DB	ASCLF
	DB	'h=27128A                      y=SPARE'
	DB	ASCCR
	DB	ASCLF
	DB	'i=27256'
	DB	ASCCR
	DB	ASCLF
	DB	'j=SPARE'
	DB	ASCCR
	DB	ASCLF
	DB	'*:not supported in this version'
	DB	ASCCR
	DB	ASCLF
	DB	ASCCR
	DB	ASCLF
	DB	'enter selection:'
	DB	ASCNUL
MSGID:	DB	ASCCR
	DB	ASCLF
	DB	'B&C Microsystems'
	DB	ASCCR
	DB	ASCLF
	DB	'UNIVERSAL EPROM PROGRAMMER'
	DB	ASCCR
	DB	ASCLF
	DB	'model 1409 ver ',LEVEL+30H,'.',REV+30H,SUBREV+060H	;3-3a
	DB	ASCCR
	DB	ASCLF
	DB	'copyright 1983'
	DB	ASCCR
	DB	ASCLF
	DB	ASCNUL
MSGOVR:	DB	ASCCR
	DB	ASCLF
	DB	'*overrun error'
	DB	ASCNUL
MSGCANT:DB	ASCCR
	DB	ASCLF
	DB	'*can''t program '
	DB	ASCNUL
MSGVER:	DB	ASCCR
	DB	ASCLF
	DB	'*verify failed '
	DB	ASCNUL
MSGAT:  DB	'@ '
	DB	ASCNUL
MSGERS:	DB	ASCCR
	DB	ASCLF
	DB	'*can''t erase @ '
	DB	ASCNUL
MSGBAS:	DB	' *below absolute start address of '		;3-3a
	DB	ASCNUL						;3-3a
MSGPMOD:DB	ASCCR
	DB	ASCLF
	DB	'programming mode:       '
	DB	ASCNUL
MSGSLW:	DB	'slow'
	DB	ASCNUL
MSGFST:	DB	'fast '
	DB	ASCNUL
MSGBR:	DB	ASCCR
	DB	ASCLF
	DB	'current baud rate:      '
	DB	ASCNUL
MSGOFF:	DB	ASCCR						;3-3a
	DB	ASCLF						;3-3a
	DB	'absolute start address: '			;3-3a
	DB	ASCNUL						;3-3a
MSGMAX:	DB	ASCCR
	DB	ASCLF
	DB	'relative high address:  '			;3-3a
	DB	ASCNUL

;PROMPT MESSAGES

PRMPTA:	DB	ASCCR
	DB	ASCLF
	DB	'2758->'
	DB	ASCNUL
PRMPTB:	DB	ASCCR
	DB	ASCLF
	DB	'27(C)16->'
	DB	ASCNUL
PRMPTC:	DB	ASCCR
	DB	ASCLF
	DB	'27(C)32->'
	DB	ASCNUL
PRMPTD:	DB	ASCCR
	DB	ASCLF
	DB	'2732A->'
	DB	ASCNUL
PRMPTE:	DB	ASCCR
	DB	ASCLF
	DB	'2764->'
	DB	ASCNUL
PRMPTF:	DB	ASCCR
	DB	ASCLF
	DB	'2764A->'
	DB	ASCNUL
PRMPTG:	DB	ASCCR
	DB	ASCLF
	DB	'27128->'
	DB	ASCNUL
PRMPTH:	DB	ASCCR
	DB	ASCLF
	DB	'27128A->'
	DB	ASCNUL
PRMPTI:	DB	ASCCR
	DB	ASCLF
	DB	'27256->'
	DB	ASCNUL
PRMPTJ:	DB	ASCCR
	DB	ASCLF
	DB	'27512->'
	DB	ASCNUL
PRMPTK:	DB	ASCCR
	DB	ASCLF
	DB	'2508->'
	DB	ASCNUL
PRMPTL:	DB	ASCCR
	DB	ASCLF
	DB	'2516->'
	DB	ASCNUL
PRMPTM:	DB	ASCCR
	DB	ASCLF
	DB	'2532->'
	DB	ASCNUL
PRMPTN:	DB	ASCCR
	DB	ASCLF
	DB	'2564->'
	DB	ASCNUL
PRMPTO:	DB	ASCCR
	DB	ASCLF
	DB	'68732->'
	DB	ASCNUL
PRMPTP:	DB	ASCCR
	DB	ASCLF
	DB	'68764->'
	DB	ASCNUL
PRMPTQ:	DB	ASCCR
	DB	ASCLF
	DB	'68766->'
	DB	ASCNUL
PRMPTR:	DB	ASCCR
	DB	ASCLF
	DB	'2816A->'
	DB	ASCNUL
PRMPTS:	DB	ASCCR
	DB	ASCLF
	DB	'2832->'
	DB	ASCNUL
PRMPTT:	DB	ASCCR
	DB	ASCLF
	DB	'2864->'
	DB	ASCNUL
PRMPTU:	DB	ASCCR
	DB	ASCLF
	DB	'52B13->'
	DB	ASCNUL
PRMPTV:	DB	ASCCR
	DB	ASCLF
	DB	'52B23->'
	DB	ASCNUL
PRMPTW:	DB	ASCCR
	DB	ASCLF
	DB	'52B33->'
	DB	ASCNUL
PRMPTX:	DB	ASCCR
	DB	ASCLF
	DB	'52B43->'
	DB	ASCNUL
PRMPT1:	DB	ASCCR
	DB	ASCLF
	DB	'8751->'
	DB	ASCNUL
PRMPT2:	DB	ASCCR
	DB	ASCLF
	DB	'8755->'
	DB	ASCNUL
PRMPT3:	DB	ASCCR
	DB	ASCLF
	DB	'8748H->'
	DB	ASCNUL
PRMPT4:	DB	ASCCR
	DB	ASCLF
	DB	'8749H->'
	DB	ASCNUL

	PAGE
;COMMAND MESSAGES

MSG1:   DB	'l',CTLX,CTLX,CTLX,CTLX,CTLX
	DB	CTLX,CTLX,CTLX,CTLX,CTLX			;3-3a
	DB	ASCNUL		;LIST COMMAND
MSG2:   DB	'r',CTLX,CTLX,CTLX,CTLX,CTLX
	DB	CTLX,CTLX,CTLX,CTLX,CTLX			;3-3a
	DB	ASCNUL		;READ COMMAND
MSG3:   DB	'p',CTLX,CTLX,CTLX,CTLX,CTLX
	DB	ASCNUL		;AUTOMATED PROGRAMMING
MSG4:   DB	'vb'
	DB	ASCNUL		;VERIFY BLANK COMMAND
MSG5:   DB	'mp',CTLX,CTLX,CTLX,CTLX,CTLX
	DB	ASCNUL		;MANUAL PROGRAMMING
MSG6:   DB	'h'
	DB	ASCNUL		;HELP COMMAND
MSG7:   DB	'm',CTLX
	DB	ASCNUL		;MENU COMMAND
MSG8:   DB	'x'
	DB	ASCNUL		;SIGNATURE COMMAND
MSG9:	DB	ASCSP
	DB	CTLX,CTLX,CTLX,CTLX,CTLX,CTLX,CTLX
	DB	CTLX,CTLX,CTLX,CTLX,CTLX,CTLX,CTLX
	DB	ASCNUL		;MESSAGE STARTS WITH SPACE
MSG11:  DB	'!'
	DB	ASCNUL		;ENTER 'monitor'
MSG12:  DB	'fp'
	DB	ASCNUL		;FAST PROGRAMMING
MSG13:  DB	'il',CTLX,CTLX,CTLX,CTLX,CTLX
	DB	CTLX,CTLX,CTLX,CTLX,CTLX			;3-3a
	DB	ASCNUL		;INTEL LIST COMMAND
MSG14:  DB	'mol',CTLX,CTLX,CTLX,CTLX,CTLX
	DB	CTLX,CTLX,CTLX,CTLX,CTLX			;3-3a
	DB	ASCNUL		;MOTOROLA LIST COMMAND
MSG15:  DB	'1p',CTLX,CTLX,CTLX,CTLX,CTLX
	DB	ASCNUL		;LOW BYTE PROGRAMMING
MSG16:  DB	'2p',CTLX,CTLX,CTLX,CTLX,CTLX
	DB	ASCNUL		;HIGH BYTE PROGRAMMING
MSG17:  DB	'e',CTLX,CTLX,CTLX,CTLX,CTLX
	DB	CTLX,CTLX,CTLX,CTLX,CTLX			;3.3a
	DB	ASCNUL		;ERASE EEPROM
MSG18:  DB	'sp'
	DB	ASCNUL		;SLOW PROGRAMMING
MSG19:  DB	'?'
	DB	ASCNUL		;DISPLAY STATUS COMMAND
MSG20:  DB	'vp'
	DB	ASCNUL		;VERIFY PROGRAMMING
MSG21:  DB	'copy'
	DB	ASCNUL		;COPY FUNCTION
MSG22:	DB	'o',CTLX,CTLX,CTLX,CTLX,CTLX			;3-3a
	DB	ASCNUL		;SET ABSOLUTE ADDRESS		;3-3a
	PAGE
;------------------------;
;    TRDY SUBROUTINE     ;
;------------------------;

;WAIT FOR UART TO GET READY TO TRANSMIT A CHARACTER

TRDY:   LDA	USTAT		;GET STATUS
	ANI	TXRDY		;ONLY TXRDY BIT
	JZ	TRDY		;WAIT UNTIL READY
	RET

;------------------------;
;    RRDY SUBROUTINE     ;
;------------------------;

;WAIT UNTIL UART HAS A NEW CHARACTER.
;READ THE CHARACTER
;DELETE THE PARITY BIT
;STORE DATA AT UDATA

RRDY:   LDA	USTAT		;GET STATUS
	ANI	RXRDY		;ONLY RXRDY BIT
	JZ	RRDY
	LDA	UART		;READ UART
	ANI	7FH		;NO PARITY
	CALL	LOWER		;CONVERT UPPER CASE TO LOWER
	STA	UDATA		;SAVE DATA
	RET

;---------------------;
;  LOWER SUBROUTINE   ;
;---------------------;

LOWER:  CPI	41H
	RC
	CPI	5BH
	RNC
	ORI	20H		;CONVERT TO LOWER CASE
	RET

;------------------------;
;   ECHO SUBROUTINE      ;
;------------------------;

;ECHO THE VALUE AT 'udata' ADDRESS

ECO:    LDA	ECOFL
	CPI	ECOFF		;CHECK IF ECHO IS OFF
	RZ			;DO NOT ECO

ECHO:   CALL	TRDY		;WAIT FOR READY TO XMIT
	LDA	UDATA		;GET CHARACTER
	STA	UART		;PRINT IT
	RET
;------------------------;
;    PRINT SUBROUTINE    ;
;------------------------;

;PRINT THE MESSAGE POINTED TO BY HL
;LAST CHARACTER IN THE MESSAGE MUST BE 'null'

PRINT:  CALL	TRDY		;WAIT FOR UART
	MOV	A,M		;GET CHARACTER FORM MESSAGE
	CPI	ASCNUL		;LOOK FOR END OF MESSAGE
	RZ			;RETURN IF EOM

	STA	UART		;PRINT CHARACTER
	INX	H		;POINT TO NEXT CHARACTER
	JMP	PRINT		;PRINT ONE MORE

	PAGE
;------------------------;
;    COMP SUBOROUTINE    ;
;------------------------;

;COMPARE MSG POINTED TO BY H,L WITH MSG POINTED TO BY D,E
;STOP WHEN 'null' IS FOUND
;RETURN WITH ZERO FLAG SET IF O.K.

COMP:   MOV	A,M		;FIRST CHAR. FROM MSG
	INX	H
	XCHG
	CPI	CTLX		;CHECK IF WILD
	JZ	NEXT1		;COMPARE NEXT CHAR

	MOV	B,A		;SAVE
	MOV	A,M		;GET INPUT CHARACTER
	CMP	B		;CHECK
	JNZ	BADC		;BAD CHARACTER

	CPI	ASCNUL		;END OF BUFFER?
	JNZ	NEXT1		;NO

	MOV	A,B		;LAST CHARACTER IN MSG
	CPI	ASCNUL		;SHOULD ALSO BE ZERO

BADC:   LXI	D,CMDBUF	;RESTORE D,E TO RETURN
	RET

NEXT1:  INX	H
	XCHG
	JMP	COMP

;-----------------------;
;  MKADR SUBROUTINE     ;
;-----------------------;

;BUILT TWO 8085 ADDRESSES FROM THE NIBBLES STORED AT NIB LOCATIONS

MKADR:  CALL	MKNIB
	LXI	H,NIB14
	LXI	D,ADDR1
	CALL	MKBYT		;LOW ORDER BYTE OF ADDRESS 1

	LXI	H,NIB12
	INX	D
	CALL	MKBYT		;HIGH ORDER BYTE OF ADDRESS 1

	LXI	H,NIB24
	LXI	D,ADDR2
	CALL	MKBYT		;LOW ORDER BYTE OF ADDRESS 1

	LXI	H,NIB22
	INX	D
	CALL	MKBYT		;HIGH ORDER BYTE OF ADDRESS 2
	RET

	PAGE
;-----------------------;
;   MKBYT SUBROUTINE    ;
;-----------------------;

;MAKE A BYTE FROM THE TWO NIBBLES POINTED TO BY H,L (NIB)
;STORE THE BYTE WHERE D,E POINTS (ADDR)
;RET WITH VALUE IN ACUMULATOR

MKBYT:  MOV	B,M		;GET RIGHT NIBBLE
	DCX	H
	MOV	A,M		;GET LEFT NIBBLE
	RLC
	RLC
	RLC
	RLC			;SHIFT NIBBLE TO LEFT
	ANI	0F0H		;DELETE RIGHT NIBBLE
	ORA	B		;MAKE BYTE
	XCHG
	MOV	M,A		;STORE BYTE
	XCHG			;RESTORE HL, DE
	RET
;-----------------------;
;   MKNIB SUBROUTINE    ;
;-----------------------;
;AFTER ACCEPTANCE OF COMMAND, THE BUFFER IS:
;       X [ADDR] [ADDR]'NL'
;STORE THE NIBBLES IN THE PROPER LOCATION


MKNIB:  LXI	H,CMDBUF

ENDMS:  INX	H		;NEXT CHARACTER IN BUFFER
	MOV	A,M		;READ IT
	CPI	0		;CHECK FOR END
	JNZ	ENDMS		;KEEP LOOKING

;HERE WE REACH THE END OF THE BUFFER

	LXI	D,NIB24
	CALL	MVNIB		;MOVE NIBBLE

	LXI	D,NIB14
	CALL	MVNIB

	RET

	PAGE
;-----------------------;
;   MVNIB SUBROUTINE    ;
;-----------------------;
;TRANSFER UP TO FOUR NIBBLES OF ASCII DATA FROM THE INPUT
; BUFFER (POINTED TO BY H,L) INTO HEX VALUES AT NIB LOCATIONS
; (POINTED TO BY D,E)
;RETURN WITH CARRY SET IF BAD ADDRESS DETECTED (NON-ASCII)

MVNIB:  MVI	B,4		;UP TO FOUR NIBBLES

NIB:    DCX	H		;BACK-UP
	MOV	A,M		;READ CHARACTER FROM BUFFER
	CALL	CKHEX		;0-9, A-F, A-F ONLY, CONVERT TO HEX
	JC	A1		;NON-ASCII CHARACTER FOUND

	XCHG
	MOV	M,A		;STORE NIBBLE
	DCX	H
	XCHG

	DCR	B
	JZ	BACKUP		;MAX FOUR NIBBLES

	JMP	NIB		;MOVE ANOTHER ONE

BACKUP: ORA	A		;CLEAR CARRY
	DCX	H
	RET

A1:     MOV	A,M		;GET LAST CHARACTER
	CPI	ASCSP		;CHECK IF 'space' (VALID DELIMITER)
	JNZ	A2		;BAD ASCII
	ORA	A		;CLEAR CARRY
	RET

A2:     STC
	RET

	PAGE
;-----------------------;
;   CKHEX SUBROUTINE    ;
;-----------------------;

;CHECK IF ACUMULATOR HAS ASCII FOR A HEX VALUE
;SET CARRY IF NOT
;CONVERT VALUE TO HEX IF OK

CKHEX:  CPI	'0'
	JC	BAD2

	CPI	'9'+1
	JC	NUM

	CPI	'A'
	JC	BAD2

	CPI	'F'+1
	JC	UPLET

	CPI	'a'
	JC	BAD2

	CPI	'f'+1
	JC	LOLET

BAD2:   STC			;SET CARRY
	RET

NUM:    SUI	NUMDIF
	JMP	OVER1

UPLET:  SUI	UPLETD
	JMP	OVER1

LOLET:  SUI	LOLETD

OVER1:  ORA	A		;CLEAR CARRY
	RET

;-----------------------;
;   MOVE SUBROUTINE     ;
;-----------------------;

;MOVE  'maxmsk' CHARACTERS FROM WHERE H,L POINTS TO WHERE D,E POINTS

MOVE:   MVI	B,MAXMSK	;COUNTER

MV:     MOV	A,M		;READ CHARACTER
	INX	H		;NEXT TO BE READ
	XCHG			;WHERE TO PUT LAST ONE

	MOV	M,A		;PUT IT
	INX	H		;NEXT PLACE TO PUT ONE

	XCHG			;
	DCR	B		;COUNT IT
	JNZ	MV		;MOVE ONE MORE

	RET

	PAGE
;-----------------------;
;   SETADR SUBROUTINE   ;
;-----------------------;

;PUT THE ADDRESS FOR THE EPROM TO THE PROPER I/O PORTS
;THE ADDRESS IS STORED AT CRTADR
;THE MASKS ARE IN CONSECUTIVE LOCATIONS, FROM MSKA08 TO MSKA15.

SETADR: LDA	CRTADR		;LOW BYTE OF ADDRESS
	STA	PORTB		;SET PORT B
	MVI	E,8		;EIGHT BITS
	LXI	H,MSKA08	;POINT TO ADDRESS MASK TABLE

	LDA	CRTADR+1	;HIGH ORDER BYTE
	MOV	C,A		;SAVE INTO C

BIT:    MOV	A,C		;GET ADDRESY AFTER LAST SHIFT
	RAR			;SHIFT RIGHT TO SET CARRY
	MOV	C,A		;SAVE FOR NEXT SHIFT
	JC	PINH		;BIT WAS HIGH

PINL:   CALL	PINLO		;PIN WAS LOW, SET IT
	JMP	OVER2

PINH:   CALL	PINHI		;SET PIN HIGH

OVER2:  DCR	E		;COUNT THE BIT
	RZ			;ALL BITS SET
	INX	H		;NEXT MASK
	INX	H		;(TWO BYTES)
	JMP	BIT		;DO ONE MORE BIT

	PAGE
;-----------------------;
;   PINLO SUBROUTINE    ;
;-----------------------;

;SET LOW THE PIN INDICATED BY THE MASK POINTED TO BY H,L

PINLO:  INX	H		;POINT TO CURRENT DESCRIPTOR
	MOV	A,M		;GET VALUE
	DCX	H		;RESTORE POINTER TO MASK
	RAL
	JNC	SETXL		;IF BIT 7 = 0, SET PORTX

SETYL:  MOV	A,M		;GET MASK
	CMA
	MOV	B,A
	LDA	IPRTY		;GET VALUE OF PORT Y
	ANA	B
	STA	PORTY
	STA	IPRTY		;SET NEW VALUE
	RET

SETXL:  MOV	A,M
	CMA
	MOV	B,A
	LDA	IPRTX
	ANA	B
	STA	PORTX
	STA	IPRTX
	RET

;-----------------------;
;   PINHI SUBROUTINE    ;
;-----------------------;

;SET HIGH THE PIN INDICATED BY THE MASK POINTED TO BY H,L

PINHI:  INX	H		;POINT TO DESCRIPTOR
	MOV	A,M		;GET MASK
	DCX	H		;RESTORE POINTER TO MASK
	RAL			;CHECK BIT 7
	JNC	SETXH		;BIT 7 IS LOW, SET PORT X HIGH

SETYH:  MOV	A,M		;GET MASK AGAIN
	MOV	B,A		;SAVE INTO B
	LDA	IPRTY		;GET PORT Y
	ORA	B		;SET BIT HIGH
	STA	PORTY		;SET I/O
	STA	IPRTY		;STORE NEW VALUE
	RET

SETXH:  MOV	A,M		;GET MASK
	MOV	B,A
	LDA	IPRTX
	ORA	B
	STA	PORTX
	STA	IPRTX
	RET

	PAGE
;-----------------------;
;   SETSTAT SUBROUTINE  ;
;-----------------------;

;SET READ OR PROGRAM STATE
;AT ENTRY D HAS RDSTAT=01 FOR READ, PGMSTAT=02 FOR PROGRAM,
; OR VERSTAT=40 FOR VERIFY

SETSTAT:LXI	H,MASKTAB
	MVI	A,MSKA08-MASKTAB ;# OF BYTES
	RRC			;DIVIDE BY 2 TO GET NR OF MASKS TO BE SET
	MOV	C,A		;SAVE INTO C FOR COUNTER

SETIT:  INX	H		;POINT TO CURRENT DESCRIPTOR
	MOV	A,M		;GET IT
	DCX	H		;RESTORE POINTER TO MASK( IF PINHI IS CALLED)
	ANA	D		;FILTER DESCRIPTOR THROUGH B
	JNZ	SETHI		;IF BIT WAS 1, CALL	PINHI

SETLO:  CALL	PINLO		;IF BIT WAS 0, CALL	PINLO

OVRSET: INX	H
	INX	H		;NEXT MASK
	DCR	C		;LAST?
	RZ			;YES
	JMP	SETIT		;SET ONE MORE PIN

SETHI:  CALL	PINHI
	JMP	OVRSET


	PAGE
;-----------------------;
;   GET28 SUBROUTINE    ;
;-----------------------;

;READ A 28 PINS DEVICE
;GET DATA FROM THE CRT ADDRESS OF THE EPROM

GET28:  CALL	SETADR		;SET ADDRESS
	MVI	D,RDSTAT	;READ STATUS PATTERN IN D
	CALL	SETSTAT		;SET READ STATUS

	LDA	PORTA		;READ DATA
	STA	ACUM		;SAVE FOR PRASCII SUBROUTINE
	RET

;-----------------------;
;   PUT28 SUBROUTINE    ;
;-----------------------;

;PROGRAM A 28 PINS DEVICE
;DATA FROM HEXDAT GETS PROGRAMMED AT CRTADR
;RETURN WITH ZERO SET IF SUCCESFULL

PUT28:  CALL	SETADR		;SET ADDRESS
	MVI	D,RDSTAT
	CALL	SETSTAT		;SET READ STATUS

	LDA	PORTA		;READ DATA
	MOV	B,A		;SAVE INTO B
	LDA	HEXDAT		;DATA TO BE PROGRAMMED
	CMP	B		;SAME?
	RZ			;DONE, ZERO SET

	LDA	VPFLAG		;VERIFY MODE?
	CPI	0
	JZ	NOVER		;NO, PROGRAM

;VERIFY MODE, DATA NOT THERE.
	RET			;RET WITH ZERO CLEAR (DATA NOT THERE)

NOVER:  LDA	CRTSTAT		;GET STATUS BYTE
	ANI	04H		;LOOK AT BIT 2 (FAST PERMISION)
	CPI	0		;BIT CLEAR?
	JNZ	NOTFAST		;NO, DO NOT PROGRAM FAST

	LDA	FFLAG		;FAST MODE ?
	CPI	0		;CHECK FLAG
	JNZ	TRYFAST		;FLAG SET, TRY TO PROGRAM FAST
	JMP	NORMAL		;NORMAL PROGRAMMING

;FLAG NOT SET, DO NORMAL STUFF

NOTFAST:XRA	A
	STA	FFLAG		;FAST PROTECT BIT ON, CLEAR FAST FLAG

NORMAL: LDA	CRTSTAT		;GET STATUS BYTE
	ANI	08H		;SLOW O.K.?
	CPI	0
	JZ	PSLOW		;YES, PROGRAM SLOW

;SLOW PERMISSION DENIED

	MVI	A,1
	STA	FFLAG
	JMP	TRYFAST		;DO IT FAST

PSLOW:  CALL	PUTIT		;PUT DATA
	CALL	PULSE
	CALL	GETIT		;GET DATA, RET WITH ZERO SET IF O.K.
	RET			;ZERO SET IF O.K.

TRYFAST:XRA	A
	STA	FCOUNT		;CLEAR COUNTER

PFAST:  CALL	PUTIT		;PUT DATA TO PORT, SET PROGRAM STATE
	LDA	FCOUNT		;GET FLAG
	INR	A
	STA	FCOUNT		;INCREMENT FLAG FOR NEXT PULSE

	MOV	B,A		;SAVE IN B
	LDA	MAXPLS
	ANI	7FH		;WITHOUT BIT 7
	SUB	B
	RC			;RETURN WITH ZERO CLEAR (B REG > A)

	CALL	PULSE		;PULSE 1 MS
	CALL	GETIT		;GET DATA
	JNZ	PFAST		;DIDN'T DO IT, PULSE AGAIN

;DATA IS THERE.  OVERPGM PULSE.

	CALL	PUTIT
	LDA	PLSMUL		;PULSE MULTIPLIER FROM TABLE
	ANI	7FH		;WITHOUT BIT 7
	DCR	A		;LESS ONE
	MOV	B,A		;SAVE
	LDA	FCOUNT		;GET # OF PULSES
	MOV	C,A		;SAVE IN C

MULT:   ADD C			;A+A
	DCR	B		;'b' TIMES
	JNZ	MULT

	STA	FFLAG		;SET COUNTER FOR WAIT ROUTINE

	CALL	PULSE		;PULSE (MULTIPLIER) TIMES FCOUNT
	CALL	GETIT
	RNZ			;RETURN WITH ZERO CLEAR

;ALL O.K., PREPARE TO EXIT

	MVI	A,1
	STA	FFLAG		;RESET FLAG
	CPI	1		;SET ZERO (DATA IS THERE)
	RET

PUTIT:  MVI	D,PGMSTAT
	CALL	SETSTAT		;SET PROGRAM STATUS

	MVI	A,ALLOUT
	STA	IOCTRL		;ALL I/O'S OUTPUT

	LDA	HEXDAT
	STA	PORTA		;SET PORT A WITH DATA
	RET

GETIT:  LDA	TIMDEL
	ANI	7FH		;7 BITS FOR COUNTER
	CPI	0
	JZ	NOWAIT		;NO DELAY REQUIRED
	MOV	D,A		;SET COUNTER

DELAY:  CALL	WT1MS
	DCR	D
	JNZ	DELAY

NOWAIT: MVI	A,PRTAIN	;PORT A INPUT
	STA	IOCTRL		;RESTORE PORT A

	MVI	D,VERSTAT
	CALL	SETSTAT		;SET VERIFY STATUS

	LDA	PORTA		;READ DATA
	MOV	B,A		;SAVE INTO B
	LDA	HEXDAT		;WHAT WE WANT
	CMP	B
	RET			;RETURN WITH ZERO SET IF O.K.

	PAGE
;-----------------------;
;   GET40 SUBROUTINE    ;
;-----------------------;

;GET DATA FROM 8748H

GET40:

STP3:   LDA	IPRTC
	ANI	0FEH		;C0=0,  TEST0=0
	ANI	0FDH		;C1=0,  RESET*=0
	STA	IPRTC
	STA	PORTC
	CALL	DLY4tCY		;3-3a - delay 4 tCY for TWT
STP4:   LDA	IPRTC
	ORI	04H		;C2=1,  EA=18V
	STA	IPRTC
	STA	PORTC

STP5:	CALL	SETADR		;SET ADDRESS

STP6:	LDA	IPRTC
	ORI	02H		;C1=1,  RESET*=5V (LATCH ADDRESS)
	STA	PORTC		;3-3a
	STA	IPRTC		;3-3a
	CALL	DLY4tCY		;3-3a - delay 4 tCY for TWA

	MVI	A,PRTBIN	;3-3a - make port b an input port
	STA	IOCTRL		;3-3a - write it to control port

STP11:	LDA	IPRTC		;3-3a
	ORI	01H		;C0=1,  TEST0=5V
	STA	IPRTC
	STA	PORTC
	CALL	DLY4tCY		;3-3a - delay 4 tCY for TDO
STP12:
	CALL	WT2MS		;3-3a - changed from WT50MS - WAIT TO SETTLE
	LDA	PORTB		;GET DATA
	STA	ACUM		;SAVE FOR PRASCI
	MVI	A,PRTAIN
	STA	IOCTRL		;RESTORE PORT A
	RET

;-----------------------;
;   PUT40 SUBROUTINE    ;
;-----------------------;

;PROGRAM CRTADR WITH HEXDAT INTO 8748H
; tCY = 10.0us for X2 = 1mhz
PUT40:

STEP3:  LDA	IPRTC
	ANI	0FDH		;C1=0,  RESET*=0 (just in case)   3-3a
	ANI	0FEH		;C0=0,  TEST0=0 (PGM MODE)
	STA	PORTC		;3-3a (need 4tCY for tTW)
	CALL	DLY4tCY		;3-3a - delay 4 tCY for tTW

STEP4:  ORI	04H		;C2=1,  EA=18V (PGM MODE ACTIVE)
	STA	IPRTC
	STA	PORTC

STEP5:  CALL	SETADR
	CALL	WT2MS		;3-3a - give it an extra 2 ms to go to ground

STEP6:  LDA	IPRTC
	ORI	02H		;C1=1,  RESET*=5V (LATCH ADDRESS)
	STA	IPRTC
	STA	PORTC
	CALL	DLY4tCY		;3-3a - delay 4 tCY for tWA
;
; Check for verify mode instead of program mode
;
	LDA	VPFLAG		;3-3a - verify mode?
	CPI	0		;3-3a - 0 if not
	JNZ	VER40S		;3-3a - just verify data

STEP7:  LDA	HEXDAT		;GET DATA TO PROGRAM
	STA	PORTB		;APPLY DATA TO BUS
	CALL	DLY4tCY		;3-3a - delay 4 tCY for tDW
	CALL	WT2MS		;3-3a - give this 2ms to settle

STEP8:  LDA	IPRTC
	ORI	10H		;C4=1,  VDD=21V (PGM POWER)
	STA	PORTC		;3-3a - do it
	CALL	DLY4tCY		;3-3a - delay 4 tCY for tVDDW

STEP9:  ORI	08H		;C3=1,  PROG=18V (PULSE HIGH)
	STA	IPRTC
	STA	PORTC

	CALL	WT50MS		; program location
	LDA	IPRTC
	ANI	0F7H		;C3=0,  PROG=0V (PULSE LOW)
	STA	PORTC		;3-3a - Do it
	STA	IPRTC		;3-3a - Save it
	CALL	DLY4tCY		;3-3a - delay 4 tCY for tVDDH

STEP10: ANI	0EFH		;C4=0,  VDD=5V
	STA	IPRTC
	STA	PORTC
	CALL	DLY4tCY		;3-3a - delay 4 tCY for tWD
	CALL	WT2MS		;3-3a - give tWD an extra 2ms

VER40S:				;3-3a - verify contents or programing
	MVI	A,PRTBIN
	STA	IOCTRL		;PREPARE PORT A TO READ DATA

STEP11: LDA	IPRTC
	ORI	01H		;C0=1,  TEST0=5V (VERIFY MODE)
	STA	IPRTC
	STA	PORTC
	CALL	DLY4tCY		;3-3a - delay 4 tCY for tDO
	CALL	WT2MS		;3-3a - Give bus 2ms to settle down

STEP12: LDA	PORTB		;READ DATA
	MOV	B,A		;SAVE

STEP13: LDA	IPRTC
	ANI	0FEH		;C0=0,  TEST0=0

STEP14: ANI	0FDH		;C1=0,  RESET*=0V
	STA	IPRTC
	STA	PORTC

	MVI	A,PRTAIN
	STA	IOCTRL		;RESTORE PORT A

	LDA	HEXDAT
	CMP	B		;SET ZERO FLAG
	RET

	;--------------------;
	; DLY4tCY SUBROUTINE ;
	;--------------------;
;
; waste 80 clock cycles - (4 tCY of 8748 at 1mhz clock)
;  (18 clocks wasted to get here) 9.0us
;  throw in an extra 2us for good luck
;
 DLY4tCY:
	CALL	DLY2tCY		;waste 40 clocks   3-3a
;
; waste 40 clock cycles - (2 tCY of 8748 at 1mhz clock)
; (18 clocks wasted to get here) 9.0us)
;
DLY2tCY:
	NOP			;4 clocks  (2us)   3-3a
	NOP			;4 clocks  (2us)   3-3a
	NOP			;4 clocks  (2us)   3-3a
	NOP			;4 clocks  (2us)   3-3a
	RET			;10 clocks (5us)   3-3a total of 22us

;-----------------------;
;   PUTDAT SUBROUTINE   ;
;-----------------------;

;SEE IF SELECTED DEVICE HAS 40 PINS
;CALL	THE PROPER ROUTINE TO PROGRAM IT
;IF 28 PIN AND TIMDEL > 0 WAIT (TIMDEL) mS BEFORE RETURN

PUTDAT: CALL	CK40		;CHECK IF 40 PINS
	JNZ	OVER40

	CALL	PUT40		;PROGRAM 40 PINER
	RET

OVER40: CALL	PUT28		;PROGRAM 24 OR 28 PINER
	RET

	PAGE
;-----------------------;
;   GETDAT SUBROUTINE   ;
;-----------------------;

;GET DATA FROM THE PROPER EPROM

GETDAT: CALL	CK40		;SEE IF 40 PINS
	JNZ	OVR40

	CALL	GET40		;READ 40 PINER
	RET

OVR40:  CALL	GET28
	RET

;-----------------------;
;    CK40 SUBROUTINE    ;
;-----------------------;

;CHECK IF SELECTED DEVICE HAS 40 PINS
;RETURN WITH ZERO SET IF YES

CK40:   LHLD	MSGPRT		;ADDRESS OF CURRENT PROMPT
	INX	H		;PASS 'CR'
	INX	H		;PASS 'LF'

	MOV	A,M		;READ FIRST CHARACTER
	CPI	'8'
	RET

;-----------------------;
;    PULSE SUBROUTINE   ;
;-----------------------;

;PULSE THE PROPER PIN, THE PROPER TIME AND THE PROPER POLARITY

PULSE:  LXI	H,MASKTAB+1	;FIRST DESCRIPTOR

TRYIT:  MOV	B,M		;READ DESCRIPTOR INTO B
	MVI	A,LOPLSE	;FILTER FOR LOW PULSE
	ANA	B		;FILTER B
	JNZ	PULSELO		;THIS IS IT.  PULSE IT LOW.

	MVI	A,HIPLSE	;CHECK FOR HIGH PULSE
	ANA	B
	JNZ	PULSEHI		;PULSE IT HIGH

;WAS NOT THIS PIN, CHECK NEXT(SHOULD STOP SOMEWHERE.)

	INX	H
	INX	H		;POINT TO NEXT DESCRIPTOR
	JMP	TRYIT		;TRY AGAIN

PULSELO:DCX	H		;RESTORE POINTER TO PIN MASK
	CALL	PINLO		;SET PIN LOW
	CALL	WAIT		;WAIT 2MS OR 50MS
	CALL	PINHI		;TRAILING EDGE OF PULSE
	RET

PULSEHI:DCX	H		;RESTORE POINTER TO PIN MASK
	CALL	PINHI		;SET PIN HIGH
	CALL	WAIT
	CALL	PINLO
	RET
	PAGE
;-----------------------;
;    WAIT SUBROUTINES   ;
;-----------------------;
;WAIT 2MS IF BIT 4 OF THE CURRENT DESCRIPTOR IS 0
;WAIT 50MS IF BIT 4 OF THE CURRENT DESCRIPTOR IS 1
;AT ENTRY AND EXIT H,L POINTS TO CURRENT MASK

WAIT:   LDA	FFLAG		;GET FLAG
	CPI	0		;CHECK IF FAST MODE
	JZ	NWAIT		;WAIT NORMALY (NOT FAST MODE)

;FAST MODE, CALL WT1MS AS MANY TIMES AS FFLAG

	LDA	FFLAG		;GET FLAG
	MOV	D,A		;SAVE INTO D

CALWT:  CALL	WT1MS		;WAIT 1 MS
	DCR	D
	JNZ	CALWT		;WAIT AGAIN
	RET

NWAIT:  INX	H		;POINT TO DESCRIPTOR
	MOV	B,M		;READ IT INTO B
	DCX	H		;RESTORE POINTER
	MVI	A,WIDTH		;FILTER FOR PULSE WIDTH
	ANA	B		;FILTER B

	JZ	C2MSEC		;BIT 4 = 0, WAIT 2MS

C50MSEC:CALL	WT50MS		;BIT 4 = 1, WAIT 50 MS
	RET

C2MSEC: CALL	WT2MS
	RET

;WAIT 1 MS      STATES
WT1MS:  MVI	A,140		;7

WT1:    DCR	A		;4
	JNZ	WT1		;10 WHEN JUMP
				;7 WHEN NOT JUMP
	RET			;10
;(14 TIMES 139 + 24) X 500 NS = 0.985 MS

WT2MS:  CALL	WT1MS
	CALL	WT1MS
	RET

WT50MS: MVI	B,50		;7

WT2:    CALL	WT1MS		;18
	DCR	B		;4
	JNZ	WT2		;10 WHEN JUMPS
				;7 WHEN DOES NOT JUMP
	RET			;10

WT100MS:CALL	WT50MS
	CALL	WT50MS
	RET

WT05S:  MVI	C,10		;7

WT3:    CALL	WT50MS		;18
	DCR	C		;4
	JNZ	WT3		;10 WHEN JUMP
				;7 WHEN NOT JUMP
	RET			;10

;-----------------------;
;   PRHL SUBROUTINE     ;
;-----------------------;
;PRINT THE CONTENT OF H,L REG

PRHL:   MOV	A,H		;GET VALUE OF H REG
	STA	ACUM		;SAVE IT
	CALL	PRASCI		;PRINT VALUE OF H REG

	MOV	A,L		;GET VALUE OF L REG
	STA	ACUM		;SAVE IT
	CALL	PRASCI		;PRINT VALUE OF L REG
	RET
	PAGE
;------------------------;
;  PRASCI SUBROUTINE     ;
;------------------------;
;CONVERT THE VALUE STORED AT 'acum' ADDRESS INTO ASCII VALUE
;STORE THE RESULT AT 'ascii' ADDRESS (TWO BYTES)
;USE ONLY THE ACUMULATOR
;PRINT THE ASCII VALUE

PRASCI: LDA	ACUM		;GET VALUE
	RRC
	RRC
	RRC
	RRC			;SHIFT NIBBLE TO RIGHT
	ANI	0FH		;ONLY RIGHT NIBBLE
	CPI	0AH		;CHECK IF NUMBER OR LETTER
	JC	NUM1		;IT'S A NUMBER (0 THRU 9)

LET1:   ADI	UPLETD		;3-3a - changed to upper case
				;IT'S LETTER, GET ASCII VALUE (A-F)
	JMP	OVER3

NUM1:   ADI	NUMDIF		;GET ASCII VALUE

OVER3:  STA	ASCII		;SAVE ASCII VALUE FOR LEFT NIBBLE

	LDA	ACUM		;GET INITIAL VALUE AGAIN
	ANI	0FH		;ONLY RIGHT NIBBLE
	CPI	0AH		;CHECK IF NUMBER
	JC	NUM2		;NUMBER

LET2:   ADI	UPLETD		;3-3a - changed to upper case
				;GET ASCII VALUE (A-F)
	JMP	OVER4

NUM2:   ADI	NUMDIF		;GET ASCII VALUE

OVER4:  STA	ASCII+1		;SAVE ASCII VALUE FOR RIGHT NIBBLE

	CALL	TRDY
	LDA	ASCII		;GET FIRST BYTE
	STA	UART		;PRINT IT

	CALL	TRDY
	LDA	ASCII+1		;GET SECOND BYTE
	STA	UART		;PRINT IT
	RET

	PAGE
;-----------------------;
;    CKEND SUBROUTINE   ;
;-----------------------;
;CHECK IF ADDRESS AT CRTADR EQUALS ADDRESS AT ADDR2
;CHECK IF ADDRESS AT CRTADR EQUALS ADDRESS AT MAXADR
;RETURN WITH ZERO FLAG SET IF YES
;DO NOT USE H,L

CKEND:  LDA	CRTADR
	MOV	C,A		;LOW BYTE INTO C
	LDA	CRTADR+1
	MOV	B,A		;HIGH BYTE INTO B

	LDA	ADDR2		;A = LOW BYTE
	CMP	C
	JNZ	TRYMAX		;CURRENT ADDRESS NOT EQUAL TO ADDR2

	LDA	ADDR2+1		;HIGH BYTE
	CMP	B
	RZ			;CURRENT ADDRESS EQUAL TO ADDR2

TRYMAX: LDA	MAXADR		;LOW BYTE
	CMP	C
	RNZ			;CURRENT ADDRESS NOT EQUAL TO MAXADR

	LDA	MAXADR+1	;HIGH BYTE
	CMP	B
	RET			;RETURN WITH ZERO FLAG SET IF EQU TO MAXADR

	PAGE

SETBR:  STA	BRATE		;SAVE BAUD RATE
	MOV	A,H
	ANI	7FH
	ORI	40H
	MOV	H,A
	SHLD	TIMREG
	MVI	A,STRTIM
	STA	TIMCTRL
	CALL	WT100MS
	CALL	RRDY		;GET DATA AGAIN
	CPI	ASCSP		;SPACE ?
	RET

;-----------------------;
;   CKBRK SUBROUTINE    ;
;-----------------------;
;CHECK IF '$' WAS RECEIVED
;RETURN WITH Z SET IF YES
;CHECK IF XOFF WAS RECEIVED
;WAIT FOR XON IF YES

CKBRK:  LDA	USTAT		;GET STATUS
	ANI	RXRDY		;ONLY RXRDY BIT
	JZ	RET1		;RETURN WITH ZERO CLEARED

	LDA	UART		;GET DATA
	ANI	7FH		;NO PARITY
	CPI	ASC$
	RZ			;RETURN WITH Z SET

	CPI	XOFF
	RNZ			;RETURN WITH Z CLEARED

WTXON:  CALL	RRDY		;WAIT FOR DATA
	CPI	XON		;SEE IF IT'S XON
	JNZ	WTXON		;WAIT

RET1:   ADI	1		;CLEAR ZERO FLAG
	RET

;--------------------------;
; COMPUTE ABSOLUTE ADDRESS ;
;--------------------------;
; INPUT: Locations CRTADR and ADROFF setup
; OUTPUT: HL = Absolute address to display
;
GETABS:	PUSH	D		;3-3a - SAVE WORK REGISTERS
	LHLD	CRTADR		;3-3a -  GET CURRENT ADDRESS INDEX
	XCHG			;3-3a - MOVE TO "DE"
	LHLD	ADROFF		;3-3a - GET ABSOLUTE START ADDRESS
	DAD	D		;3-3a - COMPUTE ABSOLUTE ADDRESS IN HL
	SHLD	ABSADR		;3-3a - SAVE IT FOR GRINS
	POP	D		;3-3a - RESTORE WORK REGISTER
	RET			;3-3a - AND GO BACK TO CALLER

;-----------------------;
;   SAVREG SUBROUTINE   ;
;-----------------------;

;SAVE ALL REGISTERS IN STACK

SAVREG: XTHL			;PUSH H, RET IN H
	PUSH D
	PUSH B
	PUSH PSW
	PCHL			;RETURN

;-----------------------;
;   GETREG SUBROUTINE   ;
;-----------------------;

;RESTORE REGISTERS FROM STACK

GETREG: POP H			;GET RET
	POP PSW
	POP B
	POP D
	XTHL			;RET ON STACK
	RET

	PAGE
;-----------------------;
;   TKDAT SUBROUTINE    ;
;-----------------------;

;TAKE DATA FROM UART & PUT IT WHERE H,L POINTS
;CLEAR BUFCNT & BUFFER BEFORE CALL
;B MUST HAVE # OF ENTRIES ACCEPTED
;RETURN WITH CARRY IF $ WAS TYPED
;SAME IF TOO MANY CHARACTERS WERE TYPED
;RETURN WITH ZERO IF NOTHING WAS TYPED
;WHEN RETURN CHECK CARRY FIRST....

TKDAT:  CALL	RRDY		;WAIT FOR DATA
	CALL	ECHO		;ECHO IT
	CPI	ASCCR
	JZ	EXECT		;EXECUTE COMMAND
	CPI	08H		;BACK SPACE?'
	JZ	ERASE		;DELETE LAST ENTRY
	CPI	ASC$
	JZ	ABORT		;TERMINATE

	MOV	M,A		;DATA VALID, STORE IT
	LDA	BUFCNT		;# OF CHARACTERS IN BUFFER
	INR	A
	STA	BUFCNT		;UPDATE IT

	INX	H		;UPDATE ADDRESS IN BUFFER
	DCR	B		;CHECK FOR MAX
	JZ	ABORT		;TOO MANY CHARACTERS
	JMP	TKDAT		;GET ANOTHER

EXECT:  LDA	BUFCNT
	CPI	0		;BUFFER EMPTY ?
	RET			;RET WITH ZERO IF NOTHING WAS TYPED (NO CARRY)

;-----------------------;
;   ERASE FUNCTION      ;
;-----------------------;

ERASE:  LDA	BUFCNT
	CPI	0		;ANI CHARACTERS IN?
	JZ	TKDAT		;FIRST WAS BACK SPACE, DO NOTHING
	DCR	A
	STA	BUFCNT		;ONE LESS
	DCX	H		;BACK UP
	XRA	A		;CLEAR ACUMULATOR
	MOV	M,A		;CLEAR BUFFER
	INR	B		;ROOM FOR ONE MORE CHARACTER
	JMP	TKDAT	;

ABORT:  STC
	RET			;RETURN WITH CARRY IF TOO MANY CHARACTERS

;-----------------------;
;   CLEAR SUBROUTINE    ;
;-----------------------;
;
;CLEAR # OF CHARACTERS IN B FROM WHERE H,L POINTS

CLEAR:  XRA	A		;CLEAR ACUM
	MOV	M,A		;CLEAR BUFFER
	INX	H
	DCR	B
	JNZ	CLEAR
	RET

	PAGE
;-----------------------;
;    RECEIVE ROUTINE    ;
;-----------------------;

RCVE:   CALL	SAVREG		;SAVE REGISTERS
	LDA	UART		;READ UART
	ANI	7FH		;WITHOUT PARITY
	CALL	LOWER		;CONVERT TO LOWER CASE
	STA	UDATA		;SAVE DATA

	CPI	ASCSP		;'space' ?
	JZ	DONE20		;DO NOTHING

	CPI	ASCCR		;'carriage return'?
	JZ	DONE30		;SET EOL FLAG

	CPI	ASCLF		;'new line'
	JZ	DONE20		;IGNORE

	CPI	ASC$		;END OF STRING?
	JZ	B10		;YES

	XRA	A
	STA	DONEFL		;NOT DONE
	STA	EOLFLG		;CLEAR EOL FLAG
	JMP	B30		;VALID CHARACTER

B10:    MVI	A,1
	STA	DONEFL

B20:    LDA	UDATA		;GET DATA
	LHLD	BUFPNT		;GET POINTER TO FIFO
	MOV	M,A		;STORE DATA
	INX	H
	SHLD	BUFPNT		;UPDATE POINTER

	LDA	BUFCNT		;# OF CHARACTERS IN BUFFER
	INR	A
	STA	BUFCNT
	JMP	DONE20

DONE30: MVI	A,1
	STA	EOLFLG		;SET EOL FLAG

DONE20: CALL	GETREG
	EI
	RET

B30:    LDA	FLAG16
	CPI	0
	JZ	B20		;16 BIT PATH NOT SET, STORE CHARATER, RETURN

	INR	A		;INCREMENT FLAG
	CPI	0		;CHECK IF WRAPS AROUND
	JNZ	NOTYET

	MVI	A,04H		;BYPASS WRAP AROUND, KEEP SAME PARITY

NOTYET: STA	FLAG16		;SAVE FLAG
	ANI	02H		;TAKE ONLY BIT 1
	CPI	0		;EVEN ?
	JNZ	B20		;NO, STORE THIS CHARACTER
	JMP	DONE20		;YES, DO NOT STORE
	PAGE
;-----------------------;
;   LITON ROUTINE       ;
;-----------------------;

;SET 'sod' HIGH (WILL BE USED TO ENABLE PROGR. LED)

LITON:  RIM
	ORI	0C0H		;ENABLE SOD HIGH
	SIM
	RET

;-----------------------;
;  LITOFF ROUTINE       ;
;-----------------------;

;SET 'sod' LOW (TURN PROGR. LED OFF)

LITOFF: RIM
	ORI	40H		;ENABLE SOD
	ANI	7FH		;SOD LOW
	SIM
	RET

	PAGE
;-----------------------;
;       I/O MASKS       ;
;-----------------------;

;I/O MASKS FOR 2758 (MODEL A)

AMSKTAB:
AMSKVCC:	DW	0C320H
AMVPP5V:	DW	0140H
AMVP21V:	DW	0000H
AMVP25V:	DW	4280H
AMFUNC1:	DW	9802H
AMFUNC2:	DW	8004H
AMFUNC3:	DW	0208H
AMSKA08:	DW	8010H
AMSKA09:	DW	8108H
AMSKA10:	DW	0000H
AMSKA11:	DW	0000H
AMSKA12:	DW	0000H
AMSKA13:	DW	0000H
AMSKA14:	DW	0000H
AMSKA15:	DW	0500H
AMAXADR:	DW	03FFH	;MAX ADDRESS
AMSGPRT:	DW	PRMPTA	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 2716 (MODEL B)

BMSKTAB:
BMSKVCC:	DW	0C320H
BMVPP5V:	DW	0140H
BMVP21V:	DW	0000H
BMVP25V:	DW	4280H
BMFUNC1:	DW	9802H
BMFUNC2:	DW	0208H
BMFUNC3:	DW	0000H
BMSKA08:	DW	8010H
BMSKA09:	DW	8108H
BMSKA10:	DW	8F04H
BMSKA11:	DW	0400H
BMSKA12:	DW	0000H
BMSKA13:	DW	0000H
BMSKA14:	DW	0000H
BMSKA15:	DW	0100H
BMAXADR:	DW	07FFH	;MAX ADDRESS
BMSGPRT:	DW	PRMPTB	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 2732 (MODEL C)

CMSKTAB:
CMSKVCC:	DW	0C320H
CMVPP5V:	DW	0008H
CMVP21V:	DW	0000H
CMVP25V:	DW	0220H
CMFUNC1:	DW	9602H
CMFUNC2:	DW	0000H
CMFUNC3:	DW	0000H
CMSKA08:	DW	8010H
CMSKA09:	DW	8108H
CMSKA10:	DW	8F04H
CMSKA11:	DW	0440H
CMSKA12:	DW	0000H
CMSKA13:	DW	0000H
CMSKA14:	DW	0000H
CMSKA15:	DW	0100H
CMAXADR:	DW	0FFFH	;MAX ADDRESS
CMSGPRT:	DW	PRMPTC	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 2732A (MODEL D)

DMSKTAB:
DMSKVCC:	DW	0C320H
DMVPP5V:	DW	0008H
DMVP21V:	DW	0210H
DMVP25V:	DW	0000H
DMFUNC1:	DW	9602H
DMFUNC2:	DW	0000H
DMFUNC3:	DW	0000H
DMSKA08:	DW	8010H
DMSKA09:	DW	8008H
DMSKA10:	DW	8F04H
DMSKA11:	DW	0440H
DMSKA12:	DW	0000H
DMSKA13:	DW	0000H
DMSKA14:	DW	0000H
DMSKA15:	DW	0100H
DMAXADR:	DW	0FFFH	;MAX ADDRESS
DMSGPRT:	DW	PRMPTD	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 2764 (MODEL E)

EMSKTAB:
EMSKVCC:	DW	0C380H
EMVPP5V:	DW	0101H
EMVP21V:	DW	4202H
EMVP25V:	DW	0000H
EMFUNC1:	DW	0D740H
EMFUNC2:	DW	0208H
EMFUNC3:	DW	8002H
EMSKA08:	DW	8010H
EMSKA09:	DW	8108H
EMSKA10:	DW	8F04H
EMSKA11:	DW	0440H
EMSKA12:	DW	8001H
EMSKA13:	DW	0000H
EMSKA14:	DW	0000H
EMSKA15:	DW	0100H
EMAXADR:	DW	1FFFH	;MAX ADDRESS
EMSGPRT:	DW	PRMPTE	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 27128 (MODEL G)

GMSKTAB:
GMSKVCC:	DW	0C380H
GMVPP5V:	DW	0101H
GMVP21V:	DW	4202H
GMVP25V:	DW	0000H
GMFUNC1:	DW	0D740H
GMFUNC2:	DW	0208H
GMFUNC3:	DW	8002H
GMSKA08:	DW	8010H
GMSKA09:	DW	8108H
GMSKA10:	DW	8F04H
GMSKA11:	DW	0340H
GMSKA12:	DW	8001H
GMSKA13:	DW	8020H
GMSKA14:	DW	0000H
GMSKA15:	DW	0900H	;FAST O.K.,SLOW DENIED,ERASE PROTECT
GMAXADR:	DW	3FFFH	;MAX ADDRESS
GMSGPRT:	DW	PRMPTG	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 27256 (MODEL I)

IMSKTAB:
IMSKVCC:	DW	0C380H
IMVPP5V:	DW	0101H
IMVP21V:	DW	4202H
IMVP25V:	DW	0000H
IMFUNC1:	DW	0000H
IMFUNC2:	DW	0208H
IMFUNC3:	DW	0D602H
IMSKA08:	DW	8010H
IMSKA09:	DW	8108H
IMSKA10:	DW	9904H	;MAX 25 1MS PULSES
IMSKA11:	DW	0340H
IMSKA12:	DW	8001H
IMSKA13:	DW	8020H
IMSKA14:	DW	8040H
IMSKA15:	DW	0900H	;FAST O.K., SLOW DENIED, ERASE PROTECT
IMAXADR:	DW	7FFFH	;MAX ADDRESS
IMSGPRT:	DW	PRMPTI	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 2508 (MODEL K)

KMSKTAB:
KMSKVCC:	DW	0C320H
KMVPP5V:	DW	0140H
KMVP21V:	DW	0000H
KMVP25V:	DW	4280H
KMFUNC1:	DW	9802H
KMFUNC2:	DW	0208H
KMFUNC3:	DW	0000H
KMSKA08:	DW	8010H
KMSKA09:	DW	8108H
KMSKA10:	DW	0000H
KMSKA11:	DW	0000H
KMSKA12:	DW	0000H
KMSKA13:	DW	0000H
KMSKA14:	DW	0000H
KMSKA15:	DW	0500H
KMAXADR:	DW	03FFH	;MAX ADDRESS
KMSGPRT:	DW	PRMPTK	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 2516 (MODEL L)

LMSKTAB:
LMSKVCC:	DW	0C320H
LMVPP5V:	DW	0140H
LMVP21V:	DW	0000H
LMVP25V:	DW	4280H
LMFUNC1:	DW	9802H
LMFUNC2:	DW	0208H
LMFUNC3:	DW	0000H
LMSKA08:	DW	8010H
LMSKA09:	DW	8108H
LMSKA10:	DW	8004H
LMSKA11:	DW	0000H
LMSKA12:	DW	0000H
LMSKA13:	DW	0000H
LMSKA14:	DW	0000H
LMSKA15:	DW	0500H
LMAXADR:	DW	07FFH	;MAX ADDRESS
LMSGPRT:	DW	PRMPTL	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 2532 (MODEL M)

MMSKTAB:
MMSKVCC:	DW	0C320H
MMVPP5V:	DW	4140H
MMVP21V:	DW	0000H
MMVP25V:	DW	0280H
MMFUNC1:	DW	1608H	;PGM*
MMFUNC2:	DW	0000H
MMFUNC3:	DW	0000H
MMSKA08:	DW	8010H
MMSKA09:	DW	8108H
MMSKA10:	DW	8F04H
MMSKA11:	DW	8402H
MMSKA12:	DW	0000H
MMSKA13:	DW	0000H
MMSKA14:	DW	0000H
MMSKA15:	DW	0100H
MMAXADR:	DW	0FFFH	;MAX ADDRESS
MMSGPRT:	DW	PRMPTM	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 2564 (MODEL N)

NMSKTAB:
NMSKVCC:	DW	0C380H
NMVPP5V:	DW	4101H
NMVP21V:	DW	0000H
NMVP25V:	DW	0202H
NMFUNC1:	DW	1608H	;PGM*
NMFUNC2:	DW	8001H	;CS1*
NMFUNC3:	DW	8040H	;CS2*
NMSKA08:	DW	8010H
NMSKA09:	DW	8108H
NMSKA10:	DW	8F04H
NMSKA11:	DW	8402H
NMSKA12:	DW	0040H
NMSKA13:	DW	0000H
NMSKA14:	DW	0000H
NMSKA15:	DW	0100H
NMAXADR:	DW	1FFFH	;MAX ADDRESS
NMSGPRT:	DW	PRMPTN	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 68732 (MODEL O)

OMSKTAB:
OMSKVCC:	DW	0C320H
OMVPP5V:	DW	0208H
OMVP21V:	DW	0000H
OMVP25V:	DW	0820H
OMFUNC1:	DW	0040H	;AR
OMFUNC2:	DW	0000H
OMFUNC3:	DW	0000H
OMSKA08:	DW	8010H
OMSKA09:	DW	8108H
OMSKA10:	DW	8004H
OMSKA11:	DW	8002H
OMSKA12:	DW	0000H
OMSKA13:	DW	0000H
OMSKA14:	DW	0000H
OMSKA15:	DW	0500H
OMAXADR:	DW	0FFFH	;MAX ADDRESS
OMSGPRT:	DW	PRMPTO	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 68764 (MODEL P)

PMSKTAB:
PMSKVCC:	DW	0C320H
PMVPP5V:	DW	0208H
PMVP21V:	DW	0000H
PMVP25V:	DW	0820H
PMFUNC1:	DW	0000H
PMFUNC2:	DW	0000H
PMFUNC3:	DW	0000H
PMSKA08:	DW	8010H
PMSKA09:	DW	8008H
PMSKA10:	DW	8004H
PMSKA11:	DW	8002H
PMSKA12:	DW	0040H
PMSKA13:	DW	0000H
PMSKA14:	DW	0000H
PMSKA15:	DW	0500H
PMAXADR:	DW	1FFFH	;MAX ADDRESS
PMSGPRT:	DW	PRMPTP	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 68766 (MODEL Q)

QMSKTAB:
QMSKVCC:	DW	0C320H
QMVPP5V:	DW	0208H
QMVP21V:	DW	0000H
QMVP25V:	DW	0820H
QMFUNC1:	DW	0000H
QMFUNC2:	DW	0000H
QMFUNC3:	DW	0000H
QMSKA08:	DW	8010H
QMSKA09:	DW	8108H
QMSKA10:	DW	8004H
QMSKA11:	DW	8002H
QMSKA12:	DW	0040H
QMSKA13:	DW	0000H
QMSKA14:	DW	0000H
QMSKA15:	DW	0500H
QMAXADR:	DW	1FFFH	;MAX ADDRESS
QMSGPRT:	DW	PRMPTQ	;ADDRESS OF PROMPT MESSAGE

;I/O MASK FOR 2816A (MODEL R)

RMSKTAB:
RMSKVCC:	DW	0E320H
RMVPP5V:	DW	0000H
RMVP21V:	DW	0000H
RMVP25V:	DW	0000H
RMFUNC1:	DW	8002H	;CE*
RMFUNC2:	DW	2208H	;OE*
RMFUNC3:	DW	6740H	;WE*
RMSKA08:	DW	8010H
RMSKA09:	DW	8108H
RMSKA10:	DW	8004H
RMSKA11:	DW	0000H
RMSKA12:	DW	0000H
RMSKA13:	DW	0000H
RMSKA14:	DW	0800H
RMSKA15:	DW	0600H
RMAXADR:	DW	07FFH   ;MAX ADDRESS
RMSGPRT:	DW	PRMPTR	;ADDRESS OF PROMPT MESSAGE

;I/O MASK FOR 52B13 (MODEL U)

UMSKTAB:
UMSKVCC:	DW	0E320H
UMVPP5V:	DW	0208H	;OE*
UMVP21V:	DW	2010H	;OE*
UMVP25V:	DW	0000H
UMFUNC1:	DW	8002H	;CE*
UMFUNC2:	DW	0000H
UMFUNC3:	DW	7740H	;WE*
UMSKA08:	DW	8010H
UMSKA09:	DW	8108H
UMSKA10:	DW	8004H
UMSKA11:	DW	0000H
UMSKA12:	DW	0000H
UMSKA13:	DW	0000H
UMSKA14:	DW	0000H
UMSKA15:	DW	0400H
UMAXADR:	DW	07FFH	;MAX ADDRESS
UMSGPRT:	DW	PRMPTU	;ADDRESS OF PROMPT MESSAGE

;I/O MASK FOR 52B23 (MODEL V)

VMSKTAB:
VMSKVCC:	DW	0E380H
VMVPP5V:	DW	2208H	;OE*
VMVP21V:	DW	0000H
VMVP25V:	DW	0000H
VMFUNC1:	DW	8002H	;CE*
VMFUNC2:	DW	4301H	;CC*
VMFUNC3:	DW	0F740H	;WE*
VMSKA08:	DW	8010H
VMSKA09:	DW	8108H
VMSKA10:	DW	8004H
VMSKA11:	DW	0040H
VMSKA12:	DW	0000H
VMSKA13:	DW	0000H
VMSKA14:	DW	0000H
VMSKA15:	DW	0400H
VMAXADR:	DW	0FFFH	;MAX ADDRESS
VMSGPRT:	DW	PRMPTV	;ADDRESS OF PROMPT MESSAGE

;I/O MASK FOR 52B33 (MODEL W)

WMSKTAB:
WMSKVCC:	DW	0E380H
WMVPP5V:	DW	2208H	;OE*
WMVP21V:	DW	0000H
WMVP25V:	DW	0000H
WMFUNC1:	DW	8002H	;CE*
WMFUNC2:	DW	4301H	;CC*
WMFUNC3:	DW	0F740H  ;WE*
WMSKA08:	DW	8010H
WMSKA09:	DW	8108H
WMSKA10:	DW	8004H
WMSKA11:	DW	0040H
WMSKA12:	DW	8001H
WMSKA13:	DW	0000H
WMSKA14:	DW	0000H
WMSKA15:	DW	0400H
WMAXADR:	DW	1FFFH	;MAX ADDRESS
WMSGPRT:	DW	PRMPTW	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 8748H (MODEL 3)

X3MSKA08:	DW	8001H
X3MSKA09:	DW	8202H
X3MSKA10:	DW	0000H
X3MSKA11:	DW	0000H
X3MSKA12:	DW	0000H
X3MSKA13:	DW	0000H
X3MSKA14:	DW	0000H
X3MSKA15:	DW	0500H
X3MAXADR:	DW	03FFH	;MAX ADDRESS
X3MSGPRT:	DW	PRMPT3	;ADDRESS OF PROMPT MESSAGE

;I/O MASKS FOR 8749H (MODEL 4)

X4MSKA08:	DW	8001H
X4MSKA09:	DW	8202H
X4MSKA10:	DW	8004H
X4MSKA11:	DW	0000H
X4MSKA12:	DW	0000H
X4MSKA13:	DW	0000H
X4MSKA14:	DW	0000H
X4MSKA15:	DW	0500H
X4MAXADR:	DW	07FFH	;MAX ADDRESS
X4MSGPRT:	DW	PRMPT4	;ADDRESS OF PROMPT MESSAGE

;       COPY ROUTINE

COPY:   LXI	H,0		;START ADDRESS ZERO
	SHLD	CRTADR
	LXI	H,COPY-1
	SHLD	ADDR2

	CALL	LITON

BCOPY:  MOV	A,M		;READ PROGRAM
	STA	HEXDAT
	CALL	PUTDAT		;USE DATA
	JNZ	ERRCOPY		;STOP IF ERROR

	LHLD	CRTADR
	INX	H
	SHLD	CRTADR		;INCREMENT ADDRESS

	CALL	CKEND
	JZ	LOOP

	JMP	BCOPY		;NOT DONE

ERRCOPY:LXI	H,MSGCANT
	CALL	PRINT
	LHLD	CRTADR
	CALL	PRHL
	JMP	LOOP

	END