;****************************************************************
;*								*
;*	  EPIC SALES INC. MOVER PROGRAM FOR FIXED DISK		*
;*			BACK END DRIVER				*
;*								*
;*	TITLE:	MOVEIT.ASM					*
;*								*
;*	VERSION 3.0	SEPT. 25, 1984				*
;*								*
;****************************************************************
;MOVEIT IS MERGED WITH FDBED.HEX UNDER DDT
;
;SET THE COMPUTER TYPE AND NUMBER OF FIXED DRIVES TO AGREE
;WITH "FDBED" AND ASSEMBLE MOVEIT USING CPM ASSEMBLER.
;IN FDBED AND ASSEMBLE "MOVEIT".
;
;START DDT
;FILL LOWER MEMORY WITH 00H TO CLEAR OUT
;GARBAGE FROM THE DDT LOAD  I.E.
;F100 4FFF 0 (CR)
;
;LOAD MOVEIT.HEX
;
;IMOVEIT.HEX (CR)
;R (CR)
;NOW CALCULATE THE LOAD BIAS FOR FDBED
;USEING DDT HEXMATH ROUTINE
;I.E. H0400 FA70 (CR)  (ASSUMEING FA70H IS THE ORG FOR START)
;     FE70 0990        (DDT`S RESPONSE)
;    (SUMM)(DIFF)
;
;NOW LOAD FDBED.HEX USEING 'DIFF' FROM ABOVE FOR A BIAS
;
;IFDBED.HEX (CR)
;R990 (CR)
;
;YOU NOW SHOULD HAVE MOVEIT AT 0100H,
;THE INIT PORTION OF BED AT 0300H,
;AND THE MAIN PORTION OF BED AT 0400H
;
;GET BACK TO CP/M WITH CONTROL C OR G0 (CR)
;SAVE THE RESULTING FILE WITH
;SAVE 8 DRV406.COM (CR) OR WHATEVER FILE NAME YOU WANT.
;FOR "FDINST" TO WORK CORRECTLY THE FILE NAME MUST BE
;SELECTED AS DESCRIBED IN "FDINST.MAC"
;
;EXECUTE THE FILE BY TYPING THE FILE NAME (CR)
;
;***** NOTE EXECUTE THIS FILE ONLY ONCE *****
;
;THIS IS BECAUSE THE JUMP TABLE ENTRY POINTS OF 
;THE BIOS ARE ALTERED SO THAT THE DRIVER CAN TRAP
;DISK I/O CALLS THAT REFER TO THE HARD DISK
;
;IF EXECUTED A 2ND TIME WITHOUT A COLD BOOT OF
;THE ENTIRE SYSTEM, THE SOFTWARE WILL LOCK UP !!
;
;
;
FALSE	EQU	0	;DEFINE FALSE
TRUE	EQU	NOT FALSE
;
;  SET THE FOLLOWING EQUATES TO AGREE WITH FDBED.ASM
;
;COMPUTER TYPE
X820	EQU	TRUE	;820
X820SWP	EQU	FALSE	;820 W/ SWP DD ADAPTER BOARD
X820II	EQU	FALSE	;820-II
BBI	EQU	FALSE	;BIGBOARD-I
;NUMBER OF PHYSICAL FIXED DISK DRIVES
FD1	EQU	TRUE	;ONE FIXED DISK DRIVE OF ANY SIZE
			;OR TWO 5 MEGABYTE DRIVES
FD2	EQU	FALSE	;TWO FIXED DISK DRIVES
			;10 MEGABYTES OR LARGER OR
			;ONE 20 MEGABYTE ON 820-II
;
	IF	X820 AND FD1
START	EQU	0FA70H
	ENDIF
;
	IF	X820 AND FD2
START	EQU	0FA00H
	ENDIF
;
	IF	X820SWP
START	EQU	0CF00H
	ENDIF
;
	IF	X820II AND FD1
START	EQU	0EBC0H
	ENDIF
;
	IF	X820II AND FD2
START	EQU	0EB00H
	ENDIF
;
	IF	BBI AND FD1
START	EQU	0FA70H
	ENDIF
;
	IF	BBI AND FD2
START	EQU	0FA00H
	ENDIF
;
INIT	EQU	0300H	;INITIALIZE PORTION AFTER MERGE
LOC	EQU	0400H	;BED LOCATION AFTER MERGE
;
;
	ORG	0100H
;
MOVEIT:	LXI	H,START
	LXI	D,LOC	;SOURCE ADDRESS
	LXI	B,03FFH	;BYTE COUNT TO MOVE (1K)
LOOP:	LDAX	D	;GET A SOURCE BYTE
	MOV	M,A	;MOVE IT
	INX	H	;BUMP THE POINTERS
	INX	D
	DCX	B	;AND THE LOOP COUNT
	MOV	A,C	;TEST LOOP COUNT FOR ZERO
	ORA	B
	JNZ	LOOP	;LOOP TILL DONE
	CALL	INIT	;INITIALIZE THE BACK END DRIVER
	JMP	0000H	;AND DO A WARM START
;
	END	MOVEIT
