;***********************************************************
;*                                                         *
;*	EPIC SALES INC. FIXED DISK SYSTEM		   *
;*  BACK END DRIVER PROGRAM FOR WD1001 OR WD1002           *
;*  CONTROLLER AND EPIC SALES XEROX 820 HOST ADAPTER       *
;*                                                         *
;*	VERSION 3.0	SEPT. 25,1984			   *
;*		MOD. DEC. 21,1984			   *
;*                                                         *
;*	TITLE:	FDBED.ASM				   *
;*		(FIXED DISK BACK END DRIVER)		   *
;*                                                         *
;*                                                         *
;***********************************************************
;
;  SIZE REQUIREMENTS FOR CPM OPERATING SYSTEM
;FOR 820, 820SWP, AND BIGBOARD W/ ONE FIXED DRIVE, CPM MUST BE 60K
;FOR 820 AND BIGBOARD W/ TWO FIXED DIRVES CPM MUST BE 59K
;FOR 820SWP W/ TWO FIXED DRIVES CPM MUST BE 60K
;FOR 820II W/ ONE FIXED DRIVE CPM MUST BE 59K
;FOR 820II W/ TWO FIXED DRIVES CPM MUST BE 58K
;
TRUE	EQU	0FFFFH	;
FALSE	EQU	NOT TRUE	;
;
;***THE USER MUST SET THE FOLLOWING EQUATES FOR HIS SYSTEM***
;
;  DRIVE TYPE
ST506	EQU	FALSE	;5 MEG ST506
ST406	EQU	FALSE	;5 MEG ST406
ST412	EQU	FALSE	;10 MEG ST412
ST419	EQU	TRUE	;15 MEG ST419
RMS526	EQU	FALSE	;20 MEG RMS526
;
;  COMPUTER TYPE
X820	EQU	TRUE	;820-I
X820SWP	EQU	FALSE	;820-I WITH SOFTWARE PUBLISHERS DD ADATPER
X820II	EQU	FALSE	;820-II
BBI	EQU	FALSE	;BIGBOARD I
BBISWP	EQU	FALSE	;BIGBOARD I WITH SOFTWART PUBLISHERS DD ADAPTER
;
;  NUMBER OF FIXED DISK DRIVES
;HD3 AND HD4 MUST BE TRUE IF TWO PHYSICAL FIXED DRIVES
;GRATER IN SIZE THAN 5 MEGABYTES ARE USED.
HD2	EQU	TRUE	;TRUE IF SECOND LOGICAL FIXED DISK
			;HD2 MUST BE TRUE FOR AN ST412 OR
			;ST419 OR RMS526
HD3	EQU	TRUE	;TRUE IF THIRD LOGICAL FIXED DISK
			;HD3 MUST BE TRUE FOR AN RMS526
HD4	EQU	TRUE	;TRUE IF FOURTH LOGICAL FIXED DISK
;
	IF	X820
DIRBUF	EQU	0ED29H	;MEMORY LOC. FOR DIR BUFFER IN BIOS
UNIT	EQU	0ED02H
	ENDIF
	IF	X820 AND NOT HD3 AND NOT HD4
START	EQU	0FA70H
BA	EQU	0EA00H
	ENDIF
	IF	X820 AND HD3 AND NOT HD4
START	EQU	0FA70H
BA	EQU	0EA00H
	ENDIF
	IF	X820 AND HD3 AND HD4
START	EQU	0FA00H
BA	EQU	0E600H
	ENDIF
;
	IF	X820SWP
START	EQU	0CF00H
DIRBUF	EQU	0F880H
BA	EQU	0EA00H
	ENDIF
;
	IF	X820II
DIRBUF	EQU	0FC80H
	ENDIF
	IF	X820II AND NOT HD3 AND NOT HD4
START	EQU	0EBC0H
BA	EQU	0E600H
	ENDIF
	IF	X820II AND HD3 AND NOT HD4
START	EQU	0EB00H
BA	EQU	0E200H
	ENDIF
	IF	X820II AND HD3 AND HD4
START	EQU	0EB00H
BA	EQU	0E200H
	ENDIF
;
	IF	BBI
DIRBUF	EQU	0ED29H
UNIT	EQU	0ED61H
	ENDIF
	IF	BBI AND NOT HD3 AND NOT HD4
START	EQU	0FA70H
BA	EQU	0EA00H
	ENDIF
	IF	BBI AND HD3 AND NOT HD4
START	EQU	0FA70H
BA	EQU	0EA00H
	ENDIF
	IF	BBI AND HD3 AND HD4
START	EQU	0FA00H
BA	EQU	0E600H
	ENDIF
;
	IF	BBISWP
START	0EC00H
DIRBUF	0FA80H
BA	0E600H
	ENDIF
;
;
CONOUT	EQU	0F00CH
			;
			;
			;
BASADD	EQU	080H	;CONTOLLER BASE ADDRESS
DATA	EQU	BASADD		;DATA ACCESS PORT
ERROR	EQU	BASADD+1	;ERROR (INPUT) PORT
WPC	EQU	BASADD+1	;WRITE PRECOMP REGISTER
SECNT	EQU	BASADD+2	;SECTOR COUNT REGISTER
SECNO	EQU	BASADD+3	;SECTOR NUMBER
CYLLO	EQU	BASADD+4	;LOW 8 BITS OF CYLINDER NUMBER
CYLHI	EQU	BASADD+5	;HIGH ORDER (2) BITS OF CYLINDER
SDH	EQU	BASADD+6	;SIZE/HEAD/DRIVE REGISTER
STATUS	EQU	BASADD+7		;STATUS (INPUT) REGISTER
COMND	EQU	BASADD+7		;COMMAND REGISTER
			;
CREST	EQU	010H	;RESTORE COMMAND
CREAD	EQU	020H	;READ COMMAND
CWRITE	EQU	030H	;WRITE COMMAND
CFMT	EQU	050H	;FORMAT COMMAND
			;
SRATE	EQU	0	;STEP RATE = BUFFERED SEEK
			;(EQUATE SRATE TO 6 FOR 3 MS STEP RATE)
SCTR	EQU	32	;SECTORS/TRACK
TRK	EQU	306	;TRACKS PER DRIVE
;
;
	IF	ST506
SCTRCL	EQU	4*SCTR	;SECTORS/CYL
HDMSK	EQU	3	;4 HEADS ON 406
SPT	EQU	256	;256 LOGICAL SECTORS PER TRACK
DSM	EQU	611	;612 8k BLOCKS
RSTRKS	EQU	0	;RESERVED TRACKS
ALSIZE	EQU	77	;ALLOCATION TABLE SIZE
	ENDIF
;
	IF	ST406
SCTRCL	EQU	2*SCTR	;SECTORS/CYLINDER
HDMSK	EQU	1	;2 HEADS ON 406
SPT	EQU	128	;128 LOGICAL SECTORS PER TRACK
DSM	EQU	611	;612 8K BLOCKS
RSTRKS	EQU	0	;RESERVED TRACKS
ALSIZE	EQU	77	;ALLOCATION TABLE SIZE
	ENDIF
;
	IF	ST412
SCTRCL	EQU	4*SCTR	;SECTORS/CYLINDER
HDMSK	EQU	3	;4 HEADS ON 412
SPT	EQU	256	;256 LOGICAL SECTORS PER TRACK
DSM	EQU	611	;612 8K BLOCKS (2 LOGICAL DRIVES)
RSTRKS	EQU	153	;153 RESERVED TRACKS FOR 2ND LOGICAL DRIVE
ALSIZE	EQU	77	;ALLOCATION TABLE SIZE
	ENDIF
;
;
	IF	ST419
SCTRCL	EQU	6*SCTR	;SECTORS/CYLINDER
HDMSK	EQU	7	;6 HEADS ON 419
SPT	EQU	384	;384 LOGICAL SECTORS PER TRACK
DSM	EQU	917	;918 8K BLOCKS
RSTRKS	EQU	153	;153 RESERVED TRACKS FOR 2ND LOGICAL DRIVE
ALSIZE	EQU	115	;ALLOCATION TABLE SIZE
	ENDIF
;
;
	IF	RMS526
SCTRCL	EQU	8*SCTR	;SECTORS/CYLINDER
HDMSK	EQU	7	;4 HEADS ON 412
SPT	EQU	512	;LOGICAL SECTORS PER TRACK
DSM	EQU	815	;816 8K BLOCKS (3 LOGICAL DRIVES)
RSTRKS	EQU	102	;102 RESERVED TRACKS FOR 1ST LOGICAL DRIVE
RSTKS2	EQU	204	;204 RESERVED TRACKS FOR 1ST & 2ND DRIVES
ALSIZE	EQU	102	;ALLOCATION TABLE SIZE
	ENDIF
;
;
DMY	EQU	0	;WARM BOOT JUMP ADDRESS IF NO ADDRESS PASSED IN
HDNUM	EQU	4	;DRIVE NUMBER FOR HARD DISC (DRIVE E)
HDNUM2	EQU	HDNUM+1	;DRIVE F
HDNUM3	EQU	HDNUM+2	;DRIVE G
HDNUM4	EQU	HDNUM+3	;DRIVE H
BDOS	EQU	5	;BDOS CALL ADDRESS
			;
			;
;***********************************************************
;*                                                         *
;*  DO NOT MOVE OR MODIFY THE CODE FROM  START  (LABEL     *
;*  INSTAL) TO THE LABEL WBOOT.  IF ANY MODIFICATIONS ARE  *
;*  MADE HERE, THE PROGRAM MOVEIT MUST ALSO BE CHANGED     *
;*                                                         *
;***********************************************************
				;
				;START OF BACK END DRIVER
	ORG	START-256	;
			;
INSTAL:			;PROGRAM TO LINK TO BIOS
			;THIS CODE CHANGES THE BIOS JUMP
			;TABLE TO POINT TO THE BACK END DRIVER, AFTER
			;USING THE JUMP TABLE VALUES TO FILL IN BED
			;LOCATIONS FOR ALL DISC FUNCTIONS
	LHLD	BA+4	;
	SHLD	WBX+1	;WARM BOOT
	LHLD	BA+019H	;
	SHLD	SHX+1	;HOME
	LHLD	BA+1CH	;
	SHLD	SDX+1	;SELECT
	LHLD	BA+1FH	;
	SHLD	SEX+1	;SELECT TRACK
	LHLD	BA+22H	;
	SHLD	SSX+1	;SELECT SECTOR
	LHLD	BA+25H	;
	SHLD	SAX+1	;DMA ADDRESS
	LHLD	BA+28H	;
	SHLD	SRX+1	;READ
	LHLD	BA+2BH	;
	SHLD	SWX+1	;WRITE
	LHLD	BA+31H	;
	SHLD	STX+1	;TRANSLATE
	LXI	H,WBOOT	;
	SHLD	BA+4H	;
	LXI	H,SH	;
	SHLD	BA+19H	;
	LXI	H,SD	;
	SHLD	BA+1CH	;
	LXI	H,SE	;
	SHLD	BA+1FH	;
	LXI	H,SS	;
	SHLD	BA+22H	;
	LXI	H,SA	;
	SHLD	BA+25H	;
	LXI	H,SR	;
	SHLD	BA+28H	;
	LXI	H,SW	;
	SHLD	BA+2BH	;
	LXI	H,ST	;
	SHLD	BA+31H	;
	RET
;
;
;*******************************************************
;*                                                     *
;*  END OF NONMODIFYABLE TABLE AREA IN BIOS            *
;*                                                     *
;*******************************************************
;
;
	ORG	START
;
;
	IF	X820 OR BBI
KLUDGE:	JMP	DMY
	ENDIF
;
			;
WBOOT:			;
	CALL	REST	;RESTORE DRIVES
WBX:			;
	JMP	DMY	;
			;
SD:			;SELECT DRIVE
	MOV	A,C	;
	IF	X820 OR BBI
	STA	UNIT	;UPDATE BIOS DRIVE VARIABLE
	ENDIF
	STA	DRIVE	;SAVE DRIVE NUMBER
	CPI	HDNUM	;THIS DRIVE?
	JZ	TD1	;
	IF	HD2	
	CPI	HDNUM2	;
	JZ	TD2	;
	ENDIF
	IF	HD3		
	CPI	HDNUM3	;
	JZ	TD3	;
	ENDIF
	IF	HD4	;
	CPI	HDNUM4	;
	JZ	TD4	;
	ENDIF		
SDX:			;
	JMP	DMY	;
			;
TD1:			;DRIVE E
	LXI	H,HDTBL	;TABLE FOR CP/M
	RET		;BACK TO CPM
			;
	IF	HD2
TD2:			;
	LXI	H,HDTBL2	;
	RET		;
	ENDIF
			;
	IF	HD3
TD3:			;
	LXI	H,HDTBL3	;
	RET		;
	ENDIF
			;
	IF	HD4
TD4:			;
	LXI	H,HDTBL4	;
	RET		;
	ENDIF
			;
			;
SH:			;HOME DRIVE
	CALL	TESTD	;
	JZ	HOME	;
SHX:			;
	JMP	DMY	;TO OTHER BIOS
			;
HOME:			;
	RET		;HOMED, SO RETURN
			;
SE:			;SELECT TRACK
	CALL	TESTD	;
	JZ	TRK1	;
SEX:			;
	JMP	DMY	;TO OTHER BIOS
			;
TRK1:			;DRIVE SELECTED, CATCH TRACK VALUE
	MOV	A,C	;
	STA	TRACK	;B,C HOLD TRACK
	MOV	A,B	;
	STA	TRACK+1	;
	RET		;
			;
SS:			;SELECT SECTOR
	CALL	TESTD	;
	JZ	STR	;
SSX:			;
	JMP	DMY	;TO OTHER BIOS
			;
STR:			;
	MOV	A,C	;SAVE SECTOR VALUE
	STA	SECTR	;
	MOV	A,B	;
	STA	SECTR+1	;
	RET		;
			;
SA:			;
	MOV	A,B	;
	STA	DMAAD+1	;
	MOV	A,C	;
	STA	DMAAD	;
SAX:			;
	JMP	DMY	;
			;
SR:			;READ
	CALL	TESTD	;
	JZ	REA	;
SRX:			;
	JMP	DMY	;
			;
REA:			;
	CALL	RSETB	;
RGO:			;
	LDAX	B	;
	MOV	M,A	;
	INX	B	;
	INX	H	;
	DCR	D	;
	JNZ	RGO	;MOVE DISC READ TO BUFFER AREA
			;
ROUT:			;
	MVI	A,0	;
	RET		;RETURN WITH GOOD READ
			;
SW:			;WRITE
	CALL	TESTD	;
	JZ	WRIT	;
SWX:			;
	JMP	DMY	;TO OTHER BIOS
			;
WRIT:			;
	CALL	RSETB	;
WGO:			;
	MOV	A,M	;
	STAX	B	;
	INX	B	;
	INX	H	;
	DCR	D	;
	JNZ	WGO	;
	CALL	WRITE	;
	MVI	A,0	;GOOD WRITE
	RET		;
			;
ST:			;
	CALL	TESTD	;
	JZ	HDXL	;
STX:			;
	JMP	DMY	;TO OTHER BIOS
			;
HDXL:			;TRANSLATE SECTOR FOR HARD DISC
	MOV	H,B	;
	MOV	L,C	;SAME SECTOR (NO TRANSLATE)
	RET		;
RSETB:			;
	CALL	READ	;
	LDA	SECTR	;
	MVI	D,128	;
	LHLD	DMAAD	;
	ANI	01	;
	JZ	RLOW	;
	LXI	B,BUFFER+080H	;
	RET		;
RLOW:			;
	LXI	B,BUFFER	;
	RET			;
			;
			;
;****************************************************
;*                                                  *
;*  THE CODE ABOVE THIS POINT IS HOUSEKEEPING CODE  *
;*  TO LINK THE FLOPPY DISC BIOS AND TO OBTAIN THE  *
;*  VALUES OF TRACK, SECTOR, DMAADR, DRIVE #, AND   *
;*  READ OR WRITE REQUESTS FROM CP/M                *
;*                                                  *
;*  THE CODE BELOW THIS POINT MUST BE CHANGED FOR   *
;*  ANY CHANGE IN THE HARDWARE CONTROLLER/ DRIVE    *
;*  CONFIGURATION                                   *
;*                                                  *
;****************************************************
UPTASK:			;SET UP TASK REGISTERS
			;
	MVI	A,TRK/2	;
	OUT	WPC	;
	MVI	A,SCTR	;32 SECTORS FOR ALL COMMANDS
	OUT	SECNT	;
	LDA	SECTR	;
	STA	NOWSTR	;SAVE CURRENT SECTOR
	RAR		;LOW BIT SELECTS U/L BLOCK OF 128
	ANI	01FH	;LOW 5 BITS ARE SECTOR NUMBER
	OUT	SECNO	;
	LDA	TRACK	;TRACK IS CYLINDER
	STA	NOWTRK	;SAVE LSB OF CURRENT TRACK
	OUT	CYLLO	;
	LDA	TRACK+1	;
	STA	NOWTRK+1	;SAVE MSB OF CURRENT TRACK
	OUT	CYLHI	;
	LDA	SECTR+1	;GET HEAD SELECT BITS
	RAR
	LDA	SECTR	;INTO 3 LSB'S
	RAL
	RAL
	RAL
	ANI	HDMSK	;STRIP OFF  EXTRA BITS
	MOV	B,A	;
	LDA	DRIVE	;
	STA	NOWDR	;SAVE CURRENT DRIVE
;
	SUI	2
;
	IF	ST412 OR ST419
	ANI	0FEH	;SPECIAL MOD MAKES PHYSICAL INTO 2 LOGICALS
	ENDIF
;
	IF	RMS526
	CPI	5
	JC	DV234
	MVI	A,8
	JMP	ADDHD
DV234:	MVI	A,0
	JMP	ADDHD
	ENDIF

	SUI	2	;
	RAL		;
	RAL		;
	IF	ST406 OR ST506
	RAL
	ENDIF
	ANI	018H	;
ADDHD:	ORA	B	;

	ORI	80H	;SET ECC ENABLE 

	OUT	SDH	;SECTOR SIZE 256, DRIVE 0, HEAD ABOVE
	RET		;DONE WITH REGISTERS
			;
READ:			;
			;
			;TEST FOR PREREAD SECTOR
	LHLD	NOWSTR	;
	MOV	A,L	;
	ANI	0FEH	;
	MOV	L,A	;
	LDA	SECTR	;
	ANI	0FEH	;
	CMP	L	;
	JNZ	READ1	;
	LDA	SECTR+1	;
	CMP	H	;
	JNZ	READ1	;
	LHLD	NOWTRK	;
	LDA	TRACK	;
	CMP	L	;
	JNZ	READ1	;
	LDA	TRACK+1	;
	CMP	H	;
	JNZ	READ1	;
	LDA	NOWDR	;
	MOV	L,A	;
	LDA	DRIVE	;
	CMP	L	;
	JNZ	READ1	;
			;
	RET		;WE ARE AT SAME DRIVE,TRACK,PHYSICAL SECTOR
			;SO DONT TO PHYSICAL READ
			;
READ1:			;
	CALL	UPTASK	;SET UP FOR READ
	MVI	A,CREAD	;
	OUT	COMND	;READ SECTOR
			;
RWAIT:			;
	CALL	WLO2	;
	MVI	B,0	;COUNT TO 256
	LXI	H,BUFFER	;MOVE TO
			;
READLP:			;
	IN	DATA	;GET BYTE
	MOV	M,A	;SAVE IT
	INX	H	;
	INR	B	;
	JNZ	READLP	;DONE YET?
	IN	STATUS	;
	ANI	01	;
	JNZ	ERRRPT	;REPORT AN ERROR
	RET		;
			;
WRITE:			;
	CALL	UPTASK	;SET UP POINTERS
	MVI	A,CWRITE	;
	OUT	COMND	;
	MVI	B,0	;SENT A COMMAND, SET UP FOR TRANSFER
	LXI	H,BUFFER	;LOAD MOVE ADDRESS
			;
WRITLP:			;WRITE LOOP
	MOV	A,M	;
	OUT	DATA	;
	INX	H	;NEXT BYTE
	INR	B	;COUNT ONE
	JNZ	WRITLP	;
			;
WWAIT:			;
	CALL	WLO2	;
	IN	STATUS	;
	ANI	01	;
	JNZ	ERRRPT	;
	RET		;
			;
REST:			;
	MVI	A,CREST+SRATE	;RESTORE COMMAND
	OUT	COMND	;
RES1:			;
WLO2:			;WAIT LOOP
	IN	STATUS	;
	ANI	080H	;
	JNZ	RES1	;
	RET		;
			;
ERRRPT:			;ERROR REPORTING
	IN	ERROR	;
	ANI	0FFH	;
	RZ		;
	CALL	MOUT	;
	RET		;
			;
MOUT:			;
	MVI	C,48	;
	CALL	CONOUT
	RET		;
TESTD:			;
	LDA	DRIVE	;
	CPI	HDNUM	;
	RZ		;
	IF	HD2
	CPI	HDNUM2	;
	RZ		;
	ENDIF
	IF	HD3
	CPI	HDNUM3	;
	RZ		;
	ENDIF
	IF	HD4	;
	CPI	HDNUM4	;
	RZ		;
	ENDIF		;
	RET		;
			;
			;
			;
TRACK:	DW	0	;
SECTR:	DW	0	;
DMAAD:	DW	0	;
DRIVE:	DB	0	;
NOWDR:	DB	0	;
NOWTRK:	DW	0	;
NOWSTR:	DW	0	;
BUFFER:	DS	256	;
HDTBL:			;
HDTBL1:			;
	DW	0	;TRANSLATE TABLE
	DW	0	;SCRATCH
	DW	0	;
	DW	0	;
	DW	DIRBUF	;DIRECTORY BUFFER AREA
	DW	DPB	;
	DW	CSV1	;
	DW	ALV1	;DPB IT IN TABLE BELOW, CSV AND ALV ARE AREAS
			;
HDTBL2:			;
	DW	0	;
	DW	0	;
	DW	0	;
	DW	0	;
	DW	DIRBUF	;
	DW	DPB1	;
	DW	CSV2	;
	DW	ALV2	;

			;
	IF	HD3
HDTBL3:			;
	DW	0	;
	DW	0	;
	DW	0	;
	DW	0	;
	DW	DIRBUF	;
	DW	DPBX
	DW	CSV3	;
	DW	ALV3	;
	ENDIF
			;
	IF	HD4
HDTBL4:			;
	DW	0	;
	DW	0	;
	DW	0	;
	DW	0	;
	DW	DIRBUF	;
	DW	DPB1	;
	DW	CSV4	;
	DW	ALV4	;
	ENDIF
			;
			;
			;
DPB:			;
	DW	SPT	;SPT (SECTORS PER TRACK)
	DB	6	;BSH
	DB	63	;BLM (8 K BLOCKS)
	DB	3	;EXM
	DW	DSM	;DSM (#8 K BLOCKS -1)
	DW	511	;DRM
	DB	192	;AL0
	DB	0	;AL1
	DW	0	;CKS
	DW	0	;OFF
			;
DPB1:			;
	DW	SPT
	DB	6	;
	DB	63	;
	DB	3	;
	DW	DSM	;
	DW	511	;
	DB	192	;
	DB	0	;
	DW	0	;
	DW	RSTRKS
			;
DPBX:			;
	DW	SPT
	DB	6	;
	DB	63	;
	DB	3	;
	DW	DSM	;
	DW	511	;
	DB	192	;
	DB	0	;
	DW	0	;

	IF	ST412 OR ST419
	DW	0
	ENDIF

	IF	RMS526
	DW	RSTKS2
	ENDIF

			;
CSV1:			;
	DW	0	;
ALV1:			;
	DS	ALSIZE	;
	IF	HD2
CSV2:			;
	DW	0	;
ALV2:			;
	DS	ALSIZE	;
	ENDIF
	IF	HD3
CSV3:			;
	DW	0	;
ALV3:			;
	DS	ALSIZE	;
	ENDIF
	IF	HD4
CSV4:			;
	DW	0	;
ALV4:			;
	DS	ALSIZE	;
	ENDIF
VAREND	EQU	$
	END		;
