;
;NORTHSTAR TO VERSAFLOPPY FILE TRANSFER PROGRAM
;DEBUGGED AND ENHANCED BY ROD HART WA3MEZ
;	AUGUST 14, 1980
;
; TO USE, BRING UP THE NORTH STAR CP/M AS A 16K SYSTEM
; AND THE VERSAFLOPPY AS A 48K SYSTEM. BE SURE TO BOOT
; UP THE VERSAFLOPPY FIRST AND USE DDT TO BOOT UP THE
; NORTH STAR SYSTEM.

; THESE EQUATES ARE USED BY THIS PROGRAM

VT	EQU	0BH		;VDM-1 CLEAR SCREEN
BDOS	EQU	5
REBDOS	EQU	0AC06H		;48K VERSAFLOPPY BDOS VECTOR
SEBDOS	EQU	00005H		;16K N* BDOS VECTOR
DEFFCB EQU	5CH		;DEFAULT FILE CONTROL BLOCK
OPEN	EQU	15
SETBUF	EQU	26
DELETE	EQU	19
MAKE	EQU	22
READ	EQU	20
WRITE	EQU	21
CLOSE	EQU	16
PRINT	EQU	9
FCBCR	EQU	DEFFCB+32
WBOOT	EQU	0



	ORG	100H
	LXI	D,MSG5
	MVI	C,PRINT
	CALL	BDOS
START	LXI	H,0
	DAD	SP
	SHLD	OLDSP
	LXI	SP,STACK
	MVI	B,0FH
	LXI	D,6CH
	LXI	H,NFCB
LOOP1	LDAX	D
	MOV	M,A
	INX	H
	INX	D
	DCR	B
	JNZ	LOOP1
	LXI	D,DEFFCB
	MVI	C,OPEN
	CALL	SEBDOS
	CPI	255
	JNZ	OPNOK
	CALL	ERROR
	DB	'FILE NOT FOUND ON THE NORTH STAR DISK.$'
OPNOK	LXI	D,MSG1
	MVI	C,PRINT
	CALL	BDOS
	XRA	A
	STA	FCBCR
	STA	NFCB+32
	LXI	D,NFCB
	MVI	C,DELETE
	CALL	REBDOS
	LXI	D,NFCB
	MVI	C,MAKE
	CALL	REBDOS
	JP	OKOPN
	CALL	ERROR
	DB	'CANNOT CREATE THE FILE ON THE VERSAFLOPPY DISK$'
OKOPN	LXI	D,MSG2
	MVI	C,PRINT
	CALL	BDOS
	CALL	READIT
	CPI	0
	JZ	HERE
	CPI	1
	JZ	DONE
	CALL	ERROR
	DB	'THERE WAS AN ERROR IN THE CALL TO BDOS.$'
HERE	LXI	D,MSG3
	MVI	C,PRINT
	CALL	BDOS
	CALL	WRITIT
	CPI	2
	JNZ	OKOPN
	CALL	ERROR
	DB	'THE DISK IS FULL, CANNOT WRITE ANY MORE TO IT.$'
READIT	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,SETBUF
	LXI	D,0080H
	CALL	SEBDOS
	MVI	C,READ
	LXI	D,DEFFCB
	CALL	SEBDOS
	POP	H
	POP	D
	POP	B
	RET
WRITIT	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,SETBUF
	LXI	D,0080H
	CALL	REBDOS
	MVI	C,WRITE
	LXI	D,NFCB
	CALL	REBDOS
	POP	H
	POP	D
	POP	B
	RET
DONE	LXI	D,MSG4
	MVI	C,PRINT
	CALL	BDOS
	MVI	C,CLOSE
	LXI	D,NFCB
	CALL	REBDOS
	JMP	WBOOT
ERROR	POP	D
	MVI	C,PRINT
	CALL	BDOS
	JMP	WBOOT
NFCB	DS	35
OLDSP	DS	2
MSG1	DB	'THE OPENING OF FILES WAS OK'
	DB	0AH,0DH,'$'
MSG2	DB	'READING A SECTOR FROM NORTH STAR DISK'
	DB	0AH,0DH,'$'
MSG3	DB	'WRITING A SECTOR TO VERSAFLOPPY DISK'
	DB	0AH,0DH,'$'
MSG4	DB	'CLOSING THE FILES NOW'
	DB	0AH,0DH,'$'
MSG5	DB	VT,0AH,0DH,'16K NORTH STAR TO 48K VERSAFLOPPY CP/M TRANSFER PROGRAM'
	DB	0AH,0DH,'$'
STACK	EQU	$+100
	END
