; DIV16B - DIVIDE 16 BIT NUMBER IN HL BY 8 BIT NUMBER IN C
;	   QUOTIENT RETURNED IN HL, REMAINDER IN A
; BY BRUCE R. RATOFF 12/11/80
;
; THIS IS A 16/8 DIVIDE WITH A DIFFERENCE IN THAT MOST TEXTBOOK
; EXAMPLES OF 16/8-BIT DIVISION WILL FAIL WHEN THE QUOTIENT EXCEEDS
; 8 BITS.  HERE THE PROBLEM IS CIRCUMVENTED BY USING THE ACCUMULATOR
; AS A HIGH ORDER EXTENSION OF THE DIVIDEND.
;
;
DIV16B:
	SUB	A		; CLEAR THIRD ORDER DIVIDEND
	MVI	B,16		; INITIALIZE 16 BIT SHIFT COUNT
DLUP:
	DAD	H		; SHIFT DIVIDEND LEFT
	ADC	A		; HIGH BIT SHIFTS INTO ACC
	SUB	C		; SUBTRACT DIVISOR
	INX	H		; SET LOW QUOTIENT BIT
	JNC	SOK		; SKIP AHEAD IF SUBTRACT SUCCEEDED
	ADD	C		; ELSE REVERSE SUBTRACTION
	DCX	H		; AND CLEAR LOW QUOTIENT BIT
SOK:
	DCR	B		; COUNT DOWN 16 BITS
	JNZ	DLUP		; LOOP IF MORE
	RET			; ALL DONE
;
