*  PROGRAM NAME:  BDOS Locator
*  AUTHOR:  RICHARD CONN
*  VERSION:  1.0
*  DATE:  3 July 81
*  PREVIOUS VERSIONS:  -None-

VERS		EQU	10	; VERSION NUMBER
CPM$BASE	EQU	0	; BASE ADDRESS OF CP/M SYSTEM

*
*	BDOS Locator simply functions to print out the base page address
* of the user's CP/M BDOS and the base page address of the user's CP/M CCP.
*

BDOS	EQU	CPM$BASE+5	; ADDRESS OF BDOS ENTRY
CR	EQU	0DH
LF	EQU	0AH

	ORG	CPM$BASE+100H

	CALL	PRINT
	DB	'The Base Page Address of this system''s BDOS is ',0
	LDA	BDOS+2	; GET PAGE ADDRESS
	CALL	HEX$OUT	; PRINT AS 2 HEX CHARS

	CALL	PRINT
	DB	CR,LF,'The Base Page Address of this system''s CCP is  ',0
	LDA	BDOS+2	; GET BDOS ADDRESS
	SUI	8	; 800H LESS
	CALL	HEX$OUT	; PRINT AS 2 HEX CHARS

	CALL	PRINT
	DB	CR,LF,0
	RET

*  PRINT VALUE IN REG A AS 2 HEX CHARS
HEX$OUT:
	PUSH	PSW	; SAVE VALUE
	RLC		; SHIFT NYBBLES
	RLC
	RLC
	RLC
	CALL	HEX1	; PRINT HIGH NYBBLE
	POP	PSW	; GET VALUE AND PRINT LOW NYBBLE

*  PRINT LOW NYBBLE OF REG A AS 1 HEX CHAR
HEX1:
	ANI	0FH	; MASK OUT HIGH
	CPI	10	; 0-9?
	JNC	HEX1A
	ADI	'0'	; CONVERT 0-9 TO '0'-'9'
	JMP	COUT
HEX1A:
	ADI	'A'-10	; CONVERT 10-15 TO 'A'-'F'
	JMP	COUT

*  PRINT STRING ENDING IN 0 PTED TO BY RET ADR
PRINT:
	XTHL		; SAVE HL AND GET RET ADR
PRINT1:
	MOV	A,M	; GET BYTE
	INX	H	; PT TO NEXT
	ORA	A	; DONE?
	JZ	PRINT2
	CALL	COUT	; PRINT IT
	JMP	PRINT1
PRINT2:
	XTHL		; RESTORE RET ADR AND HL
	RET

*  PRINT CHAR IN REG A ON CONSOLE
COUT:
	PUSH	H	; SAVE REGS
	PUSH	D
	PUSH	B
	MOV	E,A
	MVI	C,2	; CONSOLE OUTPUT
	CALL	BDOS
	POP	B	; RESTORE REGS
	POP	D
	POP	H
	RET

	END
