;
	TITLE	'LINKASM AS OF 11/1/82'
;************************************************
; Copyright (c) Pete Mack
;		Mack Associates
;		1660 Olympic Street
;		Simi Valley, Ca. 93063
;************************************************
; rev 8/11/83 Initial release
;
;************************************************
;
	ORG	0100H
CPM	EQU	00H
BDOS	EQU	05H
L0006	EQU	06H
TFCB	EQU	5CH
L0064	EQU	64H
FCB2	EQU	6CH
TBUFF	EQU	80H
LC013	EQU	0C013H
LC217	EQU	0C217H
;
; BDOS EQUATES
;
RDCON	EQU	1
WRCON	EQU	2
PRINT	EQU	9
CSTAT	EQU	11
SELDSK	EQU	14
OPEN	EQU	15
CLOSE	EQU	16
SRCHF	EQU	17
SRCHN	EQU	18
DELETE	EQU	19
READ	EQU	20
WRITE	EQU	21
MAKE	EQU	22
RTCUDSK	EQU	25
STDMA	EQU	26
;
; GENERAL EQUATES
;
CR	EQU	0DH
LF	EQU	0AH
TAB	EQU	09H
;
	LXI	SP,IBUFR
	JMP	START
LIN$PAG$CT:
	DB	55
STITLE:
	DB	'LASM NOV-82     ',0
PAGE$BUF:
	DB	'PAGE  000   '
TIT$BUF:
	DB	'                              ',CR
PAS$MSG:
	DB	'PASS 1',CR
;
; CHARACTER TYPE
; 1 = ALPHA
; 2 = NUMBER
; 3 = QUOTE "
; 4 = OTHER
;
PRN$CHR$CT:
	DB	0
STR$TYPE:
	DB	0
STR$VAL:
	DW	0
STR$SIZE:
	DB	0
STRING:
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0
L0161:
	DW	0
SYMTAB$PTR:
	DW	SYM$TABLE
XREF$PTR:
	DW	0
PASS$NM:
	DB	0
LOC$CTR1:
	DW	0
LOC$CTR2:
	DW	0
SYM$TAB$BASE:
	DW	SYM$TABLE
SYM$HASH$PTR:
	DW	0
OBJ$LINE$LOC:	
	DW	0
OBJ$BYTE$CNT:	
	DB	0
OBJ$LINE:	
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0
DFALDRV:
	DB	0
OPTSRC:	
	DB	0
OPTPRN:	
	DB	0
OPTOBJ:	
	DB	0
SRCFCB:	
	DB	0
SRCNAME:
	DB	0,0,0,0,0,0,0,0,'ASM'
SRC$EXT:	
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
SRC$CR:	
	DB	0
PRNFCB:	
	DB	0,0,0,0,0,0,0,0,0
	DB	'PRN'
L01B2:				
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
L01C6:
	DB	0
OBJFCB:
	DB	0,0,0,0,0,0,0,0,0,'HEX',0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
IBUF$CTR:
	DW	1000H
PRN$BUF$PTR: 
	DW	0
OBJ$BUF$PTR: 
	DW	0
FLAG$BYT:
	DB	0

XREFF	EQU	1
SYMF	EQU	2

SEL$DRV: 
	LXI	H,DFALDRV
	CMP	M
	RZ
	MOV	M,A
	MOV	E,A
	MVI	C,SELDSK
	CALL	BDOS
	RET
OPT$TRAN: 
	INX	H
	MOV	A,M
	CPI	' '
	JZ	L0205
	SBI	'A'
	RET
L0205: 
	LDA	DFALDRV
	RET
MSGOUT: 
	MOV	A,M
	CALL	CO
	MOV	A,M
	INX	H
	ORA	A
	JZ	MSG$01
	CPI	CR
	JNZ	MSGOUT
MSG$00:	MVI	A,LF
	CALL	CO
	RET
MSG$01: MVI	A,CR
	CALL	CO
	JMP	MSG$00

MOVNAM: 
	LXI	D,TFCB
	MVI	B,9
L021F: 
	LDAX	D
	CPI	'?'
	JZ	ER04		;'SOURCE NAME ERROR'
	MOV	M,A
	INX	H
	INX	D
	DCR	B
	JNZ	L021F
	RET
OPENFIL: 
	MVI	C,OPEN
	CALL	BDOS
	CPI	0FFH
	RNZ
	LXI	H,ERMSG1
	CALL	MSGOUT
	JMP	CPM
CLOSFIL: 
	MVI	C,CLOSE
	CALL	BDOS
	CPI	0FFH
	RNZ
	LXI	H,CANT$CLOS$M
	CALL	MSGOUT
	JMP	CPM
DEL$FIL: 
	MVI	C,DELETE
	JMP	BDOS
MAKEFIL: 
	MVI	C,MAKE
	CALL	BDOS
	CPI	0FFH
	RNZ
	LXI	H,ERMSG3
	CALL	MSGOUT
	JMP	CPM
SEL$SRC$DRV: 
	LDA	OPTSRC
	CALL	SEL$DRV
	RET
L026C: 
	LDA	OPTPRN
	CPI	'Z'-'A'		;NO FILE OPTION
	RZ
	CPI	'X'-'A'		;LIST AT CONSOL OPT
	RET
SEL$PRN: 
	LDA	OPTPRN
	CALL	SEL$DRV
	RET
SEL$OBJ: 
	LDA	OPTOBJ
	CALL	SEL$DRV
	RET
START: 
	LXI	H,STITLE
	CALL	MSGOUT		;WRITE ASM VERSION TO CONS.
	LDA	TFCB+1
	CPI	' '		;FILENAME THERE?
	JZ	ER04		;NO, SOURCE NAME ERROR
	MVI	C,RTCUDSK
	CALL	BDOS
	STA	DFALDRV		;SAVE DEFAULT DRIVE OPTION
	LXI	H,L0064		;POINT TO SOURCE DRIVE OPTION
	CALL	OPT$TRAN	;TRANSLATE SOURCE OPTION
	STA	OPTSRC		;SAVE SOURCE OPTION
	CALL	OPT$TRAN	;TRANSLATE OBJECT OPTION
	STA	OPTOBJ		;SAVE OBJECT OPTION
	CALL	OPT$TRAN	;TRANSLATE PRINT OPTION
	STA	OPTPRN		;SAVE PRINT OPTION
	LXI	H,SRCFCB
	CALL	MOVNAM		;SET UP SOURCE FCB
	LXI	H,PRNFCB
	CALL	MOVNAM		;SET UP PRN FCB
	CALL	L026C
	JZ	L02D5		;BR IF NO PRN FILE OPTION
	CALL	SEL$PRN		;SELECT PRN FILE DISK
	LXI	D,PRNFCB	;POINT TO FCB
	CALL	DEL$FIL		;DELETE OLD PRN FILE
	LXI	D,PRNFCB
	CALL	MAKEFIL		;OPEN NEW PRN FILE.
L02D5: 
	LDA	OPTOBJ
	CPI	'Z'-'A'
	JZ	MAIN		;BR IF NO FILE OPTION
	LXI	H,OBJFCB
	PUSH	H
	PUSH	H
	CALL	MOVNAM
	CALL	SEL$OBJ		;SELECT OBJ DISK
	POP	D
	CALL	DEL$FIL		;KILL OLD OBJECT
	POP	D
	CALL	MAKEFIL		;OPEN NEW OBJECT
	JMP	MAIN		;JUMP TO PASS 1.
RESET$SRC: 
	LXI	H,01000H	;RESET IBUF POINTER
	SHLD	IBUF$CTR
	XRA	A
	STA	SRC$EXT		;RESET EXTENT
	STA	SRC$CR		;RESET CURRENT RECORD #
	CALL	SEL$SRC$DRV	;SELECT DRIVE
	LXI	D,SRCFCB
	CALL	OPENFIL		;OPEN FILE
	RET
ER04:				; SOURCE NAME ERROR
	LXI	H,ERMSG4
	CALL	MSGOUT
	JMP	CPM
CMP$LIM: 
	MOV	A,D
	CMP	H
	RNZ
	MOV	A,E
	CMP	L
	RET

***************************************
* GET INPUT CHARACTER FROM DISK
***************************************

DSK$IN: 
	PUSH	B
	PUSH	D
	PUSH	H
	LHLD	IBUF$CTR	;HAVE WE FINISHED THIS BUFFER
	LXI	D,01000H
	CALL	CMP$LIM
	JNZ	DSK$IN$05	;BR IF NOT.
	CALL	SEL$SRC$DRV	;YES, SELECT DSK
	LXI	H,00H
	SHLD	IBUF$CTR
	MVI	B,32		;RESET BUF PTR (32 SECTORS)
	LXI	H,IBUFR
DSK$IN$01: 
	PUSH	B
	PUSH	H
	MVI	C,READ
	LXI	D,SRCFCB	;READ A SECTOR
	CALL	BDOS
	POP	H
	POP	B
	ORA	A
	MVI	C,80H
	JNZ	DSK$IN$03	;BR IF EOF
	LXI	D,TBUFF
	MVI	C,80H		;SET CHAR COUNT
DSK$IN$02: 
	LDAX	D		;MOVE DATA FROM TBUFF TO IBUFR
	MOV	M,A
	INX	D
	INX	H
	DCR	C		;DECR CHAR CTR
	JNZ	DSK$IN$02
	DCR	B		;DECR SECTOR CTR
	JNZ	DSK$IN$01
	JMP	DSK$IN$05
DSK$IN$03: 
	CPI	3		; ETX CHAR?
	JNC	ER05
DSK$IN$04: 
	MVI	M,1AH		;WRITE ^Z EOFS FILL SECTOR
	INX	H
	DCR	C
	JNZ	DSK$IN$04
DSK$IN$05: 
	LXI	D,IBUFR
	LHLD	IBUF$CTR
	PUSH	H
	INX	H
	SHLD	IBUF$CTR
	POP	H
	DAD	D
	MOV	A,M		;THIS IS THE CHARACTER.....
	PUSH	PSW
	CPI	LF		; IS IT A LF?
	CZ	INC$LINE$NM	;YES, INCR LINE NUMBER.
	POP	PSW
	POP	H
	POP	D
	POP	B
	RET
ER05: 
	LXI	H,ERMSG5	;SOURCE FILE READ ERROR
	CALL	MSGOUT
	JMP	CPM

***************************************
* PRINT 
* The following routines handle the listing
* operations.
***************************************

PRINT$00: 
	PUSH	B
	MOV	B,A
	LDA	OPTPRN
	CPI	'Z'-'A'		;NO FILE OPTION
	JZ	PRINT$03
	CPI	'X'-'A'		;LIST AT CONSOL OPT
	MOV	A,B
	JNZ	PRINT$02
	CALL	CO
	JMP	PRINT$03
PRINT$01: 
	PUSH	B
PRINT$02: 
	PUSH	D
	PUSH	H
	CALL	PRINT$04
	POP	H
	POP	D
PRINT$03: 
	POP	B
	RET
PRINT$04: 
	LHLD	PRN$BUF$PTR
	XCHG
	LXI	H,PRN$BUFR
	DAD	D
	MOV	M,A
	XCHG
	INX	H
	SHLD	PRN$BUF$PTR
	XCHG
	LXI	H,0400H
	CALL	CMP$LIM
	RNZ
	CALL	SEL$PRN
	LXI	H,00H
	SHLD	PRN$BUF$PTR
	LXI	H,PRN$BUFR
	LXI	D,PRNFCB
	MVI	B,8
PRINT$05: 
	MOV	A,M
	CPI	1AH
	RZ
	PUSH	B
	PUSH	D
	MVI	C,80H
	LXI	D,TBUFF
PRINT$06: 
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	PRINT$06
	POP	D
	PUSH	D
	PUSH	H
	MVI	C,WRITE
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	ORA	A
	JNZ	OUT$FIL$ERR
	DCR	B
	RZ
	JMP	PRINT$05
OUT$FIL$ERR: 
	LXI	H,ERMSG6
	CALL	MSGOUT
	JMP	CLOSE$04

***************************************
* OBJECT OUT
***************************************

OBJ$OUT$00: 
	PUSH	B
	PUSH	D
	PUSH	H
	CALL	OBJ$OUT$02
	POP	H
	POP	D
	POP	B
	RET
OBJ$OUT$02: 
	LHLD	OBJ$BUF$PTR
	XCHG
	LXI	H,OBJ$BUFR
	DAD	D
	MOV	M,A
	XCHG
	INX	H
	SHLD	OBJ$BUF$PTR
	XCHG
	LXI	H,0400H
	CALL	CMP$LIM
	RNZ
	CALL	SEL$OBJ
	LXI	H,00H
	SHLD	OBJ$BUF$PTR
	LXI	H,OBJ$BUFR
	LXI	D,OBJFCB
	MVI	B,8
	JMP	PRINT$05

***************************************
* CONSOL OUT
***************************************

CO: 
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,WRCON
	MOV	E,A
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET

***************************************
* SEND PRN CHARACTER TO LIST DEVICE
***************************************

PRN$CHR: 
	MOV	C,A
	CALL	PRINT$00
	LDA	PRN$LINE
	CPI	' '
	RZ
	LDA	OPTPRN
	CPI	'X'-'A'		;LIST AT CONSOLE OPT
	RZ
	MOV	A,C
	CALL	CO
	RET

***************************************
* PRINT MESSAGE TO LIST DEVICE
***************************************

PRN$MSG$00: 
	LDA	PRN$CHR$CT
	LXI	H,PRN$LINE
PRN$MSG$01: 
	ORA	A
	JZ	PRN$MSG$02	;IF CTR 0, OUTPUT CRLF
	MOV	B,A
	PUSH	B
	MVI	B,8		;OUTPUT LINE NUMBER
	LXI	H,LINE$NUM
PRN$MSG$01A:
	MOV	A,M
	CALL	PRN$CHR
	INX	H
	DCR	B
	JNZ	PRN$MSG$01A
	LXI	H,PRN$LINE
	POP	B
PRN$MSG$01B:
	MOV	A,M		; ELSE OUTPUT MSG CHAR.
	CALL	PRN$CHR
	INX	H
	DCR	B
	JNZ	PRN$MSG$01B
	XRA	A
PRN$MSG$02: 
	STA	PRN$CHR$CT
	CALL	HEADER		;PRINT HEADER IF REQ.
	LXI	H,PRN$LINE
	MVI	A,78H
PRN$MSG$03: 
	MVI	M,' '		;NOW SETUP BLANK LINE.
	INX	H
	DCR	A
	JNZ	PRN$MSG$03
	RET
ERR$COD: 
	MOV	B,A
	LXI	H,PRN$LINE
	MOV	A,M
	CPI	' '
	RNZ
	MOV	M,B
	RET

***************************************
* HEADER OUTPUT
***************************************
HEADER:
	MVI	A,CR
	CALL	PRN$CHR
	MVI	A,LF		;OUTPUT LINE FEED
	CALL	PRN$CHR
	LDA	PASS$NM
	ORA	A
	RZ
	LXI	H,LIN$PAG$CT	;INCREMENT LINES-PAGE COUNTER
	MOV	A,M
	INR	M
	CPI	55		;LIMIT IS 55 LINES 
	RC
	MVI	M,0		;RESET COUNTER IF OVER
	LXI	H,PAGE$BUF+8
HEADER$00:
	MOV	A,M		;INCREMENT PAGE COUNTER
	ORI	'0'
	INR	A
	MOV	M,A
	CPI	':'
	JC	HEADER$02	;NOW PRINT HEADER
	MVI	M,'0'
	DCX	H
	JMP	HEADER$00
HEADER$01:
	MVI	A,LF		;OUTPUT LINE FEED
	CALL	PRN$CHR
	RET			;EXIT
HEADER$02:
	MVI	A,12		;SEND FORM FEED
	CALL	PRN$CHR
	LXI	H,STITLE	;NOW PRINT HEADER
HEADER$03:
	MOV	A,M		;GET CHAR
	ORA	A		;SKIP IF 0
	JZ	HEADER$04
	PUSH	H
	CALL	PRN$CHR		;OUTPUT CHARACTER
	POP	H
	MOV	A,M
HEADER$04:
	INX	H
	CPI	CR		;WAS THAT A CR.
	JNZ	HEADER$03
	MVI	A,LF
	CALL	PRN$CHR
	JMP	HEADER$01
***************************************
* CLOSING OPERATIONS
***************************************

CLOSE$00: 
	CALL	L026C
	JZ	CLOSE$02
	CALL	SORT$SYM
	CALL	PRN$REFS
CLOSE$01: 
	LHLD	PRN$BUF$PTR	;RUN OUT PRN.
	MOV	A,L
	ORA	H
	JZ	CLOSE$02
	MVI	A,1AH
	CALL	PRINT$00
	JMP	CLOSE$01
CLOSE$02: 
	LDA	OPTOBJ
	CPI	'Z'-'A'		;NO FILE OPTION
	JZ	CLOSE$04
	LDA	OBJ$BYTE$CNT
	ORA	A
	CNZ	OBJ$LINE$00
	LHLD	LOC$CTR1
	SHLD	OBJ$LINE$LOC
	CALL	OBJ$LINE$00
CLOSE$03: 
	LHLD	OBJ$BUF$PTR	;RUN OUT OBJ.
	MOV	A,L
	ORA	H
	JZ	CLOSE$04
	MVI	A,1AH
	CALL	OBJ$OUT$00
	JMP	CLOSE$03
CLOSE$04:			;CLOSE PRN FILE. 
	CALL	L026C
	JZ	CLOSE$05
	CALL	SEL$PRN
	LXI	D,PRNFCB
	CALL	CLOSFIL
CLOSE$05: 
	LDA	OPTOBJ
	CPI	'Z'-'A'		;NO FILE OPTION
	JZ	END$MSG$OUT
	CALL	SEL$OBJ
	LXI	D,OBJFCB
	CALL	CLOSFIL		;CLOSE OBJ FILE.
CLOSE$06:			;PRINT SYMBOL FILE
	LDA	FLAG$BYT
	ANI	SYMF		;SYM FILE?
	JZ	END$MSG$OUT	;BR IF NOT
	LXI	H,PRNFCB+9
	LXI	D,SYM$MSG
	MVI	B,3
	CALL	L021F
	XRA	A
	STA	PRNFCB+12
	STA	PRNFCB+32
	CALL	SEL$PRN
	LXI	D,PRNFCB
	PUSH	D
	CALL	DEL$FIL		;DEL OLD SYM FILE
	POP	D
	CALL	MAKEFIL		;MAKE NEW SYM FILE
	LXI	H,00H
	SHLD	PRN$BUF$PTR
	LXI	H,SYM$MSG
	CALL	MSGOUT
	CALL	L0585
	JMP	END$MSG$OUT

***************************************
* SET UP SYMBOL TABLE FOR PRINTING
* SORT ON FIRST CHAR BY FORMING LINKED
* LIST.
***************************************

SORT$SYM:
	LDA	FLAG$BYT
	ANI	XREFF+SYMF	;NEED SORT?
	RZ 			;RET IF NOT
	MVI	B,'A'
	LXI	D,SYM$LINK$ORG		;INIT LINK POINTER
SORT$S$00: 
	CALL	SORT$S$01
	INR	B
	MOV	A,B
	CPI	'Z'+1
	JNZ	SORT$S$00
	XRA	A		;DONE, CLEAR END LINK.
	STAX	D
	INX	D
	STAX	D
	RET
SORT$S$01: 
	LXI	H,SYM$TAB
SORT$S$02: 
	CALL	SORT$S$03		;TRY FOR MATCH CHAR.
	RC			;LIST PASS DONE
	CZ	SORT$S$04		;FOUND A MATCH
	CALL	SORT$S$06		;BUMP TO NEXT
	JMP	SORT$S$02		;GO AGAIN
SORT$S$03: 
	LDA	SYMTAB$PTR
	SUB	L
	LDA	SYMTAB$PTR+1
	SBB	H
	RC
	MOV	A,M
	ANI	0FH
	MOV	C,A		;SYMBOL SIZE SAVED
	INX	H
	MOV	A,M		;1ST CHAR OF SYMBOL
	SUB	B		;SUBTRACT PASS CHARACTER
	ORA	A
	RET
SORT$S$04: 
	MOV	A,D
	ORA	E
	JZ	SORT$S$05		;DONT UNDERSTAND WHY THIS???
	DCX	H
	MOV	A,L
	STAX	D		;WRITE LINK.
	INX	D
	MOV	A,H
	STAX	D
	INX	H
SORT$S$05: 
	PUSH	H
	CALL	SORT$S$07
	MOV	D,H		;UPDATE LINK POINTER
	MOV	E,L
	POP	H
	RET
SORT$S$06: 
	CALL	SORT$S$07
	INX	H		;SKIP W1,W2 SYM RECORD (POINTER)
	INX	H
	RET
SORT$S$07: 
	MOV	A,B		;SAVE B.
	MVI	B,0
	DAD	B		;ADD SIZE
	MOV	B,A
	INX	H		;AND BUMP TO NEXT RECORD.
	INX	H
	INX	H
	INX	H
	INX	H
	RET

***************************************
* PRINT SYMBOL TABLE
***************************************

L0585: 
	LHLD	SYM$LINK$ORG
	LXI	B,0
L0588: 
	MOV	A,H
	ORA	L
	JZ	CLOS$SYM$PRN		;EXIT IF DONE
	MOV	A,M
	ANI	0FH
	MOV	E,A		;GET SYMBOL SIZE
	MVI	D,0
	INX	H
	PUSH	H
	DAD	D		;ADD SIZE
	INX	H
	MOV	C,M		;GET SYMBOL VALUE
	INX	H
	MOV	A,M
	CALL	PRN$HEX		;PRINT UPPER
	MOV	A,C
	CALL	PRN$HEX		;PRINT LOWER
	CALL	PRN$SPACE		;PRINT SPACE
	POP	H		;RESTORE SYM ADDR
	INR	E		;INCR SIZE
	PUSH	D		;SAVE SIZE
L05A6: 
	MOV	A,M
	CALL	PRINT$01	;PRINT THE SYMBOL
	INX	H
	DCR	E
	JNZ	L05A6
	POP	D		;RESTORE SIZE
	MOV	A,B
	CPI	4
	JNC	PT1		;END LINE
; LESS THAN 5 ITEMS
;
	INR	B
	MVI	A,TAB
	CALL	PRINT$01
	MOV	A,E
	CPI	3
	JNC	PT3
	MVI	A,TAB
	CALL	PRINT$01
PT3:	MOV	A,E
	CPI	11		;IF SYMBOL TOO LARGE,TABOUT.
	JC	PT2
	INR	B
	MVI	A,TAB
	CALL	PRINT$01
;
PT2:	INX	H
	INX	H
	INX	H
	INX	H
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	JMP	L0588
;
PT1:	MVI	B,0
	MVI	A,CR
	CALL	PRINT$01
	MVI	A,LF
	CALL	PRINT$01
	JMP	PT2

***************************************
* PRINT SPACE
***************************************

PRN$SPACE: 
	MVI	A,' '
	JMP	PRINT$01

***************************************
* CLOSE SYMBOL FILE
***************************************

CLOS$SYM$PRN: 
	LHLD	PRN$BUF$PTR
	MOV	A,L
	ORA	H
	JZ	CLOS$SYM$01
	MVI	A,1AH
	CALL	PRINT$00
	JMP	CLOS$SYM$PRN
CLOS$SYM$01: 
	CALL	SEL$PRN
	LXI	D,PRNFCB
	CALL	CLOSFIL
	RET

***************************************
* PRINT TWO HEX CHARACTERS
***************************************

PRN$HEX: 
	PUSH	PSW
	RAR
	RAR
	RAR
	RAR
	CALL	PRN$HEX$01
	POP	PSW
PRN$HEX$01: 
	ANI	0FH
	ADI	90H
	DAA
	ACI	'@'
	DAA
	JMP	PRINT$01

SYM$LINK$ORG: 
	DW	0

***************************************
* PRINT CROSS REFERENCES
***************************************
SYM$LST$PTR:
	DW	0
SYM$LINE:
	DW	0

PRN$REFS:
	LDA	FLAG$BYT
	ANI	XREFF		;XREF?
	RZ			;RET IF NOT
	CALL	HEADER$02	;PRINT HEADER
	LXI	H,XREF$MSG
	CALL	HEADER$03
	LHLD	SYM$LINK$ORG	;INIT LIST POINTER
	SHLD	SYM$LST$PTR
	LXI	H,LIN$PAG$CT
	MVI	A,2
	MOV	M,A
	CALL	HEADER
PREF$00:
	CALL	PREF$10		;GET SYMBOL AND PRINT IT.
	RZ			;NONE FOUND
	CALL	PREF$30		;PRINT XREFS
	CALL	HEADER
	JMP	PREF$00
PREF$01:
	MVI	A,CR
	CALL	PRINT$01
	MVI	A,LF
	CALL	PRINT$01
	RET

***************************************
* SYMBOL PRINT 
***************************************
PREF$10:
	LHLD	SYM$LST$PTR	;LOAD SYMBOL LIST POINTER
	MOV	A,H
	ORA	L
	RZ
	MOV	A,M		;LOAD SIZE
	ANI	0FH
	INR	A
	MOV	B,A
	PUSH	B		;SAVE SIZE
PREF$11:
	INX	H
	MOV	A,M		;PRINT SYMBOL
	CALL	PRINT$01
	DCR	B
	JNZ	PREF$11
	INX	H
	POP	B		;RESTORE SIZE
	MOV	A,B
	CPI	8
	JNC	PREF$12
	MVI	A,TAB
	CALL	PRINT$01	;TAB TO 8TH POSITION
PREF$12:
	MVI	A,TAB
	CALL	PRINT$01	;TAB TO 16TH POSITION
	INX	H		;SKIP VALUE
	INX	H
	MOV	A,M		;OUTPUT LINE #
	MOV	D,A
	CALL	PRN$HEX
	INX	H
	MOV	A,M
	MOV	E,A
	CALL	PRN$HEX
	XCHG
	SHLD	SYM$LINE	;LOAD LINE
	XCHG
	INX	H
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	SHLD	SYM$LST$PTR
	MVI	A,TAB
	CALL	PRINT$01
	XRA	A
	INR	A
	RET

***************************************
* PRINT XREFS
***************************************

PREF$30:
	LHLD	XREF$PTR
	LXI	D,4
	DAD	D
	MVI	B,8		;SET ITEMS PER LINE
PREF$31:
	CALL	PREF$34		;ARE WE DONE
	RC
	CALL	PREF$32		;TRY FOR MATCH
	JNZ	PREF$31		;BR IF NO MATCH
	CALL	PREF$33		;PRINT FOUND REF.
	JMP	PREF$31

PREF$32:
	LDA	SYM$LINE+1
	CMP	M
	JNZ	PREF$320
	INX	H
	LDA	SYM$LINE
	CMP	M
	DCX	H
	RZ
PREF$320:
	INX	H
	INX	H
	INX	H
	INX	H
	RET

***************************************
* PRINT FOUND REFERENCE
***************************************

PREF$33:
	INX	H
	INX	H
	MOV	A,M
	CALL	PRN$HEX
	INX	H
	MOV	A,M
	CALL	PRN$HEX
	INX	H
	MVI	A,TAB
	CALL	PRINT$01
	DCR	B
	RNZ
	MVI	B,8
	CALL	PREF$01
	MVI	A,TAB
	CALL	PRINT$01
	MVI	A,TAB
	CALL	PRINT$01
	MVI	A,TAB
	CALL	PRINT$01
	RET

PREF$34:
	XCHG
	LHLD	L0006
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	XCHG
	RET

***************************************
* MISCELLANEOUS MESSAGES
***************************************

XREF$MSG:
	DB	'CROSS REFERENCED SYMBOL LIST',CR
SYM$MSG: 
	DB	'SYMBOLS',CR
END$MSG$OUT: 
	LXI	H,END$ASSY$MSG
	CALL	MSGOUT
	JMP	CPM
ERMSG1: 
	DB	'No source'
ERMSG2: 
	DB	' file present',CR
ERMSG3:
	DB	'No directory space',CR
ERMSG4:
	DB	'Source file name error'
	DB	CR
ERMSG5:
	DB	'Source file read error'
	DB	CR
ERMSG6:
	DB	'Output file write error'
	DB	CR
CANT$CLOS$M:
	DB	'Cannot close files',CR
END$ASSY$MSG:
	DB	'End of assembly',CR

***************************************
* PUT OBJECT IN OBJECT LINE
***************************************

PUT$OBJ:
	PUSH	B
	MOV	B,A
	LDA	OPTOBJ		;LOAD OBJECT FILE OPTION
	CPI	'Z'-'A'		;NO FILE OPTION
	MOV	A,B
	JZ	PUT$OBJ$EX	;NO OPTION,-EXIT.
	PUSH	D
	PUSH	PSW
	LXI	H,OBJ$BYTE$CNT	;GET OBJECT BYTE COUNT
	MOV	A,M
	ORA	A
	JZ	PUT$OBJ$03
	CPI	16		;MAX IS 16 BYTES PER LINE
	JC	PUT$OBJ$01
	CALL	OBJ$LINE$00	;OUTPUT LINE TO BUFFER
	JMP	PUT$OBJ$03	;NOW PUT NEW CHARACTER IN
PUT$OBJ$01:
	LHLD	LOC$CTR1
	XCHG
	LHLD	OBJ$LINE$LOC
	MOV	C,A		;PUT OFFSET IN C.
	MVI	B,0
	DAD	B		;ADD OFFSET TO LINE ORG.
	MOV	A,E		;NOW COMPARE LOC COUNTER.
	CMP	L
	JNZ	PUT$OBJ$02	;IF DIFFERENT, OUTPUT LINE.
	MOV	A,D
	CMP	H
	JZ	PUT$OBJ$04
PUT$OBJ$02:
	CALL	OBJ$LINE$00	;OUTPUT LINE TO BUFR
PUT$OBJ$03:
	LHLD	LOC$CTR1	;UPDATE LINE LOCATION
	SHLD	OBJ$LINE$LOC
PUT$OBJ$04:
	LXI	H,OBJ$BYTE$CNT	;GET OFFSET
	MOV	E,M
	INR	M
	MVI	D,0
	LXI	H,OBJ$LINE	;ADD TO LINE ORG.
	DAD	D
	POP	PSW
	MOV	M,A			;PUT BYTE IN LINE
	POP	D
PUT$OBJ$EX:
	POP	B
	RET

***************************************
* OBJECT BYTE OUTPUT
* ADDS CHECKSUM IN REG D
***************************************

OBJ$BYTE$OUT: 
	PUSH	PSW
	RRC				; OUTPUT UPPER NIBBLE
	RRC
	RRC
	RRC
	ANI	0FH
	CALL	OBJ$ASCII$OUT
	POP	PSW
	PUSH	PSW
	ANI	0FH
	CALL	OBJ$ASCII$OUT		;OUTPUT LOWER NIBBLE
	POP	PSW
	ADD	D
	MOV	D,A
	RET

***************************************
* HEX TO ASCII CONVERSION 
* WITH OUTPUT TO OBJ.
***************************************

OBJ$ASCII$OUT: 
	ADI	90H
	DAA
	ACI	'@'		;40H
	DAA
	JMP	OBJ$OUT$00

***************************************
* OUTPUT OBJECT LINE
* OUTPUTS TO OBJ$BUFR
***************************************

OBJ$LINE$00:
	MVI	A,':'
	CALL	OBJ$OUT$00		;START NEW LINE
	LXI	H,OBJ$BYTE$CNT
	MOV	E,M
	XRA	A
	MOV	D,A
	MOV	M,A
	LHLD	OBJ$LINE$LOC		;SET LINE LOCATION
	MOV	A,E
	CALL	OBJ$BYTE$OUT		;WRITE BYTE COUNT
	MOV	A,H
	CALL	OBJ$BYTE$OUT		;WRITE LOCATION
	MOV	A,L
	CALL	OBJ$BYTE$OUT		;WRITE LOCATION
	XRA	A
	CALL	OBJ$BYTE$OUT
	MOV	A,E			;GET COUNT
	ORA	A
	JZ	OBJ$LINE$03		;EXIT IF ZERO
	LXI	H,OBJ$LINE		;POINT TO LINE DATA
OBJ$LINE$01:
	MOV	A,M
	INX	H
	CALL	OBJ$BYTE$OUT		;OUTPUT A BYTE
	DCR	E			;DECR BYTE COUNT
	JNZ	OBJ$LINE$01		;DO ANOTHER IF NOT DONE.
OBJ$LINE$03:				;DONE 
	XRA	A
	SUB	D
	CALL	OBJ$BYTE$OUT
	MVI	A,CR
	CALL	OBJ$OUT$00
	MVI	A,LF
	CALL	OBJ$OUT$00
	RET

***************************************
*
***************************************

L0747: 
	DB	0
CUR$CHR: 
	DB	0
RADIX$CHR: 
	DB	0
RDCHAR: 
	CALL	DSK$IN		; GET CHAR FROM DISK.
	PUSH	PSW
	CPI	CR		;EXIT IF CR OR LF
	JZ	RDCHAR$EX
	CPI	LF
	JZ	RDCHAR$EX
	LDA	PRN$CHR$CT
	CPI	78H		; MAX LINE LENGTH.(78H=120D)
	JNC	RDCHAR$EX
	MOV	E,A
	MVI	D,0
	INR	A
	STA	PRN$CHR$CT	;GET LINE OFFSET
	LXI	H,PRN$LINE	;ADD TO ORG,(GETS LOC)
	DAD	D
	POP	PSW
	MOV	M,A		;PUT CHAR
	RET
RDCHAR$EX: 
	POP	PSW
	RET

***************************************
* END PRINT LINE IN PRN BUFR.
***************************************

PRN$END$LINE: 
	CALL	L0787
	STA	CUR$CHR		;CLEAR CUR CHAR
	STA	PRN$CHR$CT	; AND PRN COUNTER.
	MVI	A,LF
	STA	L0747
	CALL	PRN$MSG$00
	MVI	A,12H		;LABEL STARTS AT 16TH CHAR.
	STA	PRN$CHR$CT
	RET
L0787: 
	XRA	A
	STA	STR$SIZE
	STA	RADIX$CHR
	RET
L078F: 
	LXI	H,STR$SIZE
	MOV	A,M
	CPI	'@'
	JC	L079D
	MVI	M,0
	CALL	L0963
L079D: 
	MOV	E,M
	MVI	D,0
	INR	M
	INX	H
	DAD	D
	LDA	CUR$CHR
	MOV	M,A
	RET
L07A8: 
	MOV	A,M
	CPI	'$'
	RNZ
	XRA	A
	MOV	M,A
	RET
NUM$C:				;TEST IF NUMBER
	LDA	CUR$CHR
	SUI	'0'		;30H
	CPI	10
	RAL
	ANI	1
	RET
L07BA: 
	CALL	NUM$C
	RNZ
	LDA	CUR$CHR
	SUI	'A'		;41H
	CPI	6
	RAL
	ANI	1
	RET
ALPHA$C: 
	LDA	CUR$CHR
	SUI	'A'		;41H
	CPI	1AH
	RAL
	ANI	1
	RET
L07D4: 
	CALL	ALPHA$C
	RNZ
	CALL	NUM$C
	RET

***************************************
* CONVERT SMALL ALPHA TO CAPS
***************************************

CON$ALPH: 
	LDA	CUR$CHR
	CPI	61H
	RC
	CPI	7BH		;CONVERT SMALL ALPHA TO CAPS.
	RNC
	ANI	5FH
	STA	CUR$CHR
	RET

***************************************
* GET CHAR FROM DISK & PUT IN STRING
***************************************

GET$STR$CHR: 
	CALL	RDCHAR
	STA	CUR$CHR
	PUSH	PSW
	LDA	STR$TYPE
	CPI	3
	CNZ	CON$ALPH
	POP	PSW
	RET
LAST$CHR: 
	CPI	CR
	RZ
	CPI	1AH
	RZ
	CPI	'!'		;21H
	RET

***************************************
* GET STRING.
* picks up a string evaluates it for type
* and computes value from radix designated.
***************************************
GET$STR: 
	XRA	A
	STA	STR$TYPE
	CALL	L0787
GS$00: 
	LDA	CUR$CHR
	CPI	TAB
	JZ	GS$03
	CPI	';'		;COMMENT
	JZ	GS$01
	CPI	'*'		;2AH
	JNZ	GS$02
	LDA	L0747
	CPI	LF
	JNZ	GS$02
GS$01: 
	CALL	GET$STR$CHR
	CALL	LAST$CHR
	JZ	GS$04
	JMP	GS$01
GS$02: 
	ORI	' '		;TEST FOR BLANK
	CPI	' '		;20H
	JNZ	GS$04
GS$03: 
	CALL	GET$STR$CHR
	JMP	GS$00
GS$04: 
	CALL	ALPHA$C
	JZ	GS$05
	MVI	A,1		;CHARACTER TYPE = ALPHA
	JMP	GS$09
GS$05: 
	CALL	NUM$C
	JZ	GS$06
	MVI	A,2		;CHARACTER TYPE = NUMBER
	JMP	GS$09
GS$06: 
	LDA	CUR$CHR
	CPI	''''		;27H
	JNZ	GS$07
	XRA	A
	STA	CUR$CHR
	MVI	A,3		;CHARACTER TYPE = QUOTE
	JMP	GS$09
GS$07: 
	CPI	LF
	JNZ	GS$08		;BR IF END OF LINE
	LDA	PASS$NM
	ORA	A
	CNZ	PRN$MSG$00
	LXI	H,PRN$LINE
	MVI	M,' '		;20H
	MVI	A,10H
	STA	PRN$CHR$CT
GS$08: 
	MVI	A,4		;CHAR TYPE= OTHER ??
GS$09: 
	STA	STR$TYPE
GS$10: 
	LDA	CUR$CHR
	STA	L0747
	ORA	A
	CNZ	L078F
	CALL	GET$STR$CHR
	LDA	STR$TYPE
	CPI	4
	RZ
	CPI	3
	CNZ	CON$ALPH
	LXI	H,CUR$CHR
	LDA	STR$TYPE
	CPI	1
	JNZ	GS$11
	CALL	L07A8
	JZ	GS$10
	CALL	L07D4
	RZ
	JMP	GS$10
GS$11: 
	CPI	2
	JNZ	L0947
	CALL	L07A8
	JZ	GS$10
	CALL	L07BA
	JNZ	GS$10
	LDA	CUR$CHR
	CPI	'O'		;RADIX OCTAL 4FH
	JZ	GS$12
	CPI	'Q'		;RADIX OCTAL (ALT) 51H
	JNZ	GS$13
GS$12: 
	MVI	A,8
	JMP	GS$14
GS$13: 
	CPI	'H'		;RADIX HEX 48H
	JNZ	GS$15
	MVI	A,10H
GS$14: 
	STA	RADIX$CHR
	XRA	A
	STA	CUR$CHR
	JMP	GS$19
GS$15: 
	LDA	L0747
	CPI	'B'		;RADIX BINARY 42H
	JNZ	GS$16
	MVI	A,2
	JMP	GS$17
GS$16: 
	CPI	'D'		;RADIX DECIMAL 44H
	MVI	A,LF
	JNZ	GS$18
GS$17: 
	LXI	H,STR$SIZE
	DCR	M
GS$18: 
	STA	RADIX$CHR
GS$19: 
	LXI	H,00H
	SHLD	STR$VAL
	LXI	H,STR$SIZE
	MOV	C,M
	INX	H
GS$20: 
	MOV	A,M		;CONVERT ASCII TO HEX
	INX	H
	CPI	'A'
	JNC	GS$21
	SUI	'0'		;30H
	JMP	GS$22
GS$21: 
	SUI	'7'		;37H
GS$22:				;EVALUATE DIGIT.
	PUSH	H
	PUSH	B
	MOV	C,A
	LXI	H,RADIX$CHR
	CMP	M		;COMPARE RADIX LIMIT
	CNC	L095D
	MVI	B,0
	MOV	A,M
	LHLD	STR$VAL
	XCHG
	LXI	H,00H
GS$23: 
	ORA	A
	JZ	GS$25
	RAR
	JNC	GS$24
	DAD	D
GS$24: 
	XCHG
	DAD	H
	XCHG
	JMP	GS$23
GS$25: 
	DAD	B
	SHLD	STR$VAL		;SAVE STRING VALUE 011EH
	POP	B
	POP	H
	DCR	C
	JNZ	GS$20
	RET
L0947: 
	LDA	CUR$CHR
	CPI	CR
	JZ	L0963
	CPI	''''		;27H
	JNZ	GS$10
	CALL	GET$STR$CHR
	CPI	''''		;27H
	RNZ
	JMP	GS$10
L095D: 
	PUSH	PSW
	MVI	A,'V'		;VALUE ERROR. 
	JMP	L0969
L0963: 
	PUSH	PSW
	MVI	A,'O'		;OVERFLOW ERROR. 
	JMP	L0969
L0969: 
	PUSH	B
	PUSH	H
	CALL	ERR$COD
	POP	H
	POP	B
	POP	PSW
	RET

***************************************
* SYMBOL TABLE ROUTINES
***************************************

SYM$SUM: 
	NOP
CL$SYM$HASH$LST: 
	LXI	H,SYM$HASH$LST
	MVI	B,80H
	XRA	A
SYM$01: 
	MOV	M,A	;CLR 3018 -- 3099
	INX	H
	MOV	M,A
	INX	H
	DCR	B
	JNZ	SYM$01
	LXI	H,00H
	SHLD	SYM$HASH$PTR
	RET

***************************************
* COMPUTE SYMBOL CHECKSUM
***************************************

CMPUT$SYM$SUM: 
	LXI	H,STR$SIZE	;PUT SIZE IN (B)
	MOV	B,M
	XRA	A
SYM$03: 
	INX	H
	ADD	M		;ADD CHAR VALUE
	DCR	B
	JNZ	SYM$03
	ANI	7FH
	STA	SYM$SUM
	RET

***************************************
* UNUSED CODE ????
***************************************

	MOV	B,A
	LHLD	SYM$HASH$PTR
	INX	H
	INX	H
	MOV	A,M
	ANI	0F0H
	ORA	B
	MOV	M,A
	RET

***************************************
* START SYMBOL EVALUATION
***************************************

SYM$04: 
	LHLD	SYM$HASH$PTR
	INX	H
	INX	H
	MOV	A,M	;GET SIZE
	ANI	0FH
	INR	A
	RET
SYM$05: 
	LHLD	SYM$HASH$PTR
	MOV	A,L
	ORA	H
	RET

***************************************
* SEARCH FOR SYMBOL
***************************************

SYM$SERCH: 
	CALL	CMPUT$SYM$SUM	;COMPUTE ADDRESS KEY
	LXI	H,STR$SIZE
	MOV	A,M
	CPI	11H
	JC	SYM$07
	MVI	M,10H
SYM$07: 
	LXI	H,SYM$SUM	;GET SYM TABLE ADDRESS
	MOV	E,M
	MVI	D,0
	LXI	H,SYM$HASH$LST
	DAD	D
	DAD	D
	MOV	E,M
	INX	H
	MOV	H,M
	MOV	L,E
SYM$08: 
	SHLD	SYM$HASH$PTR	;PUT ADDRESS IN POINTER
	CALL	SYM$05		;IS ADDRESS USED?
	RZ			; RETURN IF EMPTY
	CALL	SYM$04		;GET SYM SIZE
	LXI	H,STR$SIZE	;AND COMPARE WITH CURRENT
	CMP	M
	JNZ	SYM$10		;BR IF NOT EQUAL
	MOV	B,A
	INX	H
	XCHG
	LHLD	SYM$HASH$PTR
	INX	H
	INX	H
	INX	H
SYM$09: 
	LDAX	D		;COMPARE SYMBOL TO NEW STRING
	CMP	M
	JNZ	SYM$10		;NOT MATCHED
	INX	D
	INX	H
	DCR	B
	JNZ	SYM$09
	RET			;RETURN IF MATCHED
SYM$10: 
	LHLD	SYM$HASH$PTR	;SET UP ANOTHER ADDRESS
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	JMP	SYM$08

***************************************
* POST NEW ENTRY TO SYMBOL TABLE
***************************************

POST$SYM: 
	LXI	H,STR$SIZE	;MOVE SIZE TO (DE)
	MOV	E,M
	MVI	D,0
	LHLD	SYMTAB$PTR	;CHECK FOR TABLE OVERFLOW.
	SHLD	SYM$HASH$PTR
	DAD	D
	LXI	D,7
	DAD	D
	XCHG
	LHLD	L0006		;CHECK FOR END MEM 
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
SYM$12: 
	XCHG
	JNC	SYM$15		;EXIT IF OVERFLOW
	SHLD	SYMTAB$PTR	;UPDATE SYM TABLE POINTER
	LHLD	SYM$HASH$PTR	;RESTORE CURRENT LOCATION
	XCHG
	LXI	H,SYM$SUM
	MOV	C,M		;PUT SYM$SUM IN (BC)
	MVI	B,0
	LXI	H,SYM$HASH$LST	;COMPUTE AN ADDRESS
	DAD	B
	DAD	B
	MOV	C,M		;GET EXISTING LINK IF ANY
	INX	H
	MOV	B,M
	MOV	M,D		;PUT NEW LINK HERE
	DCX	H
	MOV	M,E
	XCHG			;RESTORE SYM TABLE ADDR.
	MOV	M,C		;PUT OLD LINK (IF ANY) HERE)
	INX	H
	MOV	M,B
	LXI	D,STR$SIZE	;GET SIZE
	LDAX	D
	CPI	11H
	JC	SYM$13
	MVI	A,10H		;TRUNCATE IF OVERSIZE
SYM$13: 
	MOV	B,A
	DCR	A
	INX	H
	MOV	M,A		;NOW MOVE SIZE TO SYM TABLE
SYM$14: 
	INX	H		;AND MOVE SYMBOL IN TO TABLE
	INX	D
	LDAX	D
	MOV	M,A
	DCR	B
	JNZ	SYM$14
	XRA	A		;CLEAR SPACE FOR VALUE
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
	RET
SYM$15: 
	LXI	H,SYM$16
	CALL	MSGOUT
	JMP	CLOSE$00
SYM$16: 
	DB	'Symbol table overflow',CR
SYM$17: 
	RAL
	RAL
	RAL
	RAL
	ANI	0F0H
	MOV	B,A
	LHLD	SYM$HASH$PTR
	INX	H
	INX	H
	MOV	A,M
	ANI	0FH
	ORA	B
	MOV	M,A		;WRITE CONTROL TO SYM TABLE
	RET
SYM$18: 
	LHLD	SYM$HASH$PTR
	INX	H
	INX	H
	MOV	A,M
	RAR
	RAR
	RAR
	RAR
	ANI	0FH
	RET
SYM$19: 
	CALL	SYM$04
	LHLD	SYM$HASH$PTR
	MOV	E,A
	MVI	D,0
	DAD	D
	INX	H
	INX	H
	INX	H
	RET
***************************************
* SYMBOL TABLE FORMAT
* LENGTH OF EACH ENTRY = SYMBOL LENGTH + 5
* FORMAT
* W1 - LINK ADDRESS (IF ANY)
* W2 -  "     "        "
* W3 - TYPE,LENGTH-1
* W4-WN SYMBOL
* WN+1 VALUE
* WN+2 VALUE
* WN+3 LINE #	| IN BCD
* WN+4 LINE #   | 0 - 9999
***************************************
PUT$SYM$VAL: 
	PUSH	H
	CALL	SYM$19
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
* LOAD BCD LINE NUMBER INTO SYMBOL TABLE
	PUSH	H
	PUSH	B
	INX	H
	LXI	B,LINE$NM
	LDAX	B
	MOV	M,A
	INX	H
	INX	B
	LDAX	B
	MOV	M,A
	POP	B
	POP	H
	RET
GET$SYM$VAL: 
	CALL	SYM$19
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	RET

***************************************
* OPERATOR TABLES
***************************************

OPR$TAB$B5: 
	DW	BLK1$A	
	DW	BLK2$A
	DW	BLK3$A
	DW	BLK4$A
	DW	BLK5$A
	DW	BLK1$B

OPR$TAB$C1: 
	DB	(BLK2$A-BLK1$A)
	DB	(BLK3$A-BLK2$A)/2
	DB	(BLK4$A-BLK3$A)/3
	DB	(BLK5$A-BLK4$A)/4
	DB	(BLK1$B-BLK5$A)/5

OPR$TAB$C6: 
	DW	BLK1$B	
	DW	BLK2$B
	DW	BLK3$B
	DW	BLK4$B
	DW	BLK5$B

BLK1$A:
	DB	CR
	DB	'('
	DB	')'
	DB	'*'
	DB	'+'
	DB	','
	DB	'-'
	DB	'/'
	DB	'A'
	DB	'B'
	DB	'C'
	DB	'D'
	DB	'E'
	DB	'H'
	DB	'L'
	DB	'M'
BLK2$A:
	DB	'DB'
	DB	'DI'
	DB	'DS'
	DB	'DW'
	DB	'EI'
	DB	'IF'
	DB	'IN'
	DB	'OR'
	DB	'SP'
BLK3$A:
	DB	'ACI'
	DB	'ADC'
	DB	'ADD'
	DB	'ADI'
	DB	'ANA'
	DB	'AND'
	DB	'ANI'
	DB	'CMA'
	DB	'CMC'
	DB	'CMP'
	DB	'CPI'
	DB	'DAA'
	DB	'DAD'
	DB	'DCR'
	DB	'DCX'
	DB	'END'
	DB	'EQU'
	DB	'HLT'
	DB	'INR'
	DB	'INX'
	DB	'JMP'
	DB	'LDA'
	DB	'LXI'
	DB	'MOD'
	DB	'MOV'
	DB	'MVI'
	DB	'NOP'
	DB	'NOT'
	DB	'ORA'
	DB	'ORG'
	DB	'ORI'
	DB	'OUT'
	DB	'POP'
	DB	'PSW'
	DB	'RAL'
	DB	'RAR'
	DB	'RET'
	DB	'RLC'
	DB	'RRC'
	DB	'RST'
	DB	'SBB'
	DB	'SBI'
	DB	'SET'
	DB	'SHL'
	DB	'SHR'
	DB	'STA'
	DB	'STC'
	DB	'SUB'
	DB	'SUI'
	DB	'SYM'
	DB	'XOR'
	DB	'XRA'
	DB	'XRI'
BLK4$A:
	DB	'CALL'
	DB	'LDAX'
	DB	'LHLD'
	DB	'LINK'
	DB	'PCHL'
	DB	'PUSH'
	DB	'SHLD'
	DB	'SPHL'
	DB	'STAX'
	DB	'XCHG'
	DB	'XREF'
	DB	'XTHL'
BLK5$A:
	DB	'ENDIF'
	DB	'MACRO'
	DB	'TITLE'
******************************************************
* OPCODE INDEX
*   FORMAT (SOURCE FORM)
*   XX-- OPCODE
*   --XX INDEX	
******************************************************
BLK1$B:
	DW	0A0FH		;CR 
	DW	140CH		;(
	DW	1E0DH		;)
	DW	5000H		;*
	DW	4605H		;+
	DW	0A0EH		;COMMA
	DW	4606H		;-
	DW	5001H		;/
	DW	0710H		;A
	DW	0010H		;B
	DW	0110H		;C
	DW	0210H		;D
	DW	0310H		;E
	DW	0410H		;H
	DW	0510H		;L
	DW	0610H		;M

BLK2$B:
	DW	00111H		;DB
	DW	0F313H		;DI
	DW	00211H		;DS
	DW	00311H		;DW
	DW	0FB13H		;EI
	DW	00811H		;IF
	DW	0DB21H		;IN
	DW	0280AH		;OR
	DW	00610H		;SP
BLK3$B:
	DW	0CE1AH		;ACI
	DW	0881DH		;ADC
	DW	0801DH		;ADD
	DW	0C61AH		;ADI
	DW	0A01DH		;ANA
	DW	03209H		;AND
	DW	0E61AH		;ANI 
	DW	02F13H		;CMA
	DW	03F13H		;CMC
	DW	0B81DH		;CMP
	DW	0FE1AH		;CPI
	DW	02713H		;DAA
	DW	00915H		;DAD
	DW	0051EH		;DCR
	DW	00B1FH		;DCX
	DW	00411H		;END
	DW	00711H		;EQU
	DW	07613H		;HLT
	DW	0041EH		;INR
	DW	0031FH		;INX
	DW	0C317H		;JMP
	DW	03A1CH		;LDA
	DW	00114H		;LXI
	DW	05002H		;MOD
	DW	04018H		;MOV
	DW	00619H		;MVI
	DW	00013H		;NOP
	DW	03C08H		;NOT
	DW	0B01DH		;ORA
	DW	00A11H		;ORG
	DW	0F61AH		;ORI
	DW	0D321H		;OUT
	DW	0C116H		;POP
	DW	00610H		;PSW
	DW	01713H		;RAL
	DW	01F13H		;RAR
	DW	0C913H		;RET
	DW	00713H		;RLC
	DW	00F13H		;RRC
	DW	0C720H		;RST
	DW	0981DH		;SBB
	DW	0DE1AH		;SBI
	DW	00B11H		;SET
	DW	05003H		;SHL
	DW	05004H		;SHR
	DW	0321CH		;STA
	DW	03713H		;STC
	DW	0901DH		;SUB
	DW	0D61AH		;SUI
	DW	00D11H		;SYM
	DW	0280BH		;XOR
	DW	0A81DH		;XRA
	DW	0EE1AH		;XRI
BLK4$B:
	DW	0CD17H		;CALL
	DW	00A1BH		;LDAX 
	DW	02A1CH		;LHLD
	DW	00611H		;LINK
	DW	0E913H		;PCHL
	DW	0C516H		;PUSH
	DW	0221CH		;SHLD
	DW	0F913H		;SPHL 
	DW	0021BH		;STAX
	DW	0EB13H		;XCHG
	DW	00E11H		;XREF
	DW	0E313H		;XTHL
BLK5$B:
	DW	00511H		;ENDIF
	DW	00911H		;MACRO
	DW	00C11H		;TITLE

***************************************
* JMP,CALL,RET LIST
***************************************

JCR$LIST:
	DB	'NZ'
	DB	'Z '
	DB	'NC'
	DB	'C '
	DB	'PO'
	DB	'PE'
	DB	'P '
	DB	'M '
***************************************
***************************************
L0C8F: 
	MVI	E,0FFH
	INR	B
	MVI	C,0

***************************************
* SCAN FOR OPERATOR
* SCHEME PROCEEDS AS A SUCCESSIVE APPROXIMATION
***************************************

L0C94: 
	XRA	A
	MOV	A,B
	ADD	C
	RAR
	CMP	E
	JZ	L0CD0
	MOV	E,A
	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	H
	MOV	B,D
	MOV	C,B
	MVI	D,0
	LXI	H,00H
L0CA8: 
	DAD	D
	DCR	B
	JNZ	L0CA8
	POP	D
	DAD	D
	LXI	D,STRING
L0CB2: 
	LDAX	D
	CMP	M		;COMPARE INPUT STRING TO LIST.
	INX	D
	INX	H
	JNZ	L0CC2
	DCR	C
	JNZ	L0CB2
	POP	B
	POP	D
	POP	H
	MOV	A,E
	RET
L0CC2: 
	POP	B
	POP	D
	POP	H
	JC	L0CCC
	MOV	C,E
	JMP	L0C94
L0CCC: 
	MOV	B,E
	JMP	L0C94
L0CD0: 
	XRA	A
	INR	A
	RET
L0CD3: 
	LDA	STRING
	LXI	B,LC217
	CPI	'J'
	RZ
	MVI	B,0C4H
	CPI	'C'
	RZ
	LXI	B,LC013
	CPI	'R'
	RET

***************************************
* SCAN JMP,CALL,RET CONDITIONAL LIST
***************************************

SCAN$JCR:
	LDA	STR$SIZE
	CPI	4
	JNC	L0D19
	CPI	3
	JZ	L0CFE
	CPI	2
	JNZ	L0D19
	LXI	H,STRING+2
	MVI	M,' '
L0CFE:
	LXI	B,8
	LXI	D,JCR$LIST
L0D04:
	LXI	H,STRING+1	
	LDAX	D
	CMP	M
	INX	D
	JNZ	L0D11
	LDAX	D
	INX	H
	CMP	M
	RZ
L0D11:
	INX	D
	INR	B
	DCR	C
	JNZ	L0D04
	INR	C
	RET
L0D19:
	XRA	A
	INR	A
	RET

***************************************
* PREPARE TO SCAN FOR OPERATOR
* FIRST INDEX INTO LISTS.
***************************************

SCAN$OP: 
	LDA	STR$SIZE	;STRING CTR 0120H
	MOV	C,A
	DCR	A
	MOV	E,A
	MVI	D,0
	PUSH	D
	CPI	5
	JNC	L0D66		;BR IF STRING > 5 CHAR. 0D66H
	LXI	H,OPR$TAB$C1	;BLOCK SIZE. 0AC1H
	DAD	D
	MOV	B,M
	LXI	H,OPR$TAB$B5
	DAD	D
	DAD	D
	MOV	D,M
	INX	H
	MOV	H,M
	MOV	L,D
	MOV	D,C
	CALL	L0C8F
	JNZ	L0D51		;OPERATOR NOT LISTED
	POP	D
	LXI	H,OPR$TAB$C6
	DAD	D
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M		;POINT TO BLOCK ORG
	MOV	L,A
	MVI	H,0
	DAD	H
	DAD	D
	MOV	A,M		;GET INDEX VALUES (BLK(X)$B
	INX	H
	MOV	B,M
	RET
L0D51: 
	POP	D
	CALL	L0CD3
	RNZ
	PUSH	B
	CALL	SCAN$JCR	;IS FIRST CHARACTER A J,C OR R.
	MOV	A,B
	POP	B
	RNZ
	ORA	A
	RAL
	RAL
	RAL
	ORA	B
	MOV	B,A
	MOV	A,C
	CMP	A
	RET
L0D66: 
	POP	D
	XRA	A
	INR	A
	RET

***************************************
* EXPRESSION STACKS
* CONSISTS OF THREE STACKS
* 00 = PRIMARY     LIMIT 16
* 01 = NEXT LEVEL	 10
* 02 = NEXT LEVEL	 10
***************************************

EXP$STAK$PTR02: 
	DB	0
EXP$STACK$01:			;EXP$STACK$01 
	DB	0,0,0,0,0,0,0,0,0,0
EXP$STACK$02: 
	DB	0,0,0,0,0,0,0,0,0,0
EXP$STACK$00: 
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0
EXP$STAK$PTR01: 
	DB	0
EXP$STAK$PTR$00: 
	DB	0

***************************************
* PUT ITEM ON EXPRESSION STACK
***************************************

PUT$EXP00$00: 
	XCHG
	LXI	H,EXP$STAK$PTR$00
	MOV	A,M
	CPI	16		;LIMIT EXCEEDED?
	JC	PUT$EXP00$01
	CALL	EXP$ERROR
	MVI	M,0
PUT$EXP00$01: 
	MOV	A,M
	INR	M
	INR	M
	MOV	C,A
	MVI	B,0
	LXI	H,EXP$STACK$00
	DAD	B
	MOV	M,E
	INX	H
	MOV	M,D
	RET
PUT$EXP$02: 
	PUSH	PSW
	LXI	H,EXP$STAK$PTR01
	MOV	A,M
	CPI	10		;LIMIT EXCEEDED?
	JC	PUT$EXP$03
	MVI	M,0
	CALL	EXP$ERROR
PUT$EXP$03: 
	MOV	E,M
	MVI	D,0
	INR	M
	POP	PSW
	LXI	H,EXP$STACK$01	;EXP$STACK$01H
	DAD	D
	MOV	M,A
	LXI	H,EXP$STACK$02
	DAD	D
	MOV	M,B
	RET

***************************************
* GET AN EXPRESSION ITEM
* RETURN WITH IT IN (HL)
***************************************

GET$EXP$ITEM: 
	LXI	H,EXP$STAK$PTR$00
	MOV	A,M
	ORA	A
	JNZ	L0DDC
	CALL	EXP$ERROR
	LXI	H,00H
	RET
L0DDC: 
	DCR	M
	DCR	M
	MOV	C,M
	MVI	B,0
	LXI	H,EXP$STACK$00
	DAD	B
	MOV	C,M
	INX	H
	MOV	H,M
	MOV	L,C
	RET

***************************************
* GET TWO EXPRESSION ITEMS
* RETURN WITH 1ST IN H
*             2ND IN D
***************************************

GET$2EXP$ITEMS: 
	CALL	GET$EXP$ITEM
	XCHG
	CALL	GET$EXP$ITEM
	RET

***************************************
* GET EXPRESSION OPERATOR
***************************************

GET$EXP$OP: 
	MOV	L,A
	MVI	H,0
	DAD	H
	LXI	D,EXP$OP$INDEX
	DAD	D
	MOV	E,M
	INX	H
	MOV	H,M
	MOV	L,E
	PCHL
EXP$OP$INDEX: 
	DW	AB$00		; *
	DW	AB$01		; /
	DW	AB$02		; MOD
	DW	AB$03		; SHL
	DW	AB$04		; SHR
	DW	AB$05		; +
	DW	AB$06		; -
	DW	AB$07
	DW	AB$08		; NOT
	DW	AB$09		; AND
	DW	AB$10		; OR
	DW	AB$11		; XOR
	DW	EXP$ERROR

***************************************
* GET TWO EXPRESSION ITEMS
* RETURN WITH 2ND ITEM IN ACC
***************************************

GET$2EXP$01: 
	CALL	GET$2EXP$ITEMS
	MOV	A,D
	ORA	A
	JNZ	L0E25
	MOV	A,E
	CPI	11H
	RC
L0E25: 
	CALL	EXP$ERROR
	MVI	A,10H
	RET
L0E2B: 
	XRA	A
	SUB	L
	MOV	L,A
	MVI	A,0
	SBB	H
	MOV	H,A
	RET
L0E33: 
	CALL	GET$2EXP$ITEMS
L0E36: 
	XCHG
	SHLD	L0E69
	LXI	H,L0E6B
	MVI	M,11H
	LXI	B,00H
	PUSH	B
	XRA	A
L0E44: 
	MOV	A,E
	RAL
	MOV	E,A
	MOV	A,D
	RAL
	MOV	D,A
	DCR	M
	POP	H
	RZ
	MVI	A,0
	ACI	0
	DAD	H
	MOV	B,H
	ADD	L
	LHLD	L0E69
	SUB	L
	MOV	C,A
	MOV	A,B
	SBB	H
	MOV	B,A
	PUSH	B
	JNC	L0E62
	DAD	B
	XTHL
L0E62: 
	LXI	H,L0E6B
	CMC
	JMP	L0E44
L0E69: 
	DB	0,0
L0E6B: 
	DB	0
L0E6C: 
	MOV	B,H
	MOV	C,L
	LXI	H,0000H
L0E71: 
	XRA	A
	MOV	A,B
	RAR
	MOV	B,A
	MOV	A,C
	RAR
	MOV	C,A
	JC	L0E80
	ORA	B
	RZ
	JMP	L0E81
L0E80: 
	DAD	D
L0E81: 
	XCHG
	DAD	H
	XCHG
	JMP	L0E71

*****************************
* MULTIPLY *
*****************************

AB$00:	CALL	GET$2EXP$ITEMS
	CALL	L0E6C
	JMP	PUT$EXP00$00

*****************************
* DIVIDE /
*****************************

AB$01:	CALL	L0E33
	XCHG
	JMP	PUT$EXP00$00

*****************************
* MODULO ARITHMETIC (MOD)
*****************************

AB$02:	CALL	L0E33
	JMP	PUT$EXP00$00

*****************************
* SHIFT LEFT SHL
*****************************

AB$03:	CALL	GET$2EXP$01
L0EA0: 
	ORA	A
	JZ	PUT$EXP00$00
	DAD	H
	DCR	A
	JMP	L0EA0

*****************************
* SHIFT RIGHT SHR
*****************************

AB$04:	CALL	GET$2EXP$01
L0EAC: 
	ORA	A
	JZ	PUT$EXP00$00
	PUSH	PSW
	XRA	A
	MOV	A,H
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	POP	PSW
	DCR	A
	JMP	L0EAC

*****************************
* PLUS +
*****************************

AB$05:	CALL	GET$2EXP$ITEMS
L0EC0: 
	DAD	D
	JMP	PUT$EXP00$00

*****************************
* MINUS -
*****************************

AB$06:	CALL	GET$2EXP$ITEMS
	XCHG
	CALL	L0E2B
	JMP	L0EC0

*****************************
*
*****************************

AB$07:	CALL	GET$EXP$ITEM
L0ED1: 
	CALL	L0E2B
	JMP	PUT$EXP00$00

*****************************
* NOT
*****************************

AB$08:	CALL	GET$EXP$ITEM
	INX	H
	JMP	L0ED1

*****************************
* AND
*****************************

AB$09:	CALL	GET$2EXP$ITEMS
	MOV	A,D
	ANA	H
	MOV	H,A
	MOV	A,E
	ANA	L
	MOV	L,A
	JMP	PUT$EXP00$00

*****************************
* OR
*****************************

AB$10:	CALL	GET$2EXP$ITEMS
	MOV	A,D
	ORA	H
	MOV	H,A
	MOV	A,E
	ORA	L
	MOV	L,A
	JMP	PUT$EXP00$00

*****************************
* XOR
*****************************

AB$11:	CALL	GET$2EXP$ITEMS
	MOV	A,D
	XRA	H
	MOV	H,A
	MOV	A,E
	XRA	L
	MOV	L,A
	JMP	PUT$EXP00$00

L0F02:	LDA	STR$TYPE
	CPI	4
	RNZ
	LDA	STRING
	CPI	CR
	RZ
	CPI	';'		;3BH
	RZ
	CPI	','		;2CH
	RZ
	CPI	'!'		;21H
	RET
L0F17: 
	XRA	A
	STA	EXP$STAK$PTR01
	STA	EXP$STAK$PTR$00	;
	DCR	A
	STA	EXP$STAK$PTR02
	LXI	H,00H		;
	SHLD	L0161		;
L0F28:				; 
	CALL	L0F02
	JNZ	L0F5B		;
L0F2E:				; 
	LXI	H,EXP$STAK$PTR01
	MOV	A,M
	ORA	A
	JZ	L0F46		;
	DCR	M
	MOV	E,A
	DCR	E
	MVI	D,0
	LXI	H,EXP$STACK$01	;EXP$STACK$01H
	DAD	D
	MOV	A,M
	CALL	GET$EXP$OP	;
	JMP	L0F2E		;
L0F46:				; 
	LDA	EXP$STAK$PTR$00	;
	CPI	2
	CNZ	EXP$ERROR	;
	LDA	PRN$LINE	;
	CPI	' '		;
	RNZ
	LHLD	EXP$STACK$00	;
	SHLD	L0161		;
	RET
L0F5B:				; 
	LDA	PRN$LINE	;
	CPI	' '		;
	JNZ	L107D		;
	LDA	STR$TYPE	;
	CPI	3
	JNZ	L0F87		;
	LDA	STR$SIZE
	ORA	A
	CZ	EXP$ERROR	;
	CPI	3
	CNC	EXP$ERROR	;
	MVI	D,0
	LXI	H,STRING	;
	MOV	E,M
	INX	H
	DCR	A
	JZ	L0F83		;
	MOV	D,M
L0F83:				; 
	XCHG
	JMP	L106F		;
L0F87:				; 
	CPI	2
	JNZ	L0F92		;
	LHLD	STR$VAL		;
	JMP	L106F		;
L0F92:				; 
	CALL	SCAN$OP		;
	JNZ	L102F		;
	CPI	10H
	JNC	L1024		;
	CPI	0CH
	MOV	C,A
	LDA	EXP$STAK$PTR02
	JNZ	L0FB3		;
	ORA	A
	CZ	EXP$ERROR	;
	MVI	A,0FFH
	STA	EXP$STAK$PTR02
	MOV	A,C
	JMP	L1001		;
L0FB3:				; 
	ORA	A
	JNZ	L100C		;
L0FB7:				; 
	PUSH	B
	LDA	EXP$STAK$PTR01	;
	ORA	A
	JZ	L0FDC		;
	MOV	E,A
	DCR	E
	MVI	D,0
	LXI	H,EXP$STACK$02
	DAD	D
	MOV	A,M
	CMP	B
	JC	L0FDC		;
	LXI	H,EXP$STAK$PTR01
	MOV	M,E
	LXI	H,EXP$STACK$01	;EXP$STACK$01H
	DAD	D
	MOV	A,M
	CALL	GET$EXP$OP	;
	POP	B
	JMP	L0FB7		;
L0FDC:				; 
	POP	B
	MOV	A,C
	CPI	CR
	JNZ	L1001		;
	LXI	H,EXP$STAK$PTR01
	MOV	A,M
	ORA	A
	JZ	L0FFA		;
	DCR	A
	MOV	M,A
	MOV	E,A
	MVI	D,0
	LXI	H,EXP$STACK$01	;EXP$STACK$01H
	DAD	D
	MOV	A,M
	CPI	0CH
	JZ	L0FFD		;
L0FFA: 
	CALL	EXP$ERROR	;
L0FFD:				; 
	XRA	A
	JMP	L1006		;
L1001:				; 
	CALL	PUT$EXP$02	;
	MVI	A,0FFH
L1006:				; 
	STA	EXP$STAK$PTR02
	JMP	L107D		;
L100C:				; 
	MOV	A,C
	CPI	5
	JZ	L107D		;
	CPI	6
	JNZ	L101C		;
	INR	A
	MOV	C,A
	JMP	L0FB7		;
L101C:				; 
	CPI	8
	CNZ	EXP$ERROR	;
	JMP	L0FB7		;
L1024:				; 
	CPI	11H
	CZ	EXP$ERROR	;
	MOV	L,B
	MVI	H,0
	JMP	L106F		;
L102F:				; 
	LDA	STR$TYPE	;
	CPI	4
	JNZ	L104E		;
	LDA	STRING		;
	CPI	'$'		;24H
	JZ	L1048		;
	CALL	EXP$ERROR	;
	LXI	H,00H		;
	JMP	L106F		;
L1048:				; 
	LHLD	LOC$CTR2	;
	JMP	L106F		;
L104E:				; 
	CALL	SYM$SERCH
	CALL	SYM$05		;
	JNZ	L1062		;
	MVI	A,'P'		;PHASE ERROR. 50H
	CALL	ERR$COD		;
	CALL	POST$SYM	;
	JMP	L106C		;
L1062:				; 
	CALL	SYM$18		;
	ANI	7
	MVI	A,'U'		;UNDEFINED SYMBOL. 55H
	CZ	ERR$COD		;
L106C:				; 
	CALL	GET$SYM$VAL		;
;
; PUT XREF ITEM IN TABLE
;
	LDA	PASS$NM
	ORA	A
	JZ	L106F
	LDA	FLAG$BYT
	ANI	XREFF		;XREF FLAG?
	JZ	L106F
	PUSH	H
	PUSH	D
	INX	D		;POINT TO SYMBOL LINE #.
	LHLD	XREF$PTR	;GET NEXT XREF LOCATION
	LDAX	D		;MOV IN SYMBOL LINE #.
	MOV	M,A
	INX	D
	INX	H
	LDAX	D
	MOV	M,A
	INX	H
	LDA	LINE$NM
	MOV	M,A
	INX	H
	LDA	LINE$NM+1
	MOV	M,A
	LXI	D,-7
	DAD	D
	SHLD	XREF$PTR
	XCHG
	LHLD	SYM$TAB$PTR
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	POP	D
	POP	H
	JNC	SYM$15
	
L106F:
	LDA	EXP$STAK$PTR02	;
	ORA	A
	CZ	EXP$ERROR	;
	XRA	A
	STA	EXP$STAK$PTR02	;
	CALL	PUT$EXP00$00	;
L107D:
	CALL	GET$STR		;
	JMP	L0F28		;

*****************************
* EXPRESSION ERROR
*****************************

EXP$ERROR:			; 
	PUSH	H
	MVI	A,'E'		;EXPRESSION ERROR. 45H
	CALL	ERR$COD		;
	POP	H
	RET

*****************************
* START OF PROCESSING
*****************************

MAIN:
	XRA	A
	STA	PASS$NM		;RESET PASS #
	LHLD	L0006		;GET TOP OF MEM
	LXI	D,-8
	DAD	D
	SHLD	XREF$PTR	;INIT XREF POINTER
	CALL	CL$SYM$HASH$LST	;CLEAR SYM$HASH$LST
MAIN$00: 
	CALL	PRN$END$LINE	;PRINT END LINE
	LDA	PASS$NM
	ADI	31H
	STA	PAS$MSG+5
	LXI	H,PAS$MSG	;ANNUNCIATE PASS 1
	CALL	MSGOUT
	LXI	H,SRCFCB	;MOVE FILE NAME
	CALL	MOVNAM		;FROM TFCB TO SRC FCB
	CALL	RESET$SRC	;RESET SOURCE FILE
	XRA	A
	STA	OBJ$BYTE$CNT
	LXI	H,00H
	SHLD	L1686
	SHLD	LOC$CTR1
	SHLD	LOC$CTR2
	SHLD	L1688
MAIN$01:
	CALL	GET$STR		;GET STRING
MAIN$02: 
	LDA	STR$TYPE
	CPI	2		;IS IT NUMERIC?
	JZ	MAIN$01
	CPI	4		;OR OTHER DELIMITERS
	JNZ	MAIN$03
	LDA	STRING
	CPI	'*'
	JNZ	END$LINE
	CALL	L159B
	JNZ	SYNTAX$ERR
	JMP	E$LINE$01
MAIN$03: 
	CPI	1		;IF IT ISNT ALPHA, THEN ERROR
	JNZ	SYNTAX$ERR
	CALL	SCAN$OP		;SCAN OPERATION. 
	JZ	L1125		;BR IF OPERATION FOUND. 
	CALL	SYM$SERCH	;ELSE SEE IF ITS A SYMBOL
	CALL	SYM$05
	JNZ	MAIN$04
	CALL	POST$SYM
	LDA	PASS$NM
	ORA	A
	CNZ	PHASE$ERR
	JMP	MAIN$05
MAIN$04: 
	CALL	SYM$18
	CPI	6
	JNZ	MAIN$05
	CALL	NOT$IMP$ERR
	JMP	E$LINE$01
MAIN$05: 
	LHLD	L1686
	MOV	A,L
	ORA	H
	CNZ	LABLE$ERR
	LHLD	SYM$HASH$PTR
	SHLD	L1686
	CALL	GET$STR
	LDA	STR$TYPE
	CPI	4
	JNZ	MAIN$02
	LDA	STRING
	CPI	':'
	JNZ	MAIN$02
	JMP	MAIN$01
*****************************
* DIRECTIVES	CODE GROUP 11
*****************************
L1125:				; 
	CPI	11H
	JNZ	L1339		;
	MOV	E,B
	MVI	D,0
	DCX	D
	LXI	H,L1138		;
	DAD	D
	DAD	D
	MOV	E,M
	INX	H
	MOV	H,M
	MOV	L,E
	PCHL
L1138:				; 

	DW	AA$00		;DB
	DW	AA$01		;DS
	DW	AA$02		;DW
	DW	AA$03		;END
	DW	AA$04		;ENDIF
	DW	AA$05		;LINK
	DW	AA$06		;EQU
	DW	AA$07		;IF
	DW	AA$08		;MACRO
	DW	AA$09		;ORG
	DW	AA$10		;SET
	DW	AA$11		;TITLE
	DW	AA$12		;SYM
	DW	AA$13		;XREF

*****************************
* DB
*****************************

AA$00:	CALL	L15A5		;
AA$001:				; 
	CALL	GET$STR		;
	LDA	STR$TYPE	;
	CPI	3
	JNZ	AA$004		;
	LDA	STR$SIZE	;
	DCR	A
	JZ	AA$004		;
	MOV	B,A
	INR	B
	INR	B
	LXI	H,STRING	;
AA$002:				; 
	DCR	B
	JZ	AA$003		;
	PUSH	B
	MOV	B,M
	INX	H
	PUSH	H
	CALL	PUT$COD$01	;
	POP	H
	POP	B
	JMP	AA$002		;
AA$003:				; 
	CALL	GET$STR		;
	JMP	AA$005		;
AA$004:				; 
	CALL	L0F17		;
	LHLD	L0161		;
	MOV	A,H
	ORA	A
	CNZ	DATA$ERR	;
	MOV	B,L
	CALL	PUT$COD$01	;
AA$005:				; 
	CALL	L1594		;
	CALL	L141C		;
	CPI	','		;2CH
	JZ	AA$001		;
	JMP	END$LINE	;

*****************************
* DS
*****************************

AA$01:
	CALL	L15A5		;
	CALL	L1641		;
	CALL	G$OPRND$00	;GET OPERAND. 1433H
	XCHG
	LHLD	LOC$CTR2	;
	DAD	D
	SHLD	LOC$CTR2	;
	SHLD	LOC$CTR1	;
	JMP	END$LINE	;

*****************************
* DW
*****************************

AA$02:	CALL	L15A5		;
AA$021:				; 
	CALL	G$OPRND$00	;
	PUSH	H
	MOV	B,L
	CALL	PUT$COD$01	;
	POP	H
	MOV	B,H
	CALL	PUT$COD$01	;
	CALL	L1594		;
	CALL	L141C		;
	CPI	','		;2CH
	JZ	AA$021		;
	JMP	END$LINE	;

*****************************
* END
*****************************

AA$03:
	CALL	L15A5		;
	CALL	L1641		;
	LDA	PRN$LINE	;
	CPI	' '		;
	JNZ	END$LINE	;
	CALL	G$OPRND$00	;
	LDA	PRN$LINE	;
	CPI	' '		;
	JNZ	AA$031		;
	SHLD	L1688		;
AA$031:				; 
	MVI	A,' '		;
	STA	PRN$LINE	;
	CALL	GET$STR		;
	LDA	STR$TYPE	;
	CPI	4
	JNZ	SYNTAX$ERR	;
	LDA	STRING		;
	CPI	LF
	JNZ	SYNTAX$ERR	;
	JMP	E$PASS		;

*****************************
* ENDIF
*****************************

AA$04:	JMP	TIT$01		;

*****************************
* LINK
*****************************

AA$05:	CALL	GET$STR		;
	LXI	H,SRCNAME	;
	LXI	D,STRING	;
	LDA	STR$SIZE	;
	ORA	A
	JZ	AA$054		;
	MOV	B,A
	MVI	A,9
	CMP	B
	JC	AA$054		;
	SUB	B
	MOV	C,A
AA$051:				; 
	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	AA$051		;
AA$052:				; 
	DCR	C
	JZ	AA$053		;
	MVI	M,' '		;
	INX	H
	JMP	AA$052		;
AA$053:				; 
	CALL	GET$STR		;
	LDA	CUR$CHR		;
	CPI	1AH
	JZ	AA$054		;
	CPI	LF
	JNZ	AA$053		;
	CALL	RESET$SRC	;
	CALL	GET$STR		;
	JMP	MAIN$01		;
	MOV	M,B
	INX	H
	DCR	C
	JNZ	AA$051		;
	JMP	AA$053		;
AA$054:				; 
	LXI	H,AA$055	;
	CALL	MSGOUT		;
	CALL	PRN$MSG$00	;
	JMP	CPM		;
AA$055:				; 
	DB	'++ERROR IN LINK OPERAND++'
	DB	CR

*****************************
* EQU
*****************************

AA$06:	CALL	L159B		;
	JZ	SYNTAX$ERR	;
	LHLD	LOC$CTR2	;
	PUSH	H
	CALL	G$OPRND$00	;
	SHLD	LOC$CTR2	;
	CALL	L15A5		;
	CALL	L1644		;
	LXI	H,L1692		;
	MVI	M,'='		;
	POP	H
	SHLD	LOC$CTR2	;
	JMP	END$LINE	;

*****************************
* IF
*****************************

AA$07:	CALL	L15A5		;
	CALL	G$OPRND$00	;
	LDA	PRN$LINE	;
	CPI	' '		;
	JNZ	END$LINE	;
	MOV	A,L
	RAR
	JC	END$LINE	;
AA$071:				; 
	CALL	GET$STR		;
	LDA	STR$TYPE	;
	CPI	4
	JNZ	AA$072		;
	LDA	STRING		;
	CPI	1AH
	MVI	A,'B'		;BALANCE ERROR. 42H
	CZ	ERR$COD		;
	JZ	E$PASS		;
	JMP	AA$071		;
AA$072:				; 
	CPI	1
	JNZ	AA$071		;
	CALL	SCAN$OP		;
	JNZ	AA$071		;
	CPI	11H
	JNZ	AA$071		;
	MOV	A,B
	CPI	5
	JNZ	AA$071		;
	JMP	TIT$01		;

*****************************
* MACRO
*****************************

AA$08:	CALL	NOT$IMP$ERR	;
	JMP	END$LINE	;

*****************************
* ORG
*****************************

AA$09:	CALL	G$OPRND$00	;
	LDA	PRN$LINE	;
	CPI	' '		;
	JNZ	END$LINE	;
	SHLD	LOC$CTR2	;
	SHLD	LOC$CTR1	;
	CALL	L15A5		;
	CALL	L1641		;
	JMP	END$LINE	;

*****************************
* SET
*****************************

AA$10:	CALL	L159B		;
	JZ	SYNTAX$ERR	;
	CALL	SYM$18		;
	CPI	5
	CNZ	LABLE$ERR	;
	MVI	A,5
	CALL	SYM$17		;
	CALL	G$OPRND$00	;
	PUSH	H
	CALL	L159B		;
	POP	H
	CALL	PUT$SYM$VAL		;
	LXI	H,00H		;
	SHLD	L1686		;
	JMP	END$LINE	;

*****************************
* TITLE
*****************************

AA$11:
	CALL	GET$STR
	LDA	STR$TYPE
	CPI	3
	JNZ	SYNTAX$ERR
	LDA	STR$SIZE
	MOV	B,A
	INR	B
	LXI	H,STRING
	LXI	D,TIT$BUF
TIT$00:
	DCR	B
	JZ	TIT$01
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	JMP	TIT$00
TIT$01:				; 
	CALL	GET$STR		;
	JMP	END$LINE	;

*****************************
* SYM (12)
*****************************
AA$12:
	LXI	H,FLAG$BYT
	MOV	A,M
	ORI	SYMF
	MOV	M,A
	JMP	TIT$01

*****************************
* XREF (13)
*****************************
AA$13:
	LXI	H,FLAG$BYT
	MOV	A,M
	ORI	XREFF
	MOV	M,A
	JMP	TIT$01

*****************************
* OPERATORS
*****************************

L1339:				; 
	SUI	13H
	CPI	'!'		;
	JNC	SYNTAX$ERR	;
	MOV	E,A
	MVI	D,0
	LXI	H,OPR$JMP$LIST
	DAD	D
	DAD	D
	MOV	E,M
	INX	H
	MOV	H,M
	MOV	L,E
	PCHL
OPR$JMP$LIST: 

	DW	OPR$00		; 13 SINGLE BYTE INSTRUCTIONS
	DW	OPR$01		; 14 LXI
	DW	OPR$02		; 15 DAD
	DW	OPR$03		; 16 POP,PUSH
	DW	OPR$04		; 17 JMP,CALL
	DW	OPR$05		; 18 MOV
	DW	OPR$06		; 19 MVI
	DW	OPR$07		; 1A XRI,MVI,SBI, ETC
	DW	OPR$08		; 1B STAX,LDAX
	DW	OPR$09		; 1C STA,LDA,SHLD,LHLD
	DW	OPR$10		; 1D XRA,SUB,SBB,ORA,ANA,ADC,ADD
	DW	OPR$11		; 1E INR,DCR
	DW	OPR$12		; 1F INX,DCX
	DW	OPR$13		; 20 RST
	DW	OPR$14		; 21 IN,OUT

*****************************
* SINGLE BYTE INSTRUCTIONS
* HLT,DAA,CMC,CMA,DI,EI,STC
*****************************

OPR$00:
	CALL	PUT$COD$01
	CALL	GET$STR	
	JMP	L1413	

*****************************
* LXI
*****************************

OPR$01:
	CALL	G$OPRND$04
	CALL	G$COMMA
	CALL	G$ADDRESS
	JMP	L1413	

*****************************
* DAD
*****************************

OPR$02:
	CALL	G$OPRND$04
	JMP	L1413	

*****************************
* POP,PUSH
*****************************

OPR$03:
	CALL	G$OPRND$03
	CPI	'8'	
	JZ	OPR$03A	
	ANI	8
	CNZ	REG$ERROR
OPR$03A:
	MOV	A,C
	ANI	'0'
	ORA	B
	JMP	L1410

*****************************
* JMP,CALL
*****************************

OPR$04:
	CALL	PUT$COD$01
	CALL	G$ADDRESS
	JMP	L1413

*****************************
* MOV
*****************************

OPR$05:
	CALL	G$OPRND$03
	ORA	B
	MOV	B,A
	CALL	G$COMMA
	CALL	G$OPRND$02
	ORA	B
	JMP	L1410

*****************************
* MVI
*****************************

OPR$06:
	CALL	G$OPRND$03
	ORA	B
	CALL	PUT$COD$00
	CALL	G$COMMA
	CALL	G$OPRND$05
	JMP	L1413

*****************************
* XRI,SUI,SBI,
*****************************
OPR$07:
	CALL	PUT$COD$01
	CALL	G$OPRND$05
	JMP	L1413

*****************************
* STAX,LDAX
*****************************

OPR$08:
	CALL	G$OPRND$03
	ANI	'('		;
	CNZ	REG$ERROR
	MOV	A,C
	ANI	10H
	ORA	B
	JMP	L1410		;

*****************************
* STA,LDA,SHLD,LHLD
*****************************

OPR$09:
	CALL	PUT$COD$01
	CALL	G$ADDRESS
	JMP	L1413

*****************************
* XRA,SUB,SBB,ORA,ANA,ADC,ADD
*****************************

OPR$10:
	CALL	G$OPRND$02	;
	ORA	B
	JMP	L1410		;

*****************************
* INR,DCR
*****************************

OPR$11:
	CALL	G$OPRND$03
	ORA	B
	JMP	L1410

*****************************
* INX,DCX
*****************************
OPR$12:
	CALL	G$OPRND$03	;
	ANI	8
	CNZ	REG$ERROR	;
	MOV	A,C
	ANI	'0'		;
	ORA	B
	JMP	L1410		;

*****************************
* RST
*****************************

OPR$13:
	CALL	G$OPRND$03	;
	ORA	B
	JMP	L1410		;

*****************************
* IN,OUT
*****************************

OPR$14:
	CALL	PUT$COD$01	;
	CALL	G$OPRND$05	;
	JMP	L1413		;

L1410:				; 
	CALL	PUT$COD$00
L1413:				; 
	CALL	L15A5		;
	CALL	L1594		;
	JMP	END$LINE	;
L141C:				; 
	LDA	STR$TYPE	;
	CPI	4
	CNZ	DATA$ERR	;
	LDA	STRING		;
	CPI	','		;
	RZ
	CPI	';'		;
	RZ
	CPI	CR
	CNZ	DATA$ERR	;
	RET

***************************************
* LOOK FOR OPERAND (1433)
***************************************
;
; GET OPERAND, RETURN WITH LISTED VALUE IN REG H.
;
G$OPRND$00:			;LOOK FOR OPERAND
	PUSH	B
	CALL	GET$STR		;
	CALL	L0F17		;
	LHLD	L0161		;OPERAND VALUE
	POP	B
	RET
G$OPRND$01:
	CALL	G$OPRND$00	;
	MOV	A,H
	ORA	A
	CNZ	VALUE$ERR	;IF VALUE > 8 BITS, THEN ERROR.
	MOV	A,L
	RET
G$OPRND$02:
	CALL	G$OPRND$01	;
	CPI	8
	CNC	VALUE$ERR	;IF OPERAND > 8 THEN ERROR.
	ANI	7
	RET
G$OPRND$03:			; 
	CALL	G$OPRND$02	;
	RAL
	RAL
	RAL
	ANI	38H		;SHIFT LEFT AND MASK.
	MOV	C,A
	RET
G$OPRND$04:
	CALL	G$OPRND$03	;
	ANI	8
	CNZ	REG$ERROR	;
	MOV	A,C		;GET OPERAND CODE
	ANI	30H		;
	ORA	B		;MERGE WITH OPERATOR
	JMP	PUT$COD$00	;
G$OPRND$05:			; 
	CALL	G$OPRND$01	;
	JMP	PUT$COD$00
G$ADDRESS:			; 
	CALL	G$OPRND$00	;
	JMP	PUT$ADDR
G$COMMA:			; 
	PUSH	PSW
	PUSH	B
	LDA	STR$TYPE	;
	CPI	4
	JNZ	COMMA$ERR	;
	LDA	STRING		;
	CPI	','		;
	JZ	L1490		;
COMMA$ERR:			; 
	MVI	A,'C'		;COMMA ERROR. 43H
	CALL	ERR$COD		;
L1490:				; 
	POP	B
	POP	PSW
	RET
***************************************
* AFTER AN OPERATION IS DECODED, IT COMES
* TO THIS ROUTINE TO CLOSE OUT THE LINE
***************************************

END$LINE:			; 
	CALL	L15A5		;
	LDA	STR$TYPE	;
	CPI	4		;IS THIS TYPE OTHER
	JNZ	SYNTAX$ERR	;
	LDA	STRING		;
	CPI	CR		;IS THIS A CR.
	JNZ	E$LINE$00	;
	CALL	GET$STR		;YES THEN CLOSE LINE.
	JMP	MAIN$01		;AND RETURN TO MAIN$01. 10B1H	
E$LINE$00:			; 
	CPI	';'		; IS THIS A COMMENT? 
	JNZ	E$LINE$02	;
	CALL	L15A5		;
E$LINE$01:			; 
	CALL	GET$STR		; RUN OUT COMMENT.0805H
	LDA	STR$TYPE	;
	CPI	4
	JNZ	E$LINE$01	;DONE?
	LDA	STRING		;
	CPI	LF
	JZ	MAIN$01		;YES WE ARE DONE.
	CPI	1AH
	JZ	E$PASS		;
	CPI	'!'		;
	JZ	MAIN$01		;
	JMP	E$LINE$01	;
E$LINE$02:			; 
	CPI	'!'		;
	JZ	MAIN$01		;
	CPI	1AH
	JZ	E$PASS		;
SYNTAX$ERR:			; 
	MVI	A,'S'		;SYNTAX ERROR. 
	CALL	ERR$COD		;
	JMP	E$LINE$01	;
L14E6:				; 
	MOV	A,E
	SUB	L
	MOV	L,A
	MOV	A,D
	SBB	H
	MOV	H,A
	RET

***************************************
* END OF PASS
***************************************

E$PASS:				;
	XRA	A
	STA	LINE$NM
	INR	A
	STA	LINE$NM+1
	LXI	H,PASS$NM	;
	MOV	A,M
	INR	M
	ORA	A
	JZ	MAIN$00
	CALL	GET$STR		;
	CALL	L1641		;
	LXI	H,L1691		;
	MVI	M,CR
	LXI	H,NXT$FREE$ADDR	;
	CALL	MSGOUT		;
	LHLD	SYMTAB$PTR	;
	XCHG
	LHLD	SYM$TAB$BASE	;
	CALL	L14E6		;
	PUSH	H
	LHLD	L0006		;
	XCHG
	LHLD	SYM$TAB$BASE	;
	CALL	L14E6		;
	MOV	E,H
	MVI	D,0
	POP	H
	CALL	L0E36		;
	XCHG
	CALL	L1644		;
	LXI	H,L1691		;
	LXI	D,E$PASS$01	;
E$PASS$00:			; 
	LDAX	D
	ORA	A
	JZ	E$PASS$02	;
	MOV	M,A
	INX	H
	INX	D
	JMP	E$PASS$00	;
E$PASS$01: 
	DB	'H use factor',CR,0
E$PASS$02: 
	LXI	H,NXT$FREE$ADDR+1
	CALL	MSGOUT
	LHLD	L1688		;
	SHLD	LOC$CTR1	;
	LXI	H,LINE$NUM-1	;
E$PASS$03:			; 
	INX	H
	MOV	A,M
	CPI	' '		;
	JZ	E$PASS$03	;
	CALL	MSGOUT		;
	JMP	CLOSE$00	;
LINE$NM:
	DW	0100H
LINE$NUM: 
	DB	'        input lines read',CR

***************************************
* INCREMENT LINE NUMBER
***************************************

INC$LINE$NM: 
	LDA	PASS$NM		;IF PASS=0 THEN DONT INCR.
	ORA	A
	JZ	INC$LINE$01
	LXI	H,LINE$NUM+5
INC$LINE$00:
	MOV	A,M
	ORI	'0'
	INR	A
	MOV	M,A
	CPI	':'		;OVERFLOW?
	JC	INC$LINE$01	;NO EXIT
	MVI	M,'0'		;YES, RESET DECADE
	DCX	H		;AND INCR NEXT.
	JMP	INC$LINE$00
INC$LINE$01:
	LXI	H,LINE$NM+1
	MVI	A,1
	ADD	M
	DAA
	MOV	M,A
	DCX	H
	MVI	A,0
	ADC	M
	DAA
	MOV	M,A
	RET
***************************************
*
***************************************
L1594:				; 
	LHLD	LOC$CTR1	;
	SHLD	LOC$CTR2	;
	RET

**************************************
*
**************************************

L159B:				; 
	LHLD	L1686		;
	SHLD	SYM$HASH$PTR	;
	CALL	SYM$05		;
	RET

***************************************
*
***************************************

L15A5:				; 
	CALL	L159B		;
	RZ
	LXI	H,00H		;
	SHLD	L1686		;
	LDA	PASS$NM		;
	ORA	A
	JNZ	L15CC		;
	CALL	SYM$18		;
	PUSH	PSW
	ANI	7
	CNZ	LABLE$ERR	;
	POP	PSW
	ORI	1
	CALL	SYM$17		;
	LHLD	LOC$CTR2	;
	CALL	PUT$SYM$VAL		;
	RET
L15CC:				; 
	CALL	SYM$18		;
	ANI	7
	CZ	PHASE$ERR	;
	CALL	GET$SYM$VAL		;
	XCHG
	LHLD	LOC$CTR2	;
	CALL	CMP$LIM		;
	CNZ	PHASE$ERR	;
	RET

***************************************
* PUT CODE IN OBJECT & PRN LINES 
* AND MAINTAIN LOCATION COUNTERS
***************************************

PUT$COD$00:
	MOV	B,A		;MOVE OBJECT TO B
PUT$COD$01:
	LDA	PASS$NM		;GET PASS NUMBER
	ORA	A
	MOV	A,B
	JZ	L1607		;UPDATE LOCATION ONLY IF PASS 0.
	PUSH	B
	CALL	PUT$OBJ
	LDA	NXT$FREE$ADDR
	CPI	' '		;20H
	LHLD	LOC$CTR2
	CZ	L1644
	LDA	PRN$LINE$CCTR
	CPI	10H
	POP	B
	JNC	L1607
	MOV	A,B
	CALL	L1631
L1607:
	LHLD	LOC$CTR1
	INX	H
	SHLD	LOC$CTR1
	RET

***************************************
* PUT ADDRESS IN PRN LINE & OBJ
***************************************

PUT$ADDR:
	PUSH	H
	MOV	B,L
	CALL	PUT$COD$01
	POP	H
	MOV	B,H
	JMP	PUT$COD$01

***************************************
* HEX TO ASCII CONVERSION
***************************************

L1619:
	ADI	30H
	CPI	3AH
	RC
	ADI	7
	RET

***************************************
* PUT NIBBLE IN PRN LINE
***************************************

L1621:
	CALL	L1619
	LXI	H,PRN$LINE$CCTR
	MOV	E,M
	MVI	D,0
	INR	M
	LXI	H,PRN$LINE
	DAD	D
	MOV	M,A
	RET

***************************************
* PUT BYTE IN PRN LINE
***************************************

L1631:
	PUSH	PSW
	RAR
	RAR
	RAR
	RAR
	ANI	0FH
	CALL	L1621		;PUT UPPER
	POP	PSW
	ANI	0FH
	JMP	L1621		;PUT LOWER

***************************************
* PUT LOCATION IN PRN LINE
***************************************

L1641:
	LHLD	LOC$CTR2
L1644:
	XCHG
	LXI	H,PRN$LINE$CCTR
	PUSH	H
	MVI	M,1
	MOV	A,D
	PUSH	D
	CALL	L1631
	POP	D
	MOV	A,E
	CALL	L1631
	POP	H
	INR	M
	RET

***************************************
* ERROR ROUTINES
***************************************

REG$ERROR:
	PUSH	PSW
	PUSH	B
	MVI	A,'R'			;REGISTER ERROR
	CALL	ERR$COD
	POP	B
	POP	PSW
	RET
VALUE$ERR:
	PUSH	PSW
	PUSH	H
	MVI	A,'V'			;VALUE ERROR. 56H
	CALL	ERR$COD
	POP	H
	POP	PSW
	RET
DATA$ERR:
	PUSH	PSW
	MVI	A,'D'			;DATA ERROR. 44H
	JMP	L1681
PHASE$ERR:
	PUSH	PSW
	MVI	A,'P'			;PHASE ERROR. 50H
	JMP	L1681
LABLE$ERR:
	PUSH	PSW
	MVI	A,'L'			;LABLE ERROR. 4CH
	JMP	L1681
NOT$IMP$ERR:
	PUSH	PSW
	MVI	A,'N'			;NOT IMPLEMENTED. 4EH
L1681:
	CALL	ERR$COD
	POP	PSW
	RET
L1686:
	DW	0
L1688:
	DW	0
PRN$LINE$CCTR:
	DB	0
SYM$OPTION:
	DB	0
PRN$LINE:
	DB	0
NXT$FREE$ADDR:
	DB	0,0,0,0
L1691:
	DB	0
L1692: 
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0

IBUFR:				; STACK AND INPUT BUFFER

	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0

PRN$BUFR		EQU	IBUFR+1000H
OBJ$BUFR		EQU	PRN$BUFR+400H
SYM$HASH$LST		EQU	OBJ$BUFR+400H
SYM$TABLE		EQU	SYM$HASH$LST+100H
SYM$TAB			EQU	SYM$TABLE+2
	END
