REM	JOURNAL.BAS FIRST APPEARED IN THE FEBRUARY 1979 ISSUE
REM	OF KILOBAUD MAGAZINE...REQUIRES BASIC-E, CBASIC, OR CBASIC-2 FOR
REM	USE.  SEE THAT ISSUE OF KILOBAUD FOR INSTRUCTIONS.
REM
REM	COMPUTER JOURNAL RESOURCE LIBRARY
REM
REM		MAIN PROGRAM
REM
REM	     WRITTEN IN BASIC-E
REM
REM
REM
REM		NOV 26,1979
REM

	PRINT.LINE=1		:REM SAY PRNTR ON FIRST LINE
	LINES.PER.PAGE=66	:REM NAME SAYS IT ALL
	CLEAR.SCREEN=12		:REM DEF SCRN CLR CHAR.
	KEYBOARD.STAT.PORT=94	:REM DEFINE KBD STATUS PORT
	KBDMASK=128		:REM KEYBOARD BIT MASK
	KBD.TRUE=0		:REM ACTIVE LO
	KEYBOARD.DATA.PORT=92	:REM DEFINE KBD DATA PORT
	MAX.ENTRY=500		:REM DEFINE MAX LIB SIZE
	MAX.KEYS=8		:REM DEFINE MAX # KEYS/ENTRY
	EOF$=CHR$(26)		:REM DEFINE END OF FIL CHAR

	DIM INDEX$(MAX.ENTRY),MONTH$(12),KEY$(185),JOURNAL$(10)
	DIM CODE$(7),K$(MAX.KEYS),SPOOL(MAX.ENTRY)


	GOSUB 800	:REM SIGN-ON MESSAGE
	PRINT TAB(24);"Please Stand By . . . .":PRINT:PRINT

REM	READ NECESSARY INFORMATION FROM DATA STATEMENTS

	FOR I=1 TO 100
		READ JOURNAL$(I)
		IF JOURNAL$(I)="0" THEN 10
	NEXT I
10	NM=I-1

	FOR I=1 TO 12
		READ MONTH$(I)
	NEXT I

	FOR I=1 TO 400
		READ KEY$(I)
		IF KEY$(I)="0" THEN 20
	NEXT I
20	NK=I-1

REM		DEFINE FIRST LETTERS OF VALID COMMANDS

	CODE$(1)="A"
	CODE$(2)="C"
	CODE$(3)="D"
	CODE$(4)="F"
	CODE$(5)="Q"
	CODE$(6)="S"
	CODE$(7)="L"


	DATALIB$="CMAGDATA.LIB"	:INDXLIB$="CMAGINDX.LIB"
	FILE DATALIB$(128),INDXLIB$(2*MAX.KEYS+4)

REM		READ INDEX FILE FROM DISK

	IF END #2 THEN 30
	FOR I=1 TO MAX.ENTRY
		READ #2,I;INDEX$(I)
		IF INDEX$(I)="0" THEN NULL=NULL+1
	NEXT I
30	EXTENT=I-1
	INDEX$(I)="0"
	IF EXTENT>0 THEN 35

REM		ARRIVE HERE IF EMPTY INDEX FILE ON DISK

	INPUT "Can't find Index File - is this new library?";A$
	IF LEFT$(A$,1)="Y" THEN 35

REM		FORM NEW INDEX FILE
31	GOSUB 32
	GOTO 35

32	PRINT TAB(21);"Forming a new Index"
	PRINT:PRINT:PRINT:PRINT

	NULL=0
	IF END #1 THEN 33
	FOR I=1 TO MAX.ENTRY-1
		READ #1,I;DUM$,DUM$,DUM$,DUM$,DUM$,INDEX$(I)
		IF INDEX$(I)="0" THEN NULL=NULL+1
	NEXT I
33	EXTENT=I-1
	INDEX$(I)="0"
	GOSUB 410
	RETURN

REM		COMMAND MODE ENTRY POINT

35	GOSUB 800	:REM SIGN-ON MESSAGE
	PRINT TAB(11);"Size of Library is currently ";\
	EXTENT-NULL;" entries": PRINT:PRINT

40	FOR J=1 TO 1 STEP 0
	PRINT
	INPUT "Command: ";COM$
	FOR I=1 TO 7
		IF LEFT$(COM$,1)=CODE$(I) THEN \
		ON I GOTO 100,200,300,31,400,500,600
	NEXT I

REM	ARRIVE HERE IF INVALID COMMAND WAS ENTERED

	PRINT CHR$(CLEAR.SCREEN)
	PRINT "Commands:"
	PRINT "---------"
	PRINT "A dd an entry"
	PRINT "C hange an entry"
	PRINT "D elete an entry"
	PRINT "F orm a new Index"
	PRINT "L ist Keys or Journals"
	PRINT "Q uit the Library"
	PRINT "S earch the Library"
	NEXT J
	STOP

REM		ADD AN ENTRY TO LIBRARY

	FOR I=1 TO 1 STEP 0

100	PRINT CHR$(CLEAR.SCREEN)
	PRINT TAB(18); "(Room for approximately ";
	PRINT INT ((FRE-300)/150)*10;" entries remains)"
	PRINT:PRINT
101	INPUT "Journal: ";MG$
	IF LEFT$(MG$,1)="0" THEN GOTO 35
	EM=0	:GOSUB 120
	IF EM=1 THEN 101
102	INPUT "Date: ";DATE$
	IF DATE$="0" THEN 35
	ED=0	:GOSUB 130
	IF ED=1 THEN 102
	INPUT "Page number: ";PAGE$
108	INPUT "Title:";TITLE$
	IF TITLE$="0" THEN 35
	INPUT "Author:";AUTHOR$
	IF AUTHOR$="0" THEN 35
	FLAG=0	:GOSUB 160	:REM CHECK RCD LENGTH
	IF FLAG=1 THEN 108
	GOSUB 750		:REM INSRT "," WHERE NEC.
	FOR J=1 TO MAX.KEYS:K$(J)="":NEXT J
	FOR J=1 TO MAX.KEYS
103		INPUT "Key:";K$(J)
		IF K$(J)="0" THEN K$(J)="":GOTO 105
		EK=0	:GOSUB 140
		IF EK=1 THEN 103
	NEXT J
	PRINT:PRINT
	PRINT TAB(18);"That is all the Keys allowed"
	PRINT:PRINT

105	GOSUB 110	:REM CONSTRUCT KEY VECTOR

REM		FIND FIRST EMPTY SLOT IN FILE

	FOR J=1 TO MAX.ENTRY-1
		IF INDEX$(J)="0" THEN 107
	NEXT J
	PRINT:PRINT"	No more room in Library":PRINT:\
	  GOTO 35

REM		WRITE NEW ENTRY TO FILE

107	INDEX$(J)=KY$	:REM UPDATE KEY IN INDEX
	GOSUB 900

REM		IF FILE EXTENT EXPANDS, WRITE NEW EOF

	IF J>EXTENT THEN :\
	  EXTENT=J:\
	  PRINT #1,(EXTENT+1);EOF$:\
	  INDEX$(J+1)="0":\
	  GOTO 109
	NULL=NULL-1
109	NEXT I

REM		CONSTRUCT SEARCH VECTOR

110	KY$=""
	FOR II=1 TO MAX.KEYS
		KY$=KY$+K$(II)
	NEXT II
	RETURN

REM		ENCODE JOURNAL

120	FOR II=1 TO NM
		IF LEFT$(MG$,3)=LEFT$(JOURNAL$(II),3) THEN 121
	NEXT II
	PRINT:PRINT"	Invalid Journal":PRINT:\
	  EM=1:RETURN
121	IF II<10 THEN 123
	MG$=LEFT$(STR$(II),2):RETURN
123	MG$="0"+LEFT$(STR$(II),1):RETURN

REM		ENCODE MONTH

130	IF LEN(DATE$)<5 THEN 130.5
	A$=LEFT$(DATE$,3)
	A1$=LEFT$(DATE$,1)
	A2=ASC(MID$(A$,2,1))
	A3=ASC(MID$(A$,3,1))
	A2=A2 OR 32	:A3=A3 OR 32
	A$=A1$+CHR$(A2)+CHR$(A3)
	FOR II=1 TO 12
		MNTH$=LEFT$(MONTH$(II),3)
		IF MNTH$=A$ THEN 131
	NEXT II
130.5	PRINT:PRINT"	Invalid date":PRINT
	PRINT	:ED=1	:RETURN

131	IF II<10 THEN 134
	B$=LEFT$(STR$(II),2)	:GOTO 136
134	B$="0"+LEFT$(STR$(II),1)
136	DATE$=RIGHT$(DATE$,2)+B$	:RETURN

REM		ENCODE KEY

140	FOR II=1 TO NK
		IF K$(J)=KEY$(II) THEN 150
	NEXT II
	PRINT:PRINT"	Invalid key":PRINT:\
	  EK=1	:RETURN
150	KK=0
	FOR JJJ=1 TO 26
		IF II<26 THEN 155
		II=II-26:KK=KK+1
	NEXT JJJ
155	IF KK=0 THEN S1$="0":GOTO 157
	S1$=CHR$(64+KK)
157	IF II=0 THEN K$(J)=S1$+"0"	:RETURN
	K$(J)=S1$+CHR$(64+II)
	RETURN

REM		CHECK LENGTH OF RECORD

160	RECORD.LENGTH=23+2*MAX.KEYS+LEN(TITLE$)+LEN(PAGE$)+\
	  LEN(AUTHOR$)
	IF RECORD.LENGTH < 127 THEN FLAG=0	:RETURN
	PRINT
	PRINT "Input is too long -Shorten title & author by ";\
	  RECORD.LENGTH-126;" characters.":FLAG=1	:RETURN

REM	CHANGE AN ENTRY

200	A$="Changed"	:IS=0
	GOSUB 310	:REM FIND DESIRED ENTRY
	IF IS=1 THEN 40
	TEMP.POINTER=J	:REM SAVE POINTER TO RANDOM FILE
	TEMP.INDEX.STORE$=INDEX$(TEMP.POINTER)

	PRINT "Here are the Keys for this entry:"
	PRINT	:GOSUB 220	:REM PRINT KEYS
	PRINT

204	INPUT "What item to be changed? ";A$
	A$=LEFT$(A$,1)
	IF A$<>"0" THEN 205
	FLAG=0	:GOSUB 160
	IF FLAG=1 THEN 204
	IF COMMA.FLAG=1 THEN COMMA.FLAG=0:GOSUB 750
	  :REM REPLACE "/"'S WITH ","'S
	PRINT "Here is the updated entry":PRINT
	GOSUB 541
	PRINT:PRINT"Here are the keywords:":PRINT
	GOSUB 220	:REM PRINT KEYS
	PRINT
	PRINT "Do you want to: A bort the edit, C hange";
	INPUT " another item, or are you D one: ";A$
	A$=LEFT$(A$,1)
	IF A$="D" THEN J=TEMP.POINTER:GOSUB 900:\
	  GOTO 35	:REM SAVE IT
	IF A$="C" THEN 204
	INDEX$(TEMP.POINTER)=TEMP.INDEX.STORE$
	GOTO 35
205	IF A$="K" THEN 213
	INPUT "What should this item be:";B$
	IF B$="0" THEN 204
	EM=0
	IF A$<>"J" THEN 209
	TEMP$=MG$	:MG$=B$	:GOSUB 120
	IF EM=1 THEN MG$=TEMP$
	GOTO 204
209	IF A$="T" THEN TITLE$=B$:COMMA.FLAG=1:GOTO 204
	IF A$="P" THEN PAGE$=B$	:GOTO 204
	ED=0
	IF A$<>"D" THEN 210
	TEMP$=DATE$	:DATE$=B$	:GOSUB 130
	IF ED=1 THEN DATE$=TEMP$
	GOTO 204
210	IF A$="A" THEN AUTHOR$=B$:COMMA.FLAG=1:GOTO 204
	IF A$<>"K" THEN 218
213	INPUT "Add, Change, or Delete a key: ";A$
	A$=LEFT$(A$,1)
	IF A$="C" THEN 214
	IF A$="D" THEN 231
	IF A$<>"A" THEN 218

REM		ADD A NEW KEY

212	J=1: INPUT "What is the key: ";K$(J)
	IF K$(J)="0" THEN 204
	EK=0:GOSUB 140
	IF EK=1 THEN 212
	IF LEN(KY$)=2*MAX.KEYS THEN \
	  PRINT "No more keywords allowed for this entry":\
	  PRINT:GOTO 204

REM		INSERT NEW KEYWORD

	KY$=KY$+K$(J)
	INDEX$(TEMP.POINTER)=KY$	:REM UPDATE INDEX LIST
	GOTO 204

214	J=1	:INPUT "Old key: ";K$(J)
	IF K$(J)="0" THEN 204
	EK=0	:GOSUB 140
	IF EK=1 THEN 213

REM		FIND THIS KEY IN KEYWORD

	FOR I=1 TO (LEN(KY$)/2)
		IF K$(J)=MID$(KY$,2*I-1,2) THEN 215
	NEXT I
	PRINT "This keyword not applicable to this entry":\
	  GOTO 204
215	INPUT "New key: ";K$(J)
	IF K$(J)="0" THEN 204
	EK=0	:GOSUB 140
	IF EK=1 THEN 215

REM		MAKE CHANGE IN KEY

	IF 2*I=LEN(KY$) THEN K2$="":GOTO 216
	K2$=RIGHT$(KY$,LEN(KY$)-2*I)
216	IF I=1 THEN K1$="":GOTO 217
	K1$=LEFT$(KY$,(I-1)*2)
217	KY$=K1$+K$(J)+K2$	:REM FORM NEW KEY

	INDEX$(TEMP.POINTER)=KY$	:REM UPDATE INDEX LISTG
	GOTO 204

REM		DELETE AN EXISTING KEYWORD

231	J=1:INPUT "What is the keyword to be deleted: ";K$(J)
	IF K$(J)="0" THEN 204
	EK=0:GOSUB 140
	IF EK=1 THEN 204

REM		FIND KEYWORD IN KEY

	FOR I=1 TO (LEN(KY$)/2)
		IF MID$(KY$,2*I-1,2)=K$(J) THEN 237
	NEXT I
235	PRINT
	PRINT "This key not applicable to this entry."
	GOTO 204

REM		DELETE THE KEYWORD

237	IF 2*I=LEN(KY$) THEN K2$="":GOTO 238
	K2$=RIGHT$(KY$,LEN(KY$)-2*I)
238	IF I=1 THEN K1$="":GOTO 238.5
	K1$=LEFT$(KY$,2*I-1)
238.5	KY$=K1$+K2$
	INDEX$(JJ)=KY$
	GOTO 204

218	PRINT "Invalid input."
	GOTO 204

REM		PRINT AN ENTRY'S KEYWORDS

220	FOR II=1 TO (LEN(KY$)/2)
		PRINT TAB((((II-INT((II-1)/3)*3)-1)*20)+1);:\
		  GOSUB 700	:REMARK DECODE KEY
		PRINT KEY$(STRING.NO);
	IF INT(II/3)=II/3 THEN PRINT
	NEXT II
	IF INT(I/3)<>I/3 THEN PRINT
221	PRINT	:RETURN

REM		DELETE AN ENTRY

300	IS=0	:A$="Deleted."
	GOSUB 310	:REM FIND AN ENTRY
	IF IS=1 THEN GOTO 35	:REM FOUND WRONG ENTRY

REM		DELETE KEY FROM INDEX

	INDEX$(J)="0"
	NULL=NULL+1

REM		CLEAR ENTRY FROM FILE

	KY$="0"	:GOSUB 900

	PRINT CHR$(CLEAR.SCREEN)
	PRINT "	Entry deleted from Library.":PRINT
	PRINT:PRINT:GOTO 35

310	PRINT CHR$(CLEAR.SCREEN)
	PRINT "What is the number of the entry to be ";A$
	INPUT "	(Obtained from the most recent Search)	";I
	IF I=0 THEN 40
	IF I>NUMBER.SPOOL THEN PRINT:PRINT:\
	  PRINT "	Invalid entry number.":\
	  GOTO 312
	J=SPOOL(I)
	IF J>EXTENT THEN 312
	PRINT:PRINT"Is this the correct entry: ":PRINT:PRINT
	M=I:GOSUB 540	:REM PRINT THE ENTRY
	KY$=DUM$
	INPUT N$:N$=LEFT$(N$,1)
	IF N$="Y" THEN RETURN

312	PRINT:PRINT "Conduct another Search and repeat."
	PRINT:IS=1:RETURN

REM		QUIT THE LIBRARY

400	PRINT CHR$(CLEAR.SCREEN)
	PRINT TAB(17);"This session is terminated...Bye!"\
	  :PRINT:PRINT:PRINT:PRINT:PRINT
	STOP

410	PRINT TAB(18);"Saving updated index file.":PRINT:PRINT
	PRINT:PRINT
	FOR I=1 TO EXTENT
		PRINT #2,I;INDEX$(I)
	NEXT I
	PRINT #2,I;EOF$
	RETURN

REM		SEARCH THE LIBRARY

500	PRINT CHR$(CLEAR.SCREEN)
	FOR J=1 TO MAX.KEYS
		K$(J)=""
	NEXT J
	FOR J=1 TO MAX.KEYS
501		INPUT "Key: ";K$(J)
		IF LEFT$(K$(J),1)="0" THEN K$(J)="":GOTO 503
		EK=0:GOSUB 140
		IF EK=1 THEN 501
	NEXT J

503	GOSUB 110	:REM CONSTRUCT SEARCH VECTOR

	PRINT "If you want hardcopy, type 'YES' "
	INPUT "Otherwise type 'NO'";PRINTER.FLAG$
	PRINTER.FLAG$=LEFT$(PRINTER.FLAG$,1)
	IF PRINTER.FLAG$="Y" THEN\
	  LPRINTER:\
	  GOSUB 920:\
	  GOTO 503.5
	PRINT CHR$(CLEAR.SCREEN)
503.5	GOSUB 509	:REM PRINT A LINE OF -----'S
	PRINT:GOSUB 910
	IF KY$<>"" THEN 504
	PRINT TAB(13);"Complete Listing of all Entries"
	GOSUB 910:GOTO 505
504	PRINT"	Library Search for Articles Related to:"
	PRINT:GOSUB 910:GOSUB 910
	FOR II=1 TO (LEN(KY$)/2)
		PRINT TAB(16);"-";
		PRINT TAB(18);
		GOSUB 700	:REM DECODE KEY
		PRINT KEY$(STRING.NO):GOSUB 910
	NEXT II
505	PRINT:GOSUB 910
	GOSUB 510 :REM SRCH INDX FIL & PRNT SELECTED ENTRIES
	IF NUMBER.SPOOL=0 THEN PRINT TAB(20);\
	  "No such articles in Library.":GOSUB 910
	PRINT	:GOSUB 910:GOSUB 509
	REM PRINT A LINE OF ----'S
	PRINT	:PRINT:GOSUB 910:GOSUB 910
506	IF PRINTER.FLAG$<>"Y" THEN 40
	PRINT:GOSUB 910
507	CONSOLE
	GOTO 35

REM		PRINT A LINE OF -----'S

509	DASHES=64
	IF PRINTER.FLAG$="Y" THEN DASHES=72
	FOR I=1 TO DASHES
		PRINT "-";
	NEXT I
	PRINT:GOSUB 910
	RETURN

REM		SEARCH INDEX FILE

510	M=1
	GOSUB 530	:REM CLEAR SPOOL MATRIX
511	NUMBER.SEARCH.KEYS=(LEN(KY$)/2)
	FOR J=1 TO EXTENT
		IF LINES.PER.PAGE-PRINT.LINE<8 THEN GOSUB 920
		IF INDEX$(J)="0" THEN 519
		IF NUMBER.SEARCH.KEYS=0 THEN 516
513		NUMBER.INDEX.KEYS=(LEN(INDEX$(J))/2)
		FOR I=1 TO NUMBER.SEARCH.KEYS
			FOR K=1 TO NUMBER.INDEX.KEYS
				IF MID$(KY$,2*I-1,2)=\
				  MID$(INDEX$(J),2*K-1,2)\
				  THEN 515
			NEXT K
			GOTO 519
515		NEXT I
516		SPOOL(M)=J
		GOSUB 540	:REM PRINT ENTRY
		M=M+1
519		ABORT.FLAG=0
		GOSUB 550	:REM POLL KEYBOARD
		IF ABORT.FLAG=1 THEN 520
	NEXT J
520	NUMBER.SPOOL=M-1
	RETURN

REM		CLEAR SPOOL MATRIX

530	FOR I=1 TO EXTENT
		SPOOL(I)=0
	NEXT I
	RETURN

REM		PRINT AN ENTRY

540	READ #1,J;MG$,DATE$,PAGE$,TITLE$,AUTHOR$,DUM$
541	PRINT M;".";
	PRINT TAB(7);JOURNAL$(VAL(MG$));
	PRINT TAB(25);
	IF LEN(TITLE$)<DASHES-26 THEN PRINT TITLE$:\
	  GOSUB 910:GOTO 545

REM		BREAK TITLE INTO MULTIPLE LINES

	TEMP.TITLE$=TITLE$
542	FOR JJ=DASHES-26 TO 1 STEP -1
		IF MID$(TEMP.TITLE$,JJ,1)=" " THEN 543
	NEXT JJ
543	TITLE1$=LEFT$(TEMP.TITLE$,JJ-1)
	TITLE2$=RIGHT$(TEMP.TITLE$,LEN(TEMP.TITLE$)-JJ)
	PRINT TITLE1$:GOSUB 910:PRINT TAB(25);
	IF LEN(TITLE2$)<DASHES-26 THEN PRINT TITLE2$:\
	  GOSUB 910:GOTO 545
	TEMP.TITLE$=TITLE2$	:GOTO 542

545	PRINT TAB(7);MONTH$(VAL(RIGHT$(DATE$,2)));" 19";
	PRINT LEFT$(DATE$,2);
	PRINT TAB(25);"by ";AUTHOR$:GOSUB 910
	PRINT TAB(7);"Page ";PAGE$:GOSUB 910
	PRINT:GOSUB 910
	RETURN

REM		KEYBOARD POLL ROUTINE TO BREAK LISTING
REM			(TYPE "0" TO ABORT)

550	IF INP(KEYBOARD.STAT.PORT) AND KBDMASK <> KBD.TRUE\
	  THEN RETURN
	IF (INP(KEYBOARD.DATA.PORT)AND 127) <> 48 THEN RETURN
	GOSUB 509	:REM PRINT LINE OF DASHES
	IF PRINTER.FLAG$ = "Y" THEN 507
	ABORT.FLAG=1	:RETURN

REM		LIST KEYS AND/OR JOURNALS IN LIBRARY

600	PRINT CHR$(CLEAR.SCREEN)
	INPUT "Do you want a list of keys or journals";A$
	PRINT CHR$(CLEAR.SCREEN)
	A$=LEFT$(A$,1)
	IF A$="J" THEN 620
	IF A$<>"K" THEN 35

REM		LIST KEYS

	FOR I=1 TO NK
		PRINT TAB((((I-INT((I-1)/3)*3)-1)*20)+1);\
		  KEY$(I);
		IF INT(I/3)=I/3 THEN PRINT
		IF INT(I/42)=I/42 THEN GOSUB 650
		IF A$="0" THEN GOTO 35
	NEXT I
	IF INT(I/3)=I/3 THEN PRINT
	PRINT	:GOSUB 650	:GOTO 35

REM		LIST JOURNALS

620	FOR I=1 TO NM
		PRINT TAB((((I-INT((I-1)/3)*3)-1)*20)+1);\
		  JOURNAL$(I);
		IF INT (I/3)= I/3 THEN PRINT
		IF INT(I/42)=I/42 THEN GOSUB 650
	NEXT I
	IF INT(I/3)<>I/3 THEN PRINT
	PRINT	:GOSUB 650	:GOTO 35

REM		PAUSE ROUTINE

650	INPUT "Type 'C' to continue";A$
	RETURN

REM		DECODE A KEY

700	S1$=MID$(KY$,2*II-1,1):S2$=MID$(KY$,2*II,1)
	IF S1$="0" THEN S1=0:GOTO 720
	S1=(ASC(S1$)-64)*26
720	IF S2$="0" THEN S2=0	:GOTO 740
	S2=ASC(S2$)-64
740	STRING.NO=S1+S2
	RETURN

REM		SUBSTITUTE "," FOR "/" IN TITLE AND AUTHOR

750	FOR L=1 TO LEN(TITLE$)
		IF MID$(TITLE$,L,1)<>"/" THEN 760
		TIT.LEFT$=LEFT$(TITLE$,L-1)
		TIT.RIGHT$=RIGHT$(TITLE$,(LEN(TITLE$)-L))
		TITLE$=TIT.LEFT$+","+TIT.RIGHT$
760	NEXT L
	FOR L=1 TO LEN(AUTHOR$)
		IF MID$(AUTHOR$,L,1)<>"/" THEN 770
		AUT.LEFT$=LEFT$(AUTHOR$,L-1)
		AUT.RIGHT$=RIGHT$(AUTHOR$,(LEN(AUTHOR$)-L))
		AUTHOR$=AUT.LEFT$+","+AUT.RIGHT$
770	NEXT L
	RETURN

REM		DISPLAY SIGN-ON MESSAGE

800	PRINT CHR$(CLEAR.SCREEN)
	PRINT "         -------------------------------------"
	PRINT "         | COMPUTER JOURNAL RETRIEVAL SYSTEM |"
	PRINT "         -------------------------------------"
	PRINT	:PRINT	:PRINT
	RETURN

REM		WRITE AN ENTRY TO DATA FILE

900	PRINT #1,J;MG$,DATE$,PAGE$,TITLE$,AUTHOR$,KY$
	PRINT #2,J;INDEX$(J)
	RETURN

	REM PRINTER LINE INCREMENT

910	IF PRINTER.FLAG$<>"Y" THEN RETURN
	PRINT.LINE=PRINT.LINE+1
	IF PRINT.LINE>66 THEN PRINT.LINE=1
	RETURN

	REM FORMFEED

920	IF PRINT.LINE=3 THEN RETURN
	PRINT:GOSUB 910:GOTO 920


REM			*** DATA SECTION ***

REM		JOURNAL LIST

	DATA	BYTE,KB,CC,DDJ,PC,IA,0

REM		MONTH LIST

	DATA	January,February,March,April,May,June
	DATA	July,August,September,October,November
	DATA	December

REM		KEY WORD LIST

	DATA	8080,6800,6502,1802,68000,8085,8086

	DATA	ART,AUTOS,APPLIANCES,ARTIFICIAL INTELLIGENCE
	DATA	APPLE,ATARI,APL,ASSEMBLER,AUDIO,ANIMATION
	DATA	ALGOL,ASCII,ALGORITHM,APPLICATIONS

	DATA	BASIC,BALLY,BUSINESS,BENCHMARK,BUS,BOARD

	DATA	C,CPU,CLOCK,CROMEMCO,CONSTRUCTION,COBOL
	DATA	CBASIC,CALCULATOR,CASSETTE,COMPILER
	DATA	CRYPTOGRAPHICS,COMPONENTS,CHIPS

	DATA	DEBUG,DISASSEMBLER,DISK,DATA,DBMS,DRIVER
	DATA	DOCUMENTATION,DISCUSSION,DESIGN,DIAGNOSTIC

	DATA	EDUCATION,EXIDY,EDITING,ELECTRONIC GAMES
	DATA	EXPANSION

	DATA	FICTION,FORTRAN,FRONT PANEL,FLEX
	DATA	FILES,FINANCE,FAIRS,FLOWCHARTING

	DATA	GRAPHICS,GENEALOGY,GAME,GODBOUT

	DATA	HARDWARE,HANDICAPPED,HEATH,HOME,HISTORY
	DATA	HUMOR

	DATA	IMSAI,INTERRUPT,ITHICA,I/O,INPUT
	DATA	INTELASM,INTERPRETER,INTERVIEW,INTERFACE

	DATA	KEYBOARD,KIM

	DATA	LINGUISTICS,LANGUAGE,LARGE,LAW,LEDGER,LISP

	DATA	MUSIC,MONITER,MICROPROGRAMMING,MICROPOLIS
	DATA	MAINFRAME,MINICOMPUTER,MBASIC,MACASM
	DATA	MATH,MEMORY,MATRIX,MULTI-TASKING,MISCELLANEOUS
	DATA	MODIFICATION

	DATA	NORTHSTAR

	DATA	OPERATING SYSTEM,OBJECT,OUTPUT

	DATA	PROGRAM,PASCAL,PILOT,PET,PRINTER,PROM,PENCIL
	DATA	PAYROLL,PROCESSING,PROGRAMMING,PACE,PROTECTION

	DATA	RS232,RANDOM,ROUTINES,REVIEW,ROBOTICS
	DATA	REAL-WORLD

	DATA	SOFTWARE,SYS8,SOL,SWTP,SSM,SD SALES,STRUCTURE
	DATA	STRUCTURED,STACK,S100,SS50,SORT,SORTING,SOURCE
	DATA	SYSTEM,STANDARDS,SECURITY,SOLDERING,SMALL

	DATA	TEXT,TEXT EDITOR,TRS80,TARBELL,TERMINAL
	DATA	TELEPHONE,TECHNIQUE,TDLASM,THEORY,TIMESHARING
	DATA	TUTORIAL,TROUBLESHOOTING

	DATA	UTILITIES

	DATA	VIDEO

	DATA	WORD,WORD PROCESSING,WIRE WRAP

	DATA	Z80,Z8000
	DATA	A/D,PAPER TAPE,PUZZLE,8008,ARCHETECTURE
	DATA	MICROPROCESSOR,MASS STORAGE,POWER SUPPLY
	DATA	MEDICINE,WEATHER,SIMULATION

	DATA	0
