	ORG	00100H
X0000	EQU	00000H
Y0001	EQU	00001H
SYSTEM	EQU	00005H
Y005D	EQU	0005DH
Y007C	EQU	0007CH
	JP	SYSGEN
;
COPWRT:	DEFM	'COPYRIGHT (C) 1978, DIGITAL RESEARCH '
;
MAXTRK:	DEFB	2	;system image resides in first 2 tracks
MAXSEC:	DEFB	26		;8 inch - 26 sectors per track
SECTAB:	DEFB	1,2,3
	DEFB	4,5,6
	DEFB	7,8,9
	DEFB	10,11,12
	DEFB	13,14,15
	DEFB	16,17,18
	DEFB	19,20,21
	DEFB	22,23,24
	DEFB	25,26
	DEFB	0,0,0
	DEFB	0,0,0
	DEFB	0,0,0
	DEFB	0,0,0
	DEFB	0,0,0
	DEFB	0,0,0
	DEFB	0,0,0
	DEFB	0,0,0
	DEFB	0,0,0
	DEFB	0,0,0
	DEFB	0,0,0
	DEFB	0,0,0
	DEFB	0,0
;
;	routine to multiply the A register by 128
;	and return the results in the HL register paair
;
A016A:	LD	L,A
	LD	H,000H		;*1
	ADD	HL,HL		;*2
	ADD	HL,HL		;*4
	ADD	HL,HL		;*8
	ADD	HL,HL		;*16
	ADD	HL,HL		;*32
	ADD	HL,HL		;*64
	ADD	HL,HL		;*128
	RET

;
;	routine to get an  input character from console
;	and convert to upper  case if lower case entered
;
GCHAR:	LD	C,001H
	CALL	SYSTEM		;get input
	CP	'a'		;lower case ?
	RET	C		;no - return
	CP	'z'+1
	RET	NC		;no - return
	AND	05FH		;yes - convert to upper case
	RET			;and return
;
;	routine to put character passed in A reg
;	on system console
;
PCHAR:	LD	E,A		;sys function wants char in E
	LD	C,002H
	CALL	SYSTEM		;put on system console
	RET
;
;	routine to print a CR and a LF on
;	the system console
;
PCRLF:	LD	A,00DH		;print a carriage return
	CALL	PCHAR
	LD	A,00AH		;print a line feed
	CALL	PCHAR
	RET
;
PMSG:	PUSH	HL
	CALL	PCRLF		;prefix a CR and a LF
	POP	HL
PMSG1:	LD	A,(HL)
	OR	A		;set flags
	RET	Z		;return if delimiter
	PUSH	HL		;not delimiter - print it
	CALL	PCHAR		;print character
	POP	HL
	INC	HL		;point to next char. in string
	JP	PMSG1		;loop for whole string
;
;	routine to select disk requested in reg A
;
SELDSK:	LD	C,A		;to proper argument register
	LD	HL,(Y0001)	;get warm start adr
	LD	DE,00018H	;and select disk vector
	ADD	HL,DE		;compute address
	JP	(HL)		;and do it
;
;	routine to set desired track for read or write
;		BC reg = desired track number (0-76)
;
SETTRK:	LD	HL,(Y0001)	;get warm start address
	LD	DE,0001BH	;and set track vector
	ADD	HL,DE		;compute address
	JP	(HL)		;and do it
;
;	routine to set desired sector for read or write
;		BC reg = desired sector number (1-26)
;
SETSEC:	LD	HL,(Y0001)	;get warm start address
	LD	DE,0001EH	;and set sector vector
	ADD	HL,DE		;compute address
	JP	(HL)		;and do it
;
;	routine to set desired dma address for read or write
;		BC reg = dma address
;
SETDMA:	LD	HL,(Y0001)	;get warm start address
	LD	DE,00021H	;and set dma vector
	ADD	HL,DE		;compute address
	JP	(HL)		;and do it
;
;	routine to read a disk sector
;
RDSEC:	LD	HL,(Y0001)	;get warm start address
	LD	DE,00024H	;and read sector vector
	ADD	HL,DE		;compute address
	JP	(HL)		;and do it
;
;	routine to write a disk sector
;
WRTSEC:	LD	HL,(Y0001)	;get warm start address
	LD	DE,00027H	;and write sector vector
	ADD	HL,DE		;compute address
	JP	(HL)		;and do it
;
;	routine to read next sequential sector of a file
;		DE reg = FCB address
;
RDSEQ:	LD	C,014H
	JP	SYSTEM
;
;	routine to open a file
;		DE reg = FCB address
;
OPNFIL:	LD	C,00FH
	JP	SYSTEM
;
A01E1:	LD	HL,00900H
	LD	(DMAADR),HL
	LD	A,0FFH
	LD	(D04A7),A
A01EC:	LD	HL,D04A7
	INC	(HL)
	LD	A,(MAXTRK)
	CP	(HL)
	JP	Z,A0277
	LD	C,(HL)
	CALL	SETTRK
	LD	A,0FFH
	LD	(D04A8),A
A0200:	LD	A,(MAXSEC)
	LD	HL,D04A8
	INC	(HL)
	CP	(HL)
	JP	Z,A0266
	LD	HL,D04A8
	LD	E,(HL)
	LD	D,000H
	LD	HL,SECTAB
	LD	B,(HL)
	ADD	HL,DE
	LD	C,(HL)
	PUSH	BC
	CALL	SETSEC
	POP	BC
	LD	A,C
	SUB	B
	CALL	A016A
	EX	DE,HL
	LD	HL,(DMAADR)
	ADD	HL,DE
	LD	B,H
	LD	C,L
	CALL	SETDMA
	XOR	A
	LD	(ERRCNT),A
A022F:	LD	A,(ERRCNT)
	CP	00AH
	JP	C,A024B
	LD	HL,T0418
	CALL	PMSG1
	CALL	GCHAR
	CP	00DH
	JP	NZ,A0363
	CALL	PCRLF
	JP	A0200
;
A024B:	INC	A
	LD	(ERRCNT),A
	LD	A,(D04A9)
	OR	A
	JP	Z,A025C
	CALL	WRTSEC
	JP	A025F
;
A025C:	CALL	RDSEC
A025F:	OR	A
	JP	Z,A0200
	JP	A022F
;
A0266:	LD	A,(D0129)
	CALL	A016A
	EX	DE,HL
	LD	HL,(DMAADR)
	ADD	HL,DE
	LD	(DMAADR),HL
	JP	A01EC
;
A0277:	RET
;
SYSGEN:	LD	SP,WRKSTK
	LD	HL,T0375
	CALL	PMSG1
	LD	A,(Y005D)
	CP	020H
	JP	Z,A02D6
	LD	DE,0005CH
	CALL	OPNFIL
	INC	A
	JP	NZ,A029C
	LD	HL,T0478
	CALL	PMSG
	JP	A0363
;
A029C:	XOR	A
	LD	(Y007C),A
	LD	C,010H
A02A2:	PUSH	BC
	LD	DE,0005CH
	CALL	RDSEQ
	POP	BC
	OR	A
	JP	NZ,A02CD
	DEC	C
	JP	NZ,A02A2
	LD	HL,00900H
A02B5:	PUSH	HL
	LD	B,H
	LD	C,L
	CALL	SETDMA
	LD	DE,0005CH
	CALL	RDSEQ
	POP	HL
	OR	A
	JP	NZ,A031C
	LD	DE,00080H
	ADD	HL,DE
	JP	A02B5
;
A02CD:	LD	HL,T048F
	CALL	PMSG
	JP	A0363
;
A02D6:	LD	HL,T0384
	CALL	PMSG
	CALL	GCHAR
	CP	00DH
	JP	Z,A031C
	SUB	041H
	CP	004H
	JP	C,A02F1
	CALL	INVDRV
	JP	A02D6
;
A02F1:	ADD	A,041H
	LD	(D03B4),A
	SUB	041H
	CALL	SELDSK
	CALL	PCRLF
	LD	HL,T03AA
	CALL	PMSG1
	CALL	GCHAR
	CP	00DH
	JP	NZ,A0363
	CALL	PCRLF
	XOR	A
	LD	(D04A9),A
	CALL	A01E1
	LD	HL,T043F
	CALL	PMSG1
A031C:	LD	HL,T03C8
	CALL	PMSG
	CALL	GCHAR
	CP	00DH
	JP	Z,A0363
	SUB	041H
	CP	004H
	JP	C,A0337
	CALL	INVDRV
	JP	A031C
;
A0337:	ADD	A,041H
	LD	(D0404),A
	SUB	041H
	CALL	SELDSK
	LD	HL,T03F5
	CALL	PMSG
	CALL	GCHAR
	CP	00DH
	JP	NZ,A0363
	CALL	PCRLF
	LD	HL,D04A9
	LD	(HL),001H
	CALL	A01E1
	LD	HL,T043F
	CALL	PMSG1
	JP	A031C
;
A0363:	LD	A,000H
	CALL	SELDSK
	CALL	PCRLF
	JP	X0000
;
INVDRV:	LD	HL,INVMSG	;point to drive error message
	CALL	PMSG
	RET
;
T0375:	DEFM	'SYSGEN VER 2.0'
	DEFB	000H
T0384:	DEFM	'SOURCE DRIVE NAME (OR RETURN TO SKIP)'
	DEFB	000H
T03AA:	DEFM	'SOURCE ON '
D03B4:	DEFB	009H
	DEFM	', THEN TYPE RETURN'
	DEFB	000H
T03C8:	DEFM	'DESTINATION DRIVE NAME (OR RETURN TO REBOOT)'
	DEFB	000H
T03F5:	DEFM	'DESTINATION ON '
D0404:	DEFB	0CDH
	DEFM	', THEN TYPE RETURN'
	DEFB	000H
T0418:	DEFM	'PERMANENT ERROR, TYPE RETURN TO IGNORE'
	DEFB	000H
T043F:	DEFM	'FUNCTION COMPLETE'
	DEFB	000H
INVMSG:	DEFM	'INVALID DRIVE NAME (USE A, B, C, OR D)'
	DEFB	000H
T0478:	DEFM	'NO SOURCE FILE ON DISK'
	DEFB	000H
T048F:	DEFM	'SOURCE FILE INCOMPLETE'
	DEFB	000H
	DEFB	000H
D04A7:	DEFB	000H
D04A8:	DEFB	000H
D04A9:	DEFB	000H
DMAADR:	DEFW	00000H
ERRCNT:	DEFB	000H
	DEFW	000H,000H,000H
	DEFW	000H,000H,000H
	DEFW	000H,000H,000H
	DEFW	000H,000H,000H
	DEFW	000H,000H,000H
	DEFW	000H
WRKSTK:	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	DEFB	000H
	END
