;REV 20 FEB 84 D
;
; *** PROM BURNER TRANSFER PROGRAM ***
;
; SUPPORTS THE B & C MICROSYSTEMS MODEL
;   1409 PROM BURNER VERSION 2.3
;   (ALLOWS INTEL AND MOTOROLA FORMAT)
;
; USES CTLS/CLTQ (SOFTWARE HANDSHAKING)
; TO ALLOW DISK ACCESSES (3-WIRE RS-232)
;
; REQUIRES CUSTOMIZATION TO ALLOW ACCESS
; TO THE SYSTEM SERIAL PORT, SINCE CPM
; DOES NOT SUPPORT A GENERAL SYSTEM CALL
; TO THE SERIAL PORT.
;
;TO INVOKE UNDER CPM:  A>PROM
;
;A TERMINAL EMULATION PROGRAM ALLOWS COMMANDS TO THE
;    PROM BURNER.  ALL MANUAL COMMANDS OUTLINED IN THE
;    MANUAL ARE SUPPORTED.
;       *** N O T E ***
;    DO NOT ISSUE THE 'p' OR THE 'r' COMMANDS TO DO PROM
;    PROGRAMMING OR READING.  THESE FUNCTIONS ARE DONE
;    FROM THE COMMAND MODE AS DISCUSSED BELOW.
;
;    ESC PUTS IT IN COMMAND MODE.  AN ASTERISK PROMPT '*'
;    IS ISSUED TO INDICATE COMMAND MODE.  THE COMMANDS
;    ARE AS FOLLOWS:
;      P <FILENAME>  NNNN  TELLS PROGRAMMER TO PROGRAM
;                      EPROM WITH CONTENTS OF FILENAME
;                      STARTING AT DEVICE ADDR NNNN
;      R <FILENAME> NNNN PPPP  TELLS PROGRAMMER TO READ THE
;                      EPROM RANGE NNNN TO PPPP INTO FILENAME
;      Q OR E          EXITS TO CPM (WARM BOOT)
;      H               COMMAND MODE HELP
;      <CR>            EXITS COMMAND MODE
;
;*****************************************************
;
;  -- CONFIGURATION EQUATES --
;
DLYCTVAL EQU	1FFH	;DELAY AFTER CTL-S BEFORE DISK ACCESS
;
;  -- CPM	EQUATES --
;
BOOT	EQU	0
BDOS	EQU	5
FCB	EQU	05CH
DIRCON	EQU	6
PRTSTRNG EQU	9
RBUF	EQU	10
OPENF	EQU	15
CLOSF	EQU	16
DELFIL	EQU	19
READF	EQU	20
WRITF	EQU	21
MAKEF	EQU	22
DSKBL	EQU	080H	;DEFAULT SECT BUFFR
;
;   --- ASCII	EQUATES ---
;
ESC	EQU	01BH
CR	EQU	0DH
LF	EQU	0AH
SPC	EQU	20H
CTLS	EQU	13H
CTLQ	EQU	11H
CTLH	EQU	8H
ENQ	EQU	05H
ACK	EQU	06H
;
; -- JUMP VECTORS AND CUSTOMIZATION --
;
	ORG 0100H
TERM JMP START ;GO START IT UP
 JMP START ;SECOND ONE JUST IN CASE
;NOTE--THIS SPACE AVAIL FOR PATCHES (INIT?)
 ORG 0109H ;START OF JUMP TABLE
IN$MODCTLP DS 3 ;SERIAL STATUS PORT
OUT$MODDATP DS 3 ;SERIAL OUT DATA PORT
ANI$MODSNDB DS 3 ;BIT TO TEST FOR SEND READY
CPI$MODSNDR DS 3 ;VALUE OF SEND BIT WHEN READY
IN$MODDATP DS 3 ;SERIAL IN DATA PORT
ANI$MODRCVB DS 3 ;BIT TO TEST WHEN RECEIVE READY
CPI$MODRCVR DS 3 ;VALUE OF RECEIVE BIT WHEN READY
;
;
;     ADDITIONAL SPACE FOR DRIVERS AND STACK IS
;        AT THE TOP OF THE AREA
;
;
 ORG 500H
STACK	EQU	$  ;PUT THE STACK AT TOP OF PATCH
;
;AINP--INPUT FROM CONSOLE OR SERIAL.  IF Z, THEN NO
; CHAR READY.  IF NZ, CHAR IS IN A.  ENTER A=0 FOR 
; CONSOLE, A=1 FOR SERIAL
;
AINP ORA A
 JNZ SERIN ;JMP IF SERIAL INPUT
 MVI C,DIRCON ;DIRECT CONSOLE FCN
 MVI E,0FFH ;CONSOLE IN
 CALL BDOS ;GET IT
 ORA A ;SET Z FLAG IF NO CHAR
 RET
SERIN CALL IN$MODCTLP ;GET SERIAL STATUS PORT
 CALL ANI$MODRCVB ;MASK TO RECEIVE BIT
 CALL CPI$MODRCVR ;TEST FOR RECEIVE READY
 JNZ NOCHR ;JMP IF NO CHAR AVAIL
 CALL IN$MODDATP ;GET SERIAL DATA
 ANI 7FH ;MASK AND SET NZ (SHOULD NOT BE NULL
 RET
NOCHR XRA A ;CLR A, SET Z FOR NO CHAR
 RET
;
;AOUT--OUTPUT CHAR IN B TO CONSOLE OR SERIAL. ENTER
; WITH A=0 FOR CONSOLE, 1 FOR SERIAL.
;
AOUT ORA A
 JNZ SEROT ;JMP IF SERIAL OUT
 MVI C,DIRCON ;DIRECT CONSOLE FCN
 MOV E,B ;CHAR IN E
 CALL BDOS ;OUTPUT IT
 RET
;SERIAL OUT--ALWAYS DOWNSHIFTS TO LOWER CASE
SEROT MOV A,B
 CPI 40H ;IS IT A NUMBER
 JC SS1 ;JMP YES
 CPI 60H ;IS IT LOWER CASE
 JNC SS1 ;JMP YES
 ORI 20H ;MAKE IT LOWER
SS1 PUSH PSW ;SAVE CHAR ON STACK
SEROUT CALL IN$MODCTLP ;GET SERIAL STATUS
 CALL ANI$MODSNDB ;MASK TO SEND BIT
 CALL CPI$MODSNDR ;TEST FOR SEND READY
 JNZ SEROUT ;WAIT IF NOT READY
 POP PSW ;RESTORE CHAR IN A
 CALL OUT$MODDATP ;OUTPUT CHAR
 RET
;
;MAIN PROGRAM STARTS HERE
;
START LXI SP,STACK ;INIT STACK
TERM1 LHLD DLYCT
 MOV A,H
 ORA L
 JZ TERM0 ;JMP IF NO DELAY ACTIVE
 DCX H ;DECR DELAY
 SHLD DLYCT
 MOV A,H
 ORA L
 JNZ TERM0 ;JMP IF NOT COUNTED OUT YET
 CALL PUTSEC ;WEVE FINISHED DELAY--WRITE
 CALL PUTSEC ;256 BYTES TO DISK
 MVI B,CTLQ
 MVI A,1 ;NOW ISSUE CTL-Q TO RESTART
 CALL AOUT ;START UP THE SERIAL PORT
;
TERM0 XRA A
 CALL AINP ;IS THERE A KEY READY?
 JZ TIN ;JMP NO
 ANI 7FH ;MASK
 MOV B,A ;SAVE CHAR IN B
 CPI ESC
 JZ CMDMODE ;JMP IF ESC KEY--IT MEANS CMD MODE
 MVI A,1
 CALL AOUT ;OUTPUT CHAR TO SERIAL PORT
TIN MVI A,1
 CALL AINP ;IS THERE SERIAL DATA?
 JZ TERM1 ;JMP NO
 ANI 07FH ;MASK TO 7 BITS
 MOV B,A ;CHAR IN B FOR CRTOUT
 JZ TERM1 ;IGNORE NULLS
 CPI CR
 JZ TERM2
 CPI LF
 JZ TERM2
 CPI CTLQ
 JZ T5
 CPI 020H ;DONT DISPLAY CTL CHAR
 JC TERM1
TERM2 PUSH B
 CALL CRTOUT ;OUTPUT CHAR
 POP B
T5 LDA INFLG
 ORA A
 JZ TERM1
 CALL WRITB ;IF INSERTING TO DISK, CALL IT
 JMP TERM1 ;LOOP OVER AND OVER
;
; -- OUTPUT TO CRT --
;
CRTOUT LDA PRVCHR ;GET PREV CHAR
 CPI CR
 JNZ CRT1
 MOV A,B ;PREV CHAR WAS CR
 CPI CR ;IS CURRENT CHR=CR?
 RZ ;JUST RET IF YES
CRT1 MOV A,B
 STA PRVCHR ;SET CURR CHAR INTO SAVE
 XRA A
 CALL AOUT ;OUTPUT IT TO CRT
 RET ;PUNT
;
;  -- OUTPUT FILE TO SERIAL --
;
SND LXI H,FCB
 CALL PARSFN ;CONVERT FILENAME TO FCB
 PUSH D ;SAVE KEYBD BUFFER
 LXI D,FCB
 MVI C,OPENF
 CALL BDOS ;OPEN FCB FILE
 CPI 0FFH ;WAS FILE THERE?
 POP D ;ALIGN STACK
 JZ NOFIL ;JMP NO
 PUSH D ;SAVE IT AGAIN
 LXI D,SNDMS
 CALL SERMSG ;TELL PROG TO START PROGRAMMING
 POP D
 CALL SERMSG ;SEND PARMS
 LXI D,CRLF
 CALL CONPRT ;MOVE UP CMD LINE
 MVI A,0
 STA RDBCT ;SET BYTCT=0 TO FORCE SECTOR READ
BYTMOV CALL CHKYB ;CHK FOR OPER INTERV
 CALL READB ;GET CHAR FROM FILE
 JC SENDONE ;JMP IF END OF FILE
 STA TEMP1 ;SAVE FIRST CHAR IN TEMP
 CALL READB ;GET SECOND CHAR OF BYTE
 JC SENDONE ;JMP IF END OF FILE
 STA TEMP2 ;SAVE SECOND CHAR
 MVI A,1
 CALL AINP ;CHECK FOR HANDSHAKES FROM PROGRAMMER
 JZ OKSEND ;JMP IF NO CHAR READY--ITS OK TO SEND
 ANI 7FH ;MASK INPUT CHAR
 CPI CTLS ;IS BURNER TELLING ME TO STOP?
 JNZ TERM ;JMP NO--SOMETHING WRONG
 CALL GETSER ;GET ANOTHER SERIAL INPUT (WAIT FOR IT)
 ANI 7FH ;MASK
 CPI CTLQ ;OK TO START AGAIN?
 JNZ TERM ;JMP NO -- BLAST OFF, SOMETHING WRONG
OKSEND LDA TEMP1
 CALL PUTOUT
 LDA TEMP1
 CALL CKCR ;CHECK FOR CARR RETURN (TO WAIT)
 LDA TEMP2
 CALL PUTOUT ;SEND TO BURNER
 LDA TEMP2
 CALL CKCR ;CHECK FOR CARR RETURN (TO WAIT)
 JMP BYTMOV ;LOOP FOR MORE
PUTOUT MOV B,A ;CHAR IN B FOR OUTPUT
 PUSH B ;SAVE CHAR TO OUTPUT
 MVI A,1
 CALL AOUT ;SEND ASCII TO BURNER
 POP B ;RESTORE CHAR
 XRA A
 CALL AOUT ;SEND FEEDBACK TO USER CRT
 RET ;PUNT
CKCR CPI CR ;WAS IT A CR?
 RNZ ;RET NO
CKCR1 CALL GETSER ;WAIT FOR CHAR FROM BURNER
 ANI 7FH
 CPI CTLS ;WAS IT CTL-S?
 JZ CKCR1 ;LOOP YES--CONTINUE WAITING
 CPI CTLQ ;WAS IT CTL-Q?
 RZ ;RET YES--DONE WAITING
 JMP TERM ;SOMETHING WRONG--GET OUT OF SEND MODE
SENDONE MVI B,'$'
 MVI A,1
 CALL AOUT ;SEND '$' TO BURNER TO EXIT BURN MODE
 JMP TERM
SNDMS	DB	'p $'
NOFIL LXI D,NOFILTX
 CALL CONPRT
 JMP CMDMODE
NOFILTX	DB	CR,LF,'FILE DOESNT EXIST$'
;
;  -- WAIT ON SERIAL INPUT DATA --
;
GETSER MVI A,1
 CALL AINP ;GET SERIAL INPUT
 JNZ GETS1 ;JMP IF CHAR RDY
 CALL CHKYB ;ALLOW OPER INTERV
 JMP GETSER ;LOOP WAITING
GETS1 ANI 07FH ;MASK TO 7 BITS
 RET ;RET WITH CHAR
CHKYB XRA A ;KYB CHAR RDY?
 CALL AINP
 RZ ;RET NO
 CPI ESC ;HAVE KEY--IS IT ESC?
 JZ TERM ;JMP YES & ABORT SYS
 RET
;
;  -- READ A BYTE FROM DISK FILE --
;
READB LDA RDBCT
 ORA A ;END OF SECTOR?
 JNZ BYP2 ;JMP NO
 MVI A,128
 STA RDBCT ;RESET CT
 LXI H,DSKBL
 SHLD RDBUF ;RESET BUFFER PTR
 LXI D,FCB
 MVI C,READF
 CALL BDOS
 ORA A
 JZ BYP2 ;JMP IF NO ERRORS
EOFRT STC ;EOF OR ERROR BAD PUNT
 RET
BYP2 LDA RDBCT
 DCR A
 STA RDBCT ;DEC CT
 LHLD RDBUF
 MOV A,M ;GET CHAR IN A
 CPI 01AH ;IS IT END OF FILE?
 JZ EOFRT ;JMP YES
 ORA A
 JZ EOFRT ;NULLS ARE ALSO EOF
 INX H ;BUMP PTR
 SHLD RDBUF
 ORA A ;CLR CY GOOD PUNT
 RET
;CONVERT ASCII HEX TO BIN IN A
CVTBIN SUI 30H
 CPI 0AH
 RC
 SUI 7
 RET
;GET BINARY BYTE
GETBINBY CALL READB
 RC
 CALL CVTBIN
 RLC
 RLC
 RLC
 RLC ;SHIFT TO HI NIBBLE
 MOV B,A
 PUSH B
 CALL READB
 POP B
 RC
 CALL CVTBIN
 ADD B
 ORA A ;CLR CY
 RET
;
;CNVNM--CONVERTS HEX ASCII STRING PTD TO BY DE INTO
;  BINARY IN HL.  IF NULL STRING, HL=0
CNVNM LXI H,0
CNVN1 LDAX D
 CPI SPC
 JNZ CNV2 ;JMP IF NOT SPACE
 INX D ;CLEAR SPACES
 JMP CNVN1
CNV2 CALL TSTRM
 RZ ;RETURN IF TERMINATOR FOUND
 CALL CVTBIN ;CONVERT TO BIN IN A
 MVI B,0
 MOV C,A ;BC=CHAR IN BINARY
 DAD H
 DAD H
 DAD H
 DAD H ;LEFT SHIFT HL 4 BITS (1 NIBBLE)
 DAD B ;ADD IN CHAR
 INX D ;BUMP PTR
 LDAX D ;GET NEXT CHAR
 JMP CNV2 ;LOOP FOR MORE
;
;  -- SET UP FOR RECEIVING FILE --
;
;MOV FIL FROM SERIAL TO CPM--ENTERED FROM R CMD
RCV LXI H,FCB
 CALL PARSFN
KSP LDAX D ;GET NEXT CHAR
 CPI SPC
 JNZ KK ;JMP IF NOT SPACE
 INX D
 JMP KSP ;LOOP TO KILL SPACES
KK XCHG
 SHLD KPTR ;STORE KEYBUF PTR
 CALL TSTRM ;TEST FOR END OF KEYBUF
 MVI A,1
 JNZ KL
 XRA A
KL STA PARMFLG ;=0 IF NO PARMS
 LXI D,CRLF
 CALL CONPRT ;MOVE COMMAND LINE UP
 LXI D,FCB
 MVI C,DELFIL
 CALL BDOS ;DELETE ANY FILE IF IT EXISTS
 LXI D,FCB
 MVI C,MAKEF
 CALL BDOS ;CREATE FILE FOR INSERT
 MVI A,129
 STA RDBCT
 STA INFLG
 LXI H,DSKBL
 SHLD RDBUF
 LXI H,WRBF
 SHLD WRBFP
 LXI H,0
 SHLD WRBCT
 XRA A
 STA INTLBC ;INIT THE LINE BYTE COUNT
;TELL THE BURNER TO START READING
 LDA PARMFLG
 ORA A
 JNZ GOTPARM ;JMP IF THERE WERE ADDR PARMS
;NO PARMS--DEFAULT TO ENTIRE ROM. MUST HACK
;DUE TO BUG IN BURNER BY LISTING 0,1; THEN FROM
;2 TO THE END.  0 TO END DOES NOT STOP AT END.
 LXI D,RCMD1 ;SEND COMMAND #1
 CALL SERMSG ;SEND TO PROM BURNER
 MVI C,4
RLP PUSH B
 CALL GETSER ;GET A NIBBLE OF DATA
 PUSH PSW ;SAVE IT
 MOV B,A ;CHAR IN B FOR WRITB
 CALL WRITB ;PUT AWAY -- MUST NOT DO DISK ACCESS
 POP B ;RESTORE CHAR IN B
 XRA A
 CALL AOUT ;OUT TO CRT FEEDBACK
 POP B
 DCR C
 JNZ RLP ;LOOP FOR 4 NIBBLES
RRP CALL GETSER
 CPI '>' ;WAIT FOR PROMPT FROM '2532->'
 JNZ RRP ;LOOP TIL WE GET IT
 LXI D,RCMD2 ;SECOND READ COMMAND
SPQ CALL SERMSG ;SEND IT
 JMP TIN ;GO DO THE REST NORMALLY
RCMD1	DB	'r 1',CR ;READ LOCS 0,1
RCMD2	DB	'r 2 ',CR ;READ LOCS 2 TO END
;
GOTPARM LXI D,RCMD3
 CALL SERMSG
 LHLD KPTR
 XCHG ;MAKE DE POINT TO REST OF KYBD INPUT
 JMP SPQ ;GO SEND IT
RCMD3	DB	'r $' ;JUST A BARE COMMAND--PARMS FROM KEYBUF
;
SERMSG LDAX D ;GET FIRST CHAR
 MOV B,A ;IN B
 CPI '$' ;CHK FOR TERMINATOR
 RZ ;RETURN IF FOUND
 PUSH D
 MVI A,1
 CALL AOUT ;OUTPUT IT
 CALL GETSER ;WAIT FOR ECHO FROM PROM BURNER
 POP D
 LDAX D ;GET CHAR AGAIN
 CPI CR ;WAS IT A CR?
 RZ ;RETURN YES (AFTER HAVING SENT IT)
 INX D ;BUMP PTR
 JMP SERMSG ;LOOP FOR MORE
;
;  -- PUT A BYTE TO CPM DISK BUFFER --
;
WRITB LDA INTLBC ;GET LINE BYTE COUNT
 INR A
 STA INTLBC ;AND BUMP IT
 CPI 65 ;TIME TO OUTPUT CRLF TO FILE?
 JNZ WRT1 ;JMP NO
 MVI A,1
 STA INTLBC ;RESET LINE COUNT
 PUSH B ;SAVE CHAR
 MVI B,CR
 CALL WRT2 ;PUT IT TO FILE
 MVI B,LF
 CALL WRT2 ;PUT IT TO FILE
 POP B ;RESTOR CHAR AND FALL THRU TO WRT1 & RET BACK
WRT1 MOV A,B
 CPI CR
 JZ FINIS ;EXIT ON FIRST CR AFTER READ COMMAND
WRT2 LHLD WRBFP ;GET PTR TO BUFFER
 MOV M,B ;PUT BYTE THERE
 INX H
 SHLD WRBFP ;UPDATE PTR
 LHLD WRBCT ;UPDATE CT
 INX H
 SHLD WRBCT
 MOV C,H ;CT HI IN C
 LHLD DLYCT
 MOV A,H
 ORA L
 RNZ ;RET IF WAITING FOR XOFF TO WORK
 MOV A,C
 CPI 1 ;>255 CHARS?
 RC ;RET NO
 MVI B,CTLS
 MVI A,1
 CALL AOUT ;STOP SERIAL XFER
 LXI H,DLYCTVAL ;DELAY TIME AFTER CTL-S
 SHLD DLYCT ;SET DELAY CT
 RET
FINIS PUSH B
 LXI D,CRLF
 CALL CONPRT ;MOVE UP DISPLAY
 POP PSW
FIN2 CPI '>' ;WAIT TIL BURNER SENDS THIS
 JZ EXIT ;GO FLUSH AFTER BURNER DONE SENDING CHARS
 CALL GETSER ;GET ANOTHER CHAR
 MOV B,A
 JMP FIN2 ;LOOP JUST SWALLOWING CHARS
;
;  -- FLUSH CPM DISK BUFFER TO DISK --
;
EXIT MVI B,1AH ;END OF FILE MARK
 CALL WRITB ;PUT IN BUFFER
EX7 CALL PUTSEC
 LHLD WRBCT
 MOV A,H
 ORA L
 JZ EX9 ;JMP IF BUFFER EMPTY
 MOV A,H
 ANI 80H
 JZ EX7 ;JMP IF BUFFER STILL FULL
EX9 LXI D,FCB
 MVI C,CLOSF
 CALL BDOS ;CLOSE THE FILE
 XRA A
 STA INFLG
 LXI H,0
 SHLD DLYCT ;RESET DELAY COUNT STUFF
 JMP SENDONE ;GO HIT BURNER WITH $ AND GOTO TERM
;
; --- PUT A SECTOR TO CPM DISK BUFFER
;
PUTSEC LXI D,WRBF
 LXI H,DSKBL
 MVI B,128
PTS6 LDAX D
 MOV M,A
 INX H
 INX D
 DCR B
 JNZ PTS6
 LHLD WRBCT
 LXI B,-128
 DAD B
 SHLD WRBCT
 LXI B,WRBF
 MOV A,H
 ORA L
 JZ PTS15 ;JMP IF SECTOR MOVED TO DSKBL
 MOV A,H
 ANI 80H
 JNZ PTS15 ;JMP IF WENT NEGATIVE--NO MORE TO MOVE
PTS10 LDAX D
 STAX B
 INX B
 INX D
 DCX H
 MOV A,H ;MOVE REST OF FILE DOWN
 ORA L
 JNZ PTS10
PTS15 MOV H,B
 MOV L,C
 SHLD WRBFP
 LXI D,FCB
 MVI C,WRITF
 CALL BDOS ;WRITE A SECTOR
 RET
;
; -- COMMAND MODE HANDLER ---
;
CMDMODE LDA INFLG
 ORA A ;ARE WE RECEIVING A FILE?
 JNZ EXIT ;JMP YES--FLUSH IT TO DISK
 LXI D,CMDTXT
 CALL CONPRT ;OUTPUT PROMPT
 LXI D,KEYBUF
 MVI C,RBUF
 CALL BDOS ;GET KEYBD INPT
 INX D ;POINT TO RETURNED LENGTH
 LDAX D ;GET IT
 MOV L,A ;IN L
 MVI H,0 ;HL HAS LENGTH
 INX D ;DE POINTS TO FIRST CHAR IN BUFFER
 DAD D ;HL POINTS TO FIRST EMPTY AT END
 MVI M,CR ;PUT A DECENT DELIMITER
CLS LDAX D ;GET FIRST CHAR
 INX D ;POINT TO SECOND CHAR
 CPI SPC ;IS IT A SPACE?
 JZ CLS ;JMP YES TO CLEAR SPACES
 CPI CR ;IS IT A CR?
 JZ EXITCMD ;JMP YES--EXIT TO TERM MODE
 ANI 0DFH ;MAKE U.C.
 CPI 'H' ;IS IT HELP?
 JZ HELP
 CPI 'Q' ;IS IT QUIT
 JZ BOOT
 CPI 'E' ;IS IT EXIT?
 JZ BOOT
 CPI 'P'
 JZ SND ;SEND FILE
 CPI 'R'
 JZ RCV ;RECEIVE FILE
 LXI D,ERMSG
ERR CALL CONPRT ;OUTPUT ERROR MSG
 JMP CMDMODE
CMDTXT	DB	CR,LF,'*$' ;PROMPT
ERMSG	DB	CR,LF,'UNKNOWN CMD, H FOR HELP$'
;
;
EXITCMD LXI D,CRLF
 CALL CONPRT
 JMP TERM
CRLF	DB	CR,LF,'$'
;
HELP LXI D,HLPTXT
 CALL CONPRT
 JMP CMDMODE
;
HLPTXT	DB	CR,LF,'<CR> Exits command mode and allows commands'
	DB	CR,LF,'          directly to the prom burner itself'
	DB	CR,LF,'Q OR E exits to CPM (Reboots)'
	DB	CR,LF,'P <FILENAME> NNNN   Programs device from file'
	DB	CR,LF,'          <FILENAME> into device address NNNN'
	DB	CR,LF,'R <FILENAME> NNNN PPPP Reads device range NNNN'
	DB	CR,LF,'          to PPPP into file <FILENAME>'
	DB	'$'
;
;PARSFN--PARSES INPUT BUFFER AT (DE) AND BUILDS AN
; FCB AT (HL).  HANDLES DISK AND EXTENSIONS
;
PARSFN MVI M,0 ;STORE DEFAULT DISK SPEC
PARS1 LDAX D
 INX D
 CPI SPC ;IS IT A SPACE?
 JZ PARS1 ;KILL SPACES
 LDAX D ;GET SECOND CHAR
 DCX D ;ADJUST PTR BACK
 CPI ':' ;IS THERE A DRIVE SPEC?
 JNZ MOVFN ;JMP NO
 LDAX D ;GET DISK SPEC
 ANI 0DFH ;MAKE U.C.
 SUI 40H ;SUBT ASCII OFFSET
 CPI 1
 JC ERROR ;JMP IF NOT A VALID DISK
 CPI 10H ;MAX DISK IS 'P'
 JNC ERROR
 MOV M,A ;PUT AWAY
 INX D
 INX D ;POINT TO FILENAME
;
MOVFN MVI B,9 ;MAX NR CHARS IN FILENAME
 INX H ;POINT TO FILENAME IN FCB
 LDAX D ;GET FIRST CHAR
 CALL TSTRM ;TEST IF NO FILENAME
 JZ ERROR
MLOOP LDAX D ;GET CHAR FROM INPUT
 CPI '.'
 JZ DOT ;JMP IF HAVE EXTENSION
 CALL TSTRM ;TEST FOR TERMINATORS
 JZ NOEX ;JMP IF TERMINATOR FOUND
	DCR	B
	JZ	ERROR ;JMP IF FILENAME TOO LONG
	CPI	60H ;IS IT LOWERCASE?
	JC	TTT ;JMP NO
	ANI	0DFH ;MAKE U.C.
TTT:	MOV	M,A ;PUT AWAY IN FILENAME
	INX	H ;BUMP PTRS
	INX	D
	JMP	MLOOP ;LOOP FOR MORE
DOT:	CALL	FILL ;FILL UP REST OF FILENAME WITH SPACES
	INX	D ;POINT TO EXTENSION IN KYBD BUFF
	MVI	B,3 ;LENGTH OF EXTENSION
LP2:	LDAX	D
	CALL	TSTRM
	JZ	SHRTEX ;JMP IF SHORT EXTENSION
	CPI	60H
	JC	TTU ;JMP IF LOWER CASE
	ANI	0DFH ;MAKE UPPER CASE
TTU:	MOV	M,A
	INX	H
	INX	D
	DCR	B
	JNZ	LP2
	JMP	CLRFCB
SHRTEX:	CALL	FILL ;FILL UP FCB WITH SPACES
	JMP	CLRFCB
NOEX:	CALL	FILL
	MVI	B,4
	CALL	FILL
CLRFCB:	XRA	A
	MVI	B,25 ;CLEAR CHARS AFTER EXT IN FCB
	JMP	LP3 ;GO CLEAR AND RETURN
FILL:	MVI	A,SPC ;SPACE IN A
LP3:	DCR	B
	RZ
	MOV	M,A
	INX	H
	JMP	LP3
TSTRM:	ORA	A ;RET WITH Z IF INPUT BUF TERM FOUND
	RZ ;RET ON NULL
	CPI SPC
	RZ ;RET ON SPACE
	CPI CR
	RET ;RET ON CR
ERROR:	LXI	D,BDFNTX
	JMP	ERR
BDFNTX:	DB	CR,LF,'BAD FILENAME$'
;
CONPRT:	MVI	C,PRTSTRNG
	JMP	BDOS ;OUTPUT STRING AND RET
;
;  --  RAM AREA  --
;
PRVCHR:	DB	0 ;PREVIOUS CHAR SAVE
RDBCT:	DB	0 ;BYT CT IN SECTOR
ESCFL:	DB	0
INFLG:	DB	0
RDBUF:	DW	0 ;PTR INTO SECTOR
WRBCT:	DW	0 ;CT IN WRBF
WRBFP:	DW	0 ;PTR TO WRBF
DLYCT:	DW	0 ;DELAY CTR AFTER SENDING CTLS
TEMP1:	DB	0
TEMP2:	DB	0
PARMFLG:DB	0
CHARSV:	DB	0
KPTR:	DW	0
INTLBC:	DB	0
KEYBUF:	DB	80 ;LENGTH MAX OF BUFFER
	DB	0 ;FOR RETURNED LENGTH
	DS	82 ;KEYBOARD BUFFER AREA + OVERFLOW
PTCHBUF:DS	80 ;SPACE FOR PATCH FIXES
WRBF	EQU	$ ;BUFFER FOR INCOMING DATA
 END