/* TODO: free urlbuf! etc! strdup!! */

/*
 * this was added by Marc Roessler <marc@tentacle.franken.de>
 * based on Steve Kemp's <skx@tardis.ed.ac.uk> popup.c rewriting patch
 * maybe replacing of strings a la 's/string1/string2' will be added later.
 *
 * Distributed under the GNU General Public License; see the README file.
 * This code comes with NO WARRANTY. http://www.junkbusters.com/ht/en/gpl.html
 */

/*
 *  rewrite.c  - Handles the loading, parsing, and filtering of popups.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include <malloc.h>
#include <errno.h>
#include <sys/stat.h>
#include <ctype.h>

#ifndef _WIN32
#include <unistd.h>
#endif

#ifdef REGEX
#include <gnu_regex.h>
#endif

#include "jcc.h"

/* Protypes. */
void unload_rwfile(struct client_state *csp /* Not used */ );

/* Globals */
static struct rwlist *rw_list = NULL;

/* Load, and parse the blocklist. */
int
load_rwfile(struct client_state *csp)
{
  FILE *fp;
  char *vec[4];
  int port, n;
  char  buf[BUFSIZ], *urlbuf, *p, *q, *tmp = NULL;
  struct url_spec url[1];
  struct rwlist *entry = NULL;
  struct rwlist *temp  = NULL;
  p = buf;
  q = buf;

  /* Unload the previous rewrite-file, if any. */
  unload_rwfile( csp );

  if((fp = fopen(rwfile, "r")) == NULL)
  {
      fprintf(logfp, "Error opening rewrite-file %s\n", rwfile);
      return -1;
  }

  while(fgets(buf, sizeof(buf), fp)) 
  {
      freez(tmp);

      /* linefeeds are string terminators */
      if((p = strpbrk(buf, "\r\n")) != NULL) *p = '\0';

      /* comments are string terminators */
      if((p = strchr(buf, '#'))) *p = '\0';

      /* skip blank lines */
      if(*buf == '\0') continue;
      // if (!strlen(buf)) continue;

      vec[0]=(char *)NULL;
      vec[1]=(char *)NULL;
      vec[2]=(char *)NULL; 

      /* find hostpattern, pattern, replacepattern .. */
      tmp = strdup(buf);
      n = ssplit(tmp, " \t", vec, SZ(vec), 1, 1);
      if (n < 2) 
	{
		free(tmp);
		fclose(fp);
		fprintf(logfp, "%s: Syntax error in rewritefile '%s'\n",
			prog, rwfile);
		return(-1);
	}

      if (((entry = (struct rwlist*) malloc(sizeof(struct rwlist))) == NULL)
#ifdef REGEX
      || ((entry->url->preg = (regex_t *) malloc(sizeof(regex_t))) == NULL)
#endif
	)
	{
		fclose(fp);
		fprintf(logfp, "%s: can't load rewritefile '%s': ",
			prog, rwfile);
		fperror(logfp, "");
		return(-1);
	}

      urlbuf = strdup(vec[0]);
      entry->blockstr = strdup(vec[1]);
      if(vec[2] == NULL)
	entry->replacestr = (char *)NULL;
      else
	entry->replacestr = strdup(vec[2]);

      if((p = strchr(urlbuf, '/')))
	{
		entry->url->path    = strdup(p);
		entry->url->pathlen = strlen(entry->url->path);
		*p = '\0';
	}
      else
	{
		entry->url->path    = NULL;
		entry->url->pathlen = 0;
	}

#ifdef REGEX
      if(entry->url->path)
	{
		int errcode;
		char rebuf[BUFSIZ];

		sprintf(rebuf, "^(%s)", entry->url->path);

		errcode = regcomp(entry->url->preg, rebuf,
			(REG_EXTENDED|REG_NOSUB|REG_ICASE));
		if(errcode)
		 {
			size_t errlen = regerror(errcode,
					entry->url->preg, urlbuf, sizeof(urlbuf));
			buf[errlen] = '\0';

			fprintf(logfp,
				"%s: error compiling %s: %s\n",
				prog, entry->url->spec, urlbuf);
			fclose(fp);
			return(-1);
	 	 }
	}
	else
	 freez(entry->url->preg);
#endif

       if((p = strchr(urlbuf, ':')) == NULL)
		port = 0;
	else
	  {
		*p++ = '\0';
		port = atoi(p);
	  }
       entry->url->port = port;

       if((entry->url->domain = strdup(urlbuf)) == NULL)
	{
		fclose(fp);
		fprintf(logfp, "%s: error compiling %s (strdup)\n",
                                prog, entry->url->domain);
		return(-1);
	}

       /* split domain into components */
       *url = dsplit(entry->url->domain);
       entry->url->dbuf = url->dbuf;
       entry->url->dcnt = url->dcnt;
       entry->url->dvec = url->dvec;

       entry->next = 0;

          if (rw_list == NULL)
              rw_list = entry; /* our first entry.. */
	    else
	     {
              /* Save current head, replace with new entry, append the rest */
              temp = rw_list;
              rw_list = entry;
              rw_list->next = temp;
             }
  }
  fclose( fp );
  return(0);
}

/* Free the list */
void
unload_rwfile(struct client_state *csp /* Not used */ )
{
    struct rwlist * cur = NULL;
    struct rwlist * temp= NULL;

    /* Free the list */
    if (rw_list != NULL)
    {
        cur = rw_list;
        
        while(cur->next != NULL)
        {
            temp = cur;
            cur  = cur->next;
            
            free( temp->blockstr );
            free( temp );
        }
        rw_list = NULL;
    }
}


/* returns NULL if current URL does NOT match the current pattern */
char *check_url(struct http_request *http, struct url_spec *pattern)
{
    struct url_spec url[1];

    *url = dsplit(http->host);

    /* if splitting the domain fails, punt */
    if(url->dbuf == NULL) return(NULL);

    if((pattern->port == 0) || (pattern->port == http->port))
	{
	if((pattern->domain[0] == '\0')
	  || (domaincmp(pattern, url) == 0))
	   {
		if((pattern->path == NULL) ||
#ifdef REGEX
		   (regexec(pattern->preg, http->path, 0, NULL, 0) == 0)
#else
		   (strncmp(pattern->path, http->path, pattern->pathlen) == 0)
#endif
		)
			{
				freez(url->dbuf);
				freez(url->dvec);
				return(rwfile); /* doesn't matter */
			}
	   }
	}
     freez(url->dbuf);
     freez(url->dvec);
     return(NULL);
}



/* look for occurance of the strings listed in the rwfile and replace
 * them with spaces */
void rewrite_html(char *buff, int size, struct http_request *http)
{
    struct rwlist * cur;
    char *str_loc = (char *) NULL;
    char *p     = (char *) NULL;
    int str_len = 0;
    char saver;

    /* make sure we don't run away .. */
    saver = buff[size];
    buff[size] = '\0';

    /* search for each of the strings specified in the config file */
    for(cur = rw_list; cur; cur = cur->next) 
    {
	if ((cur->blockstr != 0) && check_url(http, cur->url))
	{
		/* now dig for the string until we find no more occurances */
		for(str_len = strlen(cur->blockstr),
			str_loc = strstr(buff, cur->blockstr);
		    str_loc != (char *)NULL;
		    str_loc = strstr(buff, cur->blockstr))
		{
			for(p = str_loc; p != &str_loc[str_len]; p++)
				*p = ' ';
		}
	}
    }

    /* restore the last character */
    buff[size] = saver;
}
