; Disassembly of the file "D:\Museum\ITT3030\ITT_BOOT.V17"
;
; CPU Type: Z80
;
; Created with dZ80 2.0
;
; on Monday, 12 of May 2008 at 12:01 AM
;
; Boot-ROM Version 1.7 des ITT 3030
; Mit Untersttzung fr Festplatte

; Portbelegung
;10: Tastatur, Datenbusregister
;11: Tastatur, Status lesen (In), Befehl ausgeben (Out)
;
;1c: Festplatte,
;    Verwendung: i 01ce 01d7 01e1, o 01df 01f8
;1d: Festplatte,
;    Verwendung: i 01c8 01d1 01f0 0204 020e 021d 022c, o 01e5
;1e: Festplatte(?),
;    Verwendung: o 01fa
;
;20: CRTC, Zeilenlnge
;    Verwendung: 040c
;21: CRTC, Rastermodus, Breite Zeilensynchronimpuls, Abstand rechter Bildrand
;    Verwendung: 0410
;22: CRTC, Rasterzeilen pro Zeichen, Anzahl Zeichen pro Zeile (kodiert)
;    Verwendung: 0414
;23: CRTC, Verzgerungen, Anzahl Zeichenzeilen
;    Verwendung: 0418
;24: CRTC, Anzahl Rasterzeilen/Bildschirm (kodiert)
;    Verwendung: 041c
;25: CRTC, Anzahl der leeren Rasterzeilen am Bildanfang
;    Verwendung: 0420
;26: CRTC, Nummer der letzten Zeichenzeile
;    Verwendung: 0424
;2a: CRTC, Out = Zeitsteuerung stoppen
;    Verwendung: 0406
;2b: CRTC, Out = Schirmbild rollen
;2d: CRTC,
;    Verwendung: 0435
;2e: CRTC, Out = Zeitsteuerung starten
;    Verwendung: 0404 0441
;
;30: Tastatur(?), Datenbusregister
;    Verwendung: i 03bc
;31: Tastatur(?), Status lesen (In), Befehlsregister (Out)
;    Verwendung: i 0029 03aa, o 000b 0084 03b7 03c4 o3cb
;
;32: Beeper, Bit 0 = 1: einschalten
;    Verwendung: 036e 03da
;33: LED Shift Lock, Bit 0 = 1: einschalten
;34: Lupenfunktion Video: Bit 0 = 1: Lupe einschalten
;    Verwendung: 034f
;35: Zustand Video-Synchronsignale, Bit 6 = 1: VSYNC, Bit 7 = 1: HSYNC oder VSYNC
;    sowie angeblich Tastatur und Videoadaptertypen
;    Verwendung: 044b 0451 045b 0461
;
;50: FDC, Statusregister (In) / Befehlsregister (Out)
;    Verwendung: i 05de 05fa 063b 0643 068e, o 0695
;51: FDC, Spur-Register
;    Verwendung: i 0535
;52: FDC, Sektor-Register
;    Verwendung: o 0616 0639 067a
;   i 053d 066d
;53: FDC, Daten-Register
;    Verwendung: o 060f
;   i 05a1 065e
;54: FDC, Karten-Status (In) / Karten-Befehlsregister (Out)
;    Verwendung: i 0585 059b 0663, o 0551 0555
;
;e0: Z80-Combo, Steuerregister Zhler A
;e1: Z80-Combo, Zhlvorgabe (Out) bzw. Zhlerstand (In) Zhler A
;e2: Z80-Combo, Steuerregister Zhler B
;e3: Z80-Combo, Zhlvorgabe (Out) bzw. Zhlerstand (In) Zhler B
;e4: Z80-Combo, Zhlvorgabe (Out) Zhler B (ohne nderung des akt. Zhlerstands)
;e5: Z80-Combo, Steuerregister (Out) bzw. Statusregister RS232 und RAM (In)
;    Bit 5 = 1: RAM 1000 bis 103F schreibgeschtzt
;e6: Z80-Combo, Schieberegister RS232 (High-Byte)
;e7: Z80-Combo, Schieberegister RS232 (Low-Byte)
;e8: Z80-Combo, Steuerregister Interrupt-Betriebsweisen
;e9: Z80-Combo, Maskierung fr Interrupts
;ea: Z80-Combo, Schreibschutz fr die ersten 64 Byte des RAMs
;    Ausgabe von 66h: Schreibschutz aufheben
;    Ausgabe von 55h: Schtzen nach dem ersten Einschreiben
;    Sonst: Schreibschutz setzen
;    Verwendung: 0007
;f0: Waitcycle bei Opcode-Fetch (OUT, Bit 0)
;    Auerdem Zugriff auf RS232 Handshake (IN) - Bit 4 = DSR, Bit 5 = CTS
;f1: Waitcycle bei Datenzugriff (OUT, Bit 0)
;f2: Waitcycle bei I/O (OUT, Bit 0)
;f3: RS232 Handshake - Bit 0 = RTS, Bit 1 = DTR
;    Verwendung: 000f
;
;f6: Speicherseiten Umschalten
;    Verwendung: 00e3, 016f
;    out (f6), 10 ; Speicherseite 0
;    out (f6), 90 ; Speicherseite 1
;    out (f6), 50 ; Speicherseite 2
;    out (f6), d0 ; Speicherseite 3
;    out (f6), 30 ; Speicherseite 4
;    out (f6), b0 ; Speicherseite 5
;    out (f6), 70 ; Speicherseite 6
;    out (f6), f0 ; Speicherseite 7
;    out (f6), 00 ; Speicherseite 8

; Speicherbelegung Bank 8 (Interner Speicher)
; 0000 - 07FF: 2 KB Boot- und Treiber-ROM
; 1000 - 10FF: 256 Byte RAM auf Z80 Combo
; 3000 - ????: Video-RAm auf I/O-Karte
; C000 - FFFF: Externer Speicher auf der gerade aktuellen Seite des Hauptspeichers
; Wegen unvollstndiger Dekodierung erscheinen alle Adressen 3 mal mit einem
; Abstand von 4000h

; Variablen
; 10C0/10C1 - Sicherung Stackpointer vor Floppy-Zugriffen
; 10C2 - Sicherung Flags? Rckgabewert der Floppy-Funktion?
; 10C3 - Sicherung Akku?
; 10C4 - Sicherung BC
; 10C6 - Sicherung DE
; 10C8 - Aktuelle Spurnummer Floppy Disk Drive 1
; 10C9 - Aktuelle Sektornummer
; 10CA - Anzahl Leseversuche?
;
; 10E0 - initialisiert mit 20
; 10E1 - initialisiert mit 00 - Aktuelles Zeichenattribut (normal/invers)
; 10E2 - initialisiert mit 47
; 10E3 - initialisiert mit 18
; 10E4 - initialisiert mit 00 - Aktuelle Cursorspalte (0-basiert)
; 10E5 - initialisiert mit 18 - Aktuelle Cursorzeile (1-basiert)
; 10E6 - initialisiert mit 80 - Aktuelle Cursoradresse (Spalte)
; 10E7 - initialisiert mit 2b - Aktuelle Cursoradresse (Zeile, 20 - 2C)
; 10E8 - initialisiert mit 00 - Originalattribut des Zeichens unter dem Cursor
; 10E9 - initialisiert mit 20 - Original des Zeichens unter dem Cursor
; 10EA - Nummer der letzten Bildschirmzeile
; 10EB - initialisiert mit 00 - modifizierte Basisadresse Videoram - low byte
; 10EC - initialisiert mit 20 - modifizierte Basisadresse Videoram - high byte
; 10ED - initialisiert mit 00 - Grundstellung Beeper (immer aus)
; 10EE - initialisiert mit e7b0
; 10F0 - initialisiert mit 1850
; 10F2 - initialisiert mit 00
; 10F3 - initialisiert mit 19
; 10F4 - initialisiert mit a0
; 10F5 - initialisiert mit 17

0000 f3        di
0001 3e00      ld      a,00h
0003 d354      out     (54h),a         ; FDC-Controllerkarte zurcksetzen
0005 3e66      ld      a,66h
0007 d3ea      out     (eah),a         ; Schreibschutz Z80-Combo-RAM aufheben
0009 3e01      ld      a,01h
000b d331      out     (31h),a         ; Tastaturcontroller zurcksetzen
000d 3eff      ld      a,ffh
000f d3f3      out     (f3h),a         ; V.24: RTS und DTR setzen
0011 212010    ld      hl,1020h
0014 f9        ld      sp,hl           ; Top of Stack = 1020

; Loesche Speicher von 1020h bis 10ffh
ClearBuffer:
0015 16e0      ld      d,e0h           ; Zhler: 240 Bytes lschen
0017 3600      ld      (hl),00h        ; Speicherzelle lschen
0019 23        inc     hl              ; Zeiger erhhen
001a 15        dec     d               ; Zhler erniedrigen
001b c21700    jp      nz,0017h        ; und weiter bis Ende

001e cd0003    call    0300h           ; Bildschirm initialisieren
0021 cd1503    call    0315h           ; Tastatur initialisieren
0024 3e01      ld      a,01h           ; Aufrufparameter: Floppy initialisieren
0026 cd0005    call    0500h           ; Floppy-Routine aufrufen
0029 db31      in      a,(31h)         ; Status Tastaturcontroller lesen
002b e6fe      and     feh             ; = 11111110b
002d ca2900    jp      z,0029h         ; FIFO leer, Controller bereit - weiter warten
0030 e68e      and     8eh             ; = 10001110b
0032 ca4000    jp      z,0040h         ; Controller bereit, weniger als 8 Zeichen im Puffer
0035 e608      and     08h             ; = 00001000b
0037 c22900    jp      nz,0029h        ; Controller beschftigt - weiter warten
                                       ; Also: Controller bereit und mehr als 7 Zeichen im FIFO
003a cd1503    call    0315h           ; Tastatur initialisieren, FIFO lschen
003d c32900    jp      0029h           ; wieder warten

0040 cd1803    call    0318h           ; Zeichen von der Tastatur lesen
0043 fe0c      cp      0ch             ; Tastencode fr "B"
0045 ca5a00    jp      z,005ah         ; Start von Floppy
0048 fe6a      cp      6ah             ; Tastencode fr "P"
004a cad000    jp      z,00d0h         ; Start von Festplatte
004d fe2a      cp      2ah             ; Tastencode fr "W"
004f cad000    jp      z,00d0h         ; Start von Festplatte
0052 fe00      cp      00h             ; Reserviert
0054 ca2900    jp      z,0029h         ; Reserviert
0057 c32900    jp      0029h           ; Wieder auf Tastatur warten

BootFloppy:
; Bootversuch von Diskettenlaufwerk
005a 0e03      ld      c,03h           ; 3 Versuche
005c c5        push    bc              ; Zhler sichern
005d 3e01      ld      a,01h           ; Parameter: Initialisieren
005f cd0005    call    0500h
0062 da8700    jp      c,0087h         ; Carry-Flag: Ausgabe 'Floppy nicht bereit ! '
0065 3e0a      ld      a,0ah           ; Parameter: Restore
0067 cd0005    call    0500h
006a 3e82      ld      a,82h           ; Parameter: Lese Bootsektor
006c 012010    ld      bc,1020h        ; Schreibe an diese Adresse
006f 118000    ld      de,0080h        ; 128 Byte (ein CP/M-Sektor)
0072 cd0005    call    0500h
0075 c1        pop     bc              ; Zhlerstand zurcklesen
0076 d28000    jp      nc,0080h        ; Carry nicht gesetzt: Lesen erfolgreich
0079 0d        dec     c               ; Sonst Zhler dekrementieren ..
007a c25c00    jp      nz,005ch        ; .. und neuer Versuch; bei Ende:
007d c38c00    jp      008ch           ; Ausgabe 'Floppyfehler ! '

0080 212010    ld      hl,1020h        ; Bootsektor wurde dorthin gelesen
0083 af        xor     a
0084 d331      out     (31h),a         ; Tastaturcontroller zurcksetzen(?)
0086 e9        jp      (hl)            ; Bootsektor anspringen

0087 21a900    ld      hl,00a9h        ; Text 'Floppy nicht bereit ! '
008a 1803      jr      008fh

008c 21c000    ld      hl,00c0h        ; Text 'Floppyfehler ! '
008f cd9500    call    0095h           ; Text ausgeben
0092 188d      jr      0021h           ; wieder auf Tastendruck warten

0094 00        nop

TextOut:
; Text an Adresse HL ausgeben
; Erstes Zeichen ist die Textlnge
0095 e5        push    hl
0096 cd0003    call    0300h
0099 e1        pop     hl
009a 5e        ld      e,(hl)          ; Lngenbyte
009b 23        inc     hl              ; Erstes Textzeichen
009c d5        push    de              ; DE sichern
009d 4e        ld      c,(hl)          ; Zeichen lesen
009e e5        push    hl              ; Adresse zwischenspeichern
009f cd1203    call    0312h           ; Zeichenausgabe
00a2 e1        pop     hl              ; Adresse zurcklesen
00a3 d1        pop     de              ; Lnge zurcklesen
00a4 1d        dec     e               ; Prfen, ob Ende erreicht
00a5 c29b00    jp      nz,009bh        ; Wenn nein, dann weiter
00a8 c9        ret

00a9 16        db      16h
00aa 46 6c 6f  db      'Floppy nicht bereit ! '
00ad 70 70 79
00b0 20 6e 69
00b3 63 68 74
00b6 20 62 65
00b9 72 65 69
00bc 74 20 21
00bf 20
00c0 0f        db      0fh
00c1 46 6c 6f  db      'Floppyfehler ! '
00c4 70 70 79
00c7 66 65 68
00ca 6c 65 72
00cd 20 21 20
00cf 20

BootWinchester:
; Bootversuch von Festplatte
; zunchst Code von 00e1 bis 0240 nach f800 schieben
00d0 3280ff    ld      (ff80),a
00d3 1100f8    ld      de,f800h
00d6 21e100    ld      hl,00e1h
00d9 016001    ld      bc,0160h
00dc edb0      ldir
00de c300f8    jp      f800h

; Der folgende Code luft nicht hier, sondern
; ab Adresse F800. Parallel wird auf den
; externen Speicher umgeschaltet - vermutlich, damit
; mehr Daten abgelegt werden knnen
00e1 3e10      ld      a,10h           ; f800 Speicherseite 0 auswhlen
00e3 d3f6      out     (f6h),a         ; f802 und umschalten
00e5 210080    ld      hl,8000h        ; f804
00e8 f9        ld      sp,hl           ; f807 Stack neu setzen auf 8000
00e9 cdfcf8    call    f8fch           ; f808 Prfen Port 1c??
00ec 207d      jr      nz,016bh        ; f80b Fehlermeldung "Festplatte nicht aktiv"
00ee 0603      ld      b,03h           ; f80d 3 Versuche(??)
00f0 c5        push    bc              ; f80f
00f1 cd07f9    call    f907h           ; f810
00f4 2072      jr      nz,0168h        ; f813 Nchster Versuch
00f6 2158f9    ld      hl,f958h        ; f815
00f9 0e1c      ld      c,1ch           ; f818
00fb cd2df9    call    f92dh           ; f81a
00fe 2100fa    ld      hl,fa00h        ; f81d
0101 e5        push    hl              ; f820
0102 cd3cf9    call    f93ch           ; f821
0105 cde7f8    call    f8e7h           ; f824
0108 e1        pop     hl              ; f827 Nchster Versuch
0109 205d      jr      nz,0168h        ; f828
010b cd07f9    call    f907h           ; f82a
010e 2058      jr      nz,0168h        ; f82d Nchster Versuch
0110 0e1c      ld      c,1ch           ; f82f
0112 cd2df9    call    f92dh           ; f831
0115 cd4bf9    call    f94bh           ; f834
0118 cde7f8    call    f8e7h           ; f837
011b 204b      jr      nz,0168h        ; f83a Nchster Versuch
011d 3a80ff    ld      a,(ff80h)       ; f83c
0120 2110fa    ld      hl,fa10h        ; f83f
0123 fe6a      cp      6ah             ; f842
0125 2804      jr      z,012bh         ; f844
0127 3e10      ld      a,10h           ; f846
0129 85        add     a,l             ; f848
012a 6f        ld      l,a             ; f849
012b 4e        ld      c,(hl)          ; f84a
012c 23        inc     hl              ; f84b
012d 46        ld      b,(hl)          ; f84c
012e 23        inc     hl              ; f84d
012f 78        ld      a,b             ; f84e
0130 b1        or      c               ; f84f
0131 282e      jr      z,0161h         ; f850 Ausgabe Fehlermeldung "Kein OS"
0133 c5        push    bc              ; f852
0134 cd07f9    call    f907h           ; f853
0137 202e      jr      nz,0167h        ; f856
0139 0e1c      ld      c,1ch           ; f858
013b cd2df9    call    f92dh           ; f85a
013e e1        pop     hl              ; f85d
013f e5        push    hl              ; f85e
0140 cd3cf9    call    f93ch           ; f85f
0143 e1        pop     hl              ; f862
0144 cde7f8    call    f8e7h           ; f863
0147 201f      jr      nz,0168h        ; f866 Nchster Versuch
0149 c1        pop     bc              ; f868
014a 018300    ld      bc,0083h        ; f869
014d 110000    ld      de,0000h        ; f86c
0150 edb0      ldir                    ; f86f
0152 21afd3    ld      hl,d3afh        ; f871
0155 22fdff    ld      (fffdh),hl      ; f874
0158 21d3f6    ld      hl,f6d3h        ; f877
015b 22feff    ld      (fffeh),hl      ; f87a
015e c30000    jp      0000h           ; f87d Sprung ins OS?

0161 21b8f8    ld      hl,f8b8h        ; f880 Meldung "Kein OS"
0164 c1        pop     bc              ; f883 Stack bereinigen
0165 1807      jr      016eh           ; f884 Meldung ausgeben

0167 c1        pop     bc              ; f886
0168 c1        pop     bc              ; f887 Zhler zurcklesen
0169 1085      djnz    00f0h           ; f888 Noch ein Versuch?
016b 219bf8    ld      hl,f89bh        ; f88a Meldung "Festplatte nicht aktiv"
016e af        xor     a               ; f88d Speicherseite 8 (CPU-Karte/Videoram)
016f d3f6      out     (f6h),a         ; f88e auswhlen und umschalten
0171 312010    ld      sp,1020h        ; f890 Stack neu setzem
0174 e5        push    hl              ; f893 Adresse sichern
0175 00        nop                     ; f894 Reserve?
0176 00        nop                     ; f895 Reserve?
0177 00        nop                     ; f896 Reserve?
0178 e1        pop     hl              ; f897 Adresse zurcklesen
0179 c38f00    jp      008fh           ; f898 Meldung ab (HL) ausgeben und zurck

017c 1c        db      1ch             ; f89b
017d 46 65 73  db      'Festplatte ist nicht aktiv !'
0180 74 70 6c
0183 61 74 74
0186 65 20 69
0189 73 74 20
018c 6e 69 63
018f 68 74 20
0192 61 6b 74
0195 69 76 20
0198 21

0199 2e        db      2eh             ; f8b8
019a 42 65 74  db      'Betriebs-System ist nicht auf der Festplatte !'
019d 72 69 65
01a0 62 73 2d
01a3 53 79 73
01a6 74 65 6d
01a9 20 69 73
01ac 74 20 6e
01af 69 63 68
01b2 74 20 61
01b5 75 66 20
01b8 64 65 72
01bb 20 46 65
01be 73 74 70
01c1 6c 61 74
01c4 74 65 20
01C7 21

01c8 db1d      in      a,(1dh)         ; f8e7
01ca e601      and     01h             ; f8e9
01cc 28fa      jr      z,01c8h         ; f8eb
01ce db1c      in      a,(1ch)         ; f8ed
01d0 47        ld      b,a             ; f8ef
01d1 db1d      in      a,(1dh)         ; f8f0
01d3 e601      and     01h             ; f8f2
01d5 28fa      jr      z,01d1h         ; f8f4
01d7 db1c      in      a,(1ch)         ; f8f6
01d9 78        ld      a,b             ; f8f8
01da e61f      and     1fh             ; f8f9
01dc c9        ret                     ; f8fb

01dd 3e00      ld      a,00h           ; f8fc
01df d31c      out     (1ch),a         ; f8fe
01e1 db1c      in      a,(1ch)         ; f900
01e3 a7        and     a               ; f902
01e4 c0        ret     nz              ; f903

01e5 d31d      out     (1dh),a         ; f904
01e7 c9        ret                     ; f906

01e8 010000    ld      bc,0000h        ; f907
01eb 0b        dec     bc              ; f90a
01ec 78        ld      a,b             ; f90b
01ed b1        or      c               ; f90c
01ee 281c      jr      z,020ch         ; f90d
01f0 db1d      in      a,(1dh)         ; f90f
01f2 e602      and     02h             ; f911
01f4 20f5      jr      nz,01ebh        ; f913
01f6 3e01      ld      a,01h           ; f915
01f8 d31c      out     (1ch),a         ; f917
01fa d31e      out     (1eh),a         ; f919
01fc 010080    ld      bc,8000h        ; f91b
01ff 0b        dec     bc              ; f91e
0200 78        ld      a,b             ; f91f
0201 b1        or      c               ; f920
0202 2808      jr      z,020ch         ; f921
0204 db1d      in      a,(1dh)         ; f923
0206 e602      and     02h             ; f925
0208 28f5      jr      z,01ffh         ; f927
020a af        xor     a               ; f929
020b c9        ret                     ; f92a

020c 3d        dec     a               ; f92b
020d c9        ret                     ; f92c

020e db1d      in      a,(1dh)         ; f92d
0210 cb47      bit     0,a             ; f92f
0212 28fa      jr      z,020eh         ; f931
0214 e618      and     18h             ; f933
0216 fe08      cp      08h             ; f935
0218 c0        ret     nz              ; f937

0219 eda3      outi                    ; f938
021b 18f1      jr      020eh           ; f93a

021d db1d      in      a,(1dh)         ; f93c
021f cb47      bit     0,a             ; f93e
0221 28fa      jr      z,021dh         ; f940
0223 e618      and     18h             ; f942
0225 fe10      cp      10h             ; f944
0227 c0        ret     nz              ; f946
0228 eda2      ini                     ; f947
022a 18f1      jr      021dh           ; f949

022c db1d      in      a,(1dh)         ; f94b
022e cb47      bit     0,a             ; f94d
0230 28fa      jr      z,022ch         ; f94f
0232 e618      and     18h             ; f951
0234 c0        ret     nz              ; f953
0235 eda3      outi                    ; f954
0237 18f3      jr      022ch           ; f956

0239 08        ex      af,af'          ; f958
023a 00        nop                     ; f959
023b 00        nop                     ; f95a
023c 00        nop                     ; f95b
023d 0100ff    ld      bc,ff00h        ; f95c

0240 ff        rst     38h             ; f95f
...
02ff ff        rst     38h

; Sprungleiste
0300 c32e03    jp      032eh           ; Videosystem initialisieren
0303 c37c03    jp      037ch           ; Zurcksetzen des Videocontrollers - ungenutzt
0306 c36303    jp      0363h           ; Beeper - im ROM nicht genutzt
0309 c37103    jp      0371h           ; Cursor auf Zeilenanfang setzen - ungenutzt
030c c3a203    jp      03a2h           ; Cursor positionieren (HL) - ungenutzt
030f c39603    jp      0396h           ; Cursor Home - ungenutzt
0312 c38503    jp      0385h           ; CharOut: Zeichen in C auf Bildschirm ausgeben
0315 c3bf03    jp      03bfh           ; Keyboard-Controller initialisieren
0318 c3b203    jp      03b2h           ; CharIn: Nchstes Zeichen lesen

; Tabelle mit Parametern fr CRTC, gehen an Port 20 bis 26
; Einstellungen fr 80 x 24
031b 65        db      065h            ; Zeilenlnge: 101
                                       ; Videotakt/(Zeichenbreite*Rasterzeilen*Bildfrequenz)
                                       ; 12,8112MHz/(8*314*50)
031c 3d        db      00111101b       ; ohne Zeilensprung,
                                       ; Breite Zeilensynchronimpuls: 7
                                       ; Abstand Bild zum Impuls: 5
031d 5d        db      01011101b       ; Rasterzeilen pro Zeichen: 12
                                       ; Zeichen pro Zeile: 80
031e 57        db      01010111b       ; Verzgerung Austastsignal 1, Cursor 0
                                       ; Anzahl Zeichenzeilen: 24
031f 1d        db      01dh            ; Anzahl Rasterzeilen: 314
0320 12        db      012h            ; Anzahl leerer Rasterzeilen oben: 18
0321 17        db      017h            ; Nr. der letzten Zeichenzeile: 23

0322 b0        dw      0e7b0h          ; wird nach 10EE/10EF kopiert
0324 50        dw      01850h          ; wird nach 10F0/10F1 kopiert
0326 00        db      000h            ; wird nach 10F2 kopiert
0327 19        db      019h            ; wird nach 10F3 kopiert
0328 a0        db      0a0h            ; wird nach 10F4 kopiert
0329 17        db      017h            ; wird nach 10F5 kopiert

032a 1847      dw      04718h          ; wird nach 10E2/10E3 kopiert
032c 80 2b     db      080h, 02bh      ; wird nach 10E7/10E6 kopiert

; 1. Routine aus Sprungtabelle
; Initialisiert das Videosystem
032e 212203    ld      hl,0322h
0331 cdb004    call    04b0h           ; Kopiert 8 Byte ab HL an 10EE ff
0334 56        ld      d,(hl)
0335 23        inc     hl
0336 5e        ld      e,(hl)          ; de=1847
0337 23        inc     hl
0338 4e        ld      c,(hl)
0339 23        inc     hl
033a 46        ld      b,(hl)          ; bc=2b80
033b eb        ex      de,hl
033c 22e210    ld      (10e2h),hl      ; 10e2=47, 10e3=18
033f c5        push    bc
0340 e1        pop     hl
0341 22e610    ld      (10e6h),hl      ; 10e6=80, 10e7=2b
0344 2e20      ld      l,20h
0346 2600      ld      h,00h
0348 22e010    ld      (10e0h),hl      ; 10e0=20, 10e1=00
034b cd0404    call    0404h           ; Initialisierung CRTC
034e af        xor     a
034f d334      out     (34h),a         ; Lupenfunktion ausschalten
0351 c3da04    jp      04dah           ; Cursor anzeigen

; Zeichen in e mit Attribut d an die durch 10e6 angegebene Position
; des Bildschirmspeichers schreiben
0354 2ae610    ld      hl,(10e6h)      ; Aktuelle Adresse lesen
0357 7c        ld      a,h
0358 f610      or      10h             ; Adresskorrektur (aus 2xxx wird 3xxx)
035a 67        ld      h,a
035b 7a        ld      a,d             ; Attribut in A
035c e680      and     80h             ; davon interessiert nur Bit 7
035e b3        or      e               ; Zeichen dazu nehmen
035f cd5904    call    0459h           ; A in Videoram-Position HL schreiben
0362 c9        ret

Beep:
; Lsst den Beeper kurz beepen
0363 cdd503    call    03d5h           ; Beeper aktivieren
0366 1680      ld      d,80h
0368 cdce03    call    03ceh           ; Pause: de auf 0 herabzhlen
036b 3aed10    ld      a,(10edh)       ; Grundeinstellung Beeper
036e d332      out     (32h),a         ; Beeper wieder in Grundstelllung (aus)
0370 c9        ret

; Setzt den Cursor auf den Zeilenanfang
0371 cdcb04    call    04cbh           ; Zeichen unter Cursor restaurieren
0374 2ae410    ld      hl,(10e4h)      ; Position aus Zwischenspeicher lesen
0377 2e00      ld      l,00h           ; Spalte 1
0379 c39c03    jp      039ch           ; Cursorposition berechnen

; 2. Routine aus Sprungtabelle
; Setzt den CRTC zurck
037c cd0804    call    0408h           ; CRTC auf Standardwerte zurcksetzen
037f 2ae410    ld      hl,(10e4h)      ; Letzte Position zurcklesen
0382 c39c03    jp      039ch           ; Cursorposition berechnen

CharOut:
; Gibt das Zeichen in C an der aktuellen Bildschirmposition aus
0385 3ae110    ld      a,(10e1h)       ; Aktuelles Attribut
0388 57        ld      d,a             ; nach d
0389 59        ld      e,c             ; Zeichen nach e
038a cd5403    call    0354h           ; Zeichen mit Attribut an aktuelle Position schreiben
038d 010100    ld      bc,0001h        ; Ein Zeichen weiter
0390 cd8604    call    0486h           ; wird hier berechnet
0393 c3da04    jp      04dah           ; Cursor anzeigen

CursorHome:
; Setzt den Cursor nach links oben
0396 cdcb04    call    04cbh           ; Zeichen unter Cursor restaurieren
0399 210001    ld      hl,0100h        ; Positionieren: Zeile 1, Spalte 1
039c cdd304    call    04d3h           ; Cursorposition berechnen
039f c3da04    jp      04dah           ; Cursor anzeigen

;Setzt den Cursor auf die Position H (Zeile) und L (Spalte)
03a2 e5        push    hl              ; Position sichern
03a3 cdcb04    call    04cbh           ; Zeichen unter Cursor restaurieren
03a6 e1        pop     hl              ; Position restaurieren
03a7 c39c03    jp      039ch           ; und Speicheradresse berechnen

; Warten, bis Tastaturcontroller bereit
03aa db31      in      a,(31h)         ; Statusbyte lesen
03ac e608      and     08h             ; Bit 3=1: Controller ist beschftigt
03ae c2aa03    jp      nz,03aah        ; Zurck wenn bereit
03b1 c9        ret

CharIn:
; Zeichen von der Tastatur lesen
03b2 cdaa03    call    03aah           ; Auf Tastaturcontroller warten
03b5 3e40      ld      a,40h
03b7 d331      out     (31h),a         ; Befehl 40: FIFO lesen
03b9 cdaa03    call    03aah           ; Auf Tastaturcontroller warten
03bc db30      in      a,(30h)         ; Zeichen von Port 30 lesen
03be c9        ret

;
03bf cdaa03    call    03aah           ; Auf Tastaturcontroller warten
03c2 3ea3      ld      a,a3h           ; Befehl: FIFO lschen
03c4 d331      out     (31h),a         ; An Tastaturcontroller ausgeben
03c6 cdaa03    call    03aah           ; Auf Tastaturcontroller warten
03c9 3e08      ld      a,08h           ; Befehl: N-Key rollover, Normalbetrieb
03cb d331      out     (31h),a         ; An Tastaturcontroller ausgeben
03cd c9        ret

Delay_DE:
; Zhlt de bis 0 herunter
03ce 1b        dec     de
03cf 7b        ld      a,e
03d0 b2        or      d
03d1 c2ce03    jp      nz,03ceh
03d4 c9        ret

; Beeper aktivieren
03d5 3aed10    ld      a,(10edh)       ; Wozu??
03d8 f601      or      01h             ; das reicht doch?!?!
03da d332      out     (32h),a         ; Beeper einschalten
03dc c9        ret

SetCursor:
; Berechnet die Cursorposition. In DE steht Zeile (1..24) und Spalte (0..79)
03dd d5        push    de
03de 210000    ld      hl,0000h        ; Basisadresse
03e1 018000    ld      bc,0080h        ; Die Lnge einer Zeile (128 Zeichen)
03e4 15        dec     d               ; wird entsprechend der Zeilenzahl
03e5 caec03    jp      z,03ech
03e8 09        add     hl,bc           ; auf die Basisadresse aufaddiert
03e9 c3e403    jp      03e4h

03ec 19        add     hl,de           ; d ist hier 0, also nur noch die Spalte
03ed eb        ex      de,hl           ; Ergebnis nach d sichern
03ee 2aeb10    ld      hl,(10ebh)      ; Basisadresse Videoram (2000 statt 3000)
03f1 19        add     hl,de
03f2 3a2d03    ld      a,(032dh)       ; Dort steht 2bh (= letzten 2 Zeilen)
03f5 3c        inc     a               ; Erste Adresse jenseits des Bildschirms
03f6 5f        ld      e,a
03f7 7c        ld      a,h             ; Die berechnete Adresse
03f8 93        sub     e               ; dagegen prfen
03f9 daff03    jp      c,03ffh         ; Wenn kleiner: Alles ok
03fc f620      or      20h             ; Sonst geht's oben weiter
03fe 67        ld      h,a
03ff 22e610    ld      (10e6h),hl      ; Aktuelle Cursorposition speichern
0402 d1        pop     de
0403 c9        ret

; Initialisierung des CRTC 5026
0404 d32e      out     (2eh),a         ; Zeitsteuerung starten (Wert ist egal!)
0406 d32a      out     (2ah),a         ; Zeitsteuerung stoppen (dito)
0408 211b03    ld      hl,031bh        ; Parametertabelle fr 80x24
040b 7e        ld      a,(hl)          ; lesen und
040c d320      out     (20h),a         ; in den Controller schreiben
040e 23        inc     hl
040f 7e        ld      a,(hl)          ; etc...
0410 d321      out     (21h),a
0412 23        inc     hl
0413 7e        ld      a,(hl)
0414 d322      out     (22h),a
0416 23        inc     hl
0417 7e        ld      a,(hl)
0418 d323      out     (23h),a
041a 23        inc     hl
041b 7e        ld      a,(hl)
041c d324      out     (24h),a
041e 23        inc     hl
041f 7e        ld      a,(hl)
0420 d325      out     (25h),a
0422 23        inc     hl
0423 7e        ld      a,(hl)
0424 d326      out     (26h),a         ; Nummer der letzten Zeichenzeile
0426 32ea10    ld      (10eah),a       ; sichern
0429 3c        inc     a               ; Anzahl Zeilen
042a 32e510    ld      (10e5h),a       ; sichern
042d af        xor     a               ; A lschen
042e 32ed10    ld      (10edh),a       ; Beeper aus
0431 32e410    ld      (10e4h),a       ; Cursorspalte
0434 2f        cpl                     ; A=0ffh
0435 d32d      out     (2dh),a         ; ??
0437 2e00      ld      l,00h
0439 2620      ld      h,20h           ; hl=02000h
043b 22eb10    ld      (10ebh),hl      ; (Modifizierte) Basisadresse Videoram??
043e 22e810    ld      (10e8h),hl      ; Zeichen unter dem Cursor samt Attribut
0441 d32e      out     (2eh),a         ; Zeitsteuerung starten
0443 210030    ld      hl,3000h        ; Bildschirmspeicher ab Adresse 3000h
0446 0e20      ld      c,20h           ; mit Leerzeichen lschen
0448 c36b04    jp      046bh           ; FillScreen

; Zeichen an der Videoram-Position HL nach A lesen,
; dabei Anfang einer Zeilenaustastlcke (HSYNC) abwarten
044b db35      in      a,(35h)         ; Synchronsignale prfen
044d 07        rlca                    ; MSB ins Carry schieben
044e da4b04    jp      c,044bh         ; Wenn gesetzt: warten, weil mitten drin
0451 db35      in      a,(35h)         ; Erneut lesen:
0453 07        rlca                    ; MSB ins Carry schieben
0454 d25104    jp      nc,0451h        ; Nicht gesetzt: Warten bis Anfang HSYNC
0457 7e        ld      a,(hl)          ; Zeichen lesen
0458 c9        ret

; Zeichen  in A an Adress HL in Videoram schreiben,
; dabei Anfang einer Zeilenaustastlcke (HSYNC) abwarten
0459 c5        push    bc              ; BC sichern
045a 4f        ld      c,a             ; A nach C bertragen
045b db35      in      a,(35h)         ; Status CRTC lesen
045d 07        rlca                    ; MSB in Carry schieben
045e da5b04    jp      c,045bh         ; Warten auf Ende Austastlcke
0461 db35      in      a,(35h)         ; Erneut lesen
0463 07        rlca                    ; MSB in Carry schieben
0464 d26104    jp      nc,0461h        ; Warten auf Beginn Austastlcke
0467 71        ld      (hl),c          ; Jetzt Zeichen schreiben
0468 c1        pop     bc              ; BC zurcklesen
0469 b7        or      a               ;
046a c9        ret

FillScreen:
; Fllt den Bildschirmspeicher komplett mit dem Zeichen in C
046b 118007    ld      de,0780h        ; 1920 Zeichen ab Position HL
046e 0650      ld      b,50h           ; in Blcken von 80 Zeichen schreiben
0470 79        ld      a,c             ; mit C fllen
0471 cd5904    call    0459h           ; A in Videoram-Position HL schreiben
0474 23        inc     hl              ; Nchste Position
0475 1b        dec     de              ; Prfen, ob Ende erreicht
0476 7b        ld      a,e
0477 b2        or      d
0478 c8        ret     z               ; dann zurck

0479 05        dec     b               ; Sonst: Zeilenlnge prfen
047a c27004    jp      nz,0470h        ; Noch kein Zeilenende
047d c5        push    bc              ; Am Ende der Zeile
047e 013000    ld      bc,0030h        ; 48 Adressen berspringen
0481 09        add     hl,bc
0482 c1        pop     bc
0483 c36e04    jp      046eh           ; und nchste Zeile

; Korrektur Bildschirmposition berechnen
; BC = Schrittweite
0486 2aee10    ld      hl,(10eeh)      ; hl = e7b0h
0489 eb        ex      de,hl
048a 2ae410    ld      hl,(10e4h)      ; Aktuelle Position des Cursors
048d 19        add     hl,de
048e 7c        ld      a,h
048f 09        add     hl,bc
0490 daaa04    jp      c,04aah
0493 bc        cp      h
0494 eb        ex      de,hl
0495 c2a004    jp      nz,04a0h
0498 2af010    ld      hl,(10f0h)      ; hl = 1850h
049b eb        ex      de,hl
049c 19        add     hl,de
049d c3d304    jp      04d3h           ; Cursorposition berechnen

04a0 2af210    ld      hl,(10f2h)      ; enthlt 1900 - ist eine Zeile weiter
04a3 eb        ex      de,hl           ; als erlaubt ....
04a4 19        add     hl,de           ; ??
04a5 2e00      ld      l,00h           ; Zeilenanfang
04a7 c3d304    jp      04d3h           ; Cursorposition berechnen

; Cursor Home
04aa 210001    ld      hl,0100h        ; Zeile 1 Spalte 0
04ad c3d304    jp      04d3h           ; Cursorposition berechnen

; Kopiert 8 Byte von (HL) bis (HL+7) nach 10EE bis 10F5
; Aufruf von 0331 (Initialisierung CRTC)
04b0 01ee10    ld      bc,10eeh
04b3 1608      ld      d,08h
04b5 7e        ld      a,(hl)
04b6 02        ld      (bc),a
04b7 23        inc     hl
04b8 03        inc     bc
04b9 15        dec     d
04ba c2b504    jp      nz,04b5h
04bd c9        ret

; ??? Nie angesprungen - Daten ???
04be 7b        ld      a,e
04bf 94        sub     h
04c0 d0        ret     nc
04c1 7c        ld      a,h
04c2 93        sub     e
04c3 3d        dec     a
04c4 57        ld      d,a
04c5 7c        ld      a,h
04c6 e620      and     20h
04c8 b2        or      d
04c9 67        ld      h,a
04ca c9        ret

; Zeichen unter dem Cursor restaurieren
04cb 2ae810    ld      hl,(10e8h)      ; Zeichen unter dem Cursor
04ce 55        ld      d,l             ; Attribut aus 10e8
04cf 5c        ld      e,h             ; Zeichen aus 10e9
04d0 c35403    jp      0354h           ; an der aktuellen Cursorposition  ausgeben

; Vorbereitung fr SetCursor
04d3 22e410    ld      (10e4h),hl      ; Position zwischenspeichern
04d6 eb        ex      de,hl           ; nach DE verschieben
04d7 c3dd03    jp      03ddh           ; und Cursorposition berechnen

ShowCursor:
; Cursor anzeigen
; Ist nicht korrekt ausprogrammiert - das i-Tpfelchen fehlt ...
04da 2ae610    ld      hl,(10e6h)      ; Aktuelle Cursorposition lesen
04dd af        xor     a
04de 32e810    ld      (10e8h),a       ; Attribut lschen - wozu?
04e1 e5        push    hl              ; Position zwischenspeichern
04e2 7c        ld      a,h
04e3 f610      or      10h             ; Korrektur Adresse Videoram
04e5 67        ld      h,a
04e6 cd4b04    call    044bh           ; Zeichen aus Videoram-Position HL lesen
04e9 32e910    ld      (10e9h),a       ; Zeichen sichern
04ec ee80      xor     80h             ; Attribut invertieren (=Cursor)
04ee 00        nop                     ; Hier sollte jetzt eine Ausgabe
04ef 00        nop                     ; erfolgen...
04f0 00        nop                     ; z.B. call 0459
04f1 e1        pop     hl
04f2 c9        ret

04f3 ff        rst     38h
04f4 ff        rst     38h
04f5 ff        rst     38h
04f6 ff        rst     38h
04f7 ff        rst     38h
04f8 ff        rst     38h
04f9 ff        rst     38h
04fa ff        rst     38h
04fb ff        rst     38h
04fc ff        rst     38h
04fd ff        rst     38h
04fe ff        rst     38h
04ff 00        nop

; Allgemeine Routine fr Diskettenzugriff
; In A wird die gewnschte Funktion bergeben:
; 01: Floppy initialisieren
; 0a: Kopf kalibrieren (Restore Spur 0)
; 82: Bootsektor lesen
0500 f3        di
0501 210000    ld      hl,0000h
0504 39        add     hl,sp           ; Stackpointer
0505 22c010    ld      (10c0h),hl      ; an Adresse 10c0, 10c1 Sichern
0508 f5        push    af              ; Aufrufparameter sichern
0509 cde505    call    05e5h           ; 05 nach 10ca schreiben
050c 210000    ld      hl,0000h
050f 22c210    ld      (10c2h),hl      ; 10c2, 10c3 loeschen
0512 21c410    ld      hl,10c4h
0515 71        ld      (hl),c          ; c in 10c4 sichern
0516 23        inc     hl
0517 70        ld      (hl),b          ; b in 10c5 sichern
0518 23        inc     hl
0519 73        ld      (hl),e          ; e in 10c6 sichern
051a 23        inc     hl
051b 72        ld      (hl),d          ; d in 10c7 sichern
051c f1        pop     af              ; Akku restaurieren
051d fe01      cp      01h             ; Aufgerufen mit 01?
051f ca4f05    jp      z,054fh         ; Dann 054f
0522 fe0a      cp      0ah             ; Aufgerufen mit 0a?
0524 ca2406    jp      z,0624h         ; Dann 0624
0527 c38c05    jp      058ch           ; Sonst 058c

; Ende der Routine, Ergebnis setzen, Aufrumen
052a 3e01      ld      a,01h           ; Bit 1 im Ergebnis setzen
052c cd4a06    call    064ah           ; Ergebnis in 10c2 setzen
052f 21c810    ld      hl,10c8h        ; Speicherort Spurnummer
0532 cd4306    call    0643h           ; Warten bis FDC bereit
0535 db51      in      a,(51h)         ; Spurregister lesen
0537 5f        ld      e,a             ; Aktuelle Spurnummer sichern in e
0538 77        ld      (hl),a          ; und an Adresse 10c8
0539 23        inc     hl
053a cd4306    call    0643h           ; Warten bis FDC bereit
053d db52      in      a,(52h)         ; Sektorregister lesen
053f 57        ld      d,a             ; Aktuelle Sektornummer sichern in d
0540 77        ld      (hl),a          ; und an Adresse 10c9
0541 2ac210    ld      hl,(10c2h)      ; Akku und Flags
0544 4d        ld      c,l             ; in BC zwischenspeichern
0545 44        ld      b,h
0546 2ac010    ld      hl,(10c0h)      ; Stackpointer zurcklesen
0549 f9        ld      sp,hl           ; Stackpointer umladen
054a c5        push    bc              ; BC per Stack nach AF
054b f1        pop     af
054c 3e30      ld      a,30h           ; Nur Flags berleben
054e c9        ret

; Einsprung 0500 mit af=01
054f 3e9b      ld      a,10011011b     ; Select Drive 1, Motor on,
                                       ; Trverriegelung, Schreibkompensation,
                                       ; Daten-Trennstufe auf Lesen
0551 d354      out     (54h),a         ; Kartenbefehlsregister schreiben
0553 3e9a      ld      a,10011010b     ; wie oben, aber Daten-Trennstufe anders
0555 d354      out     (54h),a         ; Kartenbefehlsregister schreiben
0557 cd6805    call    0568h           ; Warten, bis Drive 1 bereit ist
055a 0e08      ld      c,08h           ; 8 mal wiederholen:
055c 3e52      ld      a,52h           ; Step-In, Head unload, no Verify
055e cd8706    call    0687h           ; Befehl an FDC und auf Bereit warten
0561 0d        dec     c               ; Zhler erniedrigen
0562 c25c05    jp      nz,055ch        ; und ggfs. wiederholen
0565 c32f05    jp      052fh           ; und zurck

WaitDrive1:
; Warten auf Drive 1
0568 cd8505    call    0585h           ; Prfen, ob bereit
056b d0        ret     nc              ; Wenn ja, zurck
056c e5        push    hl              ; hl sichern
056d 26ff      ld      h,ffh           ; ca 65.000 mal prfen
056f 2b        dec     hl              ; hl runterzhlen
0570 7c        ld      a,h             ; und auf 0 prfen
0571 b5        or      l
0572 ca7d05    jp      z,057dh         ; Wartezeit abgelaufen
0575 cd8505    call    0585h           ; Prfen, ob Drive mittlerweile bereit
0578 da6f05    jp      c,056fh         ; Wenn nicht, weiter versuchen
057b e1        pop     hl              ; Jetzt bereit. hl restaurieren ...
057c c9        ret                     ; ... und zurck

057d 3e10      ld      a,10h
057f cd5306    call    0653h           ; A in Ergbnis 10C3 setzen
0582 c32a05    jp      052ah           ; und Routine verlassen

; Prfen, ob Drive 1 bereit
; Nicht bereit wird durch Carry-Flag signalisiert
ChkDrive1:
0585 db54      in      a,(54h)         ; Status Floppy-Controllerkarte
0587 e604      and     04h             ; Prfen ob Drive 1 bereit
0589 c0        ret     nz
058a 37        scf                     ; Wenn nicht bereit, CY setzen
058b c9        ret

; Liest anscheinend einen Sektor (bzw. soviel Byte wie in DE angegeben)
; und schreibt sie ab der Adresse HL in den Speicher
058c cd0406    call    0604h
058f 3e88      ld      a,88h           ; FDC-Kommando: Read Single Sector
0591 0e00      ld      c,00h           ; ?? Wozu ??
0593 cd8d06    call    068dh           ; Befehl an FDC
0596 7a        ld      a,d             ; Maximalzahl erreicht?
0597 b3        or      e
0598 cabc05    jp      z,05bch         ; dann fertig
059b db54      in      a,(54h)         ; Status Floppy-Controllerkarte
059d 07        rlca
059e d2a905    jp      nc,05a9h
05a1 db53      in      a,(53h)         ; FDC Datenregister lesen
05a3 77        ld      (hl),a          ; In Speicher schreiben
05a4 23        inc     hl              ; Adresse erhhen
05a5 1b        dec     de              ; Zhler erniedrigen
05a6 c39605    jp      0596h           ; und zum Schleifenanfang

05a9 07        rlca
05aa d29b05    jp      nc,059bh
05ad cdde05    call    05deh
05b0 c28c05    jp      nz,058ch
05b3 cdc805    call    05c8h
05b6 da2a05    jp      c,052ah         ; Floppy-Routine verlassen
05b9 c38f05    jp      058fh

05bc cd5a06    call    065ah           ; Byte aus FDC lesen
05bf cdc805    call    05c8h
05c2 da2a05    jp      c,052ah         ; Floppy-Routine verlassen
05c5 c32f05    jp      052fh

05c8 cdfa05    call    05fah
05cb d8        ret     c
05cc c36d06    jp      066dh

05cf 3e1e      ld      a,1eh           ; FDC-Kommando: Seek
05d1 cd8d06    call    068dh           ; Befehl an FDC
05d4 cd4306    call    0643h           ; Warten bis FDC bereit
05d7 cdde05    call    05deh           ; Prfen, ob erfolgreich
05da c2cf05    jp      nz,05cfh        ; Wenn nicht: Nochmal
05dd c9        ret

05de db50      in      a,(50h)         ; Lesen FDC-Status
05e0 e610      and     10h             ; Pruefen, ob Seek Error
05e2 c2eb05    jp      nz,05ebh        ; Ups, Fehler
05e5 3e05      ld      a,05h           ; Jetzt 5 Versuche
05e7 32ca10    ld      (10cah),a       ; Zhler fr verbleibende Versuche
05ea c9        ret

05eb 3aca10    ld      a,(10cah)       ; Anzahl briger Versuche
05ee 3d        dec     a               ; runterzhlen
05ef c2e705    jp      nz,05e7h        ; und ggfs. noch mal probieren
05f2 3e90      ld      a,90h           ; Bits 7 und 4 im Ergebnis setzen
05f4 cd4a06    call    064ah           ; Ergebnis in 10c2 setzen
05f7 c32a05    jp      052ah           ; Floppy-Routine verlassen

05fa db50      in      a,(50h)         ; Lesen FDC-Status
05fc e608      and     08h             ; CRC-Error?
05fe c8        ret     z               ; Wenn nein, zurck
05ff 3e80      ld      a,80h           ; Sonst Bit 4 im Ergebnis setzen
0601 c34a06    jp      064ah           ; Ergebnis in 10c2 setzen

0604 f5        push    af
0605 cd6805    call    0568h           ; Warten auf Laufwerk 1
0608 cd4306    call    0643h           ; Warten bis FDC bereit
060b 21c810    ld      hl,10c8h        ; Speicherort Spurnummer
060e 7e        ld      a,(hl)          ; Spurnummer nach A laden
060f d353      out     (53h),a         ; FDC Datenregister schreiben
0611 23        inc     hl
0612 cd4306    call    0643h           ; Warten bis FDC bereit
0615 7e        ld      a,(hl)          ; Sektornummer nach A laden
0616 d352      out     (52h),a         ; Sektornummer in Sektorregister
0618 cdcf05    call    05cfh           ; Seek durchfhren
061b f1        pop     af
061c 2ac610    ld      hl,(10c6h)      ; DE zurcklesen per HL
061f eb        ex      de,hl           ; dahin, wo es hingehrt
0620 2ac410    ld      hl,(10c4h)      ; HL zurcklesen
0623 c9        ret

0624 cd2f06    call    062fh           ; Restore Disk (Seek Track 0)
0627 3e40      ld      a,40h
0629 cd5306    call    0653h           ; A in Ergebnis 10c3 setzen
062c c32f05    jp      052fh

RestoreDisk:
; Aktuelles Laufwerk auf Spur 0 zurckfahren
062f 3e02      ld      a,02h           ; FDC-Kommando: Restore
0631 cd8d06    call    068dh           ; Befehl an FDC
0634 cd4306    call    0643h           ; Warten bis FDC bereit
0637 3e01      ld      a,01h           ; Sektornummer 1
0639 d352      out     (52h),a         ; in Sektorregister schreiben
063b db50      in      a,(50h)         ; Lesen FDC-Status
063d e604      and     04h             ; Spur 0 erreicht?
063f ca2a05    jp      z,052ah         ; Wenn nicht, weiterwarten
0642 c9        ret

Wait_FDC_Ready:
; Warten, bis der FDC bereit ist
0643 db50      in      a,(50h)         ; Lesen FDC-Status
0645 0f        rrca                    ; Busy-Bit in Carry schieben
0646 d0        ret     nc              ; Wenn bereit, zurck
0647 c34306    jp      0643h           ; Sonst weiterwarten

; A in die "Ergebnis"-Zelle 10C2 schreiben (oder-verknpft)
064a e5        push    hl
064b 21c210    ld      hl,10c2h
064e b6        or      (hl)
064f 77        ld      (hl),a
0650 3f        ccf
0651 e1        pop     hl
0652 c9        ret

; A in die "Ergebnis"-Zelle 10C3 schreiben (oder-verknpft)
0653 e5        push    hl
0654 21c310    ld      hl,10c3h
0657 c34e06    jp      064eh

; Datenbyte vom FDC lesen
065a cd6306    call    0663h           ; Warten auf Daten vom Controller
065d d8        ret     c               ; Zurck ohne Daten?
065e db53      in      a,(53h)         ; FDC Datenregister lesen
0660 c35a06    jp      065ah

; Warten auf Daten vom Floppy-Controller
; CY=0: Daten vorhanden                         
0663 db54      in      a,(54h)         ; Kartenstatus lesen
0665 07        rlca                    ; /DRQ ins Carry schieben
0666 3f        ccf                     ; Komplementieren
0667 d0        ret     nc              ; Daten bereit
0668 07        rlca                    ; INTRQ ins Carry schieben
0669 d26306    jp      nc,0663h        ; Weiterwarten, falls kein INTRQ
066c c9        ret

; Sektornummer erhhen
066d db52      in      a,(52h)         ; Sektorregister lesen
066f 4f        ld      c,a             ; in C sichern
0670 fe10      cp      10h             ; Maximale Sektorzahl erreicht?
0672 ca7d06    jp      z,067dh         ; Dann nchste Spur
0675 0c        inc     c               ; Sektornummer erhhen
0676 cd4306    call    0643h           ; warten bis FDC bereit
0679 79        ld      a,c             ; und neuen Sektor ins
067a d352      out     (52h),a         ; Sektorregister schreiben
067c c9        ret

067d cd8506    call    0685h           ; FDC StepIn
0680 0e01      ld      c,01h           ; Neue Sektornummer 1
0682 c37606    jp      0676h           ; und zurckschreiben

FDC_StepIn:
; Kopf einen Track weiterbewegen
0685 3e5a      ld      a,5ah           ; FDC-Kommando: Step-In
0687 cd8d06    call    068dh           ; Befehl an FDC
068a c34306    jp      0643h           ; Warten bis FDC bereit

FDC_Command:
; Befehl in FDC schreiben
068d f5        push    af              ; Befehl sichern
068e db50      in      a,(50h)         ; Lesen FDC-Status
0690 0f        rrca                    ; Busy-Bit prfen
0691 da8e06    jp      c,068eh         ; Wiederholen bis bereit
0694 f1        pop     af              ; Befehl zurckholen
0695 d350      out     (50h),a         ; und an FDC schicken
0697 c9        ret

0698 ff        rst     38h
...
07ff ff        rst     38h
