; I/O Characteristics for System 8000 under CP/M 3.0
; User patch area for system constants
			
;*************************************************
;
; Copyright (C) 1983, 1984 by
;
; 		Datentechnik oettle + reichler
;
; 		Schie~grabenstr. 28 a
; 		D- 8900 Augsburg 1
; 		Tel.: (0821) 15 46 32
;
;*************************************************


	maclib modebaud		; macro library definition

	public @intab,@ctbl	; public data items for character I/O
	public ucinit,ucout
	public uconin,ucinst
	public ucost		; publics for user supplied I/O-devices
	public vaconf,vbconf	; publics for v24a / v24b characteristics
	public cyear		; current year
	public datkey,timkey
	public brkkey		; definitions for special bios functions

	public rambnk		; ram-flpy starting bank
	public ramtst		; test flag for ram-flpy
	public tpalen		; length of tpa-region
	public motwai		; delay time if drive-motor is off

	public ulogin		; user supplied login 
	public uread,uwrite	; user supplied disk read, write entries

; external names for BIOS entry points
; Use these names if need for.

	extrn ?boot,?wboot,?const
	extrn ?conin,?cono,?list
	extrn ?auxo,?auxi,?home
	extrn ?sldsk,?sttrk,?stsec
	extrn ?stdma,?read,?write
	extrn ?lists,?sctrn,?conos
	extrn ?auxis,?auxos,?dvtbl
	extrn ?devin,?drtbl,?mltio
	extrn ?flush,?mov,?tim
	extrn ?bnksl,?stbnk,?xmov


; *****************************************
; BIOS DATA CONSTANTS
; *****************************************

    ; disk communication data items

@trk:		equ	0fc00h
@sect:		equ	0fc02h
@dma:		equ	0fc04h
@dbnk:		equ	0fc06h
@cbnk:		equ	0fc07h
@adrv:		equ	0fc08h
@cnt:		equ	0fc09h


; *********************************************
; Character I/O definitons
; *********************************************


; I/O Characteristics
;device	name	dir	baud	prot	  hardware	    
;------------------------------------------------------------------------
; 0	crt	i/o	soft	special	  gdp/keyin (out only System 8043, 8023)	      
; 1	v24a	i/o	soft	xon/xoff  darta, sti timer d
; 2	v24b	i/o	soft	xon/xoff  dartb, sti timer c
; 3	centr	o	none	none	  pio 8255, sti gpip, 74373
; 4	paral	i	none	none	  pio 8255 C (only System 8043,33)
; 5	ttlser	i/o	soft	xon/xoff  sti seriell
; 6	diablo	i/o	soft	etx/ack	  v24b

; Device 0 RGB-Term is only under System 8043 and 8023 supported 
; Device 4 is only under System 8043 and 8033 supported

	cseg			; This part resides in common memory

; You can install in the following table the baudrates and optional
; xon/xoff protocol for the 6 logical serial devices on coldboot
; Refer to file modebaud.lib for valid modifications

; If you want you install own devices write your driver in
; ucinit,ucout,uconin,ucinst,ucost and add the new device (7 - 15)
; in the @ctbl.

; Assemble your modified file USRDEF0.ASM using RMAC:
; A>RMAC USRDEF0.ASM

; Link the file USRDEF0.REL with the bios modules.
; Thus the linker creates the system page relocatable file BNKBIOS3.SPR
; Use GENCPM.COM and optional GENCPM.DAT to create a new CPM3.SYS file.
; GENCPM needs the files RESBDOS3.SPR, BNKBDOS3.SPR and BNKBIOS3.SPR as input
; Modifications on the default input data of GENCPM should be done very
; carefully, please refer to datentechnik oettle + reichler if you have
; any trouble with your new installation

; See more under READ.ME1

;*************************************************************
;             Baudrates and Protocolls
;*************************************************************

; All baudrates defined in modebaud.lib will be from now  on 
; supported. Be care under system 8010/23: A baudrate of 19200
; is only a approximation and will result in a baudrate of 
; 23000.

@ctbl:	
	; Device 0 CRT (RGB-Terminal)

	db 'CRT   '
	db mb$in$out+mb$serial+mb$softbaud
	db baud$9600

	; Device 1 V24A (DART channel A)

	db 'V24-A '
	db mbinout+mb$serial+mb$softbaud
	db baud$9600

	; Device 2 V24B (DART channel B)

	db 'V24-B '
	db mb$in$out+mb$serial+mb$softbaud
	db baud$1200

	; Device 3 CENTR (Centronics Interface)

	db 'CENTR '
	db mb$output
	db baud$none

	; Device 4 PARA (Parallel port PIO 8255)

	db 'PARA  '
	db mb$input
	db baud$none

	; Device 5 TTLSER (STI serial channel)
	; Select same baudrate as in device 0 CRT

	db 'TTLSER'
	db mbin$out+mb$serial+mb$softbaud
	db baud$9600

	; Device 6 DIABLO (DART channel B with etx/ack Protocol)
	; Select same baudrate as in device 2 V24B
	; Do not implement a xon/xoff Protocol

	db 'DIABLO'
	db mb$in$out+mb$serial+mb$softbaud
	db baud$1200

; Here you can add your own devices in the @ctbl

	db 0			; last entry terminated by zero

; ************************************************************
; User suplied Character I/O-Routines
; ************************************************************

; If you add own I/O-devices to your system you give them
; the character-device-number from 7 to 15. Device 0 to 6
; is suplied by standard bios. Write the routines to handle
; the I/O at this place. CBIOS-3 will call these entries if
; not-standard-device (7 to 15) will be choosen by applications.

; ******************************************
; User supplied Character-I/O initialisation
; ******************************************

; This entry is called by CBIOS-3 to init user-devices
; The device number for the particular device is given
; in register <c>.

UCINIT:		; yet doing nothing

; ******************************************
; User supplied Character-Output
; ******************************************

; This entry is called by CBIOS-3 to output a character to 
; user-devices. The character to output is in register <c>.
; The device number for the particular device is given
; in register <b>.

UCOUT:		; yet doing nothing

; ******************************************
; User supplied Character-Output-Status
; ******************************************

; This entry is called by CBIOS-3 to test output-status of 
; user-devices. Return z=1 if not ready, else z = 0.
; The device number for the particular device is given
; in register <b>.

UCOST:		; yet nothing ready

; ******************************************
; User supplied Character-Input
; ******************************************

; This entry is called by CBIOS-3 to input a character from
; user-devices. Return character in register <a>.
; The device number for the particular device is given
; in register <b>.

UCONIN:		; yet nothing


; ******************************************
; User supplied Character-Input-Status
; ******************************************

; This entry is called by CBIOS-3 to test input-status of 
; user-devices. Return z=1 if not ready, else z = 0.
; The device number for the particular device is given
; in register <b>.

UCINST:		ret			; simple return


; ************************************************************
; Special CBIOS-3 Key Functions
; ************************************************************

; There are 3 user definable key-functions how have a special
; meaning. Two of this return date or time information to
; the calling programm when input at the console device. If an
; application inputs a character from the console and you input
; the 'datkey' or the 'timkey' from the key-board, the CBIOS-3
; converts this key-stroke to a full date or time-information:
;
; CONIN: = 'datkey' -----> DD.MM.YY
;	 = 'timkey' -----> HH:MM:SS
;
; A third special key allows the user to abort CBIOS-3 loops how
; could be dangerous because they never return to their calling
; programm. An example for this would be selecting a non-existing 
; or non-ready drive or selecting a non-existing ouptut device
; as a printer who is switched off or not adapted. CBIOS-3 waits 
; for the ready-state of such a drive or device. The user has the 
; capability to abort such a loop by pressing a special break-key. 
; If the CBIOS-3 detects this break-key it aborts polling this 
; drive and returns an error to the calling programm. In case of
; non-ready devices as a printer the CBIOS-3 erases this device 
; from the device table. No special error message will occur.

		CSEG		; must be common

DATKEY:		DB	81H	; if this key is input, CBIOS-3
				; returns date-information to the
				; calling programm

TIMKEY:		DB	82h	; this key returns time-information

BRKKEY:		DB	03h	; this key aborts selecting a drive
				; or outputing to a not-ready device.



;**************************************************************
;                I/O - Select at Coldboot
;**************************************************************


; Definitions ( do not change these values)

crt	equ 	8000h		
v24a	equ 	4000h
v24b	equ 	2000h
centr	equ 	1000h
ttlser	equ 	0800h


; Here you can define the initial I/O-Redirection-Vector 
; in the SCB at coldboot. Multiple I/O-Devices for the same
; logical device are allowed.
; For example: crt + v24a + ...

	dseg			; bank switched

@intab:
	db	0		; Flag to say autodevice select if zero.
				; If non-zero following values will be choosen
				; at system start-up.

	dw	crt		; console input
	dw	crt		; console output
	dw	v24a		; auxiliary input
	dw	v24a		; auxiliary output
	dw	centr		; list output

; **********************************************
; CURRENT YEAR
; **********************************************

; Please insert at the following label the current year. CBIOS-3
; needs this constant when programming the time circuity new.

CYEAR:	DB	85H		; Current year



; **********************************************
; Configuration of RS-232 A and RS-232 B
; **********************************************

; Here you can define Stop-, Paritybits and Word-length of the
; two RS-232A and RS232-B devices. 

	cseg			; resident

VACONF:
	db	1111$1111b	; Bit-mask of RS-232-A -> 8 Bits valid

	db	1100$0000b	; bits to receive from RS-232-A
				; 1100$0000b = 8 bits -> standard bios
				; 1000$0000b = 6 bits
				; 0100$0000b = 7 bits
				; 0000$0000b = 5 bits

	db	0000$0100b	; Stop & Parity bits of RS-232-A
		;    ^^^^
		;    llll_______ Parity enable if 1
		;    lll________ Parity even if 1
		;    ll_________ 00 not used
		;  		 01 1 stop bit	-> std. bios
		;		 10 1 1/2 stop bits
		;		 11 2 stop bits

	db	0110$0000b	; Bits to transmit to RS-232-A -> 8 Bits valid
				; 0110$0000b = 8 bits -> standard-bios
				; 0100$0000b = 6 bits
				; 0010$0000b = 7 bits
				; 0000$0000b = 5 bits
				

VBCONF:
	db	0111$1111b	; Bit-mask of RS-232-B -> 7 Bits valid

	db	0100$0000b	; Bits to receive from RS-232-B
				; 1100$0000b = 8 bits 
				; 1000$0000b = 6 bits
				; 0100$0000b = 7 bits -> standard bios
				; 0000$0000b = 5 bits

	db	0000$1111b	; Stop & Parity bits of RS-232-B
		;    ^^^^
		;    llll_______ Parity enable if 1 -> std. bios
		;    lll________ Parity even if 1 -> std. bios
		;    ll_________ 00 not used
		;  		 01 1 stop bit	
		;		 10 1 1/2 stop bits
		;		 11 2 stop bits -> std. bios

	db	0010$0000b	; Bits to transmit to RS-232-B -> 7 Bits valid
				; 0110$0000b = 8 bits 
				; 0100$0000b = 6 bits
				; 0010$0000b = 7 bits -> standard bios
				; 0000$0000b = 5 bits





; *********************************
; RAM-Floppy-System-Bank
; *********************************

; Here you can define the system bank the RAM-Floppy drive E
; starts. Normaly it is set to bank 2. If you wish to give the
; CP/M-Plus System more banks for buffers you must adapt the
; RAM-Floppy starting bank. For example if the CP/M gets 3 banks
; (Bank 0,2,3; Bank 1 is always TPA) the RAM-Floppy bank starts
; at bank 4. Therefore you must adapt the value in 'RAMBNK' to 4.
	
	dseg

RAMBNK:	db	2		; Standard version RAM-Flpy. 

; The following flag determines wether the CBIOS-3 has to do
; a RAM-Test at system start-up to determine the length of the
; RAM-Floppy or wether the it should not. The RAM-Test of the
; CBIOS-3 destroys the content of the Ram-Floppy. If you use
; Accu-buffered CMOS-RAM's as RAM-Floppy its no good idea to
; destroy its content at boot. If you want to avoid this 
; destruction put the following flag to a non-zero value. You
; must set it to the number of 64k banks -1 your system has. F.e.
; in a 256k Byte System put it to the value 3 (4 x 64 kRAM - 1).

RAMTST:	db	0		; Say 0 if automatic RAM-Test
				; Say number of pages -1 if no
				; RAM-Test.



				; starts at bank 2
	cseg

; **********************************
; TPA-Length
; **********************************

; In the standard CBIOS-3 version the TPA has a length of 60 kByte
; resulting in a starting adress of the resident BDOS area at 0F000h.
; If you add own routines to your Bios (f. example interrupt drivers ..)
; and you have to write these routines in common area, you must be aware 
; of preserving the TPA at 0F0h. If you wish to get more common memory
; for your own routines you must adapt following constant, because the
; BIOS-routine 'BNKSEL' must know which area is common and which memory-
; area is bank-switched. You can lower the TPA-Area in 4 kByte steps from
; 0C0h, 0D0h, 0E0h or 0F0h. Other values are not allowed. When creating
; your new bios be sure to place your TPA at the same value as common 
; area starts. For example it is not possible to lower the common-region
; to 0E000h but having a TPA-area from 0 - to 0E800h .

TPALEN:	db	0F0h		; standard TPA 60 kByte


	
	dseg			; Disk I/O resides in banked memory region


; ************************************
; DELAY TIME AFTER DRIVE-MOTOR GOES ON
; ************************************

; Some drives need a special delay after the motor goes on when switched
; off. Normaly this delay is not necessary, but some drive like EPSON's
; low-power 3.5 " drive need it, because stepper power is switched on after
; a delay of 500 ms after the motor-on signal. In this special cases set the
; label 'MOTWAI' to your desired delay (normaly to 5 for 500ms delay). If
; 'MOTWAI' is set to 0 (default) there will be no delay. Note: This function
; is only avaiable under EPC-Systems 8023, not under CPU-Board based systems.

MOTWAI:	db	0		; no special delay
				; fill in 1 for 100 ms delay
				;	  2 for 200 ms ...


;**************************************************************
; Disk LOGIN, READ and WRITE entry points for user drives F - P
;**************************************************************

; The standard CBIOS-3 supports five drives numbered from A to E.
; If you want to install more drives (i.e. Harddisk over a SASI-Interface
; install the drive in the AUTODPB0.ASM-File (Drive-Table, Disk-Parameter
; Header. If the CBIOS-3 detects a new drive from number F upwards it
; calls these entrys. You must write here your own routines to handle
; disk I/O for these drives.


		; these entries are called with the following arguments:

			; absolute drive number in @adrv (8 bits)
			; disk transfer address in @dma (16 bits)
			; disk transfer bank	in @dbnk (8 bits)
			; disk track address	in @trk (16 bits)
			; disk sector address	in @sect (16 bits)

		; they transfer the appropriate data, perform retries
		; if necessary, then return an error code in <A>


; ************************************
; User drive login procedur
; ************************************

; This routine is invoked when a user drive is about to loged-in.
; You get in register <HL> the adress of the disk-parameter-header
; (DPH) for this drive. Return this adress in <HL> if your drive
; exists, else return in <HL> 0 if no drive.

ULOGIN:		ret


; ************************************
; User drive read/write routines
; ************************************

; Return in <A> 0 if no error occurred. <A> = 1 if any physical
; error, <A> = -1 if media has changed, <A> = 2 if disk read only.

UREAD:		mvi a,1 ! ret		; error, yet no user drive

UWRITE:		mvi a,1 ! ret		; error, yet no user drive


	end


