	title 'User definable Bios entry points'
	page 66


;*************************************************
;
; Copyright (C) 1983, 1984 by
;
; 		Datentechnik oettle + reichler
;
; 		Schie~grabenstr. 28 a
; 		8900 Augsburg 1
; 		Tel.: (0821) 15 46 32
;
;*************************************************


; Theses entries are the very first branch for each Bios-Jump
; If for example the BDOS makes a call to Bios function 0 'BOOT'
; the Bios calls first the user definable Function ZBOOT. Normaly
; these 'Z-Functions' return immediatelly to their calling programm,
; in other words they do nothing.

; Example of a standard Bios-Call:

; Bios Jump Vector at F600h ... :

; ?BOOT:	JMP BOOT	; initial entry on cold boot
; ?WBOOT:	JMP WBOOT
;
;		...


; Standard Bios BOOT-Routine:

; BOOT:		CALL ZBOOT	; call user boot function
;		...		; perform standard boot
;		
;		RET		; ret to BDOS


; User supplied BOOT-Routine:

; ZBOOT:	RET		; normaly do nothing, return to BOOT


; You can intercept the normal Bios-Jumps by filling in
; a jump to your individual Bios-Routine to adappt the system to your
; special requirements. There are allmost two ways to do this. First
; is to 'add' some special Functions to the normal Bios-Functions and
; then returning to the calling Bios-Function to perform their task.
; The second way is to intercept the standard Bios-Function totaly. Then 
; your supplied function must do all required tasks herself and return
; directly to the bios-calling programm i.g. to the BDOS.

; Be aware of following items when adding user bios-functions:

; 1. 	No stack under- or owerflow may occure, if trouble swap the
;	stack to a local area, do your function and then restore
;	again the stack.

; 2.	Do not change the CSEG or DSEG region of the function.

; 3.	If you add only some routines to the standard Bios-Functions
;	be sure that the CPU-Registers have the correct value
;	when returning to the calling Bios-Function. If trouble
;	set them to their original value at the beginning of the call.

; 4.	If you want to intercept the standard Bios-Function be aware
;	of the return adress on the stack to the calling Bios-Function.
;	Increment the Stackpointer two times to return directly to the
;	calling BDOS ( or POP a nonsense value).

; 5.	If you add code in CSEG be aware that the CSEG-value ecceeds
;	not 2.5 kByte. The linker message must appear as:

; 	ABSOLUTE	0000
;	CODE SIZE	09XX  	(0000 - 09XX)
;	DATA SIZE	....

; Use RMAC to assemble your personal bios routine and link it with 
; other modules as described in READ.ME. Then run GENCPM, adjust if
; neccessary the GENCPM.DAT File and place the new CPM3.SYS file onto
; your system disk.

; See more under READ.ME1

    ; External names for BIOS entry points
	
    ; These are the original names for the Bios-Entrys at location
    ; 0F600h. You can use them to perform some special functions
    ; for you.

	extrn ?boot,?wboot,?const,?conin,?cono,?list,?auxo,?auxi
	extrn ?home,?sldsk,?sttrk,?stsec,?stdma,?read,?write
	extrn ?lists,?sctrn
	extrn ?conos,?auxis,?auxos,?dvtbl,?devin,?drtbl
	extrn ?mltio,?flush,?mov,?tim,?bnksl,?stbnk,?xmov


    ; Public names for user definable routines

	public zboot,zwbot,zconst,zconin,zconou,zlist,zauxou
	public zauxin,zlstst,zconos,zaxist,zaxost,zcinit
	public zhome,zselds,zsettr,zsetsc,zsetdm,zread,zwrite
	public zsectr,ztime

    ; BIOS Z-Routines

		; All BIOS routines are invoked by calling these
		;	entry points.


		DSEG		; resides in bank 0


zboot:		; initial entry on cold start
zhome:		; set disks to logical home
zselds:		; select disk drive, return disk parameter info
zsettr:		; set disk track
zsetsc:		; set disk sector
zsetdm:		; set disk I/O memory address
zread:		; read physical block(s)
zwrite:		; write physical block(s)
zsectr:		; translate logical to physical sector
zcinit:		; change baud rate of device
ztime:	ret	; Signal Time and Date operation


		CSEG		; resides in common memory


zwbot:		; reentry on program exit, warm start
zconst:		; return console input status
zconin:		; return console input character
zconou:		; send console output character
zlist:		; send list output character
zauxou:		; send auxilliary output character
zauxin:		; return auxilliary input character
zlstst:		; return list device status
zconos:		; return console output status
zaxist:		; return aux input status
zaxost:	ret	; return aux output status



	end