	title 'Control and Escape definitions for RGB-Terminal'
	page 66


;*************************************************
;
; Copyright (C) 1983, 1984 by
;
; 		Datentechnik oettle + reichler
;
; 		Schie~grabenstr. 28 a
; 		D-8900 Augsburg 1
; 		Tel.: (0821) 15 46 32
;
;*************************************************


; You can modify in the following tables the CTR and ESC-Sequences
; for the RGB-Terminal. The original version is compatible to
; Tele-Video-950 Terminal as concerning the popular Functions.
; You may adjust the tables to get compatibility to your software.


; Assemble your modified file TVI950.ASM using RMAC:
; A>RMAC TVI950.ASM

; Link the file TVI950.REL with the bios modules:

; Note that this order to link the different modules is urgent.
; Thus the linker creates the system page relocatable file BNKBIOS3.SPR
; Use GENCPM.COM and optional GENCPM.DAT to create a new CPM3.SYS file.

; See more under READ.ME1


	public ctrchr,esc1ch,escxch,attrichr,panchr,curschr

	DSEG		; this part is banked

;************************************
; CONTROL CHARACTER DEFINITIONS
;************************************
	
CTRCHR:	db 1bh			; Escape
	db 07h			; Bell = ^G
	db 08h			; Cursor left = ^H
	db 0ch			; Cursor right = ^L
	db 16h			; Cursor down = ^V
	db 0bh			; Cursor up = ^K
	db 1eh			; Cursor home = ^^
	db 1ah			; Clear screen = ^Z
	db 0dh			; Carriage return = ^M
	db 0ah			; Line Feed = ^J
	db 09h			; Tab = ^I
	db 17h			; Clear to end of line = ^W
	db 12h			; Clear current line = ^R


;**************************************
; ONE LETTER ESCAPE SEQUENCES
;**************************************

ESC1CH:

	db '+'		; clr screen
	db ';'		; clr screen
	db 'R'		; clear line
	db 'E'		; clear line
	db 'T'		; clear EOL
	db 't'		; clear EOL
	db 'Y'		; clear EOP
	db 'y'		; clear EOP
	db '8'		; smoth scroll on
	db '9'		; smoth scroll off
	db 'd'		; invers video off
	db 'b'		; invers video on
	db 'n'		; screen on
	db 'o'		; screen off
	db 'U'		; local edit
	db 'u'		; full duplex edit
	db 'l'		; full init in non-interlaced mode
	db 'w'		; black & white / colour
	db 'k'		; full init in interlaced mode

;*********************************************
; MULTI LETTER ESCAPE SEQUENCES
;*********************************************

ESCXCH:

	db 'z'		; German/American Characters, '0'=int., '1'=german
	db 'G'		; Attributes, see more under character attributes
	db ' '		; Panning, see more under pan directions
	db '='		; Direct Cursor adressing, first row, then clm
	db 'v'		; Hardware zooming, from '0' (1x) to '3' (8x)
	db 'm'		; Software Zooming, from 'A' (1x) to 'P' (16x)
	db 'p'		; Parameter to GDP
	db 'c'		; Command to GDP
	db 'q'		; Set Cursor Colour, 3 parameters
	db 'r'		; Set Normal Colour, 3 para.
	db 's'		; Set reverse Colour, 3 para.
	db '*'		; Set Background Colour, 1 para.
	db 'x'		; Set drawing direction, from '0' to '7'
	db '.'		; Set cursor format, see more under cursor dispaly & fmt.



;************************************
; CHARACTER ATTRIBUTE IDENTIFIER
;************************************

attrichr:	; Attribute identifier
	db '0'	; Clear all character attributes
	db '4'	; Invers Video On
	db '8'	; Underline with straight line
	db '9'	; Underline with dotted line
	db 'A'	; Print slanted character
	db 'B'	; Space each 2nd character


;**************************************
; PANNING DIRECTIONS
;**************************************

panchr:		; Pan directions
	db 'U'	; UP
	db 'N'	; DOWN
	db 'J'	; RIGHT
	db 'H'	; LEFT


;**************************************
; CURSOR DISPLAY AND FORMAT
;**************************************

curschr:	; Define cursor format
	db '0'	; no cursor dispaly
	db '1'	; blinking block cursor
	db '2'	; staedy block cursor
	db '3'	; blinking underline cursor
	db '4'  ; staedy underline cursor

	END



