 	title 'User definable extended disk tables'
	page 66

	; CBIOS-3 VER 3.0    07.12.84/14:38:37

;*************************************************
;
; Copyright (C) 1983, 1984 by
;
; 		Datentechnik oettle + reichler
;
; 		Schie~grabenstr. 28 a
; 		D-8900 Augsburg 1
; 		Tel.: (0821) 15 46 32
;
;*************************************************


	; Standard Version 
	

; You can fill in these tables new values to adapt the system to your
; specific disk drives ( for example steprates, headloadtimes etc.)
; Next you can redefine the order of disk parameter bases. The BIOS
; always starts with dpb1 when login a drive. If this login was not
; succesfull it starts a new login with the next dpb after dpb1 ...
; Therfore dpb1 must be the very first disk parameter base in the 
; dp-bases chain. The dpb's following dpb1 can be in any order and 
; determines the search order for a disk format.
; After done your modification assemble the file autodpb0.asm with
; RMAC under use of macro library CPM3.LIB . Then link it with other
; Bios-Modules to create a new system page relocatable SPR-File
; BNKBIOS3.SPR . Note that the Code-Section of the Bios (CSEG) must
; not exceed 2.5 kByte. The CSEG region printed out by the linker
; MUST be within the region of 0900 - 09FFh.

; The linker message must appear as follows:

; ....
; ABSOLUTE	0000
; CODE SIZE	09XX  (0000 - 09XX)
; DATA SIZE     ...


; Then run GENCPM to create a new CPM3.SYS File using the input
; files RESBDOS3.SPR, BNKBDOS3.SPR and BNKBIOS3.SPR

; See more under READ.ME1 .


    ; Disk drive dispatching tables for linked BIOS

	public	@dtbl,xdpha,xdpb1,dpb1
	public	revtrk,dpbnr
	extrn	dphr

    ; CP/M 3 Disk definition macros

	maclib cpm3

;**********************
; Type flag meaning
;**********************

; The type flag gives the Bios some information about the
; current format of a disk:

; bit 6 = 1: Skip each 2nd sektor to read 40 tracks disks on 80 tracks drives
;		-> double step option
	
; bit 5 = 1: Single sided format, if 0 double sided

; bit 2 = 1: Reverse seek: Track Nr. <  revtrk: Seek Side 0: Track 0 - (revtrk-1)
;			   Track Nr. >= revtrk: Seek Side 1: Track 0 - (revtrk-1)

; bit 1 = 1: 5 1/4 Zoll Drive 250/125 khz instead of 8 Zoll 500 kHz/250 kHz
; bit 0 = 1: FM-Modulation instead of MFM

; Do not alter these values 

tyskip		equ	40h
tysingle	equ	20h
tyreverse	equ	04h
ty5zoll		equ	02h
tymfm		equ	00h
tyfm		equ	01h


;***************************************************
; Disk timing
; Replace with values for your disk
; Define headload, steprate and headunloadtime
;***************************************************

; Refer to your disk drive data sheet and uPD 765 data sheet .

;*************************************************
; Teac FD-55G drives and most other 8 Zoll drives
;*************************************************

hltg equ 32	; Head load time in ms for 8 Mhz clock, 2ms increments (2-254)
hutg equ 240	; Head unload time in ms for 8 Mhz clock, 16ms increments (16-240)
srtg equ 3	; Step rate in ms for 8 MHz clock, 1 ms increments (1-16)

specg equ ((hltg)/2)*512 + (16-srtg)*16 + (hutg+15)/16


;*******************************************************
; Teac FD-55F drives and most other 96 tpi 5 Zoll drives
;*******************************************************

hltf equ 32/2	; Head load time in ms for 4 Mhz clock, 4ms increments (4-508)
hutf equ 480/2	; Head unload time in ms for 4 Mhz clock, 32ms increments (32-480)
srtf equ 4/2	; Step rate in ms for 4 MHz clock, 2 ms increments (2-32)

specf equ ((hltf)/2)*512 + (16-srtf)*16 + (hutf+15)/16


;*******************************************************
; Teac FD-55B drives and most other 48 tpi 5 Zoll drives
;*******************************************************

hltb equ 32/2	; Head load time in ms for 4 Mhz clock, 2ms increments (4-508)
hutb equ 480/2	; Head unload time in ms for 4 Mhz clock, 32ms increments (32-480)
srtb equ 6/2	; Step rate in ms for 4 MHz clock, 2 ms increments (2-32)

specb equ ((hltb)/2)*512 + (16-srtb)*16 + (hutb+15)/16



	dseg	; disk para headers are switched

;********** Extended Disk Parameter Headers (XPDHs) ************
;***************************************************************

; Fill in the following four tables the dpb with the largest
; space requirements for allocation vectors, checksum vector
; the directory hash table and physical record size. If one DPB
; is not the largest in all of the above categories, a false DPH
; must be constructed so that GENCPM allocates sufficient space for
; each data area. In the standard AUTODPB0-Version the dpb4 requires 
; most space for these buffers, therfore we fill in dpb4 in the dpheader.


xdpha:	ds 12		; do not change

DPHA:	dph	xlt4,dpb4

lxdph	equ $-xdpha

xdphb:	ds 12		; do not change

DPHB:	dph	xlt4,dpb4

xdphc:	ds 12		; do not change

DPHC:	dph	xlt4,dpb4

xdphd:	ds 12		; do not change

DPHD:	dph	xlt4,dpb4


	cseg	; DPB & DTBL must be resident


                   ;***** DRIVE TABLE *******
                   ;*************************

@DTBL:	DTBL	<dphA,dphB,dphC,dphD,dphR>


               ;***** DISK PARAMETER BLOCK CHAIN *****
               ;**************************************

; The following disk-parameter block chain defines the different
; disk formats you can work with. 

; First some definintions ...

; Number of disk parameter blocks:
; ================================

DPBNR:	db 10	; The std.-version contains 10 disk-parameter blocks.
		; Please adapt this number if you use more or fewer
		; disk formats.

; Number of tracks until the reverse seek-option will be choosen:

REVTRK:	db 40	; NCR DM-V 40 tracks, adapt it if incorrect 


; An extended disk parameter block consists of two parts:

; First part labeld XDPBx contains specific physical informations
; about your disk drive:

; 1. NUM	1 Byte	0 if 255 Bytes per Sector ot lower
;			1 if 256, 2 if 512, 3 if 1024 ....
; 2. MXSC	1 Byte  Sectors per Track
; 3. GAP 3	1 Byte	Length of Gap 3
; 4. DTL	1 Byte	-1 if NUM > 0, else number of Bytes per Sector
; 5. SPEC	2 Bytes	Specify Parameter of your disk
; 6. TYPE	1 Byte	Type Flag
; 7. XLT	2 Bytes	Adress of translate table, must not be zero.

; Second part labeld DPBx contains logical disk informations as described
; in CP/M 3 System Guide. The Macro dpb generates a CP/M disk parameter block
; with the given informations.
	
; If you create a new XDPB these two parts must always be together. There must 
; be exact ten XDPB's with no space between each other (if not defined other 
; in DPBNR). The very first Disk-Parameter-Block in this chain  must 
; be labeld XDPB1 and DPB1. The following DPB's can be grouped in any order. If 
; login a drive the Bios start with XDPB1 and DPB1 resp. If failed, it reveals with 
; next Block following immediatelly after XDPB1 , then with the second Block
; after XDPB1 ... max. 10 times. 

; If none of the 10 possible DPB was correct (errors occured) the Bios auto-
; maticaly modifies the original TYPE-Byte. The two bits 5 and 6 alter their
; values in four steps:

; Step 1: Reset bit 5 and 6 of type bit to zero. Therfore switch off skip-
;	  option, try to access two sides of the drive.
;	  TYPE I: X00XXXXXb

; Then the Bios starts ten new retries (XDPB1-10) with the modified 
; type-flag. If still failled the type-flag will be modified as follows:

; Step 2: Try to login the drive with SKIP-Force and double sided option:
;	  TYPE II: X10XXXXb

; ... 10 new retries with XDPB1-10. If failled:

; Step 3: Switch off skip-force, switch on single sided option:
;	  TYPE III: X01XXXXXb

; ... 10 new retries. If failled again:

; Step 4: Switch on both skip-force and single-sided option:
;	  TYPE IV: X11XXXXXb 

; Step 1 - 4 will alter the TYPE-Flag in all of the eight XDPB's. Therfore
; max. 40 differnt formats will be detected. Each XDPB's with 4 different
; Options. 4 x 10 = max. 40 different disk formats.

; .... If now after 50 retries still failled an login error message occures .


; You must not create two XDPB's with identical physical but different logical
; parameters. With a given disk drive by the type flag (5 Zoll / 8 Zoll), 
; recording density (MFM/FM) the Sectors per track (MXSC) and Sectorlength (DTL,NUM)
; together must be unique, even if different GAP's, SPEC, XLT's, DIR's ... for
; another format are defined.

; For example a format with 256 Bytes per Sector and 16 Sectors per Track on an 
; 5 1/4 Zoll Drive with MFM may exist only once, even if the same format on another 
; DPB with different directory entries or block size exists. Choose for this
; new format lower or greater MXSC Parameter (15 or 17 Sectors per Track).


;**********************************************
; DRIVE 1 Layout FD-55 F 9x512 2x80
;**********************************************

sect1		equ	512	; sector Size
mxsc1		equ	9	; sectors per track
mxtr1		equ	80	; tracks per surface
side1		equ	2	; number of surfaces
xtrk1		equ	mxtr1*side1
blk1		equ	1024*2	; number of 1024k Blocksizes
dir1		equ	128	; number of directory entries
off1		equ	4	; offset for system tracks
type1		equ	tymfm + ty5zoll

Xdpb1:	db	2		; NUM
	db	mxsc1
	db	1Ah		; Gap 3
	db	-1		; DTL
	dw	specf		; Specify Parameter
	db	type1		; type-byte
	dw	xlt1

l$hd$dpb	equ	$-xdpb1

DPB1:	dpb	sect1,mxsc1,xtrk1,blk1,dir1,off1

; Note: Do note move the first dpb1 .

lxdpb	equ $-xdpb1


; next drive format to search ...



;**********************************************
; DRIVE 2 Layout  FD55-G 16x512, 2x80
;**********************************************

sect2		equ	512	; sector Size
mxsc2		equ	16	; sectors per track
mxtr2		equ	80	; tracks per surface
side2		equ	2	; number of surfaces
xtrk2		equ	mxtr2*side2
blk2		equ	1024*2	; number of 1024k Blocksizes
dir2		equ	256	; number of directory entries
skew2		equ	3	; skew faktor
off2		equ	4	; offset for system tracks

Xdpb2:	db	02		; NUM
	db	mxsc2
	db	07h		; Gap 3
	db	-1		; DTL
	dw	specg		; Specify Parameter
	db	tymfm		; Type
	dw	xlt2
DPB2:	dpb	sect2,mxsc2,xtrk2,blk2,dir2,off2


;**********************************************
; DRIVE 3 Layout FD-55 F 5x1024 2x80
;**********************************************

sect3		equ	1024	; sector Size
mxsc3		equ	5	; sectors per track
mxtr3		equ	80	; tracks per surface
side3		equ	2	; number of surfaces
xtrk3		equ	mxtr3*side3
blk3		equ	1024*4	; number of 1024k Blocksizes
dir3		equ	128	; number of directory entries
off3		equ	4	; offset for system tracks
skew3		equ	1	; skew faktor
type3		equ	tymfm + ty5zoll

Xdpb3:	db	3		; NUM
	db	mxsc3
	db	25h		; Gap 3
	db	-1		; DTL
	dw	specf		; Specify Parameter
	db	type3		; type-byte
	dw	xlt3

DPB3:	dpb	sect3,mxsc3,xtrk3,blk3,dir3,off3


;**********************************************
; DRIVE 4 Layout  FD55-G 9x1024, 2x80
;**********************************************

sect4		equ	1024	; sector Size
mxsc4		equ	9	; sectors per track
mxtr4		equ	80	; tracks per surface
side4		equ	2	; number of surfaces
xtrk4		equ	mxtr4*side4
blk4		equ	1024*2	; number of 1024k Blocksizes
dir4		equ	256	; number of directory entries
skew4		equ	5	; skew faktor
off4		equ	4	; offset for system tracks

Xdpb4:	db	03		; NUM
	db	mxsc4
	db	07h		; Gap 3
	db	-1		; DTL
	dw	specg		; Specify Parameter
	db	tymfm		; Type
	dw	xlt4
DPB4:	dpb	sect4,mxsc4,xtrk4,blk4,dir4,off4


;**********************************************
; DRIVE 5 Layout  FD55-G 15x512, 2x77
;**********************************************

sect5		equ	512	; sector Size
mxsc5		equ	15	; sectors per track
mxtr5		equ	77	; tracks per surface
side5		equ	2	; number of surfaces
xtrk5		equ	mxtr5*side5
blk5		equ	1024*2	; number of 1024k Blocksizes
dir5		equ	128	; number of directory entries
skew5		equ	5	; skew faktor
off5		equ	4	; reserved tracks

Xdpb5:	db	2		; NUM: ld (sect/128)
	db	mxsc5
	db	1Bh		; GAP 3
	db	-1		; DTL important if num = 0
	dw	specg		; Specify parameter
	db	tymfm		; Type
	dw	xlt5
DPB5:	dpb	sect5,mxsc5,xtrk5,blk5,dir5,off5



;**********************************************
; DRIVE 6 Layout FD55-B 10x512 2x40
;**********************************************

sect6		equ	512	; sector Size
mxsc6		equ	10	; sectors per track
mxtr6		equ	40	; tracks per surface
side6		equ	2	; number of surfaces
xtrk6		equ	mxtr6*side6
blk6		equ	1024*2	; number of 1024k Blocksizes
dir6		equ	64	; number of directory entries
off6		equ	4	; offset for system tracks

Xdpb6:	db	2		; NUM
	db	mxsc6
	db	10h		; GAP 3
	db	-1		; DTL
	dw	specb		; specify parameter
	db	tymfm+ty5zoll	; Type
	dw	xlt6
DPB6:	dpb	sect6,mxsc6,xtrk6,blk6,dir6,off6



;**********************************************
; DRIVE 7 FD-55 B 16x256x1x40, Ecma 70
;**********************************************

sect7		equ	256	; sector Size
mxsc7		equ	16	; sectors per track
mxtr7		equ	40	; tracks per surface
side7		equ	1	; number of surfaces
xtrk7		equ	mxtr7*side7
blk7		equ	1024*1	; number of 1024k Blocksizes
dir7		equ	64	; number of directory entries
skew7		equ	1	; skew faktor
off7		equ	4	; offset for system tracks

Xdpb7:	db	1		; NUM
	db	mxsc7
	db	20h		; Gap 3
	db	-1		; DTL
	dw	specb		; Specify Parameter
	db	tymfm+ty5zoll+tysingle
	dw	xlt7
DPB7:	dpb	sect7,mxsc7,xtrk7,blk7,dir7,off7



;**********************************************
; DRIVE 8 Layout  IBM 3740 Standard
;**********************************************

sect8		equ	128	; sector Size
mxsc8		equ	26	; sectors per track
mxtr8		equ	77	; tracks per surface
side8		equ	1	; number of surfaces
xtrk8		equ	mxtr8*side8
blk8		equ	1024*1	; number of 1024k Blocksizes
dir8		equ	64	; number of directory entries
skew8		equ	6	; skew faktor
off8		equ	2	; offset for system tracks

Xdpb8:	db	0		; NUM
	db	mxsc8
	db	07h		; Gap 3
	db	128		; 128
	dw	specg		; Specify Parameter
	db	tysingle+tyfm	; Type
	dw	xlt8
DPB8:	dpb	sect8,mxsc8,xtrk8,blk8,dir8,off8


;**************************************************
; DRIVE 9 Layout  NCR F3 format 2x40 Tracks reverse
;**************************************************

sect9		equ	512	; sector Size
mxsc9		equ	8	; sectors per track
mxtr9		equ	40	; tracks per surface
side9		equ	2	; number of surfaces
xtrk9		equ	mxtr9*side9
blk9		equ	1024*2	; number of 1024k Blocksizes
dir9		equ	128	; number of directory entries
skew9		equ	1	; skew faktor
off9		equ	3	; offset for system tracks

Xdpb9:	db	2		; NUM
	db	mxsc9
	db	2Ah		; Gap 3
	db	-1		; DTL
	dw	specb
	db	tymfm+ty5zoll+tyreverse; Type
	dw	xlt9
DPB9:	dpb	sect9,mxsc9,xtrk9,blk9,dir9,off9


;**********************************************
; DRIVE 10 Layout 8" MFM Format 14x512x2x80
;**********************************************

sect10		equ	512	; sector Size
mxsc10		equ	14	; sectors per track
mxtr10		equ	80	; tracks per surface
side10		equ	2	; number of surfaces
xtrk10		equ	mxtr10*side10
blk10		equ	1024*4	; number of 1024k Blocksizes
dir10		equ	128	; number of directory entries
skew10		equ	3	; skew faktor
off10		equ	4	; offset for system tracks

Xdpb10:	db	2		; NUM
	db	mxsc10
	db	25h		; Gap 3
	db	-1		; DTL
	dw	specg		; Specify Parameter
	db	tymfm		; type
	dw	xlt10
DPB10:	dpb	sect10,mxsc10,xtrk10,blk10,dir10,off10



	dseg


           ;******* SECTOR TRANSLATE TABLES **********
           ;******************************************


xlt1:	db 	1,4,7,2,5,8,3,6,9	; Standard FD-55 F

xlt2:	skew	mxsc2,skew2,1		; 16x512x2x80

xlt3:	skew	mxsc3,skew3,1		; 5x1024x2x80

xlt4:	skew	mxsc4,skew4,1		; 9x1024x2x80

xlt5:	skew	mxsc5,skew5,1 		; Standard FD-55G/8" 512x15x2x77

xlt6:	db	1,4,7,10,3,6,9,2,5,8 	; Standard FD-55 B 10x512x2x40

xlt7:	skew	mxsc7,skew7,1		; Ecmac 70

xlt8:	skew	mxsc8,skew8,1		; FD-55G/8" std ibm 3740

xlt9:	skew	mxsc9,skew9,1		; NCR F3

xlt10: 	skew	mxsc10,skew10,1		; 14x512x2x80
	

	end


