 	title 'Control and Escape definitions for RGB-Terminal'
	page 66

	maclib	epc

    if rgbterm ; RGB-Terminal selektiert ?


;*************************************************
;
; Copyright (C) 1983, 1984 by
;
; 		Datentechnik oettle + reichler
;
; 		Schie~grabenstr. 28 a
; 		D-8900 Augsburg 1
; 		Tel.: (0821) 15 46 32
;
;*************************************************


; You can modify in the following tables the CTR and ESC-Sequences
; for the RGB-Terminal. The original version is compatible to
; Tele-Video-950 Terminal as concerning the popular Functions.
; You may adjust the tables to get compatibility to your software.

; Assemble your modified file TVI950.ASM using RMAC:
; A>RMAC TVI950.ASM

; Link the file TVI950.REL with the bios modules:
; See more under READ.ME1


; **************************************
; NEW FEATURES OF RGBTERM-PACKAGE:
; **************************************

; 1: Enhanced language codes:
; Now there are 7 language codes and 1 user definable code aviable:
; ESC z 0	internatinol
; ESC z 1	german
; ESC z 2	united kingdom
; ESC z 3	sweden
; ESC z 4	french
; ESC z 5	italy
; ESC z 6	spanish
; ESC z 7	user defined translate table, see more under 'usrtra'

; 2: Extended ASCII-Set from 80h to 0FEh:
; Under the label 'USRCOD' you will find a table of characters how
; are attached by RGB-TERM when ASCII-Codes above 07Fh are input. You
; can omit this codes and save memory space by switching the label 
; 'usercode' to false. In this case the extended character set is not
; aviable. If you use only some special characters you install only
; these really needed and clear those not used.

; 3: Second condensed font type:
; Under the label 'DENSCO' you will find a table for a full ASCII-Set from
; 0 to 254. You can omit theses codes by switching 'condensed' to false.
; This second font type consists of a 8 by 8 Pixel matrix only, therfore
; you will get more characters on the screen. You switch with 'ESC )' to
; this condensed font type II. By 'ESC (' you will switch to the standard
; font I (8x12). If you need only the standard ASCII-Set from 00 to 7Fh
; you can clear the codes above 7Fh.

; 4: Different line spacing:
; The new ESC-Function 'ESC _' switchs different line spacings between
; 8 and 16 lines per character in 2 steps increments.

; 5: High-Resolution Monitors:
; RGB-Term suports two kinds of monitors:
;	1: Standard 15 kHz hor., 50 Hz ver., 288 active lines, 640 pixel
;	   16 Mhz GDC-Clock-Rate
;	2: High-Res 24.8 kHz hor., 57 Hz ver., 400 active lines, 640 pixel
;	   22.2 MHz GDC-Clock-Rate
; RGB-Term detects which kind of monitor is adapted when 'ESC #' is input.
; Note that this code should be the very first call to RGB-Term, to install
; the correct row-numbers, line spacings and frequencys.
;
; 6: New character resolution:
; In the following table you will find the character resolution for
; RGB-Term depending on line spacing, monitor type and font type. Note
; that line spacing 8 and 10 is only aviable on condensed character mode
; (font type II).
;
; 	Line spacing:	Matrix:		Std. 15 kHz:	High-Res. 24 Khz
;					
; 	8		 8 x 8		36 x 80 	50 x 80	 font II only
; 	10		10 x 8		28 x 80		40 x 80  font II only
; 	12		12 x 8		24 x 80 (*)	33 x 80
; 	14		14 x 8		20 x 80		28 x 80
; 	16		16 x 8		18 x 80		25 x 80 (*)
;
; (*) = default values at power up after input of 'ESC #'

; 7: Fast mode:
; You can switch RGB-Term into the fast mode by 'ESC &'. In this mode only 
; the character matrix (8x12 font I, 8x8 font II) will be drawn. The upper
; rows (number depends on font type and line spacing) which are always zero
; spaces will never be attached. This results in faster drawing speed, but 
; when switching to invers video you will find theese upper rows not inverted.
; You can switch to standard mode by 'ESC $'. The default value at power up
; is the standard (slower but correct) mode.


	public ctrchr,esc1ch,escxch,attrichr,panchr,curschr
	public usrtra,usrcod,condco


true	equ	-1
false	equ	not true

usercode:	equ	false	; say false if you want to preserve memory
				; space, say true if you want a full 256 bytes
				; character set for font I.

condensed:	equ	false	; say false if you want preserve memory
				; space, say true if you use the second 
				; condensed character font II.


	DSEG		; this part is banked


; ***********************************
; USER DEFINABLE CODE TRANSLATE TABLE
; USED WHEN 'ESC z 7' IS INPUT
; ***********************************

; This table is attached when 'ESC z 7' is input. The first byte
; in this table says how much codes should be translated. Next there
; are all codes in any order (length = 'lenusrtab') you wish to 
; translate in another code. Next you write the codes to take instead of
; the aboves exactly in the same order. The following table is only an
; example of such a translation. Only three codes will be translated:
; 0D8h -> 034H; 089h -> 045h; 0EFh -> 0B2h

USRTRA:
	DB	lenusrtab	; this byte gives information about length
				; of translate table
	DB	0D8h,089h,0EFh	; ascii codes to translate
	DB	034h,045h,0B2h	; ... and their codes to take instead of

lenusrtab:	equ ($ - usrtra - 1) / 2


;************************************
; CONTROL CHARACTER DEFINITIONS
;************************************
	
CTRCHR:	DB 1bh 			; Escape
	DB 07h			; Bell = ^G
	DB 08h			; Cursor left = ^H
	DB 0ch			; Cursor right = ^L
	DB 16h			; Cursor down = ^V
	DB 0bh			; Cursor up = ^K
	DB 1eh			; Cursor home = ^^
	DB 1ah			; Clear screen = ^Z
	DB 0dh			; Carriage return = ^M
	DB 0ah			; Line Feed = ^J
	DB 09h			; Tab = ^I
	DB 17h			; Clear to end of line = ^W
	DB 12h			; Clear current line = ^R


;**************************************
; ONE LETTER ESCAPE SEQUENCES
;**************************************

ESC1CH:

	DB '+'		; clr screen
	DB ';'		; clr screen
	DB 'R'		; clear line
	DB 'E'		; clear line
	DB 'T'		; clear EOL
	DB 't'		; clear EOL
	DB 'Y'		; clear EOP
	DB 'y'		; clear EOP
	DB '8'		; smoth scroll on
	DB '9'		; smoth scroll off
	DB 'd'		; invers video off
	DB 'b'		; invers video on
	DB 'n'		; screen on
	DB 'o'		; screen off
	DB 'U'		; local edit
	DB 'u'		; full duplex edit
	DB 'l'		; full init of rgb-term
	DB 'w'		; black & white / colour
	DB '#'		; install rgb-terminal, first sequence to rgb
	DB '('		; standard character font I: 8x12
	DB ')'		; condensed character font II: 8x8
	DB '&'		; fast mode on
	DB '$'		; fast mode off


;*********************************************
; MULTI LETTER ESCAPE SEQUENCES
;*********************************************

ESCXCH:

	DB 'z'		; character font '0' - '7'
	DB 'G'		; attributes, see more under character attributes
	DB ' '		; panning, see more under pan directions
	DB '='		; direct Cursor adressing, first row, then clm
	DB 'v'		; hardware zooming, from '0' (1x) to '3' (8x)
	DB 'm'		; software Zooming, from 'A' (1x) to 'P' (16x)
	DB 'p'		; parameter to GDP
	DB 'c'		; command to GDP
	DB 'q'		; set cursor colour, 3 parameters
	DB 'r'		; set normal colour, 3 para.
	DB 's'		; set reverse colour, 3 para.
	DB '*'		; set background colour, 1 para.
	DB 'x'		; set drawing direction, from '0' to '7'
	DB '.'		; set cursor format, see more under cursor dispaly & fmt.
	DB '_'		; set line spacing from 0 (8 lines) to 4 (16 lines) 2 incr.


;************************************
; CHARACTER ATTRIBUTE IDENTIFIER
;************************************

attrichr:	; Attribute identifier
	DB '0'	; clear all character attributes
	DB '4'	; invers Video On
	DB '8'	; underline with straight line
	DB '9'	; underline with dotted line
	DB 'A'	; print slanted character
	DB 'B'	; space each 2nd character


;**************************************
; PANNING DIRECTIONS
;**************************************

panchr:		; Pan directions
	DB 'U'	; UP
	DB 'N'	; DOWN
	DB 'J'	; RIGhT
	DB 'H'	; LEFT


;**************************************
; CURSOR DISPLAY AND FORMAT
;**************************************

curschr:	; Define cursor format
	DB '0'	; no cursor dispaly
	DB '1'	; blinking block cursor
	DB '2'	; staedy block cursor
	DB '3'	; blinking underline cursor
	DB '4'  ; staedy underline cursor


; *******************************************
; USER DEFINABLE EXTENDED ASCII CHARACTER SET
; FONT 1 IN 8 BY 12 CHARACTER MATRIX
; FOR SPECIAL CHARACTERS OR BLOCK-GRAPHIC
; THIS CODES ARE USED FOR ASCII ABOVE 7FH
; *******************************************

USRCOD:

 IF USERCODE	

;   ROW NR:
;   7    6    5    4    3    2    1    0    11   10   9    8

 DB 000h,000h,000h,000h,000h,000h,000h,0FFh,000h,000h,000h,000h ; 80h - _____
 DB 000h,000h,000h,000h,000h,000h,000h,000h,0FFh,000h,000h,000h ; 81h - ____
 DB 001h,001h,001h,001h,001h,001h,001h,001h,001h,001h,001h,001h ; 82h -  
 DB 080h,008h,008h,080h,080h,080h,080h,080h,080h,080h,080h,080h ; 83h -
 DB 077h,07Fh,07Fh,03Eh,01Ch,008h,000h,000h,000h,000h,000h,022h ; 84h - HEART
 DB 01Ch,03Eh,07Fh,03Eh,01Ch,008h,000h,000h,000h,000h,000h,008h ; 85h - SQUARE
 DB 0FFh,0FFh,05Ah,018h,018h,03Ch,000h,000h,018h,03Ch,018h,05Ah ; 86h -
 DB 0FFh,0FFh,0DBh,018h,03Ch,07Eh,000h,000h,018h,018h,03Ch,07Eh ; 87h -
 DB 0C0h,0A0h,0B8h,044h,044h,044h,038h,000h,000h,000h,000h,0F0h ; 88h - MEN
 DB 022h,022h,01Ch,008h,008h,01Ch,008h,000h,000h,000h,01Ch,022h ; 89h - WOMAN
 DB 050h,050h,010h,010h,01Ch,01Eh,00Ch,000h,000h,000h,010h,030h ; 8Ah - TONE
 DB 0A8h,0CEh,08Fh,086h,0E0h,0F0h,060h,000h,000h,018h,028h,058h ; 8Bh - TONE2
 DB 07Fh,0FFh,07Fh,03Fh,01Fh,00Fh,007h,003h,003h,007h,00Fh,01Fh ; 8Ch -
 DB 0FCh,0FFh,0FEh,0FCh,0F8h,0F0h,0E0h,0C0h,0C0h,0E0h,0F0h,0F8h ; 8Dh -
 DB 008h,008h,008h,008h,03Eh,01Ch,008h,000h,000h,008h,01Ch,03Eh ; 8Eh - D.ARROW
 DB 024h,024h,024h,024h,000h,000h,024h,000h,000h,000h,024h,024h ; 8Fh - ii
 DB 02Ah,02Ch,028h,028h,028h,028h,028h,000h,000h,000h,07Ch,02Ah ; 90h - PI
 DB 000h,07Eh,07Eh,07Eh,07Eh,07Eh,07Eh,000h,000h,000h,000h,000h ; 91h -
 DB 008h,008h,008h,03Eh,01Ch,008h,07Fh,000h,000h,008h,01Ch,03Eh ; 92h - D.ARROW
 DB 008h,008h,008h,008h,008h,008h,008h,000h,000h,008h,01Ch,03Eh ; 93h - 
 DB 008h,008h,008h,008h,03Eh,01Ch,008h,000h,000h,008h,008h,008h ; 94h -
 DB 000h,010h,020h,07Eh,020h,010h,000h,000h,000h,000h,000h,000h ; 95h -
 DB 000h,008h,004h,07Eh,004h,008h,000h,000h,000h,000h,000h,000h ; 96h - LEFT ARR.
 DB 000h,001h,001h,001h,001h,0FFh,000h,000h,000h,000h,000h,000h ; 97h - CORNER
 DB 000h,024h,042h,0FFh,042h,024h,000h,000h,000h,000h,000h,000h ; 98h - D. ARROW
 DB 010h,038h,07Ch,0FEh,000h,000h,000h,000h,000h,000h,000h,000h ; 99h -
 DB 000h,000h,000h,0FEh,07Ch,038h,010h,000h,000h,000h,000h,000h ; 9Ah -
 DB 000h,000h,000h,07Eh,002h,002h,002h,000h,000h,000h,000h,000h ; 9Bh -
 DB 000h,000h,000h,07Eh,040h,040h,040h,000h,000h,000h,000h,000h ; 9Ch -
 DB 010h,07Eh,018h,024h,010h,008h,03Ch,000h,000h,010h,018h,010h ; 9Dh - 1/2
 DB 010h,07Eh,010h,008h,014h,03Ch,010h,000h,000h,010h,018h,010h ; 9Eh - 1/4
 DB 000h,010h,010h,010h,010h,010h,010h,000h,000h,000h,010h,000h ; 9Fh - i
 DB 024h,012h,009h,012h,024h,048h,000h,000h,000h,000h,000h,050h ; A0h - >>
 DB 024h,048h,080h,048h,024h,012h,000h,000h,000h,000h,000h,012h ; A1h - <<
 DB 011h,044h,011h,044h,011h,044h,011h,044h,011h,044h,011h,044h ; A2h - PATTERN1
 DB 0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h ; A3h - PATTERN2
 DB 077h,0DDh,077h,0DDh,077h,0DDh,077h,0DDh,077h,0DDh,077h,0DDh ; A4h - PATTERN2
 DB 018h,018h,018h,018h,018h,018h,018h,018h,018h,018h,018h,018h ; A5h - LINE
 DB 018h,01Fh,01Fh,018h,018h,018h,018h,018h,018h,018h,018h,018h ; A6h -
 DB 01Fh,018h,018h,01Fh,018h,018h,018h,018h,018h,018h,018h,018h ; A7h -
 DB 024h,027h,027h,024h,024h,024h,024h,024h,024h,024h,024h,024h ; A8h -
 DB 000h,03Fh,03Fh,024h,024h,024h,024h,024h,000h,000h,000h,000h ; A9h -
 DB 01Fh,018h,018h,01Fh,018h,018h,018h,018h,000h,000h,000h,000h ; AAh -
 DB 027h,020h,020h,027h,024h,024h,024h,024h,024h,024h,024h,024h ; ABh -
 DB 024h,024h,024h,024h,024h,024h,024h,024h,024h,024h,024h,024h ; ACh - STREET
 DB 03Fh,020h,020h,027h,024h,024h,024h,024h,000h,000h,000h,000h ; ADh -
 DB 027h,020h,020h,03Fh,000h,000h,000h,000h,024h,024h,024h,024h ; AEh -
 DB 024h,03Fh,03Fh,000h,000h,000h,000h,000h,024h,024h,024h,024h ; AFh -
 DB 01Fh,018h,018h,01Fh,000h,000h,000h,000h,018h,018h,018h,018h ; B0h -
 DB 000h,01Fh,01Fh,018h,018h,018h,018h,018h,000h,000h,000h,000h ; B1h -
 DB 018h,0F8h,0F8h,000h,000h,000h,000h,000h,018h,018h,018h,018h ; B2h -
 DB 018h,0FFh,0FFh,000h,000h,000h,000h,000h,018h,018h,018h,018h ; B3h - T-CROSSING
 DB 000h,0FFh,0FFh,018h,018h,018h,018h,000h,000h,000h,000h,000h ; B4h -
 DB 018h,0F8h,0F8h,018h,018h,018h,018h,018h,018h,018h,018h,018h ; B5h -
 DB 000h,0FFh,0FFh,000h,000h,000h,000h,000h,000h,000h,000h,000h ; B6h -
 DB 018h,0FFh,0FFh,018h,018h,018h,018h,018h,018h,018h,018h,018h ; B7h - CROSSING
 DB 0F8h,018h,018h,0F8h,018h,018h,018h,018h,018h,018h,018h,018h ; B8h -
 DB 024h,0E4h,0E4h,024h,024h,024h,024h,024h,024h,024h,024h,024h ; B9h -
 DB 0E4h,004h,004h,0FCh,000h,000h,000h,000h,024h,024h,024h,024h ; BAh -
 DB 0FCh,004h,004h,0E4h,024h,024h,024h,024h,000h,000h,000h,000h ; BBh -
 DB 0E7h,000h,000h,0FFh,000h,000h,000h,000h,024h,024h,024h,024h ; BCh -
 DB 0FFh,000h,000h,0E7h,024h,024h,024h,024h,000h,000h,000h,000h ; BDh -
 DB 0E4h,004h,004h,0E4h,024h,024h,024h,024h,024h,024h,024h,024h ; BEh -
 DB 0FFh,000h,000h,0FFh,000h,000h,000h,000h,000h,000h,000h,000h ; BFh -
 DB 0E7h,000h,000h,0E7h,024h,024h,024h,024h,024h,024h,024h,024h	; C0h - BIG CROS.
 DB 0FFh,000h,000h,0FFh,000h,000h,000h,000h,018h,018h,018h,018h ; C1h -
 DB 024h,0FFh,0FFh,000h,000h,000h,000h,000h,024h,024h,024h,024h ; C2h -
 DB 0FFh,000h,000h,0FFh,018h,018h,018h,018h,000h,000h,000h,000h ; C3h -
 DB 000h,0FFh,0FFh,024h,024h,024h,024h,024h,000h,000h,000h,000h ; C4h -
 DB 024h,03Fh,03Fh,000h,000h,000h,000h,000h,024h,024h,024h,024h ; C5h -
 DB 0F8h,018h,018h,0F8h,000h,000h,000h,000h,018h,018h,018h,018h ; C6h -
 DB 0F8h,018h,018h,0F8h,018h,018h,018h,018h,000h,000h,000h,000h ; C7h -
 DB 000h,0FCh,0FCh,024h,024h,024h,024h,024h,000h,000h,000h,000h ; C8h -
 DB 024h,0FFh,0FFh,024h,024h,024h,024h,024h,024h,024h,024h,024h ; C9h -
 DB 0FFh,018h,018h,0FFh,018h,018h,018h,018h,018h,018h,018h,018h ; CAh -
 DB 018h,01Fh,01Fh,000h,000h,000h,000h,000h,018h,018h,018h,018h ; CBh -
 DB 000h,0F8h,0F8h,018h,018h,018h,018h,018h,000h,000h,000h,000h ; CCh -
 DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh ; CDh -
 DB 000h,000h,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,000h,000h,000h,000h ; CEh -
 DB 00Fh,00Fh,00Fh,00Fh,00Fh,00Fh,00Fh,00Fh,00Fh,00Fh,00Fh,00Fh ; CFh -
 DB 0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h ; D0h -
 DB 0FFh,0FFh,000h,000h,000h,000h,000h,000h,0FFh,0FFh,0FFh,0FFh ; D1h - LAST GR.
 DB 08Ch,052h,022h,022h,052h,08Ch,000h,000h,000h,000h,000h,000h ; D2h - ALPHA
 DB 044h,024h,044h,044h,044h,034h,004h,004h,000h,038h,044h,044h ; D3h - BETA
 DB 002h,002h,002h,002h,002h,002h,000h,000h,000h,07Eh,042h,002h ; D4h - 
 DB 07Ch,02Ah,028h,028h,028h,024h,000h,000h,000h,000h,000h,000h ; D5h - PI
 DB 010h,020h,010h,008h,044h,07Eh,000h,000h,000h,07Eh,044h,008h ; D6h -
 DB 03Ch,012h,012h,012h,012h,00Ch,000h,000h,000h,000h,000h,040h ; D7h -
 DB 044h,044h,044h,044h,044h,03Ch,004h,002h,000h,000h,000h,000h ; D8h -
 DB 078h,014h,010h,010h,010h,008h,000h,000h,000h,000h,000h,000h ; D9h -
 DB 01Ch,022h,022h,01Ch,008h,008h,01Ch,000h,000h,01Ch,008h,008h ; DAh -
 DB 042h,07Eh,042h,042h,024h,018h,000h,000h,000h,018h,024h,042h ; DBh -
 DB 042h,042h,042h,024h,024h,066h,000h,000h,000h,000h,03Ch,042h ; DCh - OMEGA
 DB 010h,028h,044h,044h,044h,038h,000h,000h,000h,030h,048h,088h ; DDh -
 DB 022h,055h,049h,055h,022h,000h,000h,000h,000h,000h,000h,000h ; DEh -
 DB 000h,000h,000h,002h,000h,006h,002h,007h,000h,000h,000h,000h ; DFh - INDEX i
 DB 002h,07Eh,002h,002h,004h,078h,000h,000h,000h,078h,004h,002h ; E0h -
 DB 042h,042h,042h,042h,042h,042h,000h,000h,000h,03Ch,042h,042h ; E1h -
 DB 07Eh,000h,07Eh,000h,07Eh,000h,000h,000h,000h,000h,000h,000h ; E2h -
 DB 03Eh,008h,008h,000h,03Eh,000h,000h,000h,000h,000h,008h,008h ; E3h -
 DB 008h,004h,008h,010h,020h,000h,07Eh,000h,000h,000h,020h,010h ; E4h -	<_
 DB 010h,020h,010h,008h,004h,000h,07Eh,000h,000h,000h,004h,008h ; E5h -
 DB 010h,010h,010h,010h,010h,010h,010h,010h,000h,0C0h,020h,010h ; E6h -
 DB 010h,010h,010h,010h,010h,008h,006h,000h,010h,010h,010h,010h ; E7h -
 DB 000h,03Eh,000h,008h,000h,000h,000h,000h,000h,000h,000h,008h ; E8h - /
 DB 00Ah,050h,024h,00Ah,050h,020h,000h,000h,000h,000h,000h,004h ; E9h -
 DB 018h,000h,000h,000h,000h,000h,000h,000h,000h,018h,024h,024h ; EAh -
 DB 000h,018h,018h,000h,000h,000h,000h,000h,000h,000h,000h,000h ; EBh -
 DB 000h,000h,010h,000h,000h,000h,000h,000h,000h,000h,000h,000h ; ECh -
 DB 020h,020h,026h,028h,030h,020h,000h,000h,000h,0E0h,020h,020h ; EDh -
 DB 048h,048h,000h,000h,000h,000h,000h,000h,000h,038h,048h,048h ; EEh - n
 DB 004h,004h,000h,000h,000h,000h,000h,000h,000h,006h,005h,004h ; EFh - EX 1
 DB 001h,007h,000h,000h,000h,000h,000h,000h,000h,007h,004h,002h ; F0h - EX 2
 DB 004h,007h,000h,000h,000h,000h,000h,000h,000h,007h,004h,002h ; F1h - EX 3
 DB 004h,004h,000h,000h,000h,000h,000h,000h,000h,001h,005h,007h ; F2h - EX 4
 DB 004h,007h,000h,000h,000h,000h,000h,000h,000h,007h,001h,007h ; F3h - EX 5
 DB 005h,007h,000h,000h,000h,000h,000h,000h,000h,001h,001h,007h ; F4h - EX 6
 DB 001h,001h,000h,000h,000h,000h,000h,000h,000h,007h,004h,002h ; F5h - EX 7
 DB 005h,007h,000h,000h,000h,000h,000h,000h,000h,007h,005h,007h ; F6h - EX 8
 DB 004h,004h,000h,000h,000h,000h,000h,000h,000h,007h,005h,007h ; F7h - EX 9
 DB 005h,007h,000h,000h,000h,000h,000h,000h,000h,007h,005h,005h ; F8h - EX 0
 DB 001h,002h,000h,000h,000h,000h,000h,000h,000h,002h,001h,001h ; F9h - EX (
 DB 002h,001h,000h,000h,000h,000h,000h,000h,000h,001h,002h,002h ; FAh - EX )
 DB 004h,004h,000h,000h,000h,000h,000h,000h,000h,004h,004h,01Fh ; FBh - EX +
 DB 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,00Fh ; FCh - EX -
 DB 002h,001h,000h,000h,000h,000h,000h,000h,000h,010h,008h,004h ; FDh - EX /
 DB 00Ch,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,00Ch ; FEh - EX *

 ENDIF


; ***************************************
;
; USER DEFINABLE CHARACTER SET II
; THIS CODES ARE USED WHEN FONT II IS SELECTED
;
; ***************************************


CONDCO:		; CONDENSED CHARACTER CODE 8 BY 8 PIXEL

 IF CONDENSED	


;   ROW NR:
;   7    6    5    4    3    2    1    0    

 DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh     ; 00h - MUST ALWAYS BE ONE'S
 DB 018h,018h,000h,03Ch,066h,07Eh,066h,000h     ; 01h - A0
 DB 038h,06Ch,04Ch,01Eh,00Ch,0CEh,07Eh,000h     ; 02h - POUND
 DB 070h,000h,07Eh,00Ch,03Ch,00Ch,07Eh,000h     ; 03h - E'
 DB 07Eh,000h,066h,06Eh,07Eh,076h,066h,000h     ; 04h - N~
 DB 000h,000h,03Ch,006h,006h,03Ch,060h,038h     ; 05h - c,
 DB 00Eh,000h,03Ch,060h,07Ch,066h,0FCh,000h     ; 06h - a~
 DB 00Eh,000h,03Ch,066h,07Eh,006h,03Ch,000h     ; 07h - e~
 DB 06Eh,03Bh,000h,000h,000h,000h,000h,000h     ; 08h - SNAKE
 DB 080h,00Ch,006h,003h,000h,000h,000h,000h     ; 09h - '
 DB 008h,018h,030h,060h,000h,000h,000h,000h     ; 0Ah - `
 DB 0C6h,038h,06Ch,0C6h,0FEh,0C6h,0C6h,000h     ; 0Bh - Ae
 DB 0C3h,018h,03Ch,066h,066h,03Ch,018h,000h     ; 0Ch - Oe
 DB 066h,000h,066h,066h,066h,066h,03Ch,000h     ; 0Dh - Ue
 DB 01Ch,036h,036h,01Ch,000h,000h,000h,000h     ; 0Eh - DEGREE'S
 DB 0C6h,000h,000h,000h,000h,000h,000h,000h     ; 0Fh - ' '
 DB 07Ch,0C6h,01Ch,036h,036h,01Ch,033h,01Eh     ; 10h - Pa
 DB 000h,000h,0FEh,030h,0FEh,033h,0FEh,000h     ; 11h - ae
 DB 018h,018h,03Ch,060h,07Ch,066h,0FCh,000h     ; 12h - a'
 DB 070h,000h,03Ch,066h,07Eh,006h,03Ch,000h     ; 13h - e'
 DB 000h,03Eh,000h,03Eh,066h,066h,066h,000h     ; 14h - N~
 DB 000h,070h,000h,03Ch,066h,066h,03Ch,000h     ; 15h - o~
 DB 000h,070h,000h,066h,066h,066h,0FCh,000h     ; 16h - u~
 DB 018h,000h,018h,00Ch,006h,066h,03Ch,000h     ; 17h - 
 DB 008h,01Ch,036h,063h,000h,000h,000h,000h     ; 18h - 
 DB 018h,018h,000h,018h,018h,018h,018h,000h     ; 19h - i
 DB 060h,030h,07Eh,0DBh,0DBh,07Eh,006h,003h     ; 1Ah - 0
 DB 066h,000h,03Ch,060h,07Ch,066h,0FCh,000h     ; 1Bh -
 DB 000h,066h,000h,03Ch,066h,066h,03Ch,000h     ; 1Ch - oe
 DB 000h,066h,000h,066h,066h,066h,0FCh,000h     ; 1Dh - ue
 DB 000h,03Ch,066h,03Eh,066h,03Eh,006h,006h     ; 1Eh 
 DB 000h,021h,01Eh,033h,033h,033h,01Eh,021h     ; 1Fh -
 DB 000h,000h,000h,000h,000h,000h,000h,000h     ; 20h - ' '
 DB 00Ch,01Eh,01Eh,00Ch,00Ch,000h,00Ch,000h     ; 21h - 
 DB 036h,036h,036h,000h,000h,000h,000h,000h     ; 22h - "
 DB 036h,036h,07Fh,036h,07Fh,036h,036h,000h     ; 23h - #
 DB 00Ch,03Eh,003h,01Eh,030h,01Fh,00Ch,000h     ; 24h - $
 DB 000h,063h,033h,018h,00Ch,066h,063h,000h     ; 25h - %
 DB 01Ch,036h,01Ch,06Eh,03Bh,033h,06Eh,000h     ; 26h - &
 DB 006h,006h,003h,000h,000h,000h,000h,000h     ; 27h - '
 DB 018h,00Ch,006h,006h,006h,00Ch,018h,000h     ; 28h - (
 DB 006h,00Ch,018h,018h,018h,00Ch,006h,000h     ; 29h - )
 DB 000h,066h,03Ch,0FFh,03Ch,066h,000h,000h     ; 2Ah - *
 DB 000h,00Ch,00Ch,03Fh,00Ch,00Ch,000h,000h     ; 2Bh - +
 DB 000h,000h,000h,000h,000h,00Ch,00Ch,006h     ; 2Ch -,
 DB 000h,000h,000h,03Fh,000h,000h,000h,000h     ; 2Dh - -
 DB 000h,000h,000h,000h,000h,00Ch,00Ch,000h     ; 2Eh - .
 DB 060h,030h,018h,00Ch,006h,003h,001h,000h     ; 2Fh - /
 DB 03Eh,063h,073h,07Bh,06Fh,067h,03Eh,000h     ; 30h - 0
 DB 00Ch,00Eh,00Ch,00Ch,00Ch,00Ch,03Fh,000h     ; 31h - 1
 DB 01Eh,033h,030h,01Ch,006h,033h,03Fh,000h     ; 32h - 2
 DB 01Eh,033h,030h,01Ch,030h,033h,01Eh,000h     ; 33h - 3
 DB 038h,03Ch,036h,033h,07Fh,030h,078h,000h     ; 34h - 4
 DB 03Fh,003h,01Fh,030h,030h,033h,01Eh,000h     ; 35h - 5
 DB 01Ch,006h,003h,01Fh,033h,033h,01Eh,000h     ; 36h - 6
 DB 03Fh,033h,030h,018h,00Ch,00Ch,00Ch,000h     ; 37h - 7
 DB 01Eh,033h,033h,01Eh,033h,033h,01Eh,000h     ; 38h - 8
 DB 01Eh,033h,033h,03Eh,030h,018h,00Eh,000h     ; 39h - 9
 DB 000h,00Ch,00Ch,000h,000h,00Ch,00Ch,000h     ; 3Ah - : 
 DB 000h,00Ch,00Ch,000h,000h,00Ch,00Ch,006h     ; 3Bh - ;
 DB 018h,00Ch,006h,003h,006h,00Ch,018h,000h	; 3Ch - <
 DB 000h,000h,03Fh,000h,000h,03Fh,000h,000h	; 3Dh - =
 DB 006h,00Ch,018h,030h,018h,00Ch,006h,000h	; 3Eh - >
 DB 01Eh,033h,030h,018h,00Ch,000h,00Ch,000h	; 3Fh - ?
 DB 03Eh,063h,07Bh,07Bh,07Bh,003h,01Eh,000h	; 40h - @
 DB 00Ch,01Eh,033h,033h,03Fh,033h,033h,000h	; 41h - A
 DB 03Fh,066h,066h,03Eh,066h,066h,03Fh,000h	; 42h - B
 DB 03Ch,066h,003h,003h,003h,066h,03Ch,000h	; 43h - C
 DB 01Fh,036h,066h,066h,066h,036h,01Fh,000h	; 44h - D
 DB 07Fh,046h,016h,01Eh,016h,046h,07Fh,000h	; 45h - E
 DB 07Fh,046h,016h,01Eh,016h,006h,00Fh,000h	; 46h - F
 DB 03Ch,066h,003h,003h,073h,066h,07Ch,000h	; 47h - G
 DB 033h,033h,033h,03Fh,033h,033h,033h,000h     ; 48h - H    
 DB 01Eh,00Ch,00Ch,00Ch,00Ch,00Ch,01Eh,000h     ; 49h - I
 DB 078h,030h,030h,030h,033h,033h,01Eh,000h     ; 4Ah - J
 DB 067h,066h,036h,01Eh,036h,066h,067h,000h 	; 4Bh - K
 DB 00Fh,006h,006h,006h,046h,066h,07Fh,000h     ; 4Ch - L
 DB 063h,077h,07Fh,07Fh,06Bh,063h,063h,000h     ; 4Dh - M
 DB 063h,067h,06Fh,07Bh,073h,063h,063h,000h     ; 4Eh - N
 DB 01Ch,036h,063h,063h,063h,036h,01Ch,000h     ; 4Fh - O
 DB 03Fh,066h,066h,03Eh,006h,006h,00Fh,000h     ; 50h - P
 DB 01Eh,033h,033h,033h,03Bh,01Eh,038h,000h     ; 51h - Q
 DB 03Fh,066h,066h,03Eh,036h,066h,067h,000h     ; 52h - R
 DB 01Eh,033h,007h,00Eh,038h,033h,01Eh,000h     ; 53h - S
 DB 03Fh,02Dh,00Ch,00Ch,00Ch,00Ch,01Eh,000h     ; 54h - T
 DB 033h,033h,033h,033h,033h,033h,03Fh,000h     ; 55h - U
 DB 033h,033h,033h,033h,033h,01Eh,00Ch,000h     ; 56h - V
 DB 063h,063h,063h,06Bh,07Fh,077h,063h,000h     ; 57h - W
 DB 063h,063h,036h,01Ch,01Ch,036h,063h,000h     ; 58h - X
 DB 033h,033h,033h,01Eh,00Ch,00Ch,01Eh,000h     ; 59h - Y
 DB 07Fh,063h,031h,018h,04Ch,066h,07Fh,000h     ; 5Ah - Z
 DB 01Eh,006h,006h,006h,006h,006h,01Eh,000h     ; 5Bh - [
 DB 003h,006h,00Ch,018h,030h,060h,040h,000h     ; 5Ch - /
 DB 01Eh,018h,018h,018h,018h,018h,01Eh,000h     ; 5Dh - ]
 DB 008h,01Ch,036h,063h,000h,000h,000h,000h     ; 5Eh - 
 DB 000h,000h,000h,000h,000h,000h,000h,0FFh     ; 5Fh - _
 DB 00Ch,00Ch,018h,000h,000h,000h,000h,000h     ; 60h - `
 DB 000h,000h,01Eh,030h,03Eh,033h,06Eh,000h     ; 61h - a
 DB 007h,006h,006h,03Eh,066h,066h,03Bh,000h     ; 62h - b
 DB 000h,000h,01Eh,033h,003h,033h,01Eh,000h     ; 63h - c
 DB 038h,030h,030h,03Eh,033h,033h,06Eh,000h     ; 64h - d
 DB 000h,000h,01Eh,033h,03Fh,003h,01Eh,000h     ; 65h - e
 DB 01Ch,036h,006h,00Fh,006h,006h,00Fh,000h     ; 66h - f
 DB 000h,000h,06Eh,033h,033h,03Eh,030h,01Fh     ; 67h - g
 DB 007h,006h,036h,06Eh,066h,066h,067h,000h     ; 68h - h
 DB 00Ch,000h,00Eh,00Ch,00Ch,00Ch,01Eh,000h     ; 69h - i
 DB 030h,000h,030h,030h,030h,033h,033h,01Eh     ; 6Ah - j
 DB 007h,006h,066h,036h,01Eh,036h,067h,000h     ; 6Bh - k
 DB 00Eh,00Ch,00Ch,00Ch,00Ch,00Ch,01Eh,000h     ; 6Ch - l
 DB 000h,000h,033h,07Fh,07Fh,06Bh,063h,000h     ; 6Dh - m
 DB 000h,000h,01Fh,033h,033h,033h,033h,000h     ; 6Eh - n
 DB 000h,000h,01Eh,033h,033h,033h,01Eh,000h     ; 6Fh - o
 DB 000h,000h,03Bh,066h,066h,03Eh,006h,00Fh     ; 70h - p
 DB 000h,000h,06Eh,033h,033h,03Eh,030h,078h     ; 71h - q
 DB 000h,000h,03Bh,06Eh,066h,006h,00Fh,000h     ; 72h - r
 DB 000h,000h,03Eh,003h,01Eh,030h,01Fh,000h     ; 73h - s
 DB 008h,00Ch,03Eh,00Ch,00Ch,02Ch,018h,000h     ; 74h - t
 DB 000h,000h,033h,033h,033h,033h,06Eh,000h     ; 75h - u
 DB 000h,000h,033h,033h,033h,01Eh,00Ch,000h     ; 76h - v
 DB 000h,000h,063h,06Bh,07Fh,07Fh,036h,000h     ; 77h - w
 DB 000h,000h,063h,036h,01Ch,036h,063h,000h     ; 78h - x
 DB 000h,000h,033h,033h,033h,03Eh,030h,01Fh     ; 79h - y
 DB 000h,000h,03Fh,019h,00Ch,026h,03Fh,000h     ; 7Ah - z
 DB 038h,00Ch,00Ch,007h,00Ch,00Ch,038h,000h     ; 7Bh - {
 DB 018h,018h,018h,000h,018h,018h,018h,000h     ; 7Ch - |
 DB 007h,00Ch,00Ch,038h,00Ch,00Ch,007h,000h     ; 7Dh - }
 DB 06Eh,03Bh,000h,000h,000h,000h,000h,000h     ; 7Eh - ~
 DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh     ; 7Fh - BLOCK
 DB 000h,000h,000h,000h,000h,000h,000h,0FFh     ; 80h -
 DB 0FFh,000h,000h,000h,000h,000h,000h,000h     ; 81h -
 DB 001h,001h,001h,001h,001h,001h,001h,001h     ; 82h -
 DB 008h,008h,008h,008h,008h,008h,008h,008h     ; 83h -
 DB 036h,07Fh,07Fh,07Fh,03Eh,01Ch,018h,000h     ; 84h -
 DB 008h,01Ch,03Eh,07Fh,03Eh,01Ch,008h,000h     ; 85h -
 DB 01Ch,03Eh,01Ch,07Fh,07Fh,03Eh,01Ch,03Eh     ; 86h -
 DB 008h,008h,01Ch,03Eh,07Fh,03Eh,01Ch,03Eh     ; 87h -
 DB 0F0h,0E0h,0F0h,0BEh,033h,033h,033h,01Eh     ; 88h -
 DB 03Ch,066h,066h,066h,03Ch,018h,07Eh,018h     ; 89h -
 DB 0FCh,0CCh,0FCh,00Ch,00Ch,00Eh,00Fh,007h     ; 8Ah -
 DB 0FEh,0C6h,0FEh,0C6h,0C6h,0E6h,067h,003h     ; 8Bh - TONE 2
 DB 001h,007h,01Fh,07Fh,01Fh,007h,001h,000h     ; 8Ch -
 DB 040h,070h,07Ch,07Fh,07Ch,070h,040h,000h     ; 8Dh -
 DB 018h,03Ch,07Eh,018h,018h,07Eh,03Ch,018h     ; 8Eh -
 DB 066h,066h,066h,066h,066h,000h,066h,000h     ; 8Fh -
 DB 0FEh,0DBh,0DBh,0D7h,0D8h,0D8h,0D8h,000h     ; 90h - PI
 DB 000h,000h,000h,000h,07Eh,07Eh,07Eh,000h     ; 91h - 
 DB 018h,03Ch,07Eh,018h,07Eh,03Ch,018h,0FFh     ; 92h - DOUBLE ARROW VERTICAL
 DB 018h,03Ch,07Eh,018h,018h,018h,018h,000h     ; 93h - ARROW UP
 DB 018h,018h,018h,018h,07Eh,03Ch,018h,000h     ; 94h - ARROW DOWN
 DB 000h,018h,030h,07Fh,030h,018h,000h,000h     ; 95h - ARROW RIGHT
 DB 000h,00Ch,006h,07Fh,006h,00Ch,000h,000h     ; 96h - ARROW LEFT
 DB 000h,000h,003h,003h,003h,07Fh,000h,000h     ; 97h - 
 DB 000h,024h,066h,0FFh,066h,024h,000h,000h     ; 98h - DOUBLE ARROW HORIZONTAL
 DB 000h,018h,03Ch,07Eh,0FFh,0FFh,000h,000h     ; 99h - TRIANGLE UP
 DB 000h,0FFh,0FFh,07Eh,03Ch,018h,000h,000h     ; 9Ah - TRIANGLE DOWN
 DB 000h,000h,000h,07Eh,006h,006h,000h,000h     ; 9Bh -
 DB 000h,000h,000h,07Eh,060h,060h,000h,000h     ; 9Ch -
 DB 0C3h,063h,033h,07Bh,03Ch,066h,033h,0F0h     ; 9Dh - 0.5
 DB 0C3h,063h,033h,0DBh,0ECh,0F6h,0F3h,0C0h     ; 9Eh - 0.25
 DB 018h,018h,000h,018h,018h,018h,018h,000h     ; 9Fh - 
 DB 000h,0CCh,066h,033h,066h,0CCh,000h,000h     ; A0h - <<
 DB 000h,033h,066h,0CCh,066h,033h,000h,000h     ; A1h - >>
 DB 044h,011h,044h,011h,044h,011h,044h,011h     ; A2h - PATTERN 1
 DB 099h,055h,099h,055h,099h,055h,099h,055h     ; A3h - PATTERN 2
 DB 0DBh,0EEh,0DBh,0EEh,0DBh,0EEh,0DBh,0EEh     ; A4h - PATTERN 3
 DB 018h,018h,018h,018h,018h,018h,018h,018h     ; A5h - BEGIN OF BLOCKGRAFIC'S
 DB 018h,018h,018h,018h,01Fh,018h,018h,018h	; A6h -
 DB 018h,018h,01Fh,018h,01Fh,018h,018h,018h 	; A7h -
 DB 06Ch,06Ch,06Ch,06Ch,06Fh,06Ch,06Ch,06Ch	; A8h -
 DB 000h,000h,000h,000h,07Fh,06Ch,06Ch,06Ch	; A9h -
 DB 000h,000h,01Fh,018h,01Fh,018h,018h,018h	; AAh -
 DB 06Ch,06Ch,06Fh,060h,06Fh,06Ch,06Ch,06Ch	; ABh -
 DB 06Ch,06Ch,06Ch,06Ch,06Ch,06Ch,06Ch,06Ch	; ACh -
 DB 000h,000h,07Fh,060h,06Fh,06Ch,06Ch,06Ch     ; ADh -
 DB 06Ch,06Ch,06Fh,060h,07Fh,000h,000h,000h	; AEh -
 DB 06Ch,06Ch,06Ch,06Ch,07Fh,000h,000h,000h	; AFh -
 DB 018h,018h,01Fh,018h,01Fh,000h,000h,000h 	; B0h -
 DB 000h,000h,000h,000h,01Fh,018h,018h,018h	; B1h -
 DB 018h,018h,018h,018h,0F8h,000h,000h,000h	; B2h -
 DB 018h,018h,018h,018h,0FFh,000h,000h,000h	; B3h -
 DB 000h,000h,000h,000h,0FFh,018h,018h,018h	; B4h -
 DB 018h,018h,018h,018h,0F8h,018h,018h,018h	; B5h -
 DB 000h,000h,000h,000h,0FFh,000h,000h,000h	; B6h -
 DB 018h,018h,018h,018h,0FFh,018h,018h,018h	; B7h - CROSSING 
 DB 018h,018h,0F8h,018h,0F8h,018h,018h,018h	; B8h -
 DB 06Ch,06Ch,06Ch,06Ch,0ECh,06Ch,06Ch,06Ch	; B9h -
 DB 06Ch,06Ch,0ECh,00Ch,0FCh,000h,000h,000h	; BAh -
 DB 000h,000h,0FCh,00Ch,0ECh,06Ch,06Ch,06Ch	; BBh -
 DB 06Ch,06Ch,0EFh,000h,0FFh,000h,000h,000h	; BCh -
 DB 000h,000h,0FFh,000h,0EFh,06Ch,06Ch,06Ch	; BDh -
 DB 06Ch,06Ch,0ECh,00Ch,0ECh,06Ch,06Ch,06Ch	; BEh -
 DB 000h,000h,0FFh,000h,0FFh,000h,000h,000h	; BFh - HORIZONTAL STREET
 DB 06Ch,06Ch,0EFh,000h,0EFh,06Ch,06Ch,06Ch	; C0h - BIG CROSSING
 DB 018h,018h,0FFh,000h,0FFh,000h,000h,000h	; C1h -
 DB 06Ch,06Ch,06Ch,06Ch,0FFh,000h,000h,000h	; C2h -
 DB 000h,000h,0FFh,000h,0FFh,018h,018h,018h	; C3h -
 DB 000h,000h,000h,000h,0FFh,06Ch,06Ch,06Ch	; C4h -
 DB 06Ch,06Ch,06Ch,06Ch,0FCh,000h,000h,000h	; C5h -
 DB 018h,018h,0F8h,018h,0F8h,000h,000h,000h	; C6h -
 DB 000h,000h,0F8h,018h,0F8h,018h,018h,018h	; C7h -
 DB 000h,000h,000h,000h,0FEh,06Ch,06Ch,06Ch	; C8h -
 DB 06Ch,06Ch,06Ch,06Ch,0FFh,06Ch,06Ch,06Ch 	; C9h -
 DB 018h,018h,0FFh,018h,0FFh,018h,018h,018h	; CAh -
 DB 018h,018h,018h,018h,01Fh,000h,000h,000h	; CBh -
 DB 000h,000h,000h,000h,0F8h,018h,018h,018h	; CCh -
 DB 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh	; CDh -
 DB 000h,000h,000h,000h,0FFh,0FFh,0FFh,0FFh	; CEh -
 DB 00Fh,00Fh,00Fh,00Fh,00Fh,00Fh,00Fh,00Fh	; CFh -
 DB 0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h	; D0h -
 DB 0FFh,0FFh,0FFh,0FFh,000h,000h,000h,000h	; D1h - END OF BLOCKGRAFIC'S
 DB 000h,000h,0DCh,076h,026h,076h,0DCh,000h	; D2h - ALPHA
 DB 000h,03Ch,066h,03Eh,066h,03Eh,006h,006h 	; D3h - BETA
 DB 000h,07Eh,066h,006h,006h,006h,006h,000h	; D4h - 
 DB 000h,0FEh,06Ch,06Ch,06Ch,06Ch,06Ch,000h	; D5h -
 DB 07Eh,066h,00Ch,018h,00Ch,066h,07Eh,000h	; D6h -
 DB 000h,000h,0FCh,036h,036h,036h,01Ch,000h  	; D7h -
 DB 000h,0CCh,0CCh,0CCh,0CCh,07Ch,00Ch,006h	; D8h -
 DB 000h,0DCh,076h,030h,030h,030h,030h,000h	; D9h -
 DB 07Eh,018h,03Ch,066h,066h,03Ch,018h,07Eh     ; DAh -
 DB 038h,06Ch,0C6h,0F7h,0C6h,06Ch,038h,000h	; DBh -
 DB 038h,06Ch,0C6h,0C6h,06Ch,06Ch,0EEh,000h	; DCh -
 DB 070h,018h,030h,07Ch,066h,066h,03Ch,000h	; DDh -
 DB 000h,000h,07Eh,0DBh,0DBh,07Eh,000h,000h	; DEh -
 DB 060h,030h,07Eh,0DBh,0DBh,07Eh,006h,003h	; DFh -
 DB 038h,006h,003h,03Fh,003h,006h,038h,000h	; E0h -
 DB 03Ch,066h,066h,066h,066h,066h,066h,000h	; E1h -
 DB 000h,07Eh,000h,07Eh,000h,07Eh,000h,000h	; E2h -
 DB 018h,018h,07Eh,018h,018h,000h,07Eh,000h	; E3h -
 DB 00Ch,018h,030h,018h,00Ch,000h,07Eh,000h	; E4h -
 DB 030h,018h,00Ch,018h,030h,000h,07Eh,000h	; E5h -
 DB 070h,0D8h,0D8h,018h,018h,018h,018h,018h 	; E6h -
 DB 018h,018h,018h,018h,018h,01Bh,01Bh,00Eh	; E7h -
 DB 018h,018h,000h,07Eh,000h,018h,018h,000h	; E8h -
 DB 000h,06Eh,03Bh,000h,06Eh,03Bh,000h,000h	; E9h -
 DB 01Ch,036h,036h,01Ch,000h,000h,000h,000h 	; EAh -
 DB 000h,000h,000h,018h,018h,000h,000h,000h	; EBh -
 DB 000h,000h,000h,000h,018h,000h,000h,000h 	; ECh -
 DB 0F0h,030h,030h,030h,037h,036h,03Ch,038h	; EDh -
 DB 01Eh,066h,066h,066h,066h,000h,000h,000h	; EEh - EX n
 DB 00Ch,00Eh,00Ch,00Ch,01Eh,000h,000h,000h	; EFh -
 DB 00Eh,018h,00Ch,006h,01Eh,000h,000h,000h	; F0h -
 DB 00Eh,018h,00Ch,018h,00Eh,000h,000h,000h	; F1h -
 DB 018h,01Ch,03Eh,018h,03Ch,000h,000h,000h 	; F2h -
 DB 01Eh,006h,01Ch,018h,01Eh,000h,000h,000h     ; F3h -
 DB 01Ch,006h,01Eh,01Eh,00Ch,000h,000h,000h	; F4h -
 DB 01Eh,018h,00Ch,006h,006h,000h,000h,000h	; F5h -
 DB 00Eh,01Bh,00Eh,01Bh,00Eh,000h,000h,000h  	; F6h -
 DB 00Eh,01Eh,01Eh,018h,00Eh,000h,000h,000h	; F7h -
 DB 00Ch,012h,01Ah,01Eh,00Ch,000h,000h,000h	; F8h -
 DB 00Ch,006h,006h,006h,00Ch,000h,000h,000h	; F9h -
 DB 006h,00Ch,00Ch,00Ch,006h,000h,000h,000h	; FAh -
 DB 000h,00Ch,01Eh,01Eh,00Ch,000h,000h,000h	; FBh -
 DB 000h,000h,00Fh,00Fh,000h,000h,000h,000h	; FCh -
 DB 030h,018h,00Ch,006h,003h,000h,000h,000h	; FDh -
 DB 000h,000h,006h,006h,000h,000h,000h,000h	; FEh -

 ENDIF

    endif ; if rgbterm

	END
