 	titl 'DSK PARA fo LDRBIOS'
	PAGE 66

	; Ver 3.0	07.12.84/14:47:37

	maclib cpm3
	maclib epc

	cseg

    ; Disk drive dispatching tables for linked BIOS

	public	@dtbl,xdpha,xdpb1,dpb1,dpha
;--------------
;	public	bufer1,bufer2
	extrn	alv
;--------------
	public	dpbnr,revtrk
	extrn 	dirbcb,dtabcb

    if hdboot
	public	dphhd
    endif

;**********************
; Type flag meaning
;**********************

tyskip		equ	40h
tysingle	equ	20h
tyreverse	equ	04h
ty5zoll		equ	02h
tymfm		equ	00h
tyfm		equ	01h


;***************************************************
; Disk timing
; Replace with values for your disk
; Define headload, steprate and headunloadtime
;***************************************************

; Refer to your disk drive data sheet and uPD 765 data sheet !

;*************************************************
; Teac FD-55G drives and most other 8 Zoll drives
;*************************************************

hltg equ 60	; Head load time in ms for 8 Mhz clock, 2ms increments (2-254)
hutg equ 240	; Head unload time in ms for 8 Mhz clock, 16ms increments (16-240)
srtg equ 6	; Step rate in ms for 8 MHz clock, 1 ms increments (1-16)

specg equ ((hltg)/2)*512 + (16-srtg)*16 + (hutg+15)/16


;*******************************************************
; Teac FD-55F drives and most other 96 tpi 5 Zoll drives
;*******************************************************

hltf equ 64/2	; Head load time in ms for 4 Mhz clock, 4ms increments (4-508)
hutf equ 480/2	; Head unload time in ms for 4 Mhz clock, 32ms increments (32-480)
srtf equ 4/2	; Step rate in ms for 4 MHz clock, 2 ms increments (2-32)

specf equ ((hltf)/2)*512 + (16-srtf)*16 + (hutf+15)/16


;*******************************************************
; Teac FD-55B drives and most other 48 tpi 5 Zoll drives
;*******************************************************

hltb equ 64/2	; Head load time in ms for 4 Mhz clock, 2ms increments (4-508)
hutb equ 480/2	; Head unload time in ms for 4 Mhz clock, 32ms increments (32-480)
srtb equ 10/2	; Step rate in ms for 4 MHz clock, 2 ms increments (2-32)

specb equ ((hltb)/2)*512 + (16-srtb)*16 + (hutb+15)/16




;********** Extended Disk Parameter Headers (XPDHs) ************
;***************************************************************


xdpha:	ds 12		; do not change


DPHA:	dw xlt2		; skew table
	db 0,0,0,0,0,0,0,0,0	; bdos scratch area
	db 0		; media flag
	dw dpb2		; disk parameter block
	dw 0		; no checksum
	dw alv		; allocation vector
	dw dirbcb	; dirbcb
	dw dtabcb	; dtabcb
	dw -1		; hash
	db 0		; hash bank

lxdph	equ $-xdpha

    if hdboot
; *****************************
; dph fuer laufwerk h

	dw 0,0,0,0,0
dphhd:	dw xlthd
	db 0,0,0,0,0,0,0,0,0	; bdos scratch area
	db 0		; media flag
	dw dpbhd	; disk parameter block
	dw 0		; no checksum
	dw alv		; allocation vector
	dw dirbcb	; dirbcb
	dw dtabcb	; dtabcb
	dw -1		; hash
	db 0		; hash bank

; *************************
; XLT fuer Harddisk
xlthd:			; Kopf #0, Sektor #0..#8
	db	00h,01h,02h,03h,04h,05h,06h,07h,08h
			; Kopf #1, Sektor #0..#8
	db	10h,11h,12h,13h,14h,15h,16h,17h,18h
			; Kopf #2, Sektor #0..#8
	db	20h,21h,22h,23h,24h,25h,26h,27h,28h
			; Kopf #3, Sektor #0..#8
	db	30h,31h,32h,33h,34h,35h,36h,37h,38h
			; Kopf #4, Sektor #0..#8
	db	40h,41h,42h,43h,44h,45h,46h,47h,48h
			; Kopf #5, Sektor #0..#8
	db	50h,51h,52h,53h,54h,55h,56h,57h,58h


; *************************
; Disk Parameter Blocks

;DPB's fuer Harddisk, Laufwerk h

dpbhd:	dpbx	secsiz,secptrk,(hdtrk1+hdtrk2+hdtrk3),hdblk,hddir3,(hdoff+hdtrk1+hdtrk2),0

    endif ; if hdboot

                   ;***** DRIVE TABLE *******
                   ;*************************

@DTBL:	dw 	dpha


               ;***** DISK PARAMETER BLOCKS *****
               ;*********************************

revtrk:	db	40	; 40 tracks on side one
dpbnr:	db	10	; 10 disk parameter blocks

;**********************************************
; DRIVE 1 Layout FD-55 F 5x1024 2x80
;**********************************************

sect1		equ	1024	; sector Size
mxsc1		equ	5	; sectors per track
mxtr1		equ	80	; tracks per surface
side1		equ	2	; number of surfaces
xtrk1		equ	mxtr1*side1
blk1		equ	1024*4	; number of 1024k Blocksizes
dir1		equ	128	; number of directory entries
off1		equ	4	; offset for system tracks
skew1		equ	1	; skew faktor
type1		equ	tymfm + ty5zoll

Xdpb1:	db	3		; NUM
	db	mxsc1
	db	25h		; Gap 3
	db	-1		; DTL
	dw	specf		; Specify Parameter
	db	type1		; type-byte
	dw	xlt1

l$hd$dpb	equ	$-xdpb1

DPB1:	dpb	sect1,mxsc1,xtrk1,blk1,dir1,off1,8000h

; Note: Do note move the first dpb1 .

lxdpb	equ $-xdpb1

; next drive format to search ...



;**********************************************
; DRIVE 2 Layout  FD55-G 9x1024, 2x80
;**********************************************

sect2		equ	1024	; sector Size
mxsc2		equ	9	; sectors per track
mxtr2		equ	80	; tracks per surface
side2		equ	2	; number of surfaces
xtrk2		equ	mxtr2*side2
blk2		equ	1024*2	; number of 1024k Blocksizes
dir2		equ	256	; number of directory entries
skew2		equ	5	; skew faktor
off2		equ	4	; offset for system tracks

Xdpb2:	db	03		; NUM
	db	mxsc2
	db	07h		; Gap 3
	db	-1		; DTL
	dw	specg		; Specify Parameter
	db	tymfm		; Type
	dw	xlt2
DPB2:	dpb	sect2,mxsc2,xtrk2,blk2,dir2,off2,8000h


;**********************************************
; DRIVE 3 Layout FD-55 F 9x512 2x80
;**********************************************

sect3		equ	512	; sector Size
mxsc3		equ	9	; sectors per track
mxtr3		equ	80	; tracks per surface
side3		equ	2	; number of surfaces
xtrk3		equ	mxtr3*side3
blk3		equ	1024*2	; number of 1024k Blocksizes
dir3		equ	128	; number of directory entries
off3		equ	4	; offset for system tracks
type3		equ	tymfm + ty5zoll

Xdpb3:	db	2		; NUM
	db	mxsc3
	db	1Ah		; Gap 3
	db	-1		; DTL
	dw	specf		; Specify Parameter
	db	type3		; type-byte
	dw	xlt3

DPB3:	dpb	sect3,mxsc3,xtrk3,blk3,dir3,off3,8000h



;**********************************************
; DRIVE 4 Layout  FD55-G 16x512, 2x80
;**********************************************

sect4		equ	512	; sector Size
mxsc4		equ	16	; sectors per track
mxtr4		equ	80	; tracks per surface
side4		equ	2	; number of surfaces
xtrk4		equ	mxtr4*side4
blk4		equ	1024*2	; number of 1024k Blocksizes
dir4		equ	256	; number of directory entries
skew4		equ	3	; skew faktor
off4		equ	4	; offset for system tracks

Xdpb4:	db	02		; NUM
	db	mxsc4
	db	07h		; Gap 3
	db	-1		; DTL
	dw	specg		; Specify Parameter
	db	tymfm		; Type
	dw	xlt4
DPB4:	dpb	sect4,mxsc4,xtrk4,blk4,dir4,off4,8000h


;**********************************************
; DRIVE 5 Layout  FD55-G 15x512, 2x77
;**********************************************

sect5		equ	512	; sector Size
mxsc5		equ	15	; sectors per track
mxtr5		equ	77	; tracks per surface
side5		equ	2	; number of surfaces
xtrk5		equ	mxtr5*side5
blk5		equ	1024*2	; number of 1024k Blocksizes
dir5		equ	128	; number of directory entries
skew5		equ	5	; skew faktor
off5		equ	4	; reserved tracks

Xdpb5:	db	2		; NUM: ld (sect/128)
	db	mxsc5
	db	1Bh		; GAP 3
	db	-1		; DTL important if num = 0
	dw	specg		; Specify parameter
	db	tymfm		; Type
	dw	xlt5
DPB5:	dpb	sect5,mxsc5,xtrk5,blk5,dir5,off5,8000h



;**********************************************
; DRIVE 6 Layout FD55-B 10x512 2x40
;**********************************************

sect6		equ	512	; sector Size
mxsc6		equ	10	; sectors per track
mxtr6		equ	40	; tracks per surface
side6		equ	2	; number of surfaces
xtrk6		equ	mxtr6*side6
blk6		equ	1024*2	; number of 1024k Blocksizes
dir6		equ	64	; number of directory entries
off6		equ	4	; offset for system tracks

Xdpb6:	db	2		; NUM
	db	mxsc6
	db	10h		; GAP 3
	db	-1		; DTL
	dw	specb		; specify parameter
	db	tymfm+ty5zoll	; Type
	dw	xlt6
DPB6:	dpb	sect6,mxsc6,xtrk6,blk6,dir6,off6,8000h



;**********************************************
; DRIVE 7 FD-55 B 16x256x1x40, Ecma 70
;**********************************************

sect7		equ	256	; sector Size
mxsc7		equ	16	; sectors per track
mxtr7		equ	40	; tracks per surface
side7		equ	1	; number of surfaces
xtrk7		equ	mxtr7*side7
blk7		equ	1024*1	; number of 1024k Blocksizes
dir7		equ	64	; number of directory entries
skew7		equ	1	; skew faktor
off7		equ	4	; offset for system tracks

Xdpb7:	db	1		; NUM
	db	mxsc7
	db	20h		; Gap 3
	db	-1		; DTL
	dw	specb		; Specify Parameter
	db	tymfm+ty5zoll+tysingle
	dw	xlt7
DPB7:	dpb	sect7,mxsc7,xtrk7,blk7,dir7,off7,8000h



;**********************************************
; DRIVE 8 Layout  IBM 3740 Standard
;**********************************************

sect8		equ	128	; sector Size
mxsc8		equ	26	; sectors per track
mxtr8		equ	77	; tracks per surface
side8		equ	1	; number of surfaces
xtrk8		equ	mxtr8*side8
blk8		equ	1024*1	; number of 1024k Blocksizes
dir8		equ	64	; number of directory entries
skew8		equ	6	; skew faktor
off8		equ	2	; offset for system tracks

Xdpb8:	db	0		; NUM
	db	mxsc8
	db	07h		; Gap 3
	db	128		; 128
	dw	specg		; Specify Parameter
	db	tysingle+tyfm	; Type
	dw	xlt8
DPB8:	dpb	sect8,mxsc8,xtrk8,blk8,dir8,off8,8000h


;**************************************************
; DRIVE 9 Layout  NCR F3 format 2x40 Tracks reverse
;**************************************************

sect9		equ	512	; sector Size
mxsc9		equ	8	; sectors per track
mxtr9		equ	40	; tracks per surface
side9		equ	2	; number of surfaces
xtrk9		equ	mxtr9*side9
blk9		equ	1024*2	; number of 1024k Blocksizes
dir9		equ	128	; number of directory entries
skew9		equ	1	; skew faktor
off9		equ	3	; offset for system tracks

Xdpb9:	db	2		; NUM
	db	mxsc9
	db	2Ah		; Gap 3
	db	-1		; DTL
	dw	specb
	db	tymfm+ty5zoll+tyreverse; Type
	dw	xlt9
DPB9:	dpb	sect9,mxsc9,xtrk9,blk9,dir9,off9,8000h


;**********************************************
; DRIVE 10 Layout 8" MFM Format 14x512x2x80
;**********************************************

sect10		equ	512	; sector Size
mxsc10		equ	14	; sectors per track
mxtr10		equ	80	; tracks per surface
side10		equ	2	; number of surfaces
xtrk10		equ	mxtr10*side10
blk10		equ	1024*4	; number of 1024k Blocksizes
dir10		equ	128	; number of directory entries
skew10		equ	3	; skew faktor
off10		equ	4	; offset for system tracks

Xdpb10:	db	2		; NUM
	db	mxsc10
	db	25h		; Gap 3
	db	-1		; DTL
	dw	specg		; Specify Parameter
	db	tymfm		; type
	dw	xlt10
DPB10:	dpb	sect10,mxsc10,xtrk10,blk10,dir10,off10,8000h





           ;******* SECTOR TRANSLATE TABLES **********
           ;******************************************


xlt1:	skew	mxsc1,skew1,1		; 5x1024x2x80

xlt2:	skew	mxsc2,skew2,1		; 9x1024x2x80

xlt3:	db 	1,4,7,2,5,8,3,6,9	; Standard FD-55 F

xlt4:	skew	mxsc4,skew4,1		; 16x512x2x80

xlt5:	skew	mxsc5,skew5,1 		; Standard FD-55G/8" 512x15x2x77

xlt6:	db	1,4,7,10,3,6,9,2,5,8 	; Standard FD-55 B 10x512x2x40

xlt7:	skew	mxsc7,skew7,1		; Ecmac 70

xlt8:	skew	mxsc8,skew8,1		; FD-55G/8" std ibm 3740

xlt9:	skew	mxsc9,skew9,1		; NCR F3

xlt10: 	skew	mxsc10,skew10,1		; 14x512x2x80
	

; daten-bereich jetzt in ldrports.mac !
; alv:	equ $		; ds 200
; bufer1:	equ alv+200	; ds 512	
; bufer2:	equ bufer1+512	; ds 512

; endloader equ bufer2+512	; ds 0


	end
