program hdsys;

{ hd-systemgenerierung fuer o+r cp/m+ }

const
  version='-- HD-SYS -- Version 1.1 (25.06.89)';
  SysFileName='CPMLDR1.400';       { name des loaders }
  drive=6;                         { drive fuer hd-sys (6=G:) }
  track=0;                         { track fuer hd-sys }
  pSecLen=1024;                    { groesse phys. sektoren }
  lSecLen=128;                     { groesse log. sektoren }
  pSysSec=9;                       { anzahl phys. sektoren fuer system }
  lSysSec=72;                      { anzahl log. sektoren fuer system }
  FreeString:string[20]=' ** Free Boot-Record';  { Fuellstring fuer freie boot-sektoren }

type dpb=record
           spt:integer;
           bsh,blm,exm:byte;
           dsm,drm:integer;
           al0,al1:byte;
           cks,off:integer;
           psh,phm:byte;
         end;
     rwtype=(readsector, writesector);

var
  SysFile:file;
  sector,PdivL:integer;
  i,j:integer;

  DefaultDrive:integer;
  idph:integer;
  dph:^integer absolute idph;
  pSysBuf:array[1..pSysSec,1..pSecLen] of byte;
  lSysBuf:array[1..lSysSec,1..lSecLen] of byte absolute pSysBuf;

function ubios (fn, pa, pbc, pde, phl: integer): integer;
type
  parameterblock=record
    func,areg:byte;
    bcreg,dereg,hlreg:integer;
  end;
var
  biospb:parameterblock;
  func2,areg2:byte;
  bcreg2,dereg2,hlreg2:integer;
  result: integer;

begin
{
  writeln('* ubios * fn:',fn:3,
                    '   a:',pa:3,
                   '   bc:',pbc:6,
                   '   de:',pde:6,
                   '   hl:',phl:6);
  read(kbd,ch); if ch=^C then halt;
}
  with biospb do begin
    func:=fn;
    areg:=pa;
    bcreg:=pbc;
    dereg:=pde;
    hlreg:=phl;
  end;
  result:=0;
  case fn of
    2,3,7,13,14,15,17,18,19,24: result:=bdos(50,addr(biospb));
    9,16,20,22,25:              result:=bdoshl(50,addr(biospb));
    else                        bdos (50,addr(biospb))
  end;
  ubios:=result;
end;

procedure LogHDrive;
var i:integer;
begin
  i:=bdoshl(12);                         { return version number }
  defaultdrive:=bdos(25);                { return current disk }
  bdos(13);                              { reset disk system }
  i:=bdos(14,drive);                     { select disk }
  i:=ubios(9,0,drive,1,0);               { seldsk }
  i:=bdosHL(31);                         { get addr(dpb) }
end;

procedure LogDefaultDrive;
begin
  bdos(13);                              { reset disk system }
  bdos(14,defaultdrive);                 { select disk }
end;

procedure WritePhysSector(sector:integer);
var i,psector:integer;
begin
  idph:=ubios(9,0,drive,1,0);                  { seldsk }
  psector:=ubios(16,0,sector-1,dph^,0);        { sectrn }
  i:=ubios(23,0,1,0,0);                        { multio }
  i:=ubios(10,0,track,0,0);                    { settrk }
  i:=ubios(11,0,psector,0,0);                  { setsec }
  i:=ubios(12,0,addr(pSysBuf[sector]),0,0);    { setdma }
  i:=ubios(14,0,0,0,0);                        { write }
end;

begin
  writeln(version);
  PdivL:=pSecLen div lSecLen;
                                               { cp/m-loader in buffer laden }
  write('Reading File ',SysFileName,' ');
  assign(SysFile,SysFileName); reset(SysFile);
  sector:=1;
  while not eof(SysFile) and (sector<=lSysSec) do begin
    blockread(SysFile,lSysBuf[sector],1);
    sector:=succ(sector);
    if (sector mod PdivL)=0 then write('.');
  end;
  writeln(' (',sector-1,' Records)');
                                               { restlichen buffer loeschen }
  write('Filling free buffer      ');
  for i:=sector to lSysSec do begin
    for j:=1 to lSecLen do begin
      lSysBuf[i,j]:=ord(FreeString[((i-1)*lSecLen+j) mod length(FreeString)+1]);
    end;
    write('.');
  end;
  writeln(' (',lSysSec-sector+1,' Records)');
                                               { umschalten auf phys. sektoren }
  LogHDrive;
                                               { buffer auf platte speichern }
  write('Writing Drive ',chr(drive+ord('A')),': Track ',track,' ');
  for sector:=1 to pSysSec do begin
    WritePhysSector(sector);
    write('.');
  end;
  writeln(' (',pSysSec*PdivL,' Records)');;
                                               { umschalten auf log. sektoren }
  write('Function complete.');
  LogDefaultDrive;
end.
