 	title 'User definable extended disk tables'
	page 66

	maclib epc
	maclib cpm3

; jedes format belegt 1Ah = 26 Bytes common memory !


frmnum	equ	27	; ===>>> Anzahl Formate anpassen <<<===


; 3.5" DSDD, 2000 KB
form24	equ	true	; FD35-H 18x512,  2x80, IBM-HD 3.5"
form27	equ	false	; FD35-H 10x1024, 2x80, Very High Density

; 8" DSDD, 1600 KB
form2	equ	true	; FD55-G 9x1024, 2x80, o+r Format 2
form26	equ	false	; FD55-G 9x1024, 2x77, Shugart SA-850
form4	equ	false	; FD55-G 16x512, 2x80, o+r Format 4
form25	equ	false	; FD55-G 15x512, 2x80, IBM-HD 5.25"
form5	equ	false	; FD55-G 15x512, 2x77, o+r Format 5
form10	equ	false	; FD55-G 14x512, 2x80, 8" MFM Format

; 8" SSSD, 400 KB
form8	equ	false	; FD55-G 26x128, 1x77, IBM 3740 Standard

; 5" DSDD 80 Spuren, 1000 KB
form1	equ	true	; FD55-F 5x1024, 2x80, o+r Format 1 >>> IMMER TRUE <<<
form6	equ	false	; FD55-F 10x512, 2x80, o+r Format 6
form3	equ	false	; FD55-F  9x512, 2x80, o+r Format 3
form16	equ	false	; FD55-F  9x512, 2x80, Vortex
form17	equ	true	; FD55-F  9x512, 2x80, Atari 520 ST CP/M DSDD
form19	equ	false	; FD55-F 16x256, 2x77, Kontron PSI-80,	Reverse 77
form18	equ	true	; FD55-F 16x256, 2x70, ITT 3030,	Reverse 70
form21	equ	false	; ?????? ??????, ????, Uwe Lemties

; 5" SSDD 80 Spuren, 500 KB
form23	equ	false	; FD55-E  9x512, 1x80, Atari 520 ST SSDD

; 5" DSDD 40 Spuren, 500 KB
form14	equ	true	; FD55-B  9x512, 2x40, 360KB MS-DOS
form9	equ	false	; FD55-B  8x512, 2x40, NCR F3,		Reverse 40
form22	equ	false	; FD55-B  8x512, 2x40, IBM CP/M-86 DS	Reverse 40
form20	equ	false	; FD55-B 16x256, 2x40, Krueger

; 5" SSDD 40 Spuren, 250 KB
form15	equ	false	; FD55-A 5x1024, 1x40, Osborne DD
form13	equ	false	; FD55-A  8x512, 1x40, IBM CP/M-86 SS
form7	equ	false	; FD55-A 16x256, 1x40, Ecma 70

; 5" SSSD 40 Spuren, 125 KB
form12	equ	false	; FD55-A 10x256, 1x40, Osborne SD
form11	equ	false	; FD55-A 18x128, 1x40, TRS-80 SD



; *******************************
	order	frmnum,<27,26,2,24,1>	; formate fuer getmax ordnen
	count	frmnum,frmcnt,frmrev	; selektierte formate zaehlen

	; CBIOS-3 VER 3.0    07.12.84/14:38:37

;*************************************************
;
; Copyright (C) 1983, 1984 by
;
; 		Datentechnik oettle + reichler
;
; 		Schie~grabenstr. 28 a
; 		D-8900 Augsburg 1
; 		Tel.: (0821) 15 46 32
;
;*************************************************


	; Standard Version 
	

; You can fill in these tables new values to adapt the system to your
; specific disk drives ( for example steprates, headloadtimes etc.)
; Next you can redefine the order of disk parameter bases. The BIOS
; always starts with dpb1 when login a drive. If this login was not
; succesfull it starts a new login with the next dpb after dpb1 ...
; Therfore dpb1 must be the very first disk parameter base in the 
; dp-bases chain. The dpb's following dpb1 can be in any order and 
; determines the search order for a disk format.
; After done your modification assemble the file autodpb1.asm with
; RMAC under use of macro library CPM3.LIB . Then link it with other
; Bios-Modules to create a new system page relocatable SPR-File
; BNKBIOS3.SPR . 
; Then run GENCPM to create a new CPM3.SYS File using the input
; files RESBDOS3.SPR, BNKBDOS3.SPR and BNKBIOS3.SPR

; See more under READ.ME1 .


    ; Disk drive dispatching tables for linked BIOS

	public	xdpha,xdpb1,dpb1
    if drivea
	public	dpha
    endif
    if driveb
	public	dphb
    endif
    if drivec
	public	dphc
    endif
    if drived
	public	dphd
    endif
	public	revtrk,dpbnr


    ; CP/M 3 Disk definition macros


;**********************
; Type flag meaning
;**********************

; The type flag gives the Bios some information about the
; current format of a disk:

; bit 6 = 1: Skip each 2nd sektor to read 40 tracks disks on 80 tracks drives
;		-> double step option
	
; bit 5 = 1: Single sided format, if 0 double sided

    if ibmtype
; bit 3 = 1: IBM-seek in kombination mit reverse seek:
;			V0 V1 .. Vx  Rx .. R0
; V = Vorderseite    R = Rueckseite    x = ReverseTrack - 1
    endif

; bit 2 = 1: Reverse seek: Track Nr. <  revtrk: Seek Side 0: Track 0 - (revtrk-1)
;			   Track Nr. >= revtrk: Seek Side 1: Track 0 - (revtrk-1)

; bit 1 = 1: 5 1/4 Zoll Drive 250/125 khz instead of 8 Zoll 500 kHz/250 kHz
; bit 0 = 1: FM-Modulation instead of MFM


;***************************************************
; Disk timing
; Replace with values for your disk
; Define headload, steprate and headunloadtime
;***************************************************

; Refer to your disk drive data sheet and uPD 765 data sheet .

;*************************************************
; Teac FD-55G drives and most other 8 Zoll drives
;*************************************************

hltg equ 32	; Head load time in ms for 8 Mhz clock, 2ms increments (2-254)
hutg equ 240	; Head unload time in ms for 8 Mhz clock, 16ms increments (16-240)
srtg equ 4 ; 3	; Step rate in ms for 8 MHz clock, 1 ms increments (1-16)

specg equ ((hltg)/2)*512 + (16-srtg)*16 + (hutg+15)/16


;*******************************************************
; Teac FD-55F drives and most other 96 tpi 5 Zoll drives
;*******************************************************

hltf equ 32/2	; Head load time in ms for 4 Mhz clock, 4ms increments (4-508)
hutf equ 480/2	; Head unload time in ms for 4 Mhz clock, 32ms increments (32-480)
srtf equ 4/2	; Step rate in ms for 4 MHz clock, 2 ms increments (2-32)

specf equ ((hltf)/2)*512 + (16-srtf)*16 + (hutf+15)/16


;*******************************************************
; Teac FD-55B drives and most other 48 tpi 5 Zoll drives
;*******************************************************

hltb equ 32/2	; Head load time in ms for 4 Mhz clock, 2ms increments (4-508)
hutb equ 480/2	; Head unload time in ms for 4 Mhz clock, 32ms increments (32-480)
srtb equ 6/2	; Step rate in ms for 4 MHz clock, 2 ms increments (2-32)

specb equ ((hltb)/2)*512 + (16-srtb)*16 + (hutb+15)/16



	dseg	; disk para headers are switched

;********** Extended Disk Parameter Headers (XPDHs) ************
;***************************************************************

; Fill in the following four tables the dpb with the largest
; space requirements for allocation vectors, checksum vector
; the directory hash table and physical record size. If one DPB
; is not the largest in all of the above categories, a false DPH
; must be constructed so that GENCPM allocates sufficient space for
; each data area. In the standard AUTODPB1-Version the dpb2 requires 
; most space for these buffers, therfore we fill in dpb2 in the dpheader.


xdpha:	ds 12		; do not change
DPHA:	dph	xltMax,dpbMax

lxdph	equ $-xdpha

    if driveb
xdphb:	ds 12		; do not change
DPHB:	dph	xltMax,dpbMax
    endif

    if drivec
xdphc:	ds 12		; do not change
DPHC:	dph	xltMax,dpbMax
    endif

    if drived
xdphd:	ds 12		; do not change
DPHD:	dph	xltMax,dpbMax
    endif

	cseg	; DPB must be resident

               ;***** DISK PARAMETER BLOCK CHAIN *****
               ;**************************************

; The following disk-parameter block chain defines the different
; disk formats you can work with. 

; First some definintions ...
	cseg

; Number of disk parameter blocks:
; ================================

DPBNR:	db frmcnt	; The std.-version contains 10 disk-parameter blocks.
			; Please adapt this number if you use more or fewer
			; disk formats.

; Number of tracks until the reverse seek-option will be choosen:

REVTRK:	db frmrev	; Reverse Seek


; An extended disk parameter block consists of two parts:

; First part labeld XDPBx contains specific physical informations
; about your disk drive:

; 1. NUM	1 Byte	0 if 255 Bytes per Sector ot lower
;			1 if 256, 2 if 512, 3 if 1024 ....
; 2. MXSC	1 Byte  Sectors per Track
; 3. GAP 3	1 Byte	Length of Gap 3
; 4. DTL	1 Byte	-1 if NUM > 0, else number of Bytes per Sector
; 5. SPEC	2 Bytes	Specify Parameter of your disk
; 6. TYPE	1 Byte	Type Flag
; 7. XLT	2 Bytes	Adress of translate table, must not be zero.

; Second part labeld DPBx contains logical disk informations as described
; in CP/M 3 System Guide. The Macro dpb generates a CP/M disk parameter block
; with the given informations.
	
; If you create a new XDPB these two parts must always be together. There must 
; be exact ten XDPB's with no space between each other (if not defined other 
; in DPBNR). The very first Disk-Parameter-Block in this chain  must 
; be labeld XDPB1 and DPB1. The following DPB's can be grouped in any order. If 
; login a drive the Bios start with XDPB1 and DPB1 resp. If failed, it reveals with 
; next Block following immediatelly after XDPB1 , then with the second Block
; after XDPB1 ... max. 10 times. 

; If none of the 10 possible DPB was correct (errors occured) the Bios auto-
; maticaly modifies the original TYPE-Byte. The two bits 5 and 6 alter their
; values in four steps:

; Step 1: Reset bit 5 and 6 of type bit to zero. Therfore switch off skip-
;	  option, try to access two sides of the drive.
;	  TYPE I: X00XXXXXb

; Then the Bios starts ten new retries (XDPB1-10) with the modified 
; type-flag. If still failled the type-flag will be modified as follows:

; Step 2: Try to login the drive with SKIP-Force and double sided option:
;	  TYPE II: X10XXXXb

; ... 10 new retries with XDPB1-10. If failled:

; Step 3: Switch off skip-force, switch on single sided option:
;	  TYPE III: X01XXXXXb

; ... 10 new retries. If failled again:

; Step 4: Switch on both skip-force and single-sided option:
;	  TYPE IV: X11XXXXXb 

; Step 1 - 4 will alter the TYPE-Flag in all of the eight XDPB's. Therfore
; max. 40 differnt formats will be detected. Each XDPB's with 4 different
; Options. 4 x 10 = max. 40 different disk formats.

; .... If now after 50 retries still failled an login error message occures .


; You must not create two XDPB's with identical physical but different logical
; parameters. With a given disk drive by the type flag (5 Zoll / 8 Zoll), 
; recording density (MFM/FM) the Sectors per track (MXSC) and Sectorlength (DTL,NUM)
; together must be unique, even if different GAP's, SPEC, XLT's, DIR's ... for
; another format are defined.

; For example a format with 256 Bytes per Sector and 16 Sectors per Track on an 
; 5 1/4 Zoll Drive with MFM may exist only once, even if the same format on another 
; DPB with different directory entries or block size exists. Choose for this
; new format lower or greater MXSC Parameter (15 or 17 Sectors per Track).


		; 1. Format nicht aendern !
;**********************************************
; DRIVE 1 Definition FD-55 F 5x1024 2x80
;**********************************************

sect1		equ	1024	; sector Size
mxsc1		equ	5	; sectors per track
mxtr1		equ	80	; tracks per surface
side1		equ	2	; number of surfaces
blk1		equ	1024*4	; number of 1K Blocksizes
dir1		equ	128	; number of directory entries
off1		equ	4	; offset for system tracks
skew1		equ	1	; skew faktor
type1		equ	tymfm + ty5zoll
spec1		equ	specf	; Specify Parameter
gap1		equ	25h	; Gap 3

	cseg
	cxdpb	1

	dseg
xlt1:	skew	mxsc1,skew1,1		; 5x1024x2x80



; next drive format to search ...


    if form2
;**********************************************
; DRIVE 2 Definition  FD55-G 9x1024, 2x80
;**********************************************

sect2		equ	1024	; sector Size
mxsc2		equ	9	; sectors per track
mxtr2		equ	80	; tracks per surface
side2		equ	2	; number of surfaces
blk2		equ	1024*2	; number of 1K Blocksizes
dir2		equ	256	; number of directory entries
skew2		equ	5	; skew faktor
off2		equ	4	; offset for system tracks
type2		equ	tymfm	; Type
spec2		equ	specg	; Specify Parameter
gap2		equ	7	; Gap 3

	cseg
	cxdpb	2

	dseg
xlt2:	skew	mxsc2,skew2,1		; 9x1024x2x80
    endif ; if form2


    if form3
;**********************************************
; DRIVE 3 Definition FD-55 F 9x512 2x80
;**********************************************

sect3		equ	512	; sector Size
mxsc3		equ	9	; sectors per track
mxtr3		equ	80	; tracks per surface
side3		equ	2	; number of surfaces
blk3		equ	1024*2	; number of 1K Blocksizes
dir3		equ	128	; number of directory entries
off3		equ	4	; offset for system tracks
type3		equ	tymfm + ty5zoll
spec3		equ	specf	; Specify Parameter
gap3		equ	1ah	; Gap 3

	cseg
	cxdpb	3

	dseg
xlt3:	db 	1,4,7,2,5,8,3,6,9	; Standard FD-55 F
    endif	; if form3



    if form4
;**********************************************
; DRIVE 4 Definition  FD55-G 16x512, 2x80
;**********************************************

sect4		equ	512	; sector Size
mxsc4		equ	16	; sectors per track
mxtr4		equ	80	; tracks per surface
side4		equ	2	; number of surfaces
blk4		equ	1024*2	; number of 1K Blocksizes
dir4		equ	256	; number of directory entries
skew4		equ	3	; skew faktor
off4		equ	4	; offset for system tracks
type4		equ	tymfm	; Type
spec4		equ	specg	; Specify Parameter
gap4		equ	7	; Gap 3

	cseg
	cxdpb	4

	dseg
xlt4:	skew	mxsc4,skew4,1		; 16x512x2x80
    endif	; if form4



    if form5
;**********************************************
; DRIVE 5 Definition  FD55-G 15x512, 2x77
;**********************************************

sect5		equ	512	; sector Size
mxsc5		equ	15	; sectors per track
mxtr5		equ	77	; tracks per surface
side5		equ	2	; number of surfaces
blk5		equ	1024*2	; number of 1K Blocksizes
dir5		equ	128	; number of directory entries
skew5		equ	5	; skew faktor
off5		equ	4	; reserved tracks
type5		equ	tymfm	; Type
spec5		equ	specg	; Specify Parameter
gap5		equ	1bh	; Gap 3

	cseg
	cxdpb	5

	dseg
xlt5:	skew	mxsc5,skew5,1 		; Standard FD-55G/8" 512x15x2x77
    endif	; if form5



    if form6
;**********************************************
; DRIVE 6 Definition FD55-F 10x512 2x80
;**********************************************

sect6		equ	512	; sector Size
mxsc6		equ	10	; sectors per track
mxtr6		equ	80	; tracks per surface
side6		equ	2	; number of surfaces
blk6		equ	1024*2	; number of 1K Blocksizes
dir6		equ	128	; number of directory entries
skew6		equ	1
off6		equ	0	; offset for system tracks
type6		equ	tymfm+ty5zoll	; Type
spec6		equ	specf	; Specify Parameter
gap6		equ	10h	; Gap 3

	cseg
	cxdpb	6

	dseg
xlt6:	skew	mxsc6,skew6,1		; FD-55F Copy 10x512x2x80
    endif	; if form6



    if form7
;**********************************************
; DRIVE 7 FD-55 B 16x256x1x40, Ecma 70
;**********************************************

sect7		equ	256	; sector Size
mxsc7		equ	16	; sectors per track
mxtr7		equ	40	; tracks per surface
side7		equ	1	; number of surfaces
blk7		equ	1024*1	; number of 1K Blocksizes
dir7		equ	64	; number of directory entries
skew7		equ	1	; skew faktor
off7		equ	4	; offset for system tracks
type7		equ	tymfm+ty5zoll+tysingle+tyskip	; Type
spec7		equ	specb	; Specify Parameter
gap7		equ	20h	; Gap 3

	cseg
	cxdpb	7

	dseg
xlt7:	skew	mxsc7,skew7,1		; Ecmac 70
    endif	; if form7


    if form8
;**********************************************
; DRIVE 8 Definition  IBM 3740 Standard
;**********************************************

sect8		equ	128	; sector Size
mxsc8		equ	26	; sectors per track
mxtr8		equ	77	; tracks per surface
side8		equ	1	; number of surfaces
blk8		equ	1024*1	; number of 1K Blocksizes
dir8		equ	64	; number of directory entries
skew8		equ	6	; skew faktor
off8		equ	2	; offset for system tracks
type8		equ	tysingle+tyfm	; Type
spec8		equ	specg	; Specify Parameter
gap8		equ	7	; Gap 3

	cseg
	cxdpb	8

	dseg
xlt8:	skew	mxsc8,skew8,1		; FD-55G/8" std ibm 3740
    endif	; if form8


    if form9
;**************************************************
; DRIVE 9 Definition  NCR F3 2x40 Tracks reverse
;**************************************************

sect9		equ	512	; sector Size
mxsc9		equ	8	; sectors per track
mxtr9		equ	40	; tracks per surface
side9		equ	2	; number of surfaces
blk9		equ	1024*2	; number of 1K Blocksizes
dir9		equ	128	; number of directory entries
skew9		equ	1	; skew faktor
off9		equ	3	; offset for system tracks
gap9		equ	2ah	; Gap 3
spec9		equ	specb	; Specify Parameter
type9		equ	tymfm+ty5zoll+tyreverse+tyskip	; Type-Byte
rev9		equ	40	; Reverse Track

	cseg
	cxdpb	9

	dseg
xlt9:	skew	mxsc9,skew9,1		; NCR F3
    endif	; if form9


    if form10
;**********************************************
; DRIVE 10 Definition 8" MFM Format 14x512x2x80
;**********************************************

sect10		equ	512	; sector Size
mxsc10		equ	14	; sectors per track
mxtr10		equ	80	; tracks per surface
side10		equ	2	; number of surfaces
blk10		equ	1024*4	; number of 1K Blocksizes
dir10		equ	128	; number of directory entries
skew10		equ	3	; skew faktor
off10		equ	4	; offset for system tracks
type10		equ	tymfm	; Type
spec10		equ	specg	; Specify Parameter
gap10		equ	25h	; Gap 3

	cseg
	cxdpb	10

	dseg
xlt10: 	skew	mxsc10,skew10,1		; 14x512x2x80
    endif	; if form10


    if form11
;***************************************************
; DRIVE 11 Definition FD-55 F 18*128*1*40 TRS-80 SD
;***************************************************

sect11		equ	128	; sector Size
mxsc11		equ	18	; sectors per track
mxtr11		equ	40	; tracks per surface
side11		equ	1	; number of surfaces
blk11		equ	1024*1	; number of 1K Blocksizes
dir11		equ	64	; number of directory entries
off11		equ	3	; offset for system tracks
skew11		equ	5	; skew-factor
type11		equ	tyfm+ty5zoll+tyskip+tysingle	; Type - Byte
gap11		equ	09h	; Gap 3
spec11		equ	specf	; Specify Parameter

	cseg
	cxdpb	11

	dseg
xlt11:	skew	mxsc11,skew11,1		; trs-80 sd
    endif	; if form11


    if form12
;************************************************
; DRIVE 12 Definition  FD55-F 1*40*256 Osborne SD
;************************************************

sect12		equ	256	; sector Size
mxsc12		equ	10	; sectors per track
mxtr12		equ	40	; tracks per surface
side12		equ	1	; number of surfaces
blk12		equ	1024*2	; number of 1K Blocksizes
dir12		equ	64	; number of directory entries
skew12		equ	2	; skew faktor
off12		equ	3	; offset for system tracks
gap12		equ	10h	; Gap 3
spec12		equ	specf	; Specify Parameter
type12		equ	tyfm+ty5zoll+tysingle+tyskip	; Type

	cseg
	cxdpb	12

	dseg
xlt12:	skew	mxsc12,skew12,1		; osborne sd
    endif	; if form12


    if form13
;****************************************************
; DRIVE 13 Definition  FD55-F 8*512*1*40, IBM cp/m 86
;****************************************************

sect13		equ	512	; sector Size
mxsc13		equ	8	; sectors per track
mxtr13		equ	40	; tracks per surface
side13		equ	1	; number of surfaces
blk13		equ	1024*1	; number of 1K Blocksizes
dir13		equ	64	; number of directory entries
skew13		equ	1	; skew faktor
off13		equ	1	; reserved tracks
type13		equ	tymfm+ty5zoll+tysingle+tyskip	; Type
gap13		equ	1Bh	; GAP 3
spec13		equ	specf	; Specify parameter

	cseg
	cxdpb	13

	dseg
xlt13:	skew	mxsc13,skew13,1 		; cp/m 86
    endif	; if form13


    if form14
;****************************************************
; DRIVE 14 Definition FD55-F 9x512 2x40 360kB MS-DOS
;****************************************************

sect14		equ	512	; sector Size
mxsc14		equ	9	; sectors per track
mxtr14		equ	40	; tracks per surface
side14		equ	2	; number of surfaces
blk14		equ	1024*2	; number of 1K Blocksizes
dir14		equ	64	; number of directory entries
skew14		equ	1	; skew faktor
off14		equ	0	; reserved tracks
type14		equ	tymfm+ty5zoll+tyskip	; Type
gap14		equ	20	; GAP 3
spec14		equ	specf	; Specify parameter

	cseg
	cxdpb	14

	dseg
xlt14:	skew	mxsc14,skew14,1
    endif	; if form14


    if form15
;****************************************************
; DRIVE 15 Definition FD55-F 5x1024 1x40 Osborne DD
;****************************************************

sect15		equ	1024	; sector Size
mxsc15		equ	5	; sectors per track
mxtr15		equ	40	; tracks per surface
side15		equ	1	; number of surfaces
blk15		equ	1024*1	; number of 1K Blocksizes
dir15		equ	64	; number of directory entries
skew15		equ	1	; skew faktor
off15		equ	3	; reserved tracks
type15		equ	tymfm+ty5zoll+tyskip+tysingle	; Type
gap15		equ	20	; GAP 3
spec15		equ	specf	; Specify parameter

	cseg
	cxdpb	15

	dseg
xlt15:	skew	mxsc15,skew15,1
    endif	; if form15

    if form16
;****************************************************
; DRIVE 16 Definition FD55-F 9x512 2x80 Vortex
;****************************************************

sect16		equ	512	; sector Size
mxsc16		equ	9	; sectors per track
mxtr16		equ	80	; tracks per surface
side16		equ	2	; number of surfaces
blk16		equ	1024*4	; number of 1K Blocksizes
dir16		equ	128	; number of directory entries
skew16		equ	1	; skew faktor
off16		equ	2	; reserved tracks
type16		equ	tymfm+ty5zoll	; Type
gap16		equ	10	; GAP 3
spec16		equ	specf	; Specify parameter

	cseg
	cxdpb	16

	dseg
xlt16:	skew	mxsc16,skew16,1
    endif	; if form16

    if form17
;****************************************************
; DRIVE 17 Definition FD55-F 9x512 2x80 Atari CP/M
;****************************************************

sect17		equ	512	; sector Size
mxsc17		equ	9	; sectors per track
mxtr17		equ	80	; tracks per surface
side17		equ	2	; number of surfaces
blk17		equ	1024*2	; number of 1K Blocksizes
dir17		equ	128	; number of directory entries
skew17		equ	1	; skew faktor
off17		equ	2	; reserved tracks
type17		equ	tymfm+ty5zoll	; Type
gap17		equ	10	; GAP 3
spec17		equ	specf	; Specify parameter

	cseg
	cxdpb	17

	dseg
xlt17:	skew	mxsc17,skew17,1
    endif	; if form17

    if form18
;****************************************************
; DRIVE 18 Definition FD55-F 16x256 2x70 ITT 3030
;****************************************************

sect18		equ	256	; sector Size
mxsc18		equ	16	; sectors per track
mxtr18		equ	70	; tracks per surface
side18		equ	2	; number of surfaces
blk18		equ	1024*2	; number of 1K Blocksizes
dir18		equ	128	; number of directory entries
skew18		equ	1	; skew faktor
off18		equ	4	; reserved tracks
type18		equ	tymfm+ty5zoll+tyreverse	; Type
gap18		equ	20	; GAP 3
spec18		equ	specf	; Specify parameter
rev18		equ	70	; Reverse Track

	cseg
	cxdpb	18

	dseg
xlt18:	skew	mxsc18,skew18,1
    endif	; if form18

    if form19
;********************************************************
; DRIVE 19 Definition FD55-F 16x256 2x77 Kontron PSI-80
;********************************************************

sect19		equ	256	; sector Size
mxsc19		equ	16	; sectors per track
mxtr19		equ	77	; tracks per surface
side19		equ	2	; number of surfaces
blk19		equ	1024*2	; number of 1K Blocksizes
dir19		equ	256	; number of directory entries
skew19		equ	3	; skew faktor
off19		equ	4	; reserved tracks
type19		equ	tymfm+ty5zoll+tyreverse	; Type
gap19		equ	32	; GAP 3
spec19		equ	specf	; Specify parameter
rev19		equ	77	; Reverse Track

	cseg
	cxdpb	19

	dseg
xlt19:	skew	mxsc19,skew19,1
    endif	; if form19

    if form20
;********************************************************
; DRIVE 20 Definition FD55-F 16x256, 2x40 Krueger
;********************************************************

sect20		equ	256	; sector Size
mxsc20		equ	16	; sectors per track
mxtr20		equ	40	; tracks per surface
side20		equ	2	; number of surfaces
blk20		equ	1024*2	; number of 1K Blocksizes
dir20		equ	64	; number of directory entries
skew20		equ	1	; skew faktor (nicht erfassbar)
off20		equ	4	; reserved tracks
type20		equ	tymfm+ty5zoll+tyskip	; Type
gap20		equ	32	; GAP 3
spec20		equ	specf	; Specify parameter
rev20		equ	40	; Reverse Track

	cseg
	cxdpb	20

	dseg
xlt20:	skew	mxsc20,skew20,1
    endif	; if form20

    if form21
;**********************************************
; DRIVE 21 FD-55 B 16x256x1x40, Uwe Lemties
;**********************************************

sect21		equ	256	; sector Size
mxsc21		equ	16	; sectors per track
mxtr21		equ	80	; tracks per surface
side21		equ	1	; number of surfaces
blk21		equ	1024*2	; number of 1K Blocksizes
dir21		equ	64	; number of directory entries
skew21		equ	1	; skew faktor
off21		equ	4	; offset for system tracks
type21		equ	tymfm+ty5zoll+tysingle+tyskip	; Type
spec21		equ	specb	; Specify Parameter
gap21		equ	20h	; Gap 3

	cseg
	cxdpb	21

	dseg
xlt21:	skew	mxsc21,skew21,1
    endif	; if form21

    if form22
;**********************************************
; DRIVE 22 FD-55 B 8x512x2x40, IBM CP/M-86 DS
;**********************************************

sect22		equ	512	; sector Size
mxsc22		equ	8	; sectors per track
mxtr22		equ	40	; tracks per surface
side22		equ	2	; number of surfaces
blk22		equ	1024*2	; number of 1K Blocksizes
dir22		equ	64	; number of directory entries
skew22		equ	1	; skew faktor
off22		equ	1	; offset for system tracks
type22		equ	tymfm+ty5zoll+tyreverse+tyibm+tyskip	; Type
rev22		equ	40	; reverse track
spec22		equ	specf	; Specify Parameter
gap22		equ	20h	; Gap 3

	cseg
	cxdpb	22

	dseg
xlt22:	skew	mxsc22,skew22,1
    endif	; if form22



    if form23
;********************************************************
; DRIVE 23 Definition FD55-F 9x512 1x80 Atari 520 ST SSDD
;********************************************************

sect23		equ	512	; sector Size
mxsc23		equ	9	; sectors per track
mxtr23		equ	80	; tracks per surface
side23		equ	1	; number of surfaces
blk23		equ	1024*2	; number of 1K Blocksizes
dir23		equ	64	; number of directory entries
skew23		equ	1	; skew faktor
off23		equ	0	; reserved tracks
type23		equ	tymfm+ty5zoll+tysingle	; Type
gap23		equ	20	; GAP 3
spec23		equ	specf	; Specify parameter

	cseg
	cxdpb	23

	dseg
xlt23:	skew	mxsc23,skew23,1
    endif	; if form23



    if form24
;********************************************************
; DRIVE 24 Definition FD55-F 18x512 2x80 IBM 3.5" HD
;********************************************************

sect24		equ	512	; sector Size
mxsc24		equ	18	; sectors per track
mxtr24		equ	80	; tracks per surface
side24		equ	2	; number of surfaces
blk24		equ	1024*4	; number of 1K Blocksizes
dir24		equ	256	; number of directory entries
skew24		equ	1	; skew faktor
off24		equ	0	; reserved tracks
type24		equ	tymfm	; Type
gap24		equ	40	; GAP 3
spec24		equ	specg	; Specify parameter

	cseg
	cxdpb	24

	dseg
xlt24:	skew	mxsc24,skew24,1
    endif	; if form24



    if form25
;********************************************************
; DRIVE 25 Definition FD55-F 15x512 2x80 IBM 5.25" HD
;********************************************************

sect25		equ	512	; sector Size
mxsc25		equ	15	; sectors per track
mxtr25		equ	80	; tracks per surface
side25		equ	2	; number of surfaces
blk25		equ	1024*4	; number of 1025k Blocksizes
dir25		equ	256	; number of directory entries
skew25		equ	1	; skew faktor
off25		equ	0	; reserved tracks
type25		equ	tymfm	; Type
gap25		equ	30	; GAP 3
spec25		equ	specg	; Specify parameter

	cseg
	cxdpb	25

	dseg
xlt25:	skew	mxsc25,skew25,1
    endif	; if form25


    if form26
;**********************************************
; DRIVE 26 Definition  SA-850 9x1024, 2*77
;**********************************************

sect26		equ	1024	; sector Size
mxsc26		equ	9	; sectors per track
mxtr26		equ	77	; tracks per surface
side26		equ	2	; number of surfaces
blk26		equ	1024*2	; number of 1K Blocksizes
dir26		equ	256	; number of directory entries
skew26		equ	1	; skew faktor
off26		equ	0	; offset for system tracks
type26		equ	tymfm	; Type
spec26		equ	specg	; Specify Parameter
gap26		equ	7	; Gap 3

	cseg
	cxdpb	26

	dseg
xlt26:	skew	mxsc26,skew26,1		; 9x1024x2x80
    endif	; if form26


    if form27
;**********************************************
; DRIVE 27 Definition  FD35H - 10x1024x2x80
;**********************************************

sect27		equ	1024	; sector Size
mxsc27		equ	10	; sectors per track
mxtr27		equ	80	; tracks per surface
side27		equ	2	; number of surfaces
blk27		equ	1024*4	; number of 1K Blocksizes
dir27		equ	256	; number of directory entries
skew27		equ	1	; skew faktor
off27		equ	0	; offset for system tracks
type27		equ	tymfm	; Type
spec27		equ	specg	; Specify Parameter
gap27		equ	7	; Gap 3

	cseg
	cxdpb	27

	dseg
xlt27:	skew	mxsc27,skew27,1		; 9x1024x2x80
    endif	; if form27


	getmax	frmnum		; groesstes format bestimmen

	end
