
;******************************************************************
;*               Kleines  Assemblerprogramm zum lesen             *
;*               und darstellen der Uhrzeit                       *
;*               (C) GES GMBH                                     *
;*               Winzek, K|hler 10/86                             *
;*               Fehler behoben (Stundenanzeige...) von           *
;*               Kracker 15.01.87                                 *
;******************************************************************

.z80
		;SMARTWATCH-Programme, smartw11
		;Uhrzeit lesen

		ORG     0100h



STARTUZ:	LD	SP,STACK
		LD	DE,TEXT1
		CALL	TEXTAUS
		JP	START
WCYCLE:		LD	B,8		;1 BYTE SCHREIBEN
WCYC1:		LD	(HL),A
		SRL 	A
		DJNZ	WCYC1
		RET
RCYCLE:		PUSH	DE
		LD	B,8		;1 BYTE LESEN
RCYC1:		SRL 	D
		LD	A,(HL)
		BIT	0,A
		JR	NZ,RCYC2
		RES	7,D
		JR	RCYC3
RCYC2:		SET	7,D
RCYC3:		DJNZ	RCYC1
		LD	A,D
		POP	DE
		RET
ACCES:		LD	HL,SCRATCHP	;ZUGANGSWORT SCHREIBEN
		LD	A,(HL)
		LD	A,0C5H		;C5
		CALL	WCYCLE
		LD	A,3AH		;3A
		CALL	WCYCLE
		LD	A,0A3H		;A3
		CALL	WCYCLE
		LD	A,5CH		;5C
		CALL	WCYCLE
		LD	A,0C5H		;C5
		CALL	WCYCLE
		LD	A,3AH		;3A
		CALL	WCYCLE
		LD	A,0A3H		;A3
		CALL	WCYCLE
		LD	A,5CH		;5C
		CALL	WCYCLE
		RET
READCL:		LD	DE,CLREG	;ALLE 8 REGISTER LESEN UND AB 
		LD	C,8		;ADRESSE CLREG IM SPEICHER ABLEGEN
		CALL	ACCES
RCL1:		CALL	RCYCLE
		LD	(DE),A
		INC	DE
		DEC	C
		JR	NZ,RCL1
		RET
WRITECL:	LD	DE,CLREG	;ALLE 8 REGISTER VON ADRESSE CLREG
		LD	C,8		;AB IN DIE UHR SCHREIBEN
		CALL	ACCES
WRCL1:		LD	A,(DE)
		INC	DE
		CALL	WCYCLE
		DEC 	C
		JR	NZ,WRCL1
		RST	38H
		DS	20		;HIER 36 BYTES STACKH
STACK:		DW	0
CLREG:		DW	0		;UHRREGISTER:1/100 SEK,SEK,MIN,STD
		DS	8		;WO.TAG,TAG,MON,JAHR
FLAG:		DB	0		;MERKER F]R SEITENUMSCHALTUNG
SEKALT:		DB	0		;HIER ALTER ZUSTAND SEK-REGISTER
ZEIT:		DB	'B'		;FLOMON-CODE F]R TEXT AUSGEBEN
STD:		DW	0		
		DB	':'
MIN:		DW	0
		DB	':'
SEK:		DW	0	
		DB	0DH,'$'
DATUM:		DB	'B'
TAG:		DW	0
		DB	'.'
MON:		DW	0
		DB	'.'
JAHR:		DW	0
		DB	0DH,'$'
TEXT1:		DB	1BH,1BH,'G',0DH,'P 0',0DH,'C',0DH,'G3 44',0DH,'$'
TEXT2:		DB	'C',0DH,'M100 100',0DH,'G3 68',0DH,'$'
TEXT3:		DB	'Z;A$'
TEXT4:		DB	'S11',0DH,'$'
TEXT5:		DB	'S14',0DH,'$'
TEXT6:		DB	'M100 20',0DH,'$'
SCRATCHP	EQU	2000H
BDOS		EQU	5
START:		CALL	CSTS		;ABFRAGE, OB TASTE GEDR]CKT
		AND	A		;ZERO-FLAG SETZEN, WENN A=0
		JP	NZ,ABBRECH	;ABBRECHEN, WENN TASTE GEDR]CKT
		CALL	READCL		;AKTUELLE WERTE NACH CLREG
		LD	A,(CLREG+1)	;SEK VON CLREG+1 HOLEN, IN ASCII-
		LD	(SEKALT),A	;ZEICHEN WANDELN UND BEI "SEK" AB-
		LD	HL,SEK		;LEGEN
		CALL	HEXASCII
		LD	A,(CLREG+2)	;MIN IN ASCII BEI "MIN" ABLEGEN
		LD	HL,MIN
		CALL	HEXASCII
		LD	A,(CLREG+3)	;STD IN ASCII BEI "STD" ABLEGEN
		AND	3FH		;STEUERBITS AUSBLENDEN
		LD	HL,STD
		CALL	HEXASCII
		LD	A,(CLREG+5)
		LD	HL,TAG
		CALL	HEXASCII
		LD	A,(CLREG+6)
		LD	HL,MON
		CALL	HEXASCII
		LD	A,(CLREG+7)
		LD	HL,JAHR
		CALL	HEXASCII
		LD	DE,text2	;BS L\SCHEN,X-,Y-, ZEICHGR\SSE
		CALL	TEXTAUS		;SETZEN
		LD	de,ZEIT		;STD,MIN,SEK AUSGEBEN
		CALL	TEXTAUS
		LD	DE,TEXT6
		CALL	TEXTAUS
		LD	DE,DATUM
		CALL	TEXTAUS
WARTEN:		CALL	READCL		;NEUE WERTE VON UHR, SEK MIT ALTER
		LD	A,(CLREG+1)	;SEKUNDE VERGLEICHEN, WARTEN BIS
		LD	HL,SEKALT	;N[CHSTE SEKUNDE
		CP	(HL)
		JR	Z,WARTEN
		LD	A,(FLAG)	;SEITENUMSCHALTUNG: ENTWEDER WIRD
		AND	A		;AUF SEITE 2 GESCHRIEBEN UND VON
		CPL			;SEITE 3 GELESEN ODER UMGEKEHRT
		LD	(FLAG),A	;MERKER DAF]R IST FLAG.WAR FLAG
		JR	Z,WA1		;=0 WIRD ES 1 GESETZT UND UMGEKEHRT
		LD	DE,TEXT4	;TEXT4:SCHREIBSEITE= 2
		CALL	TEXTAUS		;      LESESEITE   = 3
		JR	WA2
WA1:		LD	DE,TEXT5	;TEXT5:SCHREIBSEITE= 3
		CALL	TEXTAUS		;      LESESEITE   = 2
WA2:		JP	START
TEXTAUS:	PUSH	BC		;UNTERPROGRAMM ZUR TEXTAUSGABE
		PUSH	HL		;REGISTER RETTEN, WERDEN BEIM
TA2:		LD	A,(DE)		;BDOS-AUFRUF VER[NDERT
		INC DE			;DE IST ZEIGER AUF TEXT
		CP	'$'		;$ IST ENDEZEICHEN
		JP	Z,TA1
		PUSH	DE
		LD	E,A		;BDOS-FUNKTION 2:KONSOLAUSGABE
		LD	C,2		;ASCII-ZEICHEN IN E,FUNKTIONSNR.
		CALL	BDOS		;IN C
		POP	DE
		JR	TA2		;WIEDERHOLEN BIS ENDEZEICHEN
TA1:		POP	HL		;GERETTTE REGISTER ZUR]CKSCHREIBEN
		POP	BC
		RET
CSTS:		PUSH	BC		;BDOS-FUNKTION 11: HOLE KONSOLSTATUS
		PUSH	HL		;FUNKTIONSNR. 11=HEX B IN REGISTER C
		PUSH	DE
		LD	C,0BH
		CALL	BDOS
		POP	DE
		POP	HL	
		POP	BC
		RET
HEXASCII:	PUSH	AF		;UNTERPROGRAMM WANDELT BCD-BYTE
		AND	0F0H		;IN ZWEI ASCII-ZEICHEN, DIE BEI
		SRL	A		;DER ADRESSE ABGELEGT WERDEN, AUF
		SRL	A		;DIE HL ZEIGT.LINKES HALBBYTE WIRD
		SRL	A		;MASKIERT UND IN RECHTES HALBBYTE
		SRL	A		;GESCHOBEN
		CALL	TESTASCI	;ZEICHEN IN ASCII WANDELN
		LD	(HL),A		;BEI (HL) ABSPEICHERN
		INC	HL		;ZEIGER AUF N[CHSTEN SPEICHERPLATZ
		POP	AF		;GERETTETEN AKKU ZUR]CKHOLEN
		AND	0FH		;RECHTES HALBBYTE MASKIEREN
		CALL	TESTASCI	;IN ASCII WANDELN
		LD	(HL),A		;BEI (HL) ABSPEICHERN
		INC	HL		;ZEIGER:=ZEIGER+1
		RET
TESTASCI:	ADD	A,30H		;ZIFFER: 30 ADDIEREN
		CP	3AH		;WENN ZIFFER, DANN CARY
		RET	C
		ADD	A,7		;WAR BUCHSTABE, DANN INSGESAMT
		RET			;37H ADDIEREN
ABBRECH:	LD	DE,TEXT3	;TEXT3: BS L\SCHEN, IN ALPHAMODS
		CALL	TEXTAUS		;ZUR]CK
		JP	0		;ZEAT- BZW. CP/M WARMSTART	
		DS	1D90H		

                END   

.SEˡDATUͥTAǦMOΩJAHҬTEXTTEXTTEXTTEXTTEXTTEXTSCRATCH  BDO STARWARTE