	;******************************************************************
	;*Programm INITRAM						  *
	;* - l|scht die ersten 5 Spuren der Ramfloppy am NDR-Klein-       *
        ;*   Computer, l|scht somit 300 Directory-Eintr{ge, sollte auch   *
	;*   f}r sp{tere Erweiterungen ausreichen.			  *
	;*   ACHTUNG   n i c h t   mit derzeitigem Winchester-BIOS        *
	;*   verwenden, da sonst das DIR der Winchester gel|scht wird.    *
	;*(C) F.J. EHRENSPERGER, M}nchen 1986				  *
	;******************************************************************

	;Definition von Systemadressen
WSTART	EQU	00000H		;Adresse f}r Warmstart
SYSTEM	EQU	00005H		;Adresse f}r Aufruf von
				;Systemfunktionen

	;Definition von Systemfunktionen
CONEINF	EQU	01H		;Eingabe von Tastatur (CONSOLE)
STRAUSF	EQU	09H		;Stringausgabe

	;Definition von BIOS-Funktionen
SELDSK	EQU	0EA1BH		;Laufwerk Nr. ausw{hlen
SETTRK	EQU	0EA1EH		;Spur Nr. ausw{hlen
SETSEC	EQU	0EA21H		;Sektor Nr. ausw{hlen
SETDMA	EQU	0EA24H		;DMA Adresse festlegen
WRITE	EQU	0EA2AH		;Sektor schreiben

	;Definitionen von ASCII-Konstanten
CR	EQU	0DH		;Carriage Return
LF	EQU	0AH		;Lind Feed
STOP	EQU	'$'		;$-Zeichen als Stringende		

	;******************************************************************
	;* Hauptprogramm INITRAM					  *
	;******************************************************************
	
	org	100H		;Programmbeginn bei 100H
START:
	LD	C,09H		;Stringausgabefunktion in REG. C
	LD	DE,STRING1	;Startadresse des Strings
	CALL	SYSTEM		;Systemaufruf
	LD	C,01H		;Consoleneingabefunktion in REG. C
	CALL	SYSTEM		;Systemaufruf
	AND	05FH		;nur Gro~buchstaben
	CP	'N'		;Eingabe N ?
	JP	Z,WSTART	;ja, dann Warmstart durchf}hren
	CP	'J'		;Eingabe J ?
	JP	Z,INIT		; ja, dann zur Initialisierungsroutine
	JP	START

STRING1:
	DB	1AH,'RAMFLOPPY-INITIALISIERUNGS-PROGRAMM, V1.1'
	DB	CR,LF,'fuer NDR-KLEIN-COMPUTER, Z80-System'
	DB	CR,LF,'(C) F.J. EHRENSPERGER, Muenchen 1986'
	DB	CR,LF
	DB	CR,LF,'RAMFLOPPY LOESCHEN? (J/N):',STOP

INIT:
	LD	C,4H		;Laufwerk Nr. in REG. C
	CALL	SELDSK		;Laufwerk selektieren
	LD	BC,DATEN	;Startadresse der Daten
	CALL	SETDMA		;Startadresse festlegen
	LD	BC,0		;Nr. der ersten Spur in REG. BC
	LD	HL,05H		;Anzahl der zu l|schen Spuren
SPURSEL:
	PUSH	HL		;HL auf Stack retten
	PUSH	BC		;BC auf Stack retten
	CALL	SETTRK		;Spur Nr. festlegen
	LD 	BC,0		;Sektor Nr. in REG. BC
	CALL	TRKWRITE	;kompl. Spur beschreiben
	POP	BC		;BC von Stack holen
	INC	BC		;Spur Nr. erh|hen
	POP 	HL		;HL von Stack holen
	DEC	HL		;Z{hler HL erniedrigen
	LD	A,L
	OR	A		;ist HL schon Null?
	JR	NZ,SPURSEL	;nein, dann n{chste Spur
	JP	WSTART		;ja, dann Warmstart durchf}hren

TRKWRITE:
	PUSH	BC		;BC auf Stack sichern
	CALL	SETSEC		;Sektor festlegen
	CALL	WRITE		;Sektor schreiben
	CP	1H		;Test ob Bank vorhanden
	JP	Z,ERROR		;ja: dann Fehler ausgeben		
	POP	BC		;BC von Stack holen
	INC	BC		;Sektor Nr. erh|hen
	LD	A,C		;letzter Sektor
	CP	0FH		;der Spur
	JR	NZ,TRKWRITE	;nein, dann n{chster Sektor
	RET			;ja, dann zur}ck

ERROR:
	LD	C,STRAUSF	;Stringausgabe ins REG C
	LD	DE,ERRORMSG	;Startadresse der Fehlermeldung
	CALL	SYSTEM		;Systemafruf
	JP	WSTART		;Warmstart ausf}hren

ERRORMSG:
	DB	CR,LF
	DB	CR,LF,'RAMFLOPPY laesst sich nicht beschreiben'
	DB	CR,LF,'Moegliche Fehler:'
	DB	CR,LF,'a) Kein Speicher dafuer vorhanden'
	DB	CR,LF,'b) Speicherkarte falsch adressiert'
	DB	CR,LF,'c) Speicherkarte defekt',STOP

DATEN:
	DS	128,0E5H	;128 Bytes mit E5H belegen

	END	START		;Programmz{hler auf Anfang
WSTAR  SYSTE CONEIN S