program clut2;

{$I col1.bib}
{$I col2.bib}

type
  tcol  = array[0..2] of byte;
  tallcol = array[0..255] of tcol;
  tstr = string[6];

const
  clut_adr = $a4;
  clut_dta = $a5;
  clut_msk = $a6;
  dx   = 40;
  xoff = 20;
  yoff = 20;
  colnam : array[0..2] of tstr = ('Rot','Gruen','Blau');

var
  ende     : boolean;
  farbnum  : integer;
  num      : integer;
  mx,my,maltx,malty : integer;
  col      : tcol;
  allcol   : tallcol;
  ch       : char;

procedure kreuz(x,y:integer);
  begin
    line(x-5,y,x+5,y,255,3);
    line(x,y-5,x,y+5,255,3);
  end;

procedure page(p:integer);
  begin
    if p=1 then p:=$50;
    inline($cd/$55/$f0/$3a/p/$d3/$60);
  end;

procedure draw(x,y:integer);
  begin
    inline($2a/x/$ed/$5b/y/$cd/$49/$f0);
  end;

procedure move(x,y:integer);
  begin
    inline($2a/x/$ed/$5b/y/$cd/$46/$f0);
  end;

procedure cmd(reg,bef:byte);
  begin
    reg:=reg+$70;
    inline( $cd/$55/$f0/$3a/reg/$4f/$3a/bef/$ed/$79 );
  end;

procedure wrtgdp(x,y:integer; text:tstr);
  var i:integer;
  begin
    move(x,y);
    for i:=1 to length(text) do
      cmd(0,ord(text[i]));
  end;

procedure balken(num,hoehe:integer);
  var x1,y1,x2,y2:integer;
      txt : tstr;

  procedure rechteck(x1,y1,x2,y2:integer);
    begin
      move(x1,y1);
      draw(x1,y2);
      draw(x2,y2);
      draw(x2,y1);
      draw(x1,y1);
    end;

  begin
    x1:=num*dx+xoff;
    y1:=yoff;
    x2:=x1+dx-3;
    y2:=y1+2*hoehe;
    page(0); rechteck(x1,y1,x2,y2);
    page(1); rechteck(x1,y1,x2,y2);
    x1:=num*dx+xoff;
    y1:=yoff-10;
    str(hoehe*100/63:2:1,txt);
    txt:=txt+'%';
    page(0); wrtgdp(x1,y1,txt);
    page(1); wrtgdp(x1,y1,txt);
  end;

procedure select(num:integer);
  var i:integer;
  begin
    for i:=0 to 2 do
      if i<>num then
        begin
          cmd(2,0); cmd(0,1); balken(i,col[i]);
          cmd(2,1); cmd(0,0); balken(i,col[i]);
        end
      else begin
          cmd(2,0); cmd(0,0); balken(i,col[i]);
        end;
      cmd(2,0); cmd(0,0);
  end;

procedure setfarbe(fnum:integer; col:tcol);
  begin
    port[clut_adr]:=fnum;
    port[clut_dta]:=col[0];
    port[clut_dta]:=col[1];
    port[clut_dta]:=col[2];
  end;

procedure neufarbnum;
  var i,x,y:integer;
  begin
    num:=0;clrscr;
    col := allcol[farbnum];
    gotoxy(40,3); write('Farbnummer = ',farbnum);
    x:=xoff; y:=yoff+2*63+3;
    for i:=0 to 2 do
      begin
        balken(i,col[i]);
        wrtgdp(x,y,colnam[i]);
        x:=x+dx;
      end;
    gotoxy(40,5); writeln(colnam[num]);
    select(num);
  end;

procedure init;
  var i,j,a,r,g,b : integer;
  begin
    a:=0;
    port[clut_adr]:=a;
    for i:=0 to 15 do
      for j:=0 to 15 do
        begin
          r:=i shl 2; g:=j shl 2; b:=0;
          port[clut_dta]:=r; allcol[a][0]:=r;
          port[clut_dta]:=g; allcol[a][1]:=g;
          port[clut_dta]:=b; allcol[a][2]:=b;
          a:=succ(a);
        end;
    farbnum:=1;
    neufarbnum;
    ende:=false;
    colinit;
    mx:=127; my:=127;
    maltx:=mx; malty:=my;
    kreuz(mx,my);
  end;

function getkey : char;
  var xx     : byte;
      fertig : boolean;
      taste  : byte;
  begin
    fertig:=false;
    repeat
      maus(mx,my,taste);
      if mx>255 then mx:=255;
      if mx<0 then mx:=0;
      if my>255 then my:=255;
      if my<0 then my:=0;
      if (mx<>maltx) or (my<>malty) then
        begin
          kreuz(maltx,malty);
          kreuz(mx,my);
          maltx:=mx; malty:=my;
        end;
      if (taste and $40) <>0 then
        begin
          farbnum:=pred(pget(mx,my));
          getkey:='+';
          fertig:=true;
        end;
    until ((port[$68] and $80) = 0) or fertig;
    if not fertig then
      begin
        getkey:=chr(port[$68]);
        xx:=port[$69];
      end;
  end;

begin
  init;
  repeat
    ch:=getkey;
    case ch of
      ^E : if col[num] < 63 then
             begin
               cmd(0,1);
               balken(num,col[num]);
               cmd(0,0);
               col[num]:=succ(col[num]);
               balken(num,col[num]);
               setfarbe(farbnum,col);
             end;
      ^X : if col[num] > 0 then
             begin
               cmd(0,1);
               balken(num,col[num]);
               cmd(0,0);
               col[num]:=pred(col[num]);
               balken(num,col[num]);
               setfarbe(farbnum,col);
             end;
      ^S : begin
             if num>0 then num:=pred(num)
                      else num:=2;
             gotoxy(40,5);
             clreol;
             write(colnam[num]);
             select(num);
           end;
      ^D : begin
             if num<2 then num:=succ(num)
                      else num:=0;
             gotoxy(40,5);
             clreol;
             write(colnam[num]);
             select(num);
           end;
      ^^ : begin
             allcol[farbnum]:=col;
             gotoxy(40,3); clreol;
             write('Neue Farbnummer: '); readln(farbnum);
             if farbnum>255 then farbnum:=255;
             if farbnum<0 then farbnum:=0;
             neufarbnum;
           end;
      '+'  : begin
               allcol[farbnum]:=col;
               farbnum:=succ(farbnum);
               if farbnum>255 then farbnum:=0;
               neufarbnum;
             end;
      '-'  : begin
               allcol[farbnum]:=col;
               farbnum:=pred(farbnum);
               if farbnum<0 then farbnum:=255;
               neufarbnum;
             end;
      'E','e' : ende:=true;
    end;
  until ende;
  clrscr;
  kreuz(mx,my);
end.
