{****************************************************************************}
{* SDIR-03.INC                         Disk-Verzeichnis und Super-Directory *}
{****************************************************************************}

PROCEDURE DiskVerzFortschreiben;
LABEL 1;
BEGIN
  IF LDrive <> SDLaufwerk THEN Laufwerkwechsel (LDrive, LDriveC);
  ASSIGN (DiskDatei, 'DISKVERZ.DAT');
1:{$I-} RESET (DiskDatei); {$I+}
  IF (IORESULT <> 0) THEN                     {leere Datei anlegen}
  BEGIN
    REWRITE (DiskDatei);
    FOR SatzNr := 0 TO MaxDiskNr DO
    WITH Satz DO
    BEGIN
      LfdNr := SatzNr;
      DiskInhalt := '';
      DirDateien := 0;
      RestKap := 0;
      Update := '';
      WRITE (DiskDatei, Satz);
    END;
    CLOSE (DiskDatei);
    GOTO 1;
  END;
  Kat := COPY (DiskDaten,1,1);                {SatzNr bestimmen}
  KatNr := ORD (Kat) -65;
  Disk := COPY (DiskDaten,2,2);
  VAL (Disk, Nr, Fehler);
  SatzNr := (100 * KatNr) + Nr;
  SEEK (DiskDatei, SatzNr);
  READ (DiskDatei, Satz);
  WITH Satz DO                                {Datensatz aendern}
    BEGIN
      LfdNr := SatzNr;
      DiskInhalt := COPY (DiskDaten, 4, LENGTH(DiskDaten)-3);
      DirDateien := Zaehler;
      RestKap := RestKapazitaet;
      Update := Datum;
    END;
    SEEK (DiskDatei, SatzNr);
    WRITE (DiskDatei, Satz);
  CLOSE (DiskDatei);
  IF NOT EingabeAnfang THEN Laufwerkwechsel (LDrive, LDriveC);
END; {DiskVerzFortschreiben}

{****************************************************************************}

OVERLAY PROCEDURE DiskVerzAusgeben (VAR Seite: BYTE);
CONST MehrSeiten : BOOLEAN = FALSE;
BEGIN
  ASSIGN (f, 'CON:'); WRITE (f, DT);
  IF Druck THEN BEGIN
    DatumLesen (Datum);
    GOTOXY(6,21); CLREOL; WRITE ('Ist der Drucker eingeschaltet? (J/N) ');
    REPEAT
      READ (KBD, Ch); Ch := UPCASE (Ch);
    UNTIL Ch IN ['J','N']; IF Ch = 'N' THEN EXIT;
    GOTOXY(6,21); CLREOL; WRITE ('Diskettenverzeichnis drucken? (J/N) ');
    REPEAT
      READ (KBD, Ch); Ch := UPCASE (Ch);
    UNTIL Ch IN ['J','N']; IF Ch = 'N' THEN EXIT;
    ASSIGN (f, 'LST:'); DruckFormat; DruckKopfzeileDiskVerz;
  END;
  IF LDrive <> SDLaufwerk THEN Laufwerkwechsel (LDrive, LDriveC);
  ASSIGN (DiskDatei, 'DISKVERZ.DAT');
  {$I-} RESET (DiskDatei) {$I+};
  IF IORESULT <> 0 THEN EXIT;
  CLRSCR; Seite := 1; Zeile := 0;
  FOR SatzNr := 0 TO MaxDiskNr DO             {Datei ausgeben}
  BEGIN
    READ (DiskDatei, Satz);
    WITH Satz DO
    BEGIN
      IF (SatzNr <> 0) AND (SatzNr MOD 100 = 0) THEN
        BEGIN WRITELN (f); Zeile := Zeile +1 END;
      IF DiskInhalt <> '' THEN
      BEGIN
        LfdNr := SatzNr;
        KatNr := LfdNr DIV 100;
        Kat := CHAR (KatNr +65);
        Nr := LfdNr MOD 100;
        STR (Nr, Disk);
        Nummer := CONCAT (Kat, '/', Disk);
        IF LENGTH (Nummer) <4 THEN INSERT ('0', Nummer, 3);
        WRITE (f, Nummer, '  ');
        DiskInhalt :=
             CONCAT (DiskInhalt, '                                        .');
        WRITE (f, DiskInhalt:40, '   ');
        WRITE (f, DirDateien:3, ' Dtn, ');
        WRITE (f, RestKap:3, ' K frei  ' );
        WRITELN (f, Update:8); Zeile := Zeile +1;
        IF Druck THEN IF Zeile = Druckzeilen THEN BEGIN
          MehrSeiten := TRUE; WRITELN (LST);
          WRITELN (LST, '****************************************',
                        '**************************************');
          DruckerKommando (32); DruckerKommando (31);
          WRITELN (LST, '                                        ',
          '                               Seite ', Seite);
          Seite :=  Seite +1;
          Zeile := 0; DruckerKommando (31); DruckerKommando (86);
          DruckKopfzeileDiskVerz
        END
      END
    END;
  END;
  CLOSE (DiskDatei);
  IF Druck THEN BEGIN
    REPEAT
      WRITELN (LST); Zeile := Zeile +1;
    UNTIL Zeile = Druckzeilen; WRITELN (LST);
    WRITELN (LST, '****************************************',
                  '**************************************');
    IF MehrSeiten THEN BEGIN
      DruckerKommando (32); DruckerKommando (31);
      WRITELN (LST, '                                        ',
      '                               Seite ', Seite) END;
    MehrSeiten := FALSE; DruckerKommando (63); DruckerKommando (86) END;
  IF NOT Druck THEN BEGIN WRITE (f, US); READLN END
END; {DiskVerzAusgeben}

{****************************************************************************}

OVERLAY PROCEDURE LiesSuperDir (MusterIdent: DiskIdent; MusterName: DirName;
                                                           VAR Anzahl: Index);
VAR   f     : FILE OF DirEintrag;             {Es werden nur Eintraege in den}
      i     : 1..11;                          {Speicher geholt, auf die das  }
      temp  : DirEintrag;                     {                  Muster passt}
      passt : BOOLEAN;
  BEGIN
    IF LDrive <> SDLaufwerk THEN Laufwerkwechsel (LDrive, LDriveC);
    ASSIGN (f, 'SUPERDIR.DAT');
    {$I-} RESET (f) {$I+}; Anzahl := 0;
    IF IORESULT = 0 THEN
      WHILE NOT EOF (f) DO
        BEGIN
          READ (f, temp); passt := TRUE;
          WITH temp DO FOR i := 1 TO 11 DO
            IF (ORD(Name[i]) AND 127 <> ORD(MusterName[i]))
                               AND (MusterName[i] <> '?') THEN passt := FALSE;
          IF passt THEN
            BEGIN Directory[Anzahl+1] := temp; Anzahl := SUCC(Anzahl) END
        END;
    CLOSE(f)
  END;

{****************************************************************************}

OVERLAY PROCEDURE SchreibSuperDir (VAR Anzahl: Index);
VAR   f       : FILE OF DirEintrag;
      i       : Index;
  BEGIN {SchreibSuperDir}
    IF LDrive <> SDLaufwerk THEN Laufwerkwechsel (LDrive, LDriveC);
    GOTOXY(37,14); WRITE (DT, 'Jetzt l|sche ich das alte SuperDir ...', US);
    ASSIGN (f, 'SUPERDIR.BAK'); {$I-} RESET (f) {$I+};
    IF IORESULT = 0 THEN BEGIN CLOSE (f); ERASE (f) END;
    ASSIGN (f, 'SUPERDIR.DAT'); {$I-} RESET (f) {$I+};
    IF IORESULT = 0 THEN BEGIN CLOSE (f); RENAME (f, 'SUPERDIR.BAK') END;
    ASSIGN (f, 'SUPERDIR.DAT');
    GOTOXY(37,16); WRITE ('... und jetzt schreibe ich das neue ... !');
    REWRITE (f);
    FOR i := 1 TO Anzahl DO WRITE (f, Directory[i]);
    CLOSE (f);
  END; {SchreibSuperDir}

