{****************************************************************************}
{* SDIR-01.INC                                              Grundprozeduren *}
{****************************************************************************}

OVERLAY PROCEDURE Laufwerkwechsel (VAR LDrive: BYTE; VAR LDriveC: CHAR);
  BEGIN
    LDrive := BDOS (25);  LDriveC := CHR (LDrive+65);
    IF LDriveC = 'A' THEN LDriveC := 'B'
    ELSE                  LDriveC := 'A';
    LDrive := ORD (LDriveC)-65;
    BDOS (14, LDrive);                        {Laufwerk anwaehlen}
    GOTOXY(27,10); WRITE (LDriveC);
  END;

{****************************************************************************}

OVERLAY PROCEDURE MachMuster (VAR MusterName: DirName);
VAR   p : 0..127;
      c : CHAR;
  BEGIN
    p := POS ('.', Befehl);
    IF p = 0 THEN BEGIN Befehl := Befehl + '.'; p := LENGTH (Befehl) END;
    MusterName := COPY (Befehl, 1, p-1);
    IF MusterName[LENGTH(MusterName)] = '*'
      THEN
        BEGIN MusterName := COPY (MusterName,1,LENGTH(MusterName)-1);
        c := '?' END
      ELSE c := ' ';
    WHILE LENGTH(MusterName) <8 DO MusterName := MusterName +c;
    MusterName := MusterName + COPY (Befehl, p+1, LENGTH(Befehl)-p);
    IF MusterName[LENGTH(MusterName)] = '*' THEN
      BEGIN MusterName := COPY(MusterName, 1, LENGTH(MusterName)-1);
      c := '?' END
      ELSE c := ' ';
    WHILE LENGTH(MusterName) <11 DO MusterName := MusterName +c
   END;

{****************************************************************************}

PROCEDURE MenueFensterLoeschen;
  BEGIN
    GOTOXY(37,8); CLREOL;
    GOTOXY(37,10); CLREOL;
    FOR Zeile := 12 TO 18 DO BEGIN GOTOXY(6, Zeile); CLREOL END;
    GOTOXY(6,21); CLREOL
  END;

{****************************************************************************}

OVERLAY PROCEDURE DatumLesen (VAR Datum: DatumTyp);
LABEL  1;
TYPE   TagTyp   = STRING[2];
       MonatTyp = STRING[2];
       JahrTyp  = STRING[2];
       DatumTyp = STRING[8];
VAR    Tag      : TagTyp;
       Monat    : MonatTyp;
       Jahr     : JahrTyp;
       JJ       : INTEGER;
  BEGIN
    IF Datum = '' THEN
      BEGIN                                   {Datum lesen und pruefen}
        GOTOXY(6,21);
        WRITE ('Bitte Datum eingeben (TT.MM.JJ): ');
        1: GOTOXY(39,21); CLREOL; BUFLEN := 8; READ (Datum);
        Tag := COPY (Datum,1,2);
        Monat := COPY (Datum,4,2);
        Jahr := COPY (Datum,7,2);
        IF LENGTH (Datum) < 8 THEN GOTO 1;
        IF (Datum[3] <>'.') OR (Datum[6] <>'.') THEN GOTO 1;
        IF (Tag <'01') OR (Tag >'31') THEN GOTO 1;
        IF Monat <'01' THEN GOTO 1; IF Monat >'12' THEN GOTO 1;
        IF Monat = '04' THEN IF Tag >'30' THEN GOTO 1;
        IF Monat = '06' THEN IF Tag >'30' THEN GOTO 1;
        IF Monat = '09' THEN IF Tag >'30' THEN GOTO 1;
        IF Monat = '11' THEN IF Tag >'30' THEN GOTO 1;
        VAL (Jahr, JJ, Fehler);
        IF Monat = '02' THEN IF (JJ MOD 4 = 0)
                        THEN IF Tag >'29' THEN GOTO 1;
        IF Monat = '02' THEN IF (JJ MOD 4 > 0)
                        THEN IF Tag >'28' THEN GOTO 1;
        IF (Jahr <'00') OR (Jahr >'99') THEN GOTO 1;
        GOTOXY(72,4); WRITE (Datum); GOTOXY(6,21); CLREOL
      END                                     {Datum lesen und pruefen}
  END;

{****************************************************************************}

OVERLAY PROCEDURE QSort (von, bis: Index);    {Modifizierter, nichtrekursiver}
TYPE  LiFo      = ^LiFoListe;                 {Quicksort mit eigenem Stack   }
      LiFoListe = RECORD                      {  und ESort fuer kleine Listen}
                  v, b : Index;
                  last : LiFo
                  END;
VAR   m         : DirEintrag;
      i, j      : Index;
      Stack     : LiFo;

  {**************************************************************************}

  PROCEDURE Push (von, bis: Index);
  VAR   p : LiFo;
    BEGIN
      NEW(p); p^.v := von; p^.b := bis; p^.last := Stack; Stack := p
    END;

  {--------------------------------------------------------------------------}

  PROCEDURE Pop (VAR von, bis: Index);
  VAR   p : LiFo;
    BEGIN
      p := Stack; von := p^.v; bis := p^.b; Stack := p^.last; DISPOSE (p)
    END;


  {--------------------------------------------------------------------------}

  PROCEDURE vertausche (d1, d2: Index);
  VAR   temp : DirEintrag;
    BEGIN
      temp := Directory[d1];
      Directory[d1] := Directory[d2];
      Directory[d2] := temp
    END;

  {--------------------------------------------------------------------------}

  FUNCTION kleiner (x, y: DirEintrag): BOOLEAN;
  VAR   h : BOOLEAN;
    BEGIN
      h := FALSE;
      IF x.Name < y.Name THEN h := TRUE
      ELSE
      IF x.Name = y.Name THEN IF x.DskNr < y.DskNr THEN h := TRUE;
      kleiner := h
    END;

  {--------------------------------------------------------------------------}

  PROCEDURE ESort (von, bis: Index);          {Einfuege-Sort fuer kleine     }
  VAR i, j, m : Index;                        {                        Listen}
    BEGIN
      FOR i:= von TO bis -1 DO
        BEGIN
          m := i;
          FOR j := i +1 TO bis DO
          IF kleiner (Directory[j], Directory[m]) THEN m := j;
          IF m <> i THEN vertausche (i, m)
        END
    END;

  {**************************************************************************}

  BEGIN {QSort}
    Stack := NIL; push (von, bis);
    REPEAT
      POP (von, bis);
      IF bis-von < 7 THEN ESort (von, bis)
    ELSE
    BEGIN
      i := von; j := bis; m := Directory[(i+j) DIV 2];
        REPEAT
          WHILE kleiner (Directory[i], m) DO i := SUCC (i);
          WHILE kleiner (m, Directory[j]) DO j := PRED (j);
          IF i <= j THEN BEGIN
          vertausche (i, j); i := SUCC (i); j := PRED (j) END;
        UNTIL i > j;
        IF i < bis THEN PUSH (i, bis);
        IF j > von THEN PUSH (von, j)
     END
    UNTIL Stack = NIL
  END; {QSort}

