const
  selectpen       =0;
  selecteraser    =1;
  down            =2;
  up              =3;
  clearscreen     =4;
  home            =5;
  clearandhome    =6;
  bigblock        =10;
  litleblock      =11;
  continuous      =0;
  dotted          =1;
  dashed          =2;
  dotteddashed    =3;
  horizontal      =0;
  vertical        =8;
  normal          =0;
  cursiv          =4;

type
  zeile=string[80];

procedure grafmode;
begin
  writeln(#27,#27,'G');
end;

procedure textmode;
begin
  write(' ; A');
end;

procedure waitgdp;
begin
  inline($DB/$70/$E6/$04/$28/$FA);
end;

procedure waitsync;
begin
  inline($DB/$70/$02/$04/$28/$FA);
end;

procedure gdpout(wert:byte);
begin
  waitgdp;
  inline($3A/wert/$D3/$70);
end;

procedure vector(vectortype:byte);
begin
  waitgdp;
  inline($DB/$72/$e6/$0c/$47/$3a/vectortype/$b0/$d3/$72);
end;

procedure textkind(direction,kind:byte);
begin
  waitgdp;
  inline($db/$72/$e6/$03/$47/$3a/direction/$b0/$47/$3a/kind/$b0/$d3/$72);
end;

procedure textsize(xexpand,yexpand:byte);
begin
  waitgdp;
  inline($3a/xexpand/$47);
  inline($3a/yexpand/$cb/$27/$cb/$27/$cb/$27/$cb/$27);
  inline($b0/$d3/$73);
end;

procedure textout(textaus:zeile);
var i:byte;
begin
  for i:=1 to length(textaus) do gdpout(ord(textaus[i]));
end;

procedure sideselect(leseseite,schreibseite:byte);
begin
  inline($3a/leseseite/$47/$cb/$20/$cb/$20/$cb/$20/$cb/$20);
  inline($3a/schreibseite/$cb/$27/$cb/$27/$cb/$27/$cb/$27/$cb/$27/$cb/$27);
  inline($b0/$d3/$60);
end;

procedure moveto(xkoord,ykoord:integer);
begin
  waitgdp;
  inline($21/xkoord/$7e/$d3/$79/$23/$7e/$d3/$78);
  inline($21/ykoord/$7e/$d3/$7b/$23/$7e/$d3/$7a);
end;

procedure drawto(x2,y2:integer);
var x1,y1  :integer;
    xd,yd  :integer;
    befehl :byte;
begin
  waitgdp;
  inline($21/befehl/$36/$11);
  inline($db/$7a/$67/$db/$7b/$6f/$22/y1);
  inline($db/$78/$67/$db/$79/$6f/$22/x1);
  xd:=x2-x1;
  if xd<0 then
     begin
       inline($21/befehl/$cb/$ce);
       xd:=-xd;
     end;
  yd:=y2-y1;
  if yd<0 then
     begin
       inline($21/befehl/$cb/$d6);
       yd:=-yd;
     end;
  if ((xd>255) or (yd>255)) then
     begin
       inline($2a/xd/$cb/$1c/$cb/$1d/$7d/$d3/$75);
       inline($3a/yd/$cb/$3f/$d3/$77);
       waitgdp;
       inline($3a/befehl/$d3/$70);
     end else
     begin
       inline($3a/xd/$d3/$75);
       inline($3a/yd/$d3/$77);
     end;
  waitgdp;
  inline($3a/befehl/$d3/$70);
end;

procedure plot(x,y:integer);
begin
  moveto(x,y);
  drawto(x,y);
end;

procedure rechteck(x1,y1,x2,y2:integer);
begin
  moveto(x1,y1);
  drawto(x2,y1);
  drawto(x2,y2);
  drawto(x1,y2);
  drawto(x1,y1);
end;

procedure rechteckfull(x1,y1,x2,y2:integer);
var a:integer;
begin
  for a:=y1 to y2 do
  begin
    moveto(x1,a);
    drawto(x2,a);
  end;
end;

procedure kreis(x0,y0,r:integer);
var x,rq,y,u1,u2,u3,u4,v1,v2,v3,v4:integer;
begin
  rq:=r*r;
  for y:=0 to trunc(r/1.414) do
  begin
    x:=trunc(sqrt(rq-y*y));
    u1:=trunc(x0-x*1.66);  u2:=trunc(x0+x*1.66);  v1:=y0-y;  v2:=y0+y;
    u3:=trunc(x0-y*1.66);  u4:=trunc(x0+y*1.66);  v3:=y0-x;  v4:=y0+x;
    plot(u1,v1);
    plot(u1,v2);
    plot(u2,v1);
    plot(u2,v2);
    plot(u3,v3);
    plot(u3,v4);
    plot(u4,v3);
    plot(u4,v4);
  end;
end;


