PROGRAM DDIR;            {Disk-Directory, Version NDR 80 (CP/M 2.2), 26.09.87}

{****************************************************************************}
{*                                                                          *}
{*  Dieses Programm liefert eine erweiterte Ausgabe des Disk-Directory und  *}
{*  und sollte deshalb auf jeder Disk vorhanden sein (SYS-Status). Die Da-  *}
{*  teien sind  alphabetisch sortiert,  wahlweise aber auch genau wie nach  *}
{*  Aufruf von "DIR" geordnet erhaeltlich.  Ausserdem werden alle interes-  *}
{*  santen Statusangaben (SYS,  R/O = ":", R/W = "-", Restkapazitaet) aus-  *}
{*  gegeben. USER - Bereiche <> 0 werden der Uebersichtlichkeit halber vom  *}
{*  Verfasser nicht verwendet,  sie sind deshalb in diesem  Programm nicht  *}
{*  beruecksichtigt.  Diskettendaten (Kategorie, Nummer und Inhaltsangabe)  *}
{*  werden automatisch auf der Diskette gespeichert  und bei Bedarf wieder  *}
{*  eingelesen, was besonders bei der Aktualisierung des  "Superdirectory"  *}
{*  in der Version des Verfassers ("SDIR") von Vorteil ist.                 *}
{*  Die Druckausgabe passt nach Ausschneiden genau in die Diskettentasche.  *}
{*  Die Druck- Prozeduren verwenden den EPSON-Code des STAR-Druckers NB24-  *}
{*  10  mit Einzelblatteinzug,  sie muessen bei Verwendung anderer Drucker  *}
{*  eventuell an diese angepasst werden.                                    *}
{*                                                                          *}
{*  (C) 09/87 Gerh. Lachmann, 6300 Giessen, Sommerberg 25 - Tel.0641/45879  *}
{*  unter Verwendung einzelner Routinen aus CHIP-Special/TURBO, Heft 1 + 3  *}
{*                                                                          *}
{****************************************************************************}

TYPE  DirName       = STRING[13];
      Directory     = RECORD
                      Number    : INTEGER;
                      SysNumber : INTEGER;
                      DirNumber : INTEGER;
                      SysEntry  : ARRAY[1..50]  OF DirName;
                      DirEntry  : ARRAY[1..150] OF DirName
                      END;
      DatumTyp      = STRING[8];
      NrTyp         = STRING[2];
      KTyp          = STRING[1];
      DiskIdent     = STRING[4];
      InhaltTyp     = STRING[40];
      DateiNamenTyp = STRING[14];
      DiskDatenTyp  = STRING[43];
CONST DT                     = ^['z1';        {Deutscher Zeichensatz ein     }
      US                     = ^['z0';        {ASCII - Zeichensatz ein       }
      MaxZeile               = 28;            {Voreinstellungen:             }
      Datum      : DatumTyp  = '';            {     kein Datum               }
      NeuDisk    : BOOLEAN   = FALSE;         {     keine DiskDaten vorhanden}
      Druck      : BOOLEAN   = FALSE;         {     keine Druckerausgabe     }
      Sort       : BOOLEAN   = TRUE;          {     sortieren                }
      Ende       : BOOLEAN   = FALSE;         {     weiter im Programm       }
      AltNr      : DiskIdent = '';
      NeuNr      : DiskIdent = '';
VAR   Befehl                 : STRING[3] ABSOLUTE $80;
      Disk                   : Directory;
      Bezugslaufwerk, Lw,
      N, SNr, DNr, DNrExt,
      DatAnz, i, j, x, y,
      Zeilenende, Zeile      : BYTE;
      Laufwerk, Ch, Wahl     : CHAR;
      DiskNr                 : NrTyp;
      DiskKategorie          : KTyp;
      DiskInhalt             : InhaltTyp;
      RestKap                : INTEGER;
      DiskDaten              : DiskDatenTyp;
      DiskDatei              : DateiNamenTyp;
      f                      : FILE OF DiskDatenTyp;

{****************************************************************************}

PROCEDURE DiskDatenMenue;
  BEGIN
    CLRSCR;                                   {NKC/FLOMON -> Rahmen zeichnen:}
    WRITELN (CHR(27),CHR(27),'GZ');           {Grafikmodus, Seiten loeschen}
    WRITELN ('P',1);                          {Schreibseite 0, Leseseite 1}
    WRITELN ('M','5,15');                     {MOVOTO linke untere Rahmenecke}
    WRITELN ('R','492,232');                  {Rahmen zeichnen}
    WRITELN ('P',5);                          {Schreibseite 1, Leseseite 1}
    WRITELN ('M','5,15');                     {MOVETO linke untere Rahmenecke}
    WRITELN ('R','492,232');                  {Rahmen zeichnen}
    WRITELN ('A');                            {in Alphamodus zurueckschalten}
    GOTOXY(6,4);  WRITE ('D I S K - D I R E C T O R Y   ', Laufwerk, ':');
    GOTOXY(72,4); WRITE (Datum);
    GOTOXY(6,6);  WRITE ('-------------------------------------');
                  WRITE ('-------------------------------------');
    GOTOXY(6,8);
    WRITE ('Disk - Ordnungssystem:'); WRITE (DT);
    GOTOXY(38,8);  WRITE ('A  ->  Arbeitsdisketten');
    GOTOXY(38,9);  WRITE ('B  ->  Lauff{hige, endg}ltige Programme');
    GOTOXY(38,10); WRITE ('C  ->  Fremdprogramme, noch nicht angepa~t');
    GOTOXY(38,11); WRITE ('D  ->  Pers|nliche Programme und Daten');
    GOTOXY(6,13);
    WRITE ('Disk - Kategorie (A .. D):      ');
    IF NOT NeuDisk THEN WRITE (DiskKategorie);
    GOTOXY(6,15);
    WRITE ('Disk - Nummer (00 .. 99):       ');
    IF NOT NeuDisk THEN WRITE (DiskNr);
    GOTOXY(6,17);
    WRITE ('Disk - Inhalt:                  ');
    IF NOT NeuDisk THEN WRITE (DiskInhalt);
    WRITE (US);
    GOTOXY(6,19); WRITE ('-------------------------------------');
                  WRITE ('-------------------------------------')
  END; {DiskDatenMenue}

{****************************************************************************}

{$I DDIR-01.INC}  {Prozeduren mit Diskzugriff}
{$I DDIR-02.INC}  {Drucker-Prozeduren}

{****************************************************************************}

PROCEDURE Print (VAR f : TEXT; Dn : DirName); {loescht achte Datenbits     }
VAR i : 1..13;                                {Quelle: CHIP-Special, Heft 1}
  FUNCTION trans (x:CHAR) : CHAR;
  VAR c : BYTE;
    BEGIN
      c := ORD(x) AND 127;
      IF c IN [32..126] THEN trans := chr(c) ELSE trans := '!'
    END;
  BEGIN  {Print}
    FOR i := 1 TO 13 DO WRITE (LST, trans (Dn[i]));
    WRITE (LST,'  ')
  END; {Print}

{****************************************************************************}

PROCEDURE Ausgabe (VAR Datum: DatumTyp; VAR DatAnz: BYTE);
LABEL  1,2,3;
TYPE   TagTyp   = STRING[2];
       MonatTyp = STRING[2];
       JahrTyp  = STRING[2];
       DatumTyp = STRING[8];
VAR    Tag      : TagTyp;
       Monat    : MonatTyp;
       Jahr     : JahrTyp;
       JJ       : INTEGER;
       Fehler   : INTEGER;
       MaxDNr   : BYTE;
  BEGIN {Ausgabe}
    DiskDatenLesen (RestKap, DiskDaten, DiskNr, DiskKategorie, DiskInhalt);
    DirectoryLesen (Disk);
    IF Druck THEN GOTO 2;
    1: CLRSCR;                                {Beginn der Bildschirmausgabe}
      WRITELN ('D I R E C T O R Y  ', Laufwerk, ':');
      WRITELN; WRITELN ('SYS-Dateien:'); SNr := 0;
      FOR N := 1 TO Disk.SysNumber DO         {BS-Ausgabe der Sys-Dateien:}
        BEGIN
          WRITE (Disk.SysEntry[N]:13,'  '); SNr := SNr + 1;
          Zeilenende := SNr MOD 4; IF Zeilenende = 0 THEN WRITELN
        END;
      IF Zeilenende >0 THEN WRITELN; WRITELN;
      WRITELN ('DIR-Dateien:'); DNr := 0;
      FOR N := 1 TO Disk.DirNumber DO         {BS-Ausgabe der Dir-Dateien:}
        BEGIN
          WRITE (Disk.DirEntry[N]:13,'  '); DNr := DNr + 1;
          Zeilenende := DNr MOD 4; IF Zeilenende = 0 THEN WRITELN
        END;
      IF Zeilenende >0 THEN WRITELN; WRITELN;
      DatAnz := DNr; x := 2; y := 2;
      IF DatAnz  DIV 10 >0 THEN x := 1; IF DatAnz  DIV 100 >0 THEN x := 0;
      IF RestKap DIV 10 >0 THEN y := 1; IF RestKap DIV 100 >0 THEN y := 0;
      WRITELN (DT, Laufwerk, ': DISK ', DiskKategorie, '/', DiskNr, ':  ',
               DiskInhalt);
      WRITELN ('----------------------------------------------------------');
      IF Sort THEN
        WRITE ('(S)') ELSE WRITE ('(U)');
        FOR j := 1 TO (18 +x +y) DO WRITE (' ');
        WRITELN (DatAnz, ' DIR-Dateien / ', RestKap, ' K Restkapazit{t', US);
        WRITELN;
      GOTOXY(1,25); CLREOL; WRITE ('Weiter im Programm? (J/N) ', ^G);
      REPEAT
        GOTOXY(27,25); READ (KBD, CH); Ch := UPCASE (Ch);
      UNTIL Ch IN ['J','N'];
      IF Ch = 'N' THEN BEGIN Ende := TRUE; EXIT END;
                                              {Ende der Bildschirmausgabe}
    2: IF Druck THEN
      BEGIN                                   {Beginn der Druckerausgabe}
        DiskDatenMenue;
        IF Datum = '' THEN
          BEGIN                               {Datum lesen und pruefen}
            GOTOXY(6,21);
            WRITE ('Bitte Datum eingeben (TT.MM.JJ): ');
            3: GOTOXY(39,21); CLREOL; BUFLEN := 8; READ (Datum);
               Tag := COPY (Datum,1,2);
               Monat := COPY (Datum,4,2);
               Jahr := COPY (Datum,7,2);
               IF LENGTH (Datum) < 8 THEN GOTO 3;
               IF (Datum[3] <>'.') OR (Datum[6] <>'.') THEN GOTO 3;
               IF (Tag <'01') OR (Tag >'31') THEN GOTO 3;
               IF Monat <'01' THEN GOTO 3; IF Monat >'12' THEN GOTO 3;
               IF Monat = '04' THEN IF Tag >'30' THEN GOTO 3;
               IF Monat = '06' THEN IF Tag >'30' THEN GOTO 3;
               IF Monat = '09' THEN IF Tag >'30' THEN GOTO 3;
               IF Monat = '11' THEN IF Tag >'30' THEN GOTO 3;
               VAL (Jahr, JJ, Fehler);
               IF Monat = '02' THEN IF (JJ MOD 4 = 0)
                               THEN IF Tag >'29' THEN GOTO 3;
               IF Monat = '02' THEN IF (JJ MOD 4 > 0)
                               THEN IF Tag >'28' THEN GOTO 3;
               IF (Jahr <'00') OR (Jahr >'99') THEN GOTO 3;
               GOTOXY(72,4); WRITE (Datum); GOTOXY(6,21); CLREOL
          END;                                {Datum lesen und pruefen}
        IF Sort THEN
          BEGIN GOTOXY(53,21); WRITE ('(S)ortiert drucken? (J/N)') END
        ELSE
          BEGIN GOTOXY(51,21); WRITE ('(U)nsortiert drucken? (J/N)') END;
        REPEAT
          GOTOXY(79,21); READ (KBD, Ch); Ch := UPCASE (Ch);
        UNTIL Ch IN ['J','N'];
        IF Ch = 'N' THEN BEGIN Druck := FALSE; EXIT END;
        Zeile := 0; DruckFormat; Schnittrand; KopfzeilenDruck;
        WRITELN (LST);
        DruckerKommando (26,0); WRITE (LST, 'SYS-Dateien:');
        WRITE (LST, '                                              ');
        WRITELN (LST); DruckerKommando (27,0); WRITELN (LST); SNr := 0;
        FOR N := 1 TO Disk.SysNumber DO       {DR-Ausgabe der Sys-Dateien:}
          BEGIN
            PRINT (LST, Disk.SysEntry[N]); SNr := SNr + 1;
            Zeilenende := SNr MOD 4;
            IF Zeilenende = 0 THEN BEGIN Zeile := Zeile +1; WRITELN(LST) END
          END;
        IF Zeilenende >0 THEN BEGIN Zeile := Zeile +1; WRITELN (LST) END;
        WRITELN (LST); DruckerKommando (26,0); WRITE (LST, 'DIR-Dateien:');
        WRITE (LST, '                                              ');
        WRITELN (LST); DruckerKommando (27,0); WRITELN (LST); DNr := 0;
        MaxDNr := (MaxZeile-Zeile) * 4;
        IF Disk.DirNumber <= MaxDNr THEN
          BEGIN
            FOR N := 1 TO Disk.DirNumber DO   {DR-Ausgabe der Dir-Dateien:}
              BEGIN
                PRINT (LST, Disk.DirEntry[N]);
                DNr := DNr + 1; Zeilenende := DNr MOD 4;
                IF Zeilenende = 0 THEN
                BEGIN Zeile := Zeile +1; WRITELN(LST) END
              END;
            IF Zeilenende >0 THEN BEGIN Zeile := Zeile +1; WRITELN(LST) END
          END;
        IF Disk.DirNumber > MaxDNr THEN
          BEGIN
            FOR N := 1 TO (MaxDNr-4) DO       {bei zuviel Dateien:          }
              BEGIN                           {Begrenzung der Druckerausgabe}
                PRINT (LST, Disk.DirEntry[N]);
                DNr := DNr + 1; Zeilenende := DNr MOD 4;
                IF Zeilenende = 0 THEN
                BEGIN Zeile := Zeile +1; WRITELN(LST) END
              END;
            DNrExt := 0;
            FOR N := (MaxDNr-4+1) TO Disk.DirNumber DO
              BEGIN DNrExt := DNrExt +1; DNr := DNr +1 END;
            WRITE (LST,'                                ... und ', DNrExt:2,
                     ' weitere Dateien')
          END;
        DatAnz := DNr;
        FusszeilenDruck; Schnittrand;
        DruckerKommando (86,0);               {Auswurf der aktuellen Seite}
        WRITE (LST, ^G); Druck := FALSE; GOTO 1
      END                                     {Ende der Druckerausgabe}
  END; {Ausgabe}

{****************************************************************************}

PROCEDURE HauptMenue;
VAR Format : STRING[10];
  BEGIN
    CLRSCR;
    REPEAT                                    {NKC/FLOMON -> Rahmen zeichnen:}
      WRITELN (CHR(27),CHR(27),'GZ');         {Grafikmodus, Seiten loeschen}
      WRITELN ('P',1);                        {Schreibseite 0, Leseseite 1}
      WRITELN ('M','5,15');                   {MOVOTO linke untere Rahmenecke}
      WRITELN ('R','492,232');                {Rahmen zeichnen}
      WRITELN ('P',5);                        {Schreibseite 1, Leseseite 1}
      WRITELN ('M','5,15');                   {MOVETO linke untere Rahmenecke}
      WRITELN ('R','492,232');                {Rahmen zeichnen}
      WRITELN ('A');                          {in Alphamodus zurueckschalten}
      GOTOXY(6,4);   WRITE ('D I S K - D I R E C T O R Y   ', Laufwerk, ':');
      GOTOXY(72,4);  WRITE (Datum);
      GOTOXY(6,6);   WRITE ('-------------------------------------');
                     WRITE ('-------------------------------------');
      GOTOXY(42,8);  WRITE ('L) aufwerk wechseln');
      GOTOXY(42,10); WRITE ('E) ditieren der Disk - Daten');
      IF Sort THEN Format := 'sortiert' ELSE Format := 'unsortiert';
      GOTOXY(42,12); WRITE ('A) usgabeform (', Format, ') wechseln');
      GOTOXY(42,15); WRITE ('B) ildschirm - Ausgabe');
      GOTOXY(42,17); WRITE ('D) ruck - Ausgabe');
      GOTOXY(68,21); WRITE ('Ende = <ESC>');
      GOTOXY(6,19);  WRITE ('-------------------------------------');
                     WRITE ('-------------------------------------');
      GOTOXY(6,21);  WRITE ('Ihre Wahl? ');
      REPEAT
        READ (KBD, Ch); Ch := UPCASE (Ch);
      UNTIL Ch IN ['L','E','A','B','D',#27]; Wahl := UPCASE (Ch);
      CASE Wahl OF
       'L': BEGIN LaufwerkWechsel (Laufwerk, Lw); Ausgabe (Datum, DatAnz) END;
       'E': DiskDatenEditieren (AltNr);
       'A': BEGIN IF Sort = FALSE THEN Sort := TRUE
            ELSE                       Sort := FALSE END;
       'B': Ausgabe (Datum, DatAnz);
       'D': BEGIN Druck := TRUE; Ausgabe (Datum, DatAnz) END
      END; {CASE}
    UNTIL (Wahl = #27) OR Ende; CLRSCR;
    EXIT                                      {-> Hauptprogramm = End = CP/M}
  END; {HauptMenue}

{************************  H a u p t p r o g r a m m  ***********************}

BEGIN
  Lw := BDOS (25)+1;
  WHILE (Befehl <> '') AND (Befehl[1] = ' ') DO BEGIN
    Befehl := COPY (Befehl,2,1);
    IF (Befehl = 'A') OR (Befehl = 'B') THEN Lw := ORD (Befehl)-64 END;
  CASE Lw OF
    1: Laufwerk := 'A';
    2: Laufwerk := 'B'
  END; {CASE}
  Ausgabe (Datum, DatAnz);
  IF NOT Ende THEN HauptMenue ELSE CLRSCR
END.

