{****************************************************************************}
{* DDIR-02.INC                                           Drucker-Prozeduren *}
{****************************************************************************}

PROCEDURE DruckerKommando (BefehlsNummer, n : BYTE);
VAR Cmd : string [24];                        {Codierung der Druckerkommandos}
BEGIN                                         {fuer STAR-Drucker NB24-10 im  }
  Cmd := '';                                  {EPSON-Modus                   }
  CASE BefehlsNummer OF
     1: Cmd := CHR(27)+CHR(120)+CHR(1);       {LQ ein                        }
     3: Cmd := CHR(27)+CHR(82)+CHR(n);        {Nationaler Zeichensatz        }
     9: Cmd := CHR(27)+CHR(77);               {ELITE ein  =  96 Zeichen/Zeile}
    26: Cmd := CHR(27)+CHR(45)+CHR(1);        {Unterstreichung ein           }
    27: Cmd := CHR(27)+CHR(45)+CHR(0);        {Unterstreichung aus           }
    30: Cmd := CHR(27)+CHR(83)+CHR(0);        {Superscript ein               }
    32: Cmd := CHR(27)+CHR(84);               {Superscript aus               }
    33: Cmd := CHR(27)+CHR(104)+CHR(1);       {Doppeltgrossdruck ein         }
    35: Cmd := CHR(27)+CHR(104)+CHR(0);       {Doppeltgrossdruck aus         }
    39: Cmd := CHR(27)+CHR(49);               {Zeilenabstand = 7/60 inch     }
    40: Cmd := CHR(27)+CHR(51)+CHR(n);        {Zeilenabstand = n/180 inch    }
    56: Cmd := CHR(27)+CHR(108)+CHR(n);       {linker Rand = n Zeichen       }
    63: Cmd := CHR(27)+CHR(64);               {Druckerinitialisierung = RESET}
    70: Cmd := CHR(27)+CHR(126)+CHR(1);       {0 mit SCHRaegstrich           }
    77: Cmd := CHR(27)+CHR(85)+CHR(1);        {Unidirektionaler Ausdruck ein }
    86: Cmd := CHR(27)+CHR(25)+CHR(82)        {Auswurf der aktuellen Seite   }
  END; {case}
  WRITE (LST, Cmd)
END; {DruckerKommando}

{****************************************************************************}

PROCEDURE DruckFormat;
BEGIN
  DruckerKommando (63,0);                     {Druckerinitialisierung = RESET}
  DruckerKommando (77,0);                     {Unidirektionaler Ausdruck ein }
  DruckerKommando (3,2);                      {deutscher Zeichensatz ein     }
  DruckerKommando (70,0);                     {0 mit SCHRaegstrich           }
  DruckerKommando (39,0);                     {Zeilenabstand = 7/60 inch     }
  DruckerKommando (1,0);                      {LQ ein                        }
  DruckerKommando (9,0);                      {ELITE ein                     }
  DruckerKommando (30,0);                     {Superscpript ein              }
  DruckerKommando (56,14)                     {linker Rand = 14              }
END; {DruckFormat}

{****************************************************************************}

PROCEDURE Schnittrand;
BEGIN
  DruckerKommando (56,11);                    {linker Rand = 11 Zeichen      }
  WRITE (LST, '+');
  WRITE (LST, '                               ');
  WRITE (LST, '                               ');
  WRITE (LST, '+');
  DruckerKommando (56,14);                    {linker Rand = 14 Zeichen      }
  WRITELN (LST)
END; {Schnittrand}

{****************************************************************************}

PROCEDURE KopfzeilenDruck;
VAR  Inhaltzeile : STRING[44];
BEGIN
  DruckerKommando (33,0);                     {Doppeltgrossdruck ein         }
  DruckerKommando (40,25);                    {Zeilenabstand = 25/180 inch   }
  WRITELN (LST, 'DIRECTORY          DISK: ', DiskKategorie, '/', DiskNr:2);
  DruckerKommando (35,0);                     {Doppeltgrossdruck aus         }
  DruckerKommando (40,20);                    {Zeilenabstand = 20/180 inch   }
  DruckerKommando (32,0);                     {Superscript aus               }
  DiskInhalt :=
             CONCAT (DiskInhalt, '                                        .');
  IF Sort THEN Inhaltzeile := CONCAT (DiskInhalt, ' (S)')
  ELSE         Inhaltzeile := CONCAT (DiskInhalt, ' (U)');
  WRITELN (LST, 'DISK-INHALT:  ', Inhaltzeile:44);
  DruckerKommando (30,0);                     {Superscript ein               }
  DruckerKommando (26,0);                     {Unterstreichung ein           }
  DruckerKommando (40,4);                     {Zeilenabstand = 4/180 inch    }
  WRITELN (LST,'                                                          ');
  DruckerKommando (39,0);                     {Zeilenabstand = 7/60 inch     }
  WRITELN (LST,'                                                          ');
  DruckerKommando (27,0)                      {Unterstreichung aus           }
END; {KopfzeilenDruck}

{****************************************************************************}

PROCEDURE FusszeilenDruck;
VAR   Leerzeilen : BYTE;
BEGIN
  Leerzeilen := MaxZeile - Zeile;
  For i := 1 TO Leerzeilen DO WRITELN (LST);
  DruckerKommando (26,0);                     {Unterstreichung ein           }
  DruckerKommando (40,4);                     {Zeilenabstand = 4/180 inch    }
  WRITELN (LST,'                                                          ');
  DruckerKommando (39,0);                     {Zeilenabstand = 7/60 inch     }
  WRITELN (LST,'                                                          ');
  DruckerKommando (27,0);                     {Unterstreichung aus           }
  WRITELN (LST);
  WRITE (LST, DatAnz, ' DIR-Dateien / ', RestKap, ' K Restkapazit{t');
  x := 2; IF DatAnz  DIV 10 >0 THEN x := 1; IF DatAnz  DIV 100 >0 THEN x := 0;
  y := 2; IF RestKap DIV 10 >0 THEN y := 1; IF RestKap DIV 100 >0 THEN y := 0;
  FOR j := 1 TO (6 +x +y) DO WRITE (LST, ' '); WRITE (LST, 'Stand: ', Datum);
  WRITELN (LST); WRITELN (LST)
END; {FusszeilenDruck}

{****************************************************************************}

