PROGRAM SDIR;           {Super-Directory, Version NDR 80 (CP/M 2.2), 27.10.87}

{****************************************************************************}
{*                                                                          *}
{*  Dieses Programm ist eine speziell an den NDR-Klein-Computer angepasste  *}
{*  Version des SD-Programms aus CHIP-Special/ TURBO, Heft 1.  Es kommuni-  *}
{*  ziert mit dem Programm "DDIR" des Verfassers, das eine erweiterte Aus-  *}
{*  gabe des  Disk-Directory liefert.  Wie dieses beruecksichtigt es keine  *}
{*  USER-Bereiche <> 0 und speichert ausserdem auch keine SYS-Dateien, die  *}
{*  naturgemaess  vielfach vorkommen und somit nur unnoetig  Speicherplatz  *}
{*  verbrauchen wuerden. Bei der vorliegenden Programmversion sind Masken-  *}
{*  eingabe  und Maskenwechsel auch aus dem Programm heraus moeglich,  und  *}
{*  ein automatisch  angelegtes  Diskettenverzeichnis gibt  Auskunft ueber  *}
{*  den jeweiligen Inhalt der einzelnen  Disketten (max. 40 Zeichen), ihre  *}
{*  letzte  Erfassung sowie die dabei ermittelte Belegung (Dir-Dateien und  *}
{*  Restkapazitaet).                                                        *}
{*  Die Druck- Prozeduren verwenden den EPSON-Code des STAR-Druckers NB24-  *}
{*  10  mit Einzelblatteinzug,  sie muessen bei Verwendung anderer Drucker  *}
{*  eventuell an diese angepasst werden.                                    *}
{*                                                                          *}
{*  (C) 10/87 Gerh. Lachmann, 6300 Giessen, Sommerberg 25 - Tel.0641/45879  *}
{*  unter Verwendung des Programms "Super-Directory" / Vers.1.5 von U.Kern  *}
{*                                                                          *}
{****************************************************************************}

LABEL 1, 2;
CONST MaxZahl         = 2000;                 {SuperDirectory - Eintraege    }
      MaxDiskNr       =  399;                 {Disketten: je 100 pro A,B,C,D }
      Druckzeilen     =   75;                 {Diskverzeichnis               }
      DT              = ^['z1';               {Deutscher Zeichensatz ein     }
      US              = ^['z0';               {ASCII - Zeichensatz ein       }
TYPE  DiskIdent       = STRING[4];
      DirName         = STRING[11];
      DirEintrag      = RECORD
                        Name : DirName;
                        DskNr: DiskIdent;
                        END;
      Index           = 1..MaxZahl;
      MaskenTyp       = STRING[12];
      DatumTyp        = STRING[8];
      DiskDatenTyp    = STRING[43];
      NrTyp           = STRING[2];
      KTyp            = CHAR;
      InhaltTyp       = STRING[40];
      DiskBeschr      = RECORD
                          LfdNr      : INTEGER;
                          DiskInhalt : InhaltTyp;
                          DirDateien : BYTE;
                          RestKap    : INTEGER;
                          Update     : DatumTyp;
                        END;
CONST Datum           : DatumTyp = '';        {Voreinstellungen:  kein Datum }
      Druck           : BOOLEAN = FALSE;      {                   kein Druck }
      MaskenEingabe   : BOOLEAN = FALSE;      {                   keine Maske}
      DiskGelesen     : BOOLEAN = FALSE;      {        keine Diskette gelesen}
      EingabeAnfang   : BOOLEAN = TRUE;       {       erst SDIR-Disk erfassen}
VAR   DiskNr, Disk    : NrTyp;
      Nummer          : DiskIdent;
      DiskKategorie,
      Kat             : KTyp;
      DiskInhalt      : InhaltTyp;
      DiskDatei       : FILE OF DiskBeschr;
      Satz            : DiskBeschr;
      SatzNr, Fehler,
      KatNr, Nr,
      RestKapazitaet,
      RestKap         : INTEGER;
      f               : TEXT;
      Update          : DatumTyp;
      DirZahl         : Index;
      TempZahl        : BYTE;
      Directory       : ARRAY[Index] OF DirEintrag;
      Wahl, Ch        : CHAR;
      Maske, AltMaske : MaskenTyp;
      MusterName      : DirName;
      MusterIdent     : DiskIdent;
      SDLaufwerk,
      LDrive          : BYTE;
      LDriveC         : CHAR;
      Zaehler         : BYTE;
      Zeile, Seite, i : BYTE;
      DateienAnzahl   : STRING[4];
      Befehl          : STRING[127] ABSOLUTE $80;
      DiskDaten       : DiskDatenTyp;
      Geraet          : STRING[10];

{****************************************************************************}

{$I SDIR-01.INC}  {Grundprozeduren}
{$I SDIR-02.INC}  {Ausgabeprozeduren}
{$I SDIR-03.INC}  {Disk-Verzeichnis und Super-Directory}
{$I SDIR-04.INC}  {Disketteneingabe}

{******************************  Hauptprogramm  *****************************}

BEGIN {Hauptprogramm}
  SDLaufwerk := MEM[4] AND 15;                {Superdir-Laufwerk ermitteln}
  LDrive := SDLaufwerk; LDriveC := CHR (SDLaufwerk +65);
  WHILE (Befehl <>'') AND (Befehl[1] =' ') DO
                                 Befehl := COPY (Befehl, 2, LENGTH(Befehl)-1);
  IF Befehl <> '' THEN
    BEGIN
      Maske := Befehl;
      MachMuster (MusterName);
      LiesSuperDir ('', MusterName, DirZahl);
      MaskenEingabe := TRUE;
      GOTO 1
    END;
  IF Befehl = '' THEN
    BEGIN
      Maske := '*.*';
      LiesSuperDir ('', '???????????', DirZahl);
      CLRSCR;
    1:REPEAT                                  {NKC/FLOMON -> Rahmen zeichnen:}
        WRITELN (CHR(27),CHR(27),'GZ');       {Grafikmodus, Seiten loeschen}
        WRITELN ('P',1);                      {Schreibseite 0, Leseseite 1}
        WRITELN ('M','5,15');                 {MOVOTO linke untere Rahmenecke}
        WRITELN ('R','492,232');              {Rahmen zeichnen}
        WRITELN ('P',5);                      {Schreibseite 1, Leseseite 1}
        WRITELN ('M','5,15');                 {MOVETO linke untere Rahmenecke}
        WRITELN ('R','492,232');              {Rahmen zeichnen}
        WRITELN ('A');                        {in Alphamodus zurueckschalten}
        GOTOXY(6,4);   WRITE ('S U P E R D I R E C T O R Y');
        GOTOXY(37,4);  WRITE ('Maske ', Maske, '  ');
        GOTOXY(47+LENGTH(Maske),4);
        FOR i := 1 TO (25 - LENGTH(Maske)) DO WRITE (' ');
        GOTOXY(47+LENGTH(Maske),4); WRITE (DirZahl, ' Dateien');
        GOTOXY(72,4);  WRITE (Datum);
        GOTOXY(6,6);   WRITE ('-------------------------------------');
                       WRITE ('-------------------------------------');
        GOTOXY(6,8);   WRITE ('SuperDir- Laufwerk : ', CHR(SDLaufwerk+65));
        GOTOXY(6,10);  WRITE ('Aktuelles Laufwerk : ', LDriveC);
        GOTOXY(37,8);  WRITE ('D) isketten eingeben');
        GOTOXY(37,10); WRITE (DT,'M) aske f}r Ausgabe (', Maske,') wechseln');
        IF Druck THEN Geraet := 'Drucker' ELSE Geraet := 'Bildschirm';
        GOTOXY(37,12); WRITE ('A) usgabeger{t (', Geraet, ') wechseln',US);
        GOTOXY(37,15); WRITE ('V) erzeichnis der Disketten ausgeben');
        GOTOXY(37,17); WRITE ('S) uperdirectory ausgeben');
        GOTOXY(6,19);  WRITE ('-------------------------------------');
                       WRITE ('-------------------------------------');
        GOTOXY(68,21); WRITE ('Ende = <ESC>');
      2:GOTOXY(6,21);  WRITE ('Ihre Wahl? ');
        REPEAT
          READ (KBD, Ch); Wahl := UPCASE (Ch);
        UNTIL Wahl IN ['D','M','A','V','S',#27];
        CASE Wahl OF
        'D': BEGIN
               DiskGelesen := FALSE; DatumLesen (Datum);
               MenueFensterLoeschen;
               IF Maske <> '*.*' THEN BEGIN
                 Maske := '*.*';
                 IF LDrive <> SDLaufwerk THEN
                                            Laufwerkwechsel (LDrive, LDriveC);
                 LiesSuperDir ('', '???????????', DirZahl);
                 GOTOXY(43,4); WRITE ('                            ');
                 GOTOXY(43,4); WRITE (Maske);
                 GOTOXY(47+LENGTH(Maske),4); WRITE (DirZahl, ' Dateien') END;
               DirEingabe
             END;
        'M': BEGIN
               AltMaske := Maske;
               GOTOXY(43,4); WRITE ('                            ');
               GOTOXY(43,4); BUFLEN := 12; READ (Maske);
               FOR i := 1 TO LENGTH (Maske) DO Maske[i] := UPCASE (Maske[i]);
               IF Maske = AltMaske THEN GOTO 1;
               IF Maske = '' THEN Maske := '*.*';
               GOTOXY(43,4); WRITE (Maske, '                ');
               GOTOXY(58,10); WRITE (Maske, ') wechseln');
               Befehl := Maske;
               IF Maske <> '*.*' THEN BEGIN
                 MachMuster (MusterName);
                 LiesSuperDir ('', MusterName, DirZahl);
                 MaskenEingabe := TRUE END
               ELSE LiesSuperDir ('', '???????????', DirZahl);
               GOTOXY(47+LENGTH(Maske),4); WRITE (DirZahl, ' Dateien');
               DiskGelesen := FALSE;
             END;
        'A': BEGIN
               IF Druck = FALSE THEN Druck := TRUE
               ELSE                  Druck := FALSE
             END;
        'V': BEGIN
               IF LDrive <> SDLaufwerk THEN Laufwerkwechsel (LDrive, LDriveC);
               IF Maske <> '*.*' THEN BEGIN
                 Maske := '*.*';
                 LiesSuperDir ('', '???????????', DirZahl);
                 GOTOXY(43,4); WRITE ('                            ');
                 GOTOXY(43,4); WRITE (Maske);
                 GOTOXY(47+LENGTH(Maske),4); WRITE (DirZahl, ' Dateien') END;
               DiskVerzAusgeben (Seite)
             END;
        'S': BEGIN
               IF LDrive <> SDLaufwerk THEN Laufwerkwechsel (LDrive, LDriveC);
               IF DiskGelesen THEN BEGIN
                 LiesSuperDir ('', '???????????', DirZahl);
                 GOTOXY(47+LENGTH(Maske),4); WRITE (DirZahl, ' Dateien');
                 DiskGelesen := FALSE END;
               Ausgabe (DirZahl, Maske)
             END;
        END; {CASE}
      UNTIL Wahl = #27; CLRSCR
    END {IF Befehl = ''}
END. {Hauptprogramm}

