{****************************************************************************}
{* SDIR-04.INC                                             Disketteneingabe *}
{****************************************************************************}

OVERLAY PROCEDURE DirEingabe;
LABEL 1, 2, 3;
VAR   Laufw         : CHAR;

{****************************************************************************}

PROCEDURE LiesDisketten (VAR EintragZahl: Index; VAR TempZahl: BYTE;
     VAR Zaehler: BYTE; VAR DiskGelesen: BOOLEAN; VAR DiskDaten: DiskDatenTyp;
                                                 VAR RestKapazitaet: INTEGER);
VAR   Offset, i, j, CtrZn,
      SysNumber, DirNumber  : BYTE;
      Nummer                : DiskIdent;
      FCB                   : ARRAY[0..12] OF CHAR ABSOLUTE $005C;
      Buffer                : STRING[128];
      Sys                   : CHAR;
      Temp, TempName,
      SortName              : DirName;
      DDDatei               : FILE OF DiskDatenTyp;

  {--------------------------------------------------------------------------}

  FUNCTION Space (LDrive: BYTE) : INTEGER;    {unter CP/M 2.2          }
  TYPE  Diskettenbeschreiber = RECORD         {aus CHIP-Special, Heft 3}
                                 Anzahl_der_logischen_Sektoren      : INTEGER;
                                 Blockverschiebungsfaktor           : BYTE;
                                 Blockmaske                         : BYTE;
                                 Eintragsmaske                      : BYTE;
                                 Anzahl_der_Bloecke                 : INTEGER;
                                 Anzahl_der_Verzeichniseintraege    : INTEGER;
                                 Verzeichnis_Vektor                 : INTEGER;
                                 Anzahl_der_zu_pruefenden_Eintraege : INTEGER;
                                 Anzahl_der_Systemspuren            : INTEGER
                               END;
        Belegungsverzeichnis = ARRAY[0..127] OF BYTE;
  VAR   p              : ^Diskettenbeschreiber;
        q              : ^Belegungsverzeichnis;
        i              : INTEGER;
        frei           : INTEGER;
        Bezugslaufwerk : BYTE;
  BEGIN {Space}
    Bezugslaufwerk := BDOS (25); BDOS (14, LDrive);
    GOTOXY(27,10); WRITE (CHR(LDrive+65));
    p := PTR (BDOSHL(31));
    q := PTR (BDOSHL(27));
    WITH p^ DO
      BEGIN
        frei := 0;
        FOR i := 0 TO Anzahl_der_Bloecke DO
        IF q^ [i SHR 3] AND (128 SHR (i AND 7)) = 0 THEN frei := SUCC (frei);
        Space := (SUCC (Blockmaske) SHR 3) * frei
      END;
    BDOS (14, Bezugslaufwerk); GOTOXY(27,10); WRITE (CHR(LDrive+65));
  END; {Space}

  {--------------------------------------------------------------------------}

  PROCEDURE Kill (DI : DiskIdent; VAR EintragZahl : Index);
  VAR   i : Index;                            {Sorgt fuer ein automatisches  }
    BEGIN                                     {Update, indem vor der Neuein- }
      i := 1;                                 {gabe einer Diskette eventuell }
      WHILE i <= EintragZahl DO               {vorhandene Eintraege fuer     }
        IF Directory[i].DskNr = DI THEN       {       diese geloescht werden.}
          BEGIN
            Directory[i] := Directory[EintragZahl];
            EintragZahl := PRED (EintragZahl)
          END
        ELSE i := SUCC (i)
    END; {Kill}

  {--------------------------------------------------------------------------}

  BEGIN {LiesDisketten}
    BDOS (13); BDOS (14, LDrive);
    ASSIGN (DDDatei, 'DDIR.DAT'); {$I-} RESET (DDDatei); {$I+}
    IF IORESULT <> 0 THEN BEGIN
      CLOSE (DDDatei);
      GOTOXY(6,21); CLREOL;
      WRITE ('Diskette ist noch nicht numeriert! -> Programm DDIR!');
      DiskGelesen := TRUE;
      GOTOXY(74,21); WRITE ('<CR> ');
      READLN; EXIT END;
    WHILE NOT (EOF(DDDatei)) DO READ (DDDatei, DiskDaten);
    CLOSE (DDDatei);
    Nummer := CONCAT (COPY (DiskDaten,1,1), '/', COPY (DiskDaten,2,2));
    DiskInhalt := COPY (DiskDaten, 4, LENGTH(DiskDaten)-3);
    GOTOXY(6,13); WRITE ('Ich lese DISK ', Nummer, ' :');
    GOTOXY(37,13); WRITE (DT, DiskInhalt, US); DELAY (2000);
    DiskGelesen := TRUE;
    Kill(Nummer, EintragZahl);
    TempZahl := EintragZahl;
    Zaehler := 0;
    FCB := #0'???????????'#0;
    IF LDriveC = 'A' THEN FCB[0] := #1 ELSE FCB[0] := #2;
    BDOS (26, ADDR (Buffer) + 1);             {Datenpuffer festlegen}
    Offset := BDOS (17, ADDR (FCB));          {ersten Eintrag suchen}
    MEM[ADDR (Buffer)] := 128;                {Stringlaenge festlegen}
    WHILE Offset < 255 DO
      BEGIN
        Sys := COPY (Buffer, 11 + 32*Offset, 1);
        IF NOT (ORD(Sys) > 128) THEN          {DIR-Dateien von Disk holen}
          BEGIN
            TempName := COPY (Buffer, 2 + 32*Offset, 11);
            FOR i := 1 to 11 DO BEGIN
              IF (ORD(TempName[i]) <32) OR (ORD(TempName[i]) =127)
                                                      THEN TempName[i] := '!';
              CtrZn := POS ('!', TempName) END;
            IF CtrZn = 0 THEN BEGIN
              EintragZahl := SUCC (EintragZahl);
              IF EintragZahl > MaxZahl THEN EintragZahl := MaxZahl;
              WITH Directory[EintragZahl] DO BEGIN
              Name := TempName; DskNr := Nummer END
            END
          END; {Dir-Dateien holen}
          Offset := BDOS (18)                 {folgenden Eintrag suchen}
      END; {WHILE}
    Zaehler := EintragZahl - TempZahl;
    GOTOXY(37,15); WRITE ('DIR-Dateien: ', Zaehler);
    GOTOXY(47+LENGTH(Maske),4); WRITE (EintragZahl, ' Dateien ');
    RestKapazitaet := Space (LDrive);
    GOTOXY(37,17); WRITE (DT, 'Restkapazit{t = ', US, RestKapazitaet, ' K');
    DiskVerzFortschreiben;
    DELAY (2000);
  END; {LiesDisketten}

  {**************************************************************************}

  BEGIN {DirEingabe}
    IF EingabeAnfang THEN GOTO 2;             {SDIR-Disk automatisch erfassen}
  1:EingabeAnfang := FALSE;
    IF LDriveC = 'A' THEN Laufw := 'B' ELSE Laufw := 'A';
    GOTOXY(37,10); CLREOL;
    WRITE ('Diskette in Laufwerk ', Laufw, ' ?  ');
    REPEAT READ (KBD, Ch); Ch := UPCASE (Ch); UNTIL Ch IN ['J','N',#13];
    IF Ch = 'N' THEN GOTO 3
      ELSE BEGIN
      IF LDrive = SDLaufwerk THEN Laufwerkwechsel (LDrive, LDriveC);
      GOTO 2 END;
    REPEAT
      IF LDrive = SDLaufwerk THEN Laufwerkwechsel (LDrive, LDriveC);
      MenueFensterLoeschen;
      IF NOT DiskGelesen THEN BEGIN
        GOTOXY(47+LENGTH(Maske),4); WRITE (DirZahl, ' Dateien'); GOTO 2 END;
      GOTOXY(37,8); WRITE ('Weitere Diskette eingeben? (J/N)  '); CLREOL;
      REPEAT READ (KBD, Ch); Ch := UPCASE (Ch); UNTIL Ch IN ['J','N'];
      WRITE (Ch, '  '); IF Ch = 'N' THEN GOTO 3;
      GOTOXY(37,10); CLREOL;
      WRITE ('Diskette in Laufwerk ', CHR (LDrive+65), ' ?  ');
      REPEAT READ (KBD, Ch); Ch := UPCASE (Ch); UNTIL Ch IN ['J','N',#13];
      IF Ch = 'N' THEN GOTO 3;
    2:LiesDisketten (DirZahl, TempZahl, Zaehler,
                                      DiskGelesen, DiskDaten, RestKapazitaet);
      IF DirZahl = MaxZahl THEN BEGIN
        GOTOXY(6,21);
        WRITE (DT, 'Superdirectory voll! (', MaxZahl, ' Eintr{ge)', US);
        GOTOXY(74,21); WRITE ('<CR> '); READLN; GOTO 3; END;
        IF EingabeAnfang THEN BEGIN MenueFensterLoeschen; GOTO 1 END;
    UNTIL Ch = 'N';
  3:IF NOT DiskGelesen THEN EXIT;
    IF LDrive <> SDLaufwerk THEN Laufwerkwechsel (LDrive, LDriveC);
    MenueFensterLoeschen;
    GOTOXY(37,12); WRITE ('Ich sortiere jetzt. Bitte warten!');
    QSort (1,DirZahl);
    SchreibSuperDir (DirZahl);
  END; {DirEingabe}

{****************************************************************************}

