{****************************************************************************}
{* SDIR-02.INC                                            Ausgabeprozeduren *}
{****************************************************************************}

OVERLAY PROCEDURE DruckerKommando (BefehlsNummer:BYTE);
VAR Cmd: STRING[24];                          {Codierung der Druckerkommandos}
  BEGIN
    Cmd:='';
    CASE BefehlsNummer OF
       1: Cmd:=CHR(27)+CHR(120)+CHR(1);       {LQ ein                        }
       2: Cmd:=CHR(27)+CHR(120)+CHR(0);       {LQ aus                        }
       3: Cmd:=CHR(27)+CHR(82)+CHR(2);        {Nationaler Zeichensatz DT     }
       9: Cmd:=CHR(27)+CHR(77);               {ELITE ein   = 96 Zeichen/Zeile}
      17: Cmd:=CHR(14);                       {Breitdruck fuer Zeilenrest ein}
      18: Cmd:=CHR(20);                       {Breitdruck fuer Zeilenrest aus}
      30: Cmd:=CHR(27)+CHR(83)+CHR(0);        {Superscript ein               }
      31: Cmd:=CHR(27)+CHR(83)+CHR(1);        {Subscript ein                 }
      32: Cmd:=CHR(27)+CHR(84);               {Super-/Subscript aus          }
      39: Cmd:=CHR(27)+CHR(49);               {Zeilenabstand = 7/60 inch     }
      56: Cmd:=CHR(27)+CHR(108)+CHR(10);      {linker Rand = 10 Zeichen      }
      63: Cmd:=CHR(27)+CHR(64);               {Druckerinitialisierung = RESET}
      70: Cmd:=CHR(27)+CHR(126)+CHR(1);       {0 mit SCHRaegstrich           }
      77: Cmd:=CHR(27)+CHR(85)+CHR(1);        {Unidirektionaler Ausdruck ein }
      86: Cmd:=CHR(27)+CHR(25)+CHR(82);       {Auswurf der aktuellen Seite   }
    END; {case}
    WRITE (LST, Cmd);
  END; {DruckerKommando}

{****************************************************************************}

PROCEDURE DruckFormat;
  BEGIN
    DruckerKommando (63);                     {Druckerinitialisierung = RESET}
    DruckerKommando (39);                     {Zeilenabstand = 7/60 inch     }
    DruckerKommando (77);                     {Unidirektionaler Ausdruck ein }
    DruckerKommando (3);                      {DT - Zeichensatz ein          }
    DruckerKommando (70);                     {0 mit Schraegstrich           }
    DruckerKommando (9);                      {ELITE ein                     }
    DruckerKommando (56);                     {linker Rand = 10              }
  END;

{****************************************************************************}

PROCEDURE DruckKopfzeileDiskVerz;
VAR   Inhalt : STRING[26];
  BEGIN
    DruckerKommando (32); DruckerKommando (1);
    DruckerKommando (17); WRITE (LST, 'Diskettenverzeichnis ');
    DruckerKommando (18); DruckerKommando (2);
    STR (DirZahl, DateienAnzahl);
    Inhalt := CONCAT (DateienAnzahl, ' DIR-Dateien             .');
    DruckerKommando (30);
    WRITELN (LST, Inhalt:26, '  ', Datum); WRITELN (LST);
    WRITELN (LST, '****************************************',
                  '**************************************'); WRITELN (LST)
  END;

{****************************************************************************}

OVERLAY PROCEDURE Ausgabe (EintragZahl: Index; Maske: MaskenTyp);
VAR   f                           : TEXT;
      i                           : Index;
      PL, MB, MT, Zeile, Spalte,
      Seite, SeitenMaximum,
      ZeilenZahl, SpaltenZahl,
      SeitenZahl                  : INTEGER;

  {**************************************************************************}

  OVERLAY PROCEDURE DruckKopfzeileSDir;
  VAR Inhalt        : STRING[38];
    BEGIN
      DruckerKommando(32); DruckerKommando (1);
      DruckerKommando(17); WRITE (LST, 'Superdirectory ');
      DruckerKommando(18); DruckerKommando (2);
      STR (DirZahl, Dateienanzahl);
      Inhalt := CONCAT ('Maske: ', Maske, ' / ', Dateienanzahl,
                                                 ' DIR-Dateien            .');
      DruckerKommando(30);
      WRITELN (LST, Inhalt:38, '  ', Datum); WRITELN (LST);
      WRITELN (LST, '****************************************',
                    '**************************************'); WRITELN (LST)
    END;

  {--------------------------------------------------------------------------}

  OVERLAY PROCEDURE PRINT (VAR f: TEXT; DN: DirName);
  VAR   i : 1..11;
    FUNCTION trans (x: CHAR) :CHAR;
    VAR c : BYTE;
      BEGIN
        c := ORD (x) AND 127;                 {Bitmaske loescht achte Bits}
        IF c IN [32..126] THEN trans := CHR (c) ELSE trans := '!'
      END;
    BEGIN {PRINT}
      FOR i := 1 to 8 DO WRITE (f, trans (DN[i]));
      WRITE (f, '.');
      FOR i := 9 to 11 DO WRITE (f, trans (DN[i]))
    END; {PRINT}

  {**************************************************************************}

  BEGIN {Ausgabe}
    IF NOT Druck THEN
      BEGIN ASSIGN (f, 'CON:'); PL:=24; MT:=0; MB:=1 END;
    IF Druck THEN
      BEGIN
        DatumLesen (Datum);
        GOTOXY(6,21); CLREOL; WRITE ('Ist der Drucker eingeschaltet? (J/N) ');
        REPEAT
          READ (KBD, Ch); Ch := UPCASE (Ch);
        UNTIL Ch IN ['J','N']; IF Ch = 'N' THEN EXIT;
        GOTOXY(6,21); CLREOL;
        WRITE ('Superdirectory mit Maske "', Maske, '" drucken? (J/N) ');
        REPEAT
          READ (KBD, Ch); Ch := UPCASE (Ch);
        UNTIL Ch IN ['J','N']; IF Ch = 'N' THEN EXIT;
        ASSIGN (f, 'LST:'); PL:=77; MT:=0; MB:=2; DruckFormat
      END;
    REWRITE (f);
    SeitenMaximum := (PL-MT-MB)*4;
    ZeilenZahl := PL-MB-MT;
    SpaltenZahl := (EintragZahl-1) DIV ZeilenZahl;
    IF SpaltenZahl >3 THEN SpaltenZahl := 3;
    SeitenZahl := (EintragZahl-1) DIV ((SpaltenZahl+1)*ZeilenZahl);
    FOR Seite := 0 TO SeitenZahl DO
      BEGIN {Bildschirm- bzw. Druckerausgabe}
        IF NOT Druck THEN CLRSCR                 {Bildschirmausgabe}
        ELSE DruckKopfzeileSDir;                 {Druckerausgabe}
        FOR Zeile := 1 TO PL-MT-MB DO
          BEGIN
            FOR Spalte := 0 TO SpaltenZahl DO
              BEGIN
                i := Seite*(PL-MB-MT)*(SpaltenZahl+1)+Spalte*(PL-MB-MT)+Zeile;
                IF i <= EintragZahl THEN WITH Directory[i] DO
                  BEGIN
                    WRITE (f, DskNr:4, ' ');
                    print (f, Name);
                    IF ORD (Name[9]) >128 THEN WRITE (f,':')
                                          ELSE WRITE (f,'-');
                    IF i <= (((Seite+1)*SeitenMaximum)-ZeilenZahl)
                                        THEN WRITE (f,'  ') ELSE WRITE (f,'')
                  END
              END;
            WRITELN (f)
          END;
        FOR Zeile := 1 TO MB -1 DO WRITELN (f);
        IF Druck THEN BEGIN
          WRITELN (LST, '****************************************',
                        '**************************************');
          IF EintragZahl > SeitenMaximum THEN BEGIN
            DruckerKommando (32); DruckerKommando (31);
            WRITELN (LST, '                                        ',
            '                               Seite ', Seite+1) END;
          DruckerKommando (32); DruckerKommando (30);
          DruckerKommando (86) END;           {Seitenende Druckerausgabe}
        IF NOT Druck THEN READLN              {Seitenende Bildschirmausgabe}
      END {Bildschirm- bzw. Druckerausgabe}
  END; {Ausgabe}

