

(*
Puzzlespiel
Christoph K|hler
28.08.86

1. Zeichnen des Puzzle
2. Einschalten der Maus
3. Zufallsgenerator f}r Lage der Ziffern
4. Fuellen des Puzzles mit den Zufallszahlen
5. Bei betaetigter rechter Taste Feld identifizieren
6. Austauschen des Jokerfeldes mit dem angewaehltem Feld
*)


Program Puzzle;

(*$I Grafikmc *)

VAR     feld,zahl,x,y,xx,yy      :   integer;
        xzahl,yzahl              :   integer;
        Reihe,Spalte             :   integer;
        Joker,Hilfsjoker         :   integer;
        neu_Zahlen,index         :   integer;
        Schritte                 :   integer;
        xRecht,yRecht            :   integer;
        xPos,yPos                :   integer;
        rechts,links             :   Byte;
        Taste,Strobe             :   Byte;
        Wort                     :   String[3];

        koordi        :     array[1..16] of integer;
        inhalt        :     array[1..16] of integer;


PROCEDURE Pfeil;
BEGIN
  grafmode;
  xx:=x;
  yy:=y;
  (*$I MAUS.INC  *);
  IF (x<>xx) OR (y<>yy) THEN BEGIN
     WRITELN('WA','0Z1^HLS');
     WRITELN('WC',' 2',' 5');
     x:=xx+((x-xx)*4);
     IF x < 3 THEN x:=3;
     IF x > 504 THEN x:= 504;
     IF y < 9 THEN y:=9;
     IF y > 254 THEN y:=254;
     y:=yy+((y-yy)*2);
     WRITELN('F',x,' ',y,' 0');
  END;
END;


PROCEDURE Rahmen;
VAR rx,ry  :  integer;

BEGIN
   rx:=175;
   ry:=140;
   moveto(40,200);
   textsize(3,6);
   textout('Puzzle-Spiel');
   moveto(125,20);
   textsize(1,2);
   textout('(C) Christoph Koehler');
   Rechteck(0,0,511,255);
   Rechteck(416,103,436,113);
   moveto(410,85);
   textout('neu');

   REPEAT
      REPEAT
         Rechteck(rx,ry,rx+40,ry+20);
         rx:=rx+40;
      UNTIL rx = 335;
      rx:=175;
      ry:=ry-20;
   UNTIL ry =  60;

   (* Feld von Joker ermitteln *)
   FOR Feld:= 1 TO 16 DO
      IF Inhalt[Feld] = 16 THEN
      BEGIN
      Joker:=Feld;
      END;
END; (* Rahmen *)


procedure Zufall;
(* nur bei Betaetigen der rechte Taste im Feld 'neu' *)
BEGIN
(* Fuellen der Felder mit Koordinaten *)
feld:=1;
zahl:=11;
repeat
   koordi[feld]:=zahl;
   feld:=feld+1;
   zahl:=zahl+1;
   if (zahl=15) or (zahl=25) or (zahl=35) then
   zahl:=zahl+6;
until feld = 17;

(* fuellen der Felder mit Inhalt per Random-Funktion *)
for feld:= 1 to 16 do
inhalt[feld]:=99;

for feld:= 1 to 16 do
begin
   repeat
      zahl:=random(17);
      if zahl=0 then zahl:=1;
      if inhalt[zahl] = 99 then
      inhalt[zahl]:=feld;
   until inhalt[zahl]=feld
end;

end; (* Zufall *)


PROCEDURE Zahlen_ausgeben;
(* Zahlen in Puzzle schreiben *)
BEGIN
xzahl:= 185;
yzahl:= 145;

For feld:= 1 TO 16 DO
   BEGIN
      moveto(xzahl,yzahl);
      IF Inhalt[feld] < 10 THEN moveto(xzahl+4,yzahl);
      textsize(1,2);
      IF Inhalt[feld] <> 16 THEN
      BEGIN
         STR(Inhalt[feld],Wort);
         textout(Wort);
      END;
      xzahl:=xzahl+40;
      IF xzahl=345 THEN
      BEGIN
         xzahl:=185;
         yzahl:=yzahl-20;
      END;
   END;

END; (* Zahlen ausgeben *)

procedure gewonnen;
BEGIN



END; (* gewonnen *)


procedure Tauschen;
BEGIN
delay(100);

hilfsjoker:=Inhalt[joker];
Inhalt[joker]:=Inhalt[feld];
Inhalt[feld]:=hilfsjoker;

Reihe:= trunc(koordi[feld]/10);
Spalte:= (koordi[feld]-(10*Reihe));
xzahl:= 136+(Spalte*40);
yzahl:= 161-(Reihe*20);

MOVETO(xzahl,yzahl);
gdpout(01);
WRITELN('R 38 18 1');
gdpout(00);

moveto(80,105);           (* alte Zahl loeschen *)
gdpout(01);
STR(Schritte,Wort);
textout(wort);
gdpout(00);

Schritte:=Schritte+1;

textsize(1,2);             (* 'Schrift' ausgeben *)
moveto(40,85);
IF Schritte = 1 THEN textout('Schritt');
moveto(124,85);
IF Schritte > 1 THEN textout('e');


moveto(80,105);          (* neue Zahl schreiben *)
STR(Schritte,Wort);
textout(Wort);

delay(100);

END; (* Tauschen *)


PROCEDURE Rechte_Taste;
BEGIN
(* Neue Zahlen  *)
IF (rechts=0) and (y>103) and (y<113) and (x>416) and (x<436) THEN BEGIN
   WRITELN('M 175 80');
   gdpout(01);
   WRITELN('R 161 80 1');
   gdpout(00);
   xRecht:=41;
   yRecht:=20;
   xPos:=235;
   yPos:=110;
   repeat
      WRITELN('M ',xPos,' ',yPos);
      WRITELN('R ',xRecht,' ',yRecht);
      delay(50);
      gdpout(01);
      WRITELN('R ',xRecht,' ',yRecht);
      gdpout(00);
      xRecht:=xRecht+12;
      yRecht:=yRecht+6;
      xPos:= xPos-6;
      yPos:=yPos-3;
   until xRecht>161;

   delay(200);
   Zufall;
                       (* Schritte loeschen *)
   textsize(1,2);
   moveto(80,105);
   gdpout(01);
   str(Schritte,Wort);
   textout(Wort);
   gdpout(00);
   Schritte:=0;
END; (* IF *)

(* Feld mit rechter Maustaste angewaehlt *)
IF (rechts=0) and (y>80) and (y<160) and (x>175) and (x<335) THEN
BEGIN
   (*Berechnung: welches Feld ist angewaehlt *)
   Reihe:=trunc(((x-175)/40)+1);
   Spalte:=(6-trunc((y-40)/20));
   Feld:=Reihe+((Spalte-1)*4);

   (* Berechnung: Soll getauscht werden ? *)
   IF (koordi[Feld]+1=koordi[Joker]) or
   (koordi[Feld]-1=koordi[Joker]) or
   (koordi[Feld]+10=koordi[Joker]) or
   (koordi[Feld]-10=koordi[Joker]) THEN Tauschen;
   Zahlen_ausgeben;
   neu_Zahlen:=1;
   END;

(* Zahlen erneuern, falls notwendig *)
neu_Zahlen:=neu_Zahlen+1;
IF rechts=0 THEN neu_Zahlen:=1;
IF neu_Zahlen=2 THEN
BEGIN
   Rahmen;
   Zahlen_ausgeben;
   neu_Zahlen:=1;
END; (* IF *)

END; (* Rechte Taste *)


PROCEDURE Bravo;

VAR gleich   :    integer;
    count    :    integer;

BEGIN
Gleich:=1;
FOR Feld:= 1 TO 15 DO
IF Inhalt[Feld] <> Feld THEN
   Gleich:=0;
IF Gleich = 1 THEN
BEGIN
   writeln('M 20 180');
   gdpout(01);
   writeln('R 480 60 1');
   writeln('M 30 5');
   writeln('R 480 40 1');
   gdpout(00);
   moveto(100,20);
   textsize(1,2);
   textout('weiter mit beliebiger Taste');
   count:=0;
   repeat
      (* Blinken des Super - Super *)
      count:= count+1;
      IF count<40 THEN
         gdpout(01)
      ELSE
         gdpout(00);

         moveto(35,200);
         textsize(3,6);
         textout('Super - Super');

      IF count=90 THEN
         count:=1;
   until keypressed;
   gdpout(00);
   writeln('Z');
   Zufall;
END;  (*IF*)
END;


PROCEDURE einstellen;
BEGIN
(*  Zahlen_ausgeben; *)
FOR Feld:=1 TO 16 DO
   Inhalt[Feld]:=Feld;
Inhalt[15]:=16;
Inhalt[16]:=15;
END;


(* Begin des Hauptprogrammes *)

BEGIN
  clrscr;
  Grafmode;
  WRITE('Y0');
  x:= 125;
  y:= 130;
  neu_Zahlen:=1;
  Schritte:=0;
  Zufall;
  Rahmen;
  (* Einstellen *);
  REPEAT
     Pfeil;
     Rechte_Taste;
     Bravo;
  UNTIL (links=0) or (Taste=72) or (Taste=40) ;
  Textmode;
  clrscr;
END.






