function muehle_zu(ad : integer; art : tstein) : boolean;
(* Testet ob eine Muehle geschlossen wurde *)
begin
  if (feld.brett[muehlen_nachb[ad,0]]=art) and
     (feld.brett[muehlen_nachb[ad,1]]=art) then muehle_zu:=true
  else
  muehle_zu:=(feld.brett[muehlen_nachb[ad,3]]=art) and
             (feld.brett[muehlen_nachb[ad,2]]=art);
end;

procedure zug_ermitteln(art : tstein);
(* Liefert einen Zug zurueck; Anzahl=0 wenn kein Zug moeglich *)
label exit;
var j : integer;
procedure teste_muehle;
(* Testen ob eine Muehle geschlossen wude, wenn ja dann
   schlagbaren Stein ermitteln *)
label  exit;
begin
  feld.muehle:=false;
  if muehle_zu(feld.zu,art) then
     begin
       while feld.schl_nr<23 do
         begin
           feld.schl_nr:=succ(feld.schl_nr);
           if feld.brett[feld.schl_nr]=geg[art]
              then
                if not muehle_zu(feld.schl_nr,geg[art]) then
                   begin
                     feld.anzahl:=1;
                     feld.muehle:=true;
                     goto exit;
                   end;
          end;
     end;
     feld.schl_nr:=-1;
     exit:
 end;

begin   (* zug_ermitteln *)
  with feld do
  begin
    anzahl:=0;
    with status[art] do  if steine+zaehler<3 then goto exit;
    if schl_nr > -1 then teste_muehle;
    while((k<23) or (l>-1)) and (anzahl=0) do
      begin
        if l=-1 then begin k:=succ(k) ; schl_nr:=-1;  end;  (*naechster Stein*)
        case status[art].modus of
          setzen : if brett[k]=leer then begin  anzahl:=1; zu:=k;
                                                teste_muehle; goto exit;
                                         end;
          ziehen : if brett[k]=art  then
                      begin
                        while l<3 do
                          begin
                            l:=succ(l);
                            j:=nachbar[k,l];
                            if j<>30 then if brett[j]=leer then
                               begin
                                 anzahl:=1;  von:=k;
                                 zu:=j; brett[k]:=leer;
                                 teste_muehle; brett[k]:=art; goto exit;
                               end;
                          end;
                        l:=-1;  (* alle Richtungen durch *)
                      end;
          springen : if brett[k]=art then
                        begin
                          while l<23 do
                            begin
                              l:=succ(l);
                              if brett[l]=leer then
                                 begin
                                   anzahl:=1;  von:=k;
                                   zu:=l; brett[k]:=leer;
                                   teste_muehle; brett[k]:=art; goto exit;
                                 end;
                            end;
                          l:=-1;
                        end;
      end; (* case *)
    end; (* wihle *)
  end; (* with *)
  exit:
end;

procedure mache_zug(stein : tstein; show : boolean);
(* Zug ausfuehren und gegebenenfals auf dem Spielbrett anzeigen *)

procedure setze_stein(ad : integer; stein : tstein);
var x, y, z  : integer;
begin
  if show then
  begin
    x:=ord(posit[ad][1])-ord('A');
    y:=ord(posit[ad][2])-ord('1');
    stein_eintragen(x, y, stein);
    delay(300);
    for z:=1 to 3 do
      begin
        stein_eintragen(x, y, feld.brett[ad]); delay(300);
        stein_eintragen(x, y, stein);          delay(300);
      end;
  end;
  feld.brett[ad]:=stein;
end;

begin  (* mache_zug *)
  with feld do
  begin
    case status[stein].modus of
      setzen    : begin
                    with status[stein] do begin
                      steine:=succ(steine); zaehler:=pred(zaehler);
                      if zaehler=0 then modus:=ziehen;
                    end;
                  end;
      springen,
      ziehen    : setze_stein(von,leer);
    end;
    setze_stein(zu,stein);
    if muehle then with status[geg[stein]] do
    begin
      setze_stein(schl_nr,leer);  steine:=pred(steine);
      if (steine=3) and (zaehler=0) then modus:=springen;
      if show then if steine+zaehler<3 then verloren(geg[stein]);
    end;
  end;
end;

