program berechnefunktion;

{ (C) Bruno Sontheim   }
{ 8960 Kempten Allgaeu }

{ das Programm berechnet eine als String eingegebene }
{ mathematische  Funktion                            }
{ System             : NDR 80                        }
{ Programmiersprache : Turbo - Pascal 3.0            }
{ Maerz 1987                                         }

type    zpointer = ^zteil;
        zteil    = record
                     zinhalt  : real;
                     znext    : zpointer;
                   end;

       fopointer = ^foteil;
       foteil    = record
                     foinhalt : char;
                     fonext   : fopointer;
                    end;

        hpointer = ^hteil;
        hteil    = record
                     hinhalt : string[80];
                     hnext   : hpointer;
                   end;

        bfunktion = string[80];
        letters   = set of #32..#126;

const   kl = 2;


var     sz                    : zpointer;
        sfo                   : fopointer;
        sh                    : hpointer;
        sfunktion             : string [80];
        hfunktion,rfunktion   : string [80];
        x,y,z,erg             : real;
        ergebnis,ergl,ergr    : real;
        po,pr,merker          : integer;
        heaptop               : ^integer;
        op                    : array [1..10] of string[3];
        oc                    : array [1..10] of char;
        zahlen,vorzeichen     : letters;
        operatoren,variab     : letters;
        poperatoren           : letters;

procedure pushz(wert:real);
var h : zpointer;
begin
  if sz = nil then
  begin
    new (h); h^.znext := sz; sz := h;
  end;
  new(h); h^.zinhalt := wert; h^.znext := sz; sz := h;
end;

function popz:real;
begin
  if sz^.znext = nil then
  begin
    popz := 0;
    exit;
  end;
  popz := sz^.zinhalt; sz := sz^.znext;
end;

procedure pushfo(wert:char);
var h: fopointer;
begin
  if sfo = nil then
  begin
    new(h);h^.fonext := sfo; sfo := h;
  end;
  new(h); h^.foinhalt := wert; h^.fonext := sfo; sfo := h;
end;

function popfo:char;
begin
 if sfo^.fonext = nil then
 begin
   popfo := ' ';
   exit;
 end;
 popfo := sfo^.foinhalt; sfo := sfo^.fonext;
end;

procedure pushh(wert:bfunktion);
var h:hpointer;
begin
  if sh = nil then
  begin
    new(h);h^.hnext := sh; sh := h;
  end;
  new(h); h^.hinhalt := wert; h^.hnext := sh; sh := h;
end;

function poph:bfunktion;
begin
 if sh^.hnext = nil then
 begin
   poph := ' ';
   exit;
 end;
 poph := sh^.hinhalt; sh := sh^.hnext;
end;

procedure init; { alle vorbereitungsmassnahmen treffen }
 begin
   op[1] := 'ABS'; op[2] := 'ATN'; op[3] := 'COS'; op[4] := 'EXP';
   oc[1] := 'A';   oc[2] := 'B'  ; oc[3] := 'C';   oc[4] := 'P';
   op[5] := 'FRA'; op[6] := 'INT'; op[7] := 'LN';  op[8] := 'SQR';
   oc[5] := 'F';   oc[6] := 'I';   oc[7] := 'L';   oc[8] := 'Q';
   op[9] := 'SQT'; oc[9] := 'R';   op[10] := 'SIN'; oc[10] := 'S';
   zahlen := ['0'..'9']+['.','E'];
   vorzeichen := ['+','-'];variab := [')','X','Y','Z'];
   operatoren := ['A','B','C','F','I','L','P',
                  'Q','R','S','+','-','*','/',' '];
   poperatoren := operatoren - ['-','*','/','+'] + ['H'];
   sz := nil; sh := nil; sfo := nil;
end;

procedure prioritaet(var s:bfunktion;g,h:integer);
{ po = position, pr := prioritaet }

var i,j,k,l : integer;

begin
  l := 0; k := 0; j := 16;
  for i := 1 to length(s) do begin
      case s[i] of
         '(' : k := k+1;
         ')' : k := k-1;
      end;
      if k = 0 then
        case s[i] of
        '+' : if ((j >= 1) and ((s[i-1] in zahlen-['E']) or(s[i-1] in variab)))
        then begin l := i; j := 1; end;
        '-' : if ((j >= 2) and ((s[i-1] in zahlen-['E'])or(s[i-1] in variab)))
        then begin l := i; j := 2; end;
        '*' : if j >= 3 then begin l := i; j := 3; end;
        '/' : if j >= 4 then begin l := i; j := 4; end;
        'A' : if j > 5 then begin l := i; j := 5; end;
        'B' : if j > 6 then begin l := i; j := 6; end;
        'C' : if j > 7 then begin l := i; j := 7; end;
        'P' : if j > 8 then begin l := i; j := 8; end;
        'F' : if j > 9 then begin l := i; j := 9; end;
        'I' : if j >10 then begin l := i; j := 10; end;
        'L' : if j >11 then begin l := i; j := 11; end;
        'Q' : if j >12 then begin l := i; j := 12; end;
        'R' : if j >13 then begin l := i; j := 13; end;
        'S' : if j >14 then begin l := i; j := 14; end;
        end;
        end;
   po := l;
   pr := j;
  end;

procedure preparestring;
var i,k    : integer;
label panfang;

{ a = abs, b = arctan, c = cos, p = exp, f = frac,i = int, l = ln,
  s = sin, q = quadrat, r = root, u = plus,m = minus,t = multiplikation,
  d = division, n = minus rechts, g = division rechts
  x und y sind fuer reelle Zahlen reserviert }

begin
  hfunktion := sfunktion;   { string kopieren }
  for i := 1 to length(hfunktion) do begin
    if hfunktion[i] = ' ' then
    begin
      delete (hfunktion,i,1);
      i := i-1;
    end;
  end;
    for i := 1 to length(hfunktion) do
    begin
      hfunktion[i] := upcase(hfunktion[i]);
    end;
  for i := 1 to 10 do
  begin
    panfang:
    k := pos (op[i],hfunktion);
    if k <> 0 then begin
      delete (hfunktion,k,length(op[i]));
      insert (oc[i],hfunktion,k);
      goto panfang;
    end;
  end;
  rfunktion := hfunktion;
end;

procedure delklammer;
{ diese funktion loescht Klammern aus dem String }
var i,k,l,m : integer;
begin
 k := 0; l := 0; m := 0;
 for i := 1 to length(hfunktion)do
 begin
   case hfunktion[i] of
    '(' :  begin k := k+1; if ((k = 1) and (l= 0)) then
           begin
             delete(hfunktion,i,1);l := 1; i := i-1;
           end;
           end;
     ')' : begin k := k-1;if ((k = 0) and (m = 0)) then
           begin
             delete(hfunktion,i,1); m := 1;i := i-1;
           end; { delete }
           end;  { ')' }
    end;{ case }
 end; { for }
end; { delklammer }

procedure eberechnung (ch1:char); { berechnet wert mit normalem operator }
begin
  ergr := popz;ergl := popz;
  case ch1 of
    '*' : erg := ergl * ergr;
    '/' : erg := ergl / ergr;
    '+' : erg := ergl + ergr;
    '-' : erg := ergl - ergr;
  end; { case }
  pushz(erg);
end;

procedure pberechnung(ch1:char);
begin
 ergl := popz;
 case ch1 of
   'A' : erg := abs(ergl);
   'B' : erg := arctan(ergl);
   'C' : erg := cos(ergl);
   'P' : erg := exp(ergl);
   'F' : erg := frac(ergl);
   'I' : erg := int(ergl);
   'L' : erg := ln(ergl);
   'S' : erg := sin(ergl);
   'Q' : erg := sqr(ergl);
   'R' : erg := sqrt(ergl);
 end;
 pushz(erg);
 end;

{$A-}  {ab hier rekursion erlaubt }

procedure preparestack;
{ stack wird mit den noetigen Angaben vorbereitet }
var k,j : integer;
    rs  : real;
    s   : string[80];
    ch  : char;
label pps1,ende,test;

begin
  k := 1;
  pps1:
  prioritaet(hfunktion,po,pr);
  if po = 0 then
  begin
    delklammer;
    k := k+1; if k = kl then goto test;
    if po = 0 then goto pps1;
  end;
  if po <> 0 then
  begin
    if po < length(hfunktion) then
    begin
      { rechten string abspalten und auf h-stack legen }
      s := copy(hfunktion,po+1,80);pushh(s);
      delete(hfunktion,po+1,80);
      { das operationszeichen wird auf stack gelegt }
      pushfo(hfunktion[po]); delete(hfunktion,po,1);
      pushfo('H'); { h gibt an, das string rechts verarbeitet werden muss !}
    end; { abspaltungsfunktion }
  test:
  if po = 0 then
  begin
    ch := copy(hfunktion,1,1);
    if (length(hfunktion) = 1) and (ch in variab-[')']) then
    begin
      case ch of
           'X' : pushz(X);
           'Y' : pushz(Y);
           'Z' : pushz(Z);
      end;  { case }
      delete(hfunktion,1,1);goto ende;
    end;
    if length(hfunktion) <> 0 then val (hfunktion,rs,j);
    if j = 0 then
    begin
      pushz(rs); hfunktion :='';
      po := 1;
    end;
    end;
    if po = length (hfunktion)then begin
       pushfo(hfunktion[po]);
       delete(hfunktion,po,1);
    end;
    if length(hfunktion) = 0 then goto ende
    else preparestack; { rekursiv }
end;
ende:
end;

{$A+}

procedure hberechnung;
begin
 hfunktion := poph;
 preparestack;
end;

procedure berechnung;
var       chb : char;
label ende,anfang;
begin
  preparestack;  { als erstes wird stack aufbereitet }
  anfang:
  chb := popfo;
  if chb = 'H' then hberechnung;
  if chb = ' ' then goto ende; { ende des programms = Zuweisung des ergebn }
  if chb  in ['+','-','*','/'] then eberechnung(chb);
  if chb in poperatoren - ['H',' ']  then pberechnung(chb);
      { praefixoperator }
  {  hier berechnung falls +,-,* oder /  sonst praefix-operatoren }
  goto anfang;
  ende:
  ergebnis := popz;
  pushz(ergebnis);
end;

{ Mit dieser Funktion kann das Programm aufgerufen werden }
{ ausdruck = string (z.B.: sin(x)-y); x,y und z sind die  }
{ Variablen die der Funktion mitgegeben werden koennen    }

function funktion(var ausdruck : bfunktion; x2,y2,z2 : real):real;
begin
 x := x2; y := y2; z := z2;
 sfunktion := ausdruck;
 init;
 preparestring;
 mark(heaptop);
 berechnung;
 release(heaptop);
 funktion := ergebnis;
end;

{ kleines Programmbeispiel }

var term      : string[80];
    fergebnis : real;
    x1,y1,z1  : real;
begin
clrscr;
 repeat;
 writeln('Geben Sie die Variablen x,y und z ein ');
 write('x = '); readln(x1)
 ;
 write('y = '); readln(y1);
 write('z = '); readln(z1);
 writeln('Geben Sie den mathematischen Ausdruck ein : ');
 writeln('Beachten Sie: Atn = ArcTan, Fra = Frac und Sqt = Sqrt');
 writeln;
 readln(term);
 fergebnis := funktion(term,x1,y1,z1);
 writeln;
 write('Ergebnis : ',sfunktion,' = ');
 writeln(fergebnis:10:7);
 writeln;
 until false
end.




