{****************************************************************************}
{* DDIR-01.INC                                   Prozeduren mit Diskzugriff *}
{****************************************************************************}

FUNCTION Space (Lw: BYTE) : INTEGER;          {unter CP/M 2.2          }
TYPE  Diskettenbeschreiber = RECORD           {aus CHIP-Special, Heft 3}
                               Anzahl_der_logischen_Sektoren      : INTEGER;
                               Blockverschiebungsfaktor           : BYTE;
                               Blockmaske                         : BYTE;
                               Eintragsmaske                      : BYTE;
                               Anzahl_der_Bloecke                 : INTEGER;
                               Anzahl_der_Verzeichniseintraege    : INTEGER;
                               Verzeichnis_Vektor                 : INTEGER;
                               Anzahl_der_zu_pruefenden_Eintraege : INTEGER;
                               Anzahl_der_Systemspuren            : INTEGER
                             END;
      Belegungsverzeichnis = ARRAY[0..127] OF BYTE;
VAR   p              : ^Diskettenbeschreiber;
      q              : ^Belegungsverzeichnis;
      i              : INTEGER;
      frei           : INTEGER;
BEGIN
  Bezugslaufwerk := BDOS (25);                {Bezugslaufwerk ermitteln}
  IF Lw >0 THEN BDOS (14, Lw-1);              {Laufwerk anwaehlen}
  p := PTR (BDOSHL(31));
  q := PTR (BDOSHL(27));
  WITH p^ DO
    BEGIN
      frei := 0;
      FOR i := 0 TO Anzahl_der_Bloecke DO
      IF q^ [i SHR 3] AND (128 SHR (i AND 7)) = 0 THEN frei := SUCC (frei);
      Space := (SUCC (Blockmaske) SHR 3) * frei
    END;
  IF Lw>0 THEN BDOS (14, Bezugslaufwerk)      {Bezugslaufwerk anwaehlen}
END; {Space}

{****************************************************************************}

PROCEDURE DiskDatenSchreiben;
LABEL  1,2,3,4,5,6,7;
CONST  Ja  : BOOLEAN = FALSE;
       Neu : BOOLEAN = FALSE;
  BEGIN
    IF NeuDisk THEN
       BEGIN GOTOXY(59,21); CLREOL; WRITE ('Bitte Daten eingeben!') END;
    1: IF NOT NeuDisk THEN BEGIN
         REPEAT
           GOTOXY(59,21); CLREOL; WRITE ('   Korrigieren? (J/N)');
           GOTOXY(40,13); CLREOL;
           BUFLEN := 1; READ (KBD, Ch); Ch := UPCASE (Ch);
         UNTIL Ch IN ['J','N'];
         IF Ch = 'J' THEN BEGIN
           Ja := TRUE; Neu := TRUE; GOTO 2 END ELSE GOTO 3 END;
    2: GOTOXY(38,13); CLREOL; BUFLEN := 1; READ (DiskKategorie);
       DiskKategorie := UPCASE (DiskKategorie);
       GOTOXY(38,13); CLREOL; WRITE (DiskKategorie);
       IF NOT (DiskKategorie IN ['A'..'D']) THEN GOTO 2;
    3: IF NOT NeuDisk THEN BEGIN
         REPEAT
           GOTOXY(59,21); CLREOL; WRITE ('   Korrigieren? (J/N)');
           GOTOXY(41,15) ; CLREOL;
           BUFLEN := 1; READ (KBD, Ch); Ch := UPCASE (Ch);
         UNTIL Ch IN ['J','N'];
         IF Ch = 'J' THEN BEGIN
           Ja := TRUE; Neu := TRUE; GOTO 4 END ELSE GOTO 5 END;
    4: GOTOXY(38,15); CLREOL;
       BUFLEN := 2; READ (DiskNr);
       IF NOT (DiskNr[1] IN ['0'..'9']) THEN GOTO 4;
       IF LENGTH (DiskNr) <> 2 THEN GOTO 4;
       IF NOT (DiskNr[2] IN ['0'..'9']) THEN GOTO 4;
    5: IF NOT NeuDisk THEN BEGIN
         REPEAT
           GOTOXY(59,21); CLREOL; WRITE ('   Korrigieren? (J/N)');
           GOTOXY(LENGTH(DiskInhalt)+39,17); CLREOL;
           BUFLEN := 1; READ (KBD, Ch); Ch := UPCASE (Ch);
         UNTIL Ch IN ['J','N'];
         IF Ch = 'J' THEN BEGIN Ja := TRUE; GOTO 6 END ELSE GOTO 7 END;
    6: GOTOXY(38,17); CLREOL;
       BUFLEN := 40; WRITE (DT); READ (DiskInhalt); WRITE (US);
    7: IF NOT NeuDisk THEN IF NOT Ja THEN EXIT;
    DiskDaten := CONCAT (DiskKategorie, DiskNr, DiskInhalt);
    DiskDatei := CONCAT (Laufwerk, ':DDIR.DAT');
    BDOS (13);                                {Laufwerke zuruecksetzen}
    ASSIGN (f, DiskDatei);
    IF NeuDisk THEN REWRITE (f) ELSE RESET (f);
    WRITE (f, DiskDaten); CLOSE (f);
    IF Neu THEN BEGIN
      NeuNr := CONCAT (DiskKategorie, '/', DiskNr);
      IF NeuNr <> AltNr THEN BEGIN
        WRITE (DT);
        FOR i := 1 TO 10 DO BEGIN
          GOTOXY(6,21); CLREOL; DELAY (500);
          WRITE ('Achtung : "Inhalt" und Directory von Disk ', AltNr,
                                              ' im SUPERDIRECTORY l|schen !');
          DELAY (1500) END;
        WRITE (US) END;
      AltNr := ''; NeuNr := ''; Neu := FALSE END
  END; {DiskDatenSchreiben}

{****************************************************************************}

PROCEDURE DiskDatenLesen (VAR RestKap: INTEGER; VAR DiskDaten: DiskDatenTyp;
       VAR DiskNr: NrTyp; VAR DiskKategorie: KTyp; VAR DiskInhalt: InhaltTyp);
  BEGIN
    BDOS (13);                                {Laufwerke zuruecksetzen}
    RestKap := Space (Lw);
    DiskDatei := CONCAT (Laufwerk, ':DDIR.DAT');
    ASSIGN (f, DiskDatei); {$I-} RESET (f); {$I+}
    IF IORESULT <> 0 THEN BEGIN               {neue Datei "DISK.DAT" anlegen}
      IF RestKap < 2 THEN BEGIN
        WRITE (DT);
        FOR i :=  1 TO 10 DO BEGIN
          GOTOXY(6,21); CLREOL; DELAY(250); WRITE ('Laufwerk ', Laufwerk,': ',
          'Diskdaten k|nnen nicht gespeichert werden, weil Diskette voll!');
          DELAY (750); GOTOXY(6,21) END;
        WRITE (US); Druck := FALSE; EXIT END
      ELSE BEGIN
        NeuDisk := TRUE; DiskDatenMenue; DiskDatenSchreiben; NeuDisk := FALSE
      END
    END
    ELSE WHILE NOT (EOF(f)) DO READ (f, DiskDaten); CLOSE (f);
    DiskKategorie := COPY (DiskDaten,1,1);
    DiskNr := COPY (DiskDaten,2,2);
    DiskInhalt := COPY (DiskDaten,4, LENGTH(DiskDaten)-3);
  END; {DiskDatenLesen}

{****************************************************************************}

PROCEDURE DiskDatenEditieren (VAR AltNr: DiskIdent);
  BEGIN
    DiskDatenLesen (RestKap, DiskDaten, DiskNr, DiskKategorie, DiskInhalt);
    IF RestKap < 2 THEN EXIT;
    DiskDatenMenue;
    GOTOXY(38,13); WRITE (DiskKategorie);
    GOTOXY(38,15); WRITE (DiskNr);
    GOTOXY(38,17); WRITE (DiskInhalt);
    AltNr := CONCAT (DiskKategorie, '/', DiskNr);
    DiskDatenSchreiben
  END; {DiskDatenEditieren}

{****************************************************************************}

PROCEDURE DirectoryLesen (VAR Disk: Directory);
VAR   Offset, i, j          : INTEGER;
      FCB                   : ARRAY[0..12] OF CHAR ABSOLUTE $005C;
      Buffer                : STRING[128];
      RW, Sys               : CHAR;
      CtrZn                 : BYTE;
      SchreibSchutz         : STRING[1];
      TempName, Temp        : DirName;
  BEGIN
    FCB := #0'???????????'#0;
    IF Laufwerk = 'A' THEN FCB[0] := #1 ELSE FCB[0] := #2;
    BDOS (26, ADDR (Buffer) + 1);             {Datenpuffer festlegen}
    Offset := BDOS (17, ADDR (FCB));          {ersten Eintrag suchen}
    MEM[ADDR (Buffer)] := 128;                {Stringlaenge festlegen}
    Disk.Number := 0;
    Disk.SysNumber := 0;
    Disk.DirNumber := 0;
    WHILE Offset < 255 DO
      BEGIN
        Disk.Number := Disk.Number +1;
        RW  := COPY (Buffer, 10 + 32 * Offset, 1);
        Sys := COPY (Buffer, 11 + 32 * Offset, 1);
        IF (ORD(RW)  > 128) THEN SchreibSchutz := ':';
        IF (ORD(RW) <= 128) THEN SchreibSchutz := '-';
        IF (ORD(Sys) > 128) THEN              {SYS-Dateien von Disk holen}
          BEGIN
            TempName := COPY (Buffer, 2 + 32*Offset, 11);
            FOR i := 1 to 11 DO BEGIN
              IF (ORD(TempName[i]) <32) OR (ORD(TempName[i]) =127)
                                                      THEN TempName[i] := '!';
              CtrZn := POS ('!', TempName) END;
            IF CtrZn = 0 THEN
              BEGIN
                Disk.SysNumber := Disk.SysNumber +1;
                Disk.SysEntry[Disk.SysNumber] :=
                            CONCAT (COPY (Buffer,  2 + 32 * Offset, 8),'.',
                            COPY (Buffer, 10 + 32 * Offset, 3), SchreibSchutz)
              END
          END; {SYS-Dateien holen}
        IF NOT (ORD(Sys) > 128) THEN          {DIR-Dateien von Disk holen}
          BEGIN
            TempName := COPY (Buffer, 2 + 32*Offset, 11);
            FOR i := 1 to 11 DO BEGIN
              IF (ORD(TempName[i]) <32) OR (ORD(TempName[i]) =127)
                                                      THEN TempName[i] := '!';
              CtrZn := POS ('!', TempName) END;
            IF CtrZn = 0 THEN
              BEGIN
                Disk.DirNumber := Disk.DirNumber +1;
                Disk.DirEntry[Disk.DirNumber] :=
                            CONCAT (COPY (Buffer,  2 + 32 * Offset, 8),'.',
                            COPY (Buffer, 10 + 32 * Offset, 3), SchreibSchutz)
              END
          END; {DIR-Dateien holen}
        Offset := BDOS (18)                   {folgenden Eintrag suchen}
      END;
      FOR i := 1 TO Disk.SysNumber-1 DO       {Bubblesort: SYS-Dateien}
        FOR j := Disk.SysNumber DOWNTO i DO
          IF Disk.SysEntry[i] > Disk.SysEntry[j] THEN
            BEGIN
              Temp := Disk.SysEntry[i];
              Disk.SysEntry[i] := Disk.SysEntry[j];
              Disk.SysEntry[j] := Temp
            END;
      IF Sort THEN BEGIN
        FOR i := 1 TO Disk.DirNumber-1 DO     {Bubblesort: Dir-Dateien}
          FOR j := Disk.DirNumber DOWNTO i DO
            IF Disk.DirEntry[i] > Disk.DirEntry[j] THEN
              BEGIN
                Temp := Disk.DirEntry[i];
                Disk.DirEntry[i] := Disk.DirEntry[j];
                Disk.DirEntry[j] := Temp
              END
      END {IF Sort}
  END; {DirectoryLesen}

{****************************************************************************}

PROCEDURE LaufwerkWechsel (VAR Laufwerk: CHAR; VAR Lw: BYTE);
  BEGIN
    IF Laufwerk = 'A' THEN BEGIN Laufwerk := 'B'; Lw := 2 END
    ELSE                   BEGIN Laufwerk := 'A'; Lw := 1 END;
    IF Laufwerk = 'B' THEN BEGIN
      GOTOXY(53,21); CLREOL; WRITE ('Diskette in Laufwerk B: ? ');
      REPEAT READ (KBD, Ch); Ch := UPCASE (Ch); UNTIL Ch IN ['J', #13]
    END
  END; {Laufwerkwechsel}

