PAGE 65,132
TITLE	SERIAL PRINTER DRIVER FOR DM-ENH

;*****************************************************************************
;*********                                                          **********
;*********                      CHANGE SHEET                        **********
;*********                                                          **********
;*****************************************************************************
;
;     Date               Changes Made                                     By
;_____________________________________________________________________________
;   06-25-84  I   Original Entry                                       I  HD 
;   07-06-84  I   Correction of SPARs   G2818   IOCTL-Call  p.7        I
;             I                         G2819   ETX-ACK     p.10       I  HD  
;   07-13-84  I   SPAR  Q2846: RETURN ERROR FOR UNDEFINED PRINTER      I  HD
;             I   ETX-ACK PROTOCOL VIA CARRIER CHECK                   I  HD
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;             I                                                        I
;_____________________________________________________________________________
;
;
PUBLIC	LPT1_ACT,LPT2_ACT,LPT3_ACT,LPT4_ACT,LPT5_ACT
PUBLIC	KBD_CC
;
;
EXTRN	PRNTBL:BYTE,LPT2TBL:BYTE,LPT3TBL:BYTE,LPT4TBL:BYTE,LPT5TBL:BYTE
EXTRN	PTRSAV:DWORD,KBD_BUFF_IN:NEAR
;
CSEG    SEGMENT	PUBLIC	'CODE'
ASSUME  CS:CSEG,DS:CSEG,ES:CSEG
PAGE   
;
;
;
;	_________________
;	-  RELEASE ID   -
;	_________________
	DB	02,02,00
;
;
;
;
;Define offsets for io data packet

IODAT   STRUC
CMDLEN  DB      ?               ;LENGTH OF THIS COMMAND
UNIT    DB      ?               ;SUB UNIT SPECIFIER
CMD     DB      ?               ;COMMAND CODE
STATUS  DW      ?               ;STATUS
        DB      8 DUP (?)
MEDIA   DB      ?               ;MEDIA DESCRIPTOR
TRANS   DD      ?               ;TRANSFER ADDRESS
COUNT   DW      ?               ;COUNT OF BLOCKS OR CHARACTERS
BEGIN   DW      ?               ;FIRST BLOCK TO TRANSFER
IODAT   ENDS


LPT_DAT	STRUC
PORT	DB	?	;PORT ADDDRESS OF PRINTER
MODE	DW	?	;MODE BYTES TO SET INTERFACE
PROTOCOL DB	?	;PROTOCOL#:0=NO,1=XON-XOFF,2=READY-BUSY
			;  3=ENQUIRY ACKNOWLEDGE 	
LPT_DAT	ENDS


LPT_ACT	DB	0		;BIT MAP OF ACTIVE PRINTER (ONLY ONE)
ACTIVE_PRINT RECORD UNDEV:3,LP5:1,LP4:1,LP3:1,LP2:1,LP1:1


ACT_PROT	DB	1	;PROTOCOL OF ACTIVE PRINTER
PAGE
;
;**********************************************************************
;*                                                                    *
;*                   EQUATES used by the SER PIM                      *
;*                                                                    *
;**********************************************************************
;
;
;	PORT ADDRESSES FOR SERIAL IF RS232 (2651)  
;
	RDATA	EQU	00H	;READ DATA
	RSTAT	EQU	01H	;READ STATUS
	RCOM	EQU	03H	;READ COMMAND
	WDATA	EQU	04H	;WRITE DATA
	WMODE	EQU	06H	;WRITE MODE
	WCOM	EQU	07H	;WRITE COMMAND
;
;	XON-XOFF VALUES
;
	XON	EQU	11H
	XOFF	EQU	13H
	ACK	EQU	06H
	ETX	EQU	03H

	WAIT_FL	DB	00H	;FOR EACH PRINTER SET IF NOT READY
				;   1F hex = ALL 5 PRINTERS NOT READY

;
;	STATUS EQUATES FOR SERIAL IF RS232 (2651)...BIT MAPPED
;
	TXRDY	EQU	01H	;TRANSMIT HOLDING REGISTER EMPTY
	RXRDY	EQU	02H	;RECEIVE HOLDING REGISTER EMPTY
	TXEMT	EQU	04H	;CHANGE IN DSR OR DCD OR TRANSMIT
	PARITY	EQU	08H	;PARITY ERROR
	OVERRUN	EQU	10H	;OVERRUN ERROR
	FRAMING	EQU	20H	;FRAMING ERROR
	DCD	EQU	40H	;DATA CARRIER DETECT
	DSR	EQU	80H	;DATA SET READY
PAGE
;
;**********************************************************************
;*                                                                    *
;*                   EQUATES used by the PAR PIM                      *
;*                                                                    *
;**********************************************************************
;
;	IDENTIFICATION BIT OF PARALLEL / SERIAL	PRINTER
;
	PARALLEL	EQU	80H
;
;	PORT ADDRESSES FOR PARALLEL I/F (CENTRONICS)  
;
	PBDA	EQU	00H	;DATA PORT
	PBSTA	EQU	01H	;STATUS PORT
	PBCOM 	EQU	03H	;CONTROL PORT
;
;	STATUS EQUATES FOR PARALLEL I/F (CENTRONICS)
;
	BUSY	EQU	20H	;PRINTER BUSY
	POBF	EQU	02H	;OUTPUT BUFFER FULL
;
;	COMMAND BYTE FOR PARALLEL PRINTER
;
	P_COM	EQU	0AAH
;
;------------------------------------------------------------------------------
;
;
;
;
;******************************************************************
;***		ADDITIONAL EQUATES			***********
;******************************************************************
;
	KBD_STAT	EQU	41H	;KEYBOARD STATUS PORT
	KBD_DATA	EQU	40H	;KEYBOARD INPUT DATA PORT
	CONTROL_C	EQU	03H	;KEY COMBINATION OF CONTROL AND C
PAGE
LPT1_ACT:
	PUSH	DX
	PUSH	BP
	MOV	BP,OFFSET PRNTBL
	MOV	DH,MASK LP1
	JMP	ENTRY			
;
LPT2_ACT:
	PUSH	DX
	PUSH	BP
	MOV	BP,OFFSET LPT2TBL
	MOV	DH,MASK LP2
	JMP	ENTRY			
;
LPT3_ACT:
	PUSH	DX
	PUSH	BP
	MOV	BP,OFFSET LPT3TBL
	MOV	DH,MASK LP3
	JMP	ENTRY			
;
LPT4_ACT:
	PUSH	DX
	PUSH	BP
	MOV	BP,OFFSET LPT4TBL
	MOV	DH,MASK LP4
	JMP	ENTRY	
;
LPT5_ACT:
	PUSH	DX
	PUSH	BP
	MOV	BP,OFFSET LPT5TBL
	MOV	DH,MASK LP5
	JMP	ENTRY	
;

PAGE
ENTRY:
	PUSH	ES
	PUSH	BX
	PUSH    AX              ;Save all necessary registers.
        PUSH    DS
        PUSH    CS
	POP	DS
        PUSH    SI
        PUSH    DI
	LES	BX,PTRSAV
	MOV	DI,WORD PTR DS:[BP.PORT]
	AND	DI,0FFH
	CMP	DI,0			;FOR UNDEFINED PRINTER 
	JNE	ENTRY0			;
	JMP	ERROR_1			;RETURN AN ERROR
ENTRY0:	
	TEST	LPT_ACT,DH
	JNZ	ENTRY1
	MOV	LPT_ACT,DH
	MOV	AL,DS:[BP.PROTOCOL]
	MOV	ACT_PROT,AL
	TEST	ACT_PROT,PARALLEL
	JNZ	ENTRY2
	MOV	AX,DS:[BP.MODE]	;GET FRAMING AND MODE
	MOV	DX,DI
	ADD	DX,WMODE
	OUT	DX,AL		;OUT MODE 1 BYTE
	MOV	AL,AH		;CLOCK AND SPEED
	OUT	DX,AL		;OUT MODE 2 BYTE
	MOV	AL,37H		;COMMAND BYTE (USUALLY 37h)
	MOV	DX,DI
	ADD	DX,WCOM
	OUT	DX,AL		; SET DTR AND RTS, RESET ERROR
	JMP	ENTRY1
ENTRY2:
	MOV	AL,P_COM
	MOV	DX,DI
	ADD	DX,PBCOM
	OUT	DX,AL        	;INITIALIZE PARALLEL INTERFACE
ENTRY1:
	MOV	SI,OFFSET PRNJMP_TBL
        MOV     AL,ES:[BX.CMD]     ;Retrieve Command type. (1 => 11)
        XOR     AH,AH           ;Clear upper half of AX for calculation.
        ADD     SI,AX           ;Compute entry pointer in dispatch table.
        ADD     SI,AX
        JMP     [SI]            ;Perform I/O packet command.
;
;
;
;		REGISTERS SET :		ES:BX = POINTER TO I/O PACKET
;					DS    = CS (CSEG)
;					DI    = PORT BASE ADDRESS	
;		REGISTERS FREE FOR USE :
;					AX,DX,SI,BX	ALREADY SAVED
;					CX		NOT SAVED TILL NOW
        PAGE

PRNJMP_TBL:
	DW      EXIT        	;INIT - NOT USED
        DW      EXIT            ;1  - (Not used)
        DW      EXIT            ;2  - Block (Not used)
        DW      EXIT		;3  - set parameters for interface on input
        DW      EXIT            ;4  - (Not used)
        DW      BUS_EXIT        ;5  - (Not used, returns busy flag.)
        DW      EXIT            ;6  - (Not used)
        DW      EXIT            ;7  - (Not used)
        DW      OUT_PROC        ;8  - Character write.
        DW      OUT_PROC        ;9  - Character write with verify.
        DW      OUT_STAT        ;10 - Character write status.
        DW      EXIT            ;11 - (Not used.)
        DW      CONTROL_OUT	;12 - IO-Control OUTPUT
	DW	ERROR_3		;13
	DW	ERROR_3		;14
	DW	ERROR_3		;15
;
;
;
;
CONTROL_OUT:
	MOV	LPT_ACT,0		;SET ALL PRINTERS TO NOT ACTIVE
	JMP	EXIT
        PAGE
;
;	*******************************
;	***    OUTPUT ENTRY POINT   ***
;	*******************************
;
;
OUT_PROC:
			PUSH	CX
			PUSH	ES
			MOV	CX,ES:[BX.COUNT]   ;GET BYTE COUNTER
			MOV	SI,WORD PTR ES:[BX.TRANS]   ;
			MOV	AX,WORD PTR ES:[BX.TRANS+2] ;ES:SI = TRANSFER ADDRESS
			MOV	ES,AX
OUT2:
			PUSH	CX		;SAVE BYTE COUNTER
			LODS	BYTE PTR ES:[SI]	;GET NEXT CHARACTER FOR PRINT
			MOV	CL,AL		;STORE ON CL
			CALL	SRLOUT_DISP	;CALL WRITE ROUTINE CORRESPONDING
			POP	CX		;  TO PROTOCOL USED
			JZ	OUT1		;FOR PRINTER NOT READY
			LOOP	OUT2		;CONTINUE TILL END OF TRANSFER
			POP	ES
			POP	CX
			JMP	EXIT		;NORMAL EXIT
OUT1:
			POP	ES
			MOV	AX,ES:[BX.COUNT] ;
			SUB	AX,CX		;GET NUMBER OF TRANSFERED BYTES
			MOV	ES:[BX.COUNT],AX ;AND SAVE IT AT TRANSFER ADDR.
			POP	CX
			JMP	ERROR_2		;RETURN VIA 'DEVICE NOT READY'
;
;
;
SRLOUT_DISP:		MOV	BP,OFFSET SO_DISP_TBL
SIF_DISP:		MOV	AL,ACT_PROT	;GET PROTOCOL VECTOR OF ACTIVE PRINTER
		CLC
		RCL	AL,1		;AL*2...TABLE TYPE WORD 
		CBW			;EXPAND BYTE IN AL TO WORD IN AX
		JNC	SIF_D1		;FOR PARALLEL PROTOCOL JUMP TO ITS
		ADD	BP,OFFSET PO_DISP_TBL  ; OWN TABLE
		SUB	BP,OFFSET SO_DISP_TBL
SIF_D1:
		ADD	BP,AX		;BP = POINTER TO ROUTINE ADDRESS
		JMP	CS:[BP]		;JUMP TO ROUTINE FOR DEFINED PROTOCOL

SO_DISP_TBL:	DW	WRITE		
		DW	WRITE
		DW	WRITE
		DW	WRITE_ACK
PO_DISP_TBL:	DW	PWRITE		;PARALLEL  WRITE TABLE

SST_DISP_TBL:	DW	SPST0		;NO PROTOCOL
		DW	SPST1		;XON-XOFF PROTOCOL
		DW	SPST2		;RDY/BSY     "
		DW	SPST3		;ETX/ACK     "
PST_DISP_TBL:	DW	PPST0		;PARALLEL PRINTER STATUS TABLE
;
;
;
; GET INPUT STATUS
;
SPAIST:
		MOV	DX,DI
		ADD	DX,RSTAT
      		IN	AL,DX	
		AND	AL,OVERRUN OR PARITY OR FRAMING
		JZ	SPAI2		;JUMP IF NONE OF CHECKED ERRORS OCCURED
		CALL	TRERR		;CALL ERROR ROUTINE, ERROR ENCOUNTERED
					; IN RECEIVER
SPAI2:		
		MOV	DX,DI	
		ADD	DX,RSTAT
		IN	AL,DX
		AND	AL,RXRDY	;TEST FOR CHARACTER RECEIVED
SPAI3:		RET			;ZR=NO CHARACTER RECEIVED
					;NZ=CHARACTER READY 

TRERR:
		MOV	DX,DI
		ADD	DX,RDATA
		IN	AL,DX		;DUMMY READ
		MOV	DX,DI
		ADD	DX,RCOM
		IN	AL,DX		;READ COMMAND BYTE
		OR	AL,10H		;RESET ERROR
		MOV	DX,DI
		ADD	DX,WCOM
		OUT	DX,AL
		RET
;
; GET PRINTER STATUS
;
SPST0:		CALL	SPAIST		;CHECK INPUT STATUS
		JZ	SP0_2		;JUMP IF NO INPUT
		CALL	SPAIN1		;GET INPUT CHARACTER
SP0_2:		
		MOV	DX,DI
		ADD	DX,RSTAT
		IN	AL,DX	
		AND	AL,TXRDY	;TEST FOR TRANSMITTER READY
		RET			;ZR=NOT READY, NZ=READY
;
;
SPST1:		CALL	SPAIST		;CHECK INPUT STATUS
		JZ	SP1_5		;JUMP IF NO INPUT
		CALL	SPAIN1		;GET INPUT CHARACTER
		CMP	AL,XON		;END OF WAITING ON RECEIVED 'XON'
		JNZ	SP1_1
		MOV	AH,LPT_ACT
		NOT	AH
		AND	WAIT_FL,AH	;IF SO, REPLACE WAITING FLAG FOR THIS
		JMP	SP1_2		;PRINTER
SP1_1:
		CMP	AL,XOFF		;START OF WAITING 
		JNZ	SP1_5
		MOV	AH,LPT_ACT
		OR	WAIT_FL,AH	;SET WAIT FLAG
		XOR	AH,AH		;SET ZERO FLAG FOR CORRECT RETURN
		JMP	SP1_4
SP1_5:
		MOV	AH,WAIT_FL
		NOT	AH
		AND	AH,LPT_ACT	;TEST FOR WAIT TO SEND  OR NOT
		JZ	SP1_4		; ZERO FLAG IS SET OK    	
SP1_2:
		MOV	DX,DI
		ADD	DX,RSTAT
		IN	AL,DX	
		AND	AL,TXRDY	;TEST FOR TRANSMITTER READY
SP1_4:		RET			;ZR=NOT READY, NZ=READY
;
;
SPST2:		CALL	SPAIST		;CHECK INPUT STATUS
		JZ	SP2_2		;JUMP IF NO INPUT
		CALL	SPAIN1		;GET INPUT CHARACTER
SP2_2:		
		MOV	DX,DI
		ADD	DX,RSTAT
		IN	AL,DX	
		TEST	AL,DCD		;TEST FOR CARRIER
		JZ	SP2_4
		TEST	AL,DSR		;AND DATA SET (PRINTER BUSY)
		JZ	SP2_4
		AND	AL,TXRDY	;TEST FOR TRANSMITTER READY
SP2_4:		RET			;ZR=NOT READY, NZ=READY
;
;
SPST3:		CALL	SPAIST		;CHECK INPUT STATUS
		JZ	SP3_2		;JUMP IF NO INPUT
		CALL	SPAIN1		;GET INPUT CHARACTER
		CMP	AL,ACK		;END OF WAITING ON RECEIVED 'ACK'
		JNZ	SP3_2
		MOV	AH,LPT_ACT
		NOT	AH
		AND	WAIT_FL,AH	;IF SO, REPLACE WAITING FLAG FOR THIS
					;PRINTER
SP3_2:
		MOV	AH,WAIT_FL
		NOT	AH
		TEST	AH,LPT_ACT	;FOR PRINTER IN WAIT POSITION
		JZ	SP3_4		;RETURN ZR FLAG ON
		MOV	DX,DI
		ADD	DX,RSTAT
		IN	AL,DX	
		AND	AL,TXRDY	;TEST FOR TRANSMITTER READY
SP3_4:		RET			;ZR=NOT READY, NZ=READY
PAGE
;
; OUTPUT TO PARALLEL PRINTER W/O PROTOCOL
;
PWRITE:	
		CALL	PPST0		;CHECK INTERFACE STATUS
		JNZ	PWRIT1		;IF OKAY SEND CHARACTER
		CALL	KBD_CC		;ELSE CHECK KEYBOARD FOR CONTROL C (03hex)
		JZ	PWRIT2		;CONTROL C WAS PRESSED - RETURN
		JMP	PWRITE		; IF NOT  STILL WAIT FOR STATUS OKAY
PWRIT1:
        	XCHG	AL,CL		;CHARACTER TO AL
		MOV	DX,DI
		ADD	DX,PBDA
		OUT 	DX,AL		;OUTPUT THE CHARACTER IN AL
PWRIT2:
		RET
;
; GET PRINTER STATUS (CENTRONICS PARALLEL) W/O ANY PROTOCOL
;
PPST0:	
		MOV	DX,DI
		ADD	DX,PBSTA
		IN	AL,DX		;GET PRINTER STATUS
		AND	AL,BUSY OR POBF 
		JZ	P1STATX		;JUMP IF PRINTER ACCEPTS A BYTE
		XOR	AL,AL		;ZERO INDICATES PRINTER NOT READY
		RET

P1STATX:	OR	AL,-1		;NOT ZERO INDICATES PRINTER READY
		RET

;
PAGE
;
; GET CHARACTER FROM INTERFACE
;
SPAIN:		CALL	SPAIST		;CHECK INPUT STATUS
		JZ	SPAIN		;WAIT IF ZERO
SPAIN1:
		MOV	DX,DI
		ADD	DX,RDATA
  		IN	AL,DX		;GET CHARACTER
		RET
;
; OUTPUT CHARACTER 
;
WRITE:
		MOV	BP,OFFSET SST_DISP_TBL
		CALL	SIF_DISP	;CHECK OUTPUT STATUS
		JNZ	WRIT1		;IF OK SEND CHARACTER
		CALL	KBD_CC		;ELSE LOOK FOR KBD INPUT (03hex)
		JZ	WRITE_RET	;CONTROL C WAS PRESSED
		JMP	WRITE		;IF NOT STILL WAIT FOR IT OR FOR STATUS OK
WRIT1:
		XCHG	AL,CL		;CHARACTER TO AL
		MOV	DX,DI
		ADD	DX,WDATA
		OUT 	DX,AL		;OUTPUT THE CHARACTER
WRITE_RET:	RET			;ZR = PRINTER NOT READY
					;NZ = PRINTER HAS WRITTEN CHARACTER
;
;
WRITE_ACK:
		MOV	DX,DI 
		ADD	DX,RSTAT
		IN	AL,DX		;GET STATUS
		TEST	AL,DCD		;FOR CHECKING CARRIER
		JNZ	WRITE_A3	;IF OK GO ON
		MOV	DX,DI
		ADD 	DX,WDATA	;ELSE SEND ETX
		MOV	AL,ETX	
		OUT	DX,AL
		MOV	AL,LPT_ACT
		OR	WAIT_FL,AL	;SET FLAG FOR WAITING
WRITE_A3:
		CALL	SPST3		;CHECK OUTPUT STATUS
		JNZ	WR_A0		;WAIT IF ZERO
		CALL	KBD_CC		;FOR KBD INPUT CONTROL C = 03 hex
		JZ	WR_A2		;IF PRESSED STOP AND RETURN
		JMP	WRITE_ACK	;ELSE STILL WAIT
WR_A0:
		XCHG	AL,CL		;CHARACTER TO AL
		CMP	AL,ETX		;ON END OF TEXT MARK SET PRINTER TO WAIT
		JNZ	WR_A1
		MOV	AH,LPT_ACT
		OR	WAIT_FL,AH	;SET WAIT FLAG THEREFORE
WR_A1:
                MOV	DX,DI
		ADD	DX,WDATA
		OUT 	DX,AL		;OUTPUT THE CHARACTER
WR_A2:		RET			;ZR = PRINTER NOT READY
					;NZ = PRINTER HAS WRITTEN CHARACTER
;
;
;
OUT_STAT:
	MOV	BP,OFFSET SST_DISP_TBL	;CALL STATUS ROUTINE DEPENDING
	CALL	SIF_DISP		;ON PROTOCOL USED
	JZ	OUT_ST1			;RET : ZR=NOT READY , NZ=READY
	JMP	EXIT
OUT_ST1:
	JMP	BUS_EXIT
PAGE
KBD_CC:
	IN	AL,KBD_STAT		; READ KEYBOARD STATUS
	TEST	AL,01H			; FOR DATA READY
	JZ	KBD_CRET
	IN	AL,KBD_DATA		; READ DATA
	CMP	AL,CONTROL_C		; TEST FOR ^C
	JE	KBD_CR			; RETURN ZR SET
	CALL	KBD_BUFF_IN		; ELSE SAVE CHARACTER IN KBD INPUT BUFFER
KBD_CRET:
	OR	DI,DI
KBD_CR:	
	RET
PAGE
BUS_EXIT:                       ;Device busy exit.
        MOV     AH,00000011B    ;Set busy and done bits.
        JMP     SHORT EXIT1


;
;  Common error processing routine.
;   AL contains actual error code.
;
;   Error # 0 = Write Protect violation.
;           1 = Unkown unit.
;           2 = Drive not ready.
;           3 = Unknown command in I/O packet.
;           4 = CRC error.
;           5 = Bad drive request structure length.
;           6 = Seek error.
;           7 = Unknown media discovered.
;           8 = Sector not found.
;           9 = Printer out of paper.
;          10 = Write fault.
;          11 = Read fault.
;          12 = General failure.
ERROR_1:
	CMP	ES:[BX.CMD],0	;FOR INIT COMMAND RETURN AN OKAY
	JE	EXIT
	MOV	AL,1		;UNKNOWN UNIT
	JMP	SHORT ERR_EXIT
ERROR_2:
	MOV	AL,2		;DEVICE not ready.
	JMP	SHORT ERR_EXIT
ERROR_3:
	MOV	AL,3		;Unknown command in I/O packet.
	JMP	SHORT ERR_EXIT


ERR_EXIT:
        MOV     AH,10000001B    ;Set error and done bits.
        STC                     ;Set carry bit also.
        JMP     SHORT EXIT1     ;Quick way out.

EXITP   PROC    FAR             ;Normal exit for device drivers.

EXIT:   
	MOV     AH,00000001B    ;Set done bit for MSDOS.
EXIT1:  
        MOV     ES:[BX.STATUS],AX  ;Save operation complete and status.

        POP     DI
        POP     SI
	POP	DS
	POP	AX
	POP	BX
	POP	ES
	POP	BP
	POP	DX
        RET                             ;RESTORE REGS AND RETURN
EXITP   ENDP
;
;
;
;
CSEG ENDS
END
